<?php
$medidaTicket = 280;


$empresa = PCO_EjecutarSQL("
            SELECT razon_social, nit, telefono, direccion
            FROM app_empresa
            WHERE id = 1
        ")->fetch();

$venta = PCO_EjecutarSQL("
            SELECT date_format(fecha, '%d-%m-%Y %H:%i:%s') fecha, total, iva, forma_pago, devuelta, dinero_entregado, id_cliente, usuario
            FROM app_ventas
            WHERE id = '$id'
        ")->fetch();

$cliente = PCO_EjecutarSQL("
            SELECT *
            FROM app_clientes
            WHERE id = '" . $venta["id_cliente"] . "'
        ")->fetch();

$vendedor = PCO_EjecutarSQL("
            SELECT nombre
            FROM core_usuario
            WHERE login = '" . $venta['usuario'] . "'
        ")->fetchColumn();

$productos = PCO_EjecutarSQL("
            SELECT vd.cantidad, p.nombre as descripcion, vd.precio, date_format(fecha, '%d-%m-%Y') 
            FROM app_ventas_detalle vd, app_productos p
            WHERE vd.id_producto = p.id AND vd.id_venta = '$id'
        ")->fetchAll();
?>
<!DOCTYPE html>
<html>

<head>

    <style>
        * {
            font-size: 15px;
            font-family: 'DejaVu Sans', serif;
        }

        h1 {
            font-size: 18px;
        }

        

        .ticket {
            margin: 0.5px;
        }

        td,
        th,
        tr,
        table {
            border-top: 1px solid black;
            border-collapse: collapse;
            margin: 0 auto;
            font-size: 15px;
        }

        td.precio {
            text-align: right;
            font-size: 11px;
        }

        td.cantidad {
            font-size: 12px;
        }

        td.producto {
            text-align: center;
        }

        th {
            text-align: center;
        }


        .centrado {
            text-align: center;
            align-content: center;
        }

        .ticket {
            width: <?php echo $medidaTicket ?>px;
            max-width: <?php echo $medidaTicket ?>px;
        }

        img {
            max-width: inherit;
            width: inherit;
        }

        * {
            margin: 0;
            padding: 0;
        }

        .ticket {
            margin: 0;
            padding: 0;
        }

        body {
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="ticket centrado">
        <h1><?php echo $empresa["razon_social"] ?></h1>
        <h2>NIT: <?php echo $empresa["nit"] ?></h2>
        <h2>Teléfono: <?php echo $empresa["telefono"] ?></h2>
        <h2>Direccion: <?php echo $empresa["direccion"] ?></h2>
        <h2>Correo: </h2>
        <h2>--------------------------------------------</h2>
        <h1 align="center">Ticket de venta #<?php echo $id ?></h1>
        
        <h2>Fecha: <?php echo $venta["fecha"] ?></h2>
        <h2>Cliente: <?php echo $cliente["nombre_completo"] ?></h2>
        <h2>telefono: <?php echo $cliente["telefono"] ?></h2>
        <h2>CC / NIT: <?php echo $cliente["numero_documento"] ?></h2>
        <h2>Dirección: <?php echo $cliente["direccion"] ?></h2>
        <h2>Vendedor: <?php echo $vendedor ?></h2>
        <h2>Caja N° 1</h2>
        <br>

        <table>
            <thead>
                <tr class="centrado">
                    <th class="cantidad">CANT</th>
                    <th class="producto">PRODUCTO</th>
                    <th class="precio">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;TOTAL</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $total = 0;
                foreach ($productos as $producto) {
                    $total += $producto["cantidad"] * $producto["precio"];
                ?>
                    <tr>
                        <td class="cantidad"><?php echo number_format($producto["cantidad"], 2) ?></td>
                        <td class="producto"><?php echo $producto["descripcion"] ?></td>
                        <td class="precio">$<?php echo number_format($producto["precio"], 2) ?></td>
                    </tr>
                <?php } ?>
            </tbody>
</table>
<BR>
<table style="border-top: 0px !important;">
    <tr style="border-top: 0px !important;">
        <td style="border-top: 0px !important;">
            <strong>SUBTOTAL</strong>
        </td>
        <td style="border-top: 0px !important;">
            <strong>$<?php echo number_format($venta["total"] - $venta["iva"], 2) ?></strong>
        </td>
    </tr>
    <tr style="border-top: 0px !important;">
        <td style="border-top: 0px !important;">
            <strong>TOTAL A PAGAR</strong>
        </td>
        <td style="border-top: 0px !important;">
            <strong>$<?php echo number_format($venta["total"] - $venta["iva"], 2) ?></strong>
        </td>
    </tr>
    <tr style="border-top: 0px !important;">
        <td style="border-top: 0px !important;">
            <strong>VALOR PAGADO</strong>
        </td>
        <td style="border-top: 0px !important;">
            <strong>$<?php echo $venta["dinero_entregado"] ?></strong>
        </td>
    </tr>
    <tr style="border-top: 0px !important;">
        <td style="border-top: 0px !important;">
            <strong>FORMA DE PAGO</strong>
        </td>
        <td style="border-top: 0px !important;">
            <strong><?php echo $venta["forma_pago"] ?></strong>
        </td>
    </tr>
    <tr style="border-top: 0px !important;">
        <td style="border-top: 0px !important;">
            <strong>CAMBIO</strong>
        </td>
        <td style="border-top: 0px !important;">
            <strong>$<?php echo $venta["devuelta"] ?></strong>
        </td>
    </tr>
</table>
        <br>
        <p class="centrado">¡GRACIAS POR SU COMPRA! </P>
        <br>
        <P>Elaborado por www.cloudecoway.com</p>
        <P>Tel: 3137010627</p>

    </div>
</body>

</html>