// This file is part of the bwip-js project available at:
//
// 	  http://metafloor.github.io/bwip-js
//
// Copyright (c) 2011-2023 Mark Warren
//
// This file contains code automatically generated from:
// Barcode Writer in Pure PostScript - Version 2023-04-03
// Copyright (c) 2004-2023 Terry Burton
//
// The MIT License
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
"use strict";

(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define([], factory);
    } else if (typeof module === 'object' && module.exports) {
        module.exports = factory();
    } else {
        root.bwipjs = factory();
	}
}(typeof self !== 'undefined' ? self : this, function () {
var $$=null;var $j=0;var $k=[];var $0={};function $a(a){if(!arguments.length){for(var i=$j-1;i>=0&&$k[i]!==Infinity;i--);if(i<0){throw new Error("array-marker-not-found")}a=$k.splice(i+1,$j-1-i);$j=i}else if(!(a instanceof Array)){a=new Array(+arguments[0]);for(var i=0,l=a.length;i<l;i++){a[i]=null}}a.b=a;a.o=0;return a}function $d(){for(var mark=$j-1;mark>=0&&$k[mark]!==Infinity;mark-=2){if($k[mark-1]===Infinity){throw new Error("dict-malformed-stack")}}if(mark<0){throw"dict-marker-not-found"}var d=new Map;for(var i=mark+1;i<$j;i+=2){var k=$k[i];var t=typeof k;if(t=="number"||t=="string"){d.set(k,$k[i+1])}else if(k instanceof Uint8Array){d.set($z(k),$k[i+1])}else{throw"dict-not-a-valid-key("+k+")"}}$j=mark;return d}function $s(v){var t=typeof v;if(t==="number"){return new Uint8Array(v)}if(t!=="string"){v=""+v}var s=new Uint8Array(v.length);for(var i=0;i<v.length;i++){s[i]=v.charCodeAt(i)}return s}function $r(n,c){if($j<n){throw"roll: --stack-underflow--"}if(!c){return}if(c<0){var t=$k.splice($j-n,-c)}else{var t=$k.splice($j-n,n-c)}$k.splice.apply($k,[$j-t.length,0].concat(t))}function $z(s){if(s instanceof Uint8Array){return String.fromCharCode.apply(null,s)}return""+s}function $Z(dst,src){if(typeof dst==="string"){dst=$s(dst)}if(src instanceof Uint8Array){for(var i=0,l=src.length;i<l;i++){dst[i]=src[i]}}else{for(var i=0,l=src.length;i<l;i++){dst[i]=src.charCodeAt(i)}}return src.length<dst.length?dst.subarray(0,src.length):dst}function $A(dst,src){for(var i=0,l=src.length;i<l;i++){dst[i]=src[i]}dst.length=src.length;return dst}function $c(s,v){var t=typeof v;if(t=="number"||t=="boolean"||v===null){v=""+v}else if(t!=="string"){v="--nostringval--"}for(var i=0,l=v.length;i<l;i++){s[i]=v.charCodeAt(i)}$k[$j++]=i<s.length?s.subarray(0,i):s}function $i(s){if(s instanceof Uint8Array){return String.fromCharCode.apply(null,s).replace(/\0+$/,"")|0}return""+s|0}function $R(s,n,r){return $Z(s,(~~n).toString(r).toUpperCase())}function $x(s){s=$z(s);var m=/^\s*<((?:[0-9a-fA-F]{2})+)>\s*$/.exec(s);if(!m){throw"cvx: not a <HH> hex string literal"}var h=m[1];var l=h.length>>1;var u=new Uint8Array(l);for(var i=0,j=0;i<l;i++){var c0=h.charCodeAt(j++);var c1=h.charCodeAt(j++);u[i]=((c0<58?c0-48:(c0&15)+9)<<4)+(c1<58?c1-48:(c1&15)+9)}return u}function $g(s,k){if(s instanceof Uint8Array){return s[k]}if(typeof s==="string"){return s.charCodeAt(k)}if(s instanceof Array){return s.b[s.o+k]}if(k instanceof Uint8Array){return s.get($z(k))}return s.get(k)}function $p(d,k,v){if(d instanceof Uint8Array){d[k]=v}else if(d instanceof Array){d.b[d.o+k]=v}else if(typeof d=="object"){if(k instanceof Uint8Array){d.set($z(k),v)}else{d.set(k,v)}}else{throw"put-not-writable-"+typeof d}}function $G(s,o,l){if(s instanceof Uint8Array){return s.subarray(o,o+l)}if(s instanceof Array){var a=new Array(l);a.b=s.b;a.o=s.o+o;return a}return s.substr(o,l)}function $P(d,o,s){if(d instanceof Uint8Array){if(typeof s=="string"){for(var i=0,l=s.length;i<l;i++){d[o+i]=s.charCodeAt(i)}}else{for(var i=s.length-1;i>=0;i--){d[o+i]=s[i]}}}else if(d instanceof Array){var darr=d.b;var doff=o+d.o;var sarr=s.b;var soff=s.o;for(var i=0,l=s.length;i<l;i++){darr[doff+i]=sarr[soff+i]}}else{throw"putinterval-not-writable-"+typeof d}}function $t(v){if(v==null){return"nulltype"}var t=typeof v;if(t=="number"){return v%1?"realtype":"integertype"}if(t=="boolean"){return"booleantype"}if(t=="string"||v instanceof Uint8Array){return"stringtype"}if(t=="function"){return"operatortype"}if(v instanceof Array){return"arraytype"}return"dicttype"}function $ax(str,seek){if(!(str instanceof Uint8Array)){str=$s(str)}var i=0,ls=str.length,lk=seek.length;if(lk==1){var cd=seek instanceof Uint8Array?seek[0]:seek.charCodeAt(0);i=str[0]==cd?1:ls}else if(seek.length<=ls){if(!(seek instanceof Uint8Array)){seek=$s(seek)}for(;i<lk&&str[i]==seek[i];i++);}if(i==lk){$k[$j++]=str.subarray(lk);$k[$j++]=str.subarray(0,lk);$k[$j++]=true}else{$k[$j++]=str;$k[$j++]=false}}function $X(str,seek){if(!(str instanceof Uint8Array)){str=$s(str)}var ls=str.length;if(seek.length==1){var lk=1;var cd=seek instanceof Uint8Array?seek[0]:seek.charCodeAt(0);for(var i=0;i<ls&&str[i]!=cd;i++);}else{if(!(seek instanceof Uint8Array)){seek=$s(seek)}var lk=seek.length;var cd=seek[0];for(var i=0;i<ls&&str[i]!=cd;i++);while(i<ls){for(var j=1;j<lk&&str[i+j]===seek[j];j++);if(j===lk){break}for(i++;i<ls&&str[i]!=cd;i++);}}if(i<ls){$k[$j++]=str.subarray(i+lk);$k[$j++]=str.subarray(i,i+lk);$k[$j++]=str.subarray(0,i);$k[$j++]=true}else{$k[$j++]=str;$k[$j++]=false}}function $F(o,cb){if(o instanceof Uint8Array){for(var i=0,l=o.length;i<l;i++){$k[$j++]=o[i];if(cb&&cb())break}}else if(o instanceof Array){for(var a=o.b,i=o.o,l=o.o+o.length;i<l;i++){$k[$j++]=a[i];if(cb&&cb())break}}else if(typeof o==="string"){for(var i=0,l=o.length;i<l;i++){$k[$j++]=o.charCodeAt(i);if(cb&&cb())break}}else if(o instanceof Map){for(var keys=o.keys(),i=0,l=o.size;i<l;i++){var id=keys.next().value;$k[$j++]=id;$k[$j++]=o.get(id);if(cb&&cb())break}}else{for(var id in o){$k[$j++]=id;$k[$j++]=o[id];if(cb&&cb())break}}}function $l(){while($j>0&&$k[--$j]!==Infinity);}function $m(){for(var i=$j-1;i>=0&&$k[i]!==Infinity;i--);return $j-i-1}function $q(a){for(var i=0,l=a.length,b=a.b,o=a.o;i<l;i++){$k[$j++]=b[o+i]}}function $as(a){for(var i=0,l=a.length,b=a.b,o=a.o+l-1;i<l;i++){b[o-i]=$k[--$j]}$k[$j++]=a}function $eq(a,b){if(typeof a==="string"&&typeof b==="string"){return a==b}if(a instanceof Uint8Array&&b instanceof Uint8Array){if(a.length!=b.length){return false}for(var i=0,l=a.length;i<l;i++){if(a[i]!=b[i]){return false}}return true}if(a instanceof Uint8Array&&typeof b==="string"||b instanceof Uint8Array&&typeof a==="string"){if(a instanceof Uint8Array){a=$z(a)}else{b=$z(b)}return a==b}return a==b}function $ne(a,b){return!$eq(a,b)}function $lt(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a<b}function $le(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a<=b}function $gt(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a>b}function $ge(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a>=b}function $an(a,b){return typeof a==="boolean"?a&&b:a&b}function $or(a,b){return typeof a==="boolean"?a||b:a|b}function $xo(a,b){return typeof a==="boolean"?!a&&b||a&&!b:a^b}function $nt(a){return typeof a=="boolean"?!a:~a}var $f=function(fa){return function(v){return Number.isInteger(v)?v:(fa[0]=v,fa[0])}}(new Float32Array(1));function bwipp_raiseerror(){var info=$k[--$j];var name=$k[--$j];throw new Error($z(name)+": "+$z(info))}function bwipp_processoptions(){var dict=$k[--$j];var opts=$k[$j-1];var map=opts instanceof Map;for(var id in dict){var val;if(map){if(!opts.has(id)){continue}val=opts.get(id)}else{if(!opts.hasOwnProperty(id)){continue}val=opts[id]}var def=dict[id];var typ=typeof def;if(def==null||typ=="number"){if(!isFinite(+val)){throw new Error("bwipp.invalidOptionType: "+id+": not a realtype: "+val)}if(typeof val=="string"){val=+val;map?opts.set(id,val):opts[id]=val}}else if(typ=="boolean"){if(val!==true&&val!==false){if(val==null||(val|0)===val){val=!!val}else if(val=="true"){val=true}else if(val=="false"){val=false}else{throw new Error("bwipp.invalidOptionType: "+id+": not a booleantype: "+val)}map?opts.set(id,val):opts[id]=val}}else if(typ=="string"||def instanceof Uint8Array){if(typeof val=="number"){val=""+val;map?opts.set(id,val):opts[id]=val}else if(typeof val!="string"&&!(val instanceof Uint8Array)){throw new Error("bwipp.invalidOptionType: "+id+": not a stringtype: "+val)}}dict[id]=val}}function $stack(){console.log("[[[");for(var i=$j-1;i>=0;i--){console.log(tostring($k[i]))}console.log("]]]");function tostring(v){if(v===null){return"null"}else if(v===undefined){return"<undefined>"}else if(v instanceof Array){var s="<array,"+v.o+","+v.length+">[";for(var j=v.o,a=v.b,l=v.length+v.o;j<l;j++){s+=(j==v.o?"":",")+tostring(a[j])}return s+"]"}else if(v instanceof Uint8Array){return"("+$z[v]+")"}else if(v instanceof Map){var s="<<";for(var elt of v){s+=(s.length==2?"":",")+elt[0]+":"+tostring(elt[1])}return s+">>"}else if(typeof v==="object"){var s="<<";for(var id in v){s+=(s.length==2?"":",")+id+":"+tostring(v[id])}return s+">>"}else if(typeof v==="string"){return'"'+v+'"'}else{return""+v}}}function bwipp_parseinput(){var $1=Object.create(bwipp_parseinput.$ctx||(bwipp_parseinput.$ctx={}));$1.fncvals=$k[--$j];$1.barcode=$k[--$j];var _2="parse";$1[_2]=$g($1.fncvals,_2);delete $1.fncvals[_2];var _6="parsefnc";$1[_6]=$g($1.fncvals,_6);delete $1.fncvals[_6];var _A="parseonly";var _C=$g($1.fncvals,_A)!==undefined;$1[_A]=_C;delete $1.fncvals[_A];var _E="eci";var _G=$g($1.fncvals,_E)!==undefined;$1[_E]=_G;delete $1.fncvals[_E];if(!bwipp_parseinput.__225__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;var _I=$a(["NUL","SOH","STX","ETX","EOT","ENQ","ACK","BEL","BS","TAB","LF","VT","FF","CR","","","DLE","DC1","DC2","DC3","DC4","NAK","SYN","ETB","CAN","EM","SUB","ESC","FS","GS","RS","US"]);$k[$j++]=0;for(var _J=0,_K=_I.length;_J<_K;_J++){var _M=$k[--$j];$k[$j++]=$g(_I,_J);$k[$j++]=_M;$k[$j++]=$f(_M+1)}$j--;$ctx.ctrl=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_parseinput.$ctx[id]=$ctx[id]);bwipp_parseinput.__225__=1})()}$1.msg=$a($1.barcode.length);$1.j=0;$k[$j++]=$1.barcode;for(;;){$X($k[--$j],"^");var _T=$k[--$j];var _U=$k[--$j];$k[$j++]=_T;$k[$j++]=_U.length;$k[$j++]=$1.msg;$k[$j++]=$1.j;$k[$j++]=_U;$k[$j++]=Infinity;var _X=$k[--$j];var _Y=$k[--$j];$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$1.j=$f($k[--$j]+$1.j);if($k[--$j]){$j--;for(var _f=0,_g=1;_f<_g;_f++){if($an($nt($1.parse),$nt($1.parsefnc))){$p($1.msg,$1.j,94);$1.j=$f($1.j+1);break}$p($1.msg,$1.j,94);$1.j=$f($1.j+1);if($1.parse){var _q=$k[--$j];$k[$j++]=_q;if(_q.length>=3){var _r=$k[--$j];var _s=$G(_r,0,3);var _t=$1.ctrl;var _u=$g(_t,_s)!==undefined;$k[$j++]=_r;$k[$j++]=_t;$k[$j++]=_s;if(_u){$1.j=$f($1.j-1);var _w=$k[--$j];$p($1.msg,$1.j,$g($k[--$j],_w));$1.j=$f($1.j+1);var _12=$k[--$j];$k[$j++]=$G(_12,3,_12.length-3);break}else{$j-=2}}var _14=$k[--$j];$k[$j++]=_14;if(_14.length>=2){var _15=$k[--$j];var _16=$G(_15,0,2);var _17=$1.ctrl;var _18=$g(_17,_16)!==undefined;$k[$j++]=_15;$k[$j++]=_17;$k[$j++]=_16;if(_18){$1.j=$f($1.j-1);var _1A=$k[--$j];$p($1.msg,$1.j,$g($k[--$j],_1A));$1.j=$f($1.j+1);var _1G=$k[--$j];$k[$j++]=$G(_1G,2,_1G.length-2);break}else{$j-=2}}var _1I=$k[--$j];$k[$j++]=_1I;if(_1I.length>=3){var _1J=$k[--$j];var _1K=$G(_1J,0,3);$k[$j++]=_1J;$k[$j++]=true;for(var _1L=0,_1M=_1K.length;_1L<_1M;_1L++){var _1N=$g(_1K,_1L);if(_1N<48||_1N>57){$j--;$k[$j++]=false}}if($k[--$j]){var _1P=$k[--$j];var _1R=$i($G(_1P,0,3));$k[$j++]=_1P;$k[$j++]=_1R;if(_1R>255){$j-=2;$k[$j++]="bwipp.invalidOrdinal#282";$k[$j++]="Ordinal must be 000 to 255";bwipp_raiseerror()}$1.j=$f($1.j-1);$p($1.msg,$1.j,$k[--$j]);$1.j=$f($1.j+1);var _1X=$k[--$j];$k[$j++]=$G(_1X,3,_1X.length-3)}}}if($or($1.parseonly,$nt($1.parsefnc))||$g($1.msg,$f($1.j-1))!=94){break}$1.j=$f($1.j-1);var _1f=$k[--$j];$k[$j++]=_1f;if(_1f.length<3){$j--;$k[$j++]="bwipp.truncatedFNC#301";$k[$j++]="Function character truncated";bwipp_raiseerror()}var _1g=$k[--$j];$k[$j++]=_1g;if($g(_1g,0)==94){$p($1.msg,$1.j,94);$1.j=$f($1.j+1);var _1l=$k[--$j];$k[$j++]=$G(_1l,1,_1l.length-1);break}var _1n=$k[--$j];$k[$j++]=_1n;if($eq($G(_1n,0,3),"ECI")&&$1.eci){var _1q=$k[--$j];$k[$j++]=_1q;if(_1q.length<9){$j--;$k[$j++]="bwipp.truncatedECI#312";$k[$j++]="ECI truncated";bwipp_raiseerror()}var _1r=$k[--$j];var _1s=$G(_1r,3,6);$k[$j++]=_1r;$k[$j++]=_1s;for(var _1t=0,_1u=_1s.length;_1t<_1u;_1t++){var _1v=$g(_1s,_1t);if(_1v<48||_1v>57){$j-=2;$k[$j++]="bwipp.invalidECI#318";$k[$j++]="ECI must be 000000 to 999999";bwipp_raiseerror()}}var _1w=$k[--$j];$k[$j++]=0;$F(_1w,function(){var _1x=$k[--$j];var _1y=$k[--$j];$k[$j++]=$f(_1y-$f(_1x-48))*10});$p($1.msg,$1.j,~~($k[--$j]/10)-1e6);$1.j=$f($1.j+1);var _23=$k[--$j];$k[$j++]=$G(_23,9,_23.length-9);break}var _25=$k[--$j];$k[$j++]=_25;if(_25.length<4){$j--;$k[$j++]="bwipp.truncatedFNC#329";$k[$j++]="Function character truncated";bwipp_raiseerror()}var _26=$k[--$j];var _27=$G(_26,0,4);var _29=$g($1.fncvals,_27)!==undefined;$k[$j++]=_26;$k[$j++]=_27;if(!_29){var _2A=$k[--$j];var _2B=$s(_2A.length+28);$P(_2B,28,_2A);$P(_2B,0,"Unknown function character: ");var _2C=$k[--$j];$k[$j++]=_2B;$k[$j++]=_2C;$j--;var _2D=$k[--$j];$k[$j++]="bwipp.unknownFNC#335";$k[$j++]=_2D;bwipp_raiseerror()}$p($1.msg,$1.j,$g($1.fncvals,$k[--$j]));$1.j=$f($1.j+1);var _2K=$k[--$j];$k[$j++]=$G(_2K,4,_2K.length-4);break}}else{break}}if($nt($1.parseonly)){$k[$j++]=$G($1.msg,0,$1.j)}else{$k[$j++]=$s($1.j);for(var _2U=0,_2T=$f($1.j-1);_2U<=_2T;_2U+=1){var _2V=$k[--$j];$p(_2V,_2U,$g($1.msg,_2U));$k[$j++]=_2V}}}function bwipp_gs1process(){var $1=Object.create(bwipp_gs1process.$ctx||(bwipp_gs1process.$ctx={}));if(!bwipp_gs1process.__2289__){(function(){var $ctx=Object.create($1);var _1=new Map([["cset","N"],["min",18],["max",18],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _2=$a([_1]);var _3=$a([]);var _4=new Map([["parts",_2],["dlpkey",_3]]);var _5=$a(["lintcsum","lintkey"]);var _6=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",_5]]);var _7=$a([_6]);var _8=$a(["02","255","37"]);var _9=$a(["22","10","21"]);var _A=$a(["235"]);var _B=$a([_9,_A]);var _C=new Map([["parts",_7],["ex",_8],["dlpkey",_B]]);var _D=$a(["lintcsum","lintkey"]);var _E=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",_D]]);var _F=$a([_E]);var _G=$a(["37"]);var _H=$a([_G]);var _I=new Map([["parts",_F],["req",_H]]);var _K=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _O=new Map([["parts",$a([_K])],["req",$a([$a(["01","02","8006","8026"])])]]);var _Q=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _U=new Map([["parts",$a([_Q])],["req",$a([$a(["01","02","8006","8026"])])]]);var _W=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _a=new Map([["parts",$a([_W])],["req",$a([$a(["8020"])])]]);var _c=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _g=new Map([["parts",$a([_c])],["req",$a([$a(["01","02","8006","8026"])])]]);var _i=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _m=new Map([["parts",$a([_i])],["req",$a([$a(["01","02","255","8006","8026"])])]]);var _o=new Map([["cset","N"],["min",2],["max",2],["opt",false],["linters",$a([])]]);var _s=new Map([["parts",$a([_o])],["req",$a([$a(["01","02","8006","8026"])])]]);var _u=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _z=new Map([["parts",$a([_u])],["ex",$a(["235"])],["req",$a([$a(["01","8006"])])]]);var _11=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _15=new Map([["parts",$a([_11])],["req",$a([$a(["01"])])]]);var _17=new Map([["cset","X"],["min",1],["max",28],["opt",false],["linters",$a([])]]);var _1B=new Map([["parts",$a([_17])],["req",$a([$a(["01"])])]]);var _1D=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _1H=new Map([["parts",$a([_1D])],["req",$a([$a(["01","02","8006","8026"])])]]);var _1J=new Map([["cset","N"],["min",1],["max",6],["opt",false],["linters",$a([])]]);var _1N=new Map([["parts",$a([_1J])],["req",$a([$a(["01","02","8006","8026"])])]]);var _1P=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _1T=new Map([["parts",$a([_1P])],["req",$a([$a(["01"])])]]);var _1V=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _1a=new Map([["parts",$a([_1V])],["req",$a([$a(["01","8006"]),$a(["21"])])]]);var _1c=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _1g=new Map([["parts",$a([_1c])],["req",$a([$a(["01","8006"])])]]);var _1i=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _1k=new Map([["cset","X"],["min",1],["max",17],["opt",true],["linters",$a([])]]);var _1n=new Map([["parts",$a([_1i,_1k])],["dlpkey",$a([])]]);var _1p=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _1t=new Map([["parts",$a([_1p])],["req",$a([$a(["414"])])]]);var _1v=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _1x=new Map([["cset","N"],["min",1],["max",12],["opt",true],["linters",$a([])]]);var _21=new Map([["parts",$a([_1v,_1x])],["ex",$a(["01","02","415","8006","8020","8026"])],["dlpkey",$a([])]]);var _22=$a([]);var _23=new Map([["cset","N"],["min",1],["max",8],["opt",false],["linters",_22]]);var _27=new Map([["parts",$a([_23])],["req",$a([$a(["01","02"])])]]);var _29=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2E=new Map([["parts",$a([_29])],["ex",$a(["310n"])],["req",$a([$a(["01","02"])])]]);var _2G=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2L=new Map([["parts",$a([_2G])],["ex",$a(["311n"])],["req",$a([$a(["01","02"])])]]);var _2N=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2S=new Map([["parts",$a([_2N])],["ex",$a(["312n"])],["req",$a([$a(["01","02"])])]]);var _2U=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2Z=new Map([["parts",$a([_2U])],["ex",$a(["313n"])],["req",$a([$a(["01","02"])])]]);var _2b=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2g=new Map([["parts",$a([_2b])],["ex",$a(["314n"])],["req",$a([$a(["01","02"])])]]);var _2i=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2n=new Map([["parts",$a([_2i])],["ex",$a(["315n"])],["req",$a([$a(["01","02"])])]]);var _2p=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _2u=new Map([["parts",$a([_2p])],["ex",$a(["316n"])],["req",$a([$a(["01","02"])])]]);var _2w=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _31=new Map([["parts",$a([_2w])],["ex",$a(["320n"])],["req",$a([$a(["01","02"])])]]);var _33=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _38=new Map([["parts",$a([_33])],["ex",$a(["321n"])],["req",$a([$a(["01","02"])])]]);var _3A=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3F=new Map([["parts",$a([_3A])],["ex",$a(["322n"])],["req",$a([$a(["01","02"])])]]);var _3H=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3M=new Map([["parts",$a([_3H])],["ex",$a(["323n"])],["req",$a([$a(["01","02"])])]]);var _3O=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3T=new Map([["parts",$a([_3O])],["ex",$a(["324n"])],["req",$a([$a(["01","02"])])]]);var _3V=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3a=new Map([["parts",$a([_3V])],["ex",$a(["325n"])],["req",$a([$a(["01","02"])])]]);var _3c=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3h=new Map([["parts",$a([_3c])],["ex",$a(["326n"])],["req",$a([$a(["01","02"])])]]);var _3j=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3o=new Map([["parts",$a([_3j])],["ex",$a(["327n"])],["req",$a([$a(["01","02"])])]]);var _3q=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3v=new Map([["parts",$a([_3q])],["ex",$a(["328n"])],["req",$a([$a(["01","02"])])]]);var _3x=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _42=new Map([["parts",$a([_3x])],["ex",$a(["329n"])],["req",$a([$a(["01","02"])])]]);var _44=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _49=new Map([["parts",$a([_44])],["ex",$a(["330n"])],["req",$a([$a(["00","01"])])]]);var _4B=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4G=new Map([["parts",$a([_4B])],["ex",$a(["331n"])],["req",$a([$a(["00","01"])])]]);var _4I=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4N=new Map([["parts",$a([_4I])],["ex",$a(["332n"])],["req",$a([$a(["00","01"])])]]);var _4P=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4U=new Map([["parts",$a([_4P])],["ex",$a(["333n"])],["req",$a([$a(["00","01"])])]]);var _4W=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4b=new Map([["parts",$a([_4W])],["ex",$a(["334n"])],["req",$a([$a(["00","01"])])]]);var _4d=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4i=new Map([["parts",$a([_4d])],["ex",$a(["335n"])],["req",$a([$a(["00","01"])])]]);var _4k=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4p=new Map([["parts",$a([_4k])],["ex",$a(["336n"])],["req",$a([$a(["00","01"])])]]);var _4r=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4w=new Map([["parts",$a([_4r])],["ex",$a(["337n"])],["req",$a([$a(["01"])])]]);var _4y=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _53=new Map([["parts",$a([_4y])],["ex",$a(["340n"])],["req",$a([$a(["00","01"])])]]);var _55=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5A=new Map([["parts",$a([_55])],["ex",$a(["341n"])],["req",$a([$a(["00","01"])])]]);var _5C=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5H=new Map([["parts",$a([_5C])],["ex",$a(["342n"])],["req",$a([$a(["00","01"])])]]);var _5J=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5O=new Map([["parts",$a([_5J])],["ex",$a(["343n"])],["req",$a([$a(["00","01"])])]]);var _5Q=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5V=new Map([["parts",$a([_5Q])],["ex",$a(["344n"])],["req",$a([$a(["00","01"])])]]);var _5X=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5c=new Map([["parts",$a([_5X])],["ex",$a(["345n"])],["req",$a([$a(["00","01"])])]]);var _5e=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5j=new Map([["parts",$a([_5e])],["ex",$a(["346n"])],["req",$a([$a(["00","01"])])]]);var _5l=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5q=new Map([["parts",$a([_5l])],["ex",$a(["347n"])],["req",$a([$a(["00","01"])])]]);var _5s=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5x=new Map([["parts",$a([_5s])],["ex",$a(["348n"])],["req",$a([$a(["00","01"])])]]);var _5z=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _64=new Map([["parts",$a([_5z])],["ex",$a(["349n"])],["req",$a([$a(["00","01"])])]]);var _66=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6B=new Map([["parts",$a([_66])],["ex",$a(["350n"])],["req",$a([$a(["01","02"])])]]);var _6D=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6I=new Map([["parts",$a([_6D])],["ex",$a(["351n"])],["req",$a([$a(["01","02"])])]]);var _6K=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6P=new Map([["parts",$a([_6K])],["ex",$a(["352n"])],["req",$a([$a(["01","02"])])]]);var _6R=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6W=new Map([["parts",$a([_6R])],["ex",$a(["353n"])],["req",$a([$a(["00","01"])])]]);var _6Y=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6d=new Map([["parts",$a([_6Y])],["ex",$a(["354n"])],["req",$a([$a(["00","01"])])]]);var _6f=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6k=new Map([["parts",$a([_6f])],["ex",$a(["355n"])],["req",$a([$a(["00","01"])])]]);var _6m=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6r=new Map([["parts",$a([_6m])],["ex",$a(["356n"])],["req",$a([$a(["01","02"])])]]);var _6t=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6y=new Map([["parts",$a([_6t])],["ex",$a(["357n"])],["req",$a([$a(["01","02"])])]]);var _70=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _75=new Map([["parts",$a([_70])],["ex",$a(["360n"])],["req",$a([$a(["01","02"])])]]);var _77=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7C=new Map([["parts",$a([_77])],["ex",$a(["361n"])],["req",$a([$a(["01","02"])])]]);var _7E=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7J=new Map([["parts",$a([_7E])],["ex",$a(["362n"])],["req",$a([$a(["00","01"])])]]);var _7L=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7Q=new Map([["parts",$a([_7L])],["ex",$a(["363n"])],["req",$a([$a(["00","01"])])]]);var _7S=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7X=new Map([["parts",$a([_7S])],["ex",$a(["364n"])],["req",$a([$a(["01","02"])])]]);var _7Z=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7e=new Map([["parts",$a([_7Z])],["ex",$a(["365n"])],["req",$a([$a(["01","02"])])]]);var _7g=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7l=new Map([["parts",$a([_7g])],["ex",$a(["366n"])],["req",$a([$a(["01","02"])])]]);var _7n=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7s=new Map([["parts",$a([_7n])],["ex",$a(["367n"])],["req",$a([$a(["00","01"])])]]);var _7u=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7z=new Map([["parts",$a([_7u])],["ex",$a(["368n"])],["req",$a([$a(["00","01"])])]]);var _81=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _86=new Map([["parts",$a([_81])],["ex",$a(["369n"])],["req",$a([$a(["00","01"])])]]);var _88=new Map([["cset","N"],["min",1],["max",8],["opt",false],["linters",$a([])]]);var _8D=new Map([["parts",$a([_88])],["req",$a([$a(["00"]),$a(["02","8026"])])]]);var _8F=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _8K=new Map([["parts",$a([_8F])],["ex",$a(["390n","391n","394n","8111"])],["req",$a([$a(["255","8020"])])]]);var _8M=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso4217"])]]);var _8O=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _8T=new Map([["parts",$a([_8M,_8O])],["ex",$a(["391n"])],["req",$a([$a(["8020"])])]]);var _8V=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _8b=new Map([["parts",$a([_8V])],["ex",$a(["392n","393n"])],["req",$a([$a(["01"]),$a(["30","31nn","32nn","35nn","36nn"])])]]);var _8d=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso4217"])]]);var _8f=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _8k=new Map([["parts",$a([_8d,_8f])],["ex",$a(["393n"])],["req",$a([$a(["30","31nn","32nn","35nn","36nn"])])]]);var _8m=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a([])]]);var _8r=new Map([["parts",$a([_8m])],["ex",$a(["394n","8111"])],["req",$a([$a(["255"])])]]);var _8t=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8y=new Map([["parts",$a([_8t])],["ex",$a(["392n","393n","395n","8005"])],["req",$a([$a(["30","31nn","32nn","35nn","36nn"])])]]);var _90=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _92=new Map([["parts",$a([_90])]]);var _94=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a(["lintkey"])]]);var _97=new Map([["parts",$a([_94])],["dlpkey",$a([])]]);var _99=new Map([["cset","N"],["min",17],["max",17],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _9C=new Map([["parts",$a([_99])],["dlpkey",$a([])]]);var _9E=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _9I=new Map([["parts",$a([_9E])],["req",$a([$a(["00"])])]]);var _9K=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _9M=new Map([["parts",$a([_9K])]]);var _9O=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _9T=new Map([["parts",$a([_9O])],["dlpkey",$a([$a(["254"]),$a(["7040"])])]]);var _9V=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _9b=new Map([["parts",$a([_9V])],["req",$a([$a(["8020"])])],["dlpkey",$a([$a(["8020"])])]]);var _9d=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _9f=new Map([["parts",$a([_9d])]]);var _9h=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _9l=new Map([["parts",$a([_9h])],["dlpkey",$a([$a(["7040"])])]]);var _9n=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _9q=new Map([["parts",$a([_9n])],["ex",$a(["421"])]]);var _9s=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _9u=new Map([["cset","X"],["min",1],["max",9],["opt",false],["linters",$a([])]]);var _9x=new Map([["parts",$a([_9s,_9u])],["ex",$a(["4307"])]]);var _9z=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _A4=new Map([["parts",$a([_9z])],["ex",$a(["426"])],["req",$a([$a(["01","02","8006","8026"])])]]);var _A6=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a(["lintiso3166list"])]]);var _AB=new Map([["parts",$a([_A6])],["ex",$a(["426"])],["req",$a([$a(["01","02"])])]]);var _AD=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _AI=new Map([["parts",$a([_AD])],["ex",$a(["426"])],["req",$a([$a(["01","02"])])]]);var _AK=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a(["lintiso3166list"])]]);var _AP=new Map([["parts",$a([_AK])],["ex",$a(["426"])],["req",$a([$a(["01","02"])])]]);var _AR=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _AV=new Map([["parts",$a([_AR])],["req",$a([$a(["01","02"])])]]);var _AX=new Map([["cset","X"],["min",1],["max",3],["opt",false],["linters",$a([])]]);var _Ac=new Map([["parts",$a([_AX])],["req",$a([$a(["01","02"]),$a(["422"])])]]);var _Ae=new Map([["cset","X"],["min",1],["max",35],["opt",false],["linters",$a(["lintpcenc"])]]);var _Ai=new Map([["parts",$a([_Ae])],["req",$a([$a(["00"])])]]);var _Ak=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _Ao=new Map([["parts",$a([_Ak])],["req",$a([$a(["00"])])]]);var _Aq=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _Au=new Map([["parts",$a([_Aq])],["req",$a([$a(["4302"])])]]);var _Aw=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _B0=new Map([["parts",$a([_Aw])],["req",$a([$a(["00"])])]]);var _B2=new Map([["cset","X"],["min",2],["max",2],["opt",false],["linters",$a(["lintiso3166alpha2"])]]);var _B6=new Map([["parts",$a([_B2])],["req",$a([$a(["00"])])]]);var _B8=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _BC=new Map([["parts",$a([_B8])],["req",$a([$a(["00"])])]]);var _BE=new Map([["cset","N"],["min",20],["max",20],["opt",false],["linters",$a(["lintlatlong"])]]);var _BI=new Map([["parts",$a([_BE])],["req",$a([$a(["00"])])]]);var _BK=new Map([["cset","X"],["min",1],["max",35],["opt",false],["linters",$a(["lintpcenc"])]]);var _BO=new Map([["parts",$a([_BK])],["req",$a([$a(["00"])])]]);var _BQ=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _BU=new Map([["parts",$a([_BQ])],["req",$a([$a(["00"])])]]);var _BW=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _Ba=new Map([["parts",$a([_BW])],["req",$a([$a(["4312"])])]]);var _Bc=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _Bg=new Map([["parts",$a([_Bc])],["req",$a([$a(["00"])])]]);var _Bi=new Map([["cset","X"],["min",2],["max",2],["opt",false],["linters",$a(["lintiso3166alpha2"])]]);var _Bm=new Map([["parts",$a([_Bi])],["req",$a([$a(["00"])])]]);var _Bo=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Bs=new Map([["parts",$a([_Bo])],["req",$a([$a(["00"])])]]);var _Bu=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _By=new Map([["parts",$a([_Bu])],["req",$a([$a(["00"])])]]);var _C0=new Map([["cset","X"],["min",1],["max",35],["opt",false],["linters",$a(["lintpcenc"])]]);var _C4=new Map([["parts",$a([_C0])],["req",$a([$a(["00"])])]]);var _C6=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintyesno"])]]);var _CA=new Map([["parts",$a([_C6])],["req",$a([$a(["00"])])]]);var _CC=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _CE=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["linthhmm"])]]);var _CI=new Map([["parts",$a([_CC,_CE])],["req",$a([$a(["00"])])]]);var _CK=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _CO=new Map([["parts",$a([_CK])],["req",$a([$a(["00"])])]]);var _CQ=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a([])]]);var _CU=new Map([["parts",$a([_CQ])],["req",$a([$a(["01","02","8006","8026"])])]]);var _CW=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _Ca=new Map([["parts",$a([_CW])],["req",$a([$a(["01","02"])])]]);var _Cc=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _Ce=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["linthhmm"])]]);var _Ci=new Map([["parts",$a([_Cc,_Ce])],["req",$a([$a(["01","02"])])]]);var _Ck=new Map([["cset","N"],["min",1],["max",4],["opt",false],["linters",$a([])]]);var _Cp=new Map([["parts",$a([_Ck])],["req",$a([$a(["01"]),$a(["10"])])]]);var _Cr=new Map([["cset","X"],["min",1],["max",12],["opt",false],["linters",$a([])]]);var _Cv=new Map([["parts",$a([_Cr])],["req",$a([$a(["01","02"])])]]);var _Cx=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _D1=new Map([["parts",$a([_Cx])],["req",$a([$a(["01","02"])])]]);var _D3=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _D5=new Map([["cset","N"],["min",6],["max",6],["opt",true],["linters",$a(["lintyymmdd"])]]);var _D9=new Map([["parts",$a([_D3,_D5])],["req",$a([$a(["01","02"])])]]);var _DB=new Map([["cset","X"],["min",1],["max",3],["opt",false],["linters",$a([])]]);var _DF=new Map([["parts",$a([_DB])],["req",$a([$a(["01","02"])])]]);var _DH=new Map([["cset","X"],["min",1],["max",10],["opt",false],["linters",$a([])]]);var _DL=new Map([["parts",$a([_DH])],["req",$a([$a(["01","02"])])]]);var _DN=new Map([["cset","X"],["min",1],["max",2],["opt",false],["linters",$a([])]]);var _DR=new Map([["parts",$a([_DN])],["req",$a([$a(["01","02"])])]]);var _DT=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _DV=new Map([["cset","N"],["min",4],["max",4],["opt",true],["linters",$a(["linthhmm"])]]);var _DZ=new Map([["parts",$a([_DT,_DV])],["req",$a([$a(["01","02"])])]]);var _Db=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Dg=new Map([["parts",$a([_Db])],["req",$a([$a(["01","8006"]),$a(["416"])])]]);var _Di=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Dm=new Map([["parts",$a([_Di])],["req",$a([$a(["01","8006"])])]]);var _Do=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Ds=new Map([["parts",$a([_Do])],["req",$a([$a(["7021"])])]]);var _Du=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a(["lintkey"])]]);var _Dw=new Map([["parts",$a([_Du])]]);var _Dy=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166999"])]]);var _E0=new Map([["cset","X"],["min",1],["max",27],["opt",false],["linters",$a([])]]);var _E4=new Map([["parts",$a([_Dy,_E0])],["req",$a([$a(["01","02"])])]]);var _E6=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _E8=new Map([["cset","X"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _EA=new Map([["cset","X"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _EC=new Map([["cset","X"],["min",1],["max",1],["opt",false],["linters",$a(["lintimporteridx"])]]);var _EE=new Map([["parts",$a([_E6,_E8,_EA,_EC])]]);var _EG=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _EK=new Map([["parts",$a([_EG])],["req",$a([$a(["01"])])]]);var _EM=new Map([["cset","X"],["min",2],["max",2],["opt",false],["linters",$a([])]]);var _EO=new Map([["cset","X"],["min",1],["max",28],["opt",false],["linters",$a([])]]);var _ES=new Map([["parts",$a([_EM,_EO])],["req",$a([$a(["01","8004"])])]]);var _EU=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _EY=new Map([["parts",$a([_EU])],["req",$a([$a(["01","8006"])])]]);var _Ea=new Map([["cset","N"],["min",2],["max",2],["opt",false],["linters",$a(["lintmediatype"])]]);var _Ee=new Map([["parts",$a([_Ea])],["req",$a([$a(["8017","8018"])])]]);var _Eg=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a([])]]);var _Ek=new Map([["parts",$a([_Eg])],["req",$a([$a(["8017","8018"])])]]);var _Em=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["lintnonzero"])]]);var _Eo=new Map([["cset","N"],["min",5],["max",5],["opt",false],["linters",$a(["lintnonzero"])]]);var _Eq=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintnonzero"])]]);var _Es=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintwinding"])]]);var _Eu=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _Ey=new Map([["parts",$a([_Em,_Eo,_Eq,_Es,_Eu])],["req",$a([$a(["01"])])]]);var _F0=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _F2=new Map([["parts",$a([_F0])]]);var _F4=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintzero"])]]);var _F6=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _F8=new Map([["cset","X"],["min",1],["max",16],["opt",true],["linters",$a([])]]);var _FB=new Map([["parts",$a([_F4,_F6,_F8])],["dlpkey",$a([])]]);var _FD=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a(["lintkey"])]]);var _FH=new Map([["parts",$a([_FD])],["dlpkey",$a([$a(["7040"])])]]);var _FJ=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _FN=new Map([["parts",$a([_FJ])],["req",$a([$a(["01","02"])])]]);var _FP=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",$a(["lintcsum"])]]);var _FR=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["lintpieceoftotal"])]]);var _FW=new Map([["parts",$a([_FP,_FR])],["ex",$a(["01","37"])],["dlpkey",$a([$a(["22","10","21"])])]]);var _FY=new Map([["cset","X"],["min",1],["max",34],["opt",false],["linters",$a(["lintiban"])]]);var _Fc=new Map([["parts",$a([_FY])],["req",$a([$a(["415"])])]]);var _Fe=new Map([["cset","N"],["min",8],["max",8],["opt",false],["linters",$a(["lintyymmddhh"])]]);var _Fg=new Map([["cset","N"],["min",1],["max",4],["opt",true],["linters",$a(["lintmmoptss"])]]);var _Fk=new Map([["parts",$a([_Fe,_Fg])],["req",$a([$a(["01","02"])])]]);var _Fm=new Map([["cset","X"],["min",1],["max",50],["opt",false],["linters",$a([])]]);var _Fq=new Map([["parts",$a([_Fm])],["req",$a([$a(["00","01"])])]]);var _Fs=new Map([["cset","Y"],["min",1],["max",30],["opt",false],["linters",$a(["lintkey"])]]);var _Fw=new Map([["parts",$a([_Fs])],["dlpkey",$a([$a(["8011"])])]]);var _Fy=new Map([["cset","N"],["min",1],["max",12],["opt",false],["linters",$a(["lintnozeroprefix"])]]);var _G2=new Map([["parts",$a([_Fy])],["req",$a([$a(["8010"])])]]);var _G4=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _G8=new Map([["parts",$a([_G4])],["req",$a([$a(["01","8006"])])]]);var _GA=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a(["lintcsumalpha","lintkey"])]]);var _GD=new Map([["parts",$a([_GA])],["dlpkey",$a([])]]);var _GF=new Map([["cset","N"],["min",18],["max",18],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _GK=new Map([["parts",$a([_GF])],["ex",$a(["8018"])],["dlpkey",$a([$a(["8019"])])]]);var _GM=new Map([["cset","N"],["min",18],["max",18],["opt",false],["linters",$a(["lintcsum","lintkey"])]]);var _GR=new Map([["parts",$a([_GM])],["ex",$a(["8017"])],["dlpkey",$a([$a(["8019"])])]]);var _GT=new Map([["cset","N"],["min",1],["max",10],["opt",false],["linters",$a([])]]);var _GX=new Map([["parts",$a([_GT])],["req",$a([$a(["8017","8018"])])]]);var _GZ=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a([])]]);var _Gd=new Map([["parts",$a([_GZ])],["req",$a([$a(["415"])])]]);var _Gf=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",$a(["lintcsum"])]]);var _Gh=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["lintpieceoftotal"])]]);var _Gm=new Map([["parts",$a([_Gf,_Gh])],["ex",$a(["02","8006"])],["req",$a([$a(["37"])])]]);var _Go=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintcouponcode"])]]);var _Gq=new Map([["parts",$a([_Go])]]);var _Gs=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a([])]]);var _Gw=new Map([["parts",$a([_Gs])],["req",$a([$a(["255"])])]]);var _Gy=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintcouponposoffer"])]]);var _H0=new Map([["parts",$a([_Gy])]]);var _H2=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a([])]]);var _H6=new Map([["parts",$a([_H2])],["req",$a([$a(["01"])])]]);var _H8=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _HA=new Map([["parts",$a([_H8])]]);var _HC=new Map([["cset","X"],["min",1],["max",90],["opt",false],["linters",$a([])]]);var _HE=new Map([["parts",$a([_HC])]]);var _HF=new Map([["00",_4],["01",_C],["02",_I],["10",_O],["11",_U],["12",_a],["13",_g],["15",_g],["16",_g],["17",_m],["20",_s],["21",_z],["22",_15],["235",_1B],["240",_1H],["241",_1H],["242",_1N],["243",_1T],["250",_1a],["251",_1g],["253",_1n],["254",_1t],["255",_21],["30",_27],["3100",_2E],["3101",_2E],["3102",_2E],["3103",_2E],["3104",_2E],["3105",_2E],["3110",_2L],["3111",_2L],["3112",_2L],["3113",_2L],["3114",_2L],["3115",_2L],["3120",_2S],["3121",_2S],["3122",_2S],["3123",_2S],["3124",_2S],["3125",_2S],["3130",_2Z],["3131",_2Z],["3132",_2Z],["3133",_2Z],["3134",_2Z],["3135",_2Z],["3140",_2g],["3141",_2g],["3142",_2g],["3143",_2g],["3144",_2g],["3145",_2g],["3150",_2n],["3151",_2n],["3152",_2n],["3153",_2n],["3154",_2n],["3155",_2n],["3160",_2u],["3161",_2u],["3162",_2u],["3163",_2u],["3164",_2u],["3165",_2u],["3200",_31],["3201",_31],["3202",_31],["3203",_31],["3204",_31],["3205",_31],["3210",_38],["3211",_38],["3212",_38],["3213",_38],["3214",_38],["3215",_38],["3220",_3F],["3221",_3F],["3222",_3F],["3223",_3F],["3224",_3F],["3225",_3F],["3230",_3M],["3231",_3M],["3232",_3M],["3233",_3M],["3234",_3M],["3235",_3M],["3240",_3T],["3241",_3T],["3242",_3T],["3243",_3T],["3244",_3T],["3245",_3T],["3250",_3a],["3251",_3a],["3252",_3a],["3253",_3a],["3254",_3a],["3255",_3a],["3260",_3h],["3261",_3h],["3262",_3h],["3263",_3h],["3264",_3h],["3265",_3h],["3270",_3o],["3271",_3o],["3272",_3o],["3273",_3o],["3274",_3o],["3275",_3o],["3280",_3v],["3281",_3v],["3282",_3v],["3283",_3v],["3284",_3v],["3285",_3v],["3290",_42],["3291",_42],["3292",_42],["3293",_42],["3294",_42],["3295",_42],["3300",_49],["3301",_49],["3302",_49],["3303",_49],["3304",_49],["3305",_49],["3310",_4G],["3311",_4G],["3312",_4G],["3313",_4G],["3314",_4G],["3315",_4G],["3320",_4N],["3321",_4N],["3322",_4N],["3323",_4N],["3324",_4N],["3325",_4N],["3330",_4U],["3331",_4U],["3332",_4U],["3333",_4U],["3334",_4U],["3335",_4U],["3340",_4b],["3341",_4b],["3342",_4b],["3343",_4b],["3344",_4b],["3345",_4b],["3350",_4i],["3351",_4i],["3352",_4i],["3353",_4i],["3354",_4i],["3355",_4i],["3360",_4p],["3361",_4p],["3362",_4p],["3363",_4p],["3364",_4p],["3365",_4p],["3370",_4w],["3371",_4w],["3372",_4w],["3373",_4w],["3374",_4w],["3375",_4w],["3400",_53],["3401",_53],["3402",_53],["3403",_53],["3404",_53],["3405",_53],["3410",_5A],["3411",_5A],["3412",_5A],["3413",_5A],["3414",_5A],["3415",_5A],["3420",_5H],["3421",_5H],["3422",_5H],["3423",_5H],["3424",_5H],["3425",_5H],["3430",_5O],["3431",_5O],["3432",_5O],["3433",_5O],["3434",_5O],["3435",_5O],["3440",_5V],["3441",_5V],["3442",_5V],["3443",_5V],["3444",_5V],["3445",_5V],["3450",_5c],["3451",_5c],["3452",_5c],["3453",_5c],["3454",_5c],["3455",_5c],["3460",_5j],["3461",_5j],["3462",_5j],["3463",_5j],["3464",_5j],["3465",_5j],["3470",_5q],["3471",_5q],["3472",_5q],["3473",_5q],["3474",_5q],["3475",_5q],["3480",_5x],["3481",_5x],["3482",_5x],["3483",_5x],["3484",_5x],["3485",_5x],["3490",_64],["3491",_64],["3492",_64],["3493",_64],["3494",_64],["3495",_64],["3500",_6B],["3501",_6B],["3502",_6B],["3503",_6B],["3504",_6B],["3505",_6B],["3510",_6I],["3511",_6I],["3512",_6I],["3513",_6I],["3514",_6I],["3515",_6I],["3520",_6P],["3521",_6P],["3522",_6P],["3523",_6P],["3524",_6P],["3525",_6P],["3530",_6W],["3531",_6W],["3532",_6W],["3533",_6W],["3534",_6W],["3535",_6W],["3540",_6d],["3541",_6d],["3542",_6d],["3543",_6d],["3544",_6d],["3545",_6d],["3550",_6k],["3551",_6k],["3552",_6k],["3553",_6k],["3554",_6k],["3555",_6k],["3560",_6r],["3561",_6r],["3562",_6r],["3563",_6r],["3564",_6r],["3565",_6r],["3570",_6y],["3571",_6y],["3572",_6y],["3573",_6y],["3574",_6y],["3575",_6y],["3600",_75],["3601",_75],["3602",_75],["3603",_75],["3604",_75],["3605",_75],["3610",_7C],["3611",_7C],["3612",_7C],["3613",_7C],["3614",_7C],["3615",_7C],["3620",_7J],["3621",_7J],["3622",_7J],["3623",_7J],["3624",_7J],["3625",_7J],["3630",_7Q],["3631",_7Q],["3632",_7Q],["3633",_7Q],["3634",_7Q],["3635",_7Q],["3640",_7X],["3641",_7X],["3642",_7X],["3643",_7X],["3644",_7X],["3645",_7X],["3650",_7e],["3651",_7e],["3652",_7e],["3653",_7e],["3654",_7e],["3655",_7e],["3660",_7l],["3661",_7l],["3662",_7l],["3663",_7l],["3664",_7l],["3665",_7l],["3670",_7s],["3671",_7s],["3672",_7s],["3673",_7s],["3674",_7s],["3675",_7s],["3680",_7z],["3681",_7z],["3682",_7z],["3683",_7z],["3684",_7z],["3685",_7z],["3690",_86],["3691",_86],["3692",_86],["3693",_86],["3694",_86],["3695",_86],["37",_8D],["3900",_8K],["3901",_8K],["3902",_8K],["3903",_8K],["3904",_8K],["3905",_8K],["3906",_8K],["3907",_8K],["3908",_8K],["3909",_8K],["3910",_8T],["3911",_8T],["3912",_8T],["3913",_8T],["3914",_8T],["3915",_8T],["3916",_8T],["3917",_8T],["3918",_8T],["3919",_8T],["3920",_8b],["3921",_8b],["3922",_8b],["3923",_8b],["3924",_8b],["3925",_8b],["3926",_8b],["3927",_8b],["3928",_8b],["3929",_8b],["3930",_8k],["3931",_8k],["3932",_8k],["3933",_8k],["3934",_8k],["3935",_8k],["3936",_8k],["3937",_8k],["3938",_8k],["3939",_8k],["3940",_8r],["3941",_8r],["3942",_8r],["3943",_8r],["3950",_8y],["3951",_8y],["3952",_8y],["3953",_8y],["3954",_8y],["3955",_8y],["400",_92],["401",_97],["402",_9C],["403",_9I],["410",_9M],["411",_9M],["412",_9M],["413",_9M],["414",_9T],["415",_9b],["416",_9f],["417",_9l],["420",_9q],["421",_9x],["422",_A4],["423",_AB],["424",_AI],["425",_AP],["426",_AV],["427",_Ac],["4300",_Ai],["4301",_Ai],["4302",_Ao],["4303",_Au],["4304",_B0],["4305",_B0],["4306",_B0],["4307",_B6],["4308",_BC],["4309",_BI],["4310",_BO],["4311",_BO],["4312",_BU],["4313",_Ba],["4314",_Bg],["4315",_Bg],["4316",_Bg],["4317",_Bm],["4318",_Bs],["4319",_By],["4320",_C4],["4321",_CA],["4322",_CA],["4323",_CA],["4324",_CI],["4325",_CI],["4326",_CO],["7001",_CU],["7002",_Ca],["7003",_Ci],["7004",_Cp],["7005",_Cv],["7006",_D1],["7007",_D9],["7008",_DF],["7009",_DL],["7010",_DR],["7011",_DZ],["7020",_Dg],["7021",_Dm],["7022",_Ds],["7023",_Dw],["7030",_E4],["7031",_E4],["7032",_E4],["7033",_E4],["7034",_E4],["7035",_E4],["7036",_E4],["7037",_E4],["7038",_E4],["7039",_E4],["7040",_EE],["710",_EK],["711",_EK],["712",_EK],["713",_EK],["714",_EK],["715",_EK],["7230",_ES],["7231",_ES],["7232",_ES],["7233",_ES],["7234",_ES],["7235",_ES],["7236",_ES],["7237",_ES],["7238",_ES],["7239",_ES],["7240",_EY],["7241",_Ee],["7242",_Ek],["8001",_Ey],["8002",_F2],["8003",_FB],["8004",_FH],["8005",_FN],["8006",_FW],["8007",_Fc],["8008",_Fk],["8009",_Fq],["8010",_Fw],["8011",_G2],["8012",_G8],["8013",_GD],["8017",_GK],["8018",_GR],["8019",_GX],["8020",_Gd],["8026",_Gm],["8110",_Gq],["8111",_Gw],["8112",_H0],["8200",_H6],["90",_HA],["91",_HE],["92",_HE],["93",_HE],["94",_HE],["95",_HE],["96",_HE],["97",_HE],["98",_HE],["99",_HE]]);$ctx.gs1syntax=_HF;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__2289__=1})()}if($eq($k[--$j],"ai")){$ax($k[--$j],"(");if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1aiMissingOpenParen#2297";$k[$j++]="AIs must start with '('";bwipp_raiseerror()}$j--;$k[$j++]=Infinity;var _HK=$k[--$j];var _HL=$k[--$j];$k[$j++]=_HK;$k[$j++]=_HL;for(;;){var _HM=$k[--$j];$k[$j++]=_HM;if($eq(_HM,"")){$j--;break}$X($k[--$j],")");if($nt($k[--$j])){$l();$k[$j++]="bwipp.GS1aiMissingCloseParen#2303";$k[$j++]="AIs must end with ')'";bwipp_raiseerror()}var _HP=$k[--$j];var _HQ=$k[--$j];$k[$j++]=_HP;$k[$j++]=_HQ;$j--;var _HR=$k[--$j];var _HS=$k[--$j];$k[$j++]=_HR;$X(_HS,"(");if($k[--$j]){var _HU=$k[--$j];var _HV=$k[--$j];$k[$j++]=_HU;$k[$j++]=_HV;$j--;var _HW=$k[--$j];var _HX=$k[--$j];$k[$j++]=_HW;$k[$j++]=_HX}else{$k[$j++]=""}}var _HY=$m();$k[$j++]=_HY;if(_HY>0){var _HZ=$k[--$j];for(var _Hb=_HZ,_Ha=~~(_HZ/2)+1;_Hb>=_Ha;_Hb-=1){$r(_Hb,-1)}}else{$j--}$as($a(~~($m()/2)));$1.ais=$k[--$j];$as($a($m()));$k[$j++]=Infinity;var _Hh=$k[--$j];var _Hi=$k[--$j];$k[$j++]=_Hh;$F(_Hi,function(){var _Hk=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$k[$j++]=_Hk;bwipp_parseinput()});$1.vals=$a();$j--}else{$ax($k[--$j],"http://");if($nt($k[--$j])){$ax($k[--$j],"https://");if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1dlURIbadScheme#2320";$k[$j++]="Scheme must be http:// or https://";bwipp_raiseerror()}}$j--;$X($k[--$j],"/");if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1dlMissingDomainOrPathInfo#2326";$k[$j++]="URI must contain a domain and path info";bwipp_raiseerror()}$j-=2;$X($k[--$j],"#");if($k[--$j]){var _Hu=$k[--$j];var _Hv=$k[--$j];$k[$j++]=_Hu;$k[$j++]=_Hv;$j--;var _Hw=$k[--$j];var _Hx=$k[--$j];$k[$j++]=_Hw;$k[$j++]=_Hx;$j--}$X($k[--$j],"?");if($nt($k[--$j])){var _I0=$k[--$j];$k[$j++]="";$k[$j++]=null;$k[$j++]=_I0}$1.pp=$k[--$j];$j--;$1.qp=$k[--$j];$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=$1.pp;for(;;){$X($k[--$j],"/");if($nt($k[--$j])){$j--;break}var _I6=$k[--$j];var _I7=$k[--$j];$k[$j++]=_I6.length+1;$k[$j++]=_I7;$j--;var _I8=$k[--$j];var _I9=$k[--$j];var _IA=$k[--$j];$k[$j++]=_IA;$k[$j++]=$f(_I8+_IA);$k[$j++]=_I9}$as($a($m()-1));$1.pipos=$k[--$j];$j-=2;if($1.pipos.length<=1){$k[$j++]="bwipp.GS1dlNoAIinfo#2351";$k[$j++]="The path was too short to contain AI info";bwipp_raiseerror()}$k[$j++]=false;for(var _IG=$1.pipos.length-2;_IG>=0;_IG-=2){var _II=$g($1.pipos,_IG);var _IM=$G($1.pp,_II,$f($f($g($1.pipos,_IG+1)-_II)-1));var _IO=$g($1.gs1syntax,_IM)!==undefined;$k[$j++]=_IG;$k[$j++]=_IM;if(_IO){var _IS=$g($g($1.gs1syntax,$k[--$j]),"dlpkey")!==undefined;if(_IS){var _IT=$k[--$j];var _IU=$k[--$j];$k[$j++]=_IT;$k[$j++]=_IU;$j--;$k[$j++]=true;break}}else{$j--}$j--}if($nt($k[--$j])){$k[$j++]="bwipp.GS1dlNoAIinfo#2370";$k[$j++]="The path does not contain a valid primary key";bwipp_raiseerror()}var _IY=$g($1.pipos,$k[--$j]);$1.pp=$G($1.pp,_IY,$f($1.pp.length-_IY));$1.uriunescape=function(){$1.in=$k[--$j];$1.out=$s($1.in.length);$k[$j++]=0;$k[$j++]=0;for(;;){var _If=$k[--$j];var _Ig=$k[--$j];$k[$j++]=_Ig;$k[$j++]=_If;if(_Ig>=$1.in.length){break}var _Ij=$k[--$j];var _Ik=$k[--$j];var _Il=$g($1.in,_Ik);$k[$j++]=_Ik;$k[$j++]=_Ij;$k[$j++]=_Il;if(_Il==43){$j--;var _In=$k[--$j];$p($1.out,_In,32);var _Io=$k[--$j];$k[$j++]=$f(_Io+1);$k[$j++]=$f(_In+1)}else{var _Ip=$k[--$j];var _Iq=$k[--$j];var _Ir=$k[--$j];$k[$j++]=_Ir;$k[$j++]=_Iq;$k[$j++]=_Ip;if(_Ip==37&&_Ir<$1.in.length-2){$j--;var _Iu=$Z($s(4),"<  >");var _Iw=$k[--$j];var _Ix=$k[--$j];$P(_Iu,1,$G($1.in,$f(_Ix+1),2));try{$k[$j++]=_Ix;$k[$j++]=_Iw;$k[$j++]=$x(_Iu);$k[$j++]=false}catch(e){$k[$j++]=true}if($k[--$j]){$j-=2;$k[$j++]="bwipp.GS1dlBadHexCharacter#2388";$k[$j++]="Invalid hex character";bwipp_raiseerror()}var _J1=$g($k[--$j],0);var _J3=$k[--$j];$p($1.out,_J3,_J1);var _J4=$k[--$j];$k[$j++]=$f(_J4+3);$k[$j++]=$f(_J3+1)}else{var _J6=$k[--$j];var _J7=$k[--$j];$p($1.out,_J7,_J6);var _J8=$k[--$j];$k[$j++]=$f(_J8+1);$k[$j++]=$f(_J7+1)}}}$1.out=$G($1.out,0,$k[--$j]);$j--;$k[$j++]=$1.out};$1.ais=$a(99);$1.vals=$a(99);$k[$j++]=0;$k[$j++]=$1.pp;for(;;){$X($k[--$j],"/");if($k[--$j]){var _JJ=$k[--$j];var _JK=$k[--$j];var _JL=$k[--$j];var _JM=$k[--$j];$p($1.ais,_JM,_JJ);$k[$j++]=_JM;$X(_JL,"/");if($k[--$j]){var _JO=$k[--$j];var _JP=$k[--$j];$k[$j++]=_JO;$k[$j++]=_JP;$j--}else{var _JQ=$k[--$j];$k[$j++]="";$k[$j++]=_JQ}var _JS=$k[--$j];var _JT=$k[--$j];var _JU=$k[--$j];$k[$j++]=_JU;$k[$j++]=_JT;$k[$j++]=$1.vals;$k[$j++]=_JU;$k[$j++]=_JS;$1.uriunescape();var _JV=$k[--$j];var _JW=$k[--$j];$p($k[--$j],_JW,_JV)}else{$j--;break}var _JY=$k[--$j];var _JZ=$k[--$j];$k[$j++]=$f(_JZ+1);$k[$j++]=_JY}var _Ja=$k[--$j];$k[$j++]=_Ja;if(_Ja>1){$k[$j++]=false;$F($g($g($1.gs1syntax,$g($1.ais,0)),"dlpkey"),function(){$1.seq=$k[--$j];$1.i=1;$1.j=0;for(;;){if($1.i>=$1.ais.length){break}if($1.j>=$1.seq.length){break}if($eq($g($1.ais,$1.i),$g($1.seq,$1.j))){$1.i=$1.i+1}$1.j=$1.j+1}var _Ju=$k[--$j];var _Jv=$k[--$j];$k[$j++]=_Jv;$k[$j++]=_Ju;if($1.i==_Jv){$j--;$k[$j++]=true;return true}});if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1dlBadPathInfo#2436";$k[$j++]="The AIs in the path are not a valid key-qualifier sequence for the key";bwipp_raiseerror()}}$k[$j++]=$1.qp;for(;;){var _Jy=$k[--$j];$k[$j++]=_Jy;if($eq(_Jy,"")){$j--;break}$X($k[--$j],"&");if($k[--$j]){var _K1=$k[--$j];var _K2=$k[--$j];$k[$j++]=_K1;$k[$j++]=_K2;$j--}else{var _K3=$k[--$j];$k[$j++]="";$k[$j++]=_K3}$X($k[--$j],"=");if($k[--$j]){var _K6=$k[--$j];$k[$j++]=_K6;$k[$j++]=true;$F(_K6,function(){var _K7=$k[--$j];var _K8=$k[--$j];$k[$j++]=_K8&&(_K7>=48&&_K7<=57)});if($k[--$j]){var _KB=$k[--$j];var _KC=$k[--$j];var _KD=$k[--$j];var _KE=$k[--$j];var _KF=$k[--$j];$p($1.ais,_KF,_KB);$k[$j++]=_KF;$k[$j++]=_KE;$k[$j++]=$1.vals;$k[$j++]=_KF;$k[$j++]=_KD;$1.uriunescape();var _KH=$k[--$j];var _KI=$k[--$j];$p($k[--$j],_KI,_KH);var _KK=$k[--$j];var _KL=$k[--$j];$k[$j++]=$f(_KL+1);$k[$j++]=_KK}else{$j-=3}}else{$j--}}var _KN=$k[--$j];$1.ais=$G($1.ais,0,_KN);$1.vals=$G($1.vals,0,_KN);for(var _KT=0,_KS=$1.ais.length-1;_KT<=_KS;_KT+=1){$k[$j++]=_KT;if($eq($g($1.ais,_KT),"01")){var _KW=$k[--$j];var _KY=$g($1.vals,_KW);var _KZ=_KY.length;$k[$j++]=_KW;$k[$j++]=_KY;if(_KZ==8||(_KZ==12||_KZ==13)){var _Kb=$Z($s(14),"00000000000000");var _Kc=$k[--$j];$P(_Kb,14-_Kc.length,_Kc);var _Ke=$k[--$j];$p($1.vals,_Ke,_Kb);$k[$j++]=_Ke}else{$j--}}$j--}}if(!bwipp_gs1process.__2487__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;var _Kf=$a(["00","01","02","03","04","11","12","13","14","15","16","17","18","19","20","31","32","33","34","35","36","41"]);for(var _Kg=0,_Kh=_Kf.length;_Kg<_Kh;_Kg++){var _Ki=$g(_Kf,_Kg);$k[$j++]=_Ki;$k[$j++]=_Ki}$ctx.aifixed=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__2487__=1})()}$k[$j++]=Infinity;var _Kl=$1.ais;for(var _Km=0,_Kn=_Kl.length;_Km<_Kn;_Km++){var _Ko=$g(_Kl,_Km);$k[$j++]=true;$k[$j++]=_Ko;if(_Ko.length>=2){var _Ks=$g($1.aifixed,$G($k[--$j],0,2))!==undefined;if(_Ks){$j--;$k[$j++]=false}}else{$j--}}$1.fncs=$a();$1.lintnumeric=function(){var _Ku=$k[--$j];$k[$j++]=true;$F(_Ku,function(){var _Kv=$k[--$j];if(_Kv<48||_Kv>57){$j--;$k[$j++]=false;return true}});if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1notNumeric#2507";$k[$j++]="Not numeric";$k[$j++]=false;return true}};$1.lintcset82=function(){var _Kx=$k[--$j];$k[$j++]=true;$F(_Kx,function(){var _Ky=$s(1);$p(_Ky,0,$k[--$j]);$X("!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz",_Ky);if($nt($k[--$j])){$j-=2;$k[$j++]=false;return true}$j-=3});if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1badCSET82character#2517";$k[$j++]="Invalid CSET 82 character";$k[$j++]=false;return true}};$1.lintcset39=function(){var _L2=$k[--$j];$k[$j++]=true;$F(_L2,function(){var _L3=$s(1);$p(_L3,0,$k[--$j]);$X("#-/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",_L3);if($nt($k[--$j])){$j-=2;$k[$j++]=false;return true}$j-=3});if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1badCSET39character#2527";$k[$j++]="Invalid CSET 39 character";$k[$j++]=false;return true}};$1.lintkey=function(){var _L7=$k[--$j];$k[$j++]=_L7;if(_L7.length<2){$j-=2;$k[$j++]="bwipp.GS1keyTooShort#2531";$k[$j++]="Key is too short";$k[$j++]=false;return true}var _L8=$k[--$j];var _L9=$g(_L8,0);var _LA=$g(_L8,1);if(_L9<48||_L9>57||(_LA<48||_LA>57)){$j--;$k[$j++]="bwipp.GS1badGCP#2534";$k[$j++]="Non-numeric company prefix";$k[$j++]=false;return true}};$1.lintimporteridx=function(){$X("-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz",$k[--$j]);if($nt($k[--$j])){$j-=2;$k[$j++]="bwipp.GS1badImporterIndex#2540";$k[$j++]="Invalid importer index";$k[$j++]=false;return true}$j-=3};$1.lintcsum=function(){$k[$j++]=Infinity;var _LD=$k[--$j];var _LE=$k[--$j];var _LF=_LE.length%2==0?3:1;$k[$j++]=_LD;$k[$j++]=_LF;$F(_LE,function(){var _LG=$k[--$j];var _LH=$k[--$j];$k[$j++]=$f(_LG-48)*_LH;$k[$j++]=$f(4-_LH)});$j--;var _LI=$m()+1;$k[$j++]=0;for(var _LJ=0,_LK=_LI-1;_LJ<_LK;_LJ++){var _LL=$k[--$j];var _LM=$k[--$j];$k[$j++]=$f(_LM+_LL)}var _LN=$k[--$j];var _LO=$k[--$j];$k[$j++]=_LN;$k[$j++]=_LO;$j--;if($k[--$j]%10!=0){$j--;$k[$j++]="bwipp.GS1badChecksum#2549";$k[$j++]="Bad checksum";$k[$j++]=false;return true}};if(!bwipp_gs1process.__2562__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;$k[$j++]=0;for(var _LQ=0,_LR="!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".length;_LQ<_LR;_LQ++){var _LT=$k[--$j];$k[$j++]=$g("!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz",_LQ);$k[$j++]=_LT;$k[$j++]=$f(_LT+1)}$j--;$ctx.cset82=$d();$k[$j++]=Infinity;$k[$j++]=0;for(var _LV=0,_LW="23456789ABCDEFGHJKLMNPQRSTUVWXYZ".length;_LV<_LW;_LV++){var _LY=$k[--$j];$k[$j++]=$g("23456789ABCDEFGHJKLMNPQRSTUVWXYZ",_LV);$k[$j++]=_LY;$k[$j++]=$f(_LY+1)}$j--;$ctx.cset32=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__2562__=1})()}$1.lintcsumalpha=function(){var _Lb=$k[--$j];$k[$j++]=_Lb;if(_Lb.length<2){$j-=2;$k[$j++]="bwipp.GS1alphaTooShort#2565";$k[$j++]="Alphanumeric string is too short to check";$k[$j++]=false;return true}var _Lc=$k[--$j];$k[$j++]=_Lc;$k[$j++]=_Lc.length-2;$k[$j++]=$G(_Lc,0,_Lc.length-2);$k[$j++]=Infinity;var _Le=$k[--$j];var _Lf=$k[--$j];$k[$j++]=_Le;$F(_Lf,function(){var _Lg=$k[--$j];var _Li=$g($1.cset82,_Lg)!==undefined;$k[$j++]=_Lg;if(_Li){var _Ll=$g($1.cset82,$k[--$j]);$k[$j++]=_Ll}else{$k[$j++]=-1;return true}});var _Lm=$k[--$j];$k[$j++]=_Lm;if(_Lm==-1){$l();$j-=3;$k[$j++]="bwipp.GS1UnknownCSET82Character#2571";$k[$j++]="Unknown CSET 82 character";$k[$j++]=false;return true}$as($a($m()));var _Lp=$k[--$j];var _Lq=$k[--$j];$k[$j++]=_Lp;$k[$j++]=_Lq;$j--;var _Lr=$k[--$j];var _Ls=$k[--$j];var _Lu=$G($k[--$j],_Ls,2);$k[$j++]=_Lr;$k[$j++]=_Lu;$k[$j++]=Infinity;var _Lv=$k[--$j];var _Lw=$k[--$j];$k[$j++]=_Lv;$F(_Lw,function(){var _Lx=$k[--$j];var _Lz=$g($1.cset32,_Lx)!==undefined;$k[$j++]=_Lx;if(_Lz){var _M2=$g($1.cset32,$k[--$j]);$k[$j++]=_M2}else{$k[$j++]=-1;return true}});var _M3=$k[--$j];$k[$j++]=_M3;if(_M3==-1){$l();$j-=2;$k[$j++]="bwipp.GS1UnknownCSET32Character#2577";$k[$j++]="Unknown CSET 32 character";$k[$j++]=false;return true}$as($a($m()));var _M6=$k[--$j];var _M7=$k[--$j];$k[$j++]=_M6;$k[$j++]=_M7;$j--;var _M8=$k[--$j];var _MB=$k[--$j];var _MC=$a([2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83]);var _MD=_MB.length;$k[$j++]=$f(($g(_M8,0)<<5)+$g(_M8,1));$k[$j++]=_MB;$k[$j++]=_MC;$k[$j++]=_MD;if(_MD>_MC.length){$j-=5;$k[$j++]="bwipp.GS1alphaTooLong#2582";$k[$j++]="Alphanumeric string is too long to check";$k[$j++]=false;return true}var _ME=$k[--$j];var _MG=$G($k[--$j],0,_ME);for(var _MH=0,_MI=_MG.length;_MH<_MI;_MH++){var _MK=$k[--$j];$k[$j++]=$g(_MG,_MH);$k[$j++]=_MK}var _ML=$k[--$j];$k[$j++]=0;$F(_ML,function(){var _MM=$k[--$j];var _MN=$k[--$j];var _MO=$k[--$j];$k[$j++]=$f(_MN+_MO*_MM)});var _MP=$k[--$j];if($k[--$j]!=_MP%1021){$j--;$k[$j++]="bwipp.GS1badAlphaCheckCharacters#2585";$k[$j++]="Bad alphanumeric check characters";$k[$j++]=false;return true}};if(!bwipp_gs1process.__2609__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;var _MR=$a(["004","008","010","012","016","020","024","028","031","032","036","040","044","048","050","051","052","056","060","064","068","070","072","074","076","084","086","090","092","096","100","104","108","112","116","120","124","132","136","140","144","148","152","156","158","162","166","170","174","175","178","180","184","188","191","192","196","203","204","208","212","214","218","222","226","231","232","233","234","238","239","242","246","248","250","254","258","260","262","266","268","270","275","276","288","292","296","300","304","308","312","316","320","324","328","332","334","336","340","344","348","352","356","360","364","368","372","376","380","384","388","392","398","400","404","408","410","414","417","418","422","426","428","430","434","438","440","442","446","450","454","458","462","466","470","474","478","480","484","492","496","498","499","500","504","508","512","516","520","524","528","531","533","534","535","540","548","554","558","562","566","570","574","578","580","581","583","584","585","586","591","598","600","604","608","612","616","620","624","626","630","634","638","642","643","646","652","654","659","660","662","663","666","670","674","678","682","686","688","690","694","702","703","704","705","706","710","716","724","728","729","732","740","744","748","752","756","760","762","764","768","772","776","780","784","788","792","795","796","798","800","804","807","818","826","831","832","833","834","840","850","854","858","860","862","876","882","887","894"]);for(var _MS=0,_MT=_MR.length;_MS<_MT;_MS++){var _MU=$g(_MR,_MS);$k[$j++]=_MU;$k[$j++]=_MU}$ctx.iso3166=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__2609__=1})()}$1.lintiso3166=function(){var _MZ=$g($1.iso3166,$k[--$j])!==undefined;if(!_MZ){$j--;$k[$j++]="bwipp.GS1UnknownCountry#2612";$k[$j++]="Unknown country code";$k[$j++]=false;return true}};$1.lintiso3166999=function(){var _Ma=$k[--$j];$k[$j++]=_Ma;if($ne(_Ma,"999")){var _Md=$g($1.iso3166,$k[--$j])!==undefined;if(!_Md){$j--;$k[$j++]="bwipp.GS1UnknownCountryOr999#2617";$k[$j++]="Unknown country code or not 999";$k[$j++]=false;return true}}else{$j--}};$1.lintiso3166list=function(){var _Me=$k[--$j];$k[$j++]=_Me;if(_Me.length%3!=0){$j-=2;$k[$j++]="bwipp.GS1BadCountryListLength#2625";$k[$j++]="Not a group of three-digit country codes";$k[$j++]=false;return true}var _Mf=$k[--$j];$k[$j++]=_Mf;$k[$j++]=true;for(var _Mh=0,_Mg=_Mf.length-1;_Mh<=_Mg;_Mh+=3){var _Mi=$k[--$j];var _Mj=$k[--$j];var _Mm=$g($1.iso3166,$G(_Mj,_Mh,3))!==undefined;$k[$j++]=_Mj;$k[$j++]=_Mi;if(!_Mm){$j-=2;$k[$j++]=false;break}}if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1UnknownCountry#2632";$k[$j++]="Unknown country code";$k[$j++]=false;return true}$j--};if(!bwipp_gs1process.__2663__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;var _Mo=$a(["AD","AE","AF","AG","AI","AL","AM","AO","AQ","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC","TD","TF","TG","TH","TJ","TK","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW"]);for(var _Mp=0,_Mq=_Mo.length;_Mp<_Mq;_Mp++){var _Mr=$g(_Mo,_Mp);$k[$j++]=_Mr;$k[$j++]=_Mr}$ctx.iso3166alpha2=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__2663__=1})()}$1.lintiso3166alpha2=function(){var _Mw=$g($1.iso3166alpha2,$k[--$j])!==undefined;if(!_Mw){$j--;$k[$j++]="bwipp.GS1UnknownCountryAlpha#2666";$k[$j++]="Unknown country alpha code";$k[$j++]=false;return true}};if(!bwipp_gs1process.__2694__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;var _Mx=$a(["008","012","032","036","044","048","050","051","052","060","064","068","072","084","090","096","104","108","116","124","132","136","144","152","156","170","174","188","191","192","203","208","214","222","230","232","238","242","262","270","292","320","324","328","332","340","344","348","352","356","360","364","368","376","388","392","398","400","404","408","410","414","417","418","422","426","430","434","446","454","458","462","480","484","496","498","504","512","516","524","532","533","548","554","558","566","578","586","590","598","600","604","608","634","643","646","654","682","690","694","702","704","706","710","728","748","752","756","760","764","776","780","784","788","800","807","818","826","834","840","858","860","882","886","901","925","927","928","929","930","931","932","933","934","936","938","940","941","943","944","946","947","948","949","950","951","952","953","955","956","957","958","959","960","961","962","963","964","965","967","968","969","970","971","972","973","975","976","977","978","979","980","981","984","985","986","990","994","997","999"]);for(var _My=0,_Mz=_Mx.length;_My<_Mz;_My++){var _N0=$g(_Mx,_My);$k[$j++]=_N0;$k[$j++]=_N0}$ctx.iso4217=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__2694__=1})()}$1.lintiso4217=function(){var _N5=$g($1.iso4217,$k[--$j])!==undefined;if(!_N5){$j--;$k[$j++]="bwipp.GS1UnknownCurrency#2697";$k[$j++]="Unknown currency code";$k[$j++]=false;return true}};$1.lintiban=function(){var _N6=$k[--$j];$k[$j++]=_N6;if(_N6.length<=4){$j-=2;$k[$j++]="bwipp.GS1tooShort#2701";$k[$j++]="IBAN too short";$k[$j++]=false;return true}var _N7=$k[--$j];$k[$j++]=_N7;$k[$j++]=true;$F(_N7,function(){var _N8=$s(1);$p(_N8,0,$k[--$j]);$X("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",_N8);if($nt($k[--$j])){$j-=2;$k[$j++]=false;return true}$j-=3});if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1badIBANcharacter#2708";$k[$j++]="Invalid IBAN character";$k[$j++]=false;return true}var _NC=$k[--$j];$k[$j++]=_NC;$k[$j++]=_NC;$k[$j++]=Infinity;var _ND=$k[--$j];var _NE=$k[--$j];$k[$j++]=_ND;$k[$j++]=_NE;$k[$j++]=Infinity;var _NF=$k[--$j];var _NG=$k[--$j];$k[$j++]=_NF;$F(_NG);$r($m(),-4);$as($a($m()));var _NK=$k[--$j];var _NL=$k[--$j];$k[$j++]=_NK;$k[$j++]=_NL;$j--;$F($k[--$j],function(){var _NO=$f($k[--$j]-48);$k[$j++]=_NO;if(_NO>9){var _NQ=$f($k[--$j]-7);$k[$j++]=~~(_NQ/10);$k[$j++]=_NQ%10}});$as($a($m()));var _NT=$k[--$j];var _NU=$k[--$j];$k[$j++]=_NT;$k[$j++]=_NU;$j--;var _NV=$k[--$j];$k[$j++]=0;$F(_NV,function(){var _NW=$k[--$j];var _NX=$k[--$j];$k[$j++]=$f(_NW+_NX*10)%97});if($k[--$j]!=1){$j-=2;$k[$j++]="bwipp.GS1badIBANchecksum#2713";$k[$j++]="IBAN checksum incorrect";$k[$j++]=false;return true}var _Na=$G($k[--$j],0,2);$k[$j++]=_Na;$1.lintiso3166alpha2()};$1.lintzero=function(){if($ne($k[--$j],"0")){$j--;$k[$j++]="bwipp.GS1zeroRequired#2718";$k[$j++]="Zero is required";$k[$j++]=false;return true}};$1.lintnonzero=function(){var _Nc=$k[--$j];$k[$j++]=false;$F(_Nc,function(){if($k[--$j]!=48){$j--;$k[$j++]=true}});if($nt($k[--$j])){$j--;$k[$j++]="bwipp.GS1zeroNotPermitted#2723";$k[$j++]="Zero not permitted";$k[$j++]=false;return true}};$1.lintnozeroprefix=function(){var _Nf=$k[--$j];if(_Nf.length>1&&$g(_Nf,0)==48){$j--;$k[$j++]="bwipp.GS1badZeroPrefix#2728";$k[$j++]="Zero prefix is not permitted";$k[$j++]=false;return true}};$1.lintyymmd0=function(){var _Nh=$k[--$j];var _Nj=$i($G(_Nh,2,2));$k[$j++]=_Nh;if(_Nj<1||_Nj>12){$j--;$k[$j++]="bwipp.GS1badMonth#2733";$k[$j++]="Invalid month";$k[$j++]=false;return true}var _Nk=$k[--$j];var _Nm=$i($G(_Nk,0,2));var _Nn=_Nm-21;$k[$j++]=_Nk;$k[$j++]=_Nm;$k[$j++]=_Nn;if(_Nn>=51){$j--;var _No=$k[--$j];$k[$j++]=$f(_No+1900)}else{if($k[--$j]<=-50){var _Nq=$k[--$j];$k[$j++]=$f(_Nq+2100)}else{var _Nr=$k[--$j];$k[$j++]=$f(_Nr+2e3)}}var _Ns=$k[--$j];$k[$j++]=_Ns%400==0||_Ns%4==0&&_Ns%100!=0;$k[$j++]=Infinity;var _Nt=$k[--$j];var _Nv=$k[--$j]?29:28;$k[$j++]=_Nt;$k[$j++]=31;$k[$j++]=_Nv;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;var _Nw=$a();var _Nx=$k[--$j];if($g(_Nw,$i($G(_Nx,2,2))-1)<$i($G(_Nx,4,2))){$j--;$k[$j++]="bwipp.GS1badDay#2739";$k[$j++]="Invalid day of month";$k[$j++]=false;return true}};$1.lintyymmdd=function(){var _O1=$k[--$j];$k[$j++]=_O1;if(_O1.length!=6){$j--;$k[$j++]="bwipp.GS1badDateLength#2743";$k[$j++]="Invalid length for date";$k[$j++]=false;return true}var _O2=$k[--$j];$k[$j++]=_O2;if($i($G(_O2,4,2))<1){$j--;$k[$j++]="bwipp.GS1badDay#2744";$k[$j++]="Invalid day of month";$k[$j++]=false;return true}$1.lintyymmd0()};$1.lintyymmddhh=function(){var _O4=$k[--$j];$k[$j++]=_O4;if(_O4.length!=8){$j--;$k[$j++]="bwipp.GS1badYYMMDDHHLength#2749";$k[$j++]="Invalid length for date with hour";$k[$j++]=false;return true}var _O5=$k[--$j];$k[$j++]=_O5;if($i($G(_O5,6,2))>23){$j-=2;$k[$j++]="bwipp.GS1badHour#2750";$k[$j++]="Invalid hour of day";$k[$j++]=false;return true}var _O8=$G($k[--$j],0,6);$k[$j++]=_O8;$1.lintyymmdd()};$1.linthhmm=function(){var _O9=$k[--$j];$k[$j++]=_O9;if($i($G(_O9,0,2))>23){$j-=2;$k[$j++]="bwipp.GS1badHour#2755";$k[$j++]="Invalid hour of day";$k[$j++]=false;return true}if($i($G($k[--$j],2,2))>59){$j--;$k[$j++]="bwipp.GS1badMinute#2756";$k[$j++]="Invalid minute in the hour";$k[$j++]=false;return true}};$1.lintmmoptss=function(){var _OD=$k[--$j];var _OE=_OD.length;$k[$j++]=_OD;if(_OE!=2&&_OE!=4){$j--;$k[$j++]="bwipp.GS1badTimeLength#2761";$k[$j++]="Invalid length for optional minutes and seconds";$k[$j++]=false;return true}var _OF=$k[--$j];$k[$j++]=_OF;if($i($G(_OF,0,2))>59){$j-=2;$k[$j++]="bwipp.GS1badMinute#2763";$k[$j++]="Invalid minute in the hour";$k[$j++]=false;return true}var _OH=$k[--$j];$k[$j++]=_OH;if(_OH.length>=4){var _OI=$k[--$j];$k[$j++]=_OI;if($i($G(_OI,2,2))>59){$j-=2;$k[$j++]="bwipp.GS1badSecond#2765";$k[$j++]="Invalid second in the minute";$k[$j++]=false;return true}}$j--};$1.lintyesno=function(){var _OK=$k[--$j];if($ne(_OK,"0")&&$ne(_OK,"1")){$j--;$k[$j++]="bwipp.GS1badBoolean#2772";$k[$j++]="Neither 0 nor 1 for yes or no";$k[$j++]=false;return true}};$1.lintwinding=function(){var _OL=$k[--$j];if($ne(_OL,"0")&&($ne(_OL,"1")&&$ne(_OL,"9"))){$j--;$k[$j++]="bwipp.GS1badWinding#2778";$k[$j++]="Invalid winding direction";$k[$j++]=false;return true}};$1.lintpieceoftotal=function(){var _OM=$k[--$j];$k[$j++]=_OM;if(_OM.length%2!=0){$j-=2;$k[$j++]="bwipp.GS1badPieceTotalLength#2783";$k[$j++]="Invalid piece/total length";$k[$j++]=false;return true}var _ON=$k[--$j];var _OP=$i($G(_ON,0,~~(_ON.length/2)));$k[$j++]=_ON;$k[$j++]=_OP;if(_OP==0){$j-=3;$k[$j++]="bwipp.GS1badPieceNumber#2785";$k[$j++]="Invalid piece number";$k[$j++]=false;return true}var _OQ=$k[--$j];var _OR=$k[--$j];var _OS=~~(_OR.length/2);var _OU=$i($G(_OR,_OS,_OS));$k[$j++]=_OQ;$k[$j++]=_OU;if(_OU==0){$j-=3;$k[$j++]="bwipp.GS1badPieceTotal#2787";$k[$j++]="Invalid total number";$k[$j++]=false;return true}var _OV=$k[--$j];if($gt($k[--$j],_OV)){$j--;$k[$j++]="bwipp.GS1pieceExceedsTotal#2788";$k[$j++]="Piece number exceeds total";$k[$j++]=false;return true}};$1.lintpcenc=function(){for(;;){$X($k[--$j],"%");if($nt($k[--$j])){$j--;break}$j-=2;var _OZ=$k[--$j];$k[$j++]=_OZ;if(_OZ.length<2){$j-=2;$k[$j++]="bwipp.GS1badPercentEscape#2794";$k[$j++]="Invalid % escape";$k[$j++]=false;break}var _Oa=$k[--$j];var _Ob=$G(_Oa,0,2);$k[$j++]=_Oa;$k[$j++]=true;for(var _Oc=0,_Od=_Ob.length;_Oc<_Od;_Oc++){var _Of=$s(1);$p(_Of,0,$g(_Ob,_Oc));$X("0123456789ABCDEFabcdef",_Of);if($nt($k[--$j])){$j-=2;$k[$j++]=false;break}$j-=3}if($nt($k[--$j])){$j-=2;$k[$j++]="bwipp.GS1badPercentChars#2801";$k[$j++]="Invalid characters for percent encoding";$k[$j++]=false;break}}};$1.lintcouponcode=function(){var _Oi=$k[--$j];$k[$j++]=_Oi;$k[$j++]=true;$F(_Oi,function(){var _Oj=$k[--$j];if(_Oj<48||_Oj>57){$j--;$k[$j++]=false;return true}});if($nt($k[--$j])){$j-=2;$k[$j++]="bwipp.GS1couponNotNumeric#2809";$k[$j++]="Coupon not numeric";$k[$j++]=false;return true}var _Ol=$k[--$j];$k[$j++]=_Ol;if(_Ol.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortGCPVLI#2813";$k[$j++]="Coupon too short: Missing GCP VLI";$k[$j++]=false;return true}var _Om=$k[--$j];var _Oo=$i($G(_Om,0,1));$k[$j++]=_Om;$k[$j++]=_Oo;if(_Oo>6){$j-=2;$k[$j++]="bwipp.GS1couponBadGCPVLI#2816";$k[$j++]="Coupon GCP length indicator must be 0-6";$k[$j++]=false;return true}var _Op=$k[--$j];var _Oq=$k[--$j];$k[$j++]=_Oq;$k[$j++]=$f($f(_Op+6)+1);if($f($f(_Op+6)+1)>_Oq.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortGCP#2820";$k[$j++]="Coupon too short: GCP truncated";$k[$j++]=false;return true}var _Or=$k[--$j];var _Os=$k[--$j];var _Ot=$G(_Os,_Or,$f(_Os.length-_Or));$k[$j++]=_Ot;if(_Ot.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortOfferCode#2826";$k[$j++]="Coupon too short: Offer Code truncated";$k[$j++]=false;return true}var _Ou=$k[--$j];var _Ov=$G(_Ou,6,_Ou.length-6);$k[$j++]=_Ov;if(_Ov.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSaveValueVLI#2832";$k[$j++]="Coupon too short: Missing Save Value VLI";$k[$j++]=false;return true}var _Ow=$k[--$j];var _Oy=$i($G(_Ow,0,1));$k[$j++]=_Ow;$k[$j++]=_Oy;if(_Oy<1||_Oy>5){$j-=2;$k[$j++]="bwipp.GS1couponBadSaveValueVLI#2835";$k[$j++]="Coupon Save Value length indicator must be 1-5";$k[$j++]=false;return true}var _Oz=$k[--$j];var _P0=$k[--$j];$k[$j++]=_P0;$k[$j++]=$f(_Oz+1);if($f(_Oz+1)>_P0.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortSaveValue#2839";$k[$j++]="Coupon too short: Save Value truncated";$k[$j++]=false;return true}var _P1=$k[--$j];var _P2=$k[--$j];var _P3=$G(_P2,_P1,$f(_P2.length-_P1));$k[$j++]=_P3;if(_P3.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseRequirementVLI#2845";$k[$j++]="Coupon too short: Missing 1st Purchase Requirement VLI";$k[$j++]=false;return true}var _P4=$k[--$j];var _P6=$i($G(_P4,0,1));$k[$j++]=_P4;$k[$j++]=_P6;if(_P6<1||_P6>5){$j-=2;$k[$j++]="bwipp.GS1couponBad1stPurchaseRequirementVLI#2848";$k[$j++]="Coupon 1st Purchase Requirement length indicator must be 1-5";$k[$j++]=false;return true}var _P7=$k[--$j];var _P8=$k[--$j];$k[$j++]=_P8;$k[$j++]=$f(_P7+1);if($f(_P7+1)>_P8.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseRequirement#2852";$k[$j++]="Coupon too short: 1st Purchase Requirement truncated";$k[$j++]=false;return true}var _P9=$k[--$j];var _PA=$k[--$j];var _PB=$G(_PA,_P9,$f(_PA.length-_P9));$k[$j++]=_PB;if(_PB.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseRequirementCode#2858";$k[$j++]="Coupon too short: Missing 1st Purchase Requirement Code";$k[$j++]=false;return true}var _PC=$k[--$j];var _PE=$i($G(_PC,0,1));$k[$j++]=_PC;if(_PE>4&&_PE!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad1stPurchaseRequirementCode#2861";$k[$j++]="Coupon 1st Purchase Requirement Code must be 0-4 or 9";$k[$j++]=false;return true}var _PF=$k[--$j];var _PG=$G(_PF,1,_PF.length-1);$k[$j++]=_PG;if(_PG.length<3){$j-=2;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseFamilyCode#2867";$k[$j++]="Coupon too short: 1st Purchase Family Code truncated";$k[$j++]=false;return true}var _PH=$k[--$j];var _PI=$G(_PH,3,_PH.length-3);$k[$j++]=_PI;if(_PI.length>=1){var _PJ=$k[--$j];$k[$j++]=_PJ;if($i($G(_PJ,0,1))==1){var _PL=$k[--$j];var _PM=$G(_PL,1,_PL.length-1);$k[$j++]=_PM;if(_PM.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortAdditionalPurchaseRulesCode#2877";$k[$j++]="Coupon too short: Missing Additional Purchase Rules Code";$k[$j++]=false;return true}var _PN=$k[--$j];$k[$j++]=_PN;if($i($G(_PN,0,1))>3){$j-=2;$k[$j++]="bwipp.GS1couponBadAdditionalPurchaseRulesCode#2880";$k[$j++]="Coupon Additional Purchase Rules Code must be 0-3";$k[$j++]=false;return true}var _PP=$k[--$j];var _PQ=$G(_PP,1,_PP.length-1);$k[$j++]=_PQ;if(_PQ.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseRequirementVLI#2886";$k[$j++]="Coupon too short: Missing 2nd Purchase Requirement VLI";$k[$j++]=false;return true}var _PR=$k[--$j];var _PT=$i($G(_PR,0,1));$k[$j++]=_PR;$k[$j++]=_PT;if(_PT<1||_PT>5){$j-=2;$k[$j++]="bwipp.GS1couponBad2ndPurchaseRequirementVLI#2889";$k[$j++]="Coupon 2nd Purchase Requirement length indicator must be 1-5";$k[$j++]=false;return true}var _PU=$k[--$j];var _PV=$k[--$j];$k[$j++]=_PV;$k[$j++]=$f(_PU+1);if($f(_PU+1)>_PV.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseRequirement#2893";$k[$j++]="Coupon too short: 2nd Purchase Requirement truncated";$k[$j++]=false;return true}var _PW=$k[--$j];var _PX=$k[--$j];var _PY=$G(_PX,_PW,$f(_PX.length-_PW));$k[$j++]=_PY;if(_PY.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseRequirementCode#2899";$k[$j++]="Coupon too short: Missing 2nd Purchase Requirement Code";$k[$j++]=false;return true}var _PZ=$k[--$j];var _Pb=$i($G(_PZ,0,1));$k[$j++]=_PZ;if(_Pb>4&&_Pb!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad2ndPurchaseRequirementCode#2902";$k[$j++]="Coupon 2nd Purchase Requirement Code must be 0-4 or 9";$k[$j++]=false;return true}var _Pc=$k[--$j];var _Pd=$G(_Pc,1,_Pc.length-1);$k[$j++]=_Pd;if(_Pd.length<3){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseFamilyCode#2908";$k[$j++]="Coupon too short: 2nd Purchase Family Code truncated";$k[$j++]=false;return true}var _Pe=$k[--$j];var _Pf=$G(_Pe,3,_Pe.length-3);$k[$j++]=_Pf;if(_Pf.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseGCPVLI#2914";$k[$j++]="Coupon too short: Missing 2nd Purchase GCP VLI";$k[$j++]=false;return true}var _Pg=$k[--$j];var _Pi=$i($G(_Pg,0,1));$k[$j++]=_Pg;$k[$j++]=_Pi;if(_Pi>6&&_Pi!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad2ndPurchaseGCPVLI#2917";$k[$j++]="Coupon 2nd Purchase GCP length indicator must be 0-6 or 9";$k[$j++]=false;return true}var _Pj=$k[--$j];$k[$j++]=_Pj;if(_Pj!=9){var _Pk=$k[--$j];$k[$j++]=$f(_Pk+6)}else{$j--;$k[$j++]=0}var _Pl=$k[--$j];var _Pm=$k[--$j];$k[$j++]=_Pm;$k[$j++]=$f(_Pl+1);if($f(_Pl+1)>_Pm.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseGCP#2921";$k[$j++]="Coupon too short: 2nd Purchase GCP truncated";$k[$j++]=false;return true}var _Pn=$k[--$j];var _Po=$k[--$j];$k[$j++]=$G(_Po,_Pn,$f(_Po.length-_Pn))}}var _Pq=$k[--$j];$k[$j++]=_Pq;if(_Pq.length>=1){var _Pr=$k[--$j];$k[$j++]=_Pr;if($i($G(_Pr,0,1))==2){var _Pt=$k[--$j];var _Pu=$G(_Pt,1,_Pt.length-1);$k[$j++]=_Pu;if(_Pu.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseRequirementVLI#2933";$k[$j++]="Coupon too short: Missing 3rd Purchase Requirement VLI";$k[$j++]=false;return true}var _Pv=$k[--$j];var _Px=$i($G(_Pv,0,1));$k[$j++]=_Pv;$k[$j++]=_Px;if(_Px<1||_Px>5){$j-=2;$k[$j++]="bwipp.GS1couponBad3rdPurchaseRequirementVLI#2936";$k[$j++]="Coupon 3rd Purchase Requirement length indicator must be 1-5";$k[$j++]=false;return true}var _Py=$k[--$j];var _Pz=$k[--$j];$k[$j++]=_Pz;$k[$j++]=$f(_Py+1);if($f(_Py+1)>_Pz.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseRequirement#2940";$k[$j++]="Coupon too short: 3rd Purchase Requirement truncated";$k[$j++]=false;return true}var _Q0=$k[--$j];var _Q1=$k[--$j];var _Q2=$G(_Q1,_Q0,$f(_Q1.length-_Q0));$k[$j++]=_Q2;if(_Q2.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseRequirementCode#2946";$k[$j++]="Coupon too short: Missing 3rd Purchase Requirement Code";$k[$j++]=false;return true}var _Q3=$k[--$j];var _Q5=$i($G(_Q3,0,1));$k[$j++]=_Q3;if(_Q5>4&&_Q5!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad3rdPurchaseRequirementCode#2949";$k[$j++]="Coupon 3rd Purchase Requirement Code must be 0-4 or 9";$k[$j++]=false;return true}var _Q6=$k[--$j];var _Q7=$G(_Q6,1,_Q6.length-1);$k[$j++]=_Q7;if(_Q7.length<3){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseFamilyCode#2955";$k[$j++]="Coupon too short: 3rd Purchase Family Code truncated";$k[$j++]=false;return true}var _Q8=$k[--$j];var _Q9=$G(_Q8,3,_Q8.length-3);$k[$j++]=_Q9;if(_Q9.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseGCPVLI#2961";$k[$j++]="Coupon too short: Missing 3rd Purchase GCP VLI";$k[$j++]=false;return true}var _QA=$k[--$j];var _QC=$i($G(_QA,0,1));$k[$j++]=_QA;$k[$j++]=_QC;if(_QC>6&&_QC!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad3rdPurchaseGCPVLI#2964";$k[$j++]="Coupon 3rd Purchase GCP length indicator must be 0-6 or 9";$k[$j++]=false;return true}var _QD=$k[--$j];$k[$j++]=_QD;if(_QD!=9){var _QE=$k[--$j];$k[$j++]=$f(_QE+6)}else{$j--;$k[$j++]=0}var _QF=$k[--$j];var _QG=$k[--$j];$k[$j++]=_QG;$k[$j++]=$f(_QF+1);if($f(_QF+1)>_QG.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseGCP#2968";$k[$j++]="Coupon too short: 3rd Purchase GCP truncated";$k[$j++]=false;return true}var _QH=$k[--$j];var _QI=$k[--$j];$k[$j++]=$G(_QI,_QH,$f(_QI.length-_QH))}}$1.couponexpire=-1;var _QK=$k[--$j];$k[$j++]=_QK;if(_QK.length>=1){var _QL=$k[--$j];$k[$j++]=_QL;if($i($G(_QL,0,1))==3){var _QN=$k[--$j];var _QO=$G(_QN,1,_QN.length-1);$k[$j++]=_QO;if(_QO.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortExpirationDate#2981";$k[$j++]="Coupon too short: Expiration date";$k[$j++]=false;return true}var _QP=$k[--$j];var _QR=$i($G(_QP,2,2));$k[$j++]=_QP;if(_QR<1||_QR>12){$j-=2;$k[$j++]="bwipp.GS1couponExpirationDateBadMonth#2983";$k[$j++]="Invalid month in expiration date";$k[$j++]=false;return true}var _QS=$k[--$j];var _QU=$i($G(_QS,0,2));var _QV=_QU-21;$k[$j++]=_QS;$k[$j++]=_QU;$k[$j++]=_QV;if(_QV>=51){$j--;var _QW=$k[--$j];$k[$j++]=$f(_QW+1900)}else{if($k[--$j]<=-50){var _QY=$k[--$j];$k[$j++]=$f(_QY+2100)}else{var _QZ=$k[--$j];$k[$j++]=$f(_QZ+2e3)}}var _Qa=$k[--$j];$k[$j++]=_Qa%400==0||_Qa%4==0&&_Qa%100!=0;$k[$j++]=Infinity;var _Qb=$k[--$j];var _Qd=$k[--$j]?29:28;$k[$j++]=_Qb;$k[$j++]=31;$k[$j++]=_Qd;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;var _Qe=$a();var _Qf=$k[--$j];var _Qj=$i($G(_Qf,4,2));$k[$j++]=_Qf;if($g(_Qe,$i($G(_Qf,2,2))-1)<_Qj||_Qj<1){$j-=2;$k[$j++]="bwipp.GS1couponExpirationDateBadDay#2990";$k[$j++]="Invalid day of month in expiration date";$k[$j++]=false;return true}var _Qk=$k[--$j];$1.couponexpire=$i($G(_Qk,0,6));$k[$j++]=$G(_Qk,6,_Qk.length-6)}}var _Qn=$k[--$j];$k[$j++]=_Qn;if(_Qn.length>=1){var _Qo=$k[--$j];$k[$j++]=_Qo;if($i($G(_Qo,0,1))==4){var _Qq=$k[--$j];var _Qr=$G(_Qq,1,_Qq.length-1);$k[$j++]=_Qr;if(_Qr.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortStartDate#3002";$k[$j++]="Coupon too short: Start date";$k[$j++]=false;return true}var _Qs=$k[--$j];var _Qu=$i($G(_Qs,2,2));$k[$j++]=_Qs;if(_Qu<1||_Qu>12){$j-=2;$k[$j++]="bwipp.GS1couponStartDateBadMonth#3004";$k[$j++]="Invalid month in start date";$k[$j++]=false;return true}var _Qv=$k[--$j];var _Qx=$i($G(_Qv,0,2));var _Qy=_Qx-21;$k[$j++]=_Qv;$k[$j++]=_Qx;$k[$j++]=_Qy;if(_Qy>=51){$j--;var _Qz=$k[--$j];$k[$j++]=$f(_Qz+1900)}else{if($k[--$j]<=-50){var _R1=$k[--$j];$k[$j++]=$f(_R1+2100)}else{var _R2=$k[--$j];$k[$j++]=$f(_R2+2e3)}}var _R3=$k[--$j];$k[$j++]=_R3%400==0||_R3%4==0&&_R3%100!=0;$k[$j++]=Infinity;var _R4=$k[--$j];var _R6=$k[--$j]?29:28;$k[$j++]=_R4;$k[$j++]=31;$k[$j++]=_R6;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;var _R7=$a();var _R8=$k[--$j];var _RC=$i($G(_R8,4,2));$k[$j++]=_R8;if($g(_R7,$i($G(_R8,2,2))-1)<_RC||_RC<1){$j-=2;$k[$j++]="bwipp.GS1couponStartDateBadDay#3011";$k[$j++]="Invalid day of month in start date";$k[$j++]=false;return true}var _RD=$k[--$j];$1.couponstart=$i($G(_RD,0,6));$k[$j++]=_RD;if($1.couponexpire!=-1&&$1.couponexpire<$1.couponstart){$j-=2;$k[$j++]="bwipp.GS1couponExpireDateBeforeStartDate#3014";$k[$j++]="Coupon expires before it starts";$k[$j++]=false;return true}var _RI=$k[--$j];$k[$j++]=$G(_RI,6,_RI.length-6)}}var _RK=$k[--$j];$k[$j++]=_RK;if(_RK.length>=1){var _RL=$k[--$j];$k[$j++]=_RL;if($i($G(_RL,0,1))==5){var _RN=$k[--$j];var _RO=$G(_RN,1,_RN.length-1);$k[$j++]=_RO;if(_RO.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSerialNumberVLI#3026";$k[$j++]="Coupon too short: Missing Serial Number VLI";$k[$j++]=false;return true}var _RP=$k[--$j];var _RQ=$G(_RP,0,1);$k[$j++]=_RP;$k[$j++]=$i(_RQ)+6+1;if($i(_RQ)+6+1>_RP.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortSerialNumber#3030";$k[$j++]="Coupon too short: Serial Number truncated";$k[$j++]=false;return true}var _RR=$k[--$j];var _RS=$k[--$j];$k[$j++]=$G(_RS,_RR,$f(_RS.length-_RR))}}var _RU=$k[--$j];$k[$j++]=_RU;if(_RU.length>=1){var _RV=$k[--$j];$k[$j++]=_RV;if($i($G(_RV,0,1))==6){var _RX=$k[--$j];var _RY=$G(_RX,1,_RX.length-1);$k[$j++]=_RY;if(_RY.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortRetailerGCPGLNVLI#3042";$k[$j++]="Coupon too short: Missing Retailer GCP/GLN VLI";$k[$j++]=false;return true}var _RZ=$k[--$j];var _Rb=$i($G(_RZ,0,1));$k[$j++]=_RZ;$k[$j++]=_Rb;if(_Rb<1||_Rb>7){$j-=2;$k[$j++]="bwipp.GS1couponBadRetailerGCPGLNVLI#3045";$k[$j++]="Coupon Retailer GCP/GLN length indicator must be 1-7";$k[$j++]=false;return true}var _Rc=$k[--$j];var _Rd=$k[--$j];$k[$j++]=_Rd;$k[$j++]=$f($f(_Rc+6)+1);if($f($f(_Rc+6)+1)>_Rd.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortRetailerGCPGLN#3049";$k[$j++]="Coupon too short: Retailer GCP/GLN truncated";$k[$j++]=false;return true}var _Re=$k[--$j];var _Rf=$k[--$j];$k[$j++]=$G(_Rf,_Re,$f(_Rf.length-_Re))}}var _Rh=$k[--$j];$k[$j++]=_Rh;if(_Rh.length>=1){var _Ri=$k[--$j];$k[$j++]=_Ri;if($i($G(_Ri,0,1))==9){var _Rk=$k[--$j];var _Rl=$G(_Rk,1,_Rk.length-1);$k[$j++]=_Rl;if(_Rl.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSaveValueCode#3061";$k[$j++]="Coupon too short: Missing Save Value Code";$k[$j++]=false;return true}var _Rm=$k[--$j];var _Ro=$i($G(_Rm,0,1));$k[$j++]=_Rm;if(_Ro>6||(_Ro==3||_Ro==4)){$j-=2;$k[$j++]="bwipp.GS1couponBadSaveValueCode#3064";$k[$j++]="Coupon Save Value Code must be 0,1,2,5 or 6";$k[$j++]=false;return true}var _Rp=$k[--$j];var _Rq=$G(_Rp,1,_Rp.length-1);$k[$j++]=_Rq;if(_Rq.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSaveValueAppliesToItem#3070";$k[$j++]="Coupon too short: Missing Save Value Applies to Item";$k[$j++]=false;return true}var _Rr=$k[--$j];$k[$j++]=_Rr;if($i($G(_Rr,0,1))>2){$j-=2;$k[$j++]="bwipp.GS1couponBadSaveValueAppliesToItem#3073";$k[$j++]="Coupon Save Value Applies to Item must be 0-2";$k[$j++]=false;return true}var _Rt=$k[--$j];var _Ru=$G(_Rt,1,_Rt.length-1);$k[$j++]=_Ru;if(_Ru.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortStoreCouponFlag#3079";$k[$j++]="Coupon too short: Missing Store Coupon Flag";$k[$j++]=false;return true}var _Rv=$k[--$j];var _Rw=$G(_Rv,1,_Rv.length-1);$k[$j++]=_Rw;if(_Rw.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortDontMultiplyFlag#3085";$k[$j++]="Coupon too short: Missing Don't Multiply Flag";$k[$j++]=false;return true}var _Rx=$k[--$j];$k[$j++]=_Rx;if($i($G(_Rx,0,1))>1){$j-=2;$k[$j++]="bwipp.GS1couponBadDontMultiplyFlag#3088";$k[$j++]="Don't Multiply Flag must be 0 or 1";$k[$j++]=false;return true}var _Rz=$k[--$j];$k[$j++]=$G(_Rz,1,_Rz.length-1)}}var _S1=$k[--$j];$k[$j++]=_S1;if(_S1.length!=0){$j-=2;$k[$j++]="bwipp.GS1couponUnrecognisedOptionalField#3095";$k[$j++]="Coupon fields must be 1,2,3,4,5,6 or 9, increasing order";$k[$j++]=false;return true}$j--};$1.lintcouponposoffer=function(){var _S2=$k[--$j];$k[$j++]=_S2;$k[$j++]=true;$F(_S2,function(){var _S3=$k[--$j];if(_S3<48||_S3>57){$j--;$k[$j++]=false;return true}});if($nt($k[--$j])){$j-=2;$k[$j++]="bwipp.GS1couponNotNumeric#3104";$k[$j++]="Coupon not numeric";$k[$j++]=false;return true}var _S5=$k[--$j];$k[$j++]=_S5;if(_S5.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortFormatCode#3107";$k[$j++]="Coupon too short: Missing Format Code";$k[$j++]=false;return true}var _S6=$k[--$j];var _S7=$G(_S6,0,1);$k[$j++]=_S6;if($ne(_S7,"0")&&$ne(_S7,"1")){$j-=2;$k[$j++]="bwipp.GS1couponBadFormatCode#3110";$k[$j++]="Coupon format must be 0 or 1";$k[$j++]=false;return true}var _S8=$k[--$j];var _S9=$G(_S8,1,_S8.length-1);$k[$j++]=_S9;if(_S9.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortFunderVLI#3115";$k[$j++]="Coupon too short: Missing Funder VLI";$k[$j++]=false;return true}var _SA=$k[--$j];var _SC=$i($G(_SA,0,1));$k[$j++]=_SA;$k[$j++]=_SC;if(_SC>6){$j-=3;$k[$j++]="bwipp.GS1couponBadFunderVLI#3118";$k[$j++]="Coupon Funder length indicator must be 0-6";$k[$j++]=false;return true}var _SD=$k[--$j];var _SE=$k[--$j];$k[$j++]=_SE;$k[$j++]=$f($f(_SD+6)+1);if($f($f(_SD+6)+1)>_SE.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortFunder#3122";$k[$j++]="Coupon too short: Truncated Funder ID";$k[$j++]=false;return true}var _SF=$k[--$j];var _SG=$k[--$j];var _SH=$G(_SG,_SF,$f(_SG.length-_SF));$k[$j++]=_SH;if(_SH.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortOfferCode#3127";$k[$j++]="Coupon too short: Truncated Offer Code";$k[$j++]=false;return true}var _SI=$k[--$j];var _SJ=$G(_SI,6,_SI.length-6);$k[$j++]=_SJ;if(_SJ.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSnVLI#3132";$k[$j++]="Coupon too short: Missing SN VLI";$k[$j++]=false;return true}var _SK=$k[--$j];var _SL=$G(_SK,0,1);$k[$j++]=_SK;$k[$j++]=$i(_SL)+6+1;if($i(_SL)+6+1>_SK.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortSn#3137";$k[$j++]="Coupon too short: Truncated SN";$k[$j++]=false;return true}var _SM=$k[--$j];var _SN=$k[--$j];var _SO=$G(_SN,_SM,$f(_SN.length-_SM));$k[$j++]=_SO;if(_SO.length!=0){$j-=2;$k[$j++]="bwipp.GS1couponTooLong#3141";$k[$j++]="Coupon too long";$k[$j++]=false;return true}$j--};$1.lintlatlong=function(){var _SP=$k[--$j];$k[$j++]=_SP;if(_SP.length!=20){$j--;$k[$j++]="bwipp.GS1badGeoLength#3148";$k[$j++]="Invalid length for a geo-location";$k[$j++]=false;return true}var _SQ=$k[--$j];$k[$j++]=_SQ;if($i($G(_SQ,0,10))>18e8){$j--;$k[$j++]="bwipp.GS1badLatitude#3150";$k[$j++]="Invalid value for latitude";$k[$j++]=false;return true}var _SS=$k[--$j];$k[$j++]=_SS;if($i($G(_SS,10,10))>36e8){$j--;$k[$j++]="bwipp.GS1badLongitude#3151";$k[$j++]="Invalid value for longitude";$k[$j++]=false;return true}$j--};if(!bwipp_gs1process.__3161__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;var _SU=$a(["01","02","03","04","05","06","07","08","09","10","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95","96","97","98","99"]);for(var _SV=0,_SW=_SU.length;_SV<_SW;_SV++){var _SX=$g(_SU,_SV);$k[$j++]=_SX;$k[$j++]=_SX}$ctx.aidcmediatype=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1process.$ctx[id]=$ctx[id]);bwipp_gs1process.__3161__=1})()}$1.lintmediatype=function(){var _Sc=$g($1.aidcmediatype,$k[--$j])!==undefined;if(!_Sc){$j--;$k[$j++]="bwipp.GS1UnknownMediaType#3164";$k[$j++]="Unknown AIDC media type";$k[$j++]=false;return true}};if(!$1.dontlint){$k[$j++]=true;for(var _Sg=0,_Sf=$1.vals.length-1;_Sg<=_Sf;_Sg+=1){$1.ai=$g($1.ais,_Sg);$1.val=$g($1.vals,_Sg);var _Sn=$g($1.gs1syntax,$1.ai)!==undefined;if(_Sn){var _Sr=$g($g($1.gs1syntax,$1.ai),"parts");$k[$j++]=_Sr;$k[$j++]=0;$F(_Sr,function(){var _Ss=$k[--$j];$k[$j++]=_Ss;if($g(_Ss,"opt")){$j--;$k[$j++]=0}else{var _Sv=$g($k[--$j],"min");$k[$j++]=_Sv}var _Sw=$k[--$j];var _Sx=$k[--$j];$k[$j++]=$f(_Sx+_Sw)});if($k[--$j]>$1.val.length){$j--;$k[$j++]="bwipp.GS1valueTooShort#3178";$k[$j++]="Too short";$k[$j++]=false;break}var _T0=$k[--$j];$k[$j++]=_T0;$k[$j++]=0;$F(_T0,function(){var _T2=$g($k[--$j],"max");var _T3=$k[--$j];$k[$j++]=$f(_T3+_T2)});if($k[--$j]<$1.val.length){$j--;$k[$j++]="bwipp.GS1valueTooLong#3181";$k[$j++]="Too long";$k[$j++]=false;break}$F($k[--$j],function(){$1.props=$k[--$j];var _T9=$g($1.props,"max");var _TA=$1.val;var _TB=_TA.length;if(_T9>_TA.length){var _=_TB;_TB=_T9;_T9=_}$1.eval=$G($1.val,0,_T9);var _TG=$1.eval.length;$1.val=$G($1.val,_TG,$1.val.length-_TG);if($1.eval.length==0){if($nt($g($1.props,"opt"))){$j--;$k[$j++]="bwipp.GS1valueTooShort#3190";$k[$j++]="Too short";$k[$j++]=false;return true}}else{if($1.eval.length<$g($1.props,"min")){$j--;$k[$j++]="bwipp.GS1valueTooShort#3194";$k[$j++]="Too short";$k[$j++]=false;return true}var _TP=new Map([["N","lintnumeric"],["X","lintcset82"],["Y","lintcset39"]]);$k[$j++]=$1.eval;if($1[$g(_TP,$g($1.props,"cset"))]()===true){return true}$F($g($1.props,"linters"),function(){var _TZ=$1[$k[--$j]];$k[$j++]=$1.eval;if(_TZ()===true){return true}})}});var _Ta=$k[--$j];$k[$j++]=_Ta;if($nt(_Ta)){break}if($1.val.length!=0){$j--;$k[$j++]="bwipp.GS1valueTooLong#3202";$k[$j++]="Too long";$k[$j++]=false;break}}else{$j--;$k[$j++]="bwipp.GS1unknownAI#3205";$k[$j++]="Unrecognised AI";$k[$j++]=false;break}}if($nt($k[--$j])){var _Td=$k[--$j];var _Tf=$s(_Td.length+$1.ai.length+5);$P(_Tf,0,"AI ");$P(_Tf,3,$1.ai);$P(_Tf,3+$1.ai.length,": ");$P(_Tf,5+$1.ai.length,_Td);$k[$j++]=_Tf;bwipp_raiseerror()}$1.aiexists=function(){$1.this=$k[--$j];$1.patt=$k[--$j];for(var _Tl=0,_Tm=1;_Tl<_Tm;_Tl++){var _Tp=$g($1.aivals,$1.patt)!==undefined;if(_Tp){$k[$j++]=true;break}if($1.patt.length==4){if($eq($G($1.patt,3,1),"n")){var _Tv=$eq($G($1.patt,2,1),"n")?2:3;$1.pfxlen=_Tv;var _Tw=$1.ais;$k[$j++]=false;for(var _Tx=0,_Ty=_Tw.length;_Tx<_Ty;_Tx++){var _Tz=$g(_Tw,_Tx);$k[$j++]=_Tz;if($ne(_Tz,$1.this)&&_Tz.length==4){if($eq($G($k[--$j],0,$1.pfxlen),$G($1.patt,0,$1.pfxlen))){$j--;$k[$j++]=true}}else{$j--}}break}$k[$j++]=false;break}$k[$j++]=false;break}};var _U7=$1.vals;$1.aivals=new Map;for(var _UA=0,_U9=$1.vals.length-1;_UA<=_U9;_UA+=1){$1.ai=$g($1.ais,_UA);$1.val=$g($1.vals,_UA);var _UH=$g($1.aivals,$1.ai)!==undefined;if(_UH){if($ne($g($1.aivals,$1.ai),$1.val)){var _UN=$s($1.ai.length+40);$P(_UN,0,"Repeated AIs (");$P(_UN,14,$1.ai);$P(_UN,14+$1.ai.length,") must have the same value");$k[$j++]="bwipp.GS1repeatedDifferingAIs#3255";$k[$j++]=_UN;bwipp_raiseerror()}}else{$p($1.aivals,$1.ai,$1.val)}}for(var _UV=0,_UU=$1.vals.length-1;_UV<=_UU;_UV+=1){$1.ai=$g($1.ais,_UV);var _Ua=$g($1.gs1syntax,$1.ai);var _Ub=$g(_Ua,"ex")!==undefined;$k[$j++]=_Ua;$k[$j++]="ex";if(_Ub){var _Uc=$k[--$j];$F($g($k[--$j],_Uc),function(){$1.patt=$k[--$j];$k[$j++]=$1.patt;$k[$j++]=$1.ai;$1.aiexists();if($k[--$j]){var _Ul=$s($1.ai.length+$1.patt.length+36);$P(_Ul,0,"AIs (");$P(_Ul,5,$1.ai);$P(_Ul,5+$1.ai.length,") and (");$P(_Ul,12+$1.ai.length,$1.patt);$P(_Ul,12+$1.ai.length+$1.patt.length,") are mutually exclusive");$k[$j++]="bwipp.GS1exclusiveAIs#3275";$k[$j++]=_Ul;bwipp_raiseerror()}})}else{$j-=2}if($1.lintreqs){var _Uv=$g($1.gs1syntax,$1.ai);var _Uw=$g(_Uv,"req")!==undefined;$k[$j++]=_Uv;$k[$j++]="req";if(_Uw){var _Ux=$k[--$j];$F($g($k[--$j],_Ux),function(){var _V0=$k[--$j];$k[$j++]=false;$F(_V0,function(){$k[$j++]=$1.ai;$1.aiexists();if($k[--$j]){$j--;$k[$j++]=true}});if($nt($k[--$j])){var _V5=$s($1.ai.length+47);$P(_V5,0,"One of more requisite AIs for AI (");$P(_V5,34,$1.ai);$P(_V5,34+$1.ai.length,") are missing");$k[$j++]="bwipp.GS1missingAIs#3292";$k[$j++]=_V5;bwipp_raiseerror()}})}else{$j-=2}}}}$k[$j++]=$1.ais;$k[$j++]=$1.vals;$k[$j++]=$1.fncs}function bwipp_renmatrix(){if($0.bwipjs_dontdraw){return}var $1=Object.create(bwipp_renmatrix.$ctx||(bwipp_renmatrix.$ctx={}));$1.width=1;$1.height=1;$1.barcolor="unset";$1.backgroundcolor="unset";$1.colormap="unset";$1.dotty=false;$1.inkspread=0;$1.inkspreadh=0;$1.inkspreadv=0;$1.includetext=false;$1.txt=$a([]);$1.textcolor="unset";$1.textxalign="unset";$1.textyalign="unset";$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=0;$1.textgaps=0;$1.alttext="";$F($k[--$j],function(){var _3=$k[--$j];$1[$k[--$j]]=_3});$k[$j++]=$1.opt;delete $1["opt"];$k[$j++]=$1;bwipp_processoptions();$j--;if($1.inkspread!=0){$1.inkspreadh=$1.inkspread}if($1.inkspread!=0){$1.inkspreadv=$1.inkspread}if($1.textsize<=0){$k[$j++]="bwipp.renmatrixBadTextsize#3602";$k[$j++]="The font size must be greater than zero";bwipp_raiseerror()}$1.xyget=function(){var _C=$k[--$j];var _F=$g($1.pixs,$f($k[--$j]+_C*$1.pixx));$k[$j++]=_F};$1.cget=function(){var _H=$k[--$j];var _K=$g($1.cache,$f($k[--$j]+_H*$1.pixx));var _L=$k[--$j];$k[$j++]=$an(_L,_K)};$1.cput=function(){var _M=$k[--$j];$k[$j++]=_M;if(_M%4==0){var _N=$k[--$j];var _O=$k[--$j];var _P=$k[--$j];var _Q=$1.pixx;var _R=$1.cache;$p(_R,$f(_P+_O*_Q),$or($g(_R,$f(_P+_O*_Q)),_N))}else{$j-=3}};$1.abcd=function(){$k[$j++]=$s(4);$k[$j++]=0;$k[$j++]=Infinity;var _U=$k[--$j];var _V=$k[--$j];var _W=$k[--$j];var _X=$k[--$j];var _a=$f($k[--$j]+_X*$1.pixx);$k[$j++]=_W;$k[$j++]=_V;$k[$j++]=_U;$k[$j++]=_a;$q($G($1.pixs,_a,2));var _d=$k[--$j];var _e=$k[--$j];var _i=$G($1.pixs,$f($k[--$j]+$1.pixx),2);$k[$j++]=_e;$k[$j++]=_d;$q(_i);var _j=$a();for(var _k=0,_l=_j.length;_k<_l;_k++){var _n=$k[--$j];var _o=$k[--$j];$p(_o,_n,$f($g(_j,_k)+48));$k[$j++]=_o;$k[$j++]=$f(_n+1)}$j--};$1.right=function(){if($1.dir!=1){$k[$j++]=$1.x;$k[$j++]=$1.y;$k[$j++]=$1.dir;$1.cput();$k[$j++]=$a([$1.x,$1.y])}$1.x=$1.x+1;$1.dir=1};$1.down=function(){if($1.dir!=2){$k[$j++]=$1.x;$k[$j++]=$1.y;$k[$j++]=$1.dir;$1.cput();$k[$j++]=$a([$1.x,$1.y])}$1.y=$1.y+1;$1.dir=2};$1.left=function(){if($1.dir!=4){$k[$j++]=$1.x;$k[$j++]=$1.y;$k[$j++]=$1.dir;$1.cput();$k[$j++]=$a([$1.x,$1.y])}$1.x=$1.x-1;$1.dir=4};$1.up=function(){if($1.dir!=8){$k[$j++]=$1.x;$k[$j++]=$1.y;$k[$j++]=$1.dir;$1.cput();$k[$j++]=$a([$1.x,$1.y])}$1.y=$1.y-1;$1.dir=8};$1.trace=function(){$1.y=$k[--$j];$1.x=$k[--$j];$k[$j++]="dir";$k[$j++]=$f($1.x+1);$k[$j++]=$f($1.y+1);$1.xyget();var _1Q=$k[--$j]==1?8:4;$1[$k[--$j]]=_1Q;$1.sx=$1.x;$1.sy=$1.y;$1.sdir=$1.dir;$k[$j++]=Infinity;for(;;){$k[$j++]=$1.x;$k[$j++]=$1.y;$1.abcd();for(var _1X=0,_1Y=1;_1X<_1Y;_1X++){var _1Z=$k[--$j];$k[$j++]=_1Z;if($eq(_1Z,"0001")||($eq(_1Z,"0011")||$eq(_1Z,"1011"))){$j--;$1.right();break}var _1a=$k[--$j];$k[$j++]=_1a;if($eq(_1a,"0010")||($eq(_1a,"1010")||$eq(_1a,"1110"))){$j--;$1.down();break}var _1b=$k[--$j];$k[$j++]=_1b;if($eq(_1b,"1000")||($eq(_1b,"1100")||$eq(_1b,"1101"))){$j--;$1.left();break}var _1c=$k[--$j];$k[$j++]=_1c;if($eq(_1c,"0100")||($eq(_1c,"0101")||$eq(_1c,"0111"))){$j--;$1.up();break}var _1d=$k[--$j];$k[$j++]=_1d;if($eq(_1d,"1001")){if($1.dir==2){$j--;$1.left();break}else{$j--;$1.right();break}}else{if($1.dir==1){$j--;$1.down();break}else{$j--;$1.up();break}}}if($eq($1.x,$1.sx)&&$eq($1.y,$1.sy)&&$1.dir==$1.sdir){break}}$as($a($m()));var _1o=$k[--$j];var _1p=$k[--$j];$k[$j++]=_1o;$k[$j++]=_1p;$j--};$1.drawlayer=function(){$1.pixsorig=$1.pixs;$1.pixs=$k[--$j];$k[$j++]=Infinity;for(var _1t=0,_1u=$1.pixx+2;_1t<_1u;_1t++){$k[$j++]=0}for(var _1y=0,_1z=$1.pixx,_1x=$1.pixs.length-1;_1z<0?_1y>=_1x:_1y<=_1x;_1y+=_1z){$k[$j++]=0;$q($G($1.pixs,_1y,$1.pixx));$k[$j++]=0}for(var _24=0,_25=$1.pixx+2;_24<_25;_24++){$k[$j++]=0}$1.pixs=$a();$1.pixx=$1.pixx+2;$1.pixy=$1.pixy+2;$k[$j++]=Infinity;for(var _2A=0,_2B=$1.pixs.length;_2A<_2B;_2A++){$k[$j++]=0}$1.cache=$a();$k[$j++]=Infinity;for(var _2F=0,_2E=$1.pixy-2;_2F<=_2E;_2F+=1){$1.j=_2F;for(var _2I=0,_2H=$1.pixx-2;_2I<=_2H;_2I+=1){$1.i=_2I;$k[$j++]="k";$k[$j++]=$1.i;$k[$j++]=$1.j;$1.abcd();var _2L=$k[--$j];$1[$k[--$j]]=_2L;if($eq($1.k,"0001")||$eq($1.k,"1001")){$k[$j++]=8;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.cget();if($k[--$j]==0){$k[$j++]=$1.i;$k[$j++]=$1.j;$1.trace()}}if($eq($1.k,"1110")){$k[$j++]=4;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.cget();if($k[--$j]==0){$k[$j++]=$1.i;$k[$j++]=$1.j;$1.trace()}}}}$1.paths=$a();$1.pixx=$1.pixx-2;$1.pixy=$1.pixy-2;$$.newpath();var _2d=$1.paths;for(var _2e=0,_2f=_2d.length;_2e<_2f;_2e++){$1.p=$g(_2d,_2e);$1.len=$1.p.length;$q($g($1.p,$1.len-1));$q($g($1.p,0));for(var _2p=0,_2o=$1.len-1;_2p<=_2o;_2p+=1){$1.i=_2p;$q($g($1.p,($1.i+1)%$1.len));var _2u=$k[--$j];var _2v=$k[--$j];var _2w=$k[--$j];var _2x=$k[--$j];var _2y=$k[--$j];var _2z=$k[--$j];$k[$j++]=_2x;$k[$j++]=_2w;$k[$j++]=_2v;$k[$j++]=_2u;$k[$j++]=_2z;$k[$j++]=_2x;$k[$j++]=$1.inkspreadh;if($lt(_2u,_2y)){var _31=$k[--$j];var _32=$k[--$j];$k[$j++]=$f(_32+_31)}else{var _33=$k[--$j];var _34=$k[--$j];$k[$j++]=$f(_34-_33)}var _35=$k[--$j];var _36=$k[--$j];var _37=$k[--$j];var _38=$k[--$j];var _39=$k[--$j];$k[$j++]=_39;$k[$j++]=_35;$k[$j++]=_38;$k[$j++]=_37;$k[$j++]=_39;$k[$j++]=$1.inkspreadv;if($gt(_38,_36)){var _3B=$k[--$j];var _3C=$k[--$j];$k[$j++]=$f(_3C+_3B)}else{var _3D=$k[--$j];var _3E=$k[--$j];$k[$j++]=$f(_3E-_3D)}var _3F=$k[--$j];var _3G=$k[--$j];var _3H=$k[--$j];var _3I=$k[--$j];$k[$j++]=_3H;$k[$j++]=_3G;$k[$j++]=_3I;$k[$j++]=$f($1.pixy-_3F);if($1.i==0){var _3L=$k[--$j];$$.moveto($k[--$j],_3L)}else{var _3N=$k[--$j];$$.lineto($k[--$j],_3N)}}$$.closepath();$j-=4}$$.fill();$1.pixs=$1.pixsorig};$1.drawlayerdots=function(){$1.pixsorig=$1.pixs;$1.pixs=$k[--$j];$$.newpath();for(var _3U=0,_3T=$1.pixs.length-1;_3U<=_3T;_3U+=1){$1.x=_3U%$1.pixx;$1.y=~~(_3U/$1.pixx);$k[$j++]=$1.x;$k[$j++]=$1.y;$1.xyget();if($k[--$j]==1){$$.moveto($f($1.x+.5),$f($1.pixy-$1.y-.5));$$.arc($f($1.x+.5),$f($1.pixy-$1.y-.5),$f(.5-$1.inkspread),0,360,1)}}$$.fill();$1.pixs=$1.pixsorig};$$.save();$1.inkspread=$1.inkspread/2;$1.inkspreadh=$1.inkspreadh/2;$1.inkspreadv=$1.inkspreadv/2;var _3l=$$.currpos();$$.translate(_3l.x,_3l.y);$$.scale($1.width/$1.pixx*72,$1.height/$1.pixy*72);$$.moveto(0,0);$$.lineto($1.pixx,0);$$.lineto($1.pixx,$1.pixy);$$.lineto(0,$1.pixy);$$.closepath();if($eq($1.colormap,"unset")){var _3w=new Map([[1,$1.barcolor]]);$1.colormap=_3w}var _3x=$1.colormap;for(var _42=_3x.size,_41=_3x.keys(),_40=0;_40<_42;_40++){var _3y=_41.next().value;var _3z=_3x.get(_3y);$k[$j++]=_3y;$k[$j++]=_3z;if($ne(_3z,"unset")){$$.setcolor($k[--$j])}else{$j--}$1.key=$k[--$j];$k[$j++]=Infinity;var _45=$1.pixs;for(var _46=0,_47=_45.length;_46<_47;_46++){var _4A=$eq($g(_45,_46),$1.key)?1:0;$k[$j++]=_4A}var _4B=$a();$k[$j++]=_4B;if($1.dotty){$1.drawlayerdots()}else{$1.drawlayer()}}if($ne($1.textcolor,"unset")){$$.setcolor($1.textcolor)}if($1.includetext){if($eq($1.textxalign,"unset")&&$eq($1.textyalign,"unset")&&$eq($1.alttext,"")){$1.s=0;$1.fn="";var _4J=$1.txt;for(var _4K=0,_4L=_4J.length;_4K<_4L;_4K++){$F($g(_4J,_4K));var _4N=$k[--$j];var _4O=$k[--$j];$k[$j++]=_4O;$k[$j++]=_4N;if(_4N!=$1.s||$ne(_4O,$1.fn)){var _4R=$k[--$j];$k[$j++]=_4R;if(_4R<=0){$j-=5;$k[$j++]="bwipp.renmatrixFontTooSmall#3803";$k[$j++]="The font size is too small";bwipp_raiseerror()}var _4S=$k[--$j];var _4T=$k[--$j];$1.s=_4S;$1.fn=_4T;$$.selectfont(_4T,_4S)}else{$j-=2}var _4U=$k[--$j];$$.moveto($k[--$j],_4U);$$.show($k[--$j],0,0)}}else{$$.selectfont($1.textfont,$1.textsize);if($eq($1.alttext,"")){$k[$j++]=Infinity;var _4a=$1.txt;for(var _4b=0,_4c=_4a.length;_4b<_4c;_4b++){$F($g($g(_4a,_4b),0))}$1.txt=$a();$1.tstr=$s($1.txt.length);for(var _4k=0,_4j=$1.txt.length-1;_4k<=_4j;_4k+=1){$p($1.tstr,_4k,$g($1.txt,_4k))}}else{$1.tstr=$1.alttext}if($1.tstr.length==0){$k[$j++]=0}else{$$.save();$$.newpath();$$.moveto(0,0);$$.charpath("0",false);var _4q=$$.pathbbox();$$.restore();$k[$j++]=_4q.ury}$1.textascent=$k[--$j];var _4t=$$.stringwidth($1.tstr);$1.textwidth=$f(_4t.w+($1.tstr.length-1)*$1.textgaps);$1.textxpos=$f($1.textxoffset+$f($1.pixx-$1.textwidth)/2);if($eq($1.textxalign,"left")){$1.textxpos=$1.textxoffset}if($eq($1.textxalign,"right")){$1.textxpos=$f($1.pixx-$1.textxoffset-$1.textwidth)}if($eq($1.textxalign,"offleft")){$1.textxpos=-$f($1.textwidth+$1.textxoffset)}if($eq($1.textxalign,"offright")){$1.textxpos=$1.pixx+$1.textxoffset}if($eq($1.textxalign,"justify")&&$1.textwidth<$1.pixx){$1.textxpos=0;$1.textgaps=$f($1.pixx-$1.textwidth)/($1.tstr.length-1)}$1.textypos=-$f($f($1.textyoffset+$1.textascent)+1);if($eq($1.textyalign,"above")){$1.textypos=$1.textyoffset+$1.pixy+1}if($eq($1.textyalign,"center")){$1.textypos=$f($1.textyoffset+$f($1.pixy-$1.textascent)/2)}$$.moveto($1.textxpos,$1.textypos);$$.show($1.tstr,$1.textgaps,0)}}$$.restore()}function bwipp_ean5(){var $1=Object.create(bwipp_ean5.$ctx||(bwipp_ean5.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=12;$1.textxoffset=0;$1.textyoffset=null;$1.height=.7;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.textyoffset,null)){$1.textyoffset=$f($1.height*72+1)}if($1.barcode.length!=5){$k[$j++]="bwipp.ean5badLength#4003";$k[$j++]="EAN-5 add-on must be 5 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _6=$k[--$j];if(_6<48||_6>57){$k[$j++]="bwipp.ean5badCharacter#4007";$k[$j++]="EAN-5 add-on must contain only digits";bwipp_raiseerror()}});if(!bwipp_ean5.__4027__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","112","11"]);$ctx.barchars="0123456789";$ctx.mirrormaps=$a(["11000","10100","10010","10001","01100","00110","00011","01010","01001","00101"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ean5.$ctx[id]=$ctx[id]);bwipp_ean5.__4027__=1})()}$1.checksum=0;for(var _A=0;_A<=4;_A+=1){$1.i=_A;$1.barchar=$f($g($1.barcode,$1.i)-48);if($1.i%2==0){$1.checksum=$f($1.barchar*3+$1.checksum)}else{$1.checksum=$f($1.barchar*9+$1.checksum)}}$1.checksum=$1.checksum%10;$1.mirrormap=$g($1.mirrormaps,$1.checksum);$1.sbs=$s(31);$1.txt=$a(5);for(var _P=0;_P<=4;_P+=1){$1.i=_P;if($1.i==0){$P($1.sbs,0,$g($1.encs,10))}else{$P($1.sbs,($1.i-1)*6+7,$g($1.encs,11))}$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);if($g($1.mirrormap,$1.i)==49){$1.enclen=$1.enc.length;$1.revenc=$s($1.enclen);for(var _o=0,_n=$1.enclen-1;_o<=_n;_o+=1){$1.j=_o;$1.char=$g($1.enc,$1.j);$p($1.revenc,$1.enclen-$1.j-1,$1.char)}$1.enc=$1.revenc}$P($1.sbs,$1.i*6+3,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i-1)*9+13+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _1B=$1.sbs;for(var _1C=0,_1D=_1B.length;_1C<_1D;_1C++){$k[$j++]=$g(_1B,_1C)-48}var _1F=$a();$k[$j++]=Infinity;for(var _1G=0,_1H=16;_1G<_1H;_1G++){$k[$j++]=$1.height}var _1J=$a();$k[$j++]=Infinity;for(var _1K=0,_1L=16;_1K<_1L;_1K++){$k[$j++]=0}var _1M=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_1F;$k[$j++]="bhs";$k[$j++]=_1J;$k[$j++]="bbs";$k[$j++]=_1M;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;$k[$j++]="guardrightpos";$k[$j++]=10;$k[$j++]="guardrightypos";$k[$j++]=$f($1.textyoffset+4);$k[$j++]="bordertop";$k[$j++]=10;var _1R=$d();$k[$j++]=_1R;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_ean2(){var $1=Object.create(bwipp_ean2.$ctx||(bwipp_ean2.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=12;$1.textxoffset=0;$1.textyoffset=null;$1.height=.7;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.textyoffset,null)){$1.textyoffset=$f($1.height*72+1)}if($1.barcode.length!=2){$k[$j++]="bwipp.ean2badLength#4146";$k[$j++]="EAN-2 add-on must be 2 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _6=$k[--$j];if(_6<48||_6>57){$k[$j++]="bwipp.ean2badCharacter#4150";$k[$j++]="EAN-2 add-on must contain only digits";bwipp_raiseerror()}});if(!bwipp_ean2.__4167__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","112","11"]);$ctx.barchars="0123456789";$ctx.mirrormaps=$a(["00","01","10","11"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ean2.$ctx[id]=$ctx[id]);bwipp_ean2.__4167__=1})()}$1.mirrormap=$g($1.mirrormaps,$i($G($1.barcode,0,2))%4);$1.sbs=$s(13);$1.txt=$a(2);for(var _G=0;_G<=1;_G+=1){$1.i=_G;if($1.i==0){$P($1.sbs,0,$g($1.encs,10))}else{$P($1.sbs,($1.i-1)*6+7,$g($1.encs,11))}$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);if($g($1.mirrormap,$1.i)==49){$1.enclen=$1.enc.length;$1.revenc=$s($1.enclen);for(var _f=0,_e=$1.enclen-1;_f<=_e;_f+=1){$1.j=_f;$1.char=$g($1.enc,$1.j);$p($1.revenc,$1.enclen-$1.j-1,$1.char)}$1.enc=$1.revenc}$P($1.sbs,$1.i*6+3,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i-1)*9+13+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _12=$1.sbs;for(var _13=0,_14=_12.length;_13<_14;_13++){$k[$j++]=$g(_12,_13)-48}var _16=$a();$k[$j++]=Infinity;for(var _17=0,_18=12;_17<_18;_17++){$k[$j++]=$1.height}var _1A=$a();$k[$j++]=Infinity;for(var _1B=0,_1C=12;_1B<_1C;_1B++){$k[$j++]=0}var _1D=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_16;$k[$j++]="bhs";$k[$j++]=_1A;$k[$j++]="bbs";$k[$j++]=_1D;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;$k[$j++]="guardrightpos";$k[$j++]=10;$k[$j++]="guardrightypos";$k[$j++]=$f($1.textyoffset+4);$k[$j++]="bordertop";$k[$j++]=10;var _1I=$d();$k[$j++]=_1I;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_ean13(){var $1=Object.create(bwipp_ean13.$ctx||(bwipp_ean13.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=12;$1.textxoffset=-10;$1.textyoffset=-4;$1.height=1;$1.addongap=12;$1.addontextfont="unset";$1.addontextsize=null;$1.addontextxoffset=null;$1.addontextyoffset=null;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$X($1.barcode," ");if($k[--$j]){$1.barcode=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.barcode.length!=12&&$1.barcode.length!=13){$k[$j++]="bwipp.ean13badLength#4288";$k[$j++]="EAN-13 must be 12 or 13 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.ean13badCharacter#4292";$k[$j++]="EAN-13 must contain only digits";bwipp_raiseerror()}});if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.ean13badAddOnLength#4296";$k[$j++]="Add-on for EAN-13 must be 2 or 5 digits";bwipp_raiseerror()}$1.pad=$s(13);$1.checksum=0;for(var _E=0;_E<=11;_E+=1){$1.i=_E;$1.barchar=$f($g($1.barcode,$1.i)-48);if($1.i%2==0){$1.checksum=$f($1.barchar+$1.checksum)}else{$1.checksum=$f($1.barchar*3+$1.checksum)}}$1.checksum=$f(10-$1.checksum%10)%10;if($1.barcode.length==13){if($g($1.barcode,12)!=$f($1.checksum+48)){$k[$j++]="bwipp.ean13badCheckDigit#4314";$k[$j++]="Incorrect EAN-13 check digit provided";bwipp_raiseerror()}}$P($1.pad,0,$1.barcode);$p($1.pad,12,$f($1.checksum+48));$1.barcode=$1.pad;if(!bwipp_ean13.__4337__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","11111","111"]);$ctx.barchars="0123456789";$ctx.mirrormaps=$a(["000000","001011","001101","001110","010011","011001","011100","010101","010110","011010"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ean13.$ctx[id]=$ctx[id]);bwipp_ean13.__4337__=1})()}$1.sbs=$s(59);$1.txt=$a(13);$P($1.sbs,0,$g($1.encs,10));$1.mirrormap=$g($1.mirrormaps,$g($1.barcode,0)-48);$p($1.txt,0,$a([$G($1.barcode,0,1),$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]));for(var _r=1;_r<=6;_r+=1){$1.i=_r;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);if($g($1.mirrormap,$1.i-1)==49){$1.enclen=$1.enc.length;$1.revenc=$s($1.enclen);for(var _18=0,_17=$1.enclen-1;_18<=_17;_18+=1){$1.j=_18;$1.char=$g($1.enc,$1.j);$p($1.revenc,$1.enclen-$1.j-1,$1.char)}$1.enc=$1.revenc}$P($1.sbs,($1.i-1)*4+3,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i-1)*7+14+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,(7-1)*4+3,$g($1.encs,11));for(var _1Y=7;_1Y<=12;_1Y+=1){$1.i=_1Y;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,($1.i-1)*4+8,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i-1)*7+18+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,56,$g($1.encs,12));$k[$j++]=Infinity;var _1y=$1.sbs;for(var _1z=0,_20=_1y.length;_1z<_20;_1z++){$k[$j++]=$g(_1y,_1z)-48}$1.sbs=$a();if($1.includetext){$k[$j++]=Infinity;$k[$j++]=$1.height;$k[$j++]=$1.height;for(var _26=0,_27=12;_26<_27;_26++){$k[$j++]=$f($1.height-.075)}$k[$j++]=$1.height;$k[$j++]=$1.height;for(var _2B=0,_2C=12;_2B<_2C;_2B++){$k[$j++]=$f($1.height-.075)}$k[$j++]=$1.height;$k[$j++]=$1.height;$1.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;for(var _2H=0,_2I=12;_2H<_2I;_2H++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;for(var _2J=0,_2K=12;_2J<_2K;_2J++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$1.bbs=$a()}else{$k[$j++]=Infinity;for(var _2M=0,_2N=30;_2M<_2N;_2M++){$k[$j++]=$1.height}$1.bhs=$a();$k[$j++]=Infinity;for(var _2Q=0,_2R=30;_2Q<_2R;_2Q++){$k[$j++]=0}$1.bbs=$a();$1.txt=$a([])}$1.guardrightypos=0;if($ne($1.addon,"")){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$f($1.height-.15);$k[$j++]="textxoffset";if($ne($1.addontextxoffset,null)){$k[$j++]=$1.addontextxoffset}else{$k[$j++]=95+$1.addongap}if($ne($1.addontextyoffset,null)){$k[$j++]="textyoffset";$k[$j++]=$1.addontextyoffset}$k[$j++]="textsize";if($ne($1.addontextsize,null)){$k[$j++]=$1.addontextsize}else{$k[$j++]=$1.textsize}var _2f=$ne($1.addontextfont,"unset")?$1.addontextfont:$1.textfont;$k[$j++]="textfont";$k[$j++]=_2f;$1.addopts=$d();if($1.addon.length==2){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean2()}if($1.addon.length==5){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean5()}$1.addcode=$k[--$j];$k[$j++]=Infinity;$q($1.sbs);$k[$j++]=$1.addongap;$q($g($1.addcode,"sbs"));$1.sbs=$a();$k[$j++]=Infinity;$q($1.bhs);$F($g($1.addcode,"bhs"),function(){var _2w=$k[--$j];$k[$j++]=$f(_2w-.075)});$1.bhs=$a();$k[$j++]=Infinity;$q($1.bbs);$F($g($1.addcode,"bbs"),function(){var _31=$k[--$j];$k[$j++]=$f(_31+.075)});$1.bbs=$a();$k[$j++]=Infinity;$q($1.txt);$q($g($1.addcode,"txt"));$1.txt=$a();$1.guardrightypos=$1.height*72-6}var _3E=new Map([["ren",bwipp_renlinear],["sbs",$1.sbs],["bhs",$1.bhs],["bbs",$1.bbs],["txt",$1.txt],["opt",$1.options],["guardrightpos",10],["guardrightypos",$1.guardrightypos],["borderbottom",5]]);$k[$j++]=_3E;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_ean8(){var $1=Object.create(bwipp_ean8.$ctx||(bwipp_ean8.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=12;$1.textxoffset=4;$1.textyoffset=-4;$1.height=1;$1.addongap=12;$1.addontextfont="unset";$1.addontextsize=null;$1.addontextxoffset=null;$1.addontextyoffset=null;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$X($1.barcode," ");if($k[--$j]){$1.barcode=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.barcode.length!=7&&$1.barcode.length!=8){$k[$j++]="bwipp.ean8badLength#4505";$k[$j++]="EAN-8 must be 7 or 8 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.ean8badCharacter#4509";$k[$j++]="EAN-8 must contain only digits";bwipp_raiseerror()}});if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.ean8badAddOnLength#4513";$k[$j++]="Add-on for EAN-8 must be 2 or 5 digits";bwipp_raiseerror()}$1.pad=$s(8);$1.checksum=0;for(var _E=0;_E<=6;_E+=1){$1.i=_E;$1.barchar=$f($g($1.barcode,$1.i)-48);if($1.i%2!=0){$1.checksum=$f($1.barchar+$1.checksum)}else{$1.checksum=$f($1.barchar*3+$1.checksum)}}$1.checksum=$f(10-$1.checksum%10)%10;if($1.barcode.length==8){if($g($1.barcode,7)!=$f($1.checksum+48)){$k[$j++]="bwipp.ean8badCheckDigit#4531";$k[$j++]="Incorrect EAN-8 check digit provided";bwipp_raiseerror()}}$P($1.pad,0,$1.barcode);$p($1.pad,7,$f($1.checksum+48));$1.barcode=$1.pad;if(!bwipp_ean8.__4548__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","11111","111"]);$ctx.barchars="0123456789";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ean8.$ctx[id]=$ctx[id]);bwipp_ean8.__4548__=1})()}$1.sbs=$s(43);$1.txt=$a(8);$P($1.sbs,0,$g($1.encs,10));for(var _e=0;_e<=3;_e+=1){$1.i=_e;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*4+3,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*7+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,4*4+3,$g($1.encs,11));for(var _14=4;_14<=7;_14+=1){$1.i=_14;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*4+8,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*7+$1.textxoffset+4,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,40,$g($1.encs,12));$k[$j++]=Infinity;var _1U=$1.sbs;for(var _1V=0,_1W=_1U.length;_1V<_1W;_1V++){$k[$j++]=$g(_1U,_1V)-48}$1.sbs=$a();if($1.includetext){$k[$j++]=Infinity;$k[$j++]=$1.height;$k[$j++]=$1.height;for(var _1c=0,_1d=8;_1c<_1d;_1c++){$k[$j++]=$f($1.height-.075)}$k[$j++]=$1.height;$k[$j++]=$1.height;for(var _1h=0,_1i=8;_1h<_1i;_1h++){$k[$j++]=$f($1.height-.075)}$k[$j++]=$1.height;$k[$j++]=$1.height;$1.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;for(var _1n=0,_1o=8;_1n<_1o;_1n++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;for(var _1p=0,_1q=8;_1p<_1q;_1p++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$1.bbs=$a()}else{$k[$j++]=Infinity;for(var _1s=0,_1t=22;_1s<_1t;_1s++){$k[$j++]=$1.height}$1.bhs=$a();$k[$j++]=Infinity;for(var _1w=0,_1x=22;_1w<_1x;_1w++){$k[$j++]=0}$1.bbs=$a();$1.txt=$a([])}$1.guardrightypos=0;if($ne($1.addon,"")){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$f($1.height-.15);$k[$j++]="textxoffset";if($ne($1.addontextxoffset,null)){$k[$j++]=$1.addontextxoffset}else{$k[$j++]=67+$1.addongap}if($ne($1.addontextyoffset,null)){$k[$j++]="textyoffset";$k[$j++]=$1.addontextyoffset}$k[$j++]="textsize";if($ne($1.addontextsize,null)){$k[$j++]=$1.addontextsize}else{$k[$j++]=$1.textsize}var _2B=$ne($1.addontextfont,"unset")?$1.addontextfont:$1.textfont;$k[$j++]="textfont";$k[$j++]=_2B;$1.addopts=$d();if($1.addon.length==2){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean2()}if($1.addon.length==5){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean5()}$1.addcode=$k[--$j];$k[$j++]=Infinity;$q($1.sbs);$k[$j++]=$1.addongap;$q($g($1.addcode,"sbs"));$1.sbs=$a();$k[$j++]=Infinity;$q($1.bhs);$F($g($1.addcode,"bhs"),function(){var _2S=$k[--$j];$k[$j++]=$f(_2S-.075)});$1.bhs=$a();$k[$j++]=Infinity;$q($1.bbs);$F($g($1.addcode,"bbs"),function(){var _2X=$k[--$j];$k[$j++]=$f(_2X+.075)});$1.bbs=$a();$k[$j++]=Infinity;$q($1.txt);$q($g($1.addcode,"txt"));$1.txt=$a();$1.guardrightypos=$1.height*72-6}var _2k=new Map([["ren",bwipp_renlinear],["sbs",$1.sbs],["bhs",$1.bhs],["bbs",$1.bbs],["txt",$1.txt],["opt",$1.options],["guardleftpos",10],["guardrightpos",10],["guardrightypos",$1.guardrightypos],["borderbottom",5]]);$k[$j++]=_2k;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_upca(){var $1=Object.create(bwipp_upca.$ctx||(bwipp_upca.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=12;$1.textxoffset=-7;$1.textyoffset=-4;$1.height=1;$1.addongap=12;$1.addontextfont="unset";$1.addontextsize=null;$1.addontextxoffset=null;$1.addontextyoffset=null;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$X($1.barcode," ");if($k[--$j]){$1.barcode=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.barcode.length==7||$1.barcode.length==8){$F($1.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.upcAupcEbadCharacter#4706";$k[$j++]="UPC-E must contain only digits";bwipp_raiseerror()}});var _B=$g($1.barcode,0);if(_B!=48&&_B!=49){$k[$j++]="bwipp.upcAupcEbadNumberSystem#4710";$k[$j++]="UPC-E must have number system 0 or 1";bwipp_raiseerror()}for(var _C=0,_D=1;_C<_D;_C++){var _F=$1.barcode.length==8?12:11;$1.upcacode=$s(_F);if($f($g($1.barcode,6)-48)<=2){$P($1.upcacode,0,$G($1.barcode,0,3));$P($1.upcacode,3,$G($1.barcode,6,1));$P($1.upcacode,4,"0000");$P($1.upcacode,8,$G($1.barcode,3,3));break}if($f($g($1.barcode,6)-48)==3){$P($1.upcacode,0,$G($1.barcode,0,4));$P($1.upcacode,4,"00000");$P($1.upcacode,9,$G($1.barcode,4,2));break}if($f($g($1.barcode,6)-48)==4){$P($1.upcacode,0,$G($1.barcode,0,5));$P($1.upcacode,5,"00000");$P($1.upcacode,10,$G($1.barcode,5,1));break}if($f($g($1.barcode,6)-48)>=5){$P($1.upcacode,0,$G($1.barcode,0,6));$P($1.upcacode,6,"0000");$P($1.upcacode,10,$G($1.barcode,6,1));break}}if($1.barcode.length==8){$P($1.upcacode,11,$G($1.barcode,7,1))}$1.barcode=$1.upcacode}if($1.barcode.length!=11&&$1.barcode.length!=12){$k[$j++]="bwipp.upcAbadLength#4748";$k[$j++]="UPC-A must be 11 or 12 digits";bwipp_raiseerror()}var _11=$1.barcode;for(var _12=0,_13=_11.length;_12<_13;_12++){var _14=$g(_11,_12);if(_14<48||_14>57){$k[$j++]="bwipp.upcAbadCharacter#4752";$k[$j++]="UPC-A must contain only digits";bwipp_raiseerror()}}if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.upcAbadAddOnLength#4756";$k[$j++]="Add-on for UPC-A must be 2 or 5 digits";bwipp_raiseerror()}$1.pad=$s(12);$1.checksum=0;for(var _19=0;_19<=10;_19+=1){$1.i=_19;$1.barchar=$g($1.barcode,$1.i)-48;if($1.i%2!=0){$1.checksum=$1.checksum+$1.barchar}else{$1.checksum=$1.checksum+$1.barchar*3}}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==12){if($g($1.barcode,11)!=$1.checksum+48){$k[$j++]="bwipp.upcAbadCheckDigit#4774";$k[$j++]="Incorrect UPC check digit provided";bwipp_raiseerror()}}$P($1.pad,0,$1.barcode);$p($1.pad,11,$1.checksum+48);$1.barcode=$1.pad;if(!bwipp_upca.__4791__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","11111","111"]);$ctx.barchars="0123456789";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_upca.$ctx[id]=$ctx[id]);bwipp_upca.__4791__=1})()}$1.sbs=$s(59);$1.txt=$a(12);$P($1.sbs,0,$g($1.encs,10));for(var _1Z=0;_1Z<=5;_1Z+=1){$1.i=_1Z;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*4+3,$1.enc);if($1.i==0){$p($1.txt,0,$a([$G($1.barcode,0,1),$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize-2]))}else{$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*7+11+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}}$P($1.sbs,6*4+3,$g($1.encs,11));for(var _28=6;_28<=11;_28+=1){$1.i=_28;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*4+8,$1.enc);if($1.i==11){$p($1.txt,11,$a([$G($1.barcode,11,1),$1.textxoffset+104,$1.textyoffset,$1.textfont,$1.textsize-2]))}else{$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*7+$1.textxoffset+15,$1.textyoffset,$1.textfont,$1.textsize]))}}$P($1.sbs,56,$g($1.encs,12));$k[$j++]=Infinity;var _2h=$1.sbs;for(var _2i=0,_2j=_2h.length;_2i<_2j;_2i++){$k[$j++]=$g(_2h,_2i)-48}$1.sbs=$a();if($1.includetext){$k[$j++]=Infinity;for(var _2n=0,_2o=4;_2n<_2o;_2n++){$k[$j++]=$1.height}for(var _2q=0,_2r=10;_2q<_2r;_2q++){$k[$j++]=$f($1.height-.075)}$k[$j++]=$1.height;$k[$j++]=$1.height;for(var _2v=0,_2w=10;_2v<_2w;_2v++){$k[$j++]=$f($1.height-.075)}for(var _2y=0,_2z=4;_2y<_2z;_2y++){$k[$j++]=$1.height}$1.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _32=0,_33=10;_32<_33;_32++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;for(var _34=0,_35=10;_34<_35;_34++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$1.bbs=$a()}else{$k[$j++]=Infinity;for(var _37=0,_38=30;_37<_38;_37++){$k[$j++]=$1.height}$1.bhs=$a();$k[$j++]=Infinity;for(var _3B=0,_3C=30;_3B<_3C;_3B++){$k[$j++]=0}$1.bbs=$a();$1.txt=$a([])}$1.guardrightypos=0;if($ne($1.addon,"")){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$f($1.height-.15);$k[$j++]="textxoffset";if($ne($1.addontextxoffset,null)){$k[$j++]=$1.addontextxoffset}else{$k[$j++]=95+$1.addongap}if($ne($1.addontextyoffset,null)){$k[$j++]="textyoffset";$k[$j++]=$1.addontextyoffset}$k[$j++]="textsize";if($ne($1.addontextsize,null)){$k[$j++]=$1.addontextsize}else{$k[$j++]=$1.textsize}var _3Q=$ne($1.addontextfont,"unset")?$1.addontextfont:$1.textfont;$k[$j++]="textfont";$k[$j++]=_3Q;$1.addopts=$d();if($1.addon.length==2){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean2()}if($1.addon.length==5){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean5()}$1.addcode=$k[--$j];$k[$j++]=Infinity;$q($1.sbs);$k[$j++]=$1.addongap;$q($g($1.addcode,"sbs"));$1.sbs=$a();$k[$j++]=Infinity;$q($1.bhs);$F($g($1.addcode,"bhs"),function(){var _3h=$k[--$j];$k[$j++]=$f(_3h-.075)});$1.bhs=$a();$k[$j++]=Infinity;$q($1.bbs);$F($g($1.addcode,"bbs"),function(){var _3m=$k[--$j];$k[$j++]=$f(_3m+.075)});$1.bbs=$a();$k[$j++]=Infinity;$q($1.txt);$q($g($1.addcode,"txt"));$1.txt=$a();$1.guardrightypos=$1.height*72-6}var _3z=new Map([["ren",bwipp_renlinear],["sbs",$1.sbs],["bhs",$1.bhs],["bbs",$1.bbs],["txt",$1.txt],["opt",$1.options],["guardrightpos",10],["guardrightypos",$1.guardrightypos],["borderbottom",5]]);$k[$j++]=_3z;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_upce(){var $1=Object.create(bwipp_upce.$ctx||(bwipp_upce.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=12;$1.textxoffset=-7;$1.textyoffset=-4;$1.height=1;$1.addongap=12;$1.addontextfont="unset";$1.addontextsize=null;$1.addontextxoffset=null;$1.addontextyoffset=null;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$X($1.barcode," ");if($k[--$j]){$1.barcode=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.barcode.length==11||$1.barcode.length==12){$F($1.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.upcEupcAbadCharacter#4956";$k[$j++]="UPC-A must contain only digits";bwipp_raiseerror()}});for(var _A=0,_B=1;_A<_B;_A++){var _D=$1.barcode.length==12?8:7;$1.upcecode=$s(_D);if($f($g($1.barcode,3)-48)<=2&&$eq($G($1.barcode,4,4),"0000")){$P($1.upcecode,0,$G($1.barcode,0,3));$P($1.upcecode,3,$G($1.barcode,8,3));$P($1.upcecode,6,$G($1.barcode,3,1));break}if($eq($G($1.barcode,4,5),"00000")){$P($1.upcecode,0,$G($1.barcode,0,4));$P($1.upcecode,4,$G($1.barcode,9,2));$P($1.upcecode,6,"3");break}if($eq($G($1.barcode,5,5),"00000")){$P($1.upcecode,0,$G($1.barcode,0,5));$P($1.upcecode,5,$G($1.barcode,10,1));$P($1.upcecode,6,"4");break}if($f($g($1.barcode,10)-48)>=5&&$eq($G($1.barcode,6,4),"0000")){$P($1.upcecode,0,$G($1.barcode,0,6));$P($1.upcecode,6,$G($1.barcode,10,1));break}$k[$j++]="bwipp.upcEupcAnotCompressible#4984";$k[$j++]="UPC-A cannot be converted to a UPC-E";bwipp_raiseerror()}if($1.barcode.length==12){$P($1.upcecode,7,$G($1.barcode,11,1))}$1.barcode=$1.upcecode}if($1.barcode.length!=7&&$1.barcode.length!=8){$k[$j++]="bwipp.upcEbadLength#4994";$k[$j++]="UPC-E must be 7 or 8 digits";bwipp_raiseerror()}var _11=$1.barcode;for(var _12=0,_13=_11.length;_12<_13;_12++){var _14=$g(_11,_12);if(_14<48||_14>57){$k[$j++]="bwipp.upcEbadCharacter#4998";$k[$j++]="UPC-E must contain only digits";bwipp_raiseerror()}}if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.upcEbadAddOnLength#5002";$k[$j++]="Add-on for UPC-E must be 2 or 5 digits";bwipp_raiseerror()}var _19=$g($1.barcode,0);if(_19!=48&&_19!=49){$k[$j++]="bwipp.upcEbadNumberSystem#5007";$k[$j++]="UPC-E must have number system 0 or 1";bwipp_raiseerror()}if(!bwipp_upce.__5025__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","111111"]);$ctx.barchars="0123456789";$ctx.mirrormaps=$a(["000111","001011","001101","001110","010011","011001","011100","010101","010110","011010"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_upce.$ctx[id]=$ctx[id]);bwipp_upce.__5025__=1})()}for(var _1D=0,_1E=1;_1D<_1E;_1D++){$1.upcacode=$s(11);if($g($1.barcode,6)-48<=2){$P($1.upcacode,0,$G($1.barcode,0,3));$P($1.upcacode,3,$G($1.barcode,6,1));$P($1.upcacode,4,"0000");$P($1.upcacode,8,$G($1.barcode,3,3));break}if($g($1.barcode,6)-48==3){$P($1.upcacode,0,$G($1.barcode,0,4));$P($1.upcacode,4,"00000");$P($1.upcacode,9,$G($1.barcode,4,2));break}if($g($1.barcode,6)-48==4){$P($1.upcacode,0,$G($1.barcode,0,5));$P($1.upcacode,5,"00000");$P($1.upcacode,10,$G($1.barcode,5,1));break}if($g($1.barcode,6)-48>=5){$P($1.upcacode,0,$G($1.barcode,0,6));$P($1.upcacode,6,"0000");$P($1.upcacode,10,$G($1.barcode,6,1));break}}$1.checksum=0;for(var _1t=0;_1t<=10;_1t+=1){$1.i=_1t;$1.barchar=$g($1.upcacode,$1.i)-48;if($1.i%2!=0){$1.checksum=$1.checksum+$1.barchar}else{$1.checksum=$1.checksum+$1.barchar*3}}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==8){if($g($1.barcode,7)!=$1.checksum+48){$k[$j++]="bwipp.upcEbadCheckDigit#5069";$k[$j++]="Incorrect UPC check digit provided";bwipp_raiseerror()}}$1.pad=$s(8);$P($1.pad,0,$1.barcode);$p($1.pad,7,$1.checksum+48);$1.barcode=$1.pad;$1.txt=$a(8);$p($1.txt,0,$a([$G($1.barcode,0,1),$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize-2]));$1.mirrormap=$g($1.mirrormaps,$1.checksum);if($g($1.barcode,0)==48){$1.invt=$s($1.mirrormap.length);for(var _2V=0,_2U=$1.mirrormap.length-1;_2V<=_2U;_2V+=1){$1.i=_2V;if($g($1.mirrormap,$1.i)==48){$p($1.invt,$1.i,49)}else{$p($1.invt,$1.i,48)}}$1.mirrormap=$1.invt}$1.sbs=$s(33);$P($1.sbs,0,$g($1.encs,10));for(var _2i=1;_2i<=6;_2i+=1){$1.i=_2i;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);if($g($1.mirrormap,$1.i-1)==49){$1.enclen=$1.enc.length;$1.revenc=$s($1.enclen);for(var _2z=0,_2y=$1.enclen-1;_2z<=_2y;_2z+=1){$1.j=_2z;$1.char=$g($1.enc,$1.j);$p($1.revenc,$1.enclen-$1.j-1,$1.char)}$1.enc=$1.revenc}$P($1.sbs,($1.i-1)*4+3,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i-1)*7+11+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize]))}$p($1.txt,7,$a([$G($1.barcode,7,1),6*7+18+$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize-2]));$P($1.sbs,27,$g($1.encs,11));$k[$j++]=Infinity;var _3X=$1.sbs;for(var _3Y=0,_3Z=_3X.length;_3Y<_3Z;_3Y++){$k[$j++]=$g(_3X,_3Y)-48}$1.sbs=$a();if($1.includetext){$k[$j++]=Infinity;$k[$j++]=$1.height;$k[$j++]=$1.height;for(var _3f=0,_3g=12;_3f<_3g;_3f++){$k[$j++]=$f($1.height-.075)}$k[$j++]=$1.height;$k[$j++]=$1.height;$k[$j++]=$1.height;$1.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;for(var _3m=0,_3n=12;_3m<_3n;_3m++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$1.bbs=$a()}else{$k[$j++]=Infinity;for(var _3p=0,_3q=17;_3p<_3q;_3p++){$k[$j++]=$1.height}$1.bhs=$a();$k[$j++]=Infinity;for(var _3t=0,_3u=17;_3t<_3u;_3t++){$k[$j++]=0}$1.bbs=$a();$1.txt=$a([])}$1.guardrightypos=0;if($ne($1.addon,"")){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$f($1.height-.15);$k[$j++]="textxoffset";if($ne($1.addontextxoffset,null)){$k[$j++]=$1.addontextxoffset}else{$k[$j++]=51+$1.addongap}if($ne($1.addontextyoffset,null)){$k[$j++]="textyoffset";$k[$j++]=$1.addontextyoffset}$k[$j++]="textsize";if($ne($1.addontextsize,null)){$k[$j++]=$1.addontextsize}else{$k[$j++]=$1.textsize}var _48=$ne($1.addontextfont,"unset")?$1.addontextfont:$1.textfont;$k[$j++]="textfont";$k[$j++]=_48;$1.addopts=$d();if($1.addon.length==2){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean2()}if($1.addon.length==5){$k[$j++]=$1.addon;$k[$j++]=$1.addopts;bwipp_ean5()}$1.addcode=$k[--$j];$k[$j++]=Infinity;$q($1.sbs);$k[$j++]=$1.addongap;$q($g($1.addcode,"sbs"));$1.sbs=$a();$k[$j++]=Infinity;$q($1.bhs);$F($g($1.addcode,"bhs"),function(){var _4P=$k[--$j];$k[$j++]=$f(_4P-.075)});$1.bhs=$a();$k[$j++]=Infinity;$q($1.bbs);$F($g($1.addcode,"bbs"),function(){var _4U=$k[--$j];$k[$j++]=$f(_4U+.075)});$1.bbs=$a();$k[$j++]=Infinity;$q($1.txt);$q($g($1.addcode,"txt"));$1.txt=$a();$1.guardrightypos=$1.height*72-6}var _4h=new Map([["ren",bwipp_renlinear],["sbs",$1.sbs],["bhs",$1.bhs],["bbs",$1.bbs],["txt",$1.txt],["opt",$1.options],["guardrightpos",10],["guardrightypos",$1.guardrightypos],["borderbottom",5]]);$k[$j++]=_4h;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_isbn(){var $1=Object.create(bwipp_isbn.$ctx||(bwipp_isbn.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.isbntextfont="OCR-A";$1.isbntextsize=8;$1.isbntextxoffset=null;$1.isbntextyoffset=null;$1.height=1;$1.addongap=12;$1.legacy=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$X($1.barcode," ");if($k[--$j]){$1.barcode=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.barcode.length!=15&&$1.barcode.length!=17&&($1.barcode.length!=11&&$1.barcode.length!=13)){$k[$j++]="bwipp.isbnBadLength#5235";$k[$j++]="ISBN-13 must be 15 or 17 characters including dashes. ISBN-10 must be 11 or 13 characters including dashes";bwipp_raiseerror()}if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.isbnBadAddOnLength#5238";$k[$j++]="Add-on for ISBN must be 2 or 5 digits";bwipp_raiseerror()}if($1.barcode.length>=15){var _F=$G($1.barcode,0,4);if($ne(_F,"978-")&&$ne(_F,"979-")){$k[$j++]="bwipp.isbn13badPrefix#5242";$k[$j++]="ISBN-13 prefix must be 978- or 979-";bwipp_raiseerror()}$1.wasdash=false;$1.numdash=0;$1.numdigit=0;var _H=$G($1.barcode,5,9);for(var _I=0,_J=_H.length;_I<_J;_I++){var _K=$g(_H,_I);$k[$j++]=_K;if(_K==45){if($1.wasdash){$k[$j++]="bwipp.isbn13adjacentDashes#5249";$k[$j++]="ISBN-13 does not permit adjacent dashes";bwipp_raiseerror()}$1.wasdash=true;$1.numdash=$1.numdash+1}var _N=$k[--$j];if(_N>=48&&_N<=57){$1.wasdash=false;$1.numdigit=$1.numdigit+1}}if($1.numdash!=2||$1.numdigit!=7){$k[$j++]="bwipp.isbn13numDashesDigits#5260";$k[$j++]="Incorrect number of dashes and digits for ISBN-13";bwipp_raiseerror()}var _S=$g($1.barcode,14);if(_S<48||_S>57){$k[$j++]="bwipp.isbn13character15#5263";$k[$j++]="ISBN-13 character 15 must be a digit";bwipp_raiseerror()}if($1.barcode.length==17){if($ne($G($1.barcode,15,1),"-")){$k[$j++]="bwipp.isbn13character16#5267";$k[$j++]="ISBN-13 penultimate character must be a dash";bwipp_raiseerror()}var _X=$g($1.barcode,16);if(_X<48||_X>57){$k[$j++]="bwipp.isbn13character17#5270";$k[$j++]="ISBN-13 final character must be a digit";bwipp_raiseerror()}}}else{var _Z=$g($1.barcode,0);if(_Z<48||_Z>57){$k[$j++]="bwipp.isbn10FirstDigit#5275";$k[$j++]="ISBN-10 first character must be a digit";bwipp_raiseerror()}$1.wasdash=false;$1.numdash=0;$1.numdigit=0;var _b=$G($1.barcode,1,9);for(var _c=0,_d=_b.length;_c<_d;_c++){var _e=$g(_b,_c);$k[$j++]=_e;if(_e==45){if($1.wasdash){$k[$j++]="bwipp.isbn10adjacentDashes#5282";$k[$j++]="ISBN-10 does not permit adjacent dashes";bwipp_raiseerror()}$1.wasdash=true;$1.numdash=$1.numdash+1}var _h=$k[--$j];if(_h>=48&&_h<=57){$1.wasdash=false;$1.numdigit=$1.numdigit+1}}if($1.numdash!=2||$1.numdigit!=7){$k[$j++]="bwipp.isbn10numDashesDigits#5293";$k[$j++]="Incorrect number of dashes and digits for ISBN-10";bwipp_raiseerror()}var _m=$g($1.barcode,10);if(_m<48||_m>57){$k[$j++]="bwipp.isbn10character11#5296";$k[$j++]="ISBN-10 character 11 must be a digit";bwipp_raiseerror()}if($1.barcode.length==13){if($ne($G($1.barcode,11,1),"-")){$k[$j++]="bwipp.isbn10character12#5300";$k[$j++]="ISBN-10 penultimate character must be a dash";bwipp_raiseerror()}var _r=$g($1.barcode,12);if((_r<48||_r>57)&&_r!=88){$k[$j++]="bwipp.isbn10character13#5303";$k[$j++]="ISBN-10 final character must be a digit or X";bwipp_raiseerror()}}}$1.isbntxt=$1.barcode;if($1.isbntxt.length<=13){$1.isbn=$s(10);$1.checksum=0;$1.i=0;$1.n=0;for(;;){$1.isbnchar=$f($g($1.isbntxt,$1.i)-48);if($1.isbnchar!=-3){$p($1.isbn,$1.n,$f($1.isbnchar+48));if($1.n<9){$1.checksum=$f($1.checksum+(10-$1.n)*$1.isbnchar)}$1.n=$1.n+1}$1.i=$1.i+1;if($1.i==$1.isbntxt.length){break}}var _1B=$f(11-$1.checksum%11)%11;$k[$j++]="checksum";$k[$j++]=_1B;if(_1B==10){$j--;$k[$j++]=40}var _1C=$k[--$j];$1[$k[--$j]]=$f(_1C+48);$1.isbn=$G($1.isbn,0,9);if($1.isbntxt.length==13){if($g($1.isbntxt,12)!=$1.checksum){$k[$j++]="bwipp.isbn10badCheckDigit#5331";$k[$j++]="Incorrect ISBN-10 check digit provided";bwipp_raiseerror()}}}if(!$1.legacy||$1.isbntxt.length>=15){if($1.isbntxt.length<=13){$1.pad=$s(15);$P($1.pad,0,"978-");$P($1.pad,4,$G($1.isbntxt,0,11));$1.isbntxt=$1.pad}$1.isbn=$s(13);$1.checksum=0;$1.i=0;$1.n=0;for(;;){$1.isbnchar=$g($1.isbntxt,$1.i)-48;if($1.isbnchar!=-3){$p($1.isbn,$1.n,$1.isbnchar+48);if($1.n<12){$k[$j++]="checksum";$k[$j++]=$1.isbnchar;if($1.n%2!=0){var _1e=$k[--$j];$k[$j++]=_1e*3}var _1g=$k[--$j];$1[$k[--$j]]=$f(_1g+$1.checksum)}$1.n=$1.n+1}$1.i=$1.i+1;if($1.i==$1.isbntxt.length){break}}$1.checksum=(10-$1.checksum%10)%10+48;$1.isbn=$G($1.isbn,0,12);if($1.isbntxt.length==17){if($g($1.isbntxt,16)!=$1.checksum){$k[$j++]="bwipp.isbn13badCheckDigit#5366";$k[$j++]="Incorrect ISBN-13 check digit provided";bwipp_raiseerror()}}}var _1u=$1.isbn.length==12?22:18;$1.pad=$s(_1u);$P($1.pad,0,"ISBN ");$P($1.pad,5,$1.isbntxt);$p($1.pad,$1.pad.length-2,45);$p($1.pad,$1.pad.length-1,$1.checksum);$1.isbntxt=$1.pad;$1.barcode=$s(12);if($1.isbn.length==9){$P($1.barcode,0,"978");$P($1.barcode,3,$1.isbn)}else{$P($1.barcode,0,$1.isbn)}if($ne($1.addon,"")){var _2E=$s(12+$1.addon.length+1);$P(_2E,0,$1.barcode);$P(_2E,12," ");$P(_2E,13,$1.addon);$1.barcode=_2E}$p($1.options,"dontdraw",true);$p($1.options,"addongap",$1.addongap);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_ean13();var _2M=$k[--$j];$1[$k[--$j]]=_2M;if($1.includetext){if($eq($1.isbntextxoffset,null)){$k[$j++]="isbntextxoffset";if($1.isbn.length==9){$k[$j++]=-1}else{$k[$j++]=-12}var _2R=$k[--$j];$1[$k[--$j]]=_2R}if($eq($1.isbntextyoffset,null)){$1.isbntextyoffset=$1.height*72+3}var _2W=$g($1.args,"txt")!==undefined;if(_2W){$1.txt=$g($1.args,"txt");$1.newtxt=$a($1.txt.length+1);$P($1.newtxt,0,$1.txt);$p($1.newtxt,$1.newtxt.length-1,$a([$1.isbntxt,$1.isbntextxoffset,$1.isbntextyoffset,$1.isbntextfont,$1.isbntextsize]));$p($1.args,"txt",$1.newtxt)}else{$p($1.args,"txt",$a([$a([$1.isbntxt,$1.isbntextxoffset,$1.isbntextyoffset,$1.isbntextfont,$1.isbntextsize])]))}}$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_ismn(){var $1=Object.create(bwipp_ismn.$ctx||(bwipp_ismn.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.ismntextfont="OCR-A";$1.ismntextsize=8;$1.ismntextxoffset=null;$1.ismntextyoffset=null;$1.height=1;$1.addongap=12;$1.legacy=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$X($1.barcode," ");if($k[--$j]){$1.barcode=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.barcode.length!=15&&$1.barcode.length!=17&&($1.barcode.length!=11&&$1.barcode.length!=13)){$k[$j++]="bwipp.ismnBadLength#5485";$k[$j++]="ISMN-13 must be 15 or 17 characters including dashes. ISMN-10 must be 11 or 13 characters including dashes";bwipp_raiseerror()}if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.ismnBadAddOnLength#5488";$k[$j++]="Add-on for ISMN must be 2 or 5 digits";bwipp_raiseerror()}if($1.barcode.length>=15){if($ne($G($1.barcode,0,4),"979-")){$k[$j++]="bwipp.ismn13badPrefix#5492";$k[$j++]="ISMN-13 prefix must be 979-";bwipp_raiseerror()}$1.wasdash=false;$1.numdash=0;$1.numdigit=0;var _H=$G($1.barcode,5,9);for(var _I=0,_J=_H.length;_I<_J;_I++){var _K=$g(_H,_I);$k[$j++]=_K;if(_K==45){if($1.wasdash){$k[$j++]="bwipp.ismn13adjacentDashes#5499";$k[$j++]="ISMN-13 does not permit adjacent dashes";bwipp_raiseerror()}$1.wasdash=true;$1.numdash=$1.numdash+1}var _N=$k[--$j];if(_N>=48&&_N<=57){$1.wasdash=false;$1.numdigit=$1.numdigit+1}}if($1.numdash!=2||$1.numdigit!=7){$k[$j++]="bwipp.ismn13numDashesDigits#5510";$k[$j++]="Incorrect number of dashes and digits for ISMN-13";bwipp_raiseerror()}var _S=$g($1.barcode,14);if(_S<48||_S>57){$k[$j++]="bwipp.ismn13character15#5513";$k[$j++]="ISMN-13 character 15 must be a digit";bwipp_raiseerror()}if($1.barcode.length==17){if($ne($G($1.barcode,15,1),"-")){$k[$j++]="bwipp.ismn13character16#5517";$k[$j++]="ISMN-13 penultimate character must be a dash";bwipp_raiseerror()}var _X=$g($1.barcode,16);if(_X<48||_X>57){$k[$j++]="bwipp.ismn13character17#5520";$k[$j++]="ISMN-13 final character must be a digit";bwipp_raiseerror()}}}else{if($ne($G($1.barcode,0,2),"M-")){$k[$j++]="bwipp.ismn10badPrefix#5525";$k[$j++]="ISMN-10 prefix must be M-";bwipp_raiseerror()}var _b=$g($1.barcode,2);if(_b<48||_b>57){$k[$j++]="bwipp.ismn10character3#5528";$k[$j++]="ISMN-10 character 3 must be a digit";bwipp_raiseerror()}$1.wasdash=false;$1.numdash=0;$1.numdigit=0;var _d=$G($1.barcode,3,7);for(var _e=0,_f=_d.length;_e<_f;_e++){var _g=$g(_d,_e);$k[$j++]=_g;if(_g==45){if($1.wasdash){$k[$j++]="bwipp.ismn10adjacentDashes#5535";$k[$j++]="ISMN-10 does not permit adjacent dashes";bwipp_raiseerror()}$1.wasdash=true;$1.numdash=$1.numdash+1}var _j=$k[--$j];if(_j>=48&&_j<=57){$1.wasdash=false;$1.numdigit=$1.numdigit+1}}if($1.numdash!=1||$1.numdigit!=6){$k[$j++]="bwipp.ismn10numDashesDigits#5546";$k[$j++]="Incorrect number of dashes and digits for ISMN-10";bwipp_raiseerror()}var _o=$g($1.barcode,10);if(_o<48||_o>57){$k[$j++]="bwipp.ismn10character11#5549";$k[$j++]="ISMN-10 character 11 must be a digit";bwipp_raiseerror()}if($1.barcode.length==13){var _r=$G($1.barcode,11,1);if($ne(_r,"-")){$k[$j++]="bwipp.ismn10character12#5553";$k[$j++]="ISMN-10 penultimate character must be a dash";bwipp_raiseerror()}var _t=$g($1.barcode,12);if((_t<48||_t>57)&&_t!=88){$k[$j++]="bwipp.ismn10character13#5556";$k[$j++]="ISMN-10 final character must be a digit or X";bwipp_raiseerror()}}}$1.ismntxt=$1.barcode;$1.legacytxt="";if($1.ismntxt.length<=13){$1.legacytxt=$1.ismntxt;$1.pad=$s($1.ismntxt.length+4);$P($1.pad,0,"979-0-");$P($1.pad,6,$G($1.ismntxt,2,$1.ismntxt.length-2));$1.ismntxt=$1.pad}$1.ismn=$s(13);$1.checksum=0;$1.i=0;$1.n=0;for(;;){$1.ismnchar=$g($1.ismntxt,$1.i)-48;if($1.ismnchar!=-3){$p($1.ismn,$1.n,$1.ismnchar+48);if($1.n<12){if($1.n%2==0){$1.checksum=$1.ismnchar+$1.checksum}else{$1.checksum=$1.ismnchar*3+$1.checksum}}$1.n=$1.n+1}$1.i=$1.i+1;if($1.i==$1.ismntxt.length){break}}$1.checksum=(10-$1.checksum%10)%10+48;if($1.barcode.length==13||$1.barcode.length==17){var _1Q=$1.barcode;if($g(_1Q,_1Q.length-1)!=$1.checksum){$k[$j++]="bwipp.ismnBadCheckDigit#5598";$k[$j++]="Incorrect ISMN check digit provided";bwipp_raiseerror()}}if($1.legacy&&$ne($1.legacytxt,"")){$1.ismntxt=$1.legacytxt;$1.pad=$s(18)}else{$1.pad=$s(22)}$P($1.pad,0,"ISMN ");$P($1.pad,5,$1.ismntxt);$p($1.pad,$1.pad.length-2,45);$p($1.pad,$1.pad.length-1,$1.checksum);$1.ismntxt=$1.pad;$1.barcode=$G($1.ismn,0,12);if($ne($1.addon,"")){var _1l=$s(12+$1.addon.length+1);$P(_1l,0,$1.barcode);$P(_1l,12," ");$P(_1l,13,$1.addon);$1.barcode=_1l}$p($1.options,"dontdraw",true);$p($1.options,"addongap",$1.addongap);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_ean13();var _1t=$k[--$j];$1[$k[--$j]]=_1t;if($1.includetext){if($eq($1.ismntextxoffset,null)){$k[$j++]="ismntextxoffset";if($1.ismntxt.length==18){$k[$j++]=-1}else{$k[$j++]=-12}var _1y=$k[--$j];$1[$k[--$j]]=_1y}if($eq($1.ismntextyoffset,null)){$1.ismntextyoffset=$1.height*72+3}var _23=$g($1.args,"txt")!==undefined;if(_23){$1.txt=$g($1.args,"txt");$1.newtxt=$a($1.txt.length+1);$P($1.newtxt,0,$1.txt);$p($1.newtxt,$1.newtxt.length-1,$a([$1.ismntxt,$1.ismntextxoffset,$1.ismntextyoffset,$1.ismntextfont,$1.ismntextsize]));$p($1.args,"txt",$1.newtxt)}else{$p($1.args,"txt",$a([$a([$1.ismntxt,$1.ismntextxoffset,$1.ismntextyoffset,$1.ismntextfont,$1.ismntextsize])]))}}$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_issn(){var $1=Object.create(bwipp_issn.$ctx||(bwipp_issn.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.issntextfont="OCR-A";$1.issntextsize=8;$1.issntextxoffset=null;$1.issntextyoffset=null;$1.height=1;$1.addongap=12;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.issntxt=$k[--$j];$X($1.issntxt," ");if($k[--$j]){$1.issntxt=$k[--$j];$j--;$1.seqvar=$k[--$j]}else{$j--;$1.seqvar="00"}$X($1.seqvar," ");if($k[--$j]){$1.seqvar=$k[--$j];$j--;$1.addon=$k[--$j]}else{$j--;$1.addon=""}if($1.issntxt.length!=8&&$1.issntxt.length!=9){$k[$j++]="bwipp.issnBadLength#5722";$k[$j++]="ISSN must be 8 or 9 characters including dash, in the format XXXX-XXXX";bwipp_raiseerror()}var _D=$G($1.issntxt,0,4);for(var _E=0,_F=_D.length;_E<_F;_E++){var _G=$g(_D,_E);if(_G<48||_G>57){$k[$j++]="bwipp.issnFirstThroughFourthNotNumeric#5726";$k[$j++]="ISSN first four characters must be numeral characters";bwipp_raiseerror()}}if($ne($G($1.issntxt,4,1),"-")){$k[$j++]="bwipp.issnNeedsDash#5730";$k[$j++]="ISSN fifth character must be a dash";bwipp_raiseerror()}var _K=$G($1.issntxt,5,3);for(var _L=0,_M=_K.length;_L<_M;_L++){var _N=$g(_K,_L);if(_N<48||_N>57){$k[$j++]="bwipp.issnSixthThroughEighthNotNumeric#5734";$k[$j++]="ISSN sixth through eighth characters must be numerals";bwipp_raiseerror()}}if($1.issntxt.length==9){var _Q=$g($1.issntxt,8);if((_Q<48||_Q>57)&&_Q!=88){$k[$j++]="bwipp.issnNinthCharacterBadFormat#5739";$k[$j++]="ISSN ninth character must be a number or the character X";bwipp_raiseerror()}}if($1.seqvar.length!=2){$k[$j++]="bwipp.issnBadSequenceVariantLength#5743";$k[$j++]="Sequence variant for ISSN must be 2 digits";bwipp_raiseerror()}$F($1.seqvar,function(){var _T=$k[--$j];if(_T<48||_T>57){$k[$j++]="bwipp.issnSequenceVariantBadCharacter#5747";$k[$j++]="Sequence variant for ISSN must contain only digits";bwipp_raiseerror()}});if($1.addon.length!=0&&$1.addon.length!=2&&$1.addon.length!=5){$k[$j++]="bwipp.issnBadAddOnLength#5751";$k[$j++]="Add-on for ISSN must be 2 or 5 digits";bwipp_raiseerror()}$1.issn=$s(8);$1.checksum=0;$1.i=0;$1.n=0;for(;;){$1.issnchar=$f($g($1.issntxt,$1.i)-48);if($1.issnchar!=-3){$p($1.issn,$1.n,$f($1.issnchar+48));if($1.n<7){$1.checksum=$f($1.checksum+$1.issnchar*(8-$1.n))}$1.n=$1.n+1}$1.i=$1.i+1;if($1.i==$1.issntxt.length){break}}$1.checksum=$f(11-$1.checksum%11)%11;var _p=$f($1.checksum+48);$k[$j++]="checksum";$k[$j++]=_p;if(_p==58){$j--;$k[$j++]=88}var _q=$k[--$j];var _r=$k[--$j];$1[_r]=_q;if($1.issntxt.length==9){if($g($1.issntxt,8)!=$1.checksum){$k[$j++]="bwipp.issnBadCheckDigit#5774";$k[$j++]="Incorrect ISSN check digit provided";bwipp_raiseerror()}}$1.pad=$s(14);$P($1.pad,0,"ISSN ");$P($1.pad,5,$1.issntxt);$p($1.pad,13,$1.checksum);$1.issntxt=$1.pad;$1.barcode=$G($1.issn,0,7);$1.barcode=$s(12);$P($1.barcode,0,"977");$P($1.barcode,3,$1.issn);$P($1.barcode,10,$1.seqvar);if($ne($1.addon,"")){var _1D=$s(12+$1.addon.length+1);$P(_1D,0,$1.barcode);$P(_1D,12," ");$P(_1D,13,$1.addon);$1.barcode=_1D}$p($1.options,"dontdraw",true);$p($1.options,"addongap",$1.addongap);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_ean13();var _1L=$k[--$j];$1[$k[--$j]]=_1L;if($1.includetext){if($eq($1.issntextxoffset,null)){$1.issntextxoffset=10}if($eq($1.issntextyoffset,null)){$1.issntextyoffset=$1.height*72+3}var _1S=$g($1.args,"txt")!==undefined;if(_1S){$1.txt=$g($1.args,"txt");$1.newtxt=$a($1.txt.length+1);$P($1.newtxt,0,$1.txt);$p($1.newtxt,$1.newtxt.length-1,$a([$1.issntxt,$1.issntextxoffset,$1.issntextyoffset,$1.issntextfont,$1.issntextsize]));$p($1.args,"txt",$1.newtxt)}else{$p($1.args,"txt",$a([$a([$1.issntxt,$1.issntextxoffset,$1.issntextyoffset,$1.issntextfont,$1.issntextsize])]))}}$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_mands(){var $1=Object.create(bwipp_mands.$ctx||(bwipp_mands.$ctx={}));$1.dontdraw=false;$1.includetext=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$1.barlen=$1.barcode.length;if($1.barlen!=7&&$1.barlen!=8){$k[$j++]="bwipp.MandSbadLength#5870";$k[$j++]="M&S barcode must be 7 or 8 characters";bwipp_raiseerror()}if($1.barlen==7){var _7=$Z($s(8),"00000000");$P(_7,1,$1.barcode);$1.barcode=_7}$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_ean8();var _C=$k[--$j];$1[$k[--$j]]=_C;var _F=$g($1.args,"bbs");$p(_F,10,$g(_F,2));$p(_F,11,$g(_F,2));var _J=$g($1.args,"bhs");$p(_J,10,$g(_J,2));$p(_J,11,$g(_J,2));$1.txt=$g($1.args,"txt");if($1.barlen==7){for(var _P=0;_P<=6;_P+=1){var _Q=$1.txt;$P($g($g(_Q,_P),0),0,$g($g(_Q,_P+1),0))}$P($g($g($1.txt,7),0),0," ")}var _Y=$a(10);$P(_Y,0,$1.txt);$1.txt=_Y;var _b=$g($1.txt,0);$p($1.txt,8,$A($a(_b.length),_b));var _g=$g($1.txt,0);$p($1.txt,9,$A($a(_g.length),_g));$p($g($1.txt,8),0,"M");$p($g($1.txt,8),1,-12);$p($g($1.txt,9),0,"S");var _r=$g($1.txt,9);$p(_r,1,69);$p($1.args,"txt",$1.txt);$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code128(){var $1=Object.create(bwipp_code128.$ctx||(bwipp_code128.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=1;$1.encoding="auto";$1.raw=false;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_code128.__5971__){(function(){var $ctx=Object.create($1);$ctx.sta=-1;$ctx.stb=-2;$ctx.stc=-3;$ctx.swa=-4;$ctx.swb=-5;$ctx.swc=-6;$ctx.fn1=-7;$ctx.fn2=-8;$ctx.fn3=-9;$ctx.fn4=-10;$ctx.sft=-11;$ctx.stp=-12;$ctx.lka=-13;$ctx.lkc=-14;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code128.$ctx[id]=$ctx[id]);bwipp_code128.__5971__=1})()}var _6=$1.fn1;var _B=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["FNC1",$1.fn1],["FNC1",_6],["FNC2",$1.fn2],["FNC3",$1.fn3],["LNKA",$1.lka],["LNKC",$1.lkc]]);$1.fncvals=_B;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _E=$k[--$j];$1[$k[--$j]]=_E;$1.msglen=$1.msg.length;if(!bwipp_code128.__6044__){(function(){var $ctx=Object.create($1);$ctx.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$ctx.fn3,$ctx.fn3,"96"]),$a([$ctx.fn2,$ctx.fn2,"97"]),$a([$ctx.sft,$ctx.sft,"98"]),$a([$ctx.swc,$ctx.swc,"99"]),$a([$ctx.swb,$ctx.fn4,$ctx.swb]),$a([$ctx.fn4,$ctx.swa,$ctx.swa]),$a([$ctx.fn1,$ctx.fn1,$ctx.fn1]),$a([$ctx.sta,$ctx.sta,$ctx.sta]),$a([$ctx.stb,$ctx.stb,$ctx.stb]),$a([$ctx.stc,$ctx.stc,$ctx.stc]),$a([$ctx.stp,$ctx.stp,$ctx.stp])]);$ctx.charvals=$a([new Map,new Map,new Map]);for(var _2X=0,_2W=$ctx.charmaps.length-1;_2X<=_2W;_2X+=1){$ctx.i=_2X;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _2b=0;_2b<=2;_2b+=1){$ctx.j=_2b;var _2e=$g($ctx.encs,$ctx.j);$k[$j++]=_2e;if($eq($t(_2e),"stringtype")){var _2h=$g($k[--$j],0);$k[$j++]=_2h}$p($g($ctx.charvals,$ctx.j),$k[--$j],$ctx.i)}}$ctx.seta=$g($ctx.charvals,0);$ctx.setb=$g($ctx.charvals,1);$ctx.setc=$g($ctx.charvals,2);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code128.$ctx[id]=$ctx[id]);bwipp_code128.__6044__=1})()}$p($1.seta,$1.lka,$g($1.seta,$1.swb));$p($1.seta,$1.lkc,$g($1.seta,$1.swc));$p($1.setb,$1.lka,$g($1.setb,$1.swc));$p($1.setb,$1.lkc,$g($1.setb,$1.swa));$p($1.setc,$1.lka,$g($1.setc,$1.swa));$p($1.setc,$1.lkc,$g($1.setc,$1.swb));if($1.raw){$1.encoding="raw"}if($eq($1.encoding,"raw")){$1.cws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i==$1.barcode.length){break}$1.cw=$i($G($1.barcode,$1.i+1,3));$p($1.cws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}$1.cws=$G($1.cws,0,$1.j);$1.text=""}if($eq($1.encoding,"auto")){$1.text=$s($1.msglen);for(var _3k=0,_3j=$1.msglen-1;_3k<=_3j;_3k+=1){$1.i=_3k;var _3p=$g($1.msg,$1.i);$k[$j++]=$1.text;$k[$j++]=$1.i;$k[$j++]=_3p;if(_3p<0){$j--;$k[$j++]=32}var _3q=$k[--$j];var _3r=$k[--$j];$p($k[--$j],_3r,_3q)}$k[$j++]=Infinity;for(var _3u=0,_3v=$1.msglen;_3u<_3v;_3u++){$k[$j++]=0}$k[$j++]=0;$1.numSA=$a();$k[$j++]=Infinity;for(var _3y=0,_3z=$1.msglen;_3y<_3z;_3y++){$k[$j++]=0}$k[$j++]=0;$1.numEA=$a();for(var _42=$1.msglen-1;_42>=0;_42-=1){$1.i=_42;if($g($1.msg,$1.i)>=0){if($g($1.msg,$1.i)>=128){$p($1.numEA,$1.i,$f($g($1.numEA,$1.i+1)+1))}else{$p($1.numSA,$1.i,$f($g($1.numSA,$1.i+1)+1))}}}$1.ea=false;$1.msgtmp=$a([]);for(var _4M=0,_4L=$1.msglen-1;_4M<=_4L;_4M+=1){$1.i=_4M;$1.c=$g($1.msg,$1.i);if(!$xo($1.ea,$1.c<128)&&$1.c>=0){if($1.ea){$k[$j++]=$1.numSA}else{$k[$j++]=$1.numEA}var _4Y=$g($k[--$j],$1.i);var _4b=$f(_4Y+$1.i)==$1.msglen?3:5;if(_4Y<_4b){$k[$j++]=Infinity;$q($1.msgtmp);$k[$j++]=$1.fn4;$1.msgtmp=$a()}else{$k[$j++]=Infinity;$q($1.msgtmp);$k[$j++]=$1.fn4;$k[$j++]=$1.fn4;$1.msgtmp=$a();$1.ea=!$1.ea}}$k[$j++]=Infinity;$q($1.msgtmp);if($1.c>=0){$k[$j++]=$1.c&127}else{$k[$j++]=$1.c}$1.msgtmp=$a()}$1.msg=$1.msgtmp;$1.msglen=$1.msg.length;$1.numsscr=function(){$1.n=0;$1.s=0;$1.p=$k[--$j];for(;;){if($1.p>=$1.msglen){break}var _4w=$g($1.msg,$1.p);var _4y=$g($1.setc,_4w)!==undefined;$k[$j++]=_4w;if(!_4y){$j--;break}var _4z=$k[--$j];$k[$j++]=_4z;if(_4z<=-1){var _51=$k[--$j];if(_51==$1.fn1&&$1.s%2==0){$1.s=$1.s+1}else{break}}else{$j--}$1.n=$1.n+1;$1.s=$1.s+1;$1.p=$f($1.p+1)}$k[$j++]=$1.n;$k[$j++]=$1.s};$1.enca=function(){$p($1.cws,$1.j,$g($1.seta,$k[--$j]));$1.j=$1.j+1};$1.encb=function(){$p($1.cws,$1.j,$g($1.setb,$k[--$j]));$1.j=$1.j+1};$1.encc=function(){var _5L=$k[--$j];$k[$j++]=_5L;if($ne($t(_5L),"arraytype")){var _5P=$g($1.setc,$k[--$j]);$k[$j++]=_5P}else{$q($k[--$j]);var _5R=$k[--$j];var _5S=$k[--$j];$k[$j++]=$f($f(_5R-48)+$f(_5S-48)*10)}$p($1.cws,$1.j,$k[--$j]);$1.j=$1.j+1};$1.anotb=function(){var _5X=$k[--$j];var _5Z=$g($1.seta,_5X)!==undefined;var _5b=$g($1.setb,_5X)!==undefined;$k[$j++]=_5Z&&!_5b};$1.bnota=function(){var _5c=$k[--$j];var _5e=$g($1.setb,_5c)!==undefined;var _5g=$g($1.seta,_5c)!==undefined;$k[$j++]=_5e&&!_5g};$k[$j++]=Infinity;for(var _5i=0,_5j=$1.msg.length;_5i<_5j;_5i++){$k[$j++]=0}$k[$j++]=9999;$1.nextanotb=$a();$k[$j++]=Infinity;for(var _5m=0,_5n=$1.msg.length;_5m<_5n;_5m++){$k[$j++]=0}$k[$j++]=9999;$1.nextbnota=$a();for(var _5q=$1.msg.length-1;_5q>=0;_5q-=1){$1.i=_5q;$k[$j++]=$g($1.msg,$1.i);$1.anotb();if($k[--$j]){$p($1.nextanotb,$1.i,0)}else{$p($1.nextanotb,$1.i,$f($g($1.nextanotb,$1.i+1)+1))}$k[$j++]=$g($1.msg,$1.i);$1.bnota();if($k[--$j]){$p($1.nextbnota,$1.i,0)}else{$p($1.nextbnota,$1.i,$f($g($1.nextbnota,$1.i+1)+1))}}$1.abeforeb=function(){var _6D=$k[--$j];$k[$j++]=$lt($g($1.nextanotb,_6D),$g($1.nextbnota,_6D))};$1.bbeforea=function(){var _6I=$k[--$j];$k[$j++]=$lt($g($1.nextbnota,_6I),$g($1.nextanotb,_6I))};$1.cws=$a($1.barcode.length*2+3);$1.j=0;if($1.msglen>0){$k[$j++]=0;$1.numsscr()}else{$k[$j++]=-1;$k[$j++]=-1}$1.nums=$k[--$j];$1.nchars=$k[--$j];for(;;){if($1.msglen==0){$k[$j++]=$1.stb;$1.enca();$1.cset="setb";break}if($1.msglen==2&&$1.nums==2){$k[$j++]=$1.stc;$1.enca();$1.cset="setc";break}if($1.nums>=4){$k[$j++]=$1.stc;$1.enca();$1.cset="setc";break}$k[$j++]=0;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.sta;$1.enca();$1.cset="seta";break}$k[$j++]=$1.stb;$1.enca();$1.cset="setb";break}$1.i=0;for(;;){if($1.i==$1.msglen){break}$k[$j++]=$1.i;$1.numsscr();$1.nums=$k[--$j];$1.nchars=$k[--$j];for(;;){if(($eq($1.cset,"seta")||$eq($1.cset,"setb"))&&$1.nums>=4&&$g($1.msg,$1.i)!=$1.fn1){if($1.nums%2==0){$k[$j++]=$1.swc;if($eq($1.cset,"seta")){$1.enca()}else{$1.encb()}$1.cset="setc";break}else{$k[$j++]=$g($1.msg,$1.i);if($eq($1.cset,"seta")){$1.enca()}else{$1.encb()}$1.i=$1.i+1;$k[$j++]=$1.swc;if($eq($1.cset,"seta")){$1.enca()}else{$1.encb()}$1.cset="setc";break}}$k[$j++]=$eq($1.cset,"setb");$k[$j++]=$g($1.msg,$1.i);$1.anotb();var _72=$k[--$j];var _73=$k[--$j];if(_73&&_72){if($1.i<$1.msglen-1){$k[$j++]=$1.i+1;$1.bbeforea();if($k[--$j]){$k[$j++]=$1.sft;$1.encb();$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;break}}$k[$j++]=$1.swa;$1.encb();$1.cset="seta";break}$k[$j++]=$eq($1.cset,"seta");$k[$j++]=$g($1.msg,$1.i);$1.bnota();var _7I=$k[--$j];var _7J=$k[--$j];if(_7J&&_7I){if($1.i<$1.msglen-1){$k[$j++]=$1.i+1;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.sft;$1.enca();$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}}$k[$j++]=$1.swb;$1.enca();$1.cset="setb";break}if($eq($1.cset,"setc")&&$1.nums<2&&($g($1.msg,$1.i)>-1||$g($1.msg,$1.i)==$1.fn4)){$k[$j++]=$1.i;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.swa;$1.encc();$1.cset="seta";break}$k[$j++]=$1.swb;$1.encc();$1.cset="setb";break}if($eq($1.cset,"seta")){$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;break}if($eq($1.cset,"setb")){$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}if($eq($1.cset,"setc")){if($g($1.msg,$1.i)<=-1){$k[$j++]=$g($1.msg,$1.i);$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}break}break}}$1.cws=$G($1.cws,0,$1.j)}var _87=$a($1.j+2);$P(_87,0,$1.cws);$1.cws=_87;$1.csum=$g($1.cws,0);for(var _8D=1,_8C=$1.j-1;_8D<=_8C;_8D+=1){$1.i=_8D;$1.csum=$f($1.csum+$g($1.cws,$1.i)*$1.i)}$1.csum=$1.csum%103;$p($1.cws,$1.j,$1.csum);$p($1.cws,$1.j+1,$g($1.seta,$1.stp));var _8T=$g($1.options,"debugcws")!==undefined;if(_8T){$k[$j++]="bwipp.debugcws#6303";$k[$j++]=$1.cws;bwipp_raiseerror()}if(!bwipp_code128.__6325__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["212222","222122","222221","121223","121322","131222","122213","122312","132212","221213","221312","231212","112232","122132","122231","113222","123122","123221","223211","221132","221231","213212","223112","312131","311222","321122","321221","312212","322112","322211","212123","212321","232121","111323","131123","131321","112313","132113","132311","211313","231113","231311","112133","112331","132131","113123","113321","133121","313121","211331","231131","213113","213311","213131","311123","311321","331121","312113","312311","332111","314111","221411","431111","111224","111422","121124","121421","141122","141221","112214","112412","122114","122411","142112","142211","241211","221114","413111","241112","134111","111242","121142","121241","114212","124112","124211","411212","421112","421211","212141","214121","412121","111143","111341","131141","114113","114311","411113","411311","113141","114131","311141","411131","211412","211214","211232","2331112"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code128.$ctx[id]=$ctx[id]);bwipp_code128.__6325__=1})()}$1.sbs=$s($1.cws.length*6+1);for(var _8b=0,_8a=$1.cws.length-1;_8b<=_8a;_8b+=1){$1.i=_8b;$P($1.sbs,$1.i*6,$g($1.encs,$g($1.cws,$1.i)))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _8j=$1.sbs;for(var _8k=0,_8l=_8j.length;_8k<_8l;_8k++){$k[$j++]=$g(_8j,_8k)-48}var _8n=$a();$k[$j++]=Infinity;for(var _8p=0,_8q=~~(($1.sbs.length+1)/2);_8p<_8q;_8p++){$k[$j++]=$1.height}var _8s=$a();$k[$j++]=Infinity;for(var _8u=0,_8v=~~(($1.sbs.length+1)/2);_8u<_8v;_8u++){$k[$j++]=0}var _8w=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_8n;$k[$j++]="bhs";$k[$j++]=_8s;$k[$j++]="bbs";$k[$j++]=_8w;$k[$j++]="txt";$k[$j++]=$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]);$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$1.options;var _95=$d();$k[$j++]=_95;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_gs1_128(){var $1=Object.create(bwipp_gs1_128.$ctx||(bwipp_gs1_128.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=.5;$1.linkagea=false;$1.linkagec=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.linkagea&&$1.linkagec){$k[$j++]="bwipp.gs1128badLinkage#6400";$k[$j++]="linkagea and linkagec cannot be used together";bwipp_raiseerror()}$1.text=$1.barcode;$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];$1.fnc1=-1;$1.c128=$a([$1.fnc1]);for(var _D=0,_C=$1.ais.length-1;_D<=_C;_D+=1){$1.i=_D;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _N=$a($1.c128.length+$1.ai.length+$1.val.length);$P(_N,0,$1.c128);$k[$j++]=_N;$k[$j++]=_N;$k[$j++]=$1.c128.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _R=$k[--$j];var _S=$k[--$j];$k[$j++]=_R;$F(_S);var _T=$a();var _U=$k[--$j];$P($k[--$j],_U,_T);var _W=$k[--$j];$k[$j++]=_W;$k[$j++]=_W;$k[$j++]=$1.c128.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=_a;$F(_b);var _c=$a();var _d=$k[--$j];$P($k[--$j],_d,_c);$1.c128=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _m=$a($1.c128.length+1);$P(_m,0,$1.c128);$p(_m,$1.c128.length,$1.fnc1);$1.c128=_m}}$1.barcode=$s(($1.c128.length+1)*5);$1.i=0;$1.j=0;for(;;){if($1.i==$1.c128.length){break}var _w=$g($1.c128,$1.i);$k[$j++]=_w;if(_w==$1.fnc1){$j--;$P($1.barcode,$1.j,"^FNC1");$1.j=$1.j+4}else{$p($1.barcode,$1.j,$k[--$j])}$1.i=$1.i+1;$1.j=$1.j+1}if($1.linkagea||$1.linkagec){$k[$j++]=$1.barcode;$k[$j++]=$1.j;if($1.linkagea){$k[$j++]="^LNKA"}else{$k[$j++]="^LNKC"}var _1B=$k[--$j];var _1C=$k[--$j];$P($k[--$j],_1C,_1B);$1.j=$1.j+5}$1.barcode=$G($1.barcode,0,$1.j);delete $1.options["parse"];$p($1.options,"height",$1.height);$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code128();var _1P=$k[--$j];$1[$k[--$j]]=_1P;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_ean14(){var $1=Object.create(bwipp_ean14.$ctx||(bwipp_ean14.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$1.text=$1.barcode;var _3=$1.barcode;$k[$j++]=$s(_3.length);$k[$j++]=0;$F(_3,function(){var _5=$k[--$j];$k[$j++]=_5;if(_5!=32){var _6=$k[--$j];var _7=$k[--$j];var _8=$k[--$j];$p(_8,_7,_6);$k[$j++]=_8;$k[$j++]=$f(_7+1)}else{$j--}});var _9=$k[--$j];$1.barcode=$G($k[--$j],0,_9);$1.hasspace=$1.text.length!=$1.barcode.length;if($ne($G($1.barcode,0,4),"(01)")){$k[$j++]="bwipp.ean14badAI#6515";$k[$j++]="GS1-14 must begin with (01) application identifier";bwipp_raiseerror()}if($1.barcode.length!=17&&$1.barcode.length!=18){$k[$j++]="bwipp.ean14badLength#6518";$k[$j++]="GS1-14 must be 13 or 14 digits";bwipp_raiseerror()}var _K=$G($1.barcode,4,$1.barcode.length-4);for(var _L=0,_M=_K.length;_L<_M;_L++){var _N=$g(_K,_L);if(_N<48||_N>57){$k[$j++]="bwipp.ean14badCharacter#6522";$k[$j++]="GS1-14 must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _O=0;_O<=12;_O+=1){$1.i=_O;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _U=$k[--$j];$k[$j++]=_U*3}var _V=$k[--$j];var _W=$k[--$j];$1[$k[--$j]]=$f(_W+_V)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==18){if($g($1.barcode,17)!=$1.checksum+48){$k[$j++]="bwipp.ean14badCheckDigit#6535";$k[$j++]="Incorrect GS1-14 check digit provided";bwipp_raiseerror()}}else{var _d=$s(18);$P(_d,0,$1.barcode);$p(_d,17,$1.checksum+48);$1.barcode=_d;var _i=$1.hasspace?2:1;var _j=$s($1.text.length+_i);$P(_j,_j.length-2," ");$p(_j,_j.length-1,$1.checksum+48);$P(_j,0,$1.text);$1.text=_j}$1.gtin=$G($1.barcode,4,14);$1.barcode=$s(21);$P($1.barcode,0,"^FNC101");var _r=$1.gtin;$P($1.barcode,7,_r);$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code128();var _w=$k[--$j];$1[$k[--$j]]=_w;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_sscc18(){var $1=Object.create(bwipp_sscc18.$ctx||(bwipp_sscc18.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$1.text=$1.barcode;var _3=$1.barcode;$k[$j++]=$s(_3.length);$k[$j++]=0;$F(_3,function(){var _5=$k[--$j];$k[$j++]=_5;if(_5!=32){var _6=$k[--$j];var _7=$k[--$j];var _8=$k[--$j];$p(_8,_7,_6);$k[$j++]=_8;$k[$j++]=$f(_7+1)}else{$j--}});var _9=$k[--$j];$1.barcode=$G($k[--$j],0,_9);$1.hasspace=$1.text.length!=$1.barcode.length;if($ne($G($1.barcode,0,4),"(00)")){$k[$j++]="bwipp.sscc18badAI#6619";$k[$j++]="SSCC-18 must begin with (00) application identifier";bwipp_raiseerror()}if($1.barcode.length!=21&&$1.barcode.length!=22){$k[$j++]="bwipp.sscc18badLength#6622";$k[$j++]="SSCC-18 must be 17 or 18 digits";bwipp_raiseerror()}var _K=$G($1.barcode,4,$1.barcode.length-4);for(var _L=0,_M=_K.length;_L<_M;_L++){var _N=$g(_K,_L);if(_N<48||_N>57){$k[$j++]="bwipp.sscc18badCharacter#6626";$k[$j++]="SSCC-18 must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _O=0;_O<=16;_O+=1){$1.i=_O;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _U=$k[--$j];$k[$j++]=_U*3}var _V=$k[--$j];var _W=$k[--$j];$1[$k[--$j]]=$f(_W+_V)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==22){if($g($1.barcode,21)!=$1.checksum+48){$k[$j++]="bwipp.sscc18badCheckDigit#6639";$k[$j++]="Incorrect SSCC-18 check digit provided";bwipp_raiseerror()}}else{var _d=$s(22);$P(_d,0,$1.barcode);$p(_d,21,$1.checksum+48);$1.barcode=_d;var _i=$1.hasspace?2:1;var _j=$s($1.text.length+_i);$P(_j,_j.length-2," ");$p(_j,_j.length-1,$1.checksum+48);$P(_j,0,$1.text);$1.text=_j}$1.sscc=$G($1.barcode,4,18);$1.barcode=$s(25);$P($1.barcode,0,"^FNC100");var _r=$1.sscc;$P($1.barcode,7,_r);$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code128();var _w=$k[--$j];$1[$k[--$j]]=_w;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code39(){var $1=Object.create(bwipp_code39.$ctx||(bwipp_code39.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.validatecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.hidestars=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_code39.__6738__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["1113313111","3113111131","1133111131","3133111111","1113311131","3113311111","1133311111","1113113131","3113113111","1133113111","3111131131","1131131131","3131131111","1111331131","3111331111","1131331111","1111133131","3111133111","1131133111","1111333111","3111111331","1131111331","3131111311","1111311331","3111311311","1131311311","1111113331","3111113311","1131113311","1111313311","3311111131","1331111131","3331111111","1311311131","3311311111","1331311111","1311113131","3311113111","1331113111","1313131111","1313111311","1311131311","1113131311","1311313111"]);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($ctx.charvals,$G($ctx.barchars,_3,1),_3)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code39.$ctx[id]=$ctx[id]);bwipp_code39.__6738__=1})()}for(var _A=0,_9=$1.barcode.length-1;_A<=_9;_A+=1){var _E=$g($1.charvals,$G($1.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.code39badCharacter#6743";$k[$j++]="Code 39 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _H=$k[--$j];$k[$j++]=$f(_H-1)}var _I=$k[--$j];$1[$k[--$j]]=_I;$1.checksum=0;for(var _M=0,_L=$f($1.barlen-1);_M<=_L;_M+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_M,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.code39badCheckDigit#6757";$k[$j++]="Incorrect Code 39 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen);$1.includecheck=true}var _f=$1.includecheck?3:2;$1.sbs=$s($f($1.barlen+_f)*10);var _j=$1.includecheck?3:2;$1.txt=$a($f($1.barlen+_j));$P($1.sbs,0,$g($1.encs,43));if(!$1.hidestars){$p($1.txt,0,$a(["*",0,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,0,$a(["",0,$1.textyoffset,$1.textfont,$1.textsize]))}for(var _11=0,_10=$f($1.barlen-1);_11<=_10;_11+=1){$1.i=_11;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$P($1.sbs,$1.i*10+10,$g($1.encs,$1.indx));$p($1.txt,$1.i+1,$a([$G($1.barcode,$1.i,1),($1.i+1)*16,$1.textyoffset,$1.textfont,$1.textsize]))}if($1.includecheck){$P($1.sbs,$f($1.barlen*10+10),$g($1.encs,$1.checksum));if($1.includecheckintext){$p($1.txt,$f($1.barlen+1),$a([$G($1.barchars,$1.checksum,1),$f($1.barlen+1)*16,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$f($1.barlen+1),$a(["",$f($1.barlen+1)*16,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,$f($1.barlen*10+20),$g($1.encs,43));if(!$1.hidestars){$p($1.txt,$f($1.barlen+2),$a(["*",$f($1.barlen+2)*16,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$f($1.barlen+2),$a(["",$f($1.barlen+2)*16,$1.textyoffset,$1.textfont,$1.textsize]))}}else{$P($1.sbs,$f($1.barlen*10+10),$g($1.encs,43));if(!$1.hidestars){$p($1.txt,$f($1.barlen+1),$a(["*",$f($1.barlen+1)*16,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$f($1.barlen+1),$a(["",$f($1.barlen+1)*16,$1.textyoffset,$1.textfont,$1.textsize]))}}$k[$j++]=Infinity;$k[$j++]=Infinity;var _2M=$1.sbs;for(var _2N=0,_2O=_2M.length;_2N<_2O;_2N++){$k[$j++]=$g(_2M,_2N)-48}var _2Q=$a();$k[$j++]=Infinity;for(var _2S=0,_2T=~~(($1.sbs.length+1)/2);_2S<_2T;_2S++){$k[$j++]=$1.height}var _2V=$a();$k[$j++]=Infinity;for(var _2X=0,_2Y=~~(($1.sbs.length+1)/2);_2X<_2Y;_2X++){$k[$j++]=0}var _2Z=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_2Q;$k[$j++]="bhs";$k[$j++]=_2V;$k[$j++]="bbs";$k[$j++]=_2Z;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2d=$d();$k[$j++]=_2d;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code39ext(){var $1=Object.create(bwipp_code39ext.$ctx||(bwipp_code39ext.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.parse=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];$1[$k[--$j]]=_6;$1.barlen=$1.barcode.length;delete $1.options["parse"];$F($1.barcode,function(){if($k[--$j]>=128){$k[$j++]="bwipp.code39extBadCharacter#6877";$k[$j++]="Code 39 Extended must contain only ASCII characters";bwipp_raiseerror()}});if(!bwipp_code39ext.__6893__){(function(){var $ctx=Object.create($1);$ctx.extencs=$a(["%U","$A","$B","$C","$D","$E","$F","$G","$H","$I","$J","$K","$L","$M","$N","$O","$P","$Q","$R","$S","$T","$U","$V","$W","$X","$Y","$Z","%A","%B","%C","%D","%E"," ","/A","/B","/C","/D","/E","/F","/G","/H","/I","/J","/K","/L","-",".","/O","0","1","2","3","4","5","6","7","8","9","/Z","%F","%G","%H","%I","%J","%V","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","%K","%L","%M","%N","%O","%W","+A","+B","+C","+D","+E","+F","+G","+H","+I","+J","+K","+L","+M","+N","+O","+P","+Q","+R","+S","+T","+U","+V","+W","+X","+Y","+Z","%P","%Q","%R","%S","%T"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code39ext.$ctx[id]=$ctx[id]);bwipp_code39ext.__6893__=1})()}$1.newcode=$s($1.barlen*2);$1.newtext=$s($1.barlen*2);$1.j=0;for(var _K=0,_J=$1.barlen-1;_K<=_J;_K+=1){$1.i=_K;$1.extchar=$g($1.extencs,$g($1.barcode,$1.i));$P($1.newcode,$1.j,$1.extchar);var _X=$g($1.barcode,$1.i);$k[$j++]=$1.newtext;$k[$j++]=$1.j;$k[$j++]=_X;if(_X<32||_X==127){$j--;$k[$j++]=32}var _Y=$k[--$j];var _Z=$k[--$j];$p($k[--$j],_Z,_Y);if($1.extchar.length!=1){$p($1.newtext,$1.j+1,32)}$1.j=$1.j+$1.extchar.length}$1.newcode=$G($1.newcode,0,$1.j);$1.newtext=$G($1.newtext,0,$1.j);$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.newcode;$k[$j++]=$1.options;bwipp_code39();var _p=$k[--$j];$1[$k[--$j]]=_p;if($1.includetext){$1.txt=$g($1.args,"txt");for(var _w=0,_v=$1.newtext.length-1;_w<=_v;_w+=1){$1.i=_w;$1.txtentry=$g($1.txt,$1.i+1);$p($1.txtentry,0,$G($1.newtext,$1.i,1));$p($1.txt,$1.i+1,$1.txtentry)}$p($1.args,"txt",$1.txt)}$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code32(){var $1=Object.create(bwipp_code32.$ctx||(bwipp_code32.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.textxoffset=0;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.barcode.length!=8&&$1.barcode.length!=9){$k[$j++]="bwipp.code32badLength#6976";$k[$j++]="Italian Pharmacode must be 8 or 9 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.code32badCharacter#6980";$k[$j++]="Italian Pharmacode must contain only digits";bwipp_raiseerror()}});$1.checksum=0;for(var _6=0;_6<=7;_6+=1){$1.i=_6;$k[$j++]=$f($g($1.barcode,$1.i)-48);if($1.i%2!=0){var _B=$k[--$j];$k[$j++]=_B*2}var _C=$k[--$j];$k[$j++]=_C;if(_C>9){var _D=$k[--$j];$k[$j++]=$f(_D-9)}$1.checksum=$f($k[--$j]+$1.checksum)}$1.checksum=$1.checksum%10;if($1.barcode.length==9){if($g($1.barcode,8)!=$f($1.checksum+48)){$k[$j++]="bwipp.code32badCheckDigit#6994";$k[$j++]="Incorrect Italian Pharmacode check digit provided";bwipp_raiseerror()}}var _L=$s(10);$P(_L,0,$1.barcode);$p(_L,8,$f($1.checksum+48));$1.text=_L;$1.val=$R($s(6),$i($1.text),32);$1.barcode=$s(6);for(var _S=0;_S<=5;_S+=1){$p($1.barcode,_S,48)}$P($1.barcode,6-$1.val.length,$1.val);for(var _X=0;_X<=5;_X+=1){var _Z=$g($1.barcode,_X);$k[$j++]=_X;$k[$j++]=_Z;$k[$j++]=_Z;for(var _a=0,_b="AEIO".length;_a<_b;_a++){if($k[--$j]>=$g("AEIO",_a)){var _e=$k[--$j];$k[$j++]=$f(_e+1)}var _f=$k[--$j];$k[$j++]=_f;$k[$j++]=_f}$j--;var _h=$k[--$j];$p($1.barcode,$k[--$j],_h)}$P($1.text,1,$G($1.text,0,9));$p($1.text,0,65);$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code39();var _q=$k[--$j];var _r=$k[--$j];$1[_r]=_q;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_pzn(){var $1=Object.create(bwipp_pzn.$ctx||(bwipp_pzn.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.textxoffset=0;$1.height=1;$1.pzn8=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.pzn8){if($1.barcode.length!=7&&$1.barcode.length!=8){$k[$j++]="bwipp.pzn8badLength#7077";$k[$j++]="PZN8 must be 7 or 8 digits";bwipp_raiseerror()}}else{if($1.barcode.length!=6&&$1.barcode.length!=7){$k[$j++]="bwipp.pzn7badLength#7081";$k[$j++]="PZN7 must be 6 or 7 digits";bwipp_raiseerror()}}$F($1.barcode,function(){var _8=$k[--$j];if(_8<48||_8>57){$k[$j++]="bwipp.pznBadCharacter#7086";$k[$j++]="PZN must contain only digits";bwipp_raiseerror()}});var _A=$1.pzn8?9:8;$1.msglen=_A;$1.checksum=0;for(var _D=0,_C=$1.msglen-3;_D<=_C;_D+=1){$1.i=_D;var _J=$1.pzn8?1:2;$1.checksum=$f($f($g($1.barcode,$1.i)-48)*($1.i+_J)+$1.checksum)}$1.checksum=$1.checksum%11;if($1.checksum==10){$k[$j++]="bwipp.pznBadInputSequence#7100";$k[$j++]="Incorrect PZN input sequence provided";bwipp_raiseerror()}if($1.barcode.length==$1.msglen-1){if($g($1.barcode,$1.msglen-2)!=$f($1.checksum+48)){$k[$j++]="bwipp.pznBadCheckDigit#7104";$k[$j++]="Incorrect PZN check digit provided";bwipp_raiseerror()}}var _U=$s($1.msglen);$p(_U,0,45);$P(_U,1,$1.barcode);$p(_U,$1.msglen-1,$f($1.checksum+48));$1.msg=_U;$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.msg;$k[$j++]=$1.options;bwipp_code39();var _b=$k[--$j];$1[$k[--$j]]=_b;$1.text=$s($1.msglen+5);$P($1.text,0,"PZN - ");$P($1.text,6,$G($1.msg,1,$1.msglen-1));var _r=$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]);$p($1.args,"txt",_r);$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code93(){var $1=Object.create(bwipp_code93.$ctx||(bwipp_code93.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_code93.__7204__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["131112","111213","111312","111411","121113","121212","121311","111114","131211","141111","211113","211212","211311","221112","221211","231111","112113","112212","112311","122112","132111","111123","111222","111321","121122","131121","212112","212211","211122","211221","221121","222111","112122","112221","122121","123111","121131","311112","311211","321111","112131","113121","211131","121221","312111","311121","122211","111141","1111411"]);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($ctx.charvals,$g($ctx.barchars,_3),_3)}$ctx.sft1=-1;$ctx.sft2=-2;$ctx.sft3=-3;$ctx.sft4=-4;var _7=$ctx.charvals;$p(_7,$ctx.sft1,43);$p($ctx.charvals,$ctx.sft2,44);$p($ctx.charvals,$ctx.sft3,45);$p($ctx.charvals,$ctx.sft4,46);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code93.$ctx[id]=$ctx[id]);bwipp_code93.__7204__=1})()}var _M=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["SFT$",$1.sft1],["SFT%",$1.sft2],["SFT/",$1.sft3],["SFT+",$1.sft4]]);$1.fncvals=_M;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _P=$k[--$j];$1[$k[--$j]]=_P;$1.msglen=$1.msg.length;$F($1.msg,function(){var _V=$g($1.charvals,$k[--$j])!==undefined;if(!_V){$k[$j++]="bwipp.code93BadCharacter#7221";$k[$j++]="Code 93 must only contain digits, capital letters, spaces, the symbols -.$/+ and shift non-data characters";bwipp_raiseerror()}});if($1.includecheck){$1.sbs=$s($1.msglen*6+25)}else{$1.sbs=$s($1.msglen*6+13)}$1.txt=$a($1.msglen);$P($1.sbs,0,$g($1.encs,47));$1.checksum1=0;$1.checksum2=0;for(var _i=0,_h=$1.msglen-1;_i<=_h;_i+=1){$1.i=_i;$1.indx=$g($1.charvals,$g($1.msg,$1.i));$P($1.sbs,$1.i*6+6,$g($1.encs,$1.indx));var _v=$g($1.msg,$1.i);$k[$j++]="char";$k[$j++]=_v;if(_v<0){$j--;$k[$j++]=" "}else{var _w=$s(1);$p(_w,0,$k[--$j]);$k[$j++]=_w}var _y=$k[--$j];$1[$k[--$j]]=_y;$p($1.txt,$1.i,$a([$1.char,$1.i*9+9,$1.textyoffset,$1.textfont,$1.textsize]));$1.checksum1=$f($1.checksum1+(($1.msglen-$1.i-1)%20+1)*$1.indx);$1.checksum2=$f($1.checksum2+(($1.msglen-$1.i)%15+1)*$1.indx)}if($1.includecheck){$1.checksum1=$1.checksum1%47;$1.checksum2=$f($1.checksum2+$1.checksum1)%47;$P($1.sbs,$1.msglen*6+6,$g($1.encs,$1.checksum1));$P($1.sbs,$1.msglen*6+12,$g($1.encs,$1.checksum2));$P($1.sbs,$1.msglen*6+18,$g($1.encs,48))}else{$P($1.sbs,$1.msglen*6+6,$g($1.encs,48))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _1c=$1.sbs;for(var _1d=0,_1e=_1c.length;_1d<_1e;_1d++){$k[$j++]=$g(_1c,_1d)-48}var _1g=$a();$k[$j++]=Infinity;for(var _1i=0,_1j=~~(($1.sbs.length+1)/2);_1i<_1j;_1i++){$k[$j++]=$1.height}var _1l=$a();$k[$j++]=Infinity;for(var _1n=0,_1o=~~(($1.sbs.length+1)/2);_1n<_1o;_1n++){$k[$j++]=0}var _1p=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_1g;$k[$j++]="bhs";$k[$j++]=_1l;$k[$j++]="bbs";$k[$j++]=_1p;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _1t=$d();$k[$j++]=_1t;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code93ext(){var $1=Object.create(bwipp_code93ext.$ctx||(bwipp_code93ext.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.parse=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];var _7=$k[--$j];$1[_7]=_6;$1.barlen=$1.barcode.length;delete $1.options["parse"];if(!bwipp_code93ext.__7349__){(function(){var $ctx=Object.create($1);$ctx.extencs=$a(["^SFT%U","^SFT$A","^SFT$B","^SFT$C","^SFT$D","^SFT$E","^SFT$F","^SFT$G","^SFT$H","^SFT$I","^SFT$J","^SFT$K","^SFT$L","^SFT$M","^SFT$N","^SFT$O","^SFT$P","^SFT$Q","^SFT$R","^SFT$S","^SFT$T","^SFT$U","^SFT$V","^SFT$W","^SFT$X","^SFT$Y","^SFT$Z","^SFT%A","^SFT%B","^SFT%C","^SFT%D","^SFT%E"," ","^SFT/A","^SFT/B","^SFT/C","$","%","^SFT/F","^SFT/G","^SFT/H","^SFT/I","^SFT/J","+","^SFT/L","-",".","/","0","1","2","3","4","5","6","7","8","9","^SFT/Z","^SFT%F","^SFT%G","^SFT%H","^SFT%I","^SFT%J","^SFT%V","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","^SFT%K","^SFT%L","^SFT%M","^SFT%N","^SFT%O","^SFT%W","^SFT+A","^SFT+B","^SFT+C","^SFT+D","^SFT+E","^SFT+F","^SFT+G","^SFT+H","^SFT+I","^SFT+J","^SFT+K","^SFT+L","^SFT+M","^SFT+N","^SFT+O","^SFT+P","^SFT+Q","^SFT+R","^SFT+S","^SFT+T","^SFT+U","^SFT+V","^SFT+W","^SFT+X","^SFT+Y","^SFT+Z","^SFT%P","^SFT%Q","^SFT%R","^SFT%S","^SFT%T"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code93ext.$ctx[id]=$ctx[id]);bwipp_code93ext.__7349__=1})()}$1.newcode=$s($1.barlen*6);$1.newtext=$s($1.barlen*6);$1.j=0;$1.k=0;for(var _I=0,_H=$1.barlen-1;_I<=_H;_I+=1){$1.i=_I;var _L=$g($1.barcode,$1.i);$k[$j++]=_L;if(_L>127){$j--;$k[$j++]="bwipp.code93extbadCharacter#7358";$k[$j++]="Code 93 Extended only support ASCII characters with values 0 to 127";bwipp_raiseerror()}$1.extchar=$g($1.extencs,$k[--$j]);$1.extlen=$1.extchar.length;$P($1.newcode,$1.j,$1.extchar);var _X=$g($1.barcode,$1.i);$k[$j++]=$1.newtext;$k[$j++]=$1.k;$k[$j++]=_X;if(_X<32||_X==127){$j--;$k[$j++]=32}var _Y=$k[--$j];var _Z=$k[--$j];$p($k[--$j],_Z,_Y);if($1.extlen!=1){$p($1.newtext,$1.k+1,32)}$1.j=$1.j+$1.extlen;var _i=$1.extlen==1?1:2;$1.k=$1.k+_i}$1.newcode=$G($1.newcode,0,$1.j);$1.newtext=$G($1.newtext,0,$1.k);$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.newcode;$k[$j++]=$1.options;bwipp_code93();var _t=$k[--$j];$1[$k[--$j]]=_t;if($1.includetext){$1.txt=$g($1.args,"txt");for(var _10=0,_z=$1.newtext.length-1;_10<=_z;_10+=1){$1.i=_10;$1.txtentry=$g($1.txt,$1.i);$p($1.txtentry,0,$G($1.newtext,$1.i,1));$p($1.txt,$1.i,$1.txtentry)}$p($1.args,"txt",$1.txt)}$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_interleaved2of5(){var $1=Object.create(bwipp_interleaved2of5.$ctx||(bwipp_interleaved2of5.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$F($1.barcode,function(){var _3=$k[--$j];if(_3<48||_3>57){$k[$j++]="bwipp.interleaved2of5badCharacter#7444";$k[$j++]="Interleaved 2 of 5 must contain only digits";bwipp_raiseerror()}});$1.barlen=$1.barcode.length;if($1.barlen%2==0&&$1.includecheck||$1.barlen%2!=0&&!$1.includecheck){$1.pad=$s($1.barlen+1);$p($1.pad,0,48);$P($1.pad,1,$1.barcode);$1.barcode=$1.pad;$1.barlen=$1.barlen+1}if($1.includecheck){$1.checksum=0;for(var _J=0,_I=$1.barlen-1;_J<=_I;_J+=1){$1.i=_J;if($1.i%2==0){$1.checksum=$1.checksum+($g($1.barcode,$1.i)-48)*3}else{$1.checksum=$1.checksum+($g($1.barcode,$1.i)-48)}}$1.checksum=(10-$1.checksum%10)%10;$1.pad=$s($1.barlen+1);$P($1.pad,0,$1.barcode);$p($1.pad,$1.barlen,$1.checksum+48);$1.barcode=$1.pad;$1.barlen=$1.barlen+1}if(!bwipp_interleaved2of5.__7490__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["11221","21112","12112","22111","11212","21211","12211","11122","21121","12121","1111","2111"]);$ctx.barchars="0123456789";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_interleaved2of5.$ctx[id]=$ctx[id]);bwipp_interleaved2of5.__7490__=1})()}$1.sbs=$s($1.barlen*5+8);$1.txt=$a($1.barlen);$P($1.sbs,0,$g($1.encs,10));for(var _o=0,_n=$1.barlen-1;_o<=_n;_o+=2){$1.i=_o;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enca=$g($1.encs,$1.indx);$X($1.barchars,$G($1.barcode,$1.i+1,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.encb=$g($1.encs,$1.indx);$1.intl=$s($1.enca.length*2);for(var _19=0,_18=$1.enca.length-1;_19<=_18;_19+=1){$1.j=_19;$1.achar=$g($1.enca,$1.j);$1.bchar=$g($1.encb,$1.j);$p($1.intl,$1.j*2,$1.achar);$p($1.intl,$1.j*2+1,$1.bchar)}$P($1.sbs,$1.i*5+4,$1.intl);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*9+4,$1.textyoffset,$1.textfont,$1.textsize]));if($1.includecheck&&!$1.includecheckintext&&$1.barlen-2==$1.i){$p($1.txt,$1.i+1,$a([" ",($1.i+1)*9+4,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.i+1,$a([$G($1.barcode,$1.i+1,1),($1.i+1)*9+4,$1.textyoffset,$1.textfont,$1.textsize]))}}$P($1.sbs,$1.barlen*5+4,$g($1.encs,11));$k[$j++]=Infinity;$k[$j++]=Infinity;var _1y=$1.sbs;for(var _1z=0,_20=_1y.length;_1z<_20;_1z++){$k[$j++]=$g(_1y,_1z)-48}var _22=$a();$k[$j++]=Infinity;for(var _24=0,_25=~~(($1.sbs.length+1)/2);_24<_25;_24++){$k[$j++]=$1.height}var _27=$a();$k[$j++]=Infinity;for(var _29=0,_2A=~~(($1.sbs.length+1)/2);_29<_2A;_29++){$k[$j++]=0}var _2B=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_22;$k[$j++]="bhs";$k[$j++]=_27;$k[$j++]="bbs";$k[$j++]=_2B;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="barratio";$k[$j++]=2;$k[$j++]="spaceratio";$k[$j++]=2;$k[$j++]="opt";$k[$j++]=$1.options;var _2F=$d();$k[$j++]=_2F;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_itf14(){var $1=Object.create(bwipp_itf14.$ctx||(bwipp_itf14.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.includecheckintext=true;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=3;$1.height=.5;$1.showborder=true;$1.borderwidth=4;$1.borderleft=15;$1.borderright=15;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$1.text=$1.barcode;var _3=$1.barcode;$k[$j++]=$s(_3.length);$k[$j++]=0;$F(_3,function(){var _5=$k[--$j];$k[$j++]=_5;if(_5!=32){var _6=$k[--$j];var _7=$k[--$j];var _8=$k[--$j];$p(_8,_7,_6);$k[$j++]=_8;$k[$j++]=$f(_7+1)}else{$j--}});var _9=$k[--$j];$1.barcode=$G($k[--$j],0,_9);$1.hasspace=$1.text.length!=$1.barcode.length;if($1.barcode.length!=13&&$1.barcode.length!=14){$k[$j++]="bwipp.itf14badLength#7610";$k[$j++]="ITF-14 must be 13 or 14 digits";bwipp_raiseerror()}var _G=$1.barcode;for(var _H=0,_I=_G.length;_H<_I;_H++){var _J=$g(_G,_H);if(_J<48||_J>57){$k[$j++]="bwipp.itf14badCharacter#7614";$k[$j++]="ITF-14 must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _K=0;_K<=12;_K+=1){$1.i=_K;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i)-48);if($1.i%2==0){var _Q=$k[--$j];$k[$j++]=_Q*3}var _R=$k[--$j];var _S=$k[--$j];$1[$k[--$j]]=$f(_S+_R)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==14){if($g($1.barcode,13)!=$1.checksum+48){$k[$j++]="bwipp.itf14badCheckDigit#7627";$k[$j++]="Incorrect ITF-14 check digit provided";bwipp_raiseerror()}}else{var _Z=$s(14);$P(_Z,0,$1.barcode);$p(_Z,13,$1.checksum+48);$1.barcode=_Z;var _e=$1.hasspace?2:1;var _f=$s($1.text.length+_e);$P(_f,_f.length-2," ");$p(_f,_f.length-1,$1.checksum+48);$P(_f,0,$1.text);$1.text=_f}var _i=$1.options;$p(_i,"dontdraw",true);$p($1.options,"showborder",$1.showborder);$p($1.options,"borderwidth",$1.borderwidth);$p($1.options,"borderleft",$1.borderleft);$p($1.options,"borderright",$1.borderright);var _r=$1.options;$p(_r,"height",$1.height);$p($1.options,"textyoffset",$1.textyoffset);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_interleaved2of5();var _x=$k[--$j];$1[$k[--$j]]=_x;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_identcode(){var $1=Object.create(bwipp_identcode.$ctx||(bwipp_identcode.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.barcode.length!=11&&$1.barcode.length!=12){$k[$j++]="bwipp.identcodeBadLength#7703";$k[$j++]="Deutsche Post Identcode must be 11 or 12 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.identcodeBadCharacter#7707";$k[$j++]="Deutsche Post Identcode must contain only digits";bwipp_raiseerror()}});$1.checksum=0;for(var _6=0;_6<=10;_6+=1){$1.i=_6;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i)-48);if($1.i%2==0){var _C=$k[--$j];$k[$j++]=_C*4}else{var _D=$k[--$j];$k[$j++]=_D*9}var _E=$k[--$j];var _F=$k[--$j];$1[$k[--$j]]=$f(_F+_E)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==12){if($g($1.barcode,11)!=$1.checksum+48){$k[$j++]="bwipp.identcodeBadCheckDigit#7720";$k[$j++]="Incorrect Deutsche Post Identcode check digit provided";bwipp_raiseerror()}}var _M=$s(12);$P(_M,0,$1.barcode);$p(_M,11,$1.checksum+48);$1.barcode=_M;$1.text=$Z($s(16),"  .       .     ");$P($1.text,0,$G($1.barcode,0,2));$P($1.text,3,$G($1.barcode,2,3));$P($1.text,7,$G($1.barcode,5,3));$P($1.text,11,$G($1.barcode,8,3));$P($1.text,15,$G($1.barcode,11,1));$p($1.options,"dontdraw",true);$p($1.options,"includecheck",false);var _i=$1.barcode;$k[$j++]="args";$k[$j++]=_i;$k[$j++]=$1.options;bwipp_interleaved2of5();var _k=$k[--$j];$1[$k[--$j]]=_k;var _r=$1.textsize;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,_r])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_leitcode(){var $1=Object.create(bwipp_leitcode.$ctx||(bwipp_leitcode.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.barcode.length!=13&&$1.barcode.length!=14){$k[$j++]="bwipp.leitcodeBadLength#7793";$k[$j++]="Deutsche Post Leitcode must be 13 or 14 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.leitcodeBadCharacter#7797";$k[$j++]="Deutsche Post Leitcode must contain only digits";bwipp_raiseerror()}});$1.checksum=0;for(var _6=0;_6<=12;_6+=1){$1.i=_6;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i)-48);if($1.i%2==0){var _C=$k[--$j];$k[$j++]=_C*4}else{var _D=$k[--$j];$k[$j++]=_D*9}var _E=$k[--$j];var _F=$k[--$j];$1[$k[--$j]]=$f(_F+_E)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==14){if($g($1.barcode,13)!=$1.checksum+48){$k[$j++]="bwipp.leitcodeBadCheckDigit#7810";$k[$j++]="Incorrect Deutsche Post Leitcode check digit provided";bwipp_raiseerror()}}var _M=$s(14);$P(_M,0,$1.barcode);$p(_M,13,$1.checksum+48);$1.barcode=_M;$1.text=$Z($s(18),"     .   .   .    ");$P($1.text,0,$G($1.barcode,0,5));$P($1.text,6,$G($1.barcode,5,3));$P($1.text,10,$G($1.barcode,8,3));$P($1.text,14,$G($1.barcode,11,2));$P($1.text,17,$G($1.barcode,13,1));$p($1.options,"dontdraw",true);$p($1.options,"includecheck",false);var _i=$1.barcode;$k[$j++]="args";$k[$j++]=_i;$k[$j++]=$1.options;bwipp_interleaved2of5();var _k=$k[--$j];$1[$k[--$j]]=_k;var _r=$1.textsize;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,_r])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_databaromni(){var $1=Object.create(bwipp_databaromni.$ctx||(bwipp_databaromni.$ctx={}));$1.dontdraw=false;$1.height=33/72;$1.linkage=false;$1.format="omni";$1.barxmult=33;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($G($1.barcode,0,4),"(01)")){$k[$j++]="bwipp.databaromniBadAI#7882";$k[$j++]="GS1 DataBar Omnidirectional must begin with (01) application identifier";bwipp_raiseerror()}if($1.barcode.length!=17&&$1.barcode.length!=18){$k[$j++]="bwipp.databaromniBadLength#7885";$k[$j++]="GS1 DataBar Omnidirectional must be 13 or 14 digits";bwipp_raiseerror()}var _8=$G($1.barcode,4,$1.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databaromniBadCharacter#7889";$k[$j++]="GS1 DataBar Omnidirectional must contain only digits";bwipp_raiseerror()}}if($1.barxmult<33){$k[$j++]="bwipp.databarStackedOmniBarXmult#7894";$k[$j++]="GS1 DataBar Stacked Omnidirectional must have a barxmult of at least 33";bwipp_raiseerror()}if($ne($1.format,"omni")&&$ne($1.format,"stacked")&&$ne($1.format,"stackedomni")&&$ne($1.format,"truncated")){$k[$j++]="bwipp.databaromniBadFormat#7898";$k[$j++]="Valid formats are omni, stacked, stackedomni and truncated";bwipp_raiseerror()}if($eq($1.format,"truncated")){$1.height=13/72}$1.checksum=0;for(var _I=0;_I<=12;_I+=1){$1.i=_I;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _O=$k[--$j];$k[$j++]=_O*3}var _P=$k[--$j];var _Q=$k[--$j];$1[$k[--$j]]=$f(_Q+_P)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==18){if($g($1.barcode,17)!=$1.checksum+48){$k[$j++]="bwipp.databaromniBadCheckDigit#7914";$k[$j++]="Incorrect GS1 DataBar Omnidirectional check digit provided";bwipp_raiseerror()}}var _X=$s(18);$P(_X,0,$1.barcode);$p(_X,17,$1.checksum+48);$1.barcode=_X;$1.txt=$a($1.barcode.length);for(var _e=0,_d=$1.barcode.length-1;_e<=_d;_e+=1){$1.i=_e;$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),0,0,"",0]))}$1.ncr=function(){var _l=$k[--$j];var _m=$k[--$j];var _n=$f(_m-_l);if(_l<$f(_m-_l)){var _=_n;_n=_l;_l=_}$k[$j++]=_n;$k[$j++]=1;$k[$j++]=1;for(var _p=_m,_o=$f(_l+1);_p>=_o;_p-=1){var _q=$k[--$j];var _r=$k[--$j];var _s=$k[--$j];$k[$j++]=_s;$k[$j++]=_r;$k[$j++]=_q*_p;if($le(_r,_s)){var _t=$k[--$j];var _u=$k[--$j];$k[$j++]=$f(_u+1);$k[$j++]=~~(_t/_u)}}for(;;){var _v=$k[--$j];var _w=$k[--$j];var _x=$k[--$j];$k[$j++]=_x;$k[$j++]=_w;$k[$j++]=_v;if($gt(_w,_x)){break}var _y=$k[--$j];var _z=$k[--$j];$k[$j++]=$f(_z+1);$k[$j++]=~~(_y/_z)}var _10=$k[--$j];var _11=$k[--$j];$k[$j++]=_10;$k[$j++]=_11;$j--;var _12=$k[--$j];var _13=$k[--$j];$k[$j++]=_12;$k[$j++]=_13;$j--};$1.getRSSwidths=function(){$1.oe=$k[--$j];$1.el=$k[--$j];$1.mw=$k[--$j];$1.nm=$k[--$j];$1.val=$k[--$j];$1.out=$a($1.el);$1.mask=0;for(var _1D=0,_1C=$f($1.el-2);_1D<=_1C;_1D+=1){$1.bar=_1D;$1.ew=1;var _1F=$1.bar;$1.mask=$1.mask|(_1F<0?1>>>-_1F:1<<_1F);for(;;){$k[$j++]="sval";$k[$j++]=$f($f($1.nm-$1.ew)-1);$k[$j++]=$f($f($1.el-$1.bar)-2);$1.ncr();var _1K=$k[--$j];$1[$k[--$j]]=_1K;if($1.oe&&$1.mask==0&&$f($f($f($1.nm-$1.ew)-$1.el*2)+$1.bar*2)>=-2){$k[$j++]="sval";$k[$j++]=$1.sval;$k[$j++]=$f($f($f($1.nm-$1.ew)-$1.el)+$1.bar);$k[$j++]=$f($f($1.el-$1.bar)-2);$1.ncr();var _1Z=$k[--$j];var _1a=$k[--$j];$1[$k[--$j]]=$f(_1a-_1Z)}if($f($1.el-$1.bar)>2){$1.lval=0;for(var _1k=$f($f($f($f($1.nm-$1.ew)-$1.el)+$1.bar)+2),_1j=$f($1.mw+1);_1k>=_1j;_1k-=1){$k[$j++]=$f($f($f($1.nm-_1k)-$1.ew)-1);$k[$j++]=$f($f($1.el-$1.bar)-3);$1.ncr();$1.lval=$f($k[--$j]+$1.lval)}$1.sval=$f($1.sval-$1.lval*$f($f($1.el-$1.bar)-1))}else{if($f($1.nm-$1.ew)>$1.mw){$1.sval=$f($1.sval-1)}}$1.val=$f($1.val-$1.sval);if($1.val<0){break}$1.ew=$1.ew+1;var _24=$1.bar;$1.mask=$1.mask&~(_24<0?1>>>-_24:1<<_24)}$1.val=$f($1.val+$1.sval);$1.nm=$f($1.nm-$1.ew);$p($1.out,$1.bar,$1.ew)}$p($1.out,$f($1.el-1),$1.nm);$k[$j++]=$1.out};$k[$j++]=Infinity;var _2H=$1.linkage?1:0;var _2J=$G($1.barcode,4,13);$k[$j++]=_2H;for(var _2K=0,_2L=_2J.length;_2K<_2L;_2K++){$k[$j++]=$f($g(_2J,_2K)-48)}$1.binval=$a();for(var _2O=0;_2O<=12;_2O+=1){$1.i=_2O;var _2P=$1.binval;var _2Q=$1.i;$p(_2P,_2Q+1,$f($g(_2P,_2Q+1)+$g($1.binval,$1.i)%4537077*10));$p($1.binval,$1.i,~~($g($1.binval,$1.i)/4537077))}$1.right=$g($1.binval,13)%4537077;var _2c=$1.binval;$p(_2c,13,~~($g(_2c,13)/4537077));$1.left=0;$1.i=true;for(var _2e=0;_2e<=13;_2e+=1){$1.j=_2e;var _2h=$g($1.binval,$1.j);$k[$j++]=_2h;if(_2h==0&&$1.i){$j--}else{$1.i=false;$1.left=$f($1.left+$k[--$j]*~~Math.pow(10,13-$1.j))}}$1.d1=~~($1.left/1597);$1.d2=$1.left%1597;$1.d3=~~($1.right/1597);$1.d4=$1.right%1597;if(!bwipp_databaromni.__8030__){(function(){var $ctx=Object.create($1);$ctx.tab164=$a([160,0,12,4,8,1,161,1,960,161,10,6,6,3,80,10,2014,961,8,8,4,5,31,34,2714,2015,6,10,3,6,10,70,2840,2715,4,12,1,8,1,126]);$ctx.tab154=$a([335,0,5,10,2,7,4,84,1035,336,7,8,4,5,20,35,1515,1036,9,6,6,3,48,10,1596,1516,11,4,8,1,81,1]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databaromni.$ctx[id]=$ctx[id]);bwipp_databaromni.__8030__=1})()}$1.i=0;for(;;){if($1.d1<=$g($1.tab164,$1.i)){var _2z=$G($1.tab164,$1.i+1,7);for(var _30=0,_31=_2z.length;_30<_31;_30++){$k[$j++]=$g(_2z,_30)}$1.d1te=$k[--$j];$1.d1to=$k[--$j];$1.d1mwe=$k[--$j];$1.d1mwo=$k[--$j];$1.d1ele=$k[--$j];$1.d1elo=$k[--$j];$1.d1gs=$k[--$j];break}$1.i=$1.i+8}$1.i=0;for(;;){if($1.d2<=$g($1.tab154,$1.i)){var _3H=$G($1.tab154,$1.i+1,7);for(var _3I=0,_3J=_3H.length;_3I<_3J;_3I++){$k[$j++]=$g(_3H,_3I)}$1.d2te=$k[--$j];$1.d2to=$k[--$j];$1.d2mwe=$k[--$j];$1.d2mwo=$k[--$j];$1.d2ele=$k[--$j];$1.d2elo=$k[--$j];$1.d2gs=$k[--$j];break}$1.i=$1.i+8}$1.i=0;for(;;){if($1.d3<=$g($1.tab164,$1.i)){var _3Z=$G($1.tab164,$1.i+1,7);for(var _3a=0,_3b=_3Z.length;_3a<_3b;_3a++){$k[$j++]=$g(_3Z,_3a)}$1.d3te=$k[--$j];$1.d3to=$k[--$j];$1.d3mwe=$k[--$j];$1.d3mwo=$k[--$j];$1.d3ele=$k[--$j];$1.d3elo=$k[--$j];$1.d3gs=$k[--$j];break}$1.i=$1.i+8}$1.i=0;for(;;){if($1.d4<=$g($1.tab154,$1.i)){var _3r=$G($1.tab154,$1.i+1,7);for(var _3s=0,_3t=_3r.length;_3s<_3t;_3s++){$k[$j++]=$g(_3r,_3s)}$1.d4te=$k[--$j];$1.d4to=$k[--$j];$1.d4mwe=$k[--$j];$1.d4mwo=$k[--$j];$1.d4ele=$k[--$j];$1.d4elo=$k[--$j];$1.d4gs=$k[--$j];break}$1.i=$1.i+8}$k[$j++]="d1wo";$k[$j++]=~~($f($1.d1-$1.d1gs)/$1.d1te);$k[$j++]=$1.d1elo;$k[$j++]=$1.d1mwo;$k[$j++]=4;$k[$j++]=false;$1.getRSSwidths();var _48=$k[--$j];$1[$k[--$j]]=_48;$k[$j++]="d1we";$k[$j++]=$f($1.d1-$1.d1gs)%$1.d1te;$k[$j++]=$1.d1ele;$k[$j++]=$1.d1mwe;$k[$j++]=4;$k[$j++]=true;$1.getRSSwidths();var _4F=$k[--$j];$1[$k[--$j]]=_4F;$k[$j++]="d2wo";$k[$j++]=$f($1.d2-$1.d2gs)%$1.d2to;$k[$j++]=$1.d2elo;$k[$j++]=$1.d2mwo;$k[$j++]=4;$k[$j++]=true;$1.getRSSwidths();var _4M=$k[--$j];$1[$k[--$j]]=_4M;$k[$j++]="d2we";$k[$j++]=~~($f($1.d2-$1.d2gs)/$1.d2to);$k[$j++]=$1.d2ele;$k[$j++]=$1.d2mwe;$k[$j++]=4;$k[$j++]=false;$1.getRSSwidths();var _4T=$k[--$j];$1[$k[--$j]]=_4T;$k[$j++]="d3wo";$k[$j++]=~~($f($1.d3-$1.d3gs)/$1.d3te);$k[$j++]=$1.d3elo;$k[$j++]=$1.d3mwo;$k[$j++]=4;$k[$j++]=false;$1.getRSSwidths();var _4a=$k[--$j];$1[$k[--$j]]=_4a;$k[$j++]="d3we";$k[$j++]=$f($1.d3-$1.d3gs)%$1.d3te;$k[$j++]=$1.d3ele;$k[$j++]=$1.d3mwe;$k[$j++]=4;$k[$j++]=true;$1.getRSSwidths();var _4h=$k[--$j];$1[$k[--$j]]=_4h;$k[$j++]="d4wo";$k[$j++]=$f($1.d4-$1.d4gs)%$1.d4to;$k[$j++]=$1.d4elo;$k[$j++]=$1.d4mwo;$k[$j++]=4;$k[$j++]=true;$1.getRSSwidths();var _4o=$k[--$j];$1[$k[--$j]]=_4o;$k[$j++]="d4we";$k[$j++]=~~($f($1.d4-$1.d4gs)/$1.d4to);$k[$j++]=$1.d4ele;$k[$j++]=$1.d4mwe;$k[$j++]=4;$k[$j++]=false;$1.getRSSwidths();var _4v=$k[--$j];$1[$k[--$j]]=_4v;$1.d1w=$a(8);for(var _4y=0;_4y<=3;_4y+=1){$1.i=_4y;$p($1.d1w,$1.i*2,$g($1.d1wo,$1.i));$p($1.d1w,$1.i*2+1,$g($1.d1we,$1.i))}$1.d2w=$a(8);for(var _5A=0;_5A<=3;_5A+=1){$1.i=_5A;$p($1.d2w,7-$1.i*2,$g($1.d2wo,$1.i));$p($1.d2w,6-$1.i*2,$g($1.d2we,$1.i))}$1.d3w=$a(8);for(var _5M=0;_5M<=3;_5M+=1){$1.i=_5M;$p($1.d3w,7-$1.i*2,$g($1.d3wo,$1.i));$p($1.d3w,6-$1.i*2,$g($1.d3we,$1.i))}$1.d4w=$a(8);for(var _5Y=0;_5Y<=3;_5Y+=1){$1.i=_5Y;$p($1.d4w,$1.i*2,$g($1.d4wo,$1.i));$p($1.d4w,$1.i*2+1,$g($1.d4we,$1.i))}$k[$j++]=Infinity;var _5j=$1.d1w;for(var _5k=0,_5l=_5j.length;_5k<_5l;_5k++){$k[$j++]=$g(_5j,_5k)}var _5n=$1.d2w;for(var _5o=0,_5p=_5n.length;_5o<_5p;_5o++){$k[$j++]=$g(_5n,_5o)}var _5r=$1.d3w;for(var _5s=0,_5t=_5r.length;_5s<_5t;_5s++){$k[$j++]=$g(_5r,_5s)}var _5v=$1.d4w;for(var _5w=0,_5x=_5v.length;_5w<_5x;_5w++){$k[$j++]=$g(_5v,_5w)}$1.widths=$a();if(!bwipp_databaromni.__8137__){(function(){var $ctx=Object.create($1);$ctx.checkweights=$a([1,3,9,27,2,6,18,54,58,72,24,8,29,36,12,4,74,51,17,32,37,65,48,16,64,34,23,69,49,68,46,59]);$ctx.checkwidths=$a([3,8,2,1,1,3,5,5,1,1,3,3,7,1,1,3,1,9,1,1,2,7,4,1,1,2,5,6,1,1,2,3,8,1,1,1,5,7,1,1,1,3,9,1,1]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databaromni.$ctx[id]=$ctx[id]);bwipp_databaromni.__8137__=1})()}$1.checksum=0;for(var _63=0;_63<=31;_63+=1){$1.i=_63;$1.checksum=$f($1.checksum+$g($1.widths,$1.i)*$g($1.checkweights,$1.i))}$1.checksum=$1.checksum%79;if($1.checksum>=8){$1.checksum=$f($1.checksum+1)}if($1.checksum>=72){$1.checksum=$f($1.checksum+1)}$1.checklt=$G($1.checkwidths,~~($1.checksum/9)*5,5);$1.checkrtrev=$G($1.checkwidths,$1.checksum%9*5,5);$1.checkrt=$a(5);for(var _6N=0;_6N<=4;_6N+=1){$1.i=_6N;$p($1.checkrt,$1.i,$g($1.checkrtrev,4-$1.i))}if($eq($1.format,"omni")||$eq($1.format,"truncated")){$k[$j++]=Infinity;var _6V=$1.d1w;$k[$j++]=1;for(var _6W=0,_6X=_6V.length;_6W<_6X;_6W++){$k[$j++]=$g(_6V,_6W)}var _6Z=$1.checklt;for(var _6a=0,_6b=_6Z.length;_6a<_6b;_6a++){$k[$j++]=$g(_6Z,_6a)}var _6d=$1.d2w;for(var _6e=0,_6f=_6d.length;_6e<_6f;_6e++){$k[$j++]=$g(_6d,_6e)}var _6h=$1.d4w;for(var _6i=0,_6j=_6h.length;_6i<_6j;_6i++){$k[$j++]=$g(_6h,_6i)}var _6l=$1.checkrt;for(var _6m=0,_6n=_6l.length;_6m<_6n;_6m++){$k[$j++]=$g(_6l,_6m)}var _6p=$1.d3w;for(var _6q=0,_6r=_6p.length;_6q<_6r;_6q++){$k[$j++]=$g(_6p,_6q)}$k[$j++]=1;$k[$j++]=1;$1.sbs=$a();$k[$j++]=Infinity;var _6u=$1.sbs;$k[$j++]=Infinity;for(var _6w=0,_6x=~~(($1.sbs.length+1)/2);_6w<_6x;_6w++){$k[$j++]=$1.height}var _6z=$a();$k[$j++]=Infinity;for(var _71=0,_72=~~(($1.sbs.length+1)/2);_71<_72;_71++){$k[$j++]=0}var _73=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_6u;$k[$j++]="bhs";$k[$j++]=_6z;$k[$j++]="bbs";$k[$j++]=_73;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$1.options;var _76=$d();$k[$j++]=_76;if(!$1.dontdraw){bwipp_renlinear()}}else{$k[$j++]=Infinity;var _78=$1.d1w;$k[$j++]=1;$k[$j++]=1;for(var _79=0,_7A=_78.length;_79<_7A;_79++){$k[$j++]=$g(_78,_79)}var _7C=$1.checklt;for(var _7D=0,_7E=_7C.length;_7D<_7E;_7D++){$k[$j++]=$g(_7C,_7D)}var _7G=$1.d2w;for(var _7H=0,_7I=_7G.length;_7H<_7I;_7H++){$k[$j++]=$g(_7G,_7H)}$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$1.top=$a();$k[$j++]=Infinity;var _7L=$1.d4w;$k[$j++]=1;$k[$j++]=1;for(var _7M=0,_7N=_7L.length;_7M<_7N;_7M++){$k[$j++]=$g(_7L,_7M)}var _7P=$1.checkrt;for(var _7Q=0,_7R=_7P.length;_7Q<_7R;_7Q++){$k[$j++]=$g(_7P,_7Q)}var _7T=$1.d3w;for(var _7U=0,_7V=_7T.length;_7U<_7V;_7U++){$k[$j++]=$g(_7T,_7U)}$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$1.bot=$a();for(var _7Y=0;_7Y<=24;_7Y+=2){$1.i=_7Y;for(var _7c=0,_7d=$g($1.top,$1.i);_7c<_7d;_7c++){$k[$j++]=0}for(var _7h=0,_7i=$g($1.top,$1.i+1);_7h<_7i;_7h++){$k[$j++]=1}}$as($a(50));$1.top=$k[--$j];for(var _7l=0;_7l<=24;_7l+=2){$1.i=_7l;for(var _7p=0,_7q=$g($1.bot,$1.i);_7p<_7q;_7p++){$k[$j++]=1}for(var _7u=0,_7v=$g($1.bot,$1.i+1);_7u<_7v;_7u++){$k[$j++]=0}}$as($a(50));$1.bot=$k[--$j];if($eq($1.format,"stacked")){$1.sep=$a(50);$p($1.sep,0,0);for(var _81=1;_81<=49;_81+=1){$1.i=_81;if($eq($g($1.top,$1.i),$g($1.bot,$1.i))){$p($1.sep,$1.i,$f(1-$g($1.top,$1.i)))}else{$p($1.sep,$1.i,$f(1-$g($1.sep,$1.i-1)))}}$P($1.sep,0,$a([0,0,0,0]));$P($1.sep,46,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _8M=0,_8N=5;_8M<_8N;_8M++){$q($1.top)}$q($1.sep);for(var _8Q=0,_8R=7;_8Q<_8R;_8Q++){$q($1.bot)}$1.pixs=$a();$1.pixy=~~($1.pixs.length/50)}if($eq($1.format,"stackedomni")){$k[$j++]=Infinity;$F($1.top,function(){var _8X=$k[--$j];$k[$j++]=$f(1-_8X)});$1.sep1=$a();$P($1.sep1,0,$a([0,0,0,0]));$P($1.sep1,46,$a([0,0,0,0]));for(var _8d=18;_8d<=30;_8d+=1){$1.i=_8d;if($g($1.top,$1.i)==0){if($g($1.top,$1.i-1)==1){$k[$j++]=1}else{var _8n=$g($1.sep1,$1.i-1)==0?1:0;$k[$j++]=_8n}}else{$k[$j++]=0}$p($1.sep1,$1.i,$k[--$j])}$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _8r=0,_8s=21;_8r<_8s;_8r++){$k[$j++]=0;$k[$j++]=1}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$1.sep2=$a();$k[$j++]=Infinity;$F($1.bot,function(){var _8v=$k[--$j];$k[$j++]=$f(1-_8v)});$1.sep3=$a();$P($1.sep3,0,$a([0,0,0,0]));$P($1.sep3,46,$a([0,0,0,0]));for(var _91=19;_91<=31;_91+=1){$1.i=_91;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _9B=$g($1.sep3,$1.i-1)==0?1:0;$k[$j++]=_9B}}else{$k[$j++]=0}$p($1.sep3,$1.i,$k[--$j])}$1.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _9G=0;_9G<=12;_9G+=1){var _9L=$k[--$j];$k[$j++]=_9L&&$eq($g($1.bot,_9G+19),$g($1.f3,_9G))}if($k[--$j]){$P($1.sep3,19,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}$k[$j++]=Infinity;for(var _9Q=0,_9R=$1.barxmult;_9Q<_9R;_9Q++){$q($1.top)}$q($1.sep1);$q($1.sep2);$q($1.sep3);for(var _9X=0,_9Y=$1.barxmult;_9X<_9Y;_9X++){$q($1.bot)}$1.pixs=$a();$1.pixy=~~($1.pixs.length/50)}var _9g=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",50],["pixy",$1.pixy],["height",$1.pixy/72],["width",50/72],["opt",$1.options]]);$k[$j++]=_9g;if(!$1.dontdraw){bwipp_renmatrix()}}}function bwipp_databarstacked(){var $1=Object.create(bwipp_databarstacked.$ctx||(bwipp_databarstacked.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($G($1.barcode,0,4),"(01)")){$k[$j++]="bwipp.databarstackedBadAI#8320";$k[$j++]="GS1 DataBar Stacked must begin with (01) application identifier";bwipp_raiseerror()}if($1.barcode.length!=17&&$1.barcode.length!=18){$k[$j++]="bwipp.databarstackedBadLength#8323";$k[$j++]="GS1 DataBar Stacked must be 13 or 14 digits";bwipp_raiseerror()}var _8=$G($1.barcode,4,$1.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databarstackedBadCharacter#8327";$k[$j++]="GS1 DataBar Stacked must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _C=0;_C<=12;_C+=1){$1.i=_C;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$1[$k[--$j]]=$f(_K+_J)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==18){if($g($1.barcode,17)!=$1.checksum+48){$k[$j++]="bwipp.databarstackedBadCheckDigit#8340";$k[$j++]="Incorrect GS1 DataBar Stacked check digit provided";bwipp_raiseerror()}}var _R=$s(18);$P(_R,0,$1.barcode);$p(_R,17,$1.checksum+48);$1.barcode=_R;$p($1.options,"dontdraw",true);$p($1.options,"format","stacked");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_databaromni();var _Y=$k[--$j];$1[$k[--$j]]=_Y;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_databarstackedomni(){var $1=Object.create(bwipp_databarstackedomni.$ctx||(bwipp_databarstackedomni.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($G($1.barcode,0,4),"(01)")){$k[$j++]="bwipp.databarstackedomniBadAI#8398";$k[$j++]="GS1 DataBar Stacked Omnidirectional must begin with (01) application identifier";bwipp_raiseerror()}if($1.barcode.length!=17&&$1.barcode.length!=18){$k[$j++]="bwipp.databarstackedomniBadLength#8401";$k[$j++]="GS1 DataBar Stacked Omnidirectional must be 13 or 14 digits";bwipp_raiseerror()}var _8=$G($1.barcode,4,$1.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databarstackedomniBadCharacter#8405";$k[$j++]="GS1 DataBar Stacked Omnidirectional must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _C=0;_C<=12;_C+=1){$1.i=_C;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$1[$k[--$j]]=$f(_K+_J)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==18){if($g($1.barcode,17)!=$1.checksum+48){$k[$j++]="bwipp.databarstackedomniBadCheckDigit#8418";$k[$j++]="Incorrect GS1 DataBar Stacked Omnidirectional check digit provided";bwipp_raiseerror()}}var _R=$s(18);$P(_R,0,$1.barcode);$p(_R,17,$1.checksum+48);$1.barcode=_R;$p($1.options,"dontdraw",true);$p($1.options,"format","stackedomni");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_databaromni();var _Y=$k[--$j];$1[$k[--$j]]=_Y;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_databartruncated(){var $1=Object.create(bwipp_databartruncated.$ctx||(bwipp_databartruncated.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($G($1.barcode,0,4),"(01)")){$k[$j++]="bwipp.databartruncatedBadAI#8476";$k[$j++]="GS1 DataBar Truncated must begin with (01) application identifier";bwipp_raiseerror()}if($1.barcode.length!=17&&$1.barcode.length!=18){$k[$j++]="bwipp.databartruncatedBadLength#8479";$k[$j++]="GS1 DataBar Truncated must be 13 or 14 digits";bwipp_raiseerror()}var _8=$G($1.barcode,4,$1.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databartruncatedBadCharacter#8483";$k[$j++]="GS1 DataBar Truncated must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _C=0;_C<=12;_C+=1){$1.i=_C;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$1[$k[--$j]]=$f(_K+_J)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==18){if($g($1.barcode,17)!=$1.checksum+48){$k[$j++]="bwipp.databartruncatedBadCheckDigit#8496";$k[$j++]="Incorrect GS1 DataBar Truncated check digit provided";bwipp_raiseerror()}}var _R=$s(18);$P(_R,0,$1.barcode);$p(_R,17,$1.checksum+48);$1.barcode=_R;$p($1.options,"dontdraw",true);$p($1.options,"format","truncated");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_databaromni();var _Y=$k[--$j];$1[$k[--$j]]=_Y;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_databarlimited(){var $1=Object.create(bwipp_databarlimited.$ctx||(bwipp_databarlimited.$ctx={}));$1.dontdraw=false;$1.height=10/72;$1.linkage=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($G($1.barcode,0,4),"(01)")){$k[$j++]="bwipp.databarlimitedBadAI#8559";$k[$j++]="GS1 DataBar Limited must begin with (01) application identifier";bwipp_raiseerror()}if($1.barcode.length!=17&&$1.barcode.length!=18){$k[$j++]="bwipp.databarlimitedBadLength#8562";$k[$j++]="GS1 DataBar Limited must be 13 or 14 digits";bwipp_raiseerror()}var _7=$g($1.barcode,4);if(_7<48||_7>49){$k[$j++]="bwipp.databarlimitedBadStartDigit#8565";$k[$j++]="GS1 DataBar Limited must begin with 0 or 1";bwipp_raiseerror()}var _A=$G($1.barcode,5,$1.barcode.length-5);for(var _B=0,_C=_A.length;_B<_C;_B++){var _D=$g(_A,_B);if(_D<48||_D>57){$k[$j++]="bwipp.databarlimitedBadCharacter#8569";$k[$j++]="GS1 DataBar Limited must contain only digits";bwipp_raiseerror()}}$1.checksum=0;for(var _E=0;_E<=12;_E+=1){$1.i=_E;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i+4)-48);if($1.i%2==0){var _K=$k[--$j];$k[$j++]=_K*3}var _L=$k[--$j];var _M=$k[--$j];$1[$k[--$j]]=$f(_M+_L)}$1.checksum=(10-$1.checksum%10)%10;if($1.barcode.length==18){if($g($1.barcode,17)!=$1.checksum+48){$k[$j++]="bwipp.databarlimitedBadCheckDigit#8582";$k[$j++]="Incorrect GS1 DataBar Limited check digit provided";bwipp_raiseerror()}}var _T=$s(18);$P(_T,0,$1.barcode);$p(_T,17,$1.checksum+48);$1.barcode=_T;if(!bwipp_databarlimited.__8593__){(function(){var $ctx=Object.create($1);$ctx.linkval=$a([2,0,1,5,1,3,3,5,3,1,0,9,6]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarlimited.$ctx[id]=$ctx[id]);bwipp_databarlimited.__8593__=1})()}$k[$j++]=Infinity;var _Z=$G($1.barcode,4,13);for(var _a=0,_b=_Z.length;_a<_b;_a++){$k[$j++]=$f($g(_Z,_a)-48)}$1.binval=$a();if($1.linkage){for(var _h=0,_g=$1.binval.length-1;_h<=_g;_h+=1){$1.i=_h;$p($1.binval,$1.i,$f($g($1.binval,$1.i)+$g($1.linkval,$1.i)))}}$1.txt=$a($1.barcode.length);for(var _u=0,_t=$1.barcode.length-1;_u<=_t;_u+=1){$1.i=_u;$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),0,0,"",0]))}$1.ncr=function(){var _11=$k[--$j];var _12=$k[--$j];var _13=$f(_12-_11);if(_11<$f(_12-_11)){var _=_13;_13=_11;_11=_}$k[$j++]=_13;$k[$j++]=1;$k[$j++]=1;for(var _15=_12,_14=$f(_11+1);_15>=_14;_15-=1){var _16=$k[--$j];var _17=$k[--$j];var _18=$k[--$j];$k[$j++]=_18;$k[$j++]=_17;$k[$j++]=_16*_15;if($le(_17,_18)){var _19=$k[--$j];var _1A=$k[--$j];$k[$j++]=$f(_1A+1);$k[$j++]=~~(_19/_1A)}}for(;;){var _1B=$k[--$j];var _1C=$k[--$j];var _1D=$k[--$j];$k[$j++]=_1D;$k[$j++]=_1C;$k[$j++]=_1B;if($gt(_1C,_1D)){break}var _1E=$k[--$j];var _1F=$k[--$j];$k[$j++]=$f(_1F+1);$k[$j++]=~~(_1E/_1F)}var _1G=$k[--$j];var _1H=$k[--$j];$k[$j++]=_1G;$k[$j++]=_1H;$j--;var _1I=$k[--$j];var _1J=$k[--$j];$k[$j++]=_1I;$k[$j++]=_1J;$j--};$1.getRSSwidths=function(){$1.oe=$k[--$j];$1.el=$k[--$j];$1.mw=$k[--$j];$1.nm=$k[--$j];$1.val=$k[--$j];$1.out=$a($1.el);$1.mask=0;for(var _1T=0,_1S=$f($1.el-2);_1T<=_1S;_1T+=1){$1.bar=_1T;$1.ew=1;var _1V=$1.bar;$1.mask=$1.mask|(_1V<0?1>>>-_1V:1<<_1V);for(;;){$k[$j++]="sval";$k[$j++]=$f($f($1.nm-$1.ew)-1);$k[$j++]=$f($f($1.el-$1.bar)-2);$1.ncr();var _1a=$k[--$j];$1[$k[--$j]]=_1a;if($1.oe&&$1.mask==0&&$f($f($f($1.nm-$1.ew)-$1.el*2)+$1.bar*2)>=-2){$k[$j++]="sval";$k[$j++]=$1.sval;$k[$j++]=$f($f($f($1.nm-$1.ew)-$1.el)+$1.bar);$k[$j++]=$f($f($1.el-$1.bar)-2);$1.ncr();var _1p=$k[--$j];var _1q=$k[--$j];$1[$k[--$j]]=$f(_1q-_1p)}if($f($1.el-$1.bar)>2){$1.lval=0;for(var _20=$f($f($f($f($1.nm-$1.ew)-$1.el)+$1.bar)+2),_1z=$f($1.mw+1);_20>=_1z;_20-=1){$k[$j++]=$f($f($f($1.nm-_20)-$1.ew)-1);$k[$j++]=$f($f($1.el-$1.bar)-3);$1.ncr();$1.lval=$f($k[--$j]+$1.lval)}$1.sval=$f($1.sval-$1.lval*$f($f($1.el-$1.bar)-1))}else{if($f($1.nm-$1.ew)>$1.mw){$1.sval=$f($1.sval-1)}}$1.val=$f($1.val-$1.sval);if($1.val<0){break}$1.ew=$1.ew+1;var _2K=$1.bar;$1.mask=$1.mask&~(_2K<0?1>>>-_2K:1<<_2K)}$1.val=$f($1.val+$1.sval);$1.nm=$f($1.nm-$1.ew);$p($1.out,$1.bar,$1.ew)}$p($1.out,$f($1.el-1),$1.nm);$k[$j++]=$1.out};for(var _2W=0;_2W<=11;_2W+=1){$1.i=_2W;var _2X=$1.binval;var _2Y=$1.i;$p(_2X,_2Y+1,$f($g(_2X,_2Y+1)+$g($1.binval,$1.i)%2013571*10));$p($1.binval,$1.i,~~($g($1.binval,$1.i)/2013571))}$1.d2=$g($1.binval,12)%2013571;var _2k=$1.binval;$p(_2k,12,~~($g(_2k,12)/2013571));$1.d1=0;$1.i=true;for(var _2m=0;_2m<=12;_2m+=1){$1.j=_2m;var _2p=$g($1.binval,$1.j);$k[$j++]=_2p;if(_2p==0&&$1.i){$j--}else{$1.i=false;$1.d1=$f($1.d1+$k[--$j]*~~Math.pow(10,12-$1.j))}}if(!bwipp_databarlimited.__8697__){(function(){var $ctx=Object.create($1);$ctx.tab267=$a([183063,0,17,9,6,3,6538,28,820063,183064,13,13,5,4,875,728,1000775,820064,9,17,3,6,28,6454,1491020,1000776,15,11,5,4,2415,203,1979844,1491021,11,15,4,5,203,2408,1996938,1979845,19,7,8,1,17094,1,2013570,1996939,7,19,1,8,1,16632]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarlimited.$ctx[id]=$ctx[id]);bwipp_databarlimited.__8697__=1})()}$1.i=0;for(;;){if($1.d1<=$g($1.tab267,$1.i)){var _32=$G($1.tab267,$1.i+1,7);for(var _33=0,_34=_32.length;_33<_34;_33++){$k[$j++]=$g(_32,_33)}$1.d1te=$k[--$j];$1.d1to=$k[--$j];$1.d1mwe=$k[--$j];$1.d1mwo=$k[--$j];$1.d1ele=$k[--$j];$1.d1elo=$k[--$j];$1.d1gs=$k[--$j];break}$1.i=$1.i+8}$1.i=0;for(;;){if($1.d2<=$g($1.tab267,$1.i)){var _3K=$G($1.tab267,$1.i+1,7);for(var _3L=0,_3M=_3K.length;_3L<_3M;_3L++){$k[$j++]=$g(_3K,_3L)}$1.d2te=$k[--$j];$1.d2to=$k[--$j];$1.d2mwe=$k[--$j];$1.d2mwo=$k[--$j];$1.d2ele=$k[--$j];$1.d2elo=$k[--$j];$1.d2gs=$k[--$j];break}$1.i=$1.i+8}$k[$j++]="d1wo";$k[$j++]=~~($f($1.d1-$1.d1gs)/$1.d1te);$k[$j++]=$1.d1elo;$k[$j++]=$1.d1mwo;$k[$j++]=7;$k[$j++]=false;$1.getRSSwidths();var _3b=$k[--$j];$1[$k[--$j]]=_3b;$k[$j++]="d1we";$k[$j++]=$f($1.d1-$1.d1gs)%$1.d1te;$k[$j++]=$1.d1ele;$k[$j++]=$1.d1mwe;$k[$j++]=7;$k[$j++]=true;$1.getRSSwidths();var _3i=$k[--$j];$1[$k[--$j]]=_3i;$k[$j++]="d2wo";$k[$j++]=~~($f($1.d2-$1.d2gs)/$1.d2te);$k[$j++]=$1.d2elo;$k[$j++]=$1.d2mwo;$k[$j++]=7;$k[$j++]=false;$1.getRSSwidths();var _3p=$k[--$j];$1[$k[--$j]]=_3p;$k[$j++]="d2we";$k[$j++]=$f($1.d2-$1.d2gs)%$1.d2te;$k[$j++]=$1.d2ele;$k[$j++]=$1.d2mwe;$k[$j++]=7;$k[$j++]=true;$1.getRSSwidths();var _3w=$k[--$j];$1[$k[--$j]]=_3w;$1.d1w=$a(14);for(var _3z=0;_3z<=6;_3z+=1){$1.i=_3z;$p($1.d1w,$1.i*2,$g($1.d1wo,$1.i));$p($1.d1w,$1.i*2+1,$g($1.d1we,$1.i))}$1.d2w=$a(14);for(var _4B=0;_4B<=6;_4B+=1){$1.i=_4B;$p($1.d2w,$1.i*2,$g($1.d2wo,$1.i));$p($1.d2w,$1.i*2+1,$g($1.d2we,$1.i))}$k[$j++]=Infinity;var _4M=$1.d1w;for(var _4N=0,_4O=_4M.length;_4N<_4O;_4N++){$k[$j++]=$g(_4M,_4N)}var _4Q=$1.d2w;for(var _4R=0,_4S=_4Q.length;_4R<_4S;_4R++){$k[$j++]=$g(_4Q,_4R)}$1.widths=$a();if(!bwipp_databarlimited.__8768__){(function(){var $ctx=Object.create($1);$ctx.checkweights=$a([1,3,9,27,81,65,17,51,64,14,42,37,22,66,20,60,2,6,18,54,73,41,34,13,39,28,84,74]);$k[$j++]=Infinity;for(var _4W=0;_4W<=43;_4W+=1){$k[$j++]=_4W}$k[$j++]=45;$k[$j++]=52;$k[$j++]=57;for(var _4X=63;_4X<=66;_4X+=1){$k[$j++]=_4X}for(var _4Y=73;_4Y<=79;_4Y+=1){$k[$j++]=_4Y}$k[$j++]=82;for(var _4Z=126;_4Z<=130;_4Z+=1){$k[$j++]=_4Z}$k[$j++]=132;for(var _4a=141;_4a<=146;_4a+=1){$k[$j++]=_4a}for(var _4b=210;_4b<=217;_4b+=1){$k[$j++]=_4b}$k[$j++]=220;for(var _4c=316;_4c<=320;_4c+=1){$k[$j++]=_4c}$k[$j++]=322;$k[$j++]=323;$k[$j++]=326;$k[$j++]=337;$ctx.checkseq=$a();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarlimited.$ctx[id]=$ctx[id]);bwipp_databarlimited.__8768__=1})()}$1.checksum=0;for(var _4f=0;_4f<=27;_4f+=1){$1.i=_4f;$1.checksum=$f($1.checksum+$g($1.widths,$1.i)*$g($1.checkweights,$1.i))}$1.checksum=$1.checksum%89;$1.seq=$g($1.checkseq,$1.checksum);$k[$j++]="swidths";$k[$j++]=~~($1.seq/21);$k[$j++]=8;$k[$j++]=3;$k[$j++]=6;$k[$j++]=false;$1.getRSSwidths();var _4s=$k[--$j];$1[$k[--$j]]=_4s;$k[$j++]="bwidths";$k[$j++]=$1.seq%21;$k[$j++]=8;$k[$j++]=3;$k[$j++]=6;$k[$j++]=false;$1.getRSSwidths();var _4v=$k[--$j];$1[$k[--$j]]=_4v;$1.checkwidths=$a([0,0,0,0,0,0,0,0,0,0,0,0,1,1]);for(var _4y=0;_4y<=5;_4y+=1){$1.i=_4y;$p($1.checkwidths,$1.i*2,$g($1.swidths,$1.i));$p($1.checkwidths,$1.i*2+1,$g($1.bwidths,$1.i))}$k[$j++]=Infinity;var _59=$1.d1w;$k[$j++]=1;for(var _5A=0,_5B=_59.length;_5A<_5B;_5A++){$k[$j++]=$g(_59,_5A)}var _5D=$1.checkwidths;for(var _5E=0,_5F=_5D.length;_5E<_5F;_5E++){$k[$j++]=$g(_5D,_5E)}var _5H=$1.d2w;for(var _5I=0,_5J=_5H.length;_5I<_5J;_5I++){$k[$j++]=$g(_5H,_5I)}$k[$j++]=1;$k[$j++]=1;$k[$j++]=5;$1.sbs=$a();$k[$j++]=Infinity;var _5M=$1.sbs;$k[$j++]=Infinity;for(var _5O=0,_5P=~~(($1.sbs.length+1)/2);_5O<_5P;_5O++){$k[$j++]=$1.height}var _5R=$a();$k[$j++]=Infinity;for(var _5T=0,_5U=~~(($1.sbs.length+1)/2);_5T<_5U;_5T++){$k[$j++]=0}var _5V=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_5M;$k[$j++]="bhs";$k[$j++]=_5R;$k[$j++]="bbs";$k[$j++]=_5V;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$1.options;var _5Y=$d();$k[$j++]=_5Y;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_databarexpanded(){var $1=Object.create(bwipp_databarexpanded.$ctx||(bwipp_databarexpanded.$ctx={}));$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$1.dontdraw=false;$1.height=34/72;$1.format="expanded";$1.segments=-1;$1.linkage=false;$1.barxmult=34;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.barxmult<34){$k[$j++]="bwipp.databarStackedOmniBarXmult#8857";$k[$j++]="GS1 DataBar Expanded Stacked must have a barxmult of at least 34";bwipp_raiseerror()}if($ne($1.format,"expanded")&&$ne($1.format,"expandedstacked")){$k[$j++]="bwipp.databarexpandedBadFormat#8861";$k[$j++]="Valid formats are expanded and expandedstacked";bwipp_raiseerror()}if($1.segments==-1){var _7=$eq($1.format,"expandedstacked")?4:22;$1.segments=_7}else{if($1.segments<2||$1.segments>22||$1.segments%2!=0){$k[$j++]="bwipp.gs1databarexpandedBadSegments#8868";$k[$j++]="The number of segments must be even from 2 to 22";bwipp_raiseerror()}}$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];for(;;){if($1.ais.length==2){if($eq($g($1.ais,0),"01")&&$eq($g($1.ais,1),"3103")){if($eq($G($g($1.vals,0),0,1),"9")&&$i($g($1.vals,1))<=32767){$k[$j++]="0100";$k[$j++]=false;break}}}if($1.ais.length==2){if($eq($g($1.ais,0),"01")&&$eq($g($1.ais,1),"3202")){if($eq($G($g($1.vals,0),0,1),"9")&&$i($g($1.vals,1))<=9999){$k[$j++]="0101";$k[$j++]=false;break}}}if($1.ais.length==2){if($eq($g($1.ais,0),"01")&&$eq($g($1.ais,1),"3203")){if($eq($G($g($1.vals,0),0,1),"9")&&$i($g($1.vals,1))<=22767){$k[$j++]="0101";$k[$j++]=false;break}}}var _k=$1.ais.length;if(_k==2||_k==3){$k[$j++]="ai310x";$k[$j++]=false;for(var _l=3100;_l<=3109;_l+=1){var _q=$k[--$j];$k[$j++]=_q||$eq($R($s(4),_l,10),$g($1.ais,1))}var _r=$k[--$j];$1[$k[--$j]]=_r;$k[$j++]="ai320x";$k[$j++]=false;for(var _t=3200;_t<=3209;_t+=1){var _y=$k[--$j];$k[$j++]=_y||$eq($R($s(4),_t,10),$g($1.ais,1))}var _z=$k[--$j];$1[$k[--$j]]=_z;if($1.ais.length==3){var _12=$a(["11","13","15","17"]);$k[$j++]="aibad";$k[$j++]=true;for(var _13=0,_14=_12.length;_13<_14;_13++){var _18=$k[--$j];$k[$j++]=_18&&$ne($g(_12,_13),$g($1.ais,2))}var _19=$k[--$j];$1[$k[--$j]]=_19}else{$1.aibad=false}if($eq($g($1.ais,0),"01")&&($1.ai310x||$1.ai320x)&&!$1.aibad){if($1.ais.length==3){var _1P=$i($G($g($1.vals,2),2,2));var _1T=$i($G($g($1.vals,2),4,2));if($eq($G($g($1.vals,0),0,1),"9")&&$i($g($1.vals,1))<=99999&&(_1P>=1&&_1P<=12)&&(_1T>=0&&_1T<=31)){if($1.ai310x&&$eq($g($1.ais,2),"11")){$k[$j++]="0111000";$k[$j++]=false;break}if($1.ai320x&&$eq($g($1.ais,2),"11")){$k[$j++]="0111001";$k[$j++]=false;break}if($1.ai310x&&$eq($g($1.ais,2),"13")){$k[$j++]="0111010";$k[$j++]=false;break}if($1.ai320x&&$eq($g($1.ais,2),"13")){$k[$j++]="0111011";$k[$j++]=false;break}if($1.ai310x&&$eq($g($1.ais,2),"15")){$k[$j++]="0111100";$k[$j++]=false;break}if($1.ai320x&&$eq($g($1.ais,2),"15")){$k[$j++]="0111101";$k[$j++]=false;break}if($1.ai310x&&$eq($g($1.ais,2),"17")){$k[$j++]="0111110";$k[$j++]=false;break}if($1.ai320x&&$eq($g($1.ais,2),"17")){$k[$j++]="0111111";$k[$j++]=false;break}}}else{if($eq($G($g($1.vals,0),0,1),"9")&&$i($g($1.vals,1))<=99999){if($1.ai310x){$k[$j++]="0111000";$k[$j++]=false;break}if($1.ai320x){$k[$j++]="0111001";$k[$j++]=false;break}}}}}if($1.ais.length>=2){$k[$j++]="ai392x";$k[$j++]=false;for(var _20=3920;_20<=3923;_20+=1){var _25=$k[--$j];$k[$j++]=_25||$eq($R($s(4),_20,10),$g($1.ais,1))}var _26=$k[--$j];$1[$k[--$j]]=_26;if($eq($g($1.ais,0),"01")&&$1.ai392x){if($eq($G($g($1.vals,0),0,1),"9")){$k[$j++]="01100";$k[$j++]=true;break}}}if($1.ais.length>=2){$k[$j++]="ai393x";$k[$j++]=false;for(var _2F=3930;_2F<=3933;_2F+=1){var _2K=$k[--$j];$k[$j++]=_2K||$eq($R($s(4),_2F,10),$g($1.ais,1))}var _2L=$k[--$j];$1[$k[--$j]]=_2L;if($eq($g($1.ais,0),"01")&&$1.ai393x){if($eq($G($g($1.vals,0),0,1),"9")){$k[$j++]="01101";$k[$j++]=true;break}}}if($eq($g($1.ais,0),"01")){$k[$j++]="1";$k[$j++]=true;break}$k[$j++]="00";$k[$j++]=true;break}$1.gpfallow=$k[--$j];$1.method=$k[--$j];$1.conv12to40=function(){var _2Y=$Z($s(40),"0000000000000000000000000000000000000000");var _2Z=$k[--$j];var _2d=$R($s(10),$i($G(_2Z,0,3)),2);$P($G(_2Y,0,10),10-_2d.length,_2d);var _2h=$R($s(10),$i($G(_2Z,3,3)),2);$P($G(_2Y,10,10),10-_2h.length,_2h);var _2l=$R($s(10),$i($G(_2Z,6,3)),2);$P($G(_2Y,20,10),10-_2l.length,_2l);var _2p=$R($s(10),$i($G(_2Z,9,3)),2);$P($G(_2Y,30,10),10-_2p.length,_2p);$k[$j++]=_2Y;$k[$j++]=_2Z;$j--};$1.conv13to44=function(){var _2r=$Z($s(44),"00000000000000000000000000000000000000000000");var _2s=$k[--$j];var _2w=$R($s(4),$i($G(_2s,0,1)),2);$P($G(_2r,0,4),4-_2w.length,_2w);$k[$j++]=_2r;$k[$j++]=_2r;$k[$j++]=$G(_2s,1,12);$1.conv12to40();var _2y=$k[--$j];$P($k[--$j],4,_2y)};$1.tobin=function(){var _31=$s($k[--$j]);$k[$j++]=_31;for(var _33=0,_32=_31.length-1;_33<=_32;_33+=1){var _34=$k[--$j];$p(_34,_33,48);$k[$j++]=_34}var _35=$k[--$j];var _38=$R($s(_35.length),$k[--$j],2);$P(_35,_35.length-_38.length,_38);$k[$j++]=_35};$1.fnc1=-1;$1.lnumeric=-2;$1.lalphanumeric=-3;$1.liso646=-4;if($eq($1.method,"00")){$1.cdf=$a([]);$1.gpf=$a([])}if($eq($1.method,"1")){$k[$j++]="cdf";$k[$j++]=$G($g($1.vals,0),0,13);$1.conv13to44();var _3G=$k[--$j];$1[$k[--$j]]=_3G;$k[$j++]=Infinity;var _3I=$1.cdf;for(var _3J=0,_3K=_3I.length;_3J<_3K;_3J++){$k[$j++]=$f($g(_3I,_3J)-48)}$1.cdf=$a();$1.gpf=$a([]);$1.ais=$G($1.ais,1,$1.ais.length-1);$1.vals=$G($1.vals,1,$1.vals.length-1);$1.fncs=$G($1.fncs,1,$1.fncs.length-1)}if($eq($1.method,"0100")){$1.cdf=$s(55);$k[$j++]=$1.cdf;$k[$j++]=0;$k[$j++]=$G($g($1.vals,0),1,12);$1.conv12to40();var _3d=$k[--$j];var _3e=$k[--$j];$P($k[--$j],_3e,_3d);$k[$j++]=$1.cdf;$k[$j++]=40;$k[$j++]=$i($g($1.vals,1));$k[$j++]=15;$1.tobin();var _3j=$k[--$j];var _3k=$k[--$j];$P($k[--$j],_3k,_3j);$k[$j++]=Infinity;var _3m=$1.cdf;for(var _3n=0,_3o=_3m.length;_3n<_3o;_3n++){$k[$j++]=$g(_3m,_3n)-48}$1.cdf=$a();$1.gpf=$a([]);$1.ais=$a([]);$1.vals=$a([]);$1.fncs=$a([])}if($eq($1.method,"0101")){$1.cdf=$s(55);$k[$j++]=$1.cdf;$k[$j++]=0;$k[$j++]=$G($g($1.vals,0),1,12);$1.conv12to40();var _41=$k[--$j];var _42=$k[--$j];$P($k[--$j],_42,_41);if($eq($g($1.ais,1),"3202")){$k[$j++]=$i($g($1.vals,1));$k[$j++]=15;$1.tobin()}else{$k[$j++]=$i($g($1.vals,1))+1e4;$k[$j++]=15;$1.tobin()}$P($1.cdf,40,$k[--$j]);$k[$j++]=Infinity;var _4C=$1.cdf;for(var _4D=0,_4E=_4C.length;_4D<_4E;_4D++){$k[$j++]=$g(_4C,_4D)-48}$1.cdf=$a();$1.gpf=$a([]);$1.ais=$a([]);$1.vals=$a([]);$1.fncs=$a([])}if($1.method.length==7){$1.cdf=$s(76);$k[$j++]=$1.cdf;$k[$j++]=0;$k[$j++]=$G($g($1.vals,0),1,12);$1.conv12to40();var _4R=$k[--$j];var _4S=$k[--$j];$P($k[--$j],_4S,_4R);var _4U=$s(6);$P(_4U,0,$G($g($1.ais,1),3,1));$P(_4U,1,$G($g($1.vals,1),1,5));$k[$j++]=$i(_4U);$k[$j++]=20;$1.tobin();$P($1.cdf,40,$k[--$j]);if($1.ais.length==3){var _4f=$g($1.vals,2);$k[$j++]=$i($G(_4f,0,2))*384+(($i($G(_4f,2,2))-1)*32+$i($G(_4f,4,2)))}else{$k[$j++]=38400}$k[$j++]=16;$1.tobin();$P($1.cdf,60,$k[--$j]);$k[$j++]=Infinity;var _4l=$1.cdf;for(var _4m=0,_4n=_4l.length;_4m<_4n;_4m++){$k[$j++]=$g(_4l,_4m)-48}$1.cdf=$a();$1.gpf=$a([]);$1.ais=$a([]);$1.vals=$a([]);$1.fncs=$a([])}if($eq($1.method,"01100")){$1.cdf=$s(42);$k[$j++]=$1.cdf;$k[$j++]=0;$k[$j++]=$G($g($1.vals,0),1,12);$1.conv12to40();var _50=$k[--$j];var _51=$k[--$j];$P($k[--$j],_51,_50);$k[$j++]=$1.cdf;$k[$j++]=40;$k[$j++]=$i($G($g($1.ais,1),3,1));$k[$j++]=2;$1.tobin();var _57=$k[--$j];var _58=$k[--$j];$P($k[--$j],_58,_57);$k[$j++]=Infinity;var _5A=$1.cdf;for(var _5B=0,_5C=_5A.length;_5B<_5C;_5B++){$k[$j++]=$g(_5A,_5B)-48}$1.cdf=$a();$k[$j++]=Infinity;$F($g($1.vals,1));if($1.ais.length>2){$k[$j++]=$1.fnc1}$1.gpf=$a();$1.ais=$G($1.ais,2,$1.ais.length-2);$1.vals=$G($1.vals,2,$1.vals.length-2);$1.fncs=$G($1.fncs,2,$1.fncs.length-2)}if($eq($1.method,"01101")){$1.cdf=$s(52);$k[$j++]=$1.cdf;$k[$j++]=0;$k[$j++]=$G($g($1.vals,0),1,12);$1.conv12to40();var _5Z=$k[--$j];var _5a=$k[--$j];$P($k[--$j],_5a,_5Z);$k[$j++]=$1.cdf;$k[$j++]=40;$k[$j++]=$i($G($g($1.ais,1),3,1));$k[$j++]=2;$1.tobin();var _5g=$k[--$j];var _5h=$k[--$j];$P($k[--$j],_5h,_5g);$k[$j++]=$1.cdf;$k[$j++]=42;$k[$j++]=$i($G($g($1.vals,1),0,3));$k[$j++]=10;$1.tobin();var _5n=$k[--$j];var _5o=$k[--$j];$P($k[--$j],_5o,_5n);$k[$j++]=Infinity;var _5q=$1.cdf;for(var _5r=0,_5s=_5q.length;_5r<_5s;_5r++){$k[$j++]=$g(_5q,_5r)-48}$1.cdf=$a();$k[$j++]=Infinity;var _5w=$g($1.vals,1);var _5x=$G(_5w,3,_5w.length-3);for(var _5y=0,_5z=_5x.length;_5y<_5z;_5y++){$k[$j++]=$g(_5x,_5y)}if($1.ais.length>2){$k[$j++]=$1.fnc1}$1.gpf=$a();$1.ais=$G($1.ais,2,$1.ais.length-2);$1.vals=$G($1.vals,2,$1.vals.length-2);$1.fncs=$G($1.fncs,2,$1.fncs.length-2)}if($1.gpfallow){$1.vlf=$a(2)}else{$1.vlf=$a([])}if(!bwipp_databarexpanded.__9120__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;for(var _6G=0;_6G<=119;_6G+=1){var _6I=$Z($s(2),"00");var _6K=$R($s(2),_6G,11);$P(_6I,2-_6K.length,_6K);$k[$j++]=_6G;$k[$j++]=_6I;if($g(_6I,0)==65){var _6M=$k[--$j];$p(_6M,0,94);$k[$j++]=_6M}var _6N=$k[--$j];$k[$j++]=_6N;if($g(_6N,1)==65){var _6P=$k[--$j];$p(_6P,1,94);$k[$j++]=_6P}var _6Q=$k[--$j];var _6T=$Z($s(7),"0000000");var _6V=$R($s(7),$f($k[--$j]+8),2);$P(_6T,7-_6V.length,_6V);$k[$j++]=_6Q;$k[$j++]=_6T}$k[$j++]=$ctx.lalphanumeric;$k[$j++]="0000";$ctx.numeric=$d();$k[$j++]=Infinity;for(var _6Y=48;_6Y<=57;_6Y+=1){$k[$j++]=_6Y;$k[$j++]=_6Y-43;$k[$j++]=5;$ctx.tobin()}$k[$j++]=$ctx.fnc1;$k[$j++]="01111";for(var _6a=65;_6a<=90;_6a+=1){$k[$j++]=_6a;$k[$j++]=_6a-33;$k[$j++]=6;$ctx.tobin()}$k[$j++]=42;$k[$j++]="111010";for(var _6b=44;_6b<=47;_6b+=1){$k[$j++]=_6b;$k[$j++]=_6b+15;$k[$j++]=6;$ctx.tobin()}$k[$j++]=$ctx.lnumeric;$k[$j++]="000";$k[$j++]=$ctx.liso646;$k[$j++]="00100";$ctx.alphanumeric=$d();$k[$j++]=Infinity;for(var _6f=48;_6f<=57;_6f+=1){$k[$j++]=_6f;$k[$j++]=_6f-43;$k[$j++]=5;$ctx.tobin()}$k[$j++]=$ctx.fnc1;$k[$j++]="01111";for(var _6h=65;_6h<=90;_6h+=1){$k[$j++]=_6h;$k[$j++]=_6h-1;$k[$j++]=7;$ctx.tobin()}for(var _6i=97;_6i<=122;_6i+=1){$k[$j++]=_6i;$k[$j++]=_6i-7;$k[$j++]=7;$ctx.tobin()}$k[$j++]=33;$k[$j++]="11101000";$k[$j++]=34;$k[$j++]="11101001";for(var _6j=37;_6j<=47;_6j+=1){$k[$j++]=_6j;$k[$j++]=_6j+197;$k[$j++]=8;$ctx.tobin()}for(var _6k=58;_6k<=63;_6k+=1){$k[$j++]=_6k;$k[$j++]=_6k+187;$k[$j++]=8;$ctx.tobin()}$k[$j++]=95;$k[$j++]="11111011";$k[$j++]=32;$k[$j++]="11111100";$k[$j++]=$ctx.lnumeric;$k[$j++]="000";$k[$j++]=$ctx.lalphanumeric;$k[$j++]="00100";$ctx.iso646=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarexpanded.$ctx[id]=$ctx[id]);bwipp_databarexpanded.__9120__=1})()}for(var _6r=0,_6q=$1.ais.length-1;_6r<=_6q;_6r+=1){$1.i=_6r;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _71=$a($1.gpf.length+$1.ai.length+$1.val.length);$P(_71,0,$1.gpf);$k[$j++]=_71;$k[$j++]=_71;$k[$j++]=$1.gpf.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _75=$k[--$j];var _76=$k[--$j];$k[$j++]=_75;$F(_76);var _77=$a();var _78=$k[--$j];$P($k[--$j],_78,_77);var _7A=$k[--$j];$k[$j++]=_7A;$k[$j++]=_7A;$k[$j++]=$1.gpf.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _7E=$k[--$j];var _7F=$k[--$j];$k[$j++]=_7E;$F(_7F);var _7G=$a();var _7H=$k[--$j];$P($k[--$j],_7H,_7G);$1.gpf=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _7Q=$a($1.gpf.length+1);$P(_7Q,0,$1.gpf);$p(_7Q,$1.gpf.length,$1.fnc1);$1.gpf=_7Q}}$1.rembits=function(){var _7U=$k[--$j];var _7V=48;var _7W=~~Math.ceil(_7U/12)*12;if(~~Math.ceil(_7U/12)*12<48){var _=_7V;_7V=_7W;_7W=_}var _7X=~~(_7W/12);$k[$j++]=_7U;$k[$j++]=_7W;$k[$j++]=_7X;if(_7X%$1.segments==1){var _7Z=$k[--$j];var _7a=$k[--$j];$k[$j++]=$f(_7Z+1)*12;$k[$j++]=_7a;$j--}else{$j--}var _7b=$k[--$j];var _7c=$k[--$j];$k[$j++]=$f(_7b-_7c)};$1.encode=function(){var _7d=$k[--$j];$k[$j++]=_7d;if($ne(_7d,"raw")){var _7e=$k[--$j];var _7g=$g(_7e,$k[--$j]);$k[$j++]=_7g}else{$j--}$k[$j++]=Infinity;var _7h=$k[--$j];var _7i=$k[--$j];$k[$j++]=_7h;$F(_7i,function(){var _7j=$k[--$j];$k[$j++]=$f(_7j-48)});var _7k=$a();$P($1.gpfenc,$1.j,_7k);$1.j=_7k.length+$1.j};$k[$j++]=Infinity;for(var _7p=0,_7q=$1.gpf.length;_7p<_7q;_7p++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=-1;$1.numericruns=$a();$k[$j++]=Infinity;for(var _7t=0,_7u=$1.gpf.length;_7t<_7u;_7t++){$k[$j++]=0}$k[$j++]=0;$1.alphanumericruns=$a();$k[$j++]=Infinity;for(var _7x=0,_7y=$1.gpf.length;_7x<_7y;_7x++){$k[$j++]=0}$k[$j++]=9999;$1.nextiso646only=$a();for(var _81=$1.gpf.length-1;_81>=0;_81-=1){$1.i=_81;var _86=$Z($s(2),"00");var _89=$g($1.gpf,$1.i);$k[$j++]=$g($1.gpf,$1.i);$k[$j++]=_86;$k[$j++]=_86;$k[$j++]=0;$k[$j++]=_89;if(_89==$1.fnc1){$j--;$k[$j++]=94}var _8B=$k[--$j];var _8C=$k[--$j];$p($k[--$j],_8C,_8B);if($1.i<$1.gpf.length-1){var _8G=$k[--$j];var _8J=$g($1.gpf,$1.i+1);$k[$j++]=_8G;$k[$j++]=_8G;$k[$j++]=1;$k[$j++]=_8J;if(_8J==$1.fnc1){$j--;$k[$j++]=94}var _8L=$k[--$j];var _8M=$k[--$j];$p($k[--$j],_8M,_8L)}var _8Q=$g($1.numeric,$k[--$j])!==undefined;if(_8Q){$p($1.numericruns,$1.i,$f($g($1.numericruns,$1.i+2)+2))}else{$p($1.numericruns,$1.i,0)}var _8Y=$k[--$j];var _8a=$g($1.alphanumeric,_8Y)!==undefined;$k[$j++]=_8Y;if(_8a){$p($1.alphanumericruns,$1.i,$f($g($1.alphanumericruns,$1.i+1)+1))}else{$p($1.alphanumericruns,$1.i,0)}var _8i=$k[--$j];var _8k=$g($1.iso646,_8i)!==undefined;var _8m=$g($1.alphanumeric,_8i)!==undefined;if(_8k&&!_8m){$p($1.nextiso646only,$1.i,0)}else{$p($1.nextiso646only,$1.i,$f($g($1.nextiso646only,$1.i+1)+1))}}$1.gpfenc=$a(252);$1.i=0;$1.j=0;$1.mode="numeric";for(;;){if($1.i==$1.gpf.length){break}for(;;){if($eq($1.mode,"numeric")){if($1.i<=$1.gpf.length-2){var _90=$s(2);var _93=$g($1.gpf,$1.i);$k[$j++]=_90;$k[$j++]=_90;$k[$j++]=0;$k[$j++]=_93;if(_93==$1.fnc1){$j--;$k[$j++]=94}var _95=$k[--$j];var _96=$k[--$j];$p($k[--$j],_96,_95);var _98=$k[--$j];var _9B=$g($1.gpf,$1.i+1);$k[$j++]=_98;$k[$j++]=_98;$k[$j++]=1;$k[$j++]=_9B;if(_9B==$1.fnc1){$j--;$k[$j++]=94}var _9D=$k[--$j];var _9E=$k[--$j];$p($k[--$j],_9E,_9D);var _9G=$k[--$j];var _9I=$g($1.numeric,_9G)!==undefined;$k[$j++]=_9G;if(_9I){$k[$j++]=$1.numeric;$1.encode();$1.i=$1.i+2;break}$j--;$k[$j++]=$1.lalphanumeric;$k[$j++]=$1.numeric;$1.encode();$1.mode="alphanumeric";break}else{var _9P=$g($1.gpf,$1.i);if(_9P<48||_9P>57){$k[$j++]=$1.lalphanumeric;$k[$j++]=$1.numeric;$1.encode();$1.mode="alphanumeric";break}$k[$j++]="rem";$k[$j++]=12+1+$1.method.length+$1.vlf.length+$1.cdf.length+$1.j;$1.rembits();var _9W=$k[--$j];$1[$k[--$j]]=_9W;if($1.rem>=4&&$1.rem<=6){var _9d=$G($Z($s(6),"000000"),0,$1.rem);var _9i=$R($s(4),$f($g($1.gpf,$1.i)-47),2);$P(_9d,4-_9i.length,_9i);$k[$j++]=_9d;$k[$j++]="raw";$1.encode();$1.i=$1.i+1;break}else{var _9k=$s(2);$p(_9k,0,$g($1.gpf,$1.i));$p(_9k,1,94);$k[$j++]=_9k;$k[$j++]=$1.numeric;$1.encode();$1.i=$1.i+1;break}}}if($eq($1.mode,"alphanumeric")){if($g($1.gpf,$1.i)==$1.fnc1){$k[$j++]=$1.fnc1;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="numeric";$1.i=$1.i+1;break}var _A0=$g($1.gpf,$1.i);var _A2=$g($1.iso646,_A0)!==undefined;var _A4=$g($1.alphanumeric,_A0)!==undefined;if(_A2&&!_A4){$k[$j++]=$1.liso646;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="iso646";break}if($g($1.numericruns,$1.i)>=6){$k[$j++]=$1.lnumeric;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="numeric";break}var _AE=$g($1.numericruns,$1.i);if(_AE>=4&&$f(_AE+$1.i)==$1.gpf.length){$k[$j++]=$1.lnumeric;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="numeric";break}$k[$j++]=$g($1.gpf,$1.i);$k[$j++]=$1.alphanumeric;$1.encode();$1.i=$1.i+1;break}if($eq($1.mode,"iso646")){if($g($1.gpf,$1.i)==$1.fnc1){$k[$j++]=$1.fnc1;$k[$j++]=$1.iso646;$1.encode();$1.mode="numeric";$1.i=$1.i+1;break}if($g($1.numericruns,$1.i)>=4&&$g($1.nextiso646only,$1.i)>=10){$k[$j++]=$1.lnumeric;$k[$j++]=$1.iso646;$1.encode();$1.mode="numeric";break}if($g($1.alphanumericruns,$1.i)>=5&&$g($1.nextiso646only,$1.i)>=10){$k[$j++]=$1.lalphanumeric;$k[$j++]=$1.iso646;$1.encode();$1.mode="alphanumeric";break}$k[$j++]=$g($1.gpf,$1.i);$k[$j++]=$1.iso646;$1.encode();$1.i=$1.i+1;break}}}$1.gpf=$G($1.gpfenc,0,$1.j);var _Ay=1+12+$1.method.length+$1.vlf.length+$1.cdf.length+$1.gpf.length;$k[$j++]=_Ay;$k[$j++]=_Ay;$1.rembits();var _Az=$k[--$j];$1.pad=$a(_Az);$k[$j++]=_Az;if($1.vlf.length!=0){var _B2=$k[--$j];var _B4=~~($f($k[--$j]+_B2)/12);$p($1.vlf,0,_B4%2);var _B6=_B4<=14?0:1;$p($1.vlf,1,_B6)}else{$j-=2}if($1.pad.length>0){for(var _BB=0,_BA=$1.pad.length-1;_BB<=_BA;_BB+=5){$1.i=_BB;var _BC=$1.pad;var _BD=$1.i;var _BE=$a([0,0,1,0,0]);var _BF=$1.pad;var _BG=$1.i;var _BH=5;var _BI=_BF.length-_BG;if(_BF.length-_BG>5){var _=_BH;_BH=_BI;_BI=_}$P(_BC,_BD,$G(_BE,0,_BI))}if($eq($1.mode,"numeric")){$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.pad);$1.pad=$G($a(),0,$1.pad.length)}}$k[$j++]=Infinity;var _BQ=$1.linkage?1:0;$k[$j++]=_BQ;$F($1.method,function(){var _BS=$k[--$j];$k[$j++]=$f(_BS-48)});$q($1.vlf);$q($1.cdf);$q($1.gpf);$q($1.pad);$1.binval=$a();$1.datalen=~~($1.binval.length/12);$1.ncr=function(){var _BZ=$k[--$j];var _Ba=$k[--$j];var _Bb=$f(_Ba-_BZ);if(_BZ<$f(_Ba-_BZ)){var _=_Bb;_Bb=_BZ;_BZ=_}$k[$j++]=_Bb;$k[$j++]=1;$k[$j++]=1;for(var _Bd=_Ba,_Bc=$f(_BZ+1);_Bd>=_Bc;_Bd-=1){var _Be=$k[--$j];var _Bf=$k[--$j];var _Bg=$k[--$j];$k[$j++]=_Bg;$k[$j++]=_Bf;$k[$j++]=_Be*_Bd;if($le(_Bf,_Bg)){var _Bh=$k[--$j];var _Bi=$k[--$j];$k[$j++]=$f(_Bi+1);$k[$j++]=~~(_Bh/_Bi)}}for(;;){var _Bj=$k[--$j];var _Bk=$k[--$j];var _Bl=$k[--$j];$k[$j++]=_Bl;$k[$j++]=_Bk;$k[$j++]=_Bj;if($gt(_Bk,_Bl)){break}var _Bm=$k[--$j];var _Bn=$k[--$j];$k[$j++]=$f(_Bn+1);$k[$j++]=~~(_Bm/_Bn)}var _Bo=$k[--$j];var _Bp=$k[--$j];$k[$j++]=_Bo;$k[$j++]=_Bp;$j--;var _Bq=$k[--$j];var _Br=$k[--$j];$k[$j++]=_Bq;$k[$j++]=_Br;$j--};$1.getRSSwidths=function(){$1.oe=$k[--$j];$1.el=$k[--$j];$1.mw=$k[--$j];$1.nm=$k[--$j];$1.val=$k[--$j];$1.out=$a($1.el);$1.mask=0;for(var _C1=0,_C0=$f($1.el-2);_C1<=_C0;_C1+=1){$1.bar=_C1;$1.ew=1;var _C3=$1.bar;$1.mask=$1.mask|(_C3<0?1>>>-_C3:1<<_C3);for(;;){$k[$j++]="sval";$k[$j++]=$f($f($1.nm-$1.ew)-1);$k[$j++]=$f($f($1.el-$1.bar)-2);$1.ncr();var _C8=$k[--$j];$1[$k[--$j]]=_C8;if($1.oe&&$1.mask==0&&$f($f($f($1.nm-$1.ew)-$1.el*2)+$1.bar*2)>=-2){$k[$j++]="sval";$k[$j++]=$1.sval;$k[$j++]=$f($f($f($1.nm-$1.ew)-$1.el)+$1.bar);$k[$j++]=$f($f($1.el-$1.bar)-2);$1.ncr();var _CN=$k[--$j];var _CO=$k[--$j];$1[$k[--$j]]=$f(_CO-_CN)}if($f($1.el-$1.bar)>2){$1.lval=0;for(var _CY=$f($f($f($f($1.nm-$1.ew)-$1.el)+$1.bar)+2),_CX=$f($1.mw+1);_CY>=_CX;_CY-=1){$k[$j++]=$f($f($f($1.nm-_CY)-$1.ew)-1);$k[$j++]=$f($f($1.el-$1.bar)-3);$1.ncr();$1.lval=$f($k[--$j]+$1.lval)}$1.sval=$f($1.sval-$1.lval*$f($f($1.el-$1.bar)-1))}else{if($f($1.nm-$1.ew)>$1.mw){$1.sval=$f($1.sval-1)}}$1.val=$f($1.val-$1.sval);if($1.val<0){break}$1.ew=$1.ew+1;var _Cs=$1.bar;$1.mask=$1.mask&~(_Cs<0?1>>>-_Cs:1<<_Cs)}$1.val=$f($1.val+$1.sval);$1.nm=$f($1.nm-$1.ew);$p($1.out,$1.bar,$1.ew)}$p($1.out,$f($1.el-1),$1.nm);$k[$j++]=$1.out};if(!bwipp_databarexpanded.__9377__){(function(){var $ctx=Object.create($1);$ctx.tab174=$a([347,0,12,5,7,2,87,4,1387,348,10,7,5,4,52,20,2947,1388,8,9,4,5,30,52,3987,2948,6,11,3,6,10,104,4191,3988,4,13,1,8,1,204]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarexpanded.$ctx[id]=$ctx[id]);bwipp_databarexpanded.__9377__=1})()}$1.dxw=$a($1.datalen);for(var _DA=0,_D9=$1.datalen-1;_DA<=_D9;_DA+=1){$1.x=_DA;$1.d=$G($1.binval,$1.x*12,12);$k[$j++]="d";$k[$j++]=0;for(var _DE=0;_DE<=11;_DE+=1){$1.j=_DE;var _DJ=$k[--$j];$k[$j++]=$f(_DJ+~~Math.pow(2,11-$1.j)*$g($1.d,$1.j))}var _DK=$k[--$j];$1[$k[--$j]]=_DK;$1.j=0;for(;;){if($le($1.d,$g($1.tab174,$1.j))){var _DS=$G($1.tab174,$1.j+1,7);for(var _DT=0,_DU=_DS.length;_DT<_DU;_DT++){$k[$j++]=$g(_DS,_DT)}$1.dte=$k[--$j];$1.dto=$k[--$j];$1.dmwe=$k[--$j];$1.dmwo=$k[--$j];$1.dele=$k[--$j];$1.delo=$k[--$j];$1.dgs=$k[--$j];break}$1.j=$1.j+8}$k[$j++]="dwo";$k[$j++]=~~($f($1.d-$1.dgs)/$1.dte);$k[$j++]=$1.delo;$k[$j++]=$1.dmwo;$k[$j++]=4;$k[$j++]=true;$1.getRSSwidths();var _Dj=$k[--$j];$1[$k[--$j]]=_Dj;$k[$j++]="dwe";$k[$j++]=$f($1.d-$1.dgs)%$1.dte;$k[$j++]=$1.dele;$k[$j++]=$1.dmwe;$k[$j++]=4;$k[$j++]=false;$1.getRSSwidths();var _Dq=$k[--$j];$1[$k[--$j]]=_Dq;$1.dw=$a(8);if($1.x%2==0){for(var _Du=0;_Du<=3;_Du+=1){$1.j=_Du;$p($1.dw,7-$1.j*2,$g($1.dwo,$1.j));$p($1.dw,6-$1.j*2,$g($1.dwe,$1.j))}}else{for(var _E5=0;_E5<=3;_E5+=1){$1.j=_E5;$p($1.dw,$1.j*2,$g($1.dwo,$1.j));$p($1.dw,$1.j*2+1,$g($1.dwe,$1.j))}}$p($1.dxw,$1.x,$1.dw)}if(!bwipp_databarexpanded.__9444__){(function(){var $ctx=Object.create($1);$ctx.finderwidths=$a([1,8,4,1,1,1,1,4,8,1,3,6,4,1,1,1,1,4,6,3,3,4,6,1,1,1,1,6,4,3,3,2,8,1,1,1,1,8,2,3,2,6,5,1,1,1,1,5,6,2,2,2,9,1,1,1,1,9,2,2]);$ctx.finderseq=$a([$a([0,1]),$a([0,3,2]),$a([0,5,2,7]),$a([0,9,2,7,4]),$a([0,9,2,7,6,11]),$a([0,9,2,7,8,11,10]),$a([0,1,2,3,4,5,6,7]),$a([0,1,2,3,4,5,6,9,8]),$a([0,1,2,3,4,5,6,9,10,11]),$a([0,1,2,3,4,7,6,9,8,11,10])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarexpanded.$ctx[id]=$ctx[id]);bwipp_databarexpanded.__9444__=1})()}$1.seq=$g($1.finderseq,~~(($1.datalen-2)/2));$1.fxw=$a($1.seq.length);for(var _Ed=0,_Ec=$1.seq.length-1;_Ed<=_Ec;_Ed+=1){$1.x=_Ed;$p($1.fxw,$1.x,$G($1.finderwidths,$g($1.seq,$1.x)*5,5))}if(!bwipp_databarexpanded.__9480__){(function(){var $ctx=Object.create($1);$ctx.checkweights=$a([-1,-1,-1,-1,-1,-1,-1,-1,77,96,32,81,27,9,3,1,20,60,180,118,143,7,21,63,205,209,140,117,39,13,145,189,193,157,49,147,19,57,171,91,132,44,85,169,197,136,186,62,185,133,188,142,4,12,36,108,50,87,29,80,97,173,128,113,150,28,84,41,123,158,52,156,166,196,206,139,187,203,138,46,76,17,51,153,37,111,122,155,146,119,110,107,106,176,129,43,16,48,144,10,30,90,59,177,164,125,112,178,200,137,116,109,70,210,208,202,184,130,179,115,190,204,68,93,31,151,191,134,148,22,66,198,172,94,71,2,40,154,192,64,162,54,18,6,120,149,25,75,14,42,126,167,175,199,207,69,23,78,26,79,103,98,83,38,114,131,182,124,159,53,88,170,127,183,61,161,55,165,73,8,24,72,5,15,89,100,174,58,160,194,135,45]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_databarexpanded.$ctx[id]=$ctx[id]);bwipp_databarexpanded.__9480__=1})()}$k[$j++]=Infinity;$F($1.seq,function(){$q($G($1.checkweights,$k[--$j]*16,16))});var _Er=$a();$1.checkweightseq=$G(_Er,8,_Er.length-8);$k[$j++]=Infinity;var _Et=$1.dxw;for(var _Eu=0,_Ev=_Et.length;_Eu<_Ev;_Eu++){$F($g(_Et,_Eu))}$1.widths=$a();$1.checksum=0;for(var _F0=0,_Ez=$1.widths.length-1;_F0<=_Ez;_F0+=1){$1.i=_F0;$1.checksum=$f($1.checksum+$g($1.widths,$1.i)*$g($1.checkweightseq,$1.i))}$1.checksum=$f($1.checksum%211+($1.datalen-3)*211);$1.i=0;for(;;){if($1.checksum<=$g($1.tab174,$1.i)){var _FG=$G($1.tab174,$1.i+1,7);for(var _FH=0,_FI=_FG.length;_FH<_FI;_FH++){$k[$j++]=$g(_FG,_FH)}$1.cte=$k[--$j];$1.cto=$k[--$j];$1.cmwe=$k[--$j];$1.cmwo=$k[--$j];$1.cele=$k[--$j];$1.celo=$k[--$j];$1.cgs=$k[--$j];break}$1.i=$1.i+8}$k[$j++]="cwo";$k[$j++]=~~($f($1.checksum-$1.cgs)/$1.cte);$k[$j++]=$1.celo;$k[$j++]=$1.cmwo;$k[$j++]=4;$k[$j++]=true;$1.getRSSwidths();var _FX=$k[--$j];$1[$k[--$j]]=_FX;$k[$j++]="cwe";$k[$j++]=$f($1.checksum-$1.cgs)%$1.cte;$k[$j++]=$1.cele;$k[$j++]=$1.cmwe;$k[$j++]=4;$k[$j++]=false;$1.getRSSwidths();var _Fe=$k[--$j];$1[$k[--$j]]=_Fe;$1.cw=$a(8);for(var _Fh=0;_Fh<=3;_Fh+=1){$1.i=_Fh;$p($1.cw,$1.i*2,$g($1.cwo,$1.i));$p($1.cw,$1.i*2+1,$g($1.cwe,$1.i))}var _Fs=$a(22);$p(_Fs,0,$1.cw);$P(_Fs,1,$1.dxw);$1.dxw=$G(_Fs,0,$1.datalen+1);$1.datalen=$1.dxw.length;$1.rows=$a(~~Math.ceil($1.datalen/$1.segments));$1.numrows=$1.rows.length;for(var _G4=0,_G3=$1.numrows-1;_G4<=_G3;_G4+=1){$1.r=_G4;$k[$j++]=Infinity;if($1.segments%4!=0&&$1.r%2==1){$k[$j++]=0}$k[$j++]=1;$k[$j++]=1;for(var _G9=0,_G8=$1.segments-1;_G9<=_G8;_G9+=1){$1.pos=_G9+$1.r*$1.segments;if($1.pos<$1.datalen){$F($g($1.dxw,$1.pos));if($1.pos%2==0){$F($g($1.fxw,~~($1.pos/2)))}}}var _GL=$m()+2;$k[$j++]=1;$k[$j++]=1;$as($a(_GL));$p($1.rows,$1.r,$k[--$j]);$j--}if($ne($1.format,"expandedstacked")){var _GS=$g($1.rows,0);$1.sbs=$G(_GS,1,_GS.length-1);$k[$j++]=Infinity;$k[$j++]=1;for(var _GW=0,_GV=$1.datalen-1;_GW<=_GV;_GW+=1){$1.i=_GW;$F($g($1.dxw,$1.i));if($1.i%2==0){$F($g($1.fxw,~~($1.i/2)))}}$k[$j++]=1;$k[$j++]=1;$1.sbs=$a();delete $1.options["parse"];$k[$j++]=Infinity;var _Gg=$1.sbs;$k[$j++]=Infinity;for(var _Gi=0,_Gj=~~(($1.sbs.length+1)/2);_Gi<_Gj;_Gi++){$k[$j++]=$1.height}var _Gl=$a();$k[$j++]=Infinity;for(var _Gn=0,_Go=~~(($1.sbs.length+1)/2);_Gn<_Go;_Gn++){$k[$j++]=0}var _Gp=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_Gg;$k[$j++]="bhs";$k[$j++]=_Gl;$k[$j++]="bbs";$k[$j++]=_Gp;$k[$j++]="opt";$k[$j++]=$1.options;var _Gr=$d();$k[$j++]=_Gr;if(!$1.dontdraw){bwipp_renlinear()}}else{$1.seps=$a($1.numrows);for(var _Gx=0,_Gw=$1.numrows-1;_Gx<=_Gw;_Gx+=1){$1.r=_Gx;$1.row=$g($1.rows,$1.r);$k[$j++]=Infinity;for(var _H3=0,_H2=$1.row.length-1;_H3<=_H2;_H3+=2){$1.i=_H3;for(var _H7=0,_H8=$g($1.row,$1.i);_H7<_H8;_H7++){$k[$j++]=0}if($1.i<$1.row.length-1){for(var _HE=0,_HF=$g($1.row,$1.i+1);_HE<_HF;_HE++){$k[$j++]=1}}}$as($a($m()));$1.row=$k[--$j];$j--;$k[$j++]=Infinity;$F($1.row,function(){var _HK=$k[--$j];$k[$j++]=$f(1-_HK)});$1.sep=$a();$k[$j++]=Infinity;for(var _HO=19,_HN=$1.row.length-13;_HO<=_HN;_HO+=98){$k[$j++]=_HO}for(var _HR=68,_HQ=$1.row.length-13;_HR<=_HQ;_HR+=98){$k[$j++]=_HR}$1.finderpos=$a();var _HT=$1.finderpos;for(var _HU=0,_HV=_HT.length;_HU<_HV;_HU++){var _HW=$g(_HT,_HU);for(var _HY=_HW,_HX=$f(_HW+14);_HY<=_HX;_HY+=1){$1.i=_HY;if($g($1.row,$1.i)==0){if($g($1.row,$1.i-1)==1){$k[$j++]=1}else{var _Hi=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_Hi}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}}$P($1.sep,0,$a([0,0,0,0]));$P($1.sep,$1.row.length-4,$a([0,0,0,0]));if($1.segments%4==0&&$1.r%2==1){if($g($1.rows,$1.r).length!=$g($1.rows,0).length&&$1.finderpos.length%2==1){$k[$j++]=Infinity;$k[$j++]=0;$q($1.row);$1.row=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($1.sep);$1.sep=$a()}else{for(var _I4=$1.row.length-1;_I4>=0;_I4-=1){$k[$j++]=$g($1.row,_I4)}$as($1.row);$j--;for(var _I9=$1.sep.length-1;_I9>=0;_I9-=1){$k[$j++]=$g($1.sep,_I9)}$as($1.sep);$j--}}$p($1.rows,$1.r,$1.row);$p($1.seps,$1.r,$1.sep)}$1.pixx=$g($1.rows,0).length;$k[$j++]=Infinity;for(var _IM=0,_IN=$1.pixx;_IM<_IN;_IM++){$k[$j++]=0}var _IO=$a();$P(_IO,0,$g($1.rows,$1.numrows-1));$p($1.rows,$1.numrows-1,_IO);$k[$j++]=Infinity;for(var _IV=0,_IW=$1.pixx;_IV<_IW;_IV++){$k[$j++]=0}var _IX=$a();$P(_IX,0,$g($1.seps,$1.numrows-1));$p($1.seps,$1.numrows-1,_IX);$k[$j++]=Infinity;for(var _Ie=0,_If=~~($1.pixx/2)+1;_Ie<_If;_Ie++){$k[$j++]=0;$k[$j++]=1}$1.sep=$G($a(),0,$1.pixx);$P($1.sep,0,$a([0,0,0,0]));$P($1.sep,$1.pixx-4,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _Iq=0,_Ip=$1.numrows-1;_Iq<=_Ip;_Iq+=1){$1.r=_Iq;if($1.r!=0){$q($g($1.seps,$1.r))}for(var _Iw=0,_Ix=$1.barxmult;_Iw<_Ix;_Iw++){$q($g($1.rows,$1.r))}if($1.r!=$1.numrows-1){$q($g($1.seps,$1.r));$q($1.sep)}}$1.pixs=$a();delete $1.options["parse"];var _JH=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",~~($1.pixs.length/$1.pixx)],["height",~~($1.pixs.length/$1.pixx)/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_JH;if(!$1.dontdraw){bwipp_renmatrix()}}}function bwipp_databarexpandedstacked(){var $1=Object.create(bwipp_databarexpandedstacked.$ctx||(bwipp_databarexpandedstacked.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"format","expandedstacked");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_databarexpanded();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1northamericancoupon(){var $1=Object.create(bwipp_gs1northamericancoupon.$ctx||(bwipp_gs1northamericancoupon.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.coupontextfont="OCR-B";$1.coupontextsize=9;$1.coupontextxoffset=null;$1.coupontextyoffset=null;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$j--;$1.vals=$k[--$j];$1.ais=$k[--$j];if($1.ais.length!=1){$k[$j++]="bwipp.gs1northamericancouponBadAIStructure#9776";$k[$j++]="A GS1 North American Coupon should consist of a single AI (8110)";bwipp_raiseerror()}if($ne($g($1.ais,0),"8110")){$k[$j++]="bwipp.gs1northamericancouponBadAIStructure#9779";$k[$j++]="A GS1 North American Coupon should consist of a single AI (8110)";bwipp_raiseerror()}$1.val=$g($1.vals,0);$1.vli=$f($g($1.val,0)-48);if($1.vli<0||$1.vli>6){$k[$j++]="bwipp.gs1northamericancouponBadVLI#9786";$k[$j++]="The AI (8110) data should start with a Company Prefix length indicator in the range 0 to 6";bwipp_raiseerror()}$1.gcp=$G($1.val,1,$f($1.vli+6));$1.cod=$G($1.val,$f($1.vli+7),6);$1.coupontext=$s($1.gcp.length+7);$P($1.coupontext,0,$1.gcp);$P($1.coupontext,$1.gcp.length,"-");$P($1.coupontext,$1.gcp.length+1,$1.cod);delete $1.options["parse"];$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_databarexpandedstacked();var _X=$k[--$j];$1[$k[--$j]]=_X;if($1.includetext){if($eq($1.coupontextxoffset,null)){$1.coupontextxoffset=0}if($eq($1.coupontextyoffset,null)){$1.coupontextyoffset=$f($g($1.args,"height")*72+3)}var _f=$g($1.args,"txt")!==undefined;if(_f){$1.txt=$g($1.args,"txt");$1.newtxt=$a($1.txt.length+1);$P($1.newtxt,0,$1.txt);$p($1.newtxt,$1.newtxt.length-1,$a([$1.coupontext,$1.coupontextxoffset,$1.coupontextyoffset,$1.coupontextfont,$1.coupontextsize]));$p($1.args,"txt",$1.newtxt)}else{$p($1.args,"txt",$a([$a([$1.coupontext,$1.coupontextxoffset,$1.coupontextyoffset,$1.coupontextfont,$1.coupontextsize])]))}}$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_pharmacode(){var $1=Object.create(bwipp_pharmacode.$ctx||(bwipp_pharmacode.$ctx={}));$1.dontdraw=false;$1.height=8*2.835/72;$1.nwidth=.5*2.835;$1.wwidth=1.5*2.835;$1.swidth=1*2.835;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.barcode.length<1||$1.barcode.length>6){$k[$j++]="bwipp.pharmacodeBadLength#9867";$k[$j++]="Pharmacode must be 1 to 6 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.pharmacodeBadCharacter#9871";$k[$j++]="Pharmacode must contain only digits";bwipp_raiseerror()}});var _7=$i($1.barcode);if(_7<3||_7>131070){$k[$j++]="bwipp.pharmacodeBadValue#9875";$k[$j++]="Pharmacode value must be between 3 and 131070";bwipp_raiseerror()}$1.txt=$a($1.barcode.length);for(var _C=0,_B=$1.barcode.length-1;_C<=_B;_C+=1){$1.i=_C;$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),0,0,"",0]))}$1.barcode=$R($s(17),$i($1.barcode)+1,2);$1.barcode=$G($1.barcode,1,$1.barcode.length-1);$1.barlen=$1.barcode.length;$1.sbs=$a($1.barlen*2);for(var _U=0,_T=$1.barlen-1;_U<=_T;_U+=1){$1.i=_U;$1.enc=$G($1.barcode,$1.i,1);if($eq($1.enc,"0")){$p($1.sbs,$1.i*2,$1.nwidth)}else{$p($1.sbs,$1.i*2,$1.wwidth)}$p($1.sbs,$1.i*2+1,$1.swidth)}$k[$j++]=Infinity;var _i=$1.sbs;$k[$j++]=Infinity;for(var _k=0,_l=~~(($1.sbs.length+1)/2);_k<_l;_k++){$k[$j++]=$1.height}var _n=$a();$k[$j++]=Infinity;for(var _p=0,_q=~~(($1.sbs.length+1)/2);_p<_q;_p++){$k[$j++]=0}var _r=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_i;$k[$j++]="bhs";$k[$j++]=_n;$k[$j++]="bbs";$k[$j++]=_r;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$1.options;var _u=$d();$k[$j++]=_u;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_pharmacode2(){var $1=Object.create(bwipp_pharmacode2.$ctx||(bwipp_pharmacode2.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.height=4;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.barcode.length<1||$1.barcode.length>8){$k[$j++]="bwipp.pharmacode2BadLength#9956";$k[$j++]="Two-track Pharmacode must be 1 to 6 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.pharmacode2badCharacter#9960";$k[$j++]="Two-track Pharmacode must contain only digits";bwipp_raiseerror()}});var _7=$i($1.barcode);if(_7<4||_7>64570080){$k[$j++]="bwipp.pharmacode2badValue#9964";$k[$j++]="Two-track Pharmacode value must be between 4 and 64570080";bwipp_raiseerror()}$1.txt=$a($1.barcode.length);for(var _C=0,_B=$1.barcode.length-1;_C<=_B;_C+=1){$1.i=_C;$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),0,0,"",0]))}$1.encstr=$s(16);$1.sbs=$a(32);$1.bar=1/25.4*$1.height;$1.spc=1/25.4*72;$1.i=15;$1.val=$i($1.barcode);for(;;){if($1.val==0){break}var _P=$1.val%3;$1.val=~~($f($1.val-$g($a([3,1,2]),_P))/3);$p($1.encstr,$1.i,$g($a([2,0,1]),_P));$1.i=$1.i-1}$1.encstr=$G($1.encstr,$1.i+1,15-$1.i);$1.bhs=$a($1.encstr.length);$1.bbs=$a($1.encstr.length);for(var _i=0,_h=$1.encstr.length-1;_i<=_h;_i+=1){$1.i=_i;var _l=$g($1.encstr,$1.i);$p($1.bhs,$1.i,$1.bar*$g($a([1,1,2]),_l));$p($1.bbs,$1.i,$g($a([0,$1.bar,0]),_l))}$k[$j++]=Infinity;var _w=$1.bhs;var _x=$1.bbs;$k[$j++]=Infinity;for(var _z=0,_10=$1.encstr.length*2;_z<_10;_z++){$k[$j++]=$1.spc}var _12=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bhs";$k[$j++]=_w;$k[$j++]="bbs";$k[$j++]=_x;$k[$j++]="sbs";$k[$j++]=_12;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="textyoffset";$k[$j++]=4;$k[$j++]="opt";$k[$j++]=$1.options;var _15=$d();$k[$j++]=_15;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code2of5(){var $1=Object.create(bwipp_code2of5.$ctx||(bwipp_code2of5.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.validatecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$1.version="industrial";$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$F($1.barcode,function(){var _3=$k[--$j];if(_3<48||_3>57){$k[$j++]="bwipp.code2of5badCharacter#10067";$k[$j++]="Code 25 must contain only digits";bwipp_raiseerror()}});$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _6=$k[--$j];$k[$j++]=$f(_6-1)}var _7=$k[--$j];$1[$k[--$j]]=_7;$1.checksum=0;for(var _B=0,_A=$f($1.barlen-1);_B<=_A;_B+=1){$1.i=_B;$k[$j++]="checksum";$k[$j++]=$1.checksum;$k[$j++]=$f($g($1.barcode,$1.i)-48);if($f($1.barlen-$1.i)%2!=0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$1[$k[--$j]]=$f(_K+_J)}$1.checksum=(10-$1.checksum%10)%10;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$1.checksum+48){$k[$j++]="bwipp.code2of5badCheckDigit#10081";$k[$j++]="Incorrect Code 25 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen);$1.includecheck=true}if(!bwipp_code2of5.__10113__){(function(){var $ctx=Object.create($1);var _a=new Map([["industrial",$a(["1111313111","3111111131","1131111131","3131111111","1111311131","3111311111","1131311111","1111113131","3111113111","1131113111","313111","31113"])],["iata",$a(["1111313111","3111111131","1131111131","3131111111","1111311131","3111311111","1131311111","1111113131","3111113111","1131113111","1111","311"])],["matrix",$a(["113311","311131","131131","331111","113131","313111","133111","111331","311311","131311","311111","31111"])],["coop",$a(["331111","111331","113131","113311","131131","131311","133111","311131","311311","313111","3131","133"])],["datalogic",$a(["113311","311131","131131","331111","113131","313111","133111","111331","311311","131311","1111","311"])]]);$ctx.versions=_a;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code2of5.$ctx[id]=$ctx[id]);bwipp_code2of5.__10113__=1})()}var _e=$g($1.versions,$1.version)!==undefined;if(!_e){$k[$j++]="bwipp.code2of5badVersion#10116";$k[$j++]="Unrecognised Code 25 version";bwipp_raiseerror()}$1.encs=$g($1.versions,$1.version);$1.cs=$g($1.encs,0).length;$k[$j++]="cw";$k[$j++]=0;$F($g($1.encs,0),function(){var _m=$k[--$j];var _n=$k[--$j];$k[$j++]=$f(_n+$f(_m-48))});var _o=$k[--$j];$1[$k[--$j]]=_o;$1.ss=$g($1.encs,10).length;$k[$j++]="sw";$k[$j++]=0;$F($g($1.encs,10),function(){var _u=$k[--$j];var _v=$k[--$j];$k[$j++]=$f(_v+$f(_u-48))});var _w=$k[--$j];$1[$k[--$j]]=_w;$1.es=$g($1.encs,11).length;if(!bwipp_code2of5.__10129__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code2of5.$ctx[id]=$ctx[id]);bwipp_code2of5.__10129__=1})()}$k[$j++]="sbs";$k[$j++]=$1.barlen;if($1.includecheck){var _13=$k[--$j];$k[$j++]=$f(_13+1)}var _18=$s($f($f($k[--$j]*$1.cs+$1.ss)+$1.es));$1[$k[--$j]]=_18;$k[$j++]="txt";$k[$j++]=$1.barlen;if($1.includecheck){var _1C=$k[--$j];$k[$j++]=$f(_1C+1)}var _1E=$a($k[--$j]);$1[$k[--$j]]=_1E;$P($1.sbs,0,$g($1.encs,10));for(var _1L=0,_1K=$f($1.barlen-1);_1L<=_1K;_1L+=1){$1.i=_1L;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*$1.cs+$1.ss,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$f($1.i*$1.cw+$1.sw),$1.textyoffset,$1.textfont,$1.textsize]))}if($1.includecheck){$P($1.sbs,$f($1.barlen*$1.cs+$1.ss),$g($1.encs,$1.checksum));$P($1.sbs,$f($f($1.barlen*$1.cs+$1.cs)+$1.ss),$g($1.encs,11));if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum,1),$f($1.barlen*$1.cw+$1.sw),$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a([" ",$f($1.barlen*$1.cw+$1.sw),$1.textyoffset,$1.textfont,$1.textsize]))}}else{$P($1.sbs,$f($1.barlen*$1.cs+$1.ss),$g($1.encs,11))}$k[$j++]=Infinity;$k[$j++]=Infinity;$F($1.sbs,function(){var _2T=$k[--$j];$k[$j++]=$f(_2T-48)});var _2U=$a();$k[$j++]=Infinity;for(var _2W=0,_2X=~~(($1.sbs.length+1)/2);_2W<_2X;_2W++){$k[$j++]=$1.height}var _2Z=$a();$k[$j++]=Infinity;for(var _2b=0,_2c=~~(($1.sbs.length+1)/2);_2b<_2c;_2b++){$k[$j++]=0}var _2d=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_2U;$k[$j++]="bhs";$k[$j++]=_2Z;$k[$j++]="bbs";$k[$j++]=_2d;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2h=$d();$k[$j++]=_2h;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_industrial2of5(){var $1=Object.create(bwipp_industrial2of5.$ctx||(bwipp_industrial2of5.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"version","industrial");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code2of5();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_iata2of5(){var $1=Object.create(bwipp_iata2of5.$ctx||(bwipp_iata2of5.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"version","iata");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code2of5();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_matrix2of5(){var $1=Object.create(bwipp_matrix2of5.$ctx||(bwipp_matrix2of5.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"version","matrix");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code2of5();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_coop2of5(){var $1=Object.create(bwipp_coop2of5.$ctx||(bwipp_coop2of5.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"version","coop");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code2of5();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_datalogic2of5(){var $1=Object.create(bwipp_datalogic2of5.$ctx||(bwipp_datalogic2of5.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"version","datalogic");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code2of5();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_code11(){var $1=Object.create(bwipp_code11.$ctx||(bwipp_code11.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.validatecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];var _1=$k[--$j];$1.barcode=_1;if(!bwipp_code11.__10477__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["111131","311131","131131","331111","113131","313111","133111","111331","311311","311111","113111","113311"]);$ctx.barchars="0123456789-";$ctx.charvals=new Map;for(var _3=0;_3<=10;_3+=1){$p($ctx.charvals,$G($ctx.barchars,_3,1),_3)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code11.$ctx[id]=$ctx[id]);bwipp_code11.__10477__=1})()}for(var _A=0,_9=$1.barcode.length-1;_A<=_9;_A+=1){var _E=$g($1.charvals,$G($1.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.code11badCharacter#10482";$k[$j++]="Code 11 must contain only digits and dashes";bwipp_raiseerror()}}$1.barlen=$1.barcode.length;if($1.validatecheck){if($1.barlen==11){$k[$j++]="bwipp.code11badLength#10489";$k[$j++]="Code 11 cannot be 11 characters using check digits";bwipp_raiseerror()}var _K=$1.barlen<=10?1:2;$1.barlen=$1.barlen-_K}$k[$j++]="numchecks";if($1.includecheck||$1.validatecheck){var _O=$1.barlen>=10?2:1;$k[$j++]=_O}else{$k[$j++]=0}var _P=$k[--$j];$1[$k[--$j]]=_P;$1.checksum1=0;$1.checksum2=0;for(var _T=0,_S=$1.barlen-1;_T<=_S;_T+=1){$1.i=_T;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$1.checksum1=$f($1.checksum1+(($1.barlen-$1.i-1)%10+1)*$1.indx);$1.checksum2=$f($1.checksum2+(($1.barlen-$1.i)%9+1)*$1.indx)}$1.checksum1=$1.checksum1%11;$1.checksum2=$f($1.checksum2+$1.checksum1)%11;if($1.validatecheck){if($1.numchecks==1){var _r=$g($1.barchars,$1.checksum1);if($g($1.barcode,$1.barlen)!=_r){$k[$j++]="bwipp.code11badCheckDigit#10507";$k[$j++]="Incorrect Code 11 check digit provided";bwipp_raiseerror()}}else{if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum1)||$g($1.barcode,$1.barlen+1)!=$g($1.barchars,$1.checksum2)){$k[$j++]="bwipp.code11badCheckDigits#10512";$k[$j++]="Incorrect Code 11 check digits provided";bwipp_raiseerror()}}$1.barcode=$G($1.barcode,0,$1.barlen);$1.includecheck=true}$1.sbs=$s($f($f($1.barlen+$1.numchecks)*6+12));$1.txt=$a($f($1.barlen+$1.numchecks));$P($1.sbs,0,$g($1.encs,11));$1.xpos=8;for(var _1I=0,_1H=$1.barlen-1;_1I<=_1H;_1I+=1){$1.i=_1I;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*6+6,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]));for(var _1e=0;_1e<=5;_1e+=1){$1.xpos=$f($f($g($1.enc,_1e)-48)+$1.xpos)}}if($1.includecheck){if($1.barlen>=10){$P($1.sbs,$1.barlen*6+6,$g($1.encs,$1.checksum1));$P($1.sbs,$1.barlen*6+12,$g($1.encs,$1.checksum2));if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum1,1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]));$1.enc=$g($1.encs,$1.checksum1);for(var _28=0;_28<=5;_28+=1){$1.xpos=$f($f($g($1.enc,_28)-48)+$1.xpos)}$p($1.txt,$1.barlen+1,$a([$G($1.barchars,$1.checksum2,1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a(["",$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]));$p($1.txt,$1.barlen+1,$a(["",$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,$1.barlen*6+18,$g($1.encs,11))}else{$P($1.sbs,$1.barlen*6+6,$g($1.encs,$1.checksum1));if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum1,1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a(["",$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,$1.barlen*6+12,$g($1.encs,11))}}else{$P($1.sbs,$1.barlen*6+6,$g($1.encs,11))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _39=$1.sbs;for(var _3A=0,_3B=_39.length;_3A<_3B;_3A++){$k[$j++]=$g(_39,_3A)-48}var _3D=$a();$k[$j++]=Infinity;for(var _3F=0,_3G=~~(($1.sbs.length+1)/2);_3F<_3G;_3F++){$k[$j++]=$1.height}var _3I=$a();$k[$j++]=Infinity;for(var _3K=0,_3L=~~(($1.sbs.length+1)/2);_3K<_3L;_3K++){$k[$j++]=0}var _3M=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_3D;$k[$j++]="bhs";$k[$j++]=_3I;$k[$j++]="bbs";$k[$j++]=_3M;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _3Q=$d();$k[$j++]=_3Q;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_bc412(){var $1=Object.create(bwipp_bc412.$ctx||(bwipp_bc412.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.validatecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.includestartstop=false;$1.semi=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.semi){$1.includestartstop=true}if(!bwipp_bc412.__10643__){(function(){var $ctx=Object.create($1);$ctx.barchars="0R9GLVHA8EZ4NTS1J2Q6C7DYKBUIX3FWP5M";$ctx.charvals=new Map;for(var _3=0;_3<=34;_3+=1){$p($ctx.charvals,$G($ctx.barchars,_3,1),_3)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_bc412.$ctx[id]=$ctx[id]);bwipp_bc412.__10643__=1})()}for(var _A=0,_9=$1.barcode.length-1;_A<=_9;_A+=1){var _E=$g($1.charvals,$G($1.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.bc412badCharacter#10648";$k[$j++]="BC412 must contain only digits and capital letters except O";bwipp_raiseerror()}}if($1.semi){if($1.validatecheck){if($1.barcode.length<8||$1.barcode.length>19){$k[$j++]="bwipp.bc412semivalidateBadLength#10656";$k[$j++]="BC412 semi with check digit must be 8 to 19 characters long";bwipp_raiseerror()}}else{if($1.barcode.length<7||$1.barcode.length>18){$k[$j++]="bwipp.bc412semiBadLength#10660";$k[$j++]="BC412 semi must be 7 to 18 characters long";bwipp_raiseerror()}}$1.barlen=$1.barcode.length;if(!$1.validatecheck){$1.barlen=$1.barlen+1;$1.sbarcode=$s($1.barlen);$p($1.sbarcode,0,$g($1.barcode,0));$p($1.sbarcode,1,48);$P($1.sbarcode,2,$G($1.barcode,1,$1.barlen-2));$1.barcode=$1.sbarcode}$1.sumodd=0;$1.sumeven=0;for(var _b=0,_a=$1.barlen-1;_b<=_a;_b+=1){$1.i=_b;$k[$j++]=$g($1.charvals,$G($1.barcode,$1.i,1));if($1.i%2==0){$1.sumodd=$f($k[--$j]+$1.sumodd)}else{$1.sumeven=$f($k[--$j]+$1.sumeven)}}$1.checksum=$f($1.sumodd%35+$1.sumeven%35*2)%35;if($1.validatecheck){if($1.checksum!=0){$k[$j++]="bwipp.bc412semiBadCheckDigit#10686";$k[$j++]="Incorrect BC412 semi check digit provided";bwipp_raiseerror()}}else{$1.checksum=$1.checksum*17%35;$p($1.barcode,1,$g($1.barchars,$1.checksum))}}else{$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _x=$k[--$j];$k[$j++]=$f(_x-1)}var _y=$k[--$j];$1[$k[--$j]]=_y;$1.checksum=0;for(var _12=0,_11=$1.barlen-1;_12<=_11;_12+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_12,1))+$1.checksum)}$1.checksum=$1.checksum%35;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.bc412badCheckDigit#10703";$k[$j++]="Incorrect BC412 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen);$1.includecheck=true}}if(!bwipp_bc412.__10722__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["11111115","13111212","11131113","12111213","12121311","13131111","12111312","11131212","11121411","11151111","15111111","11111511","12131211","13121112","13111311","11111214","12121113","11111313","13111113","11121213","11141112","11121312","11141211","14121111","12121212","11131311","13121211","12111411","14111211","11111412","12111114","14111112","12141111","11121114","12131112","12","111"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_bc412.$ctx[id]=$ctx[id]);bwipp_bc412.__10722__=1})()}$1.sbs=$s(($1.barlen+1)*8+5);if($1.includecheck){$1.txt=$a($1.barlen+1)}else{$1.txt=$a($1.barlen)}if($1.includestartstop){$P($1.sbs,0,$g($1.encs,35));$1.pos=2;$1.txtpos=3}else{$1.pos=0;$1.txtpos=0}for(var _1Y=0,_1X=$1.barlen-1;_1Y<=_1X;_1Y+=1){$1.i=_1Y;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$P($1.sbs,$1.pos,$g($1.encs,$1.indx));$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*12+$1.txtpos,$1.textyoffset,$1.textfont,$1.textsize]));$1.pos=$1.pos+8}if($1.includecheck){$P($1.sbs,$1.pos,$g($1.encs,$1.checksum));if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum,1),$1.barlen*12+$1.txtpos,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a(["",$1.barlen*12+$1.txtpos,$1.textyoffset,$1.textfont,$1.textsize]))}$1.pos=$1.pos+8}if($1.includestartstop){$P($1.sbs,$1.pos,$g($1.encs,36));$1.pos=$1.pos+3}$1.sbs=$G($1.sbs,0,$1.pos);$k[$j++]=Infinity;$k[$j++]=Infinity;var _2V=$1.sbs;for(var _2W=0,_2X=_2V.length;_2W<_2X;_2W++){$k[$j++]=$f($g(_2V,_2W)-48)}var _2Z=$a();$k[$j++]=Infinity;for(var _2b=0,_2c=~~(($1.sbs.length+1)/2);_2b<_2c;_2b++){$k[$j++]=$1.height}var _2e=$a();$k[$j++]=Infinity;for(var _2g=0,_2h=~~(($1.sbs.length+1)/2);_2g<_2h;_2g++){$k[$j++]=0}var _2i=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_2Z;$k[$j++]="bhs";$k[$j++]=_2e;$k[$j++]="bbs";$k[$j++]=_2i;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2m=$d();$k[$j++]=_2m;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_rationalizedCodabar(){var $1=Object.create(bwipp_rationalizedCodabar.$ctx||(bwipp_rationalizedCodabar.$ctx={}));$1.dontdraw=false;$1.altstartstop=false;$1.includecheck=false;$1.validatecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];var _1=$k[--$j];$1.barcode=_1;if(!bwipp_rationalizedCodabar.__10844__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["11111331","11113311","11131131","33111111","11311311","31111311","13111131","13113111","13311111","31131111","11133111","11331111","31113131","31311131","31313111","11313131","11331311","13131131","11131331","11133311"]);$ctx.barcharsnormal="0123456789-$:/.+ABCD";$ctx.barcharsalt="0123456789-$:/.+TN*E";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_rationalizedCodabar.$ctx[id]=$ctx[id]);bwipp_rationalizedCodabar.__10844__=1})()}var _5=$1.altstartstop?$1.barcharsalt:$1.barcharsnormal;$1.barchars=_5;$1.charvals=new Map;for(var _6=0;_6<=19;_6+=1){$p($1.charvals,$G($1.barchars,_6,1),_6)}$1.bodyvals=new Map;for(var _A=0;_A<=15;_A+=1){$p($1.bodyvals,$G($1.barchars,_A,1),_A)}$1.ssvals=new Map;for(var _E=16;_E<=19;_E+=1){$p($1.ssvals,$G($1.barchars,_E,1),_E)}var _L=$g($1.ssvals,$G($1.barcode,0,1))!==undefined;var _Q=$g($1.ssvals,$G($1.barcode,$1.barcode.length-1,1))!==undefined;if(!_L||!_Q){if($1.altstartstop){$k[$j++]="bwipp.rationalizedCodabarBadAltStartStop#10859";$k[$j++]="Codabar start and stop characters must be one of E N T or *";bwipp_raiseerror()}else{$k[$j++]="bwipp.rationalizedCodabarBadStartStop#10861";$k[$j++]="Codabar start and stop characters must be one of A B C or D";bwipp_raiseerror()}}for(var _U=1,_T=$1.barcode.length-2;_U<=_T;_U+=1){var _Y=$g($1.bodyvals,$G($1.barcode,_U,1))!==undefined;if(!_Y){$k[$j++]="bwipp.rationalizedCodabarBadCharacter#10866";$k[$j++]="Codabar body must contain only digits and symbols - $ : / . +";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _b=$k[--$j];$k[$j++]=$f(_b-1)}var _c=$k[--$j];$1[$k[--$j]]=_c;$1.checksum=0;for(var _g=0,_f=$f($1.barlen-2);_g<=_f;_g+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_g,1))+$1.checksum)}$1.checksum=$f($g($1.charvals,$G($1.barcode,$1.barcode.length-1,1))+$1.checksum);$1.checksum=$f(16-$1.checksum%16)%16;if($1.validatecheck){if($g($1.barcode,$f($1.barlen-1))!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.rationalizedCodabarBadCheckDigit#10882";$k[$j++]="Incorrect Codabar check digit provided";bwipp_raiseerror()}var _11=$s($1.barlen);$P(_11,0,$G($1.barcode,0,$f($1.barlen-1)));$P(_11,$f($1.barlen-1),$G($1.barcode,$1.barlen,1));$1.barcode=_11;$1.includecheck=true}$k[$j++]="sbs";$k[$j++]=$1.barlen;if($1.includecheck){var _1B=$k[--$j];$k[$j++]=$f(_1B+1)}var _1D=$s($k[--$j]*8);$1[$k[--$j]]=_1D;$k[$j++]="txt";$k[$j++]=$1.barlen;if($1.includecheck){var _1H=$k[--$j];$k[$j++]=$f(_1H+1)}var _1J=$a($k[--$j]);$1[$k[--$j]]=_1J;$1.xpos=0;for(var _1N=0,_1M=$f($1.barlen-2);_1N<=_1M;_1N+=1){$1.i=_1N;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*8,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]));for(var _1j=0;_1j<=7;_1j+=1){$1.xpos=$f($f($g($1.enc,_1j)-48)+$1.xpos)}}if($1.includecheck){$P($1.sbs,$f($1.barlen*8-8),$g($1.encs,$1.checksum));if($1.includecheckintext){$p($1.txt,$f($1.barlen-1),$a([$G($1.barchars,$1.checksum,1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$f($1.barlen-1),$a([" ",$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}for(var _2B=0;_2B<=7;_2B+=1){$1.xpos=$f($f($g($g($1.encs,$1.checksum),_2B)-48)+$1.xpos)}$1.indx=$g($1.charvals,$G($1.barcode,$f($1.barlen-1),1));$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.barlen*8,$1.enc);$p($1.txt,$1.barlen,$a([$G($1.barcode,$f($1.barlen-1),1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}else{$1.indx=$g($1.charvals,$G($1.barcode,$f($1.barlen-1),1));$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$f($1.barlen*8-8),$1.enc);$p($1.txt,$f($1.barlen-1),$a([$G($1.barcode,$f($1.barlen-1),1),$1.xpos,$1.textyoffset,$1.textfont,$1.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;$F($1.sbs,function(){var _2y=$k[--$j];$k[$j++]=$f(_2y-48)});var _2z=$a();$k[$j++]=Infinity;for(var _31=0,_32=~~(($1.sbs.length+1)/2);_31<_32;_31++){$k[$j++]=$1.height}var _34=$a();$k[$j++]=Infinity;for(var _36=0,_37=~~(($1.sbs.length+1)/2);_36<_37;_36++){$k[$j++]=0}var _38=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_2z;$k[$j++]="bhs";$k[$j++]=_34;$k[$j++]="bbs";$k[$j++]=_38;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _3C=$d();$k[$j++]=_3C;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_onecode(){var $1=Object.create(bwipp_onecode.$ctx||(bwipp_onecode.$ctx={}));$1.dontdraw=false;$1.height=.15;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$1.barlen=$1.barcode.length;$F($1.barcode,function(){var _4=$k[--$j];if(_4<48||_4>57){$k[$j++]="bwipp.onecodeBadCharacter#10992";$k[$j++]="The data must contain only digits";bwipp_raiseerror()}});if($1.barlen!=20&&$1.barlen!=25&&$1.barlen!=29&&$1.barlen!=31){$k[$j++]="bwipp.onecodeInvalidLength#10997";$k[$j++]="The data must be 20, 25, 29 or 31 digits";bwipp_raiseerror()}$k[$j++]=Infinity;var _B=$eq($G($1.barcode,5,1),"9")?14:11;$k[$j++]=2;$k[$j++]=2;$k[$j++]=5;$k[$j++]=5;$k[$j++]=_B;$k[$j++]=_B;$k[$j++]=20;$k[$j++]=20;$k[$j++]=25;$k[$j++]=25;$k[$j++]=29;$k[$j++]=29;$1.txtdict=$d();$1.txt=$a($1.barlen+6);$1.spacecnt=0;for(var _H=0,_G=$1.barlen-1;_H<=_G;_H+=1){$1.i=_H;var _K=$g($1.txtdict,$1.i)!==undefined;if(_K){$p($1.txt,$1.i+$1.spacecnt,$a([" ",0,0,"",0]));$1.spacecnt=$1.spacecnt+1}$p($1.txt,$1.i+$1.spacecnt,$a([$G($1.barcode,$1.i,1),0,0,"",0]))}$1.txt=$G($1.txt,0,$1.barcode.length+$1.spacecnt);$1.normalize=function(){$1.base=$k[--$j];$1.num=$k[--$j];for(var _e=$1.num.length-1;_e>=1;_e-=1){$1.i=_e;var _f=$1.num;var _g=$1.i;$p(_f,_g-1,$f($g(_f,_g-1)+~~($g($1.num,$1.i)/$1.base)));$p($1.num,$1.i,$g($1.num,$1.i)%$1.base)}for(;;){if($lt($g($1.num,0),$1.base)){break}$k[$j++]=Infinity;$k[$j++]=0;$q($1.num);$1.num=$a();$p($1.num,0,$f($g($1.num,0)+~~($g($1.num,1)/$1.base)));$p($1.num,1,$g($1.num,1)%$1.base)}$k[$j++]=Infinity;$1.i=true;var _17=$1.num;for(var _18=0,_19=_17.length;_18<_19;_18++){var _1A=$g(_17,_18);$k[$j++]=_1A;if(_1A==0&&$1.i){$j--}else{$1.i=false}}$1.num=$a();if($1.num.length==0){$1.num=$a([0])}$k[$j++]=$1.num};$1.bigadd=function(){var _1G=$k[--$j];var _1H=$k[--$j];$1.offset=Math.abs(_1G.length-_1H.length);if(_1G.length<_1H.length){var _=_1G;_1G=_1H;_1H=_}$1.a=_1G;$1.b=_1H;for(var _1K=0,_1J=$1.b.length-1;_1K<=_1J;_1K+=1){var _1L=$1.a;var _1M=$1.offset;$p(_1L,_1K+_1M,$f($g(_1L,_1K+_1M)+$g($1.b,_1K)))}$k[$j++]=$1.a};if(!bwipp_onecode.__11060__){(function(){var $ctx=Object.create($1);var _1V=new Map([[20,$a([0])],[25,$a([1])],[29,$a([1,0,0,0,0,1])],[31,$a([1,0,0,0,1,0,0,0,0,1])]]);$ctx.startvals=_1V;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_onecode.$ctx[id]=$ctx[id]);bwipp_onecode.__11060__=1})()}$k[$j++]="binval";$k[$j++]=$g($1.startvals,$1.barlen);$k[$j++]=Infinity;var _1c=$G($1.barcode,20,$1.barlen-20);for(var _1d=0,_1e=_1c.length;_1d<_1e;_1d++){$k[$j++]=$f($g(_1c,_1d)-48)}var _1g=$a();$k[$j++]=_1g;$1.bigadd();var _1h=$k[--$j];$1[$k[--$j]]=_1h;$k[$j++]=Infinity;$q($1.binval);$k[$j++]=$f($g($1.barcode,0)-48);$1.binval=$a();$k[$j++]=Infinity;var _1n=$1.binval;for(var _1o=0,_1p=_1n.length;_1o<_1p;_1o++){$k[$j++]=$g(_1n,_1o)*5}var _1r=$a();$k[$j++]="binval";$k[$j++]=_1r;$k[$j++]=$a([$f($g($1.barcode,1)-48)]);$1.bigadd();$k[$j++]=10;$1.normalize();var _1v=$k[--$j];$1[$k[--$j]]=_1v;$k[$j++]=Infinity;$q($1.binval);var _1z=$G($1.barcode,2,18);for(var _20=0,_21=_1z.length;_20<_21;_20++){$k[$j++]=$f($g(_1z,_20)-48)}$1.binval=$a();$1.bytes=$a(13);var _25=$1.binval;$1.bintmp=$A($a(_25.length),_25);for(var _28=12;_28>=0;_28-=1){$1.i=_28;for(var _2B=0,_2A=$1.bintmp.length-2;_2B<=_2A;_2B+=1){$1.j=_2B;var _2C=$1.bintmp;var _2D=$1.j;$p(_2C,_2D+1,$f($g(_2C,_2D+1)+$g($1.bintmp,$1.j)%256*10));$p($1.bintmp,$1.j,~~($g($1.bintmp,$1.j)/256))}$p($1.bytes,$1.i,$g($1.bintmp,$1.bintmp.length-1)%256);var _2S=$1.bintmp;var _2T=$1.bintmp;$p(_2S,_2T.length-1,~~($g(_2S,_2T.length-1)/256))}$1.fcs=2047;$1.dat=$g($1.bytes,0)<<5;for(var _2X=0,_2Y=6;_2X<_2Y;_2X++){if((($1.fcs^$1.dat)&1024)!=0){$1.fcs=$1.fcs<<1^3893}else{$1.fcs=$1.fcs<<1}$1.fcs=$1.fcs&2047;$1.dat=$1.dat<<1}for(var _2f=1;_2f<=12;_2f+=1){$1.dat=$g($1.bytes,_2f)<<3;for(var _2i=0,_2j=8;_2i<_2j;_2i++){if((($1.fcs^$1.dat)&1024)!=0){$1.fcs=$1.fcs<<1^3893}else{$1.fcs=$1.fcs<<1}$1.fcs=$1.fcs&2047;$1.dat=$1.dat<<1}}$1.codewords=$a(10);for(var _2r=9;_2r>=0;_2r-=1){$1.i=_2r;var _2t=$1.i==9?636:1365;$1.b=_2t;for(var _2w=0,_2v=$1.binval.length-2;_2w<=_2v;_2w+=1){$1.j=_2w;var _2x=$1.binval;var _2y=$1.j;$p(_2x,_2y+1,$f($g(_2x,_2y+1)+$g($1.binval,$1.j)%$1.b*10));$p($1.binval,$1.j,~~($g($1.binval,$1.j)/$1.b))}$p($1.codewords,$1.i,$g($1.binval,$1.binval.length-1)%$1.b);var _3G=$1.binval;var _3H=$1.binval;$p(_3G,_3H.length-1,~~($g(_3G,_3H.length-1)/$1.b))}$p($1.codewords,9,$g($1.codewords,9)*2);if(($1.fcs&1024)!=0){$p($1.codewords,0,$f($g($1.codewords,0)+659))}if(!bwipp_onecode.__11225__){(function(){var $ctx=Object.create($1);$ctx.tab513=$a([31,7936,47,7808,55,7552,59,7040,61,6016,62,3968,79,7744,87,7488,91,6976,93,5952,94,3904,103,7360,107,6848,109,5824,110,3776,115,6592,117,5568,118,3520,121,5056,122,3008,124,1984,143,7712,151,7456,155,6944,157,5920,158,3872,167,7328,171,6816,173,5792,174,3744,179,6560,181,5536,182,3488,185,5024,186,2976,188,1952,199,7264,203,6752,205,5728,206,3680,211,6496,213,5472,214,3424,217,4960,218,2912,220,1888,227,6368,229,5344,230,3296,233,4832,234,2784,236,1760,241,4576,242,2528,244,1504,248,992,271,7696,279,7440,283,6928,285,5904,286,3856,295,7312,299,6800,301,5776,302,3728,307,6544,309,5520,310,3472,313,5008,314,2960,316,1936,327,7248,331,6736,333,5712,334,3664,339,6480,341,5456,342,3408,345,4944,346,2896,348,1872,355,6352,357,5328,358,3280,361,4816,362,2768,364,1744,369,4560,370,2512,372,1488,376,976,391,7216,395,6704,397,5680,398,3632,403,6448,405,5424,406,3376,409,4912,410,2864,412,1840,419,6320,421,5296,422,3248,425,4784,426,2736,428,1712,433,4528,434,2480,436,1456,440,944,451,6256,453,5232,454,3184,457,4720,458,2672,460,1648,465,4464,466,2416,468,1392,472,880,481,4336,482,2288,484,1264,488,752,527,7688,535,7432,539,6920,541,5896,542,3848,551,7304,555,6792,557,5768,558,3720,563,6536,565,5512,566,3464,569,5e3,570,2952,572,1928,583,7240,587,6728,589,5704,590,3656,595,6472,597,5448,598,3400,601,4936,602,2888,604,1864,611,6344,613,5320,614,3272,617,4808,618,2760,620,1736,625,4552,626,2504,628,1480,632,968,647,7208,651,6696,653,5672,654,3624,659,6440,661,5416,662,3368,665,4904,666,2856,668,1832,675,6312,677,5288,678,3240,681,4776,682,2728,684,1704,689,4520,690,2472,692,1448,696,936,707,6248,709,5224,710,3176,713,4712,714,2664,716,1640,721,4456,722,2408,724,1384,728,872,737,4328,738,2280,740,1256,775,7192,779,6680,781,5656,782,3608,787,6424,789,5400,790,3352,793,4888,794,2840,796,1816,803,6296,805,5272,806,3224,809,4760,810,2712,812,1688,817,4504,818,2456,820,1432,824,920,835,6232,837,5208,838,3160,841,4696,842,2648,844,1624,849,4440,850,2392,852,1368,865,4312,866,2264,868,1240,899,6200,901,5176,902,3128,905,4664,906,2616,908,1592,913,4408,914,2360,916,1336,929,4280,930,2232,932,1208,961,4216,962,2168,964,1144,1039,7684,1047,7428,1051,6916,1053,5892,1054,3844,1063,7300,1067,6788,1069,5764,1070,3716,1075,6532,1077,5508,1078,3460,1081,4996,1082,2948,1084,1924,1095,7236,1099,6724,1101,5700,1102,3652,1107,6468,1109,5444,1110,3396,1113,4932,1114,2884,1116,1860,1123,6340,1125,5316,1126,3268,1129,4804,1130,2756,1132,1732,1137,4548,1138,2500,1140,1476,1159,7204,1163,6692,1165,5668,1166,3620,1171,6436,1173,5412,1174,3364,1177,4900,1178,2852,1180,1828,1187,6308,1189,5284,1190,3236,1193,4772,1194,2724,1196,1700,1201,4516,1202,2468,1204,1444,1219,6244,1221,5220,1222,3172,1225,4708,1226,2660,1228,1636,1233,4452,1234,2404,1236,1380,1249,4324,1250,2276,1287,7188,1291,6676,1293,5652,1294,3604,1299,6420,1301,5396,1302,3348,1305,4884,1306,2836,1308,1812,1315,6292,1317,5268,1318,3220,1321,4756,1322,2708,1324,1684,1329,4500,1330,2452,1332,1428,1347,6228,1349,5204,1350,3156,1353,4692,1354,2644,1356,1620,1361,4436,1362,2388,1377,4308,1378,2260,1411,6196,1413,5172,1414,3124,1417,4660,1418,2612,1420,1588,1425,4404,1426,2356,1441,4276,1442,2228,1473,4212,1474,2164,1543,7180,1547,6668,1549,5644,1550,3596,1555,6412,1557,5388,1558,3340,1561,4876,1562,2828,1564,1804,1571,6284,1573,5260,1574,3212,1577,4748,1578,2700,1580,1676,1585,4492,1586,2444,1603,6220,1605,5196,1606,3148,1609,4684,1610,2636,1617,4428,1618,2380,1633,4300,1634,2252,1667,6188,1669,5164,1670,3116,1673,4652,1674,2604,1681,4396,1682,2348,1697,4268,1698,2220,1729,4204,1730,2156,1795,6172,1797,5148,1798,3100,1801,4636,1802,2588,1809,4380,1810,2332,1825,4252,1826,2204,1857,4188,1858,2140,1921,4156,1922,2108,2063,7682,2071,7426,2075,6914,2077,5890,2078,3842,2087,7298,2091,6786,2093,5762,2094,3714,2099,6530,2101,5506,2102,3458,2105,4994,2106,2946,2119,7234,2123,6722,2125,5698,2126,3650,2131,6466,2133,5442,2134,3394,2137,4930,2138,2882,2147,6338,2149,5314,2150,3266,2153,4802,2154,2754,2161,4546,2162,2498,2183,7202,2187,6690,2189,5666,2190,3618,2195,6434,2197,5410,2198,3362,2201,4898,2202,2850,2211,6306,2213,5282,2214,3234,2217,4770,2218,2722,2225,4514,2226,2466,2243,6242,2245,5218,2246,3170,2249,4706,2250,2658,2257,4450,2258,2402,2273,4322,2311,7186,2315,6674,2317,5650,2318,3602,2323,6418,2325,5394,2326,3346,2329,4882,2330,2834,2339,6290,2341,5266,2342,3218,2345,4754,2346,2706,2353,4498,2354,2450,2371,6226,2373,5202,2374,3154,2377,4690,2378,2642,2385,4434,2401,4306,2435,6194,2437,5170,2438,3122,2441,4658,2442,2610,2449,4402,2465,4274,2497,4210,2567,7178,2571,6666,2573,5642,2574,3594,2579,6410,2581,5386,2582,3338,2585,4874,2586,2826,2595,6282,2597,5258,2598,3210,2601,4746,2602,2698,2609,4490,2627,6218,2629,5194,2630,3146,2633,4682,2641,4426,2657,4298,2691,6186,2693,5162,2694,3114,2697,4650,2705,4394,2721,4266,2753,4202,2819,6170,2821,5146,2822,3098,2825,4634,2833,4378,2849,4250,2881,4186,2945,4154,3079,7174,3083,6662,3085,5638,3086,3590,3091,6406,3093,5382,3094,3334,3097,4870,3107,6278,3109,5254,3110,3206,3113,4742,3121,4486,3139,6214,3141,5190,3145,4678,3153,4422,3169,4294,3203,6182,3205,5158,3209,4646,3217,4390,3233,4262,3265,4198,3331,6166,3333,5142,3337,4630,3345,4374,3361,4246,3393,4182,3457,4150,3587,6158,3589,5134,3593,4622,3601,4366,3617,4238,3649,4174,3713,4142,3841,4126,4111,7681,4119,7425,4123,6913,4125,5889,4135,7297,4139,6785,4141,5761,4147,6529,4149,5505,4153,4993,4167,7233,4171,6721,4173,5697,4179,6465,4181,5441,4185,4929,4195,6337,4197,5313,4201,4801,4209,4545,4231,7201,4235,6689,4237,5665,4243,6433,4245,5409,4249,4897,4259,6305,4261,5281,4265,4769,4273,4513,4291,6241,4293,5217,4297,4705,4305,4449,4359,7185,4363,6673,4365,5649,4371,6417,4373,5393,4377,4881,4387,6289,4389,5265,4393,4753,4401,4497,4419,6225,4421,5201,4425,4689,4483,6193,4485,5169,4489,4657,4615,7177,4619,6665,4621,5641,4627,6409,4629,5385,4633,4873,4643,6281,4645,5257,4649,4745,4675,6217,4677,5193,4739,6185,4741,5161,4867,6169,4869,5145,5127,7173,5131,6661,5133,5637,5139,6405,5141,5381,5155,6277,5157,5253,5187,6213,5251,6181,5379,6165,5635,6157,6151,7171,6155,6659,6163,6403,6179,6275,6211,5189,4681,4433,4321,3142,2634,2386,2274,1612,1364,1252,856,744,496]);$ctx.tab213=$a([3,6144,5,5120,6,3072,9,4608,10,2560,12,1536,17,4352,18,2304,20,1280,24,768,33,4224,34,2176,36,1152,40,640,48,384,65,4160,66,2112,68,1088,72,576,80,320,96,192,129,4128,130,2080,132,1056,136,544,144,288,257,4112,258,2064,260,1040,264,528,513,4104,514,2056,516,1032,1025,4100,1026,2052,2049,4098,4097,2050,1028,520,272,160]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_onecode.$ctx[id]=$ctx[id]);bwipp_onecode.__11225__=1})()}$1.chars=$a(10);for(var _3V=0;_3V<=9;_3V+=1){$1.i=_3V;var _3Y=$g($1.codewords,$1.i);$k[$j++]=_3Y;if(_3Y<=1286){var _3b=$g($1.tab513,$k[--$j]);$k[$j++]=_3b}else{var _3e=$g($1.tab213,$f($k[--$j]-1287));$k[$j++]=_3e}$p($1.chars,$1.i,$k[--$j])}for(var _3i=9;_3i>=0;_3i-=1){$1.i=_3i;if((~~Math.pow(2,$1.i)&$1.fcs)!=0){$p($1.chars,$1.i,$g($1.chars,$1.i)^8191)}}if(!bwipp_onecode.__11262__){(function(){var $ctx=Object.create($1);$ctx.barmap=$a([7,2,4,3,1,10,0,0,9,12,2,8,5,5,6,11,8,9,3,1,0,1,5,12,2,5,1,8,4,4,9,11,6,3,8,10,3,9,7,6,5,11,1,4,8,5,2,12,9,10,0,2,7,1,6,7,3,6,4,9,0,3,8,6,6,4,2,7,1,1,9,9,7,10,5,2,4,0,3,8,6,2,0,4,8,11,1,0,9,8,3,12,2,6,7,7,5,1,4,10,1,12,6,9,7,3,8,0,5,8,9,7,4,6,2,10,3,4,0,5,8,4,5,7,7,11,1,9,6,0,9,6,0,6,4,8,2,1,3,2,5,9,8,12,4,11,6,1,9,5,7,4,3,3,1,2,0,7,2,0,1,3,4,1,6,10,3,5,8,7,9,4,2,11,5,6,0,8,7,12,4,2,8,1,5,10,3,0,9,3,0,9,6,5,2,4,7,8,1,7,5,0,4,5,2,3,0,10,6,12,9,2,3,11,1,6,8,8,7,9,5,4,0,11,1,5,2,2,9,1,4,12,8,3,6,6,7,0,3,7,4,7,7,5,0,12,1,11,2,9,9,0,6,8,5,3,3,10,8,2]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_onecode.$ctx[id]=$ctx[id]);bwipp_onecode.__11262__=1})()}$1.bbs=$a(65);$1.bhs=$a(65);for(var _3u=0;_3u<=64;_3u+=1){$1.i=_3u;$1.dec=($g($1.chars,$g($1.barmap,$1.i*4))&~~Math.pow(2,$g($1.barmap,$1.i*4+1)))!=0;$1.asc=($g($1.chars,$g($1.barmap,$1.i*4+2))&~~Math.pow(2,$g($1.barmap,$1.i*4+3)))!=0;if(!$1.dec&&!$1.asc){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,2*$1.height/8)}if(!$1.dec&&$1.asc){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($1.dec&&!$1.asc){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($1.dec&&$1.asc){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,8*$1.height/8)}}$k[$j++]=Infinity;var _4h=$1.bbs;var _4i=$1.bhs;$k[$j++]=Infinity;for(var _4k=0,_4l=$1.bhs.length-1;_4k<_4l;_4k++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _4m=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bbs";$k[$j++]=_4h;$k[$j++]="bhs";$k[$j++]=_4i;$k[$j++]="sbs";$k[$j++]=_4m;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="textxalign";$k[$j++]="left";$k[$j++]="textfont";$k[$j++]="OCR-B";$k[$j++]="textyoffset";$k[$j++]=1;$k[$j++]="textxoffset";$k[$j++]=-.3;$k[$j++]="opt";$k[$j++]=$1.options;var _4p=$d();$k[$j++]=_4p;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_postnet(){var $1=Object.create(bwipp_postnet.$ctx||(bwipp_postnet.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.validatecheck=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.125;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _4=$k[--$j];$k[$j++]=$f(_4-1)}var _5=$k[--$j];$1[$k[--$j]]=_5;if($1.barlen!=5&&$1.barlen!=9&&$1.barlen!=11){$k[$j++]="bwipp.postnetBadLength#11357";$k[$j++]="USPS POSTNET must be 5, 9 or 11 digits excluding check digit";bwipp_raiseerror()}$F($1.barcode,function(){var _B=$k[--$j];if(_B<48||_B>57){$k[$j++]="bwipp.postnetBadCharacter#11361";$k[$j++]="USPS POSTNET must contain only digits";bwipp_raiseerror()}});if(!bwipp_postnet.__11375__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789";$ctx.encs=$a(["55222","22255","22525","22552","25225","25252","25522","52225","52252","52522","5","5"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_postnet.$ctx[id]=$ctx[id]);bwipp_postnet.__11375__=1})()}$1.checksum=0;for(var _G=0,_F=$f($1.barlen-1);_G<=_F;_G+=1){$1.i=_G;$1.checksum=$f($1.checksum+$f($g($1.barcode,$1.i)-48))}$1.checksum=$f(10-$1.checksum%10)%10;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.postnetBadCheckDigit#11385";$k[$j++]="Incorrect USPS POSTNET check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}$1.bhs=$a($f($1.barlen*5+7));$1.txt=$a($f($1.barlen+1));$1.enc=$g($1.encs,10);$1.heights=$a($1.enc.length);for(var _g=0,_f=$1.enc.length-1;_g<=_f;_g+=1){$1.j=_g;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,0,$1.heights);for(var _r=0,_q=$f($1.barlen-1);_r<=_q;_r+=1){$1.i=_r;$1.enc=$g($1.encs,$f($g($1.barcode,$1.i)-48));$1.heights=$a($1.enc.length);for(var _11=0,_10=$1.enc.length-1;_11<=_10;_11+=1){$1.j=_11;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,$1.i*5+1,$1.heights);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i*5+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$1.enc=$g($1.encs,$1.checksum);$1.heights=$a($1.enc.length);for(var _1S=0,_1R=$1.enc.length-1;_1S<=_1R;_1S+=1){$1.j=_1S;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,$f($1.barlen*5+1),$1.heights);if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum,1),$f($1.barlen*5+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a([" ",$f($1.barlen*5+1)*72/25,$1.textyoffset,$1.textfont,$1.textsize]))}$1.enc=$g($1.encs,11);$1.heights=$a($1.enc.length);for(var _20=0,_1z=$1.enc.length-1;_20<=_1z;_20+=1){$1.j=_20;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,$f($1.barlen*5+6),$1.heights);$k[$j++]=Infinity;var _2A=$1.bhs;$k[$j++]=Infinity;for(var _2C=0,_2D=$1.bhs.length;_2C<_2D;_2C++){$k[$j++]=0}var _2E=$a();$k[$j++]=Infinity;for(var _2G=0,_2H=$1.bhs.length-1;_2G<_2H;_2G++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _2I=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bhs";$k[$j++]=_2A;$k[$j++]="bbs";$k[$j++]=_2E;$k[$j++]="sbs";$k[$j++]=_2I;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2M=$d();$k[$j++]=_2M;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_planet(){var $1=Object.create(bwipp_planet.$ctx||(bwipp_planet.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.validatecheck=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.125;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _4=$k[--$j];$k[$j++]=$f(_4-1)}var _5=$k[--$j];$1[$k[--$j]]=_5;if($1.barlen!=11&&$1.barlen!=13){$k[$j++]="bwipp.planetBadLength#11505";$k[$j++]="USPS PLANET must be 11 or 13 digits excluding check digit";bwipp_raiseerror()}$F($1.barcode,function(){var _A=$k[--$j];if(_A<48||_A>57){$k[$j++]="bwipp.planetBadCharacter#11509";$k[$j++]="USPS PLANET must contain only digits";bwipp_raiseerror()}});if(!bwipp_planet.__11523__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789";$ctx.encs=$a(["22555","55522","55252","55225","52552","52525","52255","25552","25525","25255","5","5"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_planet.$ctx[id]=$ctx[id]);bwipp_planet.__11523__=1})()}$1.checksum=0;for(var _F=0,_E=$f($1.barlen-1);_F<=_E;_F+=1){$1.i=_F;$1.checksum=$f($1.checksum+$f($g($1.barcode,$1.i)-48))}$1.checksum=$f(10-$1.checksum%10)%10;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.planetBadCheckDigit#11534";$k[$j++]="Incorrect USPS PLANET check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}$1.bhs=$a($f($1.barlen*5+7));$1.txt=$a($f($1.barlen+1));$1.enc=$g($1.encs,10);$1.heights=$a($1.enc.length);for(var _f=0,_e=$1.enc.length-1;_f<=_e;_f+=1){$1.j=_f;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,0,$1.heights);for(var _q=0,_p=$f($1.barlen-1);_q<=_p;_q+=1){$1.i=_q;$1.enc=$g($1.encs,$f($g($1.barcode,$1.i)-48));$1.heights=$a($1.enc.length);for(var _10=0,_z=$1.enc.length-1;_10<=_z;_10+=1){$1.j=_10;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,$1.i*5+1,$1.heights);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i*5+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$1.enc=$g($1.encs,$1.checksum);$1.heights=$a($1.enc.length);for(var _1R=0,_1Q=$1.enc.length-1;_1R<=_1Q;_1R+=1){$1.j=_1R;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,$f($1.barlen*5+1),$1.heights);if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum,1),$f($1.barlen*5+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a([" ",$f($1.barlen*5+1)*72/25,$1.textyoffset,$1.textfont,$1.textsize]))}$1.enc=$g($1.encs,11);$1.heights=$a($1.enc.length);for(var _1z=0,_1y=$1.enc.length-1;_1z<=_1y;_1z+=1){$1.j=_1z;$p($1.heights,$1.j,$i($G($1.enc,$1.j,1))*$1.height/5)}$P($1.bhs,$f($1.barlen*5+6),$1.heights);$k[$j++]=Infinity;var _29=$1.bhs;$k[$j++]=Infinity;for(var _2B=0,_2C=$1.bhs.length;_2B<_2C;_2B++){$k[$j++]=0}var _2D=$a();$k[$j++]=Infinity;for(var _2F=0,_2G=$1.bhs.length-1;_2F<_2G;_2F++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _2H=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bhs";$k[$j++]=_29;$k[$j++]="bbs";$k[$j++]=_2D;$k[$j++]="sbs";$k[$j++]=_2H;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2L=$d();$k[$j++]=_2L;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_royalmail(){var $1=Object.create(bwipp_royalmail.$ctx||(bwipp_royalmail.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.validatecheck=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.175;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];var _1=$k[--$j];$1.barcode=_1;if(!bwipp_royalmail.__11666__){(function(){var $ctx=Object.create($1);$ctx.barchars="ZUVWXY501234B6789AHCDEFGNIJKLMTOPQRS";$ctx.charvals=new Map;for(var _2=0;_2<=35;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}$ctx.encs=$a(["3300","2211","2301","2310","3201","3210","1122","0033","0123","0132","1023","1032","1302","0213","0303","0312","1203","1212","1320","0231","0321","0330","1221","1230","3102","2013","2103","2112","3003","3012","3120","2031","2121","2130","3021","3030","2","3"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_royalmail.$ctx[id]=$ctx[id]);bwipp_royalmail.__11666__=1})()}for(var _A=0,_9=$1.barcode.length-1;_A<=_9;_A+=1){var _E=$g($1.charvals,$G($1.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.royalmailBadCharacter#11671";$k[$j++]="RM4SCC must contain only capital letters and digits";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _H=$k[--$j];$k[$j++]=$f(_H-1)}var _I=$k[--$j];$1[$k[--$j]]=_I;$1.checksumrow=0;$1.checksumcol=0;for(var _M=0,_L=$f($1.barlen-1);_M<=_L;_M+=1){$1.i=_M;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$1.checksumrow=$1.checksumrow+~~($1.indx/6);$1.checksumcol=$f($1.checksumcol+$1.indx%6)}$1.checksum=$f($1.checksumrow%6*6+$1.checksumcol%6);if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.royalmailBadCheckDigit#11688";$k[$j++]="Incorrect RM4SCC check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}$1.encstr=$s($f($1.barlen*4+6));$1.txt=$a($f($1.barlen+1));$P($1.encstr,0,$g($1.encs,36));for(var _r=0,_q=$f($1.barlen-1);_r<=_q;_r+=1){$1.i=_r;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$P($1.encstr,$1.i*4+1,$g($1.encs,$1.indx));$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.i*4+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.encstr,$f($1.barlen*4+1),$g($1.encs,$1.checksum));if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum,1),$f($1.barlen*4+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a([" ",$f($1.barlen*4+1)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.encstr,$f($1.barlen*4+5),$g($1.encs,37));$1.bbs=$a($1.encstr.length);$1.bhs=$a($1.encstr.length);for(var _1j=0,_1i=$1.encstr.length-1;_1j<=_1i;_1j+=1){$1.i=_1j;$1.enc=$G($1.encstr,$1.i,1);if($eq($1.enc,"0")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,2*$1.height/8)}if($eq($1.enc,"1")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"2")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"3")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,8*$1.height/8)}}$k[$j++]=Infinity;var _2F=$1.bbs;var _2G=$1.bhs;$k[$j++]=Infinity;for(var _2I=0,_2J=$1.bhs.length-1;_2I<_2J;_2I++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _2K=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bbs";$k[$j++]=_2F;$k[$j++]="bhs";$k[$j++]=_2G;$k[$j++]="sbs";$k[$j++]=_2K;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2O=$d();$k[$j++]=_2O;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_auspost(){var $1=Object.create(bwipp_auspost.$ctx||(bwipp_auspost.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.175;$1.custinfoenc="character";$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($1.custinfoenc,"character")&&$ne($1.custinfoenc,"numeric")){$k[$j++]="bwipp.auspostBadCustinfoEncoding#11801";$k[$j++]="Customer information encoding must be either character or numeric";bwipp_raiseerror()}if(!bwipp_auspost.__11827__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["000","001","002","010","011","012","020","021","022","100","101","102","110","111","112","120","121","122","200","201","202","210","211","212","220","221","222","300","301","302","310","311","312","320","321","322","023","030","031","032","033","103","113","123","130","131","132","133","203","213","223","230","231","232","233","303","313","323","330","331","332","333","003","013","00","01","02","10","11","12","20","21","22","30","13","3"]);$ctx.barchars="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz #";var _5=new Map([["11",37],["45",37],["59",52],["62",67]]);$ctx.fcclen=_5;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_auspost.$ctx[id]=$ctx[id]);bwipp_auspost.__11827__=1})()}$1.barlen=$1.barcode.length;$1.txt=$a($1.barlen-2);$k[$j++]=$1.fcclen;if($1.barlen>=2){$k[$j++]=$G($1.barcode,0,2)}else{$k[$j++]=""}var _E=$k[--$j];var _F=$k[--$j];var _G=$g(_F,_E)!==undefined;$k[$j++]=_F;$k[$j++]=_E;if(!_G){$j-=2;$k[$j++]="bwipp.auspostBadFCC#11834";$k[$j++]="Must begin with an FCC, either 11, 45, 59 or 62";bwipp_raiseerror()}var _H=$k[--$j];$1.encstr=$s($g($k[--$j],_H));$k[$j++]=true;for(var _L=0,_M=1;_L<_M;_L++){if($1.barlen<10){$j--;$k[$j++]=false;break}var _P=$G($1.barcode,2,8);for(var _Q=0,_R=_P.length;_Q<_R;_Q++){var _S=$g(_P,_Q);if(_S<48||_S>57){$j--;$k[$j++]=false;break}}}if($nt($k[--$j])){$k[$j++]="bwipp.auspostIncompleteDPID#11845";$k[$j++]="The DPID must be 8 digits";bwipp_raiseerror()}var _W=$eq($1.custinfoenc,"numeric")?2:3;if(($1.barlen-10)*_W>$1.encstr.length-22-14){$k[$j++]="bwipp.auspostTooLong#11851";$k[$j++]="The message is too long";bwipp_raiseerror()}$P($1.encstr,0,$g($1.encs,74));for(var _b=0;_b<=1;_b+=1){$1.i=_b;$P($1.encstr,$1.i*2+2,$g($1.encs,$i($G($1.barcode,$1.i,1))+64))}for(var _j=2;_j<=9;_j+=1){$1.i=_j;$P($1.encstr,$1.i*2+2,$g($1.encs,$i($G($1.barcode,$1.i,1))+64));$p($1.txt,$1.i-2,$a([$G($1.barcode,$1.i,1),(($1.i-2)*2+6)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}if($eq($1.custinfoenc,"numeric")){for(var _14=0,_13=$1.barlen-11;_14<=_13;_14+=1){$1.i=_14;var _18=$g($1.barcode,$1.i+10);$k[$j++]=$1.encs;$k[$j++]=_18;if(_18<48||_18>57){$k[$j++]="bwipp.auspostInvalidCustinfoDigit#11878";$k[$j++]="The customer information data contains a non-digit character";bwipp_raiseerror()}var _19=$k[--$j];$P($1.encstr,$1.i*2+22,$g($k[--$j],$f($f(_19-48)+64)));$p($1.txt,$1.i+8,$a([$G($1.barcode,$1.i+10,1),($1.i*2+22)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$1.ciflen=($1.barlen-10)*2}else{for(var _1R=0,_1Q=$1.barlen-11;_1R<=_1Q;_1R+=1){$1.i=_1R;$X($1.barchars,$G($1.barcode,$1.i+10,1));if($nt($k[--$j])){$j--;$k[$j++]="bwipp.auspostInvalidCustinfoCharacter#11890";$k[$j++]="The customer information contains an invalid character";bwipp_raiseerror()}$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.encstr,$1.i*3+22,$1.enc);$p($1.txt,$1.i+8,$a([$G($1.barcode,$1.i+10,1),($1.i*3+22)*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$1.ciflen=($1.barlen-10)*3}for(var _1s=22+$1.ciflen,_1r=$1.encstr.length-14;_1s<=_1r;_1s+=1){$P($1.encstr,_1s,$g($1.encs,75))}if(!bwipp_auspost.__11927__){(function(){var $ctx=Object.create($1);$ctx.rstable=$a(64*64);$k[$j++]=$ctx.rstable;$k[$j++]=0;$k[$j++]=Infinity;for(var _1y=0,_1z=64;_1y<_1z;_1y++){$k[$j++]=0}var _20=$a();var _21=$k[--$j];$P($k[--$j],_21,_20);$k[$j++]=$ctx.rstable;$k[$j++]=64;$k[$j++]=Infinity;for(var _24=0;_24<=63;_24+=1){$k[$j++]=_24}var _25=$a();var _26=$k[--$j];$P($k[--$j],_26,_25);$ctx.prev=1;for(var _28=0,_29=64;_28<_29;_28++){$ctx.next=$ctx.prev<<1;if(($ctx.next&64)!=0){$ctx.next=$ctx.next^67}for(var _2D=0;_2D<=63;_2D+=1){$ctx.j=_2D;$ctx.nextcell=function(){$k[$j++]=$ctx.rstable;$k[$j++]=64*$ctx.next+$ctx.j};$ctx.nextcell();var _2L=$k[--$j];$p($k[--$j],_2L,$g($ctx.rstable,64*$ctx.prev+$ctx.j)<<1);$ctx.nextcell();var _2N=$k[--$j];if(($g($k[--$j],_2N)&64)!=0){$ctx.nextcell();$ctx.nextcell();var _2Q=$k[--$j];var _2S=$g($k[--$j],_2Q);var _2T=$k[--$j];$p($k[--$j],_2T,_2S^67)}}$ctx.prev=$ctx.next}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_auspost.$ctx[id]=$ctx[id]);bwipp_auspost.__11927__=1})()}$1.rscodes=$a(~~(($1.encstr.length-16)/3)+4);$k[$j++]=$1.rscodes;$k[$j++]=0;$k[$j++]=Infinity;for(var _2a=0,_2b=4;_2a<_2b;_2a++){$k[$j++]=0}var _2c=$a();var _2d=$k[--$j];$P($k[--$j],_2d,_2c);for(var _2h=2,_2g=$1.encstr.length-16;_2h<=_2g;_2h+=3){$1.i=_2h;$p($1.rscodes,$1.rscodes.length-~~(($1.i-2)/3)-1,$i($G($1.encstr,$1.i,1))*16+$i($G($1.encstr,$1.i+1,1))*4+$i($G($1.encstr,$1.i+2,1)))}for(var _2v=$1.rscodes.length-5;_2v>=0;_2v-=1){$1.i=_2v;for(var _2w=0;_2w<=4;_2w+=1){$1.j=_2w;$p($1.rscodes,$1.i+$1.j,$xo($g($1.rscodes,$1.i+$1.j),$g($1.rstable,$f(64*$g($a([48,17,29,30,1]),$1.j)+$g($1.rscodes,$1.i+4)))))}}$1.checkcode=$Z($s(12),"000000000000");for(var _3E=0;_3E<=3;_3E+=1){$1.i=_3E;$1.enc=$R($s(3),$g($1.rscodes,3-$1.i),4);$P($1.checkcode,$1.i*3+(3-$1.enc.length),$1.enc)}$P($1.encstr,$1.encstr.length-14,$1.checkcode);$P($1.encstr,$1.encstr.length-2,$g($1.encs,74));$1.bbs=$a($1.encstr.length);$1.bhs=$a($1.encstr.length);for(var _3b=0,_3a=$1.encstr.length-1;_3b<=_3a;_3b+=1){$1.i=_3b;$1.enc=$G($1.encstr,$1.i,1);if($eq($1.enc,"0")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,8*$1.height/8)}if($eq($1.enc,"1")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"2")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"3")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,2*$1.height/8)}}$k[$j++]=Infinity;var _47=$1.bbs;var _48=$1.bhs;$k[$j++]=Infinity;for(var _4A=0,_4B=$1.bhs.length-1;_4A<_4B;_4A++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _4C=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bbs";$k[$j++]=_47;$k[$j++]="bhs";$k[$j++]=_48;$k[$j++]="sbs";$k[$j++]=_4C;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _4G=$d();$k[$j++]=_4G;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_kix(){var $1=Object.create(bwipp_kix.$ctx||(bwipp_kix.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.175;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];var _1=$k[--$j];$1.barcode=_1;if(!bwipp_kix.__12059__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["0033","0123","0132","1023","1032","1122","0213","0303","0312","1203","1212","1302","0231","0321","0330","1221","1230","1320","2013","2103","2112","3003","3012","3102","2031","2121","2130","3021","3030","3120","2211","2301","2310","3201","3210","3300"]);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";$ctx.charvals=new Map;for(var _3=0;_3<=35;_3+=1){$p($ctx.charvals,$G($ctx.barchars,_3,1),_3)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_kix.$ctx[id]=$ctx[id]);bwipp_kix.__12059__=1})()}for(var _A=0,_9=$1.barcode.length-1;_A<=_9;_A+=1){var _E=$g($1.charvals,$G($1.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.kixBadCharacter#12064";$k[$j++]="KIX must contain only capital letters and digits";bwipp_raiseerror()}}$1.barlen=$1.barcode.length;$1.encstr=$s($1.barlen*4);$1.txt=$a($1.barlen);for(var _M=0,_L=$1.barlen-1;_M<=_L;_M+=1){$1.i=_M;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$P($1.encstr,$1.i*4,$g($1.encs,$1.indx));$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*4*3.312,$1.textyoffset,$1.textfont,$1.textsize]))}$1.bbs=$a($1.encstr.length);$1.bhs=$a($1.encstr.length);for(var _n=0,_m=$1.encstr.length-1;_n<=_m;_n+=1){$1.i=_n;$1.enc=$G($1.encstr,$1.i,1);if($eq($1.enc,"0")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,2*$1.height/8)}if($eq($1.enc,"1")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"2")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"3")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,8*$1.height/8)}}$k[$j++]=Infinity;var _1J=$1.bbs;var _1K=$1.bhs;$k[$j++]=Infinity;for(var _1M=0,_1N=$1.bhs.length-1;_1M<_1N;_1M++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _1O=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bbs";$k[$j++]=_1J;$k[$j++]="bhs";$k[$j++]=_1K;$k[$j++]="sbs";$k[$j++]=_1O;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _1S=$d();$k[$j++]=_1S;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_japanpost(){var $1=Object.create(bwipp_japanpost.$ctx||(bwipp_japanpost.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.includecheckintext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.175;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$F($1.barcode,function(){var _3=$k[--$j];if(!(_3>=48&&_3<=57||(_3>=65&&_3<=90||_3==45))){$k[$j++]="bwipp.japanPostBadCharacter#12169";$k[$j++]="Japan Post must contain only digits, capital letters and the dash symbol";if("raiseerror"()===true){return true}}});if(!bwipp_japanpost.__12183__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["300","330","312","132","321","303","123","231","213","033","030","120","102","210","012","201","021","003","333","31","13"]);$ctx.barchars="0123456789-ABCDEFGHIJKLMNOPQRSTUVWXYZ";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_japanpost.$ctx[id]=$ctx[id]);bwipp_japanpost.__12183__=1})()}$1.barlen=$1.barcode.length;$1.encstr=$s((20+1)*3+4);$1.digits=$a(20);$1.txt=$a($1.barlen+1);$P($1.encstr,0,$g($1.encs,19));$1.checksum=0;$1.j=0;$1.i=0;$k[$j++]=true;for(var _G=0,_F=$1.barlen-1;_G<=_F;_G+=1){$1.i=_G;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;if($1.indx>=11&&$1.indx<37){if($1.j>18){$j--;$k[$j++]=false;break}$1.digit=~~(($1.indx-1)/10)+10;$P($1.encstr,$1.j*3+2,$g($1.encs,$1.digit));$1.checksum=$1.checksum+$1.digit;$p($1.digits,$1.j,$1.digit);$1.j=$1.j+1}if($1.j>19){$j--;$k[$j++]=false;break}$1.digit=0;if($1.indx==37){$1.digit=14}if($1.indx>=11&&$1.indx<37){$1.digit=($1.indx-1)%10}if($1.indx<11){$1.digit=$1.indx}$P($1.encstr,$1.j*3+2,$g($1.encs,$1.digit));$1.checksum=$1.checksum+$1.digit;$p($1.digits,$1.j,$1.digit);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),($1.j*3+2)*3.312,$1.textyoffset,$1.textfont,$1.textsize]));$1.j=$1.j+1}if($nt($k[--$j])){$k[$j++]="bwipp.japanpostTooLong#12233";$k[$j++]="The input is too long";bwipp_raiseerror()}for(var _16=$1.j,_15=20-1;_16<=_15;_16+=1){$1.k=_16;$P($1.encstr,$1.k*3+2,$g($1.encs,14));$1.checksum=$1.checksum+14;$p($1.digits,$1.k,14)}$1.checksum=19-$1.checksum%19;$P($1.encstr,2+20*3,$g($1.encs,$1.checksum));$P($1.encstr,2+21*3,$g($1.encs,20));$1.checkdigit=" ";if($1.includecheckintext){$1.checkdigit=$G($1.barchars,$1.checksum,1)}$p($1.txt,$1.i+1,$a([$1.checkdigit,(20*3+2)*3.312,$1.textyoffset,$1.textfont,$1.textsize]));$P($1.encstr,(20+1)*3+2,$g($1.encs,20));$1.bbs=$a(21*3+4);$1.bhs=$a($1.bbs.length);for(var _1f=0,_1e=$1.bbs.length-1;_1f<=_1e;_1f+=1){$1.i=_1f;$1.enc=$G($1.encstr,$1.i,1);$1.bunit=0;$1.hunit=0;if($eq($1.enc,"0")){$1.bunit=3;$1.hunit=2}if($eq($1.enc,"1")){$1.bunit=0;$1.hunit=5}if($eq($1.enc,"2")){$1.bunit=3;$1.hunit=5}if($eq($1.enc,"3")){$1.bunit=0;$1.hunit=8}$p($1.bbs,$1.i,$1.bunit*$1.height/8);$p($1.bhs,$1.i,$1.hunit*$1.height/8)}$k[$j++]=Infinity;var _1v=$1.bbs;var _1w=$1.bhs;$k[$j++]=Infinity;for(var _1y=0,_1z=$1.bhs.length-1;_1y<_1z;_1y++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _20=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bbs";$k[$j++]=_1v;$k[$j++]="bhs";$k[$j++]=_1w;$k[$j++]="sbs";$k[$j++]=_20;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _24=$d();$k[$j++]=_24;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_msi(){var $1=Object.create(bwipp_msi.$ctx||(bwipp_msi.$ctx={}));$1.dontdraw=false;$1.includecheck=false;$1.includetext=false;$1.includecheckintext=false;$1.checktype="unset";$1.badmod11=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($1.checktype,"unset")&&!$1.includecheck){$k[$j++]="bwipp.msiCheckTypeWithoutCheck#12350";$k[$j++]="checktype requires includecheck";bwipp_raiseerror()}if($1.badmod11&&($ne($1.checktype,"mod11")&&$ne($1.checktype,"ncrmod11")&&$ne($1.checktype,"mod1110")&&$ne($1.checktype,"ncrmod1110"))){$k[$j++]="bwipp.msiBadMod11Mismatch#12354";$k[$j++]="badmod11 requires checktype with mod11";bwipp_raiseerror()}if($eq($1.checktype,"unset")){$1.checktype="mod10"}$F($1.barcode,function(){var _B=$k[--$j];if(_B<48||_B>57){$k[$j++]="bwipp.msiBadCharacter#12364";$k[$j++]="MSI must contain only digits";bwipp_raiseerror()}});if(!bwipp_msi.__12378__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["12121212","12121221","12122112","12122121","12211212","12211221","12212112","12212121","21121212","21121221","21","121"]);$ctx.barchars="0123456789";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_msi.$ctx[id]=$ctx[id]);bwipp_msi.__12378__=1})()}$1.barlen=$1.barcode.length;$1.txtlen=$1.barlen;$1.mod10=function(){$1.code=$k[--$j];$k[$j++]=0;$k[$j++]=0;$F($1.code,function(){var _I=$k[--$j];var _J=$k[--$j];var _K=$k[--$j];$k[$j++]=$f($f(_I-48)+_J*10);$k[$j++]=_K});$j--;var _L=$k[--$j];$k[$j++]=_L*2;$k[$j++]=0;for(;;){var _M=$k[--$j];var _N=$k[--$j];var _O=~~(_N/10);$k[$j++]=$f(_M+_N%10);$k[$j++]=_O;if(_O==0){$j--;break}var _P=$k[--$j];var _Q=$k[--$j];$k[$j++]=_P;$k[$j++]=_Q}$k[$j++]=0;$k[$j++]=0;$F($1.code,function(){var _S=$k[--$j];var _T=$k[--$j];var _U=$k[--$j];$k[$j++]=$f(_T+$f(_S-48));$k[$j++]=_U});var _V=$k[--$j];var _W=$k[--$j];$k[$j++]=_V;$k[$j++]=_W;$j--;var _X=$k[--$j];var _a=$s($1.code.length+1);$P(_a,0,$1.code);$p(_a,$1.code.length,$f($f(10-$f($k[--$j]+_X)%10)%10+48));$k[$j++]=_a};$1.mod11=function(){$1.code=$k[--$j];$k[$j++]=$1.code.length-1;$F($1.code,function(){var _g=$k[--$j];var _h=$k[--$j];$k[$j++]=$f(_g-48);$k[$j++]=$f(_h%6+2);$k[$j++]=$f(_h-1)});$j--;$k[$j++]=0;for(var _j=0,_k=$1.code.length;_j<_k;_j++){var _l=$k[--$j];var _m=$k[--$j];var _n=$k[--$j];$k[$j++]=$f(_l+_n*_m)}var _p=$f(11-$k[--$j]%11)%11;$k[$j++]=_p;if(_p==10){if($1.badmod11){$j--;var _s=$s($1.code.length+2);$P(_s,0,$1.code);$P(_s,$1.code.length,"10");$k[$j++]=_s}else{$j--;$k[$j++]="bwipp.msiBadMod11NotSpecified#12401";$k[$j++]="mod11 check digit is 10 but badmod11 not specified";bwipp_raiseerror()}}else{var _w=$s($1.code.length+1);$P(_w,0,$1.code);$p(_w,$1.code.length,$f($k[--$j]+48));$k[$j++]=_w}};$1.ncrmod11=function(){$1.code=$k[--$j];$k[$j++]=$1.code.length-1;$F($1.code,function(){var _13=$k[--$j];var _14=$k[--$j];$k[$j++]=$f(_13-48);$k[$j++]=$f(_14%8+2);$k[$j++]=$f(_14-1)});$j--;$k[$j++]=0;for(var _16=0,_17=$1.code.length;_16<_17;_16++){var _18=$k[--$j];var _19=$k[--$j];var _1A=$k[--$j];$k[$j++]=$f(_18+_1A*_19)}var _1C=$f(11-$k[--$j]%11)%11;$k[$j++]=_1C;if(_1C==10){if($1.badmod11){$j--;var _1F=$s($1.code.length+2);$P(_1F,0,$1.code);$P(_1F,$1.code.length,"10");$k[$j++]=_1F}else{$j--;$k[$j++]="bwipp.msiBadMod11NotSpecified#12417";$k[$j++]="mod11 check digit is 10 but badmod11 not specified";bwipp_raiseerror()}}else{var _1J=$s($1.code.length+1);$P(_1J,0,$1.code);$p(_1J,$1.code.length,$f($k[--$j]+48));$k[$j++]=_1J}};if(!bwipp_msi.__12433__){(function(){var $ctx=Object.create($1);var _1N=new Map([["mod10",function(){$ctx.mod10()}],["mod1010",function(){$ctx.mod10();$ctx.mod10()}],["mod11",function(){$ctx.mod11()}],["ncrmod11",function(){$ctx.ncrmod11()}],["mod1110",function(){$ctx.mod11();$ctx.mod10()}],["ncrmod1110",function(){$ctx.ncrmod11();$ctx.mod10()}]]);$ctx.checkfunc=_1N;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_msi.$ctx[id]=$ctx[id]);bwipp_msi.__12433__=1})()}if($1.includecheck){var _1Q=$1.checkfunc;var _1R=$1.checktype;var _1S=$g(_1Q,_1R)!==undefined;$k[$j++]=_1Q;$k[$j++]=_1R;if(!_1S){$j-=2;$k[$j++]="bwipp.msiBadCharacter#12438";$k[$j++]="MSI checktype must be mod10, mod1010, mod11, ncrmod11, mod1110 or ncrmod1110";bwipp_raiseerror()}var _1T=$k[--$j];var _1V=$g($k[--$j],_1T);$k[$j++]=$1.barcode;if(_1V()===true){return true}$1.barcode=$k[--$j];$1.barlen=$1.barcode.length;if($1.includecheckintext){$1.txtlen=$1.barlen}}$1.sbs=$s($1.barlen*8+5);$1.txt=$a($1.barlen);$P($1.sbs,0,$g($1.encs,10));for(var _1k=0,_1j=$1.barlen-1;_1k<=_1j;_1k+=1){$1.i=_1k;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*8+2,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*12+3,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,$1.barlen*8+2,$g($1.encs,11));$k[$j++]=Infinity;$k[$j++]=Infinity;var _2A=$1.sbs;for(var _2B=0,_2C=_2A.length;_2B<_2C;_2B++){$k[$j++]=$g(_2A,_2B)-48}var _2E=$a();$k[$j++]=Infinity;for(var _2G=0,_2H=~~(($1.sbs.length+1)/2);_2G<_2H;_2G++){$k[$j++]=$1.height}var _2J=$a();$k[$j++]=Infinity;for(var _2L=0,_2M=~~(($1.sbs.length+1)/2);_2L<_2M;_2L++){$k[$j++]=0}var _2N=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_2E;$k[$j++]="bhs";$k[$j++]=_2J;$k[$j++]="bbs";$k[$j++]=_2N;if($1.includetext){$k[$j++]="txt";$k[$j++]=$G($1.txt,0,$1.txtlen)}$k[$j++]="opt";$k[$j++]=$1.options;var _2T=$d();$k[$j++]=_2T;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_plessey(){var $1=Object.create(bwipp_plessey.$ctx||(bwipp_plessey.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.validatecheck=false;$1.includecheckintext=false;$1.unidirectional=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];var _1=$k[--$j];$1.barcode=_1;if(!bwipp_plessey.__12544__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEF";$ctx.charvals=new Map;for(var _2=0;_2<=15;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}$ctx.encs=$a(["14141414","32141414","14321414","32321414","14143214","32143214","14323214","32323214","14141432","32141432","14321432","32321432","14143232","32143232","14323232","32323232","32321432","541412323","323"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_plessey.$ctx[id]=$ctx[id]);bwipp_plessey.__12544__=1})()}for(var _A=0,_9=$1.barcode.length-1;_A<=_9;_A+=1){var _E=$g($1.charvals,$G($1.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.plesseyBadCharacter#12549";$k[$j++]="Plessey must contain only digits and letters A B C D E F";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _H=$k[--$j];$k[$j++]=$f(_H-2)}var _I=$k[--$j];$1[$k[--$j]]=_I;$1.checkbits=$a($f($1.barlen*4+8));$P($1.checkbits,$1.barlen*4,$a([0,0,0,0,0,0,0,0]));for(var _R=0,_Q=$f($1.barlen-1);_R<=_Q;_R+=1){$1.i=_R;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$P($1.checkbits,$1.i*4,$a([$1.indx&1,$1.indx>>>1&1,$1.indx>>>2&1,$1.indx>>>3]))}$1.checksalt=$a([1,1,1,1,0,1,0,0,1]);for(var _h=0,_g=$f($1.barlen*4-1);_h<=_g;_h+=1){$1.i=_h;if($g($1.checkbits,$1.i)==1){for(var _l=0;_l<=8;_l+=1){$1.j=_l;$p($1.checkbits,$1.i+$1.j,$xo($g($1.checkbits,$1.i+$1.j),$g($1.checksalt,$1.j)))}}}$1.checkval=0;for(var _w=0;_w<=7;_w+=1){$1.i=_w;$1.checkval=$f($1.checkval+~~Math.pow(2,$1.i)*$g($1.checkbits,$f($1.barlen*4+$1.i)))}$1.checksum1=$1.checkval&15;$1.checksum2=$1.checkval>>>4;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum1)||$g($1.barcode,$f($1.barlen+1))!=$g($1.barchars,$1.checksum2)){$k[$j++]="bwipp.plesseyBadCheckDigits#12588";$k[$j++]="Incorrect Plessey check digits provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _1N=$1.unidirectional?27:33;$1.sbs=$s($f($1.barlen*8+_1N));$1.txt=$a($f($1.barlen+2));$P($1.sbs,0,$g($1.encs,16));for(var _1W=0,_1V=$f($1.barlen-1);_1W<=_1V;_1W+=1){$1.i=_1W;$1.indx=$g($1.charvals,$G($1.barcode,$1.i,1));$P($1.sbs,$1.i*8+8,$g($1.encs,$1.indx));$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*20+20,$1.textyoffset,$1.textfont,$1.textsize]))}$P($1.sbs,$f($1.barlen*8+8),$g($1.encs,$1.checksum1));$P($1.sbs,$f($1.barlen*8+16),$g($1.encs,$1.checksum2));if($1.includecheckintext){$p($1.txt,$1.barlen,$a([$G($1.barchars,$1.checksum1,1),$f($1.barlen*20+20),$1.textyoffset,$1.textfont,$1.textsize]));$p($1.txt,$f($1.barlen+1),$a([$G($1.barchars,$1.checksum2,1),$f($f($1.barlen+1)*20+20),$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.barlen,$a([" ",$f($1.barlen*20+20),$1.textyoffset,$1.textfont,$1.textsize]));$p($1.txt,$f($1.barlen+1),$a([" ",$f($f($1.barlen+1)*20+20),$1.textyoffset,$1.textfont,$1.textsize]))}var _2e=$1.unidirectional?18:17;$P($1.sbs,$f($1.barlen*8+24),$g($1.encs,_2e));$k[$j++]=Infinity;$k[$j++]=Infinity;var _2g=$1.sbs;for(var _2h=0,_2i=_2g.length;_2h<_2i;_2h++){$k[$j++]=$g(_2g,_2h)-48}var _2k=$a();$k[$j++]=Infinity;for(var _2m=0,_2n=~~(($1.sbs.length+1)/2);_2m<_2n;_2m++){$k[$j++]=$1.height}var _2p=$a();$k[$j++]=Infinity;for(var _2r=0,_2s=~~(($1.sbs.length+1)/2);_2r<_2s;_2r++){$k[$j++]=0}var _2t=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_2k;$k[$j++]="bhs";$k[$j++]=_2p;$k[$j++]="bbs";$k[$j++]=_2t;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2x=$d();$k[$j++]=_2x;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_telepen(){var $1=Object.create(bwipp_telepen.$ctx||(bwipp_telepen.$ctx={}));$1.numeric=false;$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=1;$1.parse=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];$1[$k[--$j]]=_6;$1.barlen=$1.barcode.length;delete $1.options["parse"];if($1.numeric&&$1.barlen%2!=0){$k[$j++]="bwipp.telepenNumericOddLength#12695";$k[$j++]="Telepen Numeric must have an even length";bwipp_raiseerror()}if(!bwipp_telepen.__12734__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["31313131","1131313111","33313111","1111313131","3111313111","11333131","13133131","111111313111","31333111","1131113131","33113131","1111333111","3111113131","1113133111","1311133111","111111113131","3131113111","11313331","333331","111131113111","31113331","1133113111","1313113111","1111113331","31131331","113111113111","3311113111","1111131331","311111113111","1113111331","1311111331","11111111113111","31313311","1131311131","33311131","1111313311","3111311131","11333311","13133311","111111311131","31331131","1131113311","33113311","1111331131","3111113311","1113131131","1311131131","111111113311","3131111131","1131131311","33131311","111131111131","3111131311","1133111131","1313111131","111111131311","3113111311","113111111131","3311111131","111113111311","311111111131","111311111311","131111111311","11111111111131","3131311111","11313133","333133","111131311111","31113133","1133311111","1313311111","1111113133","313333","113111311111","3311311111","11113333","311111311111","11131333","13111333","11111111311111","31311133","1131331111","33331111","1111311133","3111331111","11331133","13131133","111111331111","3113131111","1131111133","33111133","111113131111","3111111133","111311131111","131111131111","111111111133","31311313","113131111111","3331111111","1111311313","311131111111","11331313","13131313","11111131111111","3133111111","1131111313","33111313","111133111111","3111111313","111313111111","131113111111","111111111313","313111111111","1131131113","33131113","11113111111111","3111131113","113311111111","131311111111","111111131113","3113111113","11311111111111","331111111111","111113111113","31111111111111","111311111113","131111111113","1111111111111111"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_telepen.$ctx[id]=$ctx[id]);bwipp_telepen.__12734__=1})()}$1.sbs=$s($1.barlen*16+48);$1.txt=$a($1.barlen);$1.enc=$g($1.encs,95);$P($1.sbs,0,$1.enc);$1.l=$1.enc.length;$1.checksum=0;$1.i=0;$1.j=0;for(;;){if($1.i==$1.barlen){break}if($1.numeric){if($g($1.barcode,$1.i)>16){$1.np=$G($1.barcode,$1.i,2);var _X=$g($1.np,0);var _Z=$g($1.np,1);if(_X<48||_X>57||(_Z<48||_Z>57)&&!(_Z==88)){$k[$j++]=-1}else{var _e=$f($g($1.np,1)-48);$k[$j++]=$f($g($1.np,0)-48);$k[$j++]=_e;if(_e!=40){var _f=$k[--$j];var _g=$k[--$j];$k[$j++]=$f($f(_f+_g*10)+10)}else{$j--}var _h=$k[--$j];$k[$j++]=$f(_h+17)}var _i=$k[--$j];$k[$j++]=_i;if(_i==-1){$k[$j++]="bwipp.telepenInvalidNumericCharacter#12761";$k[$j++]="Telepen Numeric may contain only digits, or X in even positions";bwipp_raiseerror()}$1.indx=$k[--$j];$p($1.txt,$1.j,$a([$1.np,$1.j*16+16,$1.textyoffset,$1.textfont,$1.textsize]));$1.i=$1.i+2}else{$1.indx=$g($1.barcode,$1.i);$p($1.txt,$1.j,$a([" ",$1.j*16+16,$1.textyoffset,$1.textfont,$1.textsize]));$1.i=$1.i+1}}else{$1.indx=$g($1.barcode,$1.i);if($1.indx>127){$k[$j++]="bwipp.telepenInvalidAlphaCharacter#12774";$k[$j++]="Telepen Alpha characters must have ordinal values 0 to 127";bwipp_raiseerror()}if($1.indx>=32&&$1.indx<=126){$p($1.txt,$1.j,$a([$G($1.barcode,$1.i,1),$1.j*16+16,$1.textyoffset,$1.textfont,$1.textsize]))}else{$p($1.txt,$1.j,$a([" ",$1.j*16+16,$1.textyoffset,$1.textfont,$1.textsize]))}$1.i=$1.i+1}$1.checksum=$f($1.checksum+$1.indx);$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.l,$1.enc);$1.l=$1.l+$1.enc.length;$1.j=$1.j+1}$1.checksum=$f(127-$1.checksum%127)%127;$1.enc=$g($1.encs,$1.checksum);$P($1.sbs,$1.l,$1.enc);$1.l=$1.l+$1.enc.length;$1.enc=$g($1.encs,122);$P($1.sbs,$1.l,$1.enc);$1.l=$1.l+$1.enc.length;$1.sbs=$G($1.sbs,0,$1.l);$1.txt=$G($1.txt,0,$1.j);$k[$j++]=Infinity;$k[$j++]=Infinity;var _1z=$1.sbs;for(var _20=0,_21=_1z.length;_20<_21;_20++){$k[$j++]=$f($g(_1z,_20)-48)}var _23=$a();$k[$j++]=Infinity;for(var _25=0,_26=~~(($1.sbs.length+1)/2);_25<_26;_25++){$k[$j++]=$1.height}var _28=$a();$k[$j++]=Infinity;for(var _2A=0,_2B=~~(($1.sbs.length+1)/2);_2A<_2B;_2A++){$k[$j++]=0}var _2C=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_23;$k[$j++]="bhs";$k[$j++]=_28;$k[$j++]="bbs";$k[$j++]=_2C;if($1.includetext){$k[$j++]="txt";$k[$j++]=$1.txt}$k[$j++]="opt";$k[$j++]=$1.options;var _2G=$d();$k[$j++]=_2G;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_telepennumeric(){var $1=Object.create(bwipp_telepennumeric.$ctx||(bwipp_telepennumeric.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"numeric",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_telepen();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_posicode(){var $1=Object.create(bwipp_posicode.$ctx||(bwipp_posicode.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=-8;$1.height=1;$1.encoding="auto";$1.version="a";$1.checkoffset=0;$1.raw=false;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];var _1=$k[--$j];$1.barcode=_1;if(!bwipp_posicode.__12963__){(function(){var $ctx=Object.create($1);$ctx.la0=-1;$ctx.la1=-2;$ctx.la2=-3;$ctx.sf0=-4;$ctx.sf1=-5;$ctx.sf2=-6;$ctx.fn1=-7;$ctx.fn2=-8;$ctx.fn3=-9;$ctx.fn4=-10;$ctx.charmapsnormal=$a([$a(["0","^","'"]),$a(["1",";",27]),$a(["2","<",28]),$a(["3","=",29]),$a(["4",">",30]),$a(["5","?",31]),$a(["6","@","!"]),$a(["7","[",'"']),$a(["8",92,"#"]),$a(["9","]","&"]),$a(["A","a",1]),$a(["B","b",2]),$a(["C","c",3]),$a(["D","d",4]),$a(["E","e",5]),$a(["F","f",6]),$a(["G","g",7]),$a(["H","h",8]),$a(["I","i",9]),$a(["J","j",10]),$a(["K","k",11]),$a(["L","l",12]),$a(["M","m",13]),$a(["N","n",14]),$a(["O","o",15]),$a(["P","p",16]),$a(["Q","q",17]),$a(["R","r",18]),$a(["S","s",19]),$a(["T","t",20]),$a(["U","u",21]),$a(["V","v",22]),$a(["W","w",23]),$a(["X","x",24]),$a(["Y","y",25]),$a(["Z","z",26]),$a(["-","_",40]),$a([".","`",41]),$a([" ",127,0]),$a(["$","{","*"]),$a(["/","|",","]),$a(["+","}",":"]),$a(["%","~",$ctx.fn1]),$a([$ctx.la1,$ctx.la0,$ctx.fn2]),$a([$ctx.sf1,$ctx.sf0,$ctx.fn3]),$a([$ctx.sf2,$ctx.sf2,$ctx.fn4])]);var _12=$a(["5",-98,-98]);$ctx.chapmapslimited=$a([$a(["0",-98,-98]),$a(["1",-98,-98]),$a(["2",-98,-98]),$a(["3",-98,-98]),$a(["4",-98,-98]),_12,$a(["6",-98,-98]),$a(["7",-98,-98]),$a(["8",-98,-98]),$a(["9",-98,-98]),$a(["A",-98,-98]),$a(["B",-98,-98]),$a(["C",-98,-98]),$a(["D",-98,-98]),$a(["E",-98,-98]),$a(["F",-98,-98]),$a(["G",-98,-98]),$a(["H",-98,-98]),$a(["I",-98,-98]),$a(["J",-98,-98]),$a(["K",-98,-98]),$a(["L",-98,-98]),$a(["M",-98,-98]),$a(["N",-98,-98]),$a(["O",-98,-98]),$a(["P",-98,-98]),$a(["Q",-98,-98]),$a(["R",-98,-98]),$a(["S",-98,-98]),$a(["T",-98,-98]),$a(["U",-98,-98]),$a(["V",-98,-98]),$a(["W",-98,-98]),$a(["X",-98,-98]),$a(["Y",-98,-98]),$a(["Z",-98,-98]),$a(["-",-98,-98]),$a([".",-98,-98])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_posicode.$ctx[id]=$ctx[id]);bwipp_posicode.__12963__=1})()}$k[$j++]="charmaps";if($eq($1.version,"a")||$eq($1.version,"b")){$k[$j++]=$1.charmapsnormal}else{$k[$j++]=$1.chapmapslimited}var _1f=$k[--$j];$1[$k[--$j]]=_1f;var _1h=$1.charmaps;var _1i=$1.charmaps;var _1j=$1.charmaps;$1.charvals=$a([new Map,new Map,new Map]);for(var _1n=0,_1m=$1.charmaps.length-1;_1n<=_1m;_1n+=1){$1.i=_1n;$1.encs=$g($1.charmaps,$1.i);for(var _1r=0;_1r<=2;_1r+=1){$1.j=_1r;var _1u=$g($1.encs,$1.j);$k[$j++]=_1u;if($eq($t(_1u),"stringtype")){var _1x=$g($k[--$j],0);$k[$j++]=_1x}$p($g($1.charvals,$1.j),$k[--$j],$1.i)}}$1.set0=$g($1.charvals,0);$1.set1=$g($1.charvals,1);$1.set2=$g($1.charvals,2);if($1.raw){$1.encoding="raw"}if($eq($1.encoding,"raw")){$1.cws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i==$1.barcode.length){break}$1.cw=$i($G($1.barcode,$1.i+1,3));$p($1.cws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}$1.cws=$G($1.cws,0,$1.j);$1.text=""}if($eq($1.encoding,"auto")){var _2W=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["FNC1",$1.fn1],["FNC2",$1.fn2],["FNC3",$1.fn3]]);$1.fncvals=_2W;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _2Z=$k[--$j];$1[$k[--$j]]=_2Z;$1.msglen=$1.msg.length;$1.text=$s($1.msglen);for(var _2g=0,_2f=$1.msglen-1;_2g<=_2f;_2g+=1){$1.i=_2g;var _2l=$g($1.msg,$1.i);$k[$j++]=$1.text;$k[$j++]=$1.i;$k[$j++]=_2l;if(_2l<0){$j--;$k[$j++]=32}var _2m=$k[--$j];var _2n=$k[--$j];$p($k[--$j],_2n,_2m)}$k[$j++]=Infinity;for(var _2q=0,_2r=$1.msglen;_2q<_2r;_2q++){$k[$j++]=0}$k[$j++]=0;$1.numSA=$a();$k[$j++]=Infinity;for(var _2u=0,_2v=$1.msglen;_2u<_2v;_2u++){$k[$j++]=0}$k[$j++]=0;$1.numEA=$a();for(var _2y=$1.msglen-1;_2y>=0;_2y-=1){$1.i=_2y;if($g($1.msg,$1.i)>=0){if($g($1.msg,$1.i)>=128){$p($1.numEA,$1.i,$f($g($1.numEA,$1.i+1)+1))}else{$p($1.numSA,$1.i,$f($g($1.numSA,$1.i+1)+1))}}}$1.ea=false;$1.msgtmp=$a([]);for(var _3I=0,_3H=$1.msglen-1;_3I<=_3H;_3I+=1){$1.i=_3I;$1.c=$g($1.msg,$1.i);if(!$xo($1.ea,$1.c<128)&&$1.c>=0){if($1.ea){$k[$j++]=$1.numSA}else{$k[$j++]=$1.numEA}var _3U=$g($k[--$j],$1.i);var _3X=$f(_3U+$1.i)==$1.msglen?3:5;if(_3U<_3X){$k[$j++]=Infinity;$q($1.msgtmp);$k[$j++]=$1.fn4;$1.msgtmp=$a()}else{$k[$j++]=Infinity;$q($1.msgtmp);$k[$j++]=$1.fn4;$k[$j++]=$1.fn4;$1.msgtmp=$a();$1.ea=!$1.ea}}$k[$j++]=Infinity;$q($1.msgtmp);if($1.c>=0){$k[$j++]=$1.c&127}else{$k[$j++]=$1.c}$1.msgtmp=$a()}$1.msg=$1.msgtmp;$1.msglen=$1.msg.length;$1.enc=function(){var _3n=$k[--$j];$p($1.cws,$1.j,$g(_3n,$k[--$j]));$1.j=$1.j+1};$1.cws=$a($1.msglen*2);$1.i=0;$1.j=0;$1.cset="set0";for(;;){if($1.i==$1.msglen){break}for(;;){$1.char1=$g($1.msg,$1.i);$k[$j++]="char2";if($1.i+1<$1.msglen){$k[$j++]=$g($1.msg,$1.i+1)}else{$k[$j++]=-99}var _45=$k[--$j];$1[$k[--$j]]=_45;var _4A=$g($1[$1.cset],$1.char1)!==undefined;if(_4A){$k[$j++]=$1.char1;$k[$j++]=$1[$1.cset];$1.enc();$1.i=$1.i+1;break}var _4H=$g($1.set2,$1.char1)!==undefined;if(_4H){$k[$j++]=$1.sf2;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.set2;$1.enc();$1.i=$1.i+1;break}var _4R=$g($1[$1.cset],$1.char2)!==undefined;if(!_4R){if($eq($1.cset,"set0")){$k[$j++]=$1.la1;$k[$j++]=$1[$1.cset];$1.enc();$1.cset="set1"}else{$k[$j++]=$1.la0;$k[$j++]=$1[$1.cset];$1.enc();$1.cset="set0"}break}else{if($eq($1.cset,"set0")){$k[$j++]=$1.sf1;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.set1;$1.enc()}else{$k[$j++]=$1.sf0;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.set0;$1.enc()}$1.i=$1.i+1;break}break}}$1.cws=$G($1.cws,0,$1.j)}if(!bwipp_posicode.__13163__){(function(){var $ctx=Object.create($1);var _4s=new Map([["a",$a(["141112","131212","121312","111412","131113","121213","111313","121114","111214","111115","181111","171211","161311","151411","141511","131611","121711","111811","171112","161212","151312","141412","131512","121612","111712","161113","151213","141313","131413","121513","111613","151114","141214","131314","121414","111514","141115","131215","121315","111415","131116","121216","111316","121117","111217","111118","1<111112","111111111;1"])],["b",$a(["151213","141313","131413","121513","141214","131314","121414","131215","121315","121216","191212","181312","171412","161512","151612","141712","131812","121912","181213","171313","161413","151513","141613","131713","121813","171214","161314","151414","141514","131614","121714","161215","151315","141415","131515","121615","151216","141316","131416","121516","141217","131317","121417","131218","121318","121219","1<121312","121212121<1"])],["limiteda",$a(["111411","111312","111213","111114","121311","121212","121113","141111","131211","131112","171111","161211","151311","141411","131511","121611","111711","161112","151212","141312","131412","121512","111612","151113","141213","131313","121413","111513","141114","131214","121314","111414","131115","121215","111315","121116","111216","111117","151111","1"])],["limitedb",$a(["121512","121413","121314","121215","131412","131313","131214","151212","141312","141213","181212","171312","161412","151512","141612","131712","121812","171213","161313","151413","141513","131613","121713","161214","151314","141414","131514","121614","151215","141315","131415","121515","141216","131316","121416","131217","121317","121218","141212","1"])]]);$ctx.encmaps=_4s;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_posicode.$ctx[id]=$ctx[id]);bwipp_posicode.__13163__=1})()}$1.encs=$g($1.encmaps,$1.version);if(!bwipp_posicode.__13174__){(function(){var $ctx=Object.create($1);$ctx.c2w=$a([$a([495,330,210,126,70,35,15,5]),$a([165,120,84,56,35,20,10,4]),$a([45,36,28,21,15,10,6,3]),$a([9,8,7,6,5,4,3,2]),$a([1,1,1,1,1,1,1,1])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_posicode.$ctx[id]=$ctx[id]);bwipp_posicode.__13174__=1})()}$1.v=0;var _54=$1.cws;for(var _55=0,_56=_54.length;_55<_56;_55++){$1.cw=$g(_54,_55);for(var _58=0,_59=6;_58<_59;_58++){if((($1.cw^$1.v)&1)!=0){$1.v=$1.v^7682}$1.v=$1.v>>>1;$1.cw=$1.cw>>>1}}$1.v=$1.v+$1.checkoffset;if($eq($1.version,"limiteda")||$eq($1.version,"limitedb")){$1.v=$1.v&1023;if($1.v>824&&$1.v<853){$1.v=$1.v+292}}else{$1.v=($1.v&1023)+45}$1.d=$a([2,2,2,2,2,2]);$1.r=0;$1.c=0;$1.w=0;$1.sum=0;for(;;){if($1.sum==$1.v){break}$1.t=$f($1.sum+$g($g($1.c2w,$1.r),$1.c));if($1.t==$1.v){$1.w=$1.w+1;$p($1.d,$1.r,$1.w+2);$1.sum=$1.t}if($1.t>$1.v){$p($1.d,$1.r,$1.w+2);$1.r=$1.r+1;$1.w=0}if($1.t<$1.v){$1.c=$1.c+1;$1.w=$1.w+1;$1.sum=$1.t}}$k[$j++]=20;for(var _5p=0;_5p<=4;_5p+=1){var _5s=$k[--$j];$k[$j++]=$f(_5s-$g($1.d,_5p))}$p($1.d,5,$k[--$j]);if($eq($1.version,"b")||$eq($1.version,"limitedb")){$k[$j++]=Infinity;var _5x=$1.d;for(var _5y=0,_5z=_5x.length;_5y<_5z;_5y++){$k[$j++]=$f($g(_5x,_5y)+1)}$1.d=$a()}$1.cbs=$Z($s(12),"111111111111");for(var _64=5;_64>=0;_64-=1){$1.i=_64;$p($1.cbs,(5-$1.i)*2+1,$f($g($1.d,$1.i)+47))}$1.sbs=$s($1.cws.length*6+31);var _6E=$g($1.encs,$1.encs.length-2);$P($1.sbs,0,_6E);$1.j=_6E.length;for(var _6I=0,_6H=$1.cws.length-1;_6I<=_6H;_6I+=1){$1.i=_6I;$P($1.sbs,$1.j,$g($1.encs,$g($1.cws,$1.i)));$1.j=$1.j+6}$P($1.sbs,$1.j,$1.cbs);$1.j=$1.j+12;var _6X=$g($1.encs,$1.encs.length-1);$P($1.sbs,$1.j,_6X);$1.j=_6X.length+$1.j;$1.sbs=$G($1.sbs,0,$1.j);$k[$j++]=Infinity;$k[$j++]=Infinity;var _6e=$1.sbs;for(var _6f=0,_6g=_6e.length;_6f<_6g;_6f++){$k[$j++]=$f($g(_6e,_6f)-48)}var _6i=$a();$k[$j++]=Infinity;for(var _6k=0,_6l=~~(($1.sbs.length+1)/2);_6k<_6l;_6k++){$k[$j++]=$1.height}var _6n=$a();$k[$j++]=Infinity;for(var _6p=0,_6q=~~(($1.sbs.length+1)/2);_6p<_6q;_6p++){$k[$j++]=0}var _6r=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_6i;$k[$j++]="bhs";$k[$j++]=_6n;$k[$j++]="bbs";$k[$j++]=_6r;$k[$j++]="txt";$k[$j++]=$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]);$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$1.options;var _70=$d();$k[$j++]=_70;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_codablockf(){var $1=Object.create(bwipp_codablockf.$ctx||(bwipp_codablockf.$ctx={}));$1.dontdraw=false;$1.rows=-1;$1.columns=8;$1.rowheight=10;$1.sepheight=1;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.columns<4||$1.columns>62){$k[$j++]="bwipp.codablockfBadColumns#13307";$k[$j++]="Codablock F must have 4 to 62 columns";bwipp_raiseerror()}if($1.rows!=-1&&($1.rows<2||$1.rows>44)){$k[$j++]="bwipp.codablockfBadRows#13311";$k[$j++]="Codablock F must have 2 to 44 rows";bwipp_raiseerror()}if($1.rowheight<8){$k[$j++]="bwipp.codablockfBadRowHeight#13315";$k[$j++]="Codablock F must have rowheight of at least 8";bwipp_raiseerror()}if($1.sepheight<1){$k[$j++]="bwipp.codablockfBadSepHeight#13319";$k[$j++]="Codablock F must have sepheight of at least 1";bwipp_raiseerror()}$k[$j++]="c";if($1.columns>=4&&$1.columns<=62){$k[$j++]=$1.columns}else{$k[$j++]=8}var _C=$k[--$j];$1[$k[--$j]]=_C;$k[$j++]="rows";if($1.rows>=2&&$1.rows<=44){$k[$j++]=$1.rows}else{$k[$j++]=-1}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.swa=-1;$1.swb=-2;$1.swc=-3;$1.sft=-4;$1.fn1=-5;$1.fn2=-6;$1.fn3=-7;$1.fn4=-8;$1.sta=-9;$1.stp=-10;var _N=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["FNC1",$1.fn1],["FNC3",$1.fn3]]);$1.fncvals=_N;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _Q=$k[--$j];$1[$k[--$j]]=_Q;$1.msglen=$1.msg.length;$1.msgtmp=$a([]);var _U=$1.msg;for(var _V=0,_W=_U.length;_V<_W;_V++){$1.char=$g(_U,_V);$k[$j++]=Infinity;$q($1.msgtmp);if($1.char<128){$k[$j++]=$1.char}else{$k[$j++]=$1.fn4;$k[$j++]=$1.char&127}$1.msgtmp=$a()}$1.kmsg=$1.msg;$1.msg=$1.msgtmp;$1.msglen=$1.msg.length;if(!bwipp_codablockf.__13409__){(function(){var $ctx=Object.create($1);$ctx.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$ctx.fn3,$ctx.fn3,"96"]),$a([$ctx.fn2,$ctx.fn2,"97"]),$a([$ctx.sft,$ctx.sft,"98"]),$a([$ctx.swc,$ctx.swc,"99"]),$a([$ctx.swb,$ctx.fn4,$ctx.swb]),$a([$ctx.fn4,$ctx.swa,$ctx.swa]),$a([$ctx.fn1,$ctx.fn1,$ctx.fn1]),$a([$ctx.sta,$ctx.sta,$ctx.sta]),$a([$ctx.stp,$ctx.stp,$ctx.stp])]);$ctx.charvals=$a([new Map,new Map,new Map]);for(var _2p=0,_2o=$ctx.charmaps.length-1;_2p<=_2o;_2p+=1){$ctx.i=_2p;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _2t=0;_2t<=2;_2t+=1){$ctx.j=_2t;var _2w=$g($ctx.encs,$ctx.j);$k[$j++]=_2w;if($eq($t(_2w),"stringtype")){var _2z=$g($k[--$j],0);$k[$j++]=_2z}$p($g($ctx.charvals,$ctx.j),$k[--$j],$ctx.i)}}$ctx.seta=$g($ctx.charvals,0);$ctx.setb=$g($ctx.charvals,1);$ctx.setc=$g($ctx.charvals,2);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_codablockf.$ctx[id]=$ctx[id]);bwipp_codablockf.__13409__=1})()}$1.numsscr=function(){$1.n=0;$1.s=0;$1.p=$k[--$j];for(;;){if($1.p>=$1.msglen){break}var _3H=$g($1.msg,$1.p);var _3J=$g($1.setc,_3H)!==undefined;$k[$j++]=_3H;if(!_3J){$j--;break}if($k[--$j]==$1.fn1){if($1.s%2==0){$1.s=$1.s+1}else{break}}$1.n=$1.n+1;$1.s=$1.s+1;$1.p=$f($1.p+1)}$k[$j++]=$1.n;$k[$j++]=$1.s};$1.enca=function(){$p($1.cws,$1.j,$g($1.seta,$k[--$j]));$1.j=$1.j+1};$1.encb=function(){$p($1.cws,$1.j,$g($1.setb,$k[--$j]));$1.j=$1.j+1};$1.encc=function(){var _3f=$k[--$j];$k[$j++]=_3f;if($ne($t(_3f),"arraytype")){var _3j=$g($1.setc,$k[--$j]);$k[$j++]=_3j}else{$q($k[--$j]);var _3l=$k[--$j];var _3m=$k[--$j];$k[$j++]=$f($f(_3l-48)+$f(_3m-48)*10)}$p($1.cws,$1.j,$k[--$j]);$1.j=$1.j+1};$1.anotb=function(){var _3r=$k[--$j];var _3t=$g($1.seta,_3r)!==undefined;var _3v=$g($1.setb,_3r)!==undefined;$k[$j++]=_3t&&!_3v};$1.bnota=function(){var _3w=$k[--$j];var _3y=$g($1.setb,_3w)!==undefined;var _40=$g($1.seta,_3w)!==undefined;$k[$j++]=_3y&&!_40};$k[$j++]=Infinity;for(var _42=0,_43=$1.msg.length;_42<_43;_42++){$k[$j++]=0}$k[$j++]=9999;$1.nextanotb=$a();$k[$j++]=Infinity;for(var _46=0,_47=$1.msg.length;_46<_47;_46++){$k[$j++]=0}$k[$j++]=9999;$1.nextbnota=$a();for(var _4A=$1.msg.length-1;_4A>=0;_4A-=1){$1.i=_4A;$k[$j++]=$g($1.msg,$1.i);$1.anotb();if($k[--$j]){$p($1.nextanotb,$1.i,0)}else{$p($1.nextanotb,$1.i,$f($g($1.nextanotb,$1.i+1)+1))}$k[$j++]=$g($1.msg,$1.i);$1.bnota();if($k[--$j]){$p($1.nextbnota,$1.i,0)}else{$p($1.nextbnota,$1.i,$f($g($1.nextbnota,$1.i+1)+1))}}$1.abeforeb=function(){var _4X=$k[--$j];$k[$j++]=$lt($g($1.nextanotb,_4X),$g($1.nextbnota,_4X))};$1.bbeforea=function(){var _4c=$k[--$j];$k[$j++]=$lt($g($1.nextbnota,_4c),$g($1.nextanotb,_4c))};$1.padrow=function(){for(var _4i=0,_4j=$k[--$j];_4i<_4j;_4i++){for(;;){if($eq($1.cset,"seta")){$k[$j++]=$1.swc;$1.enca();$1.cset="setc";break}if($eq($1.cset,"setb")){$k[$j++]=$1.swc;$1.encb();$1.cset="setc";break}if($eq($1.cset,"setc")){$k[$j++]=$1.swb;$1.encc();$1.cset="setb";break}}}};$1.encafitsrow=function(){if($1.rem<=2&&$g($1.msg,$1.i)==$1.fn4){var _4z=$1.rem==2&&$g($1.msg,$1.i+1)<=95;$k[$j++]=_4z;if(_4z){$k[$j++]=$1.fn4;$1.enca();$k[$j++]=$g($1.msg,$1.i+1);$1.enca();$1.i=$1.i+2}}else{$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;$k[$j++]=true}};$1.encbfitsrow=function(){if($1.rem<=2&&$g($1.msg,$1.i)==$1.fn4){var _5I=$1.rem==2&&$g($1.msg,$1.i+1)>=32;$k[$j++]=_5I;if(_5I){$k[$j++]=$1.fn4;$1.encb();$k[$j++]=$g($1.msg,$1.i+1);$1.encb();$1.i=$1.i+2}}else{$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;$k[$j++]=true}};$1.cws=$a($f($1.c+5)*44);$1.i=0;$1.j=0;$1.r=1;$1.lastrow=false;for(;;){if($1.lastrow){break}if($1.r>44){$k[$j++]="bwipp.codablockfTooBig#13525";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$k[$j++]=$1.sta;$1.enca();if($1.i<$1.msglen){$k[$j++]=$1.i;$1.numsscr()}else{$k[$j++]=-1;$k[$j++]=-1}$1.nums=$k[--$j];$1.nchars=$k[--$j];for(;;){if($1.msglen==0){$k[$j++]=$1.swb;$1.enca();$1.cset="setb";break}if($1.nums>=2){$k[$j++]=$1.swc;$1.enca();$1.cset="setc";break}$k[$j++]=$1.i;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.sft;$1.enca();$1.cset="seta";break}$k[$j++]=$1.swb;$1.enca();$1.cset="setb";break}$1.j=$1.j+1;$1.endofrow=false;for(;;){$1.rem=$f($f($1.c+3)-$1.j%$f($1.c+5));if($1.i==$1.msglen||$1.endofrow){break}$k[$j++]=$1.i;$1.numsscr();$1.nums=$k[--$j];$1.nchars=$k[--$j];$k[$j++]="remnums";if($1.nums>$1.rem*2){$k[$j++]=$1.rem*2}else{$k[$j++]=$1.nums}var _5y=$k[--$j];$1[$k[--$j]]=_5y;for(;;){if(($eq($1.cset,"seta")||$eq($1.cset,"setb"))&&$1.remnums>=4&&$g($1.msg,$1.i)!=$1.fn1){if($1.remnums%2==0&&$1.rem>=3){$k[$j++]=$1.swc;if($eq($1.cset,"seta")){$1.enca()}else{$1.encb()}$1.cset="setc";for(var _6B=0,_6C=2;_6B<_6C;_6B++){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}}break}if($1.remnums%2!=0&&$1.rem>=4){$k[$j++]=$g($1.msg,$1.i);if($eq($1.cset,"seta")){$1.enca()}else{$1.encb()}$1.i=$1.i+1;$k[$j++]=$1.swc;if($eq($1.cset,"seta")){$1.enca()}else{$1.encb()}$1.cset="setc";for(var _6W=0,_6X=2;_6W<_6X;_6W++){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}}break}}$k[$j++]=$eq($1.cset,"setb");$k[$j++]=$g($1.msg,$1.i);$1.anotb();var _6m=$k[--$j];var _6n=$k[--$j];if(_6n&&_6m&&$1.rem>=2){if($1.i<$1.msglen-1){$k[$j++]=$1.i+1;$1.bbeforea();if($k[--$j]){$k[$j++]=$1.sft;$1.encb();$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;break}}$k[$j++]=$1.swa;$1.encb();$1.cset="seta";$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;break}$k[$j++]=$eq($1.cset,"seta");$k[$j++]=$g($1.msg,$1.i);$1.bnota();var _77=$k[--$j];var _78=$k[--$j];if(_78&&_77&&$1.rem>=2){if($1.i<$1.msglen-1){$k[$j++]=$1.i+1;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.sft;$1.enca();$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}}$k[$j++]=$1.swb;$1.enca();$1.cset="setb";$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}if($eq($1.cset,"setc")&&$1.remnums<2&&$1.rem>=2){$1.rem=$f($1.rem-1);$k[$j++]=$1.i;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.swa;$1.encc();$1.cset="seta";$1.encafitsrow();if($k[--$j]){break}}else{$k[$j++]=$1.swb;$1.encc();$1.cset="setb";$1.encbfitsrow();if($k[--$j]){break}}}var _7d=$g($1.seta,$g($1.msg,$1.i))!==undefined;if($eq($1.cset,"seta")&&_7d&&$1.rem>=1){$1.encafitsrow();if($k[--$j]){break}}var _7l=$g($1.setb,$g($1.msg,$1.i))!==undefined;if($eq($1.cset,"setb")&&_7l&&$1.rem>=1){$1.encbfitsrow();if($k[--$j]){break}}if($eq($1.cset,"setc")&&$1.remnums>=2&&$1.rem>=1){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}break}$1.endofrow=true;break}}if(($1.r>=$1.rows||$1.rows==-1)&&$1.r>1&&$1.i==$1.msglen&&$1.rem>=2){$k[$j++]=$f($1.rem-2);$1.padrow();$1.j=$1.j+3;$k[$j++]=$1.stp;$1.enca();$1.lastrow=true}else{$k[$j++]=$1.rem;$1.padrow();$1.j=$1.j+1;$k[$j++]=$1.stp;$1.enca();$1.r=$1.r+1}}$1.cws=$G($1.cws,0,$1.j);if(!bwipp_codablockf.__13698__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;for(var _8I=64;_8I<=95;_8I+=1){$k[$j++]=_8I}for(var _8J=0;_8J<=15;_8J+=1){$k[$j++]=_8J}for(var _8K=26;_8K<=63;_8K+=1){$k[$j++]=_8K}$ctx.abmap=$a();$k[$j++]=Infinity;for(var _8M=0;_8M<=85;_8M+=1){$k[$j++]=_8M}$ctx.cmap=$a();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_codablockf.$ctx[id]=$ctx[id]);bwipp_codablockf.__13698__=1})()}$1.chkmsg=$a($1.kmsg.length);$1.j=0;for(var _8T=0,_8S=$1.kmsg.length-1;_8T<=_8S;_8T+=1){$1.i=_8T;$1.char=$g($1.kmsg,$1.i);if($1.char>=0){$p($1.chkmsg,$1.j,$1.char);$1.j=$1.j+1}if($1.char==$1.fn1&&$1.i!=0){$p($1.chkmsg,$1.j,29);$1.j=$1.j+1}}$1.t1=0;$1.t2=0;$1.k1=0;$1.k2=0;for(var _8k=0,_8j=$1.j-1;_8k<=_8j;_8k+=1){$1.i=_8k;$1.t1=$g($1.chkmsg,$1.i)*$1.i%86;$1.t2=$f($1.t1+$g($1.chkmsg,$1.i))%86;$1.k1=$f($1.k1+$1.t2)%86;$1.k2=$f($1.k2+$1.t1)%86}$k[$j++]=$1.cws;$k[$j++]=$1.cws.length-4;if($ne($1.cset,"setc")){$k[$j++]=$1.abmap}else{$k[$j++]=$1.cmap}var _94=$g($k[--$j],$1.k1);var _95=$k[--$j];$p($k[--$j],_95,_94);$k[$j++]=$1.cws;$k[$j++]=$1.cws.length-3;if($ne($1.cset,"setc")){$k[$j++]=$1.abmap}else{$k[$j++]=$1.cmap}var _9E=$g($k[--$j],$1.k2);var _9F=$k[--$j];$p($k[--$j],_9F,_9E);var _9H=$1.cws;$k[$j++]=_9H;$k[$j++]=2;if($g(_9H,2-1)!=99){$k[$j++]=$1.abmap}else{$k[$j++]=$1.cmap}var _9N=$g($k[--$j],$1.r-2);var _9O=$k[--$j];$p($k[--$j],_9O,_9N);for(var _9S=1,_9R=$1.r-1;_9S<=_9R;_9S+=1){$1.i=_9S;var _9T=$1.cws;var _9U=$1.i;var _9V=$1.c;$k[$j++]=_9T;$k[$j++]=$f(_9U*$f(_9V+5)+2);if($g(_9T,$f($f(_9U*$f(_9V+5)+2)-1))!=99){$k[$j++]=$1.abmap}else{$k[$j++]=$1.cmap}var _9b=$g($k[--$j],$1.i+42);var _9c=$k[--$j];$p($k[--$j],_9c,_9b)}for(var _9g=0,_9f=$1.r-1;_9g<=_9f;_9g+=1){$1.rcws=$G($1.cws,_9g*$f($1.c+5),$f($1.c+4));$1.csum=$g($1.rcws,0);for(var _9p=1,_9o=$1.rcws.length-2;_9p<=_9o;_9p+=1){$1.i=_9p;$1.csum=$f($1.csum+$g($1.rcws,$1.i)*$1.i)}$p($1.rcws,$1.rcws.length-1,$1.csum%103)}var _9z=$g($1.options,"debugcws")!==undefined;if(_9z){$k[$j++]="bwipp.debugcws#13738";$k[$j++]=$1.cws;bwipp_raiseerror()}if(!bwipp_codablockf.__13759__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["212222","222122","222221","121223","121322","131222","122213","122312","132212","221213","221312","231212","112232","122132","122231","113222","123122","123221","223211","221132","221231","213212","223112","312131","311222","321122","321221","312212","322112","322211","212123","212321","232121","111323","131123","131321","112313","132113","132311","211313","231113","231311","112133","112331","132131","113123","113321","133121","313121","211331","231131","213113","213311","213131","311123","311321","331121","312113","312311","332111","314111","221411","431111","111224","111422","121124","121421","141122","141221","112214","112412","122114","122411","142112","142211","241211","221114","413111","241112","134111","111242","121142","121241","114212","124112","124211","411212","421112","421211","212141","214121","412121","111143","111341","131141","114113","114311","411113","411311","113141","114131","311141","411131","211412","2331112"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_codablockf.$ctx[id]=$ctx[id]);bwipp_codablockf.__13759__=1})()}$1.rowbits=$a($1.r);for(var _A7=0,_A6=$1.r-1;_A7<=_A6;_A7+=1){$1.i=_A7;$k[$j++]=Infinity;var _AC=$G($1.cws,$1.i*$f($1.c+5),$f($1.c+5));for(var _AD=0,_AE=_AC.length;_AD<_AE;_AD++){$F($g($1.encs,$g(_AC,_AD)),function(){var _AI=$k[--$j];$k[$j++]=$f(_AI-48)})}$1.sbs=$a();$k[$j++]=Infinity;var _AK=$1.sbs;$k[$j++]=0;for(var _AL=0,_AM=_AK.length;_AL<_AM;_AL++){var _AO=$k[--$j];var _AP=_AO==1?0:1;$k[$j++]=_AO;for(var _AQ=0,_AR=$g(_AK,_AL);_AQ<_AR;_AQ++){$k[$j++]=_AP}}$as($a($m()-1));var _AU=$k[--$j];var _AV=$k[--$j];$k[$j++]=_AU;$k[$j++]=_AV;$j--;var _AW=$k[--$j];var _AX=$k[--$j];$k[$j++]=_AW;$k[$j++]=_AX;$j--;$p($1.rowbits,$1.i,$k[--$j])}$1.symwid=$f($1.c*11+57);$k[$j++]=Infinity;for(var _Ae=0,_Af=$1.symwid*$1.sepheight;_Ae<_Af;_Ae++){$k[$j++]=1}for(var _Ai=0,_Ah=$1.r-2;_Ai<=_Ah;_Ai+=1){$1.i=_Ai;for(var _Ak=0,_Al=$1.rowheight;_Ak<_Al;_Ak++){$q($g($1.rowbits,$1.i))}for(var _Aq=0,_Ar=$1.sepheight;_Aq<_Ar;_Aq++){$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;for(var _At=0,_Au=$f($1.symwid-24);_At<_Au;_At++){$k[$j++]=1}$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=1}}for(var _Aw=0,_Ax=$1.rowheight;_Aw<_Ax;_Aw++){$q($g($1.rowbits,$1.r-1))}for(var _B3=0,_B4=$1.symwid*$1.sepheight;_B3<_B4;_B3++){$k[$j++]=1}$1.pixs=$a();var _BE=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.symwid],["pixy",~~($1.pixs.length/$1.symwid)],["height",~~($1.pixs.length/$1.symwid)/72],["width",$1.symwid/72],["opt",$1.options]]);$k[$j++]=_BE;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_code16k(){var $1=Object.create(bwipp_code16k.$ctx||(bwipp_code16k.$ctx={}));$1.dontdraw=false;$1.sam=-1;$1.rows=0;$1.rowheight=8;$1.sepheight=1;$1.raw=false;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.rows!=0&&($1.rows<2||$1.rows>16)){$k[$j++]="bwipp.code16kBadRows#13855";$k[$j++]="Code 16K must have 2 to 16 rows";bwipp_raiseerror()}if($1.rowheight<8){$k[$j++]="bwipp.code16kBadRowHeight#13859";$k[$j++]="Code 16K must have rowheight of at least 8";bwipp_raiseerror()}if($1.sepheight<1){$k[$j++]="bwipp.code16kBadSepHeight#13863";$k[$j++]="Code 16K must have sepheight of at least 1";bwipp_raiseerror()}if($1.sam!=-1){$k[$j++]=true;for(var _8=0,_9=1;_8<_9;_8++){var _A=$1.sam;if(_A<12||_A>99){$j--;$k[$j++]=false;break}if($1.sam%10<2){$j--;$k[$j++]=false;break}if(~~($1.sam/10)>$1.sam%10){$j--;$k[$j++]=false;break}}if($nt($k[--$j])){$k[$j++]="bwipp.code16kBadSAM#13874";$k[$j++]='SAM must be formatted as "NM" for Nth of M symbols, from 2 to 9 symbols';bwipp_raiseerror()}}if($1.sam!=-1){$1.rows=16}if(!bwipp_code16k.__13945__){(function(){var $ctx=Object.create($1);$ctx.swa=-1;$ctx.swb=-2;$ctx.swc=-3;$ctx.sa1=-4;$ctx.sb1=-5;$ctx.sc1=-6;$ctx.sa2=-7;$ctx.sb2=-8;$ctx.sc2=-9;$ctx.pad=-10;$ctx.sb3=-11;$ctx.sc3=-12;$ctx.fn1=-13;$ctx.fn2=-14;$ctx.fn3=-15;$ctx.fn4=-16;$ctx.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$ctx.fn3,$ctx.fn3,"96"]),$a([$ctx.fn2,$ctx.fn2,"97"]),$a([$ctx.sb1,$ctx.sa1,"98"]),$a([$ctx.swc,$ctx.swc,"99"]),$a([$ctx.swb,$ctx.fn4,$ctx.swb]),$a([$ctx.fn4,$ctx.swa,$ctx.swa]),$a([$ctx.fn1,$ctx.fn1,$ctx.fn1]),$a([$ctx.pad,$ctx.pad,$ctx.pad]),$a([$ctx.sb2,$ctx.sa2,$ctx.sb1]),$a([$ctx.sc2,$ctx.sc2,$ctx.sb2]),$a([$ctx.sc3,$ctx.sc3,$ctx.sb3])]);$ctx.charvals=$a([new Map,new Map,new Map]);for(var _2W=0,_2V=$ctx.charmaps.length-1;_2W<=_2V;_2W+=1){$ctx.i=_2W;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _2a=0;_2a<=2;_2a+=1){$ctx.j=_2a;var _2d=$g($ctx.encs,$ctx.j);$k[$j++]=_2d;if($eq($t(_2d),"stringtype")){var _2g=$g($k[--$j],0);$k[$j++]=_2g}$p($g($ctx.charvals,$ctx.j),$k[--$j],$ctx.i)}}$ctx.seta=$g($ctx.charvals,0);$ctx.setb=$g($ctx.charvals,1);$ctx.setc=$g($ctx.charvals,2);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code16k.$ctx[id]=$ctx[id]);bwipp_code16k.__13945__=1})()}if($1.raw){$1.cws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.barcode.length-3){break}if($g($1.barcode,$1.i)!=94){break}var _33=$G($1.barcode,$1.i+1,3);$k[$j++]=_33;$k[$j++]=false;for(var _34=0,_35=_33.length;_34<_35;_34++){var _36=$g(_33,_34);if(_36<48||_36>57){$j--;$k[$j++]=true}}if($k[--$j]){$j--;break}$1.cw=$i($k[--$j]);$p($1.cws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}if($1.i!=$1.barcode.length){$k[$j++]="bwipp.code16kBadRawFormat#13963";$k[$j++]="raw data must be formatted as ^NNN";bwipp_raiseerror()}$1.cws=$G($1.cws,0,$1.j)}else{var _3O=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true],["FNC1",$1.fn1],["FNC2",$1.fn2],["FNC3",$1.fn3]]);$1.fncvals=_3O;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _3R=$k[--$j];$1[$k[--$j]]=_3R;$1.msglen=$1.msg.length;$k[$j++]=Infinity;for(var _3V=0,_3W=$1.msglen;_3V<_3W;_3V++){$k[$j++]=0}$k[$j++]=0;$1.numSA=$a();$k[$j++]=Infinity;for(var _3Z=0,_3a=$1.msglen;_3Z<_3a;_3Z++){$k[$j++]=0}$k[$j++]=0;$1.numEA=$a();for(var _3d=$1.msglen-1;_3d>=0;_3d-=1){$1.i=_3d;if($g($1.msg,$1.i)>=0){if($g($1.msg,$1.i)>=128){$p($1.numEA,$1.i,$f($g($1.numEA,$1.i+1)+1))}else{$p($1.numSA,$1.i,$f($g($1.numSA,$1.i+1)+1))}}}$1.ea=false;$1.msgtmp=$a([]);for(var _3x=0,_3w=$1.msglen-1;_3x<=_3w;_3x+=1){$1.i=_3x;$1.c=$g($1.msg,$1.i);if(!$xo($1.ea,$1.c<128)&&$1.c>=0){if($1.ea){$k[$j++]=$1.numSA}else{$k[$j++]=$1.numEA}var _49=$g($k[--$j],$1.i);var _4C=$f(_49+$1.i)==$1.msglen?3:5;if(_49<_4C){$k[$j++]=Infinity;$q($1.msgtmp);$k[$j++]=$1.fn4;$1.msgtmp=$a()}else{$k[$j++]=Infinity;$q($1.msgtmp);$k[$j++]=$1.fn4;$k[$j++]=$1.fn4;$1.msgtmp=$a();$1.ea=!$1.ea}}$k[$j++]=Infinity;$q($1.msgtmp);if($1.c>=0){$k[$j++]=$1.c&127}else{$k[$j++]=$1.c}$1.msgtmp=$a()}$1.msg=$1.msgtmp;$1.msglen=$1.msg.length;$1.numsscr=function(){$1.n=0;$1.s=0;$1.p=$k[--$j];for(;;){if($1.p>=$1.msglen){break}var _4X=$g($1.msg,$1.p);var _4Z=$g($1.setc,_4X)!==undefined;$k[$j++]=_4X;if(!_4Z){$j--;break}if($k[--$j]==$1.fn1){if($1.s%2==0){$1.s=$1.s+1}else{break}}$1.n=$1.n+1;$1.s=$1.s+1;$1.p=$f($1.p+1)}$k[$j++]=$1.n;$k[$j++]=$1.s};$1.enca=function(){$p($1.cws,$1.j,$g($1.seta,$k[--$j]));$1.j=$1.j+1};$1.encb=function(){$p($1.cws,$1.j,$g($1.setb,$k[--$j]));$1.j=$1.j+1};$1.encc=function(){var _4v=$k[--$j];$k[$j++]=_4v;if($ne($t(_4v),"arraytype")){var _4z=$g($1.setc,$k[--$j]);$k[$j++]=_4z}else{$q($k[--$j]);var _51=$k[--$j];var _52=$k[--$j];$k[$j++]=$f($f(_51-48)+$f(_52-48)*10)}$p($1.cws,$1.j,$k[--$j]);$1.j=$1.j+1};$1.anotb=function(){var _57=$k[--$j];var _59=$g($1.seta,_57)!==undefined;var _5B=$g($1.setb,_57)!==undefined;$k[$j++]=_59&&!_5B};$1.bnota=function(){var _5C=$k[--$j];var _5E=$g($1.setb,_5C)!==undefined;var _5G=$g($1.seta,_5C)!==undefined;$k[$j++]=_5E&&!_5G};$k[$j++]=Infinity;for(var _5I=0,_5J=$1.msg.length;_5I<_5J;_5I++){$k[$j++]=0}$k[$j++]=9999;$1.nextanotb=$a();$k[$j++]=Infinity;for(var _5M=0,_5N=$1.msg.length;_5M<_5N;_5M++){$k[$j++]=0}$k[$j++]=9999;$1.nextbnota=$a();for(var _5Q=$1.msg.length-1;_5Q>=0;_5Q-=1){$1.i=_5Q;$k[$j++]=$g($1.msg,$1.i);$1.anotb();if($k[--$j]){$p($1.nextanotb,$1.i,0)}else{$p($1.nextanotb,$1.i,$f($g($1.nextanotb,$1.i+1)+1))}$k[$j++]=$g($1.msg,$1.i);$1.bnota();if($k[--$j]){$p($1.nextbnota,$1.i,0)}else{$p($1.nextbnota,$1.i,$f($g($1.nextbnota,$1.i+1)+1))}}$1.abeforeb=function(){var _5n=$k[--$j];$k[$j++]=$lt($g($1.nextanotb,_5n),$g($1.nextbnota,_5n))};$1.bbeforea=function(){var _5s=$k[--$j];$k[$j++]=$lt($g($1.nextbnota,_5s),$g($1.nextanotb,_5s))};$1.cws=$a($1.barcode.length*2+3);$1.i=0;$1.j=0;for(;;){if($1.sam!=-1){$p($1.cws,0,~~($1.sam/10)-1);$p($1.cws,1,$1.sam%10-1);$1.j=2;$1.cset="setb";$1.mode=7;break}if($1.msglen==0){$1.cset="setb";$1.mode=1;break}if($1.msglen>=2){$k[$j++]=$g($1.msg,0)==$1.fn1;$k[$j++]=1;$1.numsscr();var _69=$k[--$j];var _6A=$k[--$j];$k[$j++]=_69;$k[$j++]=_6A;$j--;var _6B=$k[--$j];var _6C=$k[--$j];if(_6C&&_6B>=2){$1.cset="setc";$1.mode=4;$1.i=1;break}}if($g($1.msg,0)==$1.fn1){$1.cset="setb";$1.mode=3;$1.i=1;break}if($1.msglen>=2){$k[$j++]=0;$1.numsscr();var _6H=$k[--$j];var _6I=$k[--$j];$k[$j++]=_6H;$k[$j++]=_6I;$j--;var _6J=$k[--$j];if(_6J>=2&&_6J%2==0){$1.cset="setc";$1.mode=2;break}$k[$j++]=0;$1.numsscr();var _6K=$k[--$j];var _6L=$k[--$j];$k[$j++]=_6K;$k[$j++]=_6L;$j--;var _6M=$k[--$j];if(_6M>=3&&_6M%2==1){$k[$j++]=$g($1.msg,0);$1.encb();$1.cset="setc";$1.mode=5;$1.i=1;break}var _6S=$g($1.setb,$g($1.msg,0))!==undefined;$k[$j++]=_6S;$k[$j++]=1;$1.numsscr();var _6T=$k[--$j];var _6U=$k[--$j];$k[$j++]=_6T;$k[$j++]=_6U;$j--;var _6V=$k[--$j];var _6W=$k[--$j];if(_6W&&(_6V>=2&&_6V%2==0)){$k[$j++]=$g($1.msg,0);$1.encb();$1.cset="setc";$1.mode=5;$1.i=1;break}var _6c=$g($1.setb,$g($1.msg,0))!==undefined;$k[$j++]=_6c;$k[$j++]=1;$1.numsscr();var _6d=$k[--$j];var _6e=$k[--$j];$k[$j++]=_6d;$k[$j++]=_6e;$j--;var _6f=$k[--$j];var _6g=$k[--$j];if(_6g&&(_6f>=3&&_6f%2==1)){$k[$j++]=$g($1.msg,0);$1.encb();$k[$j++]=$g($1.msg,1);$1.encb();$1.cset="setc";$1.mode=6;$1.i=2;break}var _6o=$g($1.setb,$g($1.msg,0))!==undefined;var _6s=$g($1.setb,$g($1.msg,1))!==undefined;$k[$j++]=_6o&&_6s;$k[$j++]=2;$1.numsscr();var _6t=$k[--$j];var _6u=$k[--$j];$k[$j++]=_6t;$k[$j++]=_6u;$j--;var _6v=$k[--$j];var _6w=$k[--$j];if(_6w&&(_6v>=2&&_6v%2==0)){$k[$j++]=$g($1.msg,0);$1.encb();$k[$j++]=$g($1.msg,1);$1.encb();$1.cset="setc";$1.mode=6;$1.i=2;break}}$k[$j++]=0;$1.abeforeb();if($k[--$j]){$1.cset="seta";$1.mode=0;break}$1.cset="setb";$1.mode=1;break}for(;;){if($1.i==$1.msglen){break}$k[$j++]=$1.i;$1.numsscr();$1.nums=$k[--$j];$1.nchars=$k[--$j];for(;;){if($eq($1.cset,"seta")){if($1.i<$1.msglen-1){$k[$j++]=$g($1.msg,$1.i);$1.bnota();$k[$j++]=$1.i+1;$1.abeforeb();var _7E=$k[--$j];var _7F=$k[--$j];if(_7F&&_7E){$k[$j++]=$1.sb1;$1.enca();$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}}if($1.i<$1.msglen-2){$k[$j++]=$g($1.msg,$1.i);$1.bnota();$k[$j++]=$g($1.msg,$1.i+1);$1.bnota();var _7T=$k[--$j];var _7U=$k[--$j];$k[$j++]=$an(_7U,_7T);$k[$j++]=$1.i+2;$1.abeforeb();var _7W=$k[--$j];var _7X=$k[--$j];if(_7X&&_7W){$k[$j++]=$1.sb2;$1.enca();$k[$j++]=$g($1.msg,$1.i);$1.encb();$k[$j++]=$g($1.msg,$1.i+1);$1.encb();$1.i=$1.i+2;break}}$k[$j++]=$g($1.msg,$1.i);$1.bnota();if($k[--$j]){$k[$j++]=$1.swb;$1.enca();$1.cset="setb";break}if($1.i<$1.msglen-4){var _7s=$g($1.seta,$g($1.msg,$1.i+4))!==undefined;if($1.nums==4&&_7s){$k[$j++]=$1.sc2;$1.enca();for(var _7u=0,_7v=2;_7u<_7v;_7u++){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}}break}}if($1.i<$1.msglen-6){var _8D=$g($1.seta,$g($1.msg,$1.i+6))!==undefined;if($1.nums==6&&_8D){$k[$j++]=$1.sc3;$1.enca();for(var _8F=0,_8G=3;_8F<_8G;_8F++){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}}break}}if($1.nums>=4&&$1.nums%2==0){$k[$j++]=$1.swc;$1.enca();$1.cset="setc";break}$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;break}if($eq($1.cset,"setb")){if($1.i<$1.msglen-1){$k[$j++]=$g($1.msg,$1.i);$1.anotb();$k[$j++]=$1.i+1;$1.bbeforea();var _8f=$k[--$j];var _8g=$k[--$j];if(_8g&&_8f){$k[$j++]=$1.sa1;$1.encb();$k[$j++]=$g($1.msg,$1.i);$1.enca();$1.i=$1.i+1;break}}if($1.i<$1.msglen-2){$k[$j++]=$g($1.msg,$1.i);$1.anotb();$k[$j++]=$g($1.msg,$1.i+1);$1.anotb();var _8u=$k[--$j];var _8v=$k[--$j];$k[$j++]=$an(_8v,_8u);$k[$j++]=$1.i+2;$1.bbeforea();var _8x=$k[--$j];var _8y=$k[--$j];if(_8y&&_8x){$k[$j++]=$1.sa2;$1.encb();$k[$j++]=$g($1.msg,$1.i);$1.enca();$k[$j++]=$g($1.msg,$1.i+1);$1.enca();$1.i=$1.i+2;break}}$k[$j++]=$g($1.msg,$1.i);$1.anotb();if($k[--$j]){$k[$j++]=$1.swa;$1.encb();$1.cset="seta";break}if($1.i<$1.msglen-4){var _9J=$g($1.setb,$g($1.msg,$1.i+4))!==undefined;if($1.nums==4&&_9J){$k[$j++]=$1.sc2;$1.encb();for(var _9L=0,_9M=2;_9L<_9M;_9L++){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}}break}}if($1.i<$1.msglen-6){var _9e=$g($1.setb,$g($1.msg,$1.i+6))!==undefined;if($1.nums==6&&_9e){$k[$j++]=$1.sc3;$1.encb();for(var _9g=0,_9h=3;_9g<_9h;_9g++){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}}break}}if($1.nums>=4&&$1.nums%2==0){$k[$j++]=$1.swc;$1.encb();$1.cset="setc";break}$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}if($eq($1.cset,"setc")){if($1.nums>=2){if($g($1.msg,$1.i)==$1.fn1){$k[$j++]=$1.fn1;$1.encc();$1.i=$1.i+1}else{$k[$j++]=$G($1.msg,$1.i,2);$1.encc();$1.i=$1.i+2}break}if($1.i<$1.msglen-1){var _AH=$g($1.setb,$g($1.msg,$1.i))!==undefined;$k[$j++]=_AH;$k[$j++]=$1.i+1;$1.numsscr();var _AJ=$k[--$j];var _AK=$k[--$j];$k[$j++]=_AJ;$k[$j++]=_AK;$j--;var _AL=$k[--$j];var _AM=$k[--$j];if(_AM&&(_AL>=2&&_AL%2==0)){$k[$j++]=$1.sb1;$1.encc();$k[$j++]=$g($1.msg,$1.i);$1.encb();$1.i=$1.i+1;break}}if($1.i<$1.msglen-1){var _AY=$g($1.setb,$g($1.msg,$1.i))!==undefined;$k[$j++]=_AY;$k[$j++]=$1.i+1;$1.numsscr();var _Aa=$k[--$j];var _Ab=$k[--$j];$k[$j++]=_Aa;$k[$j++]=_Ab;$j--;var _Ac=$k[--$j];var _Ad=$k[--$j];if(_Ad&&(_Ac>=3&&_Ac%2==1)){$k[$j++]=$1.sb2;$1.encc();$k[$j++]=$g($1.msg,$1.i);$1.encb();$k[$j++]=$g($1.msg,$1.i+1);$1.encb();$1.i=$1.i+2;break}}if($1.i<$1.msglen-2){var _As=$g($1.setb,$g($1.msg,$1.i))!==undefined;var _Ax=$g($1.setb,$g($1.msg,$1.i+1))!==undefined;$k[$j++]=_As&&_Ax;$k[$j++]=$1.i+2;$1.numsscr();var _Az=$k[--$j];var _B0=$k[--$j];$k[$j++]=_Az;$k[$j++]=_B0;$j--;var _B1=$k[--$j];var _B2=$k[--$j];if(_B2&&(_B1>=2&&_B1%2==0)){$k[$j++]=$1.sb2;$1.encc();$k[$j++]=$g($1.msg,$1.i);$1.encb();$k[$j++]=$g($1.msg,$1.i+1);$1.encb();$1.i=$1.i+2;break}}if($1.i<$1.msglen-3){var _BH=$g($1.setb,$g($1.msg,$1.i))!==undefined;var _BM=$g($1.setb,$g($1.msg,$1.i+1))!==undefined;$k[$j++]=_BH&&_BM;$k[$j++]=$1.i+2;$1.numsscr();var _BO=$k[--$j];var _BP=$k[--$j];$k[$j++]=_BO;$k[$j++]=_BP;$j--;var _BQ=$k[--$j];var _BR=$k[--$j];if(_BR&&(_BQ>=3&&_BQ%2==1)){$k[$j++]=$1.sb3;$1.encc();$k[$j++]=$g($1.msg,$1.i);$1.encb();$k[$j++]=$g($1.msg,$1.i+1);$1.encb();$k[$j++]=$g($1.msg,$1.i+2);$1.encb();$1.i=$1.i+3;break}}if($1.i<$1.msglen-3){var _Bj=$g($1.setb,$g($1.msg,$1.i))!==undefined;var _Bo=$g($1.setb,$g($1.msg,$1.i+1))!==undefined;var _Bt=$g($1.setb,$g($1.msg,$1.i+2))!==undefined;$k[$j++]=_Bj&&_Bo&&_Bt;$k[$j++]=$1.i+3;$1.numsscr();var _Bv=$k[--$j];var _Bw=$k[--$j];$k[$j++]=_Bv;$k[$j++]=_Bw;$j--;var _Bx=$k[--$j];var _By=$k[--$j];if(_By&&(_Bx>=2&&_Bx%2==0)){$k[$j++]=$1.sb3;$1.encc();$k[$j++]=$g($1.msg,$1.i);$1.encb();$k[$j++]=$g($1.msg,$1.i+1);$1.encb();$k[$j++]=$g($1.msg,$1.i+2);$1.encb();$1.i=$1.i+3;break}}$k[$j++]=$1.i;$1.abeforeb();if($k[--$j]){$k[$j++]=$1.swa;$1.encc();$1.cset="seta";break}$k[$j++]=$1.swb;$1.encc();$1.cset="setb";break}break}}$1.cws=$G($1.cws,0,$1.j)}if(!bwipp_code16k.__14438__){(function(){var $ctx=Object.create($1);$ctx.metrics=$a([$a([2,7]),$a([3,12]),$a([4,17]),$a([5,22]),$a([6,27]),$a([7,32]),$a([8,37]),$a([9,42]),$a([10,47]),$a([11,52]),$a([12,57]),$a([13,62]),$a([14,67]),$a([15,72]),$a([16,77])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code16k.$ctx[id]=$ctx[id]);bwipp_code16k.__14438__=1})()}$1.urows=$1.rows;var _CZ=$1.metrics;for(var _Ca=0,_Cb=_CZ.length;_Ca<_Cb;_Ca++){$1.m=$g(_CZ,_Ca);$1.r=$g($1.m,0);$1.dcws=$g($1.m,1);$1.okay=true;if($1.urows!=0&&$1.urows!=$1.r){$1.okay=false}if($1.cws.length>$1.dcws){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.code16kNoValidSymbol#14453";$k[$j++]="Maximum length exceeded or data too large for given options";bwipp_raiseerror()}$k[$j++]=Infinity;$q($1.cws);for(var _Cr=0,_Cs=$f($1.dcws-$1.cws.length);_Cr<_Cs;_Cr++){$k[$j++]=103}$1.cws=$a();$k[$j++]=Infinity;$k[$j++]=$f($f($1.r-2)*7+$1.mode);$q($1.cws);$1.cws=$a();$k[$j++]=0;for(var _D0=0,_Cz=$1.dcws;_D0<=_Cz;_D0+=1){var _D3=$k[--$j];$k[$j++]=$f(_D3+(_D0+2)*$g($1.cws,_D0))}$1.c1=$k[--$j]%107;$k[$j++]=0;for(var _D7=0,_D6=$1.dcws;_D7<=_D6;_D7+=1){var _DA=$k[--$j];$k[$j++]=$f(_DA+(_D7+1)*$g($1.cws,_D7))}$1.c2=$f($k[--$j]+$1.c1*$f($1.dcws+2))%107;$k[$j++]=Infinity;$q($1.cws);$k[$j++]=$1.c1;$k[$j++]=$1.c2;$1.cws=$a();var _DJ=$g($1.options,"debugcws")!==undefined;if(_DJ){$k[$j++]="bwipp.debugcws#14469";$k[$j++]=$1.cws;bwipp_raiseerror()}if(!bwipp_code16k.__14505__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["212222","222122","222221","121223","121322","131222","122213","122312","132212","221213","221312","231212","112232","122132","122231","113222","123122","123221","223211","221132","221231","213212","223112","312131","311222","321122","321221","312212","322112","322211","212123","212321","232121","111323","131123","131321","112313","132113","132311","211313","231113","231311","112133","112331","132131","113123","113321","133121","313121","211331","231131","213113","213311","213131","311123","311321","331121","312113","312311","332111","314111","221411","431111","111224","111422","121124","121421","141122","141221","112214","112412","122114","122411","142112","142211","241211","221114","413111","241112","134111","111242","121142","121241","114212","124112","124211","411212","421112","421211","212141","214121","412121","111143","111341","131141","114113","114311","411113","411311","113141","114131","311141","411131","211412","211214","211232","211133"]);$ctx.startencs=$a(["3211","2221","2122","1411","1132","1231","1114","3112","3211","2221","2122","1411","1132","1231","1114","3112"]);$ctx.stopencsodd=$a(["3211","2221","2122","1411","1132","1231","1114","3112","1132","1231","1114","3112","3211","2221","2122","1411"]);$ctx.stopencseven=$a(["2122","1411","1132","1231","1114","3112","1132","1231","1114","3112","3211","2221","2122","1411","3211","2221"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code16k.$ctx[id]=$ctx[id]);bwipp_code16k.__14505__=1})()}if($1.sam==-1||~~($1.sam/10)%2==1){$1.stopencs=$1.stopencsodd}else{$1.stopencs=$1.stopencseven}$1.rowbits=$a($1.r);for(var _DY=0,_DX=$f($1.r-1);_DY<=_DX;_DY+=1){$1.i=_DY;$k[$j++]=Infinity;$k[$j++]=10;$F($g($1.startencs,$1.i),function(){var _Dc=$k[--$j];$k[$j++]=$f(_Dc-48)});var _Df=$G($1.cws,$1.i*5,5);$k[$j++]=1;for(var _Dg=0,_Dh=_Df.length;_Dg<_Dh;_Dg++){$F($g($1.encs,$g(_Df,_Dg)),function(){var _Dl=$k[--$j];$k[$j++]=$f(_Dl-48)})}$F($g($1.stopencs,$1.i),function(){var _Dp=$k[--$j];$k[$j++]=$f(_Dp-48)});$k[$j++]=1;$1.sbs=$a();$k[$j++]=Infinity;var _Dr=$1.sbs;$k[$j++]=1;for(var _Ds=0,_Dt=_Dr.length;_Ds<_Dt;_Ds++){var _Dv=$k[--$j];var _Dw=_Dv==0?1:0;$k[$j++]=_Dv;for(var _Dx=0,_Dy=$g(_Dr,_Ds);_Dx<_Dy;_Dx++){$k[$j++]=_Dw}}$as($a($m()-1));var _E1=$k[--$j];var _E2=$k[--$j];$k[$j++]=_E1;$k[$j++]=_E2;$j--;var _E3=$k[--$j];var _E4=$k[--$j];$k[$j++]=_E3;$k[$j++]=_E4;$j--;$p($1.rowbits,$1.i,$k[--$j])}$k[$j++]=Infinity;for(var _E9=0,_EA=81*$1.sepheight;_E9<_EA;_E9++){$k[$j++]=1}for(var _ED=0,_EC=$f($1.r-2);_ED<=_EC;_ED+=1){$1.i=_ED;for(var _EF=0,_EG=$1.rowheight;_EF<_EG;_EF++){$q($g($1.rowbits,$1.i))}for(var _EL=0,_EM=$1.sepheight;_EL<_EM;_EL++){for(var _EN=0,_EO=10;_EN<_EO;_EN++){$k[$j++]=0}for(var _EP=0,_EQ=70;_EP<_EQ;_EP++){$k[$j++]=1}$k[$j++]=0}}for(var _ES=0,_ET=$1.rowheight;_ES<_ET;_ES++){$q($g($1.rowbits,$f($1.r-1)))}for(var _EY=0,_EZ=81*$1.sepheight;_EY<_EZ;_EY++){$k[$j++]=1}$1.pixs=$a();var _Ef=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",81],["pixy",~~($1.pixs.length/81)],["height",~~($1.pixs.length/81)/72],["width",81/72],["opt",$1.options]]);$k[$j++]=_Ef;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_code49(){var $1=Object.create(bwipp_code49.$ctx||(bwipp_code49.$ctx={}));$1.dontdraw=false;$1.sam=-1;$1.append=false;$1.rows=0;$1.rowheight=8;$1.sepheight=1;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.rows!=0&&($1.rows<2||$1.rows>8)){$k[$j++]="bwipp.code49badRows#14607";$k[$j++]="Code 49 must have 2 to 8 rows";bwipp_raiseerror()}if($1.rowheight<8){$k[$j++]="bwipp.code49badRowHeight#14611";$k[$j++]="Code 49 must have rowheight of at least 8";bwipp_raiseerror()}if($1.sepheight<1){$k[$j++]="bwipp.code49badSepHeight#14615";$k[$j++]="Code 49 must have sepheight of at least 1";bwipp_raiseerror()}if($1.append&&$1.sam!=-1){$k[$j++]="bwipp.code49samAndAppend#14619";$k[$j++]="sam and append cannot be specified together";bwipp_raiseerror()}if($1.sam!=-1){$k[$j++]=true;for(var _A=0,_B=1;_A<_B;_A++){var _C=$1.sam;if(_C<12||_C>99){$j--;$k[$j++]=false;break}if($1.sam%10<2){$j--;$k[$j++]=false;break}if(~~($1.sam/10)>$1.sam%10){$j--;$k[$j++]=false;break}}if($nt($k[--$j])){$k[$j++]="bwipp.code49badSAM#14630";$k[$j++]='SAM must be formatted as "NM" for Nth of M symbols, from 2 to 9 symbols';bwipp_raiseerror()}}if(!bwipp_code49.__14638__){(function(){var $ctx=Object.create($1);$ctx.s1=-1;$ctx.s2=-2;$ctx.fn1=-3;$ctx.fn2=-4;$ctx.fn3=-5;$ctx.ns=-6;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code49.$ctx[id]=$ctx[id]);bwipp_code49.__14638__=1})()}var _N=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["FNC1",$1.fn1],["FNC2",$1.fn2],["FNC3",$1.fn3]]);$1.fncvals=_N;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _Q=$k[--$j];$1[$k[--$j]]=_Q;$1.msglen=$1.msg.length;$F($1.msg,function(){if($k[--$j]>127){$k[$j++]="bwipp.code49badCharacter#14653";$k[$j++]="Code 49 can only support ASCII characters with values 0 to 127";bwipp_raiseerror()}});if(!bwipp_code49.__14697__){(function(){var $ctx=Object.create($1);$ctx.charmap=$a(["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","-","."," ","$","/","+","%",$ctx.s1,$ctx.s2,$ctx.fn1,$ctx.fn2,$ctx.fn3,$ctx.ns]);$ctx.charvals=new Map;for(var _c=0;_c<=48;_c+=1){$ctx.i=_c;var _f=$g($ctx.charmap,$ctx.i);$k[$j++]=_f;if($eq($t(_f),"stringtype")){var _i=$g($k[--$j],0);$k[$j++]=_i}$p($ctx.charvals,$k[--$j],$ctx.i)}$ctx.combos=$a(["1 ","1A","1B","1C","1D","1E","1F","1G","1H","1I","1J","1K","1L","1M","1N","1O","1P","1Q","1R","1S","1T","1U","1V","1W","1X","1Y","1Z","11","12","13","14","15","  ","16","17","18"," $"," %","19","10","1-","1.","1$"," +","1/"," -"," ."," /"," 0"," 1"," 2"," 3"," 4"," 5"," 6"," 7"," 8"," 9","1+","21","22","23","24","25","26"," A"," B"," C"," D"," E"," F"," G"," H"," I"," J"," K"," L"," M"," N"," O"," P"," Q"," R"," S"," T"," U"," V"," W"," X"," Y"," Z","27","28","29","20","2-","2.","2A","2B","2C","2D","2E","2F","2G","2H","2I","2J","2K","2L","2M","2N","2O","2P","2Q","2R","2S","2T","2U","2V","2W","2X","2Y","2Z","2$","2/","2+","2%","2 "]);for(var _n=0;_n<=127;_n+=1){$ctx.i=_n;var _q=$g($ctx.combos,$ctx.i);$ctx.c1=$g(_q,0);$ctx.c2=$g(_q,1);if($ctx.c1==49){$p($ctx.charvals,$ctx.i,$a([$g($ctx.charvals,$ctx.s1),$g($ctx.charvals,$ctx.c2)]))}if($ctx.c1==50){$p($ctx.charvals,$ctx.i,$a([$g($ctx.charvals,$ctx.s2),$g($ctx.charvals,$ctx.c2)]))}}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code49.$ctx[id]=$ctx[id]);bwipp_code49.__14697__=1})()}$1.encodealpha=function(){var _1G=$g($1.charvals,$k[--$j]);$k[$j++]=_1G;if($ne($t(_1G),"arraytype")){$as($a(1))}var _1J=$k[--$j];$P($1.cws,$1.j,_1J);$1.j=_1J.length+$1.j};$1.base48=function(){var _1N=$k[--$j];$k[$j++]=0;$F(_1N,function(){var _1O=$k[--$j];var _1P=$k[--$j];$k[$j++]=$f($f(_1O-48)+_1P*10)});$k[$j++]=Infinity;var _1Q=$k[--$j];var _1R=$k[--$j];var _1S=$k[--$j];$k[$j++]=_1Q;$k[$j++]=_1R;for(var _1T=0,_1U=$f(_1S-1);_1T<_1U;_1T++){var _1V=$k[--$j];$k[$j++]=_1V%48;$k[$j++]=~~(_1V/48)}var _1W=$a();$k[$j++]=_1W;$k[$j++]=Infinity;var _1X=$k[--$j];var _1Y=$k[--$j];$k[$j++]=_1X;$k[$j++]=_1Y;for(var _1Z=_1Y.length-1;_1Z>=0;_1Z-=1){var _1a=$k[--$j];$k[$j++]=$g(_1a,_1Z);$k[$j++]=_1a}$j--;var _1c=$a();$P($1.cws,$1.j,_1c);$1.j=_1c.length+$1.j};$1.encodenumeric=function(){$1.nums=$k[--$j];var _1i=$1.nums.length;var _1j=_1i%5;$k[$j++]="pre";$k[$j++]=_1i;$k[$j++]=_1j;if(_1j!=2){var _1k=$k[--$j];var _1l=$k[--$j];$k[$j++]=$f(_1l-_1k)}else{var _1m=$k[--$j];var _1n=$k[--$j];$k[$j++]=$f($f(_1n-_1m)-5)}var _1o=$k[--$j];$1[$k[--$j]]=_1o;for(var _1s=0,_1r=$f($1.pre-1);_1s<=_1r;_1s+=5){$k[$j++]=3;$k[$j++]=$G($1.nums,_1s,5);$1.base48()}$1.nums=$G($1.nums,$1.pre,$f($1.nums.length-$1.pre));var _21=$1.nums.length;$k[$j++]=_21;if(_21==1){$k[$j++]=$g($1.nums,$1.i);$1.encodealpha()}var _25=$k[--$j];$k[$j++]=_25;if(_25==3){$k[$j++]=2;$k[$j++]=$1.nums;$1.base48()}var _27=$k[--$j];$k[$j++]=_27;if(_27==4){$k[$j++]=3;$k[$j++]=Infinity;$k[$j++]=49;$k[$j++]=48;$q($1.nums);var _29=$a();$k[$j++]=_29;$1.base48()}if($k[--$j]==7){$k[$j++]=3;$k[$j++]=Infinity;$k[$j++]=49;$k[$j++]=48;$q($G($1.nums,0,4));var _2D=$a();$k[$j++]=_2D;$1.base48();$k[$j++]=2;$k[$j++]=$G($1.nums,4,3);$1.base48()}};$k[$j++]=Infinity;for(var _2H=0,_2I=$1.msglen;_2H<_2I;_2H++){$k[$j++]=0}$k[$j++]=0;$1.numericruns=$a();for(var _2L=$1.msglen-1;_2L>=0;_2L-=1){$1.i=_2L;var _2O=$g($1.msg,$1.i);if(_2O>=48&&_2O<=57){$p($1.numericruns,$1.i,$f($g($1.numericruns,$1.i+1)+1))}else{$p($1.numericruns,$1.i,0)}}$1.cws=$a($1.msglen*2+1);if(!bwipp_code49.__14754__){(function(){var $ctx=Object.create($1);$ctx.samval=$a([12,22,13,23,33,14,24,34,44,15,25,35,45,55,16,26,36,46,56,66,17,27,37,47,57,67,77,18,28,38,48,58,68,78,88,19,29,39,49,59,69,79,89,99]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code49.$ctx[id]=$ctx[id]);bwipp_code49.__14754__=1})()}for(;;){if($1.append){$1.mode=1;$1.method="alpha";$1.i=0;$1.j=0;break}if($1.sam!=-1){$1.mode=3;$k[$j++]=$1.cws;$k[$j++]=0;for(var _2d=0;_2d<=43;_2d+=1){$k[$j++]=_2d;if($g($1.samval,_2d)!=$1.sam){$j--}}var _2h=$k[--$j];var _2i=$k[--$j];$p($k[--$j],_2i,$f(_2h+1));$1.method="alpha";$1.i=0;$1.j=1;break}if($g($1.numericruns,0)>=5){$1.mode=2;$1.method="numeric";$1.i=0;$1.j=0;break}var _2p=$g($1.charvals,$g($1.msg,0));$k[$j++]=_2p;if($ne($t(_2p),"arraytype")){$j--;$1.mode=0;$1.method="alpha";$1.i=0;$1.j=0;break}var _2t=$g($k[--$j],0)==43?4:5;$1.mode=_2t;$p($1.cws,0,$g($g($1.charvals,$g($1.msg,0)),1));$1.method="alpha";$1.i=1;$1.j=1;break}for(;;){if($1.i==$1.msglen){break}for(;;){if($eq($1.method,"alpha")){if($g($1.numericruns,$1.i)>=5){$k[$j++]=$1.ns;$1.encodealpha();$1.method="numeric";break}$k[$j++]=$g($1.msg,$1.i);$1.encodealpha();$1.i=$1.i+1;break}if($eq($1.method,"numeric")){if($g($1.numericruns,$1.i)<5){$k[$j++]=$1.ns;$1.encodealpha();$1.method="alpha";break}$k[$j++]=$G($1.msg,$1.i,$g($1.numericruns,$1.i));$1.encodenumeric();$1.i=$f($1.i+$g($1.numericruns,$1.i));break}}}$1.cws=$G($1.cws,0,$1.j);if(!bwipp_code49.__14832__){(function(){var $ctx=Object.create($1);$ctx.metrics=$a([$a([2,9]),$a([3,16]),$a([4,23]),$a([5,30]),$a([6,37]),$a([7,42]),$a([8,49])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code49.$ctx[id]=$ctx[id]);bwipp_code49.__14832__=1})()}$1.urows=$1.rows;var _3d=$1.metrics;for(var _3e=0,_3f=_3d.length;_3e<_3f;_3e++){$1.m=$g(_3d,_3e);$1.r=$g($1.m,0);$1.dcws=$g($1.m,1);$1.okay=true;if($1.urows!=0&&$1.urows!=$1.r){$1.okay=false}if($1.cws.length>$1.dcws){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.code49noValidSymbol#14847";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$k[$j++]=Infinity;$q($1.cws);for(var _3v=0,_3w=$f($1.dcws-$1.cws.length);_3v<_3w;_3v++){$k[$j++]=48}$1.cws=$a();$1.ccs=$a($1.r*8);$1.j=0;for(var _42=0,_41=$f($1.r-2);_42<=_41;_42+=1){$1.i=_42;$1.cc=$G($1.cws,$1.j,7);$P($1.ccs,$1.i*8,$1.cc);var _4B=$1.cc;$k[$j++]=$1.ccs;$k[$j++]=$1.i*8+7;$k[$j++]=0;for(var _4C=0,_4D=_4B.length;_4C<_4D;_4C++){var _4F=$k[--$j];$k[$j++]=$f(_4F+$g(_4B,_4C))}var _4G=$k[--$j];var _4H=$k[--$j];$p($k[--$j],_4H,_4G%49);$1.j=$1.j+7}if($1.j<$1.dcws){$P($1.ccs,$1.ccs.length-8,$G($1.cws,$1.j,$f($1.dcws-$1.j)))}$1.cr7=$f($f($1.r-2)*7+$1.mode);$p($1.ccs,$1.ccs.length-2,$1.cr7);if(!bwipp_code49.__14878__){(function(){var $ctx=Object.create($1);var _4Y=$a([1,9,31,26,2,12,17,23,37,18,22,6,27,44,15,43,39,11,13,5,41,33,36,8,4,32,3,19,40,25,29,10,24,30]);$k[$j++]=_4Y;$k[$j++]=_4Y;$k[$j++]=Infinity;var _4Z=$k[--$j];var _4b=$G($k[--$j],0,32);$k[$j++]=_4Z;$k[$j++]=20;$q(_4b);$ctx.weightx=$a();var _4d=$k[--$j];$k[$j++]=_4d;$k[$j++]=_4d;$k[$j++]=Infinity;var _4e=$k[--$j];var _4g=$G($k[--$j],1,32);$k[$j++]=_4e;$k[$j++]=16;$q(_4g);$ctx.weighty=$a();$k[$j++]=Infinity;var _4i=$k[--$j];var _4k=$G($k[--$j],2,32);$k[$j++]=_4i;$k[$j++]=38;$q(_4k);$ctx.weightz=$a();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code49.$ctx[id]=$ctx[id]);bwipp_code49.__14878__=1})()}$1.calccheck=function(){$1.weights=$k[--$j];$1.score=0;for(var _4q=0,_4p=~~($f($1.r-1)*8/2)-1;_4q<=_4p;_4q+=1){$1.i=_4q;$1.score=$f($f($g($1.ccs,$1.i*2)*49+$g($1.ccs,$1.i*2+1))*$g($1.weights,$1.i+1)+$1.score)}$k[$j++]=$1.score};$1.lastrow=$G($1.ccs,$1.ccs.length-8,8);if($1.r>=7){$k[$j++]=$1.cr7*$g($1.weightz,0);$k[$j++]=$1.weightz;$1.calccheck();var _5A=$k[--$j];var _5C=$f($k[--$j]+_5A)%2401;$k[$j++]=~~(_5C/49);$k[$j++]=_5C%49;$as($a(2));$P($1.lastrow,0,$k[--$j])}$1.wr1=$f($g($1.lastrow,0)*49+$g($1.lastrow,1));$k[$j++]=$1.cr7*$g($1.weighty,0);$k[$j++]=$1.weighty;$1.calccheck();var _5O=$k[--$j];var _5U=$f($f($k[--$j]+_5O)+$1.wr1*$g($1.weighty,$f($1.r*4-3)))%2401;$1.wr2=_5U;$k[$j++]=~~(_5U/49);$k[$j++]=_5U%49;$as($a(2));$P($1.lastrow,2,$k[--$j]);$k[$j++]=$1.cr7*$g($1.weightx,0);$k[$j++]=$1.weightx;$1.calccheck();var _5c=$k[--$j];var _5m=$f($f($f($k[--$j]+_5c)+$1.wr1*$g($1.weightx,$f($1.r*4-3)))+$1.wr2*$g($1.weightx,$f($1.r*4-2)))%2401;$k[$j++]=~~(_5m/49);$k[$j++]=_5m%49;$as($a(2));$P($1.lastrow,4,$k[--$j]);var _5s=$G($1.ccs,$1.ccs.length-8,7);$k[$j++]=0;for(var _5t=0,_5u=_5s.length;_5t<_5u;_5t++){var _5w=$k[--$j];$k[$j++]=$f(_5w+$g(_5s,_5t))}$p($1.ccs,$1.ccs.length-1,$k[--$j]%49);var _61=$g($1.options,"debugcws")!==undefined;if(_61){$k[$j++]="bwipp.debugcws#14918";$k[$j++]=$1.ccs;bwipp_raiseerror()}if(!bwipp_code49.__15616__){(function(){var $ctx=Object.create($1);$ctx.patterns=$a([$a(["11521132","25112131","14212132","25121221","14221222","12412132","23321221","12421222","21521221","15112222","15121312","13312222","24221311","13321312","11512222","22421311","11521312","25112311","14212312","23312311","12412312","21512311","16121131","14321131","12521131","15212131","15221221","13412131","13421221","11612131","16112221","16121311","14312221","14321311","12512221","12521311","15212311","13412311","11612311","11131135","31131133","51131131","21122134","41122132","21131224","41131222","11113135","31113133","51113131","11122225","31122223","51122221","11131315","31131313","51131311","21113224","41113222","21122314","41122312","11113315","31113313","51113311","12131134","32131132","21231133","41231131","22122133","42122131","11222134","22131223","42131221","11231224","31231222","12113134","32113132","12122224","32122222","12131314","32131312","21231313","41231311","22113223","42113221","11213224","22122313","42122311","11222314","31222312","12113314","32113312","21213313","41213311","13131133","33131131","22231132","11331133","31331131","23122132","12222133","23131222","12231223","32231221","21331222","13113133","33113131","13122223","33122221","11313133","13131313","33131311","11322223","22231312","11331313","31331311","23113222","12213223","23122312","12222313","32222311","21322312","13113313","33113311","22213312","11313313","31313311","14131132","23231131","12331132","21431131","24122131","13222132","24131221","13231222","11422132","22331221","11431222","14113132","14122222","12313132","14131312","12322222","23231311","12331312","21431311","24113221","13213222","24122311","13222312","11413222","22322311","11422312","14113312","23213311","12313312","21413311","15131131","13331131","14222131","14231221","12422131","12431221","15113131","15122221","13313131","15131311","13322221","11513131","13331311","11522221","14213221","14222311","12413221","12422311","15113311","13313311","11513311","11141134","31141132","21132133","41132131","21141223","41141221","11123134","31123132","11132224","31132222","11141314","31141312","21114133","41114131","21123223","41123221","21132313","41132311","11114224","31114222","11123314","31123312","21114313","41114311","12141133","32141131","21241132","22132132","11232133","22141222","11241223","31241221","12123133","32123131","12132223","32132221","12141313","32141311","21241312","22114132","11214133","22123222","11223223","22132312","11232313","31232311","12114223","32114221","12123313","32123311","21223312","22114312","11214313","31214311","13141132","22241131","11341132","23132131","12232132","23141221","12241222","21341221","13123132","13132222","11323132","13141312","11332222","22241311","11341312","23114131","12214132","23123221","12223222","23132311","12232312","21332311","13114222","13123312","11314222","22223311","11323312","23114311","12214312","21314311","14141131","12341131","13232131","13241221","11432131","14123131","14132221","12323131","14141311","12332221","12341311","13214131","13223221","11414131","13232311","11423221","11432311","14114221","14123311","12314221","12323311","13214311","11414311","11151133","31151131","21142132","21151222","11133133","31133131","11142223","31142221","11151313","31151311","21124132","21133222","21142312","11115133","31115131","11124223","31124221","11133313","31133311","21115222","21124312","12151132","21251131","22142131","11242132","22151221","11251222","12133132","12142222","12151312","21251311","22124131","11224132","22133221","11233222","22142311","11242312","12115132","12124222","12133312","21233311","22115221","11215222","22124311","11224312","13151131","12242131","12251221","13133131","13142221","11333131","13151311","11342221","12224131","12233221","12242311","13115131","13124221","11315131","13133311","11324221","11333311","12215221","12224311","11161132","21152131","21161221","11143132","11152222","11161312","21134131","21143221","21152311","11125132","11134222","11143312","21116131","21125221","21134311","12161131","11252131","12143131","12152221","12161311","11234131","11243221","11252311","12125131","12134221","12143311","11216131","11225221","11234311","11111236","31111234","51111232","21111325","41111323","61111321","11111416","31111414","51111412","31211143","51211141","12111235","32111233","52111231","21211234","41211232","22111324","42111322","11211325","31211323","51211321","12111415","32111413","52111411","21211414","41211412","12211144","32211142","21311143","41311141","13111234","33111232","22211233","42211231","11311234","31311232","23111323","43111321","12211324","32211322","21311323","41311321","13111414","33111412","22211413","42211411","11311414","31311412","13211143","33211141","22311142","11411143","31411141","14111233","34111231","23211232","12311233","32311231","21411232","24111322","13211323","33211321","22311322","11411323","31411321","14111413","34111411","23211412","12311413","32311411","21411412","14211142","23311141","12411142","21511141","15111232","24211231","13311232","22411231","11511232","25111321","14211322","23311321","12411322","21511321","15111412","24211411","13311412","22411411","11511412","15211141","13411141","11611141","16111231","14311231","12511231","15211321","13411321","11611321","16111411","14311411","12511411","21121144","41121142","11112145","31112143","51112141","11121235","31121233","51121231","21112234","41112232","21121324","41121322","11112325","31112323","51112321","11121415","31121413","51121411","21112414","41112412","22121143","42121141","11221144","31221142","12112144","32112142","12121234","32121232","21221233","41221231","22112233","42112231","11212234","22121323","42121321","11221324","31221322","12112324","32112322","12121414","32121412","21221413","41221411","22112413","42112411","11212414","31212412","23121142","12221143","32221141","21321142","13112143","33112141","13121233","33121231","11312143","22221232","11321233","31321231","23112232","12212233","23121322","12221323","32221321","21321322","13112323","33112321","13121413","33121411","11312323","22221412","11321413","31321411","23112412","12212413","32212411","21312412","24121141","13221142","22321141","11421142","14112142","14121232","12312142","23221231","12321232","21421231","24112231","13212232","24121321","13221322","11412232","22321321","11421322","14112322","14121412","12312322","23221411","12321412","21421411","24112411","13212412","22312411","11412412","14221141","12421141","15112141","15121231","13312141","13321231","11512141","11521231","14212231","14221321","12412231","12421321","15112321","15121411","13312321","13321411","11512321","11521411","14212411","12412411","21131143","41131141","11122144","31122142","11131234","31131232","21113143","41113141","21122233","41122231","21131323","41131321","11113234","31113232","11122324","31122322","11131414","31131412","21113323","41113321","21122413","41122411","11113414","31113412","22131142","11231143","31231141","12122143","32122141","12131233","32131231","21231232","22113142","11213143","22122232","11222233","22131322","11231323","31231321","12113233","32113231","12122323","32122321","12131413","32131411","21231412","22113322","11213323","22122412","11222413","31222411","12113413","32113411","21213412","23131141","12231142","21331141","13122142","13131232","11322142","22231231","11331232","23113141","12213142","23122231","12222232","23131321","12231322","21331321","13113232","13122322","11313232","13131412","11322322","22231411","11331412","23113321","12213322","23122411","12222412","21322411","13113412","22213411","11313412","13231141","11431141","14122141","14131231","12322141","12331231","13213141","13222231","11413141","13231321","11422231","11431321","14113231","14122321","12313231","14131411","12322321","12331411","13213321","13222411","11413321","11422411","14113411","12313411","21141142","11132143","31132141","11141233","31141231","21123142","21132232","21141322","11114143","31114141","11123233","31123231","11132323","31132321","11141413","31141411","21114232","21123322","21132412","11114323","31114321","11123413","31123411","22141141","11241142","12132142","12141232","21241231","22123141","11223142","22132231","11232232","22141321","11241322","12114142","12123232","12132322","12141412","21241411","22114231","11214232","22123321","11223322","22132411","11232412","12114322","12123412","21223411","12241141","13132141","13141231","11332141","11341231","12223141","12232231","12241321","13114141","13123231","11314141","13132321","11323231","13141411","11332321","11341411","12214231","12223321","12232411","13114321","13123411","11314321","11323411","21151141","11142142","11151232","21133141","21142231","21151321","11124142","11133232","11142322","11151412","21115141","21124231","21133321","21142411","11115232","11124322","11133412","11251141","12142141","12151231","11233141","11242231","11251321","12124141","12133231","12142321","12151411","11215141","11224231","11233321","11242411","12115231","12124321","12133411","11152141","11161231","11134141","11143231","11152321","11161411","11116141","11125231","11134321","11143411","21111244","41111242","11111335","31111333","51111331","21111424","41111422","11111515","31111513","51111511","21211153","41211151","22111243","42111241","11211244","31211242","12111334","32111332","21211333","41211331","22111423","42111421","11211424","31211422","12111514","32111512","21211513","41211511","22211152","11311153","31311151","23111242","12211243","32211241","21311242","13111333","33111331","22211332","11311333","31311331","23111422","12211423","32211421","21311422","13111513","33111511","22211512","11311513","31311511","23211151","12311152","21411151","24111241","13211242","22311241","11411242","14111332","23211331","12311332","21411331","24111421","13211422","22311421","11411422","14111512","23211511","12311512","21411511","13311151","11511151","14211241","12411241","15111331","13311331","11511331","14211421","12411421","15111511","13311511","11511511","31121152","21112153","41112151","21121243","41121241","11112244","31112242","11121334","31121332","21112333","41112331","21121423","41121421","11112424","31112422","11121514","31121512","21112513","41112511","12121153","32121151","21221152","22112152","11212153","22121242","11221243","31221241","12112243","32112241","12121333","32121331","21221332","22112332","11212333","22121422","11221423","31221421","12112423","32112421","12121513","32121511","21221512","22112512","11212513","31212511","13121152","22221151","11321152","23112151","12212152","23121241","12221242","21321241","13112242","13121332","11312242","22221331","11321332","23112331","12212332","23121421","12221422","21321421","13112422","13121512","11312422","22221511","11321512","23112511","12212512","21312511","14121151","12321151","13212151","13221241","11412151","11421241","14112241","14121331","12312241","12321331","13212331","13221421","11412331","11421421","14112421","14121511","12312421","12321511","13212511","11412511","11131153","31131151","21122152","21131242","11113153","31113151","11122243","31122241","11131333","31131331","21113242","21122332","21131422","11113333","31113331","11122423","31122421","11131513","31131511","21113422","21122512","12131152","21231151","22122151","11222152","22131241","11231242","12113152","12122242","12131332","21231331","22113241","11213242","22122331","11222332","22131421","11231422","12113332","12122422","12131512","21231511","22113421","11213422","22122511","11222512","13131151","11331151","12222151","12231241","13113151","13122241","11313151","13131331","11322241","11331331","12213241","12222331","12231421","13113331","13122421","11313331","13131511","11322421","11331511","12213421","12222511","11141152","21132151","21141241","11123152","11132242","11141332","21114151","21123241","21132331","21141421","11114242","11123332","11132422","11141512","21114331","21123421","21132511","12141151","11232151","11241241","12123151","12132241","12141331","11214151","11223241","11232331","11241421","12114241","12123331","12132421","12141511","11214331","11223421","11232511","11151151","11133151","11142241","11151331","11115151","11124241","11133331","11142421","11151511","11111254","31111252","21111343","41111341","11111434","31111432","21111523","41111521","11111614","31111612","31211161","12111253","32111251","21211252","22111342","11211343","31211341","12111433","32111431","21211432","22111522","11211523","31211521","12111613","32111611","21211612","12211162","21311161","13111252","22211251","11311252","23111341","12211342","21311341","13111432","22211431","11311432","23111521","12211522","21311521","13111612","22211611","11311612","13211161","11411161","14111251","12311251","13211341","11411341","14111431","12311431","13211521","11411521","14111611","12311611","21121162","11112163","31112161","11121253","31121251","21112252","21121342","11112343","31112341","11121433","31121431","21112432","21121522","11112523","31112521","11121613","31121611","22121161","11221162","12112162","12121252","21221251","22112251","11212252","22121341","11221342","12112342","12121432","21221431","22112431","11212432","22121521","11221522","12112522","12121612","21221611","12221161","13112161","13121251","11312161","11321251","32121115","52121113","21221116","41221114","61221112","22112116","42112114","31212115","51212113","13121116","33121114","22221115","42221113","11321116","31321114","51321112","23112115","43112113","12212116","32212114","52212112","21312115","41312113","61312111","14121115","34121113","23221114","43221112","12321115","32321113","52321111","21421114","41421112","24112114","13212115","33212113","22312114","42312112","11412115","31412113","51412111","15121114","24221113","13321114","33321112","22421113","42421111","11521114","31521112","25112113","14212114","34212112","23312113","43312111","12412114","32412112","21512113","41512111","16121113","25221112","14321113","34321111","23421112","12521113","32521111","15212113","24312112","13412113","33412111","22512112","11612113","31612111","31131115","51131113","21122116","41122114","61122112","31113115","51113113","12131116","32131114","52131112","21231115","41231113","61231111","22122115","42122113","11222116","31222114","51222112","12113116","32113114","52113112","21213115","41213113","61213111","13131115","33131113","22231114","42231112","11331115","31331113","51331111","23122114","43122112","12222115","32222113","52222111","21322114","41322112","13113115","33113113","22213114","42213112","11313115","31313113","51313111","14131114","34131112","23231113","43231111","12331114","32331112","21431113","41431111","24122113","13222114","33222112","22322113","42322111","11422114","31422112","14113114","34113112","23213113","43213111","12313114","32313112","21413113","41413111","15131113","24231112","13331113","33331111","22431112","25122112","14222113","34222111","23322112","12422113","32422111","21522112","15113113","24213112","13313113","33313111","22413112","11513113","31513111","16131112","25231111","14331112","23431111","15222112","24322111","13422112","22522111","16113112","25213111","14313112","23413111","12513112","21613111","11141116","31141114","51141112","21132115","41132113","61132111","11123116","31123114","51123112","21114115","41114113","61114111","12141115","32141113","52141111","21241114","41241112","22132114","42132112","11232115","31232113","51232111","12123115","32123113","52123111","21223114","41223112","22114114","42114112","11214115","31214113","51214111","13141114","33141112","22241113","42241111","11341114","31341112","23132113","43132111","12232114","32232112","21332113","41332111","13123114","33123112","22223113","42223111","11323114","31323112","23114113","43114111","12214114","32214112","21314113","41314111","14141113","34141111","23241112","12341113","32341111","24132112","13232113","33232111","22332112","11432113","31432111","14123113","34123111","23223112","12323113","32323111","21423112","24114112","13214113","33214111","22314112","11414113","31414111","15141112","24241111","13341112","25132111","14232112","23332111","12432112","15123112","24223111","13323112","22423111","11523112","25114111","14214112","23314111","12414112","21514111","16141111","14341111","15232111","13432111","16123111","14323111","12523111","15214111","13414111","11614111","11151115","31151113","51151111","21142114","41142112","11133115","31133113","51133111","21124114","41124112","11115115","31115113","51115111","12151114","32151112","21251113","41251111","22142113","42142111","11242114","31242112","12133114","32133112","21233113","41233111","22124113","42124111","11224114","31224112","12115114","32115112","21215113","41215111","13151113","33151111","22251112","23142112","12242113","32242111","21342112","13133113","33133111","22233112","11333113","31333111","23124112","12224113","32224111","21324112","13115113","33115111","22215112","11315113","31315111","14151112","23251111","24142111","13242112","22342111","14133112","23233111","12333112","21433111","24124111","13224112","22324111","11424112","14115112","23215111","12315112","21415111","15151111","14242111","15133111","13333111","14224111","12424111","15115111","13315111","11515111","11161114","31161112","21152113","41152111","11143114","31143112","21134113","41134111","11125114","31125112","21116113","41116111","12161113","32161111","22152112","11252113","31252111","12143113","32143111","21243112","22134112","11234113","31234111","12125113","32125111","21225112","22116112","11216113","31216111","13161112","23152111","12252112","13143112","22243111","11343112","23134111","12234112","21334111","13125112","22225111","11325112","23116111","12216112","21316111","14161111","13252111","14143111","12343111","13234111","11434111","14125111","12325111","13216111","11416111","31111216","51111214","31211125","51211123","32111215","52111213","21211216","41211214","61211212","12211126","32211124","52211122","21311125","41311123","61311121","13111216","33111214","22211215","42211213","11311216","31311214","51311212","13211125","33211123","22311124","42311122","11411125","31411123","51411121","14111215","34111213","23211214","43211212","12311215","32311213","52311211","21411214","41411212","14211124","34211122","23311123","43311121","12411124","32411122","21511123","41511121","15111214","24211213","13311214","33311212","22411213","42411211","11511214","31511212","15211123","24311122","13411123","33411121","22511122","11611123","31611121","16111213","25211212","14311213","34311211","23411212","12511213","32511211","21611212","21121126","41121124","61121122","31112125","51112123","31121215","51121213","21112216","41112214","61112212","22121125","42121123","11221126","31221124","51221122","12112126","32112124","52112122","12121216","32121214","52121212","21221215","41221213","61221211","22112215","42112213","11212216","31212214","51212212","23121124","43121122","12221125","32221123","52221121","21321124","41321122","13112125","33112123","13121215","33121213","11312125","22221214","42221212","11321215","31321213","51321211","23112214","43112212","12212215","32212213","52212211","21312214","41312212","24121123","13221124","33221122","22321123","42321121","11421124","31421122","14112124","34112122","14121214","34121212","12312124","23221213","43221211","12321214","32321212","21421213","41421211","24112213","13212214","33212212","22312213","42312211","11412214","31412212","25121122","14221123","34221121","23321122","12421123","32421121","21521122","15112123","15121213","13312123","24221212","13321213","33321211","11512123","22421212","11521213","31521211","25112212","14212213","34212211","23312212","12412213","32412211","21512212","15221122","24321121","13421122","22521121","16112122","16121212","14312122","25221211","14321212","12512122","23421211","12521212","15212212","24312211","13412212","22512211","11612212","21131125","41131123","61131121","11122126","31122124","51122122","11131216","31131214","51131212","21113125","41113123","61113121","21122215","41122213","61122211","11113216","31113214","51113212","22131124","42131122","11231125","31231123","51231121","12122125","32122123","52122121","12131215","32131213","52131211","21231214","41231212","22113124","42113122","11213125","22122214","42122212","11222215","31222213","51222211","12113215","32113213","52113211","21213214","41213212","23131123","43131121","12231124","32231122","21331123","41331121","13122124","33122122","13131214","33131212","11322124","22231213","42231211","11331214","31331212","23113123","43113121","12213124","23122213","43122211","12222214","32222212","21322213","41322211","13113214","33113212","22213213","42213211","11313214","31313212","24131122","13231123","33231121","22331122","11431123","31431121","14122123","34122121","14131213","34131211","12322123","23231212","12331213","32331211","21431212","24113122","13213123","24122212","13222213","33222211","11413123","22322212","11422213","31422211","14113213","34113211","23213212","12313213","32313211","21413212","25131121","14231122","23331121","12431122","15122122","15131212","13322122","24231211","13331212","11522122","22431211","25113121","14213122","25122211","14222212","12413122","23322211","12422212","21522211","15113212","24213211","13313212","22413211","11513212","15231121","13431121","16122121","16131211","14322121","14331211","12522121","15213121","15222211","13413121","13422211","11613121","16113211","14313211","12513211","21141124","41141122","11132125","31132123","51132121","11141215","31141213","51141211","21123124","41123122","21132214","41132212","11114125","31114123","51114121","11123215","31123213","51123211","21114214","41114212","22141123","42141121","11241124","31241122","12132124","32132122","12141214","32141212","21241213","41241211","22123123","42123121","11223124","22132213","42132211","11232214","31232212","12114124","32114122","12123214","32123212","21223213","41223211","22114213","42114211","11214214","31214212","23141122","12241123","32241121","21341122","13132123","33132121","13141213","33141211","11332123","22241212","11341213","31341211","23123122","12223123","23132212","12232213","32232211","21332212","13114123","33114121","13123213","33123211","11314123","22223212","11323213","31323211","23114212","12214213","32214211","21314212","24141121","13241122","22341121","14132122","14141212","12332122","23241211","12341212","24123121","13223122","24132211","13232212","11423122","22332211","11432212","14114122","14123212","12314122","23223211","12323212","21423211","24114211","13214212","22314211","11414212","14241121","15132121","15141211","13332121","13341211","14223121","14232211","12423121","12432211","15114121","15123211","13314121","13323211","11514121","11523211","14214211","12414211","21151123","41151121","11142124","31142122","11151214","31151212","21133123","41133121","21142213","41142211","11124124","31124122","11133214","31133212","21115123","41115121","21124213","41124211","11115214","31115212","22151122","11251123","31251121","12142123","32142121","12151213","32151211","21251212","22133122","11233123","22142212","11242213","31242211","12124123","32124121","12133213","32133211","21233212","22115122","11215123","22124212","11224213","31224211","12115213","32115211","21215212","23151121","12251122","13142122","13151212","11342122","22251211","23133121","12233122","23142211","12242212","21342211","13124122","13133212","11324122","22233211","11333212","23115121","12215122","23124211","12224212","21324211","13115212","22215211","11315212","13251121","14142121","14151211","12342121","13233121","13242211","11433121","14124121","14133211","12324121","12333211","13215121","13224211","11415121","11424211","14115211","12315211","21161122","11152123","31152121","11161213","31161211","21143122","21152212","11134123","31134121","11143213","31143211","21125122","21134212","11116123","31116121","11125213","31125211","22161121","12152122","12161212","22143121","11243122","22152211","11252212","12134122","12143212","21243211","22125121","11225122","22134211","11234212","12116122","12125212","21225211","13152121","13161211","12243121","12252211","13134121","13143211","11334121","11343211","12225121","12234211","13116121","13125211","11316121","11325211","21111226","41111224","61111222","31111315","51111313","21211135","41211133","61211131","22111225","42111223","11211226","31211224","51211222","12111316","32111314","52111312","21211315","41211313","61211311","22211134","42211132","11311135","31311133","51311131","23111224","43111222","12211225","32211223","52211221","21311224","41311222","13111315","33111313","22211314","42211312","11311315","31311313","51311311","23211133","43211131","12311134","32311132","21411133","41411131","24111223","13211224","33211222","22311223","42311221","11411224","31411222","14111314","34111312","23211313","43211311","12311314","32311312","21411313","41411311","24211132","13311133","33311131","22411132","11511133","31511131","25111222","14211223","34211221","23311222","12411223","32411221","21511222","15111313","24211312","13311313","33311311","22411312","11511313","31511311","25211131","14311132","23411131","12511132","21611131","15211222","24311221","13411222","22511221","11611222","16111312","25211311","14311312","23411311","12511312","21611311","31121134","51121132","21112135","41112133","61112131","21121225","41121223","61121221","11112226","31112224","51112222","11121316","31121314","51121312","21112315","41112313","61112311","12121135","32121133","52121131","21221134","41221132","22112134","42112132","11212135","22121224","42121222","11221225","31221223","51221221","12112225","32112223","52112221","12121315","32121313","52121311","21221314","41221312","22112314","42112312","11212315","31212313","51212311","13121134","33121132","22221133","42221131","11321134","31321132","23112133","43112131","12212134","23121223","43121221","12221224","32221222","21321223","41321221","13112224","33112222","13121314","33121312","11312224","22221313","42221311","11321314","31321312","23112313","43112311","12212314","32212312","21312313","41312311","14121133","34121131","23221132","12321133","32321131","21421132","24112132","13212133","24121222","13221223","33221221","11412133","22321222","11421223","31421221","14112223","34112221","14121313","34121311","12312223","23221312","12321313","32321311","21421312","24112312","13212313","33212311","22312312","11412313","31412311","15121132","24221131","13321132","22421131"]),$a(["22121116","42121114","31221115","51221113","32112115","52112113","21212116","41212114","61212112","23121115","43121113","12221116","32221114","52221112","21321115","41321113","61321111","13112116","33112114","22212115","42212113","11312116","31312114","51312112","24121114","13221115","33221113","22321114","42321112","11421115","31421113","51421111","14112115","34112113","23212114","43212112","12312115","32312113","52312111","21412114","41412112","25121113","14221114","34221112","23321113","43321111","12421114","32421112","21521113","41521111","15112114","24212113","13312114","33312112","22412113","42412111","11512114","31512112","15221113","24321112","13421113","33421111","22521112","16112113","25212112","14312113","34312111","23412112","12512113","32512111","21612112","21131116","41131114","61131112","31122115","51122113","21113116","41113114","61113112","22131115","42131113","11231116","31231114","51231112","12122116","32122114","52122112","21222115","41222113","61222111","22113115","42113113","11213116","31213114","51213112","23131114","43131112","12231115","32231113","52231111","21331114","41331112","13122115","33122113","22222114","42222112","11322115","31322113","51322111","23113114","43113112","12213115","32213113","52213111","21313114","41313112","24131113","13231114","33231112","22331113","42331111","11431114","31431112","14122114","34122112","23222113","43222111","12322114","32322112","21422113","41422111","24113113","13213114","33213112","22313113","42313111","11413114","31413112","25131112","14231113","34231111","23331112","12431113","32431111","15122113","24222112","13322113","33322111","22422112","11522113","31522111","25113112","14213113","34213111","23313112","12413113","32413111","21513112","15231112","24331111","13431112","16122112","25222111","14322112","23422111","12522112","15213112","24313111","13413112","22513111","11613112","21141115","41141113","61141111","11132116","31132114","51132112","21123115","41123113","61123111","11114116","31114114","51114112","22141114","42141112","11241115","31241113","51241111","12132115","32132113","52132111","21232114","41232112","22123114","42123112","11223115","31223113","51223111","12114115","32114113","52114111","21214114","41214112","23141113","43141111","12241114","32241112","21341113","41341111","13132114","33132112","22232113","42232111","11332114","31332112","23123113","43123111","12223114","32223112","21323113","41323111","13114114","33114112","22214113","42214111","11314114","31314112","24141112","13241113","33241111","22341112","14132113","34132111","23232112","12332113","32332111","21432112","24123112","13223113","33223111","22323112","11423113","31423111","14114113","34114111","23214112","12314113","32314111","21414112","25141111","14241112","23341111","15132112","24232111","13332112","22432111","25123111","14223112","23323111","12423112","21523111","15114112","24214111","13314112","22414111","11514112","15241111","16132111","14332111","15223111","13423111","16114111","14314111","12514111","21151114","41151112","11142115","31142113","51142111","21133114","41133112","11124115","31124113","51124111","21115114","41115112","22151113","42151111","11251114","31251112","12142114","32142112","21242113","41242111","22133113","42133111","11233114","31233112","12124114","32124112","21224113","41224111","22115113","42115111","11215114","31215112","23151112","12251113","32251111","13142113","33142111","22242112","11342113","31342111","23133112","12233113","32233111","21333112","13124113","33124111","22224112","11324113","31324111","23115112","12215113","32215111","21315112","24151111","13251112","14142112","23242111","12342112","24133111","13233112","22333111","11433112","14124112","23224111","12324112","21424111","24115111","13215112","22315111","11415112","14251111","15142111","13342111","14233111","12433111","15124111","13324111","11524111","14215111","12415111","21161113","41161111","11152114","31152112","21143113","41143111","11134114","31134112","21125113","41125111","11116114","31116112","22161112","12152113","32152111","21252112","22143112","11243113","31243111","12134113","32134111","21234112","22125112","11225113","31225111","12116113","32116111","21216112","23161111","13152112","22252111","23143111","12243112","21343111","13134112","22234111","11334112","23125111","12225112","21325111","13116112","22216111","11316112","14152111","13243111","14134111","12334111","13225111","11425111","14116111","12316111","41111215","61111213","21211126","41211124","61211122","22111216","42111214","31211215","51211213","22211125","42211123","11311126","31311124","51311122","23111215","43111213","12211216","32211214","52211212","21311215","41311213","61311211","23211124","43211122","12311125","32311123","52311121","21411124","41411122","24111214","13211215","33211213","22311214","42311212","11411215","31411213","51411211","24211123","13311124","33311122","22411123","42411121","11511124","31511122","25111213","14211214","34211212","23311213","43311211","12411214","32411212","21511213","41511211","25211122","14311123","34311121","23411122","12511123","32511121","21611122","15211213","24311212","13411213","33411211","22511212","11611213","31611211","31121125","51121123","21112126","41112124","61112122","21121216","41121214","61121212","31112215","51112213","12121126","32121124","52121122","21221125","41221123","61221121","22112125","42112123","11212126","22121215","42121213","11221216","31221214","51221212","12112216","32112214","52112212","21212215","41212213","61212211","13121125","33121123","22221124","42221122","11321125","31321123","51321121","23112124","43112122","12212125","23121214","43121212","12221215","32221213","52221211","21321214","41321212","13112215","33112213","22212214","42212212","11312215","31312213","51312211","14121124","34121122","23221123","43221121","12321124","32321122","21421123","41421121","24112123","13212124","24121213","13221214","33221212","11412124","22321213","42321211","11421214","31421212","14112214","34112212","23212213","43212211","12312214","32312212","21412213","41412211","15121123","24221122","13321123","33321121","22421122","11521123","31521121","25112122","14212123","25121212","14221213","34221211","12412123","23321212","12421213","32421211","21521212","15112213","24212212","13312213","33312211","22412212","11512213","31512211","16121122","25221121","14321122","23421121","12521122","15212122","15221212","13412122","24321211","13421212","11612122","22521211","16112212","25212211","14312212","23412211","12512212","21612211","11131126","31131124","51131122","21122125","41122123","61122121","21131215","41131213","61131211","11113126","31113124","51113122","11122216","31122214","51122212","21113215","41113213","61113211","12131125","32131123","52131121","21231124","41231122","22122124","42122122","11222125","22131214","42131212","11231215","31231213","51231211","12113125","32113123","52113121","12122215","32122213","52122211","21222214","41222212","22113214","42113212","11213215","31213213","51213211","13131124","33131122","22231123","42231121","11331124","31331122","23122123","43122121","12222124","23131213","43131211","12231214","32231212","21331213","41331211","13113124","33113122","13122214","33122212","11313124","22222213","42222211","11322214","31322212","23113213","43113211","12213214","32213212","21313213","41313211","14131123","34131121","23231122","12331123","32331121","21431122","24122122","13222123","24131212","13231213","33231211","11422123","22331212","11431213","31431211","14113123","34113121","14122213","34122211","12313123","23222212","12322213","32322211","21422212","24113212","13213213","33213211","22313212","11413213","31413211","15131122","24231121","13331122","22431121","25122121","14222122","25131211","14231212","12422122","23331211","12431212","15113122","15122212","13313122","24222211","13322212","11513122","22422211","11522212","25113211","14213212","23313211","12413212","21513211","16131121","14331121","15222121","15231211","13422121","13431211","16113121","16122211","14313121","14322211","12513121","12522211","15213211","13413211","11613211","11141125","31141123","51141121","21132124","41132122","21141214","41141212","11123125","31123123","51123121","11132215","31132213","51132211","21114124","41114122","21123214","41123212","11114215","31114213","51114211","12141124","32141122","21241123","41241121","22132123","42132121","11232124","22141213","42141211","11241214","31241212","12123124","32123122","12132214","32132212","21232213","41232211","22114123","42114121","11214124","22123213","42123211","11223214","31223212","12114214","32114212","21214213","41214211","13141123","33141121","22241122","11341123","31341121","23132122","12232123","23141212","12241213","32241211","21341212","13123123","33123121","13132213","33132211","11323123","22232212","11332213","31332211","23114122","12214123","23123212","12223213","32223211","21323212","13114213","33114211","22214212","11314213","31314211","14141122","23241121","12341122","24132121","13232122","24141211","13241212","11432122","22341211","14123122","14132212","12323122","23232211","12332212","21432211","24114121","13214122","24123211","13223212","11414122","22323211","11423212","14114212","23214211","12314212","21414211","15141121","13341121","14232121","14241211","12432121","15123121","15132211","13323121","13332211","11523121","14214121","14223211","12414121","12423211","15114211","13314211","11514211","11151124","31151122","21142123","41142121","21151213","41151211","11133124","31133122","11142214","31142212","21124123","41124121","21133213","41133211","11115124","31115122","11124214","31124212","21115213","41115211","12151123","32151121","21251122","22142122","11242123","22151212","11251213","31251211","12133123","32133121","12142213","32142211","21242212","22124122","11224123","22133212","11233213","31233211","12115123","32115121","12124213","32124211","21224212","22115212","11215213","31215211","13151122","22251121","23142121","12242122","23151211","12251212","13133122","13142212","11333122","22242211","11342212","23124121","12224122","23133211","12233212","21333211","13115122","13124212","11315122","22224211","11324212","23115211","12215212","21315211","14151121","13242121","13251211","14133121","14142211","12333121","12342211","13224121","13233211","11424121","11433211","14115121","14124211","12315121","12324211","13215211","11415211","11161123","31161121","21152122","21161212","11143123","31143121","11152213","31152211","21134122","21143212","11125123","31125121","11134213","31134211","21116122","21125212","12161122","22152121","11252122","22161211","12143122","12152212","21252211","22134121","11234122","22143211","11243212","12125122","12134212","21234211","22116121","11216122","22125211","11225212","13161121","12252121","13143121","13152211","11343121","12234121","12243211","13125121","13134211","11325121","11334211","12216121","12225211","31111225","51111223","21111316","41111314","61111312","31211134","51211132","12111226","32111224","52111222","21211225","41211223","61211221","22111315","42111313","11211316","31211314","51211312","12211135","32211133","52211131","21311134","41311132","13111225","33111223","22211224","42211222","11311225","31311223","51311221","23111314","43111312","12211315","32211313","52211311","21311314","41311312","13211134","33211132","22311133","42311131","11411134","31411132","14111224","34111222","23211223","43211221","12311224","32311222","21411223","41411221","24111313","13211314","33211312","22311313","42311311","11411314","31411312","14211133","34211131","23311132","12411133","32411131","21511132","15111223","24211222","13311223","33311221","22411222","11511223","31511221","25111312","14211313","34211311","23311312","12411313","32411311","21511312","15211132","24311131","13411132","22511131","11611132","16111222","25211221","14311222","23411221","12511222","21611221","15211312","24311311","13411312","22511311","11611312","21121135","41121133","61121131","11112136","31112134","51112132","11121226","31121224","51121222","21112225","41112223","61112221","21121315","41121313","61121311","11112316","31112314","51112312","22121134","42121132","11221135","31221133","51221131","12112135","32112133","52112131","12121225","32121223","52121221","21221224","41221222","22112224","42112222","11212225","22121314","42121312","11221315","31221313","51221311","12112315","32112313","52112311","21212314","41212312","23121133","43121131","12221134","32221132","21321133","41321131","13112134","33112132","13121224","33121222","11312134","22221223","42221221","11321224","31321222","23112223","43112221","12212224","23121313","43121311","12221314","32221312","21321313","41321311","13112314","33112312","22212313","42212311","11312314","31312312","24121132","13221133","33221131","22321132","11421133","31421131","14112133","34112131","14121223","34121221","12312133","23221222","12321223","32321221","21421222","24112222","13212223","24121312","13221313","33221311","11412223","22321312","11421313","31421311","14112313","34112311","23212312","12312313","32312311","21412312","25121131","14221132","23321131","12421132","21521131","15112132","15121222","13312132","24221221","13321222","11512132","22421221","11521222","25112221","14212222","25121311","14221312","12412222","23321311","12421312","21521311","15112312","24212311","13312312","22412311","11512312","15221131","13421131","16112131","16121221","14312131","14321221","12512131","12521221","15212221","15221311","13412221","13421311","11612221","16112311","14312311","12512311","21131134","41131132","11122135","31122133","51122131","11131225","31131223","51131221","21113134","41113132","21122224","41122222","21131314","41131312","11113225","31113223","51113221","11122315","31122313","51122311","21113314","41113312","22131133","42131131","11231134","31231132","12122134","32122132","12131224","32131222","21231223","41231221","22113133","42113131","11213134","22122223","42122221","11222224","22131313","42131311","11231314","31231312","12113224","32113222","12122314","32122312","21222313","41222311","22113313","42113311","11213314","31213312","23131132","12231133","32231131","21331132","13122133","33122131","13131223","33131221","11322133","22231222","11331223","31331221","23113132","12213133","23122222","12222223","23131312","12231313","32231311","21331312","13113223","33113221","13122313","33122311","11313223","22222312","11322313","31322311","23113312","12213313","32213311","21313312","24131131","13231132","22331131","11431132","14122132","14131222","12322132","23231221","12331222","21431221","24113131","13213132","24122221","13222222","24131311","11413132","13231312","11422222","22331311","11431312","14113222","14122312","12313222","23222311","12322312","21422311","24113311","13213312","22313311","11413312","14231131","12431131","15122131","15131221","13322131","13331221","11522131","14213131","14222221","12413131","14231311","12422221","12431311","15113221","15122311","13313221","13322311","11513221","11522311","14213311","12413311","21141133","41141131","11132134","31132132","11141224","31141222","21123133","41123131","21132223","41132221","21141313","41141311","11114134","31114132","11123224","31123222","11132314","31132312","21114223","41114221","21123313","41123311","11114314","31114312","22141132","11241133","31241131","12132133","32132131","12141223","32141221","21241222","22123132","11223133","22132222","11232223","22141312","11241313","31241311","12114133","32114131","12123223","32123221","12132313","32132311","21232312","22114222","11214223","22123312","11223313","31223311","12114313","32114311","21214312","23141131","12241132","21341131","13132132","13141222","11332132","22241221","11341222","23123131","12223132","23132221","12232222","23141311","12241312","21341311","13114132","13123222","11314132","13132312","11323222","22232311","11332312","23114221","12214222","23123311","12223312","21323311","13114312","22214311","11314312","13241131","14132131","14141221","12332131","12341221","13223131","13232221","11423131","13241311","11432221","14114131","14123221","12314131","14132311","12323221","12332311","13214221","13223311","11414221","11423311","14114311","12314311","21151132","11142133","31142131","11151223","31151221","21133132","21142222","21151312","11124133","31124131","11133223","31133221","11142313","31142311","21115132","21124222","21133312","11115223","31115221","11124313","31124311","22151131","11251132","12142132","12151222","21251221","22133131","11233132","22142221","11242222","22151311","11251312","12124132","12133222","12142312","21242311","22115131","11215132","22124221","11224222","22133311","11233312","12115222","12124312","21224311","12251131","13142131","13151221","11342131","12233131","12242221","12251311","13124131","13133221","11324131","13142311","11333221","11342311","12215131","12224221","12233311","13115221","13124311","11315221","11324311","21161131","11152132","11161222","21143131","21152221","21161311","11134132","11143222","11152312","21125131","21134221","21143311","11116132","11125222","11134312","12152131","12161221","11243131","11252221","12134131","12143221","12152311","11225131","11234221","11243311","12116131","12125221","12134311","21111235","41111233","61111231","11111326","31111324","51111322","21111415","41111413","61111411","21211144","41211142","22111234","42111232","11211235","31211233","51211231","12111325","32111323","52111321","21211324","41211322","22111414","42111412","11211415","31211413","51211411","22211143","42211141","11311144","31311142","23111233","43111231","12211234","32211232","21311233","41311231","13111324","33111322","22211323","42211321","11311324","31311322","23111413","43111411","12211414","32211412","21311413","41311411","23211142","12311143","32311141","21411142","24111232","13211233","33211231","22311232","11411233","31411231","14111323","34111321","23211322","12311323","32311321","21411322","24111412","13211413","33211411","22311412","11411413","31411411","24211141","13311142","22411141","11511142","25111231","14211232","23311231","12411232","21511231","15111322","24211321","13311322","22411321","11511322","25111411","14211412","23311411","12411412","21511411","14311141","12511141","15211231","13411231","11611231","16111321","14311321","12511321","15211411","13411411","11611411","31121143","51121141","21112144","41112142","21121234","41121232","11112235","31112233","51112231","11121325","31121323","51121321","21112324","41112322","21121414","41121412","11112415","31112413","51112411","12121144","32121142","21221143","41221141","22112143","42112141","11212144","22121233","42121231","11221234","31221232","12112234","32112232","12121324","32121322","21221323","41221321","22112323","42112321","11212324","22121413","42121411","11221414","31221412","12112414","32112412","21212413","41212411","13121143","33121141","22221142","11321143","31321141","23112142","12212143","23121232","12221233","32221231","21321232","13112233","33112231","13121323","33121321","11312233","22221322","11321323","31321321","23112322","12212323","23121412","12221413","32221411","21321412","13112413","33112411","22212412","11312413","31312411","14121142","23221141","12321142","21421141","24112141","13212142","24121231","13221232","11412142","22321231","11421232","14112232","14121322","12312232","23221321","12321322","21421321","24112321","13212322","24121411","13221412","11412322","22321411","11421412","14112412","23212411","12312412","21412411","15121141","13321141","11521141","14212141","14221231","12412141","12421231","15112231","15121321","13312231","13321321","11512231","11521321","14212321","14221411","12412321","12421411","15112411","13312411","11512411","11131144","31131142","21122143","41122141","21131233","41131231","11113144","31113142","11122234","31122232","11131324","31131322","21113233","41113231","21122323","41122321","21131413","41131411","11113324","31113322","11122414","31122412","21113413","41113411","12131143","32131141","21231142","22122142","11222143","22131232","11231233","31231231","12113143","32113141","12122233","32122231","12131323","32131321","21231322","22113232","11213233","22122322","11222323","22131412","11231413","31231411","12113323","32113321","12122413","32122411","21222412","22113412","11213413","31213411","13131142","22231141","11331142","23122141","12222142","23131231","12231232","21331231","13113142","13122232","11313142","13131322","11322232","22231321","11331322","23113231","12213232","23122321","12222322","23131411","12231412","21331411","13113322","13122412","11313322","22222411","11322412","23113411","12213412","21313411","14131141","12331141","13222141","13231231","11422141","11431231","14113141","14122231","12313141","14131321","12322231","12331321","13213231","13222321","11413231","13231411","11422321","11431411","14113321","14122411","12313321","12322411","13213411","11413411","11141143","31141141","21132142","21141232","11123143","31123141","11132233","31132231","11141323","31141321","21114142","21123232","21132322","21141412","11114233","31114231","11123323","31123321","11132413","31132411","21114322","21123412","12141142","21241141","22132141","11232142","22141231","11241232","12123142","12132232","12141322","21241321","22114141","11214142","22123231","11223232","22132321","11232322","22141411","11241412","12114232","12123322","12132412","21232411","22114321","11214322","22123411","11223412","13141141","11341141","12232141","12241231","13123141","13132231","11323141","13141321","11332231","11341321","12214141","12223231","12232321","12241411","13114231","13123321","11314231","13132411","11323321","11332411","12214321","12223411","11151142","21142141","21151231","11133142","11142232","11151322","21124141","21133231","21142321","21151411","11115142","11124232","11133322","11142412","21115231","21124321","21133411","12151141","11242141","11251231","12133141","12142231","12151321","11224141","11233231","11242321","11251411","12115141","12124231","12133321","12142411","11215231","11224321","11233411","11161141","11143141","11152231","11161321","11125141","11134231","11143321","11152411","11111245","31111243","51111241","21111334","41111332","11111425","31111423","51111421","21111514","41111512","31211152","12111244","32111242","21211243","41211241","22111333","42111331","11211334","31211332","12111424","32111422","21211423","41211421","22111513","42111511","11211514","31211512","12211153","32211151","21311152","13111243","33111241","22211242","11311243","31311241","23111332","12211333","32211331","21311332","13111423","33111421","22211422","11311423","31311421","23111512","12211513","32211511","21311512","13211152","22311151","11411152","14111242","23211241","12311242","21411241","24111331","13211332","22311331","11411332","14111422","23211421","12311422","21411421","24111511","13211512","22311511","11411512","14211151","12411151","15111241","13311241","11511241","14211331","12411331","15111421","13311421","11511421","14211511","12411511","21121153","41121151","11112154","31112152","11121244","31121242","21112243","41112241","21121333","41121331","11112334","31112332","11121424","31121422","21112423","41112421","21121513","41121511","11112514","31112512","22121152","11221153","31221151","12112153","32112151","12121243","32121241","21221242","22112242","11212243","22121332","11221333","31221331","12112333","32112331","12121423","32121421","21221422","22112422","11212423","22121512","11221513","31221511","12112513","32112511","21212512","23121151","12221152","21321151","13112152","13121242","11312152","22221241","11321242","23112241","12212242","23121331","12221332","21321331","13112332","13121422","11312332","22221421","11321422","23112421","12212422","23121511","12221512","21321511","13112512","22212511","11312512","13221151","11421151","14112151","14121241","12312151","12321241","13212241","13221331","11412241","11421331","14112331","14121421","12312331","12321421","13212421","13221511","11412421","11421511","14112511","12312511","21131152","11122153","31122151","11131243","31131241","21113152","21122242","21131332","11113243","31113241","11122333","31122331","11131423","31131421","21113332","21122422","21131512","11113423","31113421","11122513","31122511","22131151","11231152","12122152","12131242","21231241","22113151","11213152","22122241","11222242","22131331","11231332","12113242","12122332","12131422","21231421","22113331","11213332","22122421","11222422","22131511","11231512","12113422","12122512","21222511","12231151","13122151","13131241","11322151","11331241","12213151","12222241","12231331","13113241","13122331","11313241","13131421","11322331","11331421","12213331","12222421","12231511","13113421","13122511","11313421","11322511","21141151","11132152","11141242","21123151","21132241","21141331","11114152","11123242","11132332","11141422","21114241","21123331","21132421","21141511","11114332","11123422","11132512","11241151","12132151","12141241","11223151","11232241","11241331","12114151","12123241","12132331","12141421","11214241","11223331","11232421","11241511","12114331","12123421","12132511","11142151","11151241","11124151","11133241","11142331","11151421","11115241","11124331","11133421","11142511","21111253","41111251","11111344","31111342","21111433","41111431","11111524","31111522","21111613","41111611","21211162","22111252","11211253","31211251","12111343","32111341","21211342","22111432","11211433","31211431","12111523","32111521","21211522","22111612","11211613","31211611","22211161","11311162","23111251","12211252","21311251","13111342","22211341","11311342","23111431","12211432","21311431","13111522","22211521","11311522","23111611","12211612","21311611","12311161","13211251","11411251","14111341","12311341","13211431","11411431","14111521","12311521","13211611","11411611","31121161","21112162","21121252","11112253","31112251","11121343","31121341","21112342","21121432","11112433","31112431","11121523","31121521","21112522","21121612","12121162","21221161","22112161","11212162","22121251","11221252","12112252","12121342","21221341","22112341","11212342","22121431","11221432","12112432","12121522","21221521","22112521","11212522","22121611","11221612","13121161","11321161","12212161","12221251","13112251","13121341","11312251","11321341","12212341","12221431","13112431","13121521","11312431","11321521","12212521","12221611","11131162","21122161","21131251","11113162"])]);$ctx.parity=$a(["1001","0101","1100","0011","1010","0110","1111","0000"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_code49.$ctx[id]=$ctx[id]);bwipp_code49.__15616__=1})()}$1.rowbits=$a($1.r);for(var _6C=0,_6B=$f($1.r-1);_6C<=_6B;_6C+=1){$1.i=_6C;$k[$j++]="p";if($1.i!=$f($1.r-1)){$k[$j++]=$g($1.parity,$1.i)}else{$k[$j++]="0000"}var _6I=$k[--$j];$1[$k[--$j]]=_6I;$1.ccrow=$G($1.ccs,$1.i*8,8);$k[$j++]=Infinity;for(var _6N=0;_6N<=7;_6N+=2){$q($G($1.ccrow,_6N,2));var _6Q=$k[--$j];var _6R=$k[--$j];$k[$j++]=$f(_6Q+_6R*49)}$1.scrow=$a();$k[$j++]=Infinity;$k[$j++]=10;$k[$j++]=1;$k[$j++]=1;for(var _6T=0;_6T<=3;_6T+=1){$1.j=_6T;$F($g($g($1.patterns,$f($g($1.p,$1.j)-48)),$g($1.scrow,$1.j)),function(){var _6d=$k[--$j];$k[$j++]=$f(_6d-48)})}$k[$j++]=4;$k[$j++]=1;$1.sbs=$a();$k[$j++]=Infinity;var _6f=$1.sbs;$k[$j++]=1;for(var _6g=0,_6h=_6f.length;_6g<_6h;_6g++){var _6j=$k[--$j];var _6k=_6j==0?1:0;$k[$j++]=_6j;for(var _6l=0,_6m=$g(_6f,_6g);_6l<_6m;_6l++){$k[$j++]=_6k}}$as($a($m()-1));var _6p=$k[--$j];var _6q=$k[--$j];$k[$j++]=_6p;$k[$j++]=_6q;$j--;var _6r=$k[--$j];var _6s=$k[--$j];$k[$j++]=_6r;$k[$j++]=_6s;$j--;$p($1.rowbits,$1.i,$k[--$j])}$k[$j++]=Infinity;for(var _6x=0,_6y=81*$1.sepheight;_6x<_6y;_6x++){$k[$j++]=1}for(var _71=0,_70=$f($1.r-2);_71<=_70;_71+=1){$1.i=_71;for(var _73=0,_74=$1.rowheight;_73<_74;_73++){$q($g($1.rowbits,$1.i))}for(var _79=0,_7A=$1.sepheight;_79<_7A;_79++){for(var _7B=0,_7C=10;_7B<_7C;_7B++){$k[$j++]=0}for(var _7D=0,_7E=70;_7D<_7E;_7D++){$k[$j++]=1}$k[$j++]=0}}for(var _7G=0,_7H=$1.rowheight;_7G<_7H;_7G++){$q($g($1.rowbits,$f($1.r-1)))}for(var _7M=0,_7N=81*$1.sepheight;_7M<_7N;_7M++){$k[$j++]=1}$1.pixs=$a();var _7T=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",81],["pixy",~~($1.pixs.length/81)],["height",~~($1.pixs.length/81)/72],["width",81/72],["opt",$1.options]]);$k[$j++]=_7T;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_flattermarken(){var $1=Object.create(bwipp_flattermarken.$ctx||(bwipp_flattermarken.$ctx={}));$1.dontdraw=false;$1.includetext=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.height=.3;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$F($1.barcode,function(){var _3=$k[--$j];if(_3<48||_3>57){$k[$j++]="bwipp.flattermarkenBadCharacter#15978";$k[$j++]="Flattermarken must contain only digits";bwipp_raiseerror()}});if(!bwipp_flattermarken.__15991__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["0018","0117","0216","0315","0414","0513","0612","0711","0810","0900"]);$ctx.barchars="1234567890";for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_flattermarken.$ctx[id]=$ctx[id]);bwipp_flattermarken.__15991__=1})()}$1.barlen=$1.barcode.length;$1.sbs=$s($1.barlen*4);$1.txt=$a($1.barlen);for(var _D=0,_C=$1.barlen-1;_D<=_C;_D+=1){$1.i=_D;$X($1.barchars,$G($1.barcode,$1.i,1));$j--;$1.indx=$k[--$j].length;$j-=2;$1.enc=$g($1.encs,$1.indx);$P($1.sbs,$1.i*4,$1.enc);$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),$1.i*9,$1.textyoffset,$1.textfont,$1.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _Z=$1.sbs;for(var _a=0,_b=_Z.length;_a<_b;_a++){$k[$j++]=$g(_Z,_a)-48}var _d=$a();$k[$j++]=Infinity;for(var _f=0,_g=~~(($1.sbs.length+1)/2);_f<_g;_f++){$k[$j++]=$1.height}var _i=$a();$k[$j++]=Infinity;for(var _k=0,_l=~~(($1.sbs.length+1)/2);_k<_l;_k++){$k[$j++]=0}var _m=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_d;$k[$j++]="bhs";$k[$j++]=_i;$k[$j++]="bbs";$k[$j++]=_m;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="opt";$k[$j++]=$1.options;var _p=$d();$k[$j++]=_p;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_raw(){var $1=Object.create(bwipp_raw.$ctx||(bwipp_raw.$ctx={}));$1.dontdraw=false;$1.height=1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$F($1.barcode,function(){var _3=$k[--$j];if(_3<49||_3>57){$k[$j++]="bwipp.rawBadCharacter#16064";$k[$j++]="Raw must contain only digits 1 to 9";bwipp_raiseerror()}});$k[$j++]=Infinity;$k[$j++]=Infinity;$F($1.barcode,function(){var _5=$k[--$j];$k[$j++]=$f(_5-48)});var _6=$a();$k[$j++]=Infinity;for(var _8=0,_9=~~(($1.barcode.length+1)/2);_8<_9;_8++){$k[$j++]=$1.height}var _B=$a();$k[$j++]=Infinity;for(var _D=0,_E=~~(($1.barcode.length+1)/2);_D<_E;_D++){$k[$j++]=0}var _F=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_6;$k[$j++]="bhs";$k[$j++]=_B;$k[$j++]="bbs";$k[$j++]=_F;$k[$j++]="opt";$k[$j++]=$1.options;var _H=$d();$k[$j++]=_H;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_daft(){var $1=Object.create(bwipp_daft.$ctx||(bwipp_daft.$ctx={}));$1.dontdraw=false;$1.height=.175;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$F($1.barcode,function(){var _3=$k[--$j];if(_3!=68&&(_3!=65&&(_3!=70&&_3!=84))){$k[$j++]="bwipp.daftBadCharacter#16118";$k[$j++]="DAFT must contain only characters D, A, F and T";bwipp_raiseerror()}});$1.barlen=$1.barcode.length;$1.bbs=$a($1.barlen);$1.bhs=$a($1.barlen);for(var _B=0,_A=$1.barlen-1;_B<=_A;_B+=1){$1.i=_B;$1.enc=$G($1.barcode,$1.i,1);if($eq($1.enc,"D")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"A")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,5*$1.height/8)}if($eq($1.enc,"F")){$p($1.bbs,$1.i,0*$1.height/8);$p($1.bhs,$1.i,8*$1.height/8)}if($eq($1.enc,"T")){$p($1.bbs,$1.i,3*$1.height/8);$p($1.bhs,$1.i,2*$1.height/8)}}$k[$j++]=Infinity;var _h=$1.bbs;var _i=$1.bhs;$k[$j++]=Infinity;for(var _k=0,_l=$1.bhs.length-1;_k<_l;_k++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _m=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="bbs";$k[$j++]=_h;$k[$j++]="bhs";$k[$j++]=_i;$k[$j++]="sbs";$k[$j++]=_m;$k[$j++]="opt";$k[$j++]=$1.options;var _o=$d();$k[$j++]=_o;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_symbol(){var $1=Object.create(bwipp_symbol.$ctx||(bwipp_symbol.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _H=new Map([["fima",function(){$1.sbs=$a([2.25,2.25,2.25,11.25,2.25,11.25,2.25,2.25,2.25]);$1.bhs=$a([.625,.625,.625,.625,.625]);$1.bbs=$a([0,0,0,0,0])}],["fimb",function(){$1.sbs=$a([2.25,6.75,2.25,2.25,2.25,6.25,2.25,2.25,2.25,6.75,2.25]);$1.bhs=$a([.625,.625,.625,.625,.625,.625]);$1.bbs=$a([0,0,0,0,0,0])}],["fimc",function(){$1.sbs=$a([2.25,2.25,2.25,6.75,2.25,6.75,2.25,6.75,2.25,2.25,2.25]);$1.bhs=$a([.625,.625,.625,.625,.625,.625]);$1.bbs=$a([0,0,0,0,0,0])}],["fimd",function(){$1.sbs=$a([2.25,2.25,2.25,2.25,2.25,6.75,2.25,6.75,2.25,2.25,2.25,2.25,2.25]);$1.bhs=$a([.625,.625,.625,.625,.625,.625,.625]);$1.bbs=$a([0,0,0,0,0,0,0])}],["fime",function(){$1.sbs=$a([2.25,6.75,2.25,15.75,2.25,6.75,2.25]);$1.bhs=$a([.625,.625,.625,.625,.625,.625,.625]);$1.bbs=$a([0,0,0,0,0,0,0])}]]);$1.symbols=_H;var _K=$g($1.symbols,$1.barcode)!==undefined;if(!_K){$k[$j++]="bwipp.symbolUnknownSymbol#16224";$k[$j++]="Unknown symbol name provided";bwipp_raiseerror()}if($g($1.symbols,$1.barcode)()===true){return true}var _S=new Map([["ren",bwipp_renlinear],["sbs",$1.sbs],["bhs",$1.bhs],["bbs",$1.bbs],["opt",$1.options]]);$k[$j++]=_S;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_pdf417(){var $1=Object.create(bwipp_pdf417.$ctx||(bwipp_pdf417.$ctx={}));$1.dontdraw=false;$1.compact=false;$1.eclevel=-1;$1.columns=0;$1.rows=0;$1.rowmult=3;$1.ccc=false;$1.raw=false;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.pdf417emptyData#16289";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($1.eclevel!=-1&&($1.eclevel<0||$1.eclevel>8)){$k[$j++]="bwipp.pdf417InvalidErrorCorrectionLevel#16293";$k[$j++]="Valid error correction levels are 0 to 8";bwipp_raiseerror()}if($1.ccc&&$1.raw){$k[$j++]="bwipp.pdf417cccAndRaw#16297";$k[$j++]="Cannot combine ccc and raw";bwipp_raiseerror()}if($1.ccc&&$1.compact){$k[$j++]="bwipp.pdf417cccAndCompact#16301";$k[$j++]="Cannot combine ccc and compact";bwipp_raiseerror()}if($1.rows!=0&&($1.rows<3||$1.rows>90)){$k[$j++]="bwipp.pdf417invalidRows#16305";$k[$j++]="There must be between 3 and 90 rows";bwipp_raiseerror()}if($1.columns!=0&&($1.columns<1||$1.columns>30)){$k[$j++]="bwipp.pdf417invalidColumns#16309";$k[$j++]="There must be between 1 and 30 columns";bwipp_raiseerror()}if($1.rowmult<=0){$k[$j++]="bwipp.pdf417badRowMult#16313";$k[$j++]="The row multiplier must be greater than zero";bwipp_raiseerror()}if(!bwipp_pdf417.__16407__){(function(){var $ctx=Object.create($1);$ctx.T=0;$ctx.N=1;$ctx.B=2;$ctx.A=0;$ctx.L=1;$ctx.M=2;$ctx.P=3;$ctx.tl=-1;$ctx.nl=-2;$ctx.bl=-3;$ctx.bl6=-4;$ctx.bs=-5;$ctx.al=-6;$ctx.ll=-7;$ctx.ml=-8;$ctx.pl=-9;$ctx.as=-10;$ctx.ps=-11;$ctx.charmaps=$a([$a(["A","a","0",";"]),$a(["B","b","1","<"]),$a(["C","c","2",">"]),$a(["D","d","3","@"]),$a(["E","e","4","["]),$a(["F","f","5",92]),$a(["G","g","6","]"]),$a(["H","h","7","_"]),$a(["I","i","8","`"]),$a(["J","j","9","~"]),$a(["K","k","&","!"]),$a(["L","l",13,13]),$a(["M","m",9,9]),$a(["N","n",",",","]),$a(["O","o",":",":"]),$a(["P","p","#",10]),$a(["Q","q","-","-"]),$a(["R","r",".","."]),$a(["S","s","$","$"]),$a(["T","t","/","/"]),$a(["U","u","+",'"']),$a(["V","v","%","|"]),$a(["W","w","*","*"]),$a(["X","x","=",40]),$a(["Y","y","^",41]),$a(["Z","z",$ctx.pl,"?"]),$a([" "," "," ","{"]),$a([$ctx.ll,$ctx.as,$ctx.ll,"}"]),$a([$ctx.ml,$ctx.ml,$ctx.al,"'"]),$a([$ctx.ps,$ctx.ps,$ctx.ps,$ctx.al])]);$ctx.charvals=$a([new Map,new Map,new Map,new Map]);$ctx.alltext=new Map;for(var _10=0,_z=$ctx.charmaps.length-1;_10<=_z;_10+=1){$ctx.i=_10;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _14=0;_14<=3;_14+=1){$ctx.j=_14;var _17=$g($ctx.encs,$ctx.j);$k[$j++]=_17;if($eq($t(_17),"stringtype")){var _1A=$g($k[--$j],0);$k[$j++]=_1A}var _1B=$k[--$j];$p($g($ctx.charvals,$ctx.j),_1B,$ctx.i);$p($ctx.alltext,_1B,-1)}}$ctx.e=1e4;$ctx.latlen=$a([$a([0,1,1,2]),$a([2,0,1,2]),$a([1,1,0,1]),$a([1,2,2,0])]);$ctx.latseq=$a([$a([$a([]),$a([$ctx.ll]),$a([$ctx.ml]),$a([$ctx.ml,$ctx.pl])]),$a([$a([$ctx.ml,$ctx.al]),$a([]),$a([$ctx.ml]),$a([$ctx.ml,$ctx.pl])]),$a([$a([$ctx.al]),$a([$ctx.ll]),$a([]),$a([$ctx.pl])]),$a([$a([$ctx.al]),$a([$ctx.al,$ctx.ll]),$a([$ctx.al,$ctx.ml]),$a([])])]);$ctx.shftlen=$a([$a([$ctx.e,$ctx.e,$ctx.e,1]),$a([1,$ctx.e,$ctx.e,1]),$a([$ctx.e,$ctx.e,$ctx.e,1]),$a([$ctx.e,$ctx.e,$ctx.e,$ctx.e])]);$k[$j++]=Infinity;$k[$j++]=$ctx.tl;$k[$j++]=900;$k[$j++]=$ctx.bl;$k[$j++]=901;$k[$j++]=$ctx.bl6;$k[$j++]=924;$k[$j++]=$ctx.nl;$k[$j++]=902;$k[$j++]=$ctx.bs;$k[$j++]=913;$ctx.latchcws=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_pdf417.$ctx[id]=$ctx[id]);bwipp_pdf417.__16407__=1})()}if($1.raw){$1.datcws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.barcode.length-3){break}if($g($1.barcode,$1.i)!=94){break}var _2W=$G($1.barcode,$1.i+1,3);$k[$j++]=_2W;$k[$j++]=false;for(var _2X=0,_2Y=_2W.length;_2X<_2Y;_2X++){var _2Z=$g(_2W,_2X);if(_2Z<48||_2Z>57){$j--;$k[$j++]=true}}if($k[--$j]){$j--;break}$1.cw=$i($k[--$j]);$p($1.datcws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}if($1.i!=$1.barcode.length){$k[$j++]="bwipp.pdf417badRawFormat#16425";$k[$j++]="raw data must be formatted as ^NNN";bwipp_raiseerror()}$1.datcws=$G($1.datcws,0,$1.j)}$1.encb=function(){$1.in=$k[--$j];$1.inlen=$1.in.length;$1.out=$a(~~($1.inlen/6)*5+$1.inlen%6);for(var _2t=0,_2s=~~($1.inlen/6)-1;_2t<=_2s;_2t+=1){$1.k=_2t;$k[$j++]=Infinity;$q($G($1.in,$1.k*6,3));$1.msbs=$a();$k[$j++]=Infinity;$q($1.msbs);var _2z=$k[--$j];var _30=$k[--$j];var _31=$k[--$j];$k[$j++]=$f($f(_2z+_30*256)+_31*65536);for(var _32=0,_33=3;_32<_33;_32++){var _34=$k[--$j];$k[$j++]=_34%900;$k[$j++]=~~(_34/900)}$1.mscs=$a();$k[$j++]=Infinity;$q($G($1.in,$1.k*6+3,3));$1.lsbs=$a();$k[$j++]=Infinity;$q($1.lsbs);var _3B=$k[--$j];var _3C=$k[--$j];var _3D=$k[--$j];$k[$j++]=$f($f(_3B+_3C*256)+_3D*65536);for(var _3E=0,_3F=3;_3E<_3F;_3E++){var _3G=$k[--$j];$k[$j++]=_3G%900;$k[$j++]=~~(_3G/900)}$1.lscs=$a();var _3J=$g($1.lscs,0);var _3L=$g($1.mscs,0);$p($1.out,$1.k*5+4,$f(_3J+_3L*316)%900);var _3P=$g($1.lscs,1);var _3R=$g($1.mscs,0);var _3T=$g($1.mscs,1);$p($1.out,$1.k*5+3,$f($f($f(~~($f(_3J+_3L*316)/900)+_3P)+_3R*641)+_3T*316)%900);var _3X=$g($1.lscs,2);var _3Z=$g($1.mscs,0);var _3b=$g($1.mscs,1);var _3d=$g($1.mscs,2);$p($1.out,$1.k*5+2,$f($f($f($f(~~($f($f($f(~~($f(_3J+_3L*316)/900)+_3P)+_3R*641)+_3T*316)/900)+_3X)+_3Z*20)+_3b*641)+_3d*316)%900);var _3h=$g($1.lscs,3);var _3j=$g($1.mscs,1);var _3l=$g($1.mscs,2);$p($1.out,$1.k*5+1,$f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_3J+_3L*316)/900)+_3P)+_3R*641)+_3T*316)/900)+_3X)+_3Z*20)+_3b*641)+_3d*316)/900)+_3h)+_3j*20)+_3l*641)%900);$p($1.out,$1.k*5,$f(~~($f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_3J+_3L*316)/900)+_3P)+_3R*641)+_3T*316)/900)+_3X)+_3Z*20)+_3b*641)+_3d*316)/900)+_3h)+_3j*20)+_3l*641)/900)+$g($1.mscs,2)*20)%900)}$1.rem=$1.inlen%6;if($1.rem!=0){$k[$j++]=$1.out;$k[$j++]=$1.out.length-$1.rem;$k[$j++]=Infinity;$q($G($1.in,$1.inlen-$1.rem,$1.rem));var _42=$a();var _43=$k[--$j];$P($k[--$j],_43,_42)}$k[$j++]=$1.out};if($1.ccc){$1.barlen=$1.barcode.length;$1.datcws=$a(~~($1.barlen/6)*5+$1.barlen%6+2);$p($1.datcws,0,920);var _4E=$1.barlen%6==0?924:901;$p($1.datcws,1,_4E);$k[$j++]=$1.datcws;$k[$j++]=2;$k[$j++]=Infinity;$F($1.barcode);var _4H=$a();$k[$j++]=_4H;$1.encb();var _4I=$k[--$j];var _4J=$k[--$j];$P($k[--$j],_4J,_4I)}if(!$1.raw&&!$1.ccc){var _4P=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true]]);$1.fncvals=_4P;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _4S=$k[--$j];$1[$k[--$j]]=_4S;$1.msglen=$1.msg.length;$k[$j++]=Infinity;for(var _4W=0,_4X=$1.msglen;_4W<_4X;_4W++){$k[$j++]=0}$k[$j++]=0;$1.numdigits=$a();$k[$j++]=Infinity;for(var _4a=0,_4b=$1.msglen;_4a<_4b;_4a++){$k[$j++]=0}$k[$j++]=0;$1.numtext=$a();$k[$j++]=Infinity;for(var _4e=0,_4f=$1.msglen;_4e<_4f;_4e++){$k[$j++]=0}$k[$j++]=0;$1.numbytes=$a();$k[$j++]=Infinity;for(var _4i=0,_4j=$1.msglen;_4i<_4j;_4i++){$k[$j++]=0}$k[$j++]=0;$1.iseci=$a();for(var _4m=$1.msglen-1;_4m>=0;_4m-=1){$1.i=_4m;var _4p=$g($1.msg,$1.i);if(_4p>=48&&_4p<=57){$p($1.numdigits,$1.i,$f($g($1.numdigits,$1.i+1)+1))}var _4z=$g($1.alltext,$g($1.msg,$1.i))!==undefined;if(_4z&&$g($1.numdigits,$1.i)<13){$p($1.numtext,$1.i,$f($g($1.numtext,$1.i+1)+1))}if($g($1.msg,$1.i)>=0&&$g($1.numtext,$1.i)<5&&$g($1.numdigits,$1.i)<13){$p($1.numbytes,$1.i,$f($g($1.numbytes,$1.i+1)+1))}$p($1.iseci,$1.i,$g($1.msg,$1.i)<=-1e6)}$1.numdigits=$G($1.numdigits,0,$1.msglen);$1.numtext=$G($1.numtext,0,$1.msglen);$1.numbytes=$G($1.numbytes,0,$1.msglen);$1.seq=$a([]);$1.seqlen=0;$1.state=$1.T;$1.p=0;for(;;){if($1.p==$1.msglen){break}if($g($1.iseci,$1.p)){$1.eci=$g($1.msg,$1.p);$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$a([$1.eci]);$1.seq=$a();$1.p=$1.p+1;$k[$j++]="seqlen";$k[$j++]=$1.seqlen;if($1.eci<=-1810900){$k[$j++]=2}else{var _5s=$1.eci<=-1000900?3:2;$k[$j++]=_5s}var _5t=$k[--$j];var _5u=$k[--$j];$1[$k[--$j]]=$f(_5u+_5t)}else{$1.n=$g($1.numdigits,$1.p);if($1.n>=13||$1.n==$1.msglen&&$1.n>=8){$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$1.nl;$k[$j++]=Infinity;$q($G($1.msg,$1.p,$1.n));var _69=$a();$k[$j++]=_69;$1.seq=$a();$1.state=$1.N;$1.p=$f($1.p+$1.n);$1.seqlen=$f($1.seqlen+1+$1.n)}else{$1.t=$g($1.numtext,$1.p);if($1.t>=5){$k[$j++]=Infinity;$q($1.seq);if($1.state!=$1.T){$k[$j++]=$1.tl}$k[$j++]=Infinity;$q($G($1.msg,$1.p,$1.t));var _6S=$a();$k[$j++]=_6S;$1.seq=$a();$1.state=$1.T;$1.p=$f($1.p+$1.t);$1.seqlen=$f($f($1.seqlen+1)+$1.t)}else{$1.b=$g($1.numbytes,$1.p);if($1.b==1&&$1.state==$1.T){$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$1.bs;$k[$j++]=$a([$g($1.msg,$1.p)]);$1.seq=$a();$1.p=$f($1.p+$1.b);$1.seqlen=$f($1.seqlen+2)}else{$k[$j++]=Infinity;$q($1.seq);var _6r=$1.b%6!=0?$1.bl:$1.bl6;$k[$j++]=_6r;$k[$j++]=Infinity;$q($G($1.msg,$1.p,$1.b));var _6w=$a();$k[$j++]=_6w;$1.seq=$a();$1.state=$1.B;$1.p=$f($1.p+$1.b);$1.seqlen=$f($f($1.seqlen+1)+$1.b)}}}}}$1.enca=function(){var _77=$g($g($1.charvals,$1.A),$k[--$j]);$k[$j++]=_77};$1.encl=function(){var _7C=$g($g($1.charvals,$1.L),$k[--$j]);$k[$j++]=_7C};$1.encm=function(){var _7H=$g($g($1.charvals,$1.M),$k[--$j]);$k[$j++]=_7H};$1.encp=function(){var _7M=$g($g($1.charvals,$1.P),$k[--$j]);$k[$j++]=_7M};$1.textencfuncs=$a(["enca","encl","encm","encp"]);$1.addtotext=function(){$p($1.text,$1.l,$k[--$j]);$1.l=$1.l+1};$1.enct=function(){$1.in=$k[--$j];$1.curlen=$a([$1.e,$1.e,$1.e,$1.e]);$p($1.curlen,$1.submode,0);$1.curseq=$a([$a([]),$a([]),$a([]),$a([])]);$F($1.in,function(){$1.char=$k[--$j];for(;;){$1.imp=false;var _7l=$a([$1.A,$1.L,$1.M,$1.P]);for(var _7m=0,_7n=_7l.length;_7m<_7n;_7m++){$1.x=$g(_7l,_7m);var _7t=$a([$1.A,$1.L,$1.M,$1.P]);for(var _7u=0,_7v=_7t.length;_7u<_7v;_7u++){$1.y=$g(_7t,_7u);$1.cost=$f($g($1.curlen,$1.x)+$g($g($1.latlen,$1.x),$1.y));if($1.cost<$g($1.curlen,$1.y)){$p($1.curlen,$1.y,$1.cost);$k[$j++]=$1.curseq;$k[$j++]=$1.y;$k[$j++]=Infinity;$q($g($1.curseq,$1.x));$q($g($g($1.latseq,$1.x),$1.y));var _8M=$a();var _8N=$k[--$j];$p($k[--$j],_8N,_8M);$1.imp=true}}}if(!$1.imp){break}}$1.nxtlen=$a([$1.e,$1.e,$1.e,$1.e]);$1.nxtseq=$a(4);var _8a=$a([$1.A,$1.L,$1.M,$1.P]);for(var _8b=0,_8c=_8a.length;_8b<_8c;_8b++){$1.x=$g(_8a,_8b);for(;;){var _8i=$g($g($1.charvals,$1.x),$1.char)!==undefined;if(!_8i){break}$1.cost=$f($g($1.curlen,$1.x)+1);if($1.cost<$g($1.nxtlen,$1.x)){$p($1.nxtlen,$1.x,$1.cost);$k[$j++]=$1.nxtseq;$k[$j++]=$1.x;$k[$j++]=Infinity;$q($g($1.curseq,$1.x));$k[$j++]=$1.char;var _8z=$a();var _90=$k[--$j];$p($k[--$j],_90,_8z)}var _96=$a([$1.A,$1.L,$1.M,$1.P]);for(var _97=0,_98=_96.length;_97<_98;_97++){$1.y=$g(_96,_97);if($ne($1.x,$1.y)){$1.cost=$f($f($g($1.curlen,$1.y)+$g($g($1.shftlen,$1.y),$1.x))+1);if($1.cost<$g($1.nxtlen,$1.y)){$p($1.nxtlen,$1.y,$1.cost);$k[$j++]=$1.nxtseq;$k[$j++]=$1.y;$k[$j++]=Infinity;$q($g($1.curseq,$1.y));var _9Y=$1.x==$1.A?$1.as:$1.ps;$k[$j++]=_9Y;$k[$j++]=$1.char;var _9a=$a();var _9b=$k[--$j];$p($k[--$j],_9b,_9a)}}}break}}$1.curlen=$1.nxtlen;$1.curseq=$1.nxtseq});$1.minseq=$1.e;var _9k=$a([$1.A,$1.L,$1.M,$1.P]);for(var _9l=0,_9m=_9k.length;_9l<_9m;_9l++){$1.k=$g(_9k,_9l);if($g($1.curlen,$1.k)<$1.minseq){$1.minseq=$g($1.curlen,$1.k);$1.txtseq=$g($1.curseq,$1.k)}}$1.text=$a($1.minseq);$1.k=0;$1.l=0;for(;;){if($1.k>=$1.txtseq.length){break}$1.char=$g($1.txtseq,$1.k);$k[$j++]=$1.char;if($1[$g($1.textencfuncs,$1.submode)]()===true){break}$1.addtotext();$1.k=$1.k+1;if($1.char==$1.as||$1.char==$1.ps){$k[$j++]=$g($1.txtseq,$1.k);if($1.char==$1.as){$1.enca()}else{$1.encp()}$1.addtotext();$1.k=$1.k+1}if($1.char==$1.al){$1.submode=$1.A}if($1.char==$1.ll){$1.submode=$1.L}if($1.char==$1.ml){$1.submode=$1.M}if($1.char==$1.pl){$1.submode=$1.P}}if($1.text.length%2==1){if($1.submode==$1.P){$k[$j++]="pad";$k[$j++]=$1.al;$1.encp();var _Ab=$k[--$j];$1[$k[--$j]]=_Ab;$1.submode=$1.A}else{$1.nextecitext=false;for(var _Ah=$1.i+1,_Ag=$1.seq.length-1;_Ah<=_Ag;_Ah+=1){$1.ti=_Ah;if($ne($t($g($1.seq,$1.ti)),"arraytype")){$1.nextecitext=false;break}if($g($g($1.seq,$1.ti),0)>-1e6){break}$1.nextecitext=true}if($1.nextecitext){if($1.submode==$1.A){var _B0=$g($g($1.charvals,$1.L),$g($g($1.seq,$1.ti),0))!==undefined;if(_B0){$k[$j++]="pad";$k[$j++]=$1.ll;$1.enca();var _B2=$k[--$j];$1[$k[--$j]]=_B2;$1.submode=$1.L}else{$k[$j++]="pad";$k[$j++]=$1.ml;$1.enca();var _B6=$k[--$j];$1[$k[--$j]]=_B6;$1.submode=$1.M}}else{if($1.submode==$1.M){var _BI=$g($g($1.charvals,$1.L),$g($g($1.seq,$1.ti),0))!==undefined;if(_BI){$k[$j++]="pad";$k[$j++]=$1.ll;$1.encm();var _BK=$k[--$j];$1[$k[--$j]]=_BK;$1.submode=$1.L}else{var _BU=$g($g($1.charvals,$1.P),$g($g($1.seq,$1.ti),0))!==undefined;if(_BU){$k[$j++]="pad";$k[$j++]=$1.pl;$1.encm();var _BW=$k[--$j];$1[$k[--$j]]=_BW;$1.submode=$1.P}else{$k[$j++]="pad";$k[$j++]=$1.al;$1.encm();var _Ba=$k[--$j];$1[$k[--$j]]=_Ba;$1.submode=$1.A}}}else{$k[$j++]="pad";$k[$j++]=$1.ml;$1.encl();var _Be=$k[--$j];$1[$k[--$j]]=_Be;$1.submode=$1.M}}}else{$k[$j++]="pad";$k[$j++]=$1.ps;if($1[$g($1.textencfuncs,$1.submode)]()===true){return true}var _Bm=$k[--$j];$1[$k[--$j]]=_Bm}}$k[$j++]=Infinity;$q($1.text);$k[$j++]=$1.pad;$1.text=$a()}$1.out=$a(~~($1.text.length/2));for(var _Bv=0,_Bu=$1.out.length-1;_Bv<=_Bu;_Bv+=1){$1.k=_Bv;$p($1.out,$1.k,$f($g($1.text,$1.k*2)*30+$g($1.text,$1.k*2+1)))}$k[$j++]=$1.out};$1.encn=function(){$1.in=$k[--$j];$1.out=$a([]);for(var _C9=0,_C8=$1.in.length-1;_C9<=_C8;_C9+=44){$1.k=_C9;$k[$j++]=Infinity;var _CE=$1.in.length-$1.k;$k[$j++]=1;$k[$j++]=$1.in;$k[$j++]=$1.k;$k[$j++]=_CE;if(_CE>44){$j--;$k[$j++]=44}var _CF=$k[--$j];var _CG=$k[--$j];var _CI=$G($k[--$j],_CG,_CF);for(var _CJ=0,_CK=_CI.length;_CJ<_CK;_CJ++){$k[$j++]=$f($g(_CI,_CJ)-48)}$1.gmod=$a();$1.cwn=$a([]);for(;;){$1.dv=900;$1.gmul=$a([]);$1.val=0;for(;;){if($1.gmod.length==0){break}$1.val=$f($1.val*10+$g($1.gmod,0));$1.gmod=$G($1.gmod,1,$1.gmod.length-1);if($1.val<$1.dv){if($1.gmul.length!=0){$k[$j++]=Infinity;$q($1.gmul);$k[$j++]=0;$1.gmul=$a()}}else{$k[$j++]=Infinity;$q($1.gmul);$k[$j++]=~~($1.val/$1.dv);$1.gmul=$a()}$1.val=$1.val%$1.dv}$1.dv=$1.val;$k[$j++]=Infinity;$k[$j++]=$1.dv;$q($1.cwn);$1.cwn=$a();$1.gmod=$1.gmul;if($1.gmul.length==0){break}}$k[$j++]=Infinity;$q($1.out);$q($1.cwn);$1.out=$a()}$k[$j++]=$1.out};$1.ence=function(){var _Ct=$f(-$g($k[--$j],0)-1e6);$k[$j++]=_Ct;if(_Ct<=899){var _Cu=$k[--$j];$k[$j++]=927;$k[$j++]=_Cu;$as($a(2))}else{var _Cw=$k[--$j];$k[$j++]=_Cw;if(_Cw<=810899){var _Cx=$k[--$j];$k[$j++]=926;$k[$j++]=~~(_Cx/900)-1;$k[$j++]=_Cx%900;$as($a(3))}else{var _Cz=$k[--$j];$k[$j++]=_Cz;if(_Cz<=811799){var _D0=$k[--$j];$k[$j++]=925;$k[$j++]=$f(_D0-810900);$as($a(2))}else{$k[$j++]="bwipp.pdf417badECI#16787";$k[$j++]="PDF417 supports ECIs 000000 to 811799";bwipp_raiseerror()}}}};$1.encfuncs=$a(["enct","encn","encb"]);$1.addtocws=function(){var _D3=$k[--$j];$P($1.datcws,$1.j,_D3);$1.j=_D3.length+$1.j};$1.state=$1.T;$1.submode=$1.A;$1.datcws=$a($1.seqlen);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.seq.length){break}$1.chars=$g($1.seq,$1.i);if($eq($t($1.chars),"arraytype")){if($g($1.chars,0)<=-1e6){$k[$j++]=$1.chars;$1.ence();$1.addtocws()}else{$k[$j++]=$1.chars;if($1[$g($1.encfuncs,$1.state)]()===true){break}$1.addtocws()}}else{$k[$j++]=$a([$g($1.latchcws,$1.chars)]);$1.addtocws();if($1.chars==$1.tl){$1.state=$1.T;$1.submode=$1.A}if($1.chars==$1.nl){$1.state=$1.N}if($1.chars==$1.bl||$1.chars==$1.bl6){$1.state=$1.B}if($1.chars==$1.bs){$1.i=$1.i+1;$k[$j++]=$g($1.seq,$1.i);$1.encb();$1.addtocws()}}$1.i=$1.i+1}$1.datcws=$G($1.datcws,0,$1.j)}$1.m=$1.datcws.length;if($1.eclevel==-1){if($1.m<=40){$1.eclevel=2}if($1.m>=41&&$1.m<=160){$1.eclevel=3}if($1.m>=161&&$1.m<=320){$1.eclevel=4}if($1.m>=321){$1.eclevel=5}}$1.maxeclevel=~~(Math.log(928-1-$1.m)/Math.log(2))-1;if($1.eclevel>$1.maxeclevel){$1.eclevel=$1.maxeclevel}$1.k=~~Math.pow(2,$1.eclevel+1);if($1.columns==0){$1.columns=~~Math.round(Math.sqrt(($1.m+$1.k)/3))}$k[$j++]="c";if($1.columns>=1){$k[$j++]=$1.columns}else{$k[$j++]=1}var _E8=$k[--$j];$1[$k[--$j]]=_E8;$1.r=~~Math.ceil(($1.m+$1.k+1)/$1.columns);if($1.r<$1.rows&&$1.rows<=90){$1.r=$1.rows}if($1.r<3){$1.r=3}if($1.r>90){$k[$j++]="bwipp.pdf417insufficientCapacity#16850";$k[$j++]="Insufficient capacity in the symbol";bwipp_raiseerror()}var _EJ=$1.c;var _EK=$1.r;var _EL=$1.m;var _EM=8;var _EN=~~(Math.log($f($f(_EJ*_EK-1)-_EL))/Math.log(2))-1;if(~~(Math.log($f($f(_EJ*_EK-1)-_EL))/Math.log(2))-1>8){var _=_EM;_EM=_EN;_EN=_}$1.maxeclevel=_EN;if($1.maxeclevel>$1.eclevel){$1.eclevel=$1.maxeclevel;$1.k=~~Math.pow(2,$1.eclevel+1)}$1.n=$f($1.c*$1.r-$1.k);$1.cws=$a($f($1.c*$1.r+1));$p($1.cws,0,$1.n);$P($1.cws,1,$1.datcws);$k[$j++]=$1.cws;$k[$j++]=$1.m+1;$k[$j++]=Infinity;for(var _Eg=0,_Eh=$f($f($1.n-$1.m)-1);_Eg<_Eh;_Eg++){$k[$j++]=900}var _Ei=$a();var _Ej=$k[--$j];$P($k[--$j],_Ej,_Ei);$k[$j++]=$1.cws;$k[$j++]=$1.n;$k[$j++]=Infinity;for(var _Eo=0,_Ep=$1.k;_Eo<_Ep;_Eo++){$k[$j++]=0}$k[$j++]=0;var _Eq=$a();var _Er=$k[--$j];$P($k[--$j],_Er,_Eq);$k[$j++]=Infinity;$k[$j++]=1;for(var _Et=0,_Eu=928;_Et<_Eu;_Et++){var _Ev=$k[--$j];$k[$j++]=_Ev;$k[$j++]=_Ev*3%929}$1.rsalog=$a();$1.rslog=$a(929);for(var _Ey=1;_Ey<=928;_Ey+=1){$p($1.rslog,$g($1.rsalog,_Ey),_Ey)}$1.rsprod=function(){var _F2=$k[--$j];var _F3=$k[--$j];$k[$j++]=_F3;$k[$j++]=_F2;if(_F2!=0&&_F3!=0){var _F6=$g($1.rslog,$k[--$j]);var _FB=$g($1.rsalog,$f(_F6+$g($1.rslog,$k[--$j]))%928);$k[$j++]=_FB}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _FD=0,_FE=$1.k;_FD<_FE;_FD++){$k[$j++]=0}$1.coeffs=$a();for(var _FI=1,_FH=$1.k;_FI<=_FH;_FI+=1){$1.i=_FI;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _FP=$1.i-1;_FP>=1;_FP-=1){$1.j=_FP;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Fb=$k[--$j];var _Fc=$k[--$j];var _Fd=$k[--$j];$p($k[--$j],_Fd,$f(_Fc+_Fb)%929)}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Fl=$k[--$j];var _Fm=$k[--$j];$p($k[--$j],_Fm,_Fl)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);for(var _Fs=$1.coeffs.length-1;_Fs>=0;_Fs-=2){var _Ft=$1.coeffs;$p(_Ft,_Fs,$f(929-$g(_Ft,_Fs)))}for(var _Fx=0,_Fw=$f($1.n-1);_Fx<=_Fw;_Fx+=1){$1.t=$f($g($1.cws,_Fx)+$g($1.cws,$1.n))%929;for(var _G5=0,_G4=$1.k-1;_G5<=_G4;_G5+=1){$1.j=_G5;$p($1.cws,$f($1.n+$1.j),$f($g($1.cws,$f($f($1.n+$1.j)+1))+$f(929-$1.t*$g($1.coeffs,$1.k-$1.j-1)%929))%929)}}for(var _GM=$1.n,_GL=$f($1.n+$1.k);_GM<=_GL;_GM+=1){$p($1.cws,_GM,$f(929-$g($1.cws,_GM))%929)}$1.cws=$G($1.cws,0,$1.cws.length-1);var _GU=$g($1.options,"debugcws")!==undefined;if(_GU){$k[$j++]="bwipp.debugcws#16909";$k[$j++]=$1.cws;bwipp_raiseerror()}if(!bwipp_pdf417.__17153__){(function(){var $ctx=Object.create($1);$ctx.clusters=$a([$a([120256,125680,128380,120032,125560,128318,108736,119920,108640,86080,108592,86048,110016,120560,125820,109792,120440,125758,88256,109680,88160,89536,110320,120700,89312,110200,120638,89200,110140,89840,110460,89720,110398,89980,128506,119520,125304,128190,107712,119408,125244,107616,119352,84032,107568,119324,84e3,107544,83984,108256,119672,125374,85184,108144,119612,85088,108088,119582,85040,108060,85728,108408,119742,85616,108348,85560,108318,85880,108478,85820,85790,107200,119152,125116,107104,119096,125086,83008,107056,119068,82976,107032,82960,82952,83648,107376,119228,83552,107320,119198,83504,107292,83480,83468,83824,107452,83768,107422,83740,83900,106848,118968,125022,82496,106800,118940,82464,106776,118926,82448,106764,82440,106758,82784,106936,119006,82736,106908,82712,106894,82700,82694,106974,82830,82240,106672,118876,82208,106648,118862,82192,106636,82184,106630,82180,82352,82328,82316,82080,118830,106572,106566,82050,117472,124280,127678,103616,117360,124220,103520,117304,124190,75840,103472,75808,104160,117624,124350,76992,104048,117564,76896,103992,76848,76824,77536,104312,117694,77424,104252,77368,77340,77688,104382,77628,77758,121536,126320,128700,121440,126264,128670,111680,121392,126236,111648,121368,126222,111632,121356,103104,117104,124092,112320,103008,117048,124062,112224,121656,126366,93248,74784,102936,117006,93216,112152,93200,75456,103280,117180,93888,75360,103224,117150,93792,112440,121758,93744,75288,93720,75632,103356,94064,75576,103326,94008,112542,93980,75708,94140,75678,94110,121184,126136,128606,111168,121136,126108,111136,121112,126094,111120,121100,111112,111108,102752,116920,123998,111456,102704,116892,91712,74272,121244,116878,91680,74256,102668,91664,111372,102662,74244,74592,102840,116958,92e3,74544,102812,91952,111516,102798,91928,74508,74502,74680,102878,92088,74652,92060,74638,92046,92126,110912,121008,126044,110880,120984,126030,110864,120972,110856,120966,110852,110850,74048,102576,116828,90944,74016,102552,116814,90912,111e3,121038,90896,73992,102534,90888,110982,90884,74160,102620,91056,74136,102606,91032,111054,91020,74118,91014,91100,91086,110752,120920,125998,110736,120908,110728,120902,110724,110722,73888,102488,116782,90528,73872,102476,90512,110796,102470,90504,73860,90500,73858,73944,90584,90572,90566,120876,120870,110658,102444,73800,90312,90308,90306,101056,116080,123580,100960,116024,70720,100912,115996,70688,100888,70672,70664,71360,101232,116156,71264,101176,116126,71216,101148,71192,71180,71536,101308,71480,101278,71452,71612,71582,118112,124600,127838,105024,118064,124572,104992,118040,124558,104976,118028,104968,118022,100704,115896,123486,105312,100656,115868,79424,70176,118172,115854,79392,105240,100620,79376,70152,79368,70496,100792,115934,79712,70448,118238,79664,105372,100750,79640,70412,79628,70584,100830,79800,70556,79772,70542,70622,79838,122176,126640,128860,122144,126616,128846,122128,126604,122120,126598,122116,104768,117936,124508,113472,104736,126684,124494,113440,122264,126670,113424,104712,117894,113416,122246,104706,69952,100528,115804,78656,69920,100504,115790,96064,78624,104856,117966,96032,113560,122318,100486,96016,78600,104838,96008,69890,70064,100572,78768,70040,100558,96176,78744,104910,96152,113614,70022,78726,70108,78812,70094,96220,78798,122016,126552,128814,122e3,126540,121992,126534,121988,121986,104608,117848,124462,113056,104592,126574,113040,122060,117830,113032,104580,113028,104578,113026,69792,100440,115758,78240,69776,100428,95136,78224,104652,100422,95120,113100,69764,95112,78212,69762,78210,69848,100462,78296,69836,95192,78284,69830,95180,78278,69870,95214,121936,126508,121928,126502,121924,121922,104528,117804,112848,104520,117798,112840,121958,112836,104514,112834,69712,100396,78032,69704,100390,94672,78024,104550,94664,112870,69698,94660,78018,94658,78060,94700,94694,126486,121890,117782,104484,104482,69672,77928,94440,69666,77922,99680,68160,99632,68128,99608,115342,68112,99596,68104,99590,68448,99768,115422,68400,99740,68376,99726,68364,68358,68536,99806,68508,68494,68574,101696,116400,123740,101664,116376,101648,116364,101640,116358,101636,67904,99504,115292,72512,67872,116444,115278,72480,101784,116430,72464,67848,99462,72456,101766,67842,68016,99548,72624,67992,99534,72600,101838,72588,67974,68060,72668,68046,72654,118432,124760,127918,118416,124748,118408,124742,118404,118402,101536,116312,105888,101520,116300,105872,118476,116294,105864,101508,105860,101506,105858,67744,99416,72096,67728,116334,80800,72080,101580,99398,80784,105932,67716,80776,72068,67714,72066,67800,99438,72152,67788,80856,72140,67782,80844,72134,67822,72174,80878,126800,128940,126792,128934,126788,126786,118352,124716,122576,126828,124710,122568,126822,122564,118338,122562,101456,116268,105680,101448,116262,114128,105672,118374,114120,122598,101442,114116,105666,114114,67664,99372,71888,67656,99366,80336,71880,101478,97232,80328,105702,67650,97224,114150,71874,97220,67692,71916,67686,80364,71910,97260,80358,97254,126760,128918,126756,126754,118312,124694,122472,126774,122468,118306,122466,101416,116246,105576,101412,113896,105572,101410,113892,105570,113890,67624,99350,71784,101430,80104,71780,67618,96744,80100,71778,96740,80098,96738,71798,96758,126738,122420,122418,105524,113780,113778,71732,79988,96500,96498,66880,66848,98968,66832,66824,66820,66992,66968,66956,66950,67036,67022,1e5,99984,115532,99976,115526,99972,99970,66720,98904,69024,100056,98892,69008,100044,69e3,100038,68996,66690,68994,66776,98926,69080,100078,69068,66758,69062,66798,69102,116560,116552,116548,116546,99920,102096,116588,115494,102088,116582,102084,99906,102082,66640,68816,66632,98854,73168,68808,66628,73160,68804,66626,73156,68802,66668,68844,66662,73196,68838,73190,124840,124836,124834,116520,118632,124854,118628,116514,118626,99880,115478,101992,116534,106216,101988,99874,106212,101986,106210,66600,98838,68712,99894,72936,68708,66594,81384,72932,68706,81380,72930,66614,68726,72950,81398,128980,128978,124820,126900,124818,126898,116500,118580,116498,122740,118578,122738,99860,101940,99858,106100,101938,114420]),$a([128352,129720,125504,128304,129692,125472,128280,129678,125456,128268,125448,128262,125444,125792,128440,129758,120384,125744,128412,120352,125720,128398,120336,125708,120328,125702,120324,120672,125880,128478,110144,120624,125852,110112,120600,125838,110096,120588,110088,120582,110084,110432,120760,125918,89664,110384,120732,89632,110360,120718,89616,110348,89608,110342,89952,110520,120798,89904,110492,89880,110478,89868,90040,110558,90012,89998,125248,128176,129628,125216,128152,129614,125200,128140,125192,128134,125188,125186,119616,125360,128220,119584,125336,128206,119568,125324,119560,125318,119556,119554,108352,119728,125404,108320,119704,125390,108304,119692,108296,119686,108292,108290,85824,108464,119772,85792,108440,119758,85776,108428,85768,108422,85764,85936,108508,85912,108494,85900,85894,85980,85966,125088,128088,129582,125072,128076,125064,128070,125060,125058,119200,125144,128110,119184,125132,119176,125126,119172,119170,107424,119256,125166,107408,119244,107400,119238,107396,107394,83872,107480,119278,83856,107468,83848,107462,83844,83842,83928,107502,83916,83910,83950,125008,128044,125e3,128038,124996,124994,118992,125036,118984,125030,118980,118978,106960,119020,106952,119014,106948,106946,82896,106988,82888,106982,82884,82882,82924,82918,124968,128022,124964,124962,118888,124982,118884,118882,106728,118902,106724,106722,82408,106742,82404,82402,124948,124946,118836,118834,106612,106610,124224,127664,129372,124192,127640,129358,124176,127628,124168,127622,124164,124162,117568,124336,127708,117536,124312,127694,117520,124300,117512,124294,117508,117506,104256,117680,124380,104224,117656,124366,104208,117644,104200,117638,104196,104194,77632,104368,117724,77600,104344,117710,77584,104332,77576,104326,77572,77744,104412,77720,104398,77708,77702,77788,77774,128672,129880,93168,128656,129868,92664,128648,129862,92412,128644,128642,124064,127576,129326,126368,124048,129902,126352,128716,127558,126344,124036,126340,124034,126338,117152,124120,127598,121760,117136,124108,121744,126412,124102,121736,117124,121732,117122,121730,103328,117208,124142,112544,103312,117196,112528,121804,117190,112520,103300,112516,103298,112514,75680,103384,117230,94112,75664,103372,94096,112588,103366,94088,75652,94084,75650,75736,103406,94168,75724,94156,75718,94150,75758,128592,129836,91640,128584,129830,91388,128580,91262,128578,123984,127532,126160,123976,127526,126152,128614,126148,123970,126146,116944,124012,121296,116936,124006,121288,126182,121284,116930,121282,102864,116972,111568,102856,116966,111560,121318,111556,102850,111554,74704,102892,92112,74696,102886,92104,111590,92100,74690,92098,74732,92140,74726,92134,128552,129814,90876,128548,90750,128546,123944,127510,126056,128566,126052,123938,126050,116840,123958,121064,116836,121060,116834,121058,102632,116854,111080,121078,111076,102626,111074,74216,102646,91112,74212,91108,74210,91106,74230,91126,128532,90494,128530,123924,126004,123922,126002,116788,120948,116786,120946,102516,110836,102514,110834,73972,90612,73970,90610,128522,123914,125978,116762,120890,102458,110714,123552,127320,129198,123536,127308,123528,127302,123524,123522,116128,123608,127342,116112,123596,116104,123590,116100,116098,101280,116184,123630,101264,116172,101256,116166,101252,101250,71584,101336,116206,71568,101324,71560,101318,71556,71554,71640,101358,71628,71622,71662,127824,129452,79352,127816,129446,79100,127812,78974,127810,123472,127276,124624,123464,127270,124616,127846,124612,123458,124610,115920,123500,118224,115912,123494,118216,124646,118212,115906,118210,100816,115948,105424,100808,115942,105416,118246,105412,100802,105410,70608,100844,79824,70600,100838,79816,105446,79812,70594,79810,70636,79852,70630,79846,129960,95728,113404,129956,95480,113278,129954,95356,95294,127784,129430,78588,128872,129974,95996,78462,128868,127778,95870,128866,123432,127254,124520,123428,126696,128886,123426,126692,124514,126690,115816,123446,117992,115812,122344,117988,115810,122340,117986,122338,100584,115830,104936,100580,113640,104932,100578,113636,104930,113634,70120,100598,78824,70116,96232,78820,70114,96228,78818,96226,70134,78838,129940,94968,113022,129938,94844,94782,127764,78206,128820,127762,95102,128818,123412,124468,123410,126580,124466,126578,115764,117876,115762,122100,117874,122098,100468,104692,100466,113140,104690,113138,69876,78324,69874,95220,78322,95218,129930,94588,94526,127754,128794,123402,124442,126522,115738,117818,121978,100410,104570,112890,69754,78074,94714,94398,123216,127148,123208,127142,123204,123202,115408,123244,115400,123238,115396,115394,99792,115436,99784,115430,99780,99778,68560,99820,68552,99814,68548,68546,68588,68582,127400,129238,72444,127396,72318,127394,123176,127126,123752,123172,123748,123170,123746,115304,123190,116456,115300,116452,115298,116450,99560,115318,101864,99556,101860,99554,101858,68072,99574,72680,68068,72676,68066,72674,68086,72694,129492,80632,105854,129490,80508,80446,127380,72062,127924,127378,80766,127922,123156,123700,123154,124788,123698,124786,115252,116340,115250,118516,116338,118514,99444,101620,99442,105972,101618,105970,67828,72180,67826,80884,72178,80882,97008,114044,96888,113982,96828,96798,129482,80252,130010,97148,80190,97086,127370,127898,128954,123146,123674,124730,126842,115226,116282,118394,122618,99386,101498,105722,114170,67706,71930,80378,96632,113854,96572,96542,80062,96702,96444,96414,96350,123048,123044,123042,115048,123062,115044,115042,99048,115062,99044,99042,67048,99062,67044,67042,67062,127188,68990,127186,123028,123316,123026,123314,114996,115572,114994,115570,98932,100084,98930,100082,66804,69108,66802,69106,129258,73084,73022,127178,127450,123018,123290,123834,114970,115514,116602,98874,99962,102138,66682,68858,73210,81272,106174,81212,81182,72894,81342,97648,114364,97592,114334,97564,97550,81084,97724,81054,97694,97464,114270,97436,97422,80990,97502,97372,97358,97326,114868,114866,98676,98674,66292,66290,123098,114842,115130,98618,99194,66170,67322,69310,73404,73374,81592,106334,81564,81550,73310,81630,97968,114524,97944,114510,97932,97926,81500,98012,81486,97998,97880,114478,97868,97862,81454,97902,97836,97830,69470,73564,73550,81752,106414,81740,81734,73518,81774,81708,81702]),$a([109536,120312,86976,109040,120060,86496,108792,119934,86256,108668,86136,129744,89056,110072,129736,88560,109820,129732,88312,109694,129730,88188,128464,129772,89592,128456,129766,89340,128452,89214,128450,125904,128492,125896,128486,125892,125890,120784,125932,120776,125926,120772,120770,110544,120812,110536,120806,110532,84928,108016,119548,84448,107768,119422,84208,107644,84088,107582,84028,129640,85488,108284,129636,85240,108158,129634,85116,85054,128232,129654,85756,128228,85630,128226,125416,128246,125412,125410,119784,125430,119780,119778,108520,119798,108516,108514,83424,107256,119166,83184,107132,83064,107070,83004,82974,129588,83704,107390,129586,83580,83518,128116,83838,128114,125172,125170,119284,119282,107508,107506,82672,106876,82552,106814,82492,82462,129562,82812,82750,128058,125050,119034,82296,106686,82236,82206,82366,82108,82078,76736,103920,117500,76256,103672,117374,76016,103548,75896,103486,75836,129384,77296,104188,129380,77048,104062,129378,76924,76862,127720,129398,77564,127716,77438,127714,124392,127734,124388,124386,117736,124406,117732,117730,104424,117750,104420,104418,112096,121592,126334,92608,111856,121468,92384,111736,121406,92272,111676,92216,111646,92188,75232,103160,117118,93664,74992,103036,93424,112252,102974,93304,74812,93244,74782,93214,129332,75512,103294,129908,129330,93944,75388,129906,93820,75326,93758,127604,75646,128756,127602,94078,128754,124148,126452,124146,126450,117236,121844,117234,121842,103412,103410,91584,111344,121212,91360,111224,121150,91248,111164,91192,111134,91164,91150,74480,102780,91888,74360,102718,91768,111422,91708,74270,91678,129306,74620,129850,92028,74558,91966,127546,128634,124026,126202,116986,121338,102906,90848,110968,121022,90736,110908,90680,110878,90652,90638,74104,102590,91e3,74044,90940,74014,90910,74174,91070,90480,110780,90424,110750,90396,90382,73916,90556,73886,90526,90296,110686,90268,90254,73822,90334,90204,90190,71136,101112,116094,70896,100988,70776,100926,70716,70686,129204,71416,101246,129202,71292,71230,127348,71550,127346,123636,123634,116212,116210,101364,101362,79296,105200,118140,79072,105080,118078,78960,105020,78904,104990,78876,78862,70384,100732,79600,70264,100670,79480,105278,79420,70174,79390,129178,70524,129466,79740,70462,79678,127290,127866,123514,124666,115962,118266,100858,113376,122232,126654,95424,113264,122172,95328,113208,122142,95280,113180,95256,113166,95244,78560,104824,117950,95968,78448,104764,95856,113468,104734,95800,78364,95772,78350,95758,70008,100542,78712,69948,96120,78652,69918,96060,78622,96030,70078,78782,96190,94912,113008,122044,94816,112952,122014,94768,112924,94744,112910,94732,94726,78192,104636,95088,78136,104606,95032,113054,95004,78094,94990,69820,78268,69790,95164,78238,95134,94560,112824,121950,94512,112796,94488,112782,94476,94470,78008,104542,94648,77980,94620,77966,94606,69726,78046,94686,94384,112732,94360,112718,94348,94342,77916,94428,77902,94414,94296,112686,94284,94278,77870,94318,94252,94246,68336,99708,68216,99646,68156,68126,68476,68414,127162,123258,115450,99834,72416,101752,116414,72304,101692,72248,101662,72220,72206,67960,99518,72568,67900,72508,67870,72478,68030,72638,80576,105840,118460,80480,105784,118430,80432,105756,80408,105742,80396,80390,72048,101564,80752,71992,101534,80696,71964,80668,71950,80654,67772,72124,67742,80828,72094,80798,114016,122552,126814,96832,113968,122524,96800,113944,122510,96784,113932,96776,113926,96772,80224,105656,118366,97120,80176,105628,97072,114076,105614,97048,80140,97036,80134,97030,71864,101470,80312,71836,97208,80284,71822,97180,80270,97166,67678,71902,80350,97246,96576,113840,122460,96544,113816,122446,96528,113804,96520,113798,96516,96514,80048,105564,96688,80024,105550,96664,113870,96652,80006,96646,71772,80092,71758,96732,80078,96718,96416,113752,122414,96400,113740,96392,113734,96388,96386,79960,105518,96472,79948,96460,79942,96454,71726,79982,96494,96336,113708,96328,113702,96324,96322,79916,96364,79910,96358,96296,113686,96292,96290,79894,96310,66936,99006,66876,66846,67006,68976,100028,68920,99998,68892,68878,66748,69052,66718,69022,73056,102072,116574,73008,102044,72984,102030,72972,72966,68792,99934,73144,68764,73116,68750,73102,66654,68830,73182,81216,106160,118620,81184,106136,118606,81168,106124,81160,106118,81156,81154,72880,101980,81328,72856,101966,81304,106190,81292,72838,81286,68700,72924,68686,81372,72910,81358,114336,122712,126894,114320,122700,114312,122694,114308,114306,81056,106072,118574,97696,81040,106060,97680,114380,106054,97672,81028,97668,81026,97666,72792,101934,81112,72780,97752,81100,72774,97740,81094,97734,68654,72814,81134,97774,114256,122668,114248,122662,114244,114242,80976,106028,97488,80968,106022,97480,114278,97476,80962,97474,72748,81004,72742,97516,80998,97510,114216,122646,114212,114210,80936,106006,97384,80932,97380,80930,97378,72726,80950,97398,114196,114194,80916,97332,80914,97330,66236,66206,67256,99166,67228,67214,66142,67294,69296,100188,69272,100174,69260,69254,67164,69340,67150,69326,73376,102232,116654,73360,102220,73352,102214,73348,73346,69208,100142,73432,102254,73420,69190,73414,67118,69230,73454,106320,118700,106312,118694,106308,106306,73296,102188,81616,106348,102182,81608,73284,81604,73282,81602,69164,73324,69158,81644,73318,81638,122792,126934,122788,122786,106280,118678,114536,106276,114532,106274,114530,73256,102166,81512,73252,98024,81508,73250,98020,81506,98018,69142,73270,81526,98038,122772,122770,106260,114484,106258,114482,73236,81460,73234,97908,81458,97906,122762,106250,114458,73226,81434,97850,66396,66382,67416,99246,67404,67398,66350,67438,69456,100268,69448,100262,69444,69442,67372,69484,67366,69478,102312,116694,102308,102306,69416,100246,73576,102326,73572,69410,73570,67350,69430,73590,118740,118738,102292,106420,102290,106418,69396,73524,69394,81780,73522,81778,118730,102282,106394,69386,73498,81722,66476,66470,67496,99286,67492,67490,66454,67510,100308,100306,67476,69556,67474,69554,116714])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_pdf417.$ctx[id]=$ctx[id]);bwipp_pdf417.__17153__=1})()}$1.cwtobits=function(){var _Gd=$g($1.clusters,$k[--$j]);$1.v=$g(_Gd,$k[--$j]);$k[$j++]=Infinity;for(var _Gg=0,_Gh=17;_Gg<_Gh;_Gg++){$k[$j++]=0}var _Gk=$R($s(17),$1.v,2);for(var _Gl=0,_Gm=_Gk.length;_Gl<_Gm;_Gl++){$k[$j++]=$g(_Gk,_Gl)-48}var _Go=$a();$k[$j++]=$G(_Go,_Go.length-17,17)};if($1.compact){$1.rwid=$f($f($f(17*$1.c+17)+17)+1)}else{$1.rwid=$f($f($f($f(17*$1.c+17)+17)+17)+18)}$1.pixs=$a($1.rwid*$1.r);for(var _Gy=0,_Gx=$1.r-1;_Gy<=_Gx;_Gy+=1){$1.i=_Gy;if($1.i%3==0){$1.lcw=~~($1.i/3)*30+~~(($1.r-1)/3);$1.rcw=$f($f(~~($1.i/3)*30+$1.c)-1)}if($1.i%3==1){$1.lcw=~~($1.i/3)*30+$1.eclevel*3+($1.r-1)%3;$1.rcw=~~($1.i/3)*30+~~(($1.r-1)/3)}if($1.i%3==2){$1.lcw=$f($f(~~($1.i/3)*30+$1.c)-1);$1.rcw=~~($1.i/3)*30+$1.eclevel*3+($1.r-1)%3}$k[$j++]=$1.pixs;$k[$j++]=$1.rwid*$1.i;$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=$1.lcw;$k[$j++]=$1.i%3;$1.cwtobits();$F($k[--$j]);var _HQ=$G($1.cws,$1.c*$1.i,$1.c);for(var _HR=0,_HS=_HQ.length;_HR<_HS;_HR++){$k[$j++]=$g(_HQ,_HR);$k[$j++]=$1.i%3;$1.cwtobits();$F($k[--$j])}if($1.compact){$k[$j++]=1}else{$k[$j++]=$1.rcw;$k[$j++]=$1.i%3;$1.cwtobits();$F($k[--$j]);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1}var _Ha=$a();var _Hb=$k[--$j];$P($k[--$j],_Hb,_Ha)}var _Hk=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.rwid],["pixy",$1.r],["height",$1.r/72*$1.rowmult],["width",$1.rwid/72],["opt",$1.options]]);$k[$j++]=_Hk;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_pdf417compact(){var $1=Object.create(bwipp_pdf417compact.$ctx||(bwipp_pdf417compact.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"compact",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_pdf417();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_micropdf417(){var $1=Object.create(bwipp_micropdf417.$ctx||(bwipp_micropdf417.$ctx={}));$1.dontdraw=false;$1.version="unset";$1.columns=0;$1.rows=0;$1.rowmult=2;$1.cca=false;$1.ccb=false;$1.raw=false;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.micropdf417emptyData#17312";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($1.rowmult<=0){$k[$j++]="bwipp.micropdf417badRowMult#17316";$k[$j++]="The row multiplier must be greater than zero";bwipp_raiseerror()}if($1.cca&&$1.ccb||($1.cca&&$1.raw||$1.ccb&&$1.raw)){$k[$j++]="bwipp.micropdf417ccaAndCcb#17320";$k[$j++]="Cannot combine cca, ccb and raw";bwipp_raiseerror()}if($ne($1.version,"unset")){$X($1.version,"x");if($k[--$j]){var _D=$k[--$j];var _E=$k[--$j];$k[$j++]=_D;$k[$j++]=_E;$j--;var _F=$k[--$j];var _G=$k[--$j];$k[$j++]=_G;$k[$j++]=_F;$k[$j++]=_G;$k[$j++]=_F;$as($a(2));$F($k[--$j],function(){var _J=$k[--$j];$k[$j++]=_J;$k[$j++]=true;if(_J.length==0){$j--;$k[$j++]=false}var _K=$k[--$j];var _L=$k[--$j];$k[$j++]=_K;$F(_L,function(){var _M=$k[--$j];if(_M<48||_M>57){$j--;$k[$j++]=false}});if($nt($k[--$j])){$k[$j++]="bwipp.micropdf417BadVersionBadRowOrColumn#17334";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}});$1.rows=$i($k[--$j]);$1.columns=$i($k[--$j])}else{$j--;$k[$j++]="bwipp.micropdf417badVersionFormat#17340";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}}if(!bwipp_micropdf417.__17431__){(function(){var $ctx=Object.create($1);$ctx.T=0;$ctx.N=1;$ctx.B=2;$ctx.A=0;$ctx.L=1;$ctx.M=2;$ctx.P=3;$ctx.tl=-1;$ctx.nl=-2;$ctx.bl=-3;$ctx.bl6=-4;$ctx.bs=-5;$ctx.al=-6;$ctx.ll=-7;$ctx.ml=-8;$ctx.pl=-9;$ctx.as=-10;$ctx.ps=-11;$ctx.charmaps=$a([$a(["A","a","0",";"]),$a(["B","b","1","<"]),$a(["C","c","2",">"]),$a(["D","d","3","@"]),$a(["E","e","4","["]),$a(["F","f","5",92]),$a(["G","g","6","]"]),$a(["H","h","7","_"]),$a(["I","i","8","`"]),$a(["J","j","9","~"]),$a(["K","k","&","!"]),$a(["L","l",13,13]),$a(["M","m",9,9]),$a(["N","n",",",","]),$a(["O","o",":",":"]),$a(["P","p","#",10]),$a(["Q","q","-","-"]),$a(["R","r",".","."]),$a(["S","s","$","$"]),$a(["T","t","/","/"]),$a(["U","u","+",'"']),$a(["V","v","%","|"]),$a(["W","w","*","*"]),$a(["X","x","=",40]),$a(["Y","y","^",41]),$a(["Z","z",$ctx.pl,"?"]),$a([" "," "," ","{"]),$a([$ctx.ll,$ctx.as,$ctx.ll,"}"]),$a([$ctx.ml,$ctx.ml,$ctx.al,"'"]),$a([$ctx.ps,$ctx.ps,$ctx.ps,$ctx.al])]);$ctx.charvals=$a([new Map,new Map,new Map,new Map]);$ctx.alltext=new Map;for(var _19=0,_18=$ctx.charmaps.length-1;_19<=_18;_19+=1){$ctx.i=_19;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _1D=0;_1D<=3;_1D+=1){$ctx.j=_1D;var _1G=$g($ctx.encs,$ctx.j);$k[$j++]=_1G;if($eq($t(_1G),"stringtype")){var _1J=$g($k[--$j],0);$k[$j++]=_1J}var _1K=$k[--$j];$p($g($ctx.charvals,$ctx.j),_1K,$ctx.i);$p($ctx.alltext,_1K,-1)}}$ctx.e=1e4;$ctx.latlen=$a([$a([0,1,1,2]),$a([2,0,1,2]),$a([1,1,0,1]),$a([1,2,2,0])]);$ctx.latseq=$a([$a([$a([]),$a([$ctx.ll]),$a([$ctx.ml]),$a([$ctx.ml,$ctx.pl])]),$a([$a([$ctx.ml,$ctx.al]),$a([]),$a([$ctx.ml]),$a([$ctx.ml,$ctx.pl])]),$a([$a([$ctx.al]),$a([$ctx.ll]),$a([]),$a([$ctx.pl])]),$a([$a([$ctx.al]),$a([$ctx.al,$ctx.ll]),$a([$ctx.al,$ctx.ml]),$a([])])]);$ctx.shftlen=$a([$a([$ctx.e,$ctx.e,$ctx.e,1]),$a([1,$ctx.e,$ctx.e,1]),$a([$ctx.e,$ctx.e,$ctx.e,1]),$a([$ctx.e,$ctx.e,$ctx.e,$ctx.e])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_micropdf417.$ctx[id]=$ctx[id]);bwipp_micropdf417.__17431__=1})()}if($1.raw||$1.cca){$1.datcws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.barcode.length-3){break}if($g($1.barcode,$1.i)!=94){break}var _2a=$G($1.barcode,$1.i+1,3);$k[$j++]=_2a;$k[$j++]=false;for(var _2b=0,_2c=_2a.length;_2b<_2c;_2b++){var _2d=$g(_2a,_2b);if(_2d<48||_2d>57){$j--;$k[$j++]=true}}if($k[--$j]){$j--;break}$1.cw=$i($k[--$j]);$p($1.datcws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}if($1.i!=$1.barcode.length){$k[$j++]="bwipp.micropdf417badCcaRawFormat#17449";$k[$j++]="cca and raw data must be formatted as ^NNN";bwipp_raiseerror()}$1.datcws=$G($1.datcws,0,$1.j)}$1.encb=function(){$1.in=$k[--$j];$1.inlen=$1.in.length;$1.out=$a(~~($1.inlen/6)*5+$1.inlen%6);for(var _2x=0,_2w=~~($1.inlen/6)-1;_2x<=_2w;_2x+=1){$1.k=_2x;$k[$j++]=Infinity;$q($G($1.in,$1.k*6,3));$1.msbs=$a();$k[$j++]=Infinity;$q($1.msbs);var _33=$k[--$j];var _34=$k[--$j];var _35=$k[--$j];$k[$j++]=$f($f(_33+_34*256)+_35*65536);for(var _36=0,_37=3;_36<_37;_36++){var _38=$k[--$j];$k[$j++]=_38%900;$k[$j++]=~~(_38/900)}$1.mscs=$a();$k[$j++]=Infinity;$q($G($1.in,$1.k*6+3,3));$1.lsbs=$a();$k[$j++]=Infinity;$q($1.lsbs);var _3F=$k[--$j];var _3G=$k[--$j];var _3H=$k[--$j];$k[$j++]=$f($f(_3F+_3G*256)+_3H*65536);for(var _3I=0,_3J=3;_3I<_3J;_3I++){var _3K=$k[--$j];$k[$j++]=_3K%900;$k[$j++]=~~(_3K/900)}$1.lscs=$a();var _3N=$g($1.lscs,0);var _3P=$g($1.mscs,0);$p($1.out,$1.k*5+4,$f(_3N+_3P*316)%900);var _3T=$g($1.lscs,1);var _3V=$g($1.mscs,0);var _3X=$g($1.mscs,1);$p($1.out,$1.k*5+3,$f($f($f(~~($f(_3N+_3P*316)/900)+_3T)+_3V*641)+_3X*316)%900);var _3b=$g($1.lscs,2);var _3d=$g($1.mscs,0);var _3f=$g($1.mscs,1);var _3h=$g($1.mscs,2);$p($1.out,$1.k*5+2,$f($f($f($f(~~($f($f($f(~~($f(_3N+_3P*316)/900)+_3T)+_3V*641)+_3X*316)/900)+_3b)+_3d*20)+_3f*641)+_3h*316)%900);var _3l=$g($1.lscs,3);var _3n=$g($1.mscs,1);var _3p=$g($1.mscs,2);$p($1.out,$1.k*5+1,$f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_3N+_3P*316)/900)+_3T)+_3V*641)+_3X*316)/900)+_3b)+_3d*20)+_3f*641)+_3h*316)/900)+_3l)+_3n*20)+_3p*641)%900);$p($1.out,$1.k*5,$f(~~($f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_3N+_3P*316)/900)+_3T)+_3V*641)+_3X*316)/900)+_3b)+_3d*20)+_3f*641)+_3h*316)/900)+_3l)+_3n*20)+_3p*641)/900)+$g($1.mscs,2)*20)%900)}$1.rem=$1.inlen%6;if($1.rem!=0){$k[$j++]=$1.out;$k[$j++]=$1.out.length-$1.rem;$k[$j++]=Infinity;$q($G($1.in,$1.inlen-$1.rem,$1.rem));var _46=$a();var _47=$k[--$j];$P($k[--$j],_47,_46)}$k[$j++]=$1.out};if($1.ccb){$1.barlen=$1.barcode.length;$1.datcws=$a(~~($1.barlen/6)*5+$1.barlen%6+2);$p($1.datcws,0,920);var _4I=$1.barlen%6==0?924:901;$p($1.datcws,1,_4I);$k[$j++]=$1.datcws;$k[$j++]=2;$k[$j++]=Infinity;$F($1.barcode);var _4L=$a();$k[$j++]=_4L;$1.encb();var _4M=$k[--$j];var _4N=$k[--$j];$P($k[--$j],_4N,_4M)}if(!$1.raw&&!$1.cca&&!$1.ccb){var _4U=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true]]);$1.fncvals=_4U;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _4X=$k[--$j];$1[$k[--$j]]=_4X;$1.msglen=$1.msg.length;$k[$j++]=Infinity;for(var _4b=0,_4c=$1.msglen;_4b<_4c;_4b++){$k[$j++]=0}$k[$j++]=0;$1.numdigits=$a();$k[$j++]=Infinity;for(var _4f=0,_4g=$1.msglen;_4f<_4g;_4f++){$k[$j++]=0}$k[$j++]=0;$1.numtext=$a();$k[$j++]=Infinity;for(var _4j=0,_4k=$1.msglen;_4j<_4k;_4j++){$k[$j++]=0}$k[$j++]=0;$1.numbytes=$a();$k[$j++]=Infinity;for(var _4n=0,_4o=$1.msglen;_4n<_4o;_4n++){$k[$j++]=0}$1.iseci=$a();for(var _4r=$1.msglen-1;_4r>=0;_4r-=1){$1.i=_4r;var _4u=$g($1.msg,$1.i);if(_4u>=48&&_4u<=57){$p($1.numdigits,$1.i,$f($g($1.numdigits,$1.i+1)+1))}var _54=$g($1.alltext,$g($1.msg,$1.i))!==undefined;if(_54&&$g($1.numdigits,$1.i)<13){$p($1.numtext,$1.i,$f($g($1.numtext,$1.i+1)+1))}if($g($1.msg,$1.i)>=0&&$g($1.numtext,$1.i)<5&&$g($1.numdigits,$1.i)<13){$p($1.numbytes,$1.i,$f($g($1.numbytes,$1.i+1)+1))}$p($1.iseci,$1.i,$g($1.msg,$1.i)<=-1e6)}$1.numdigits=$G($1.numdigits,0,$1.msglen);$1.numtext=$G($1.numtext,0,$1.msglen);$1.numbytes=$G($1.numbytes,0,$1.msglen);$1.seq=$a([]);$1.seqlen=0;$1.state=$1.B;$1.p=0;for(;;){if($1.p==$1.msglen){break}if($g($1.iseci,$1.p)){$1.eci=$g($1.msg,$1.p);$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$a([$1.eci]);$1.seq=$a();$1.p=$1.p+1;$k[$j++]="seqlen";$k[$j++]=$1.seqlen;if($1.eci<=-1810900){$k[$j++]=2}else{var _5x=$1.eci<=-1000900?3:2;$k[$j++]=_5x}var _5y=$k[--$j];var _5z=$k[--$j];$1[$k[--$j]]=$f(_5z+_5y)}else{$1.n=$g($1.numdigits,$1.p);if($1.n>=13||$1.n==$1.msglen&&$1.n>=8){$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$1.nl;$k[$j++]=Infinity;$q($G($1.msg,$1.p,$1.n));var _6E=$a();$k[$j++]=_6E;$1.seq=$a();$1.state=$1.N;$1.p=$f($1.p+$1.n);$1.seqlen=$f($1.seqlen+1+$1.n)}else{$1.t=$g($1.numtext,$1.p);if($1.t>=5){$k[$j++]=Infinity;$q($1.seq);if($1.state!=$1.T){$k[$j++]=$1.tl}$k[$j++]=Infinity;$q($G($1.msg,$1.p,$1.t));var _6X=$a();$k[$j++]=_6X;$1.seq=$a();$1.state=$1.T;$1.p=$f($1.p+$1.t);$1.seqlen=$f($f($1.seqlen+1)+$1.t)}else{$1.b=$g($1.numbytes,$1.p);if($1.b==1&&$1.state==$1.T){$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$1.bs;$k[$j++]=$a([$g($1.msg,$1.p)]);$1.seq=$a();$1.p=$f($1.p+$1.b);$1.seqlen=$f($1.seqlen+2)}else{$k[$j++]=Infinity;$q($1.seq);var _6w=$1.b%6!=0?$1.bl:$1.bl6;$k[$j++]=_6w;$k[$j++]=Infinity;$q($G($1.msg,$1.p,$1.b));var _71=$a();$k[$j++]=_71;$1.seq=$a();$1.state=$1.B;$1.p=$f($1.p+$1.b);$1.seqlen=$f($f($1.seqlen+1)+$1.b)}}}}}$k[$j++]=Infinity;$k[$j++]=$1.tl;$k[$j++]=900;$k[$j++]=$1.bl;$k[$j++]=901;$k[$j++]=$1.bl6;$k[$j++]=924;$k[$j++]=$1.nl;$k[$j++]=902;$k[$j++]=$1.bs;$k[$j++]=913;$1.latchcws=$d();$1.enca=function(){var _7I=$g($g($1.charvals,$1.A),$k[--$j]);$k[$j++]=_7I};$1.encl=function(){var _7N=$g($g($1.charvals,$1.L),$k[--$j]);$k[$j++]=_7N};$1.encm=function(){var _7S=$g($g($1.charvals,$1.M),$k[--$j]);$k[$j++]=_7S};$1.encp=function(){var _7X=$g($g($1.charvals,$1.P),$k[--$j]);$k[$j++]=_7X};$1.textencfuncs=$a(["enca","encl","encm","encp"]);$1.addtotext=function(){$p($1.text,$1.l,$k[--$j]);$1.l=$1.l+1};$1.enct=function(){$1.in=$k[--$j];$1.curlen=$a([$1.e,$1.e,$1.e,$1.e]);$p($1.curlen,$1.submode,0);$1.curseq=$a([$a([]),$a([]),$a([]),$a([])]);$F($1.in,function(){$1.char=$k[--$j];for(;;){$1.imp=false;var _7w=$a([$1.A,$1.L,$1.M,$1.P]);for(var _7x=0,_7y=_7w.length;_7x<_7y;_7x++){$1.x=$g(_7w,_7x);var _84=$a([$1.A,$1.L,$1.M,$1.P]);for(var _85=0,_86=_84.length;_85<_86;_85++){$1.y=$g(_84,_85);$1.cost=$f($g($1.curlen,$1.x)+$g($g($1.latlen,$1.x),$1.y));if($1.cost<$g($1.curlen,$1.y)){$p($1.curlen,$1.y,$1.cost);$k[$j++]=$1.curseq;$k[$j++]=$1.y;$k[$j++]=Infinity;$q($g($1.curseq,$1.x));$q($g($g($1.latseq,$1.x),$1.y));var _8X=$a();var _8Y=$k[--$j];$p($k[--$j],_8Y,_8X);$1.imp=true}}}if(!$1.imp){break}}$1.nxtlen=$a([$1.e,$1.e,$1.e,$1.e]);$1.nxtseq=$a(4);var _8l=$a([$1.A,$1.L,$1.M,$1.P]);for(var _8m=0,_8n=_8l.length;_8m<_8n;_8m++){$1.x=$g(_8l,_8m);for(;;){var _8t=$g($g($1.charvals,$1.x),$1.char)!==undefined;if(!_8t){break}$1.cost=$f($g($1.curlen,$1.x)+1);if($1.cost<$g($1.nxtlen,$1.x)){$p($1.nxtlen,$1.x,$1.cost);$k[$j++]=$1.nxtseq;$k[$j++]=$1.x;$k[$j++]=Infinity;$q($g($1.curseq,$1.x));$k[$j++]=$1.char;var _9A=$a();var _9B=$k[--$j];$p($k[--$j],_9B,_9A)}var _9H=$a([$1.A,$1.L,$1.M,$1.P]);for(var _9I=0,_9J=_9H.length;_9I<_9J;_9I++){$1.y=$g(_9H,_9I);if($ne($1.x,$1.y)){$1.cost=$f($f($g($1.curlen,$1.y)+$g($g($1.shftlen,$1.y),$1.x))+1);if($1.cost<$g($1.nxtlen,$1.y)){$p($1.nxtlen,$1.y,$1.cost);$k[$j++]=$1.nxtseq;$k[$j++]=$1.y;$k[$j++]=Infinity;$q($g($1.curseq,$1.y));var _9j=$1.x==$1.A?$1.as:$1.ps;$k[$j++]=_9j;$k[$j++]=$1.char;var _9l=$a();var _9m=$k[--$j];$p($k[--$j],_9m,_9l)}}}break}}$1.curlen=$1.nxtlen;$1.curseq=$1.nxtseq});$1.minseq=$1.e;var _9v=$a([$1.A,$1.L,$1.M,$1.P]);for(var _9w=0,_9x=_9v.length;_9w<_9x;_9w++){$1.k=$g(_9v,_9w);if($g($1.curlen,$1.k)<$1.minseq){$1.minseq=$g($1.curlen,$1.k);$1.txtseq=$g($1.curseq,$1.k)}}$1.text=$a($1.minseq);$1.k=0;$1.l=0;for(;;){if($1.k>=$1.txtseq.length){break}$1.char=$g($1.txtseq,$1.k);$k[$j++]=$1.char;if($1[$g($1.textencfuncs,$1.submode)]()===true){break}$1.addtotext();$1.k=$1.k+1;if($1.char==$1.as||$1.char==$1.ps){$k[$j++]=$g($1.txtseq,$1.k);if($1.char==$1.as){$1.enca()}else{$1.encp()}$1.addtotext();$1.k=$1.k+1}if($1.char==$1.al){$1.submode=$1.A}if($1.char==$1.ll){$1.submode=$1.L}if($1.char==$1.ml){$1.submode=$1.M}if($1.char==$1.pl){$1.submode=$1.P}}if($1.text.length%2==1){if($1.submode==$1.P){$k[$j++]="pad";$k[$j++]=$1.al;$1.encp();var _Am=$k[--$j];$1[$k[--$j]]=_Am;$1.submode=$1.A}else{$1.nextecitext=false;for(var _As=$1.i+1,_Ar=$1.seq.length-1;_As<=_Ar;_As+=1){$1.ti=_As;if($ne($t($g($1.seq,$1.ti)),"arraytype")){$1.nextecitext=false;break}if($g($g($1.seq,$1.ti),0)>-1e6){break}$1.nextecitext=true}if($1.nextecitext){if($1.submode==$1.A){var _BB=$g($g($1.charvals,$1.L),$g($g($1.seq,$1.ti),0))!==undefined;if(_BB){$k[$j++]="pad";$k[$j++]=$1.ll;$1.enca();var _BD=$k[--$j];$1[$k[--$j]]=_BD;$1.submode=$1.L}else{$k[$j++]="pad";$k[$j++]=$1.ml;$1.enca();var _BH=$k[--$j];$1[$k[--$j]]=_BH;$1.submode=$1.M}}else{if($1.submode==$1.M){var _BT=$g($g($1.charvals,$1.L),$g($g($1.seq,$1.ti),0))!==undefined;if(_BT){$k[$j++]="pad";$k[$j++]=$1.ll;$1.encm();var _BV=$k[--$j];$1[$k[--$j]]=_BV;$1.submode=$1.L}else{var _Bf=$g($g($1.charvals,$1.P),$g($g($1.seq,$1.ti),0))!==undefined;if(_Bf){$k[$j++]="pad";$k[$j++]=$1.pl;$1.encm();var _Bh=$k[--$j];$1[$k[--$j]]=_Bh;$1.submode=$1.P}else{$k[$j++]="pad";$k[$j++]=$1.al;$1.encm();var _Bl=$k[--$j];$1[$k[--$j]]=_Bl;$1.submode=$1.A}}}else{$k[$j++]="pad";$k[$j++]=$1.ml;$1.encl();var _Bp=$k[--$j];$1[$k[--$j]]=_Bp;$1.submode=$1.M}}}else{$k[$j++]="pad";$k[$j++]=$1.ps;if($1[$g($1.textencfuncs,$1.submode)]()===true){return true}var _Bx=$k[--$j];$1[$k[--$j]]=_Bx}}$k[$j++]=Infinity;$q($1.text);$k[$j++]=$1.pad;$1.text=$a()}$1.out=$a(~~($1.text.length/2));for(var _C6=0,_C5=$1.out.length-1;_C6<=_C5;_C6+=1){$1.k=_C6;$p($1.out,$1.k,$f($g($1.text,$1.k*2)*30+$g($1.text,$1.k*2+1)))}$k[$j++]=$1.out};$1.encn=function(){$1.in=$k[--$j];$1.out=$a([]);for(var _CK=0,_CJ=$1.in.length-1;_CK<=_CJ;_CK+=44){$1.k=_CK;$k[$j++]=Infinity;var _CP=$1.in.length-$1.k;$k[$j++]=1;$k[$j++]=$1.in;$k[$j++]=$1.k;$k[$j++]=_CP;if(_CP>44){$j--;$k[$j++]=44}var _CQ=$k[--$j];var _CR=$k[--$j];var _CT=$G($k[--$j],_CR,_CQ);for(var _CU=0,_CV=_CT.length;_CU<_CV;_CU++){$k[$j++]=$f($g(_CT,_CU)-48)}$1.gmod=$a();$1.cwn=$a([]);for(;;){$1.dv=900;$1.gmul=$a([]);$1.val=0;for(;;){if($1.gmod.length==0){break}$1.val=$f($1.val*10+$g($1.gmod,0));$1.gmod=$G($1.gmod,1,$1.gmod.length-1);if($1.val<$1.dv){if($1.gmul.length!=0){$k[$j++]=Infinity;$q($1.gmul);$k[$j++]=0;$1.gmul=$a()}}else{$k[$j++]=Infinity;$q($1.gmul);$k[$j++]=~~($1.val/$1.dv);$1.gmul=$a()}$1.val=$1.val%$1.dv}$1.dv=$1.val;$k[$j++]=Infinity;$k[$j++]=$1.dv;$q($1.cwn);$1.cwn=$a();$1.gmod=$1.gmul;if($1.gmul.length==0){break}}$k[$j++]=Infinity;$q($1.out);$q($1.cwn);$1.out=$a()}$k[$j++]=$1.out};$1.ence=function(){var _D4=$f(-$g($k[--$j],0)-1e6);$k[$j++]=_D4;if(_D4<=899){var _D5=$k[--$j];$k[$j++]=927;$k[$j++]=_D5;$as($a(2))}else{var _D7=$k[--$j];$k[$j++]=_D7;if(_D7<=810899){var _D8=$k[--$j];$k[$j++]=926;$k[$j++]=~~(_D8/900)-1;$k[$j++]=_D8%900;$as($a(3))}else{var _DA=$k[--$j];$k[$j++]=_DA;if(_DA<=811799){var _DB=$k[--$j];$k[$j++]=925;$k[$j++]=$f(_DB-810900);$as($a(2))}else{$k[$j++]="bwipp.pdf417badECI#17816";$k[$j++]="PDF417 supports ECIs 000000 to 811799";bwipp_raiseerror()}}}};$1.encfuncs=$a(["enct","encn","encb"]);$1.addtocws=function(){var _DE=$k[--$j];$P($1.datcws,$1.j,_DE);$1.j=_DE.length+$1.j};$1.datcws=$a($1.seqlen);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.seq.length){break}$1.chars=$g($1.seq,$1.i);if($eq($t($1.chars),"arraytype")){if($g($1.chars,0)<=-1e6){$k[$j++]=$1.chars;$1.ence();$1.addtocws()}else{$k[$j++]=$1.chars;if($1[$g($1.encfuncs,$1.state)]()===true){break}$1.addtocws()}}else{$k[$j++]=$a([$g($1.latchcws,$1.chars)]);$1.addtocws();if($1.chars==$1.tl){$1.state=$1.T;$1.submode=$1.A}if($1.chars==$1.nl){$1.state=$1.N}if($1.chars==$1.bl||$1.chars==$1.bl6){$1.state=$1.B}if($1.chars==$1.bs){$1.i=$1.i+1;$k[$j++]=$g($1.seq,$1.i);$1.encb();$1.addtocws()}}$1.i=$1.i+1}$1.datcws=$G($1.datcws,0,$1.j)}if(!bwipp_micropdf417.__17915__){(function(){var $ctx=Object.create($1);$ctx.ccametrics=$a([$a([2,5,4,39,0,19]),$a([2,6,4,1,0,33]),$a([2,7,5,32,0,12]),$a([2,8,5,8,0,40]),$a([2,9,6,14,0,46]),$a([2,10,6,43,0,23]),$a([2,12,7,20,0,52]),$a([3,4,4,11,43,23]),$a([3,5,5,1,33,13]),$a([3,6,6,5,37,17]),$a([3,7,7,15,47,27]),$a([3,8,7,21,1,33]),$a([4,3,4,40,20,52]),$a([4,4,5,43,23,3]),$a([4,5,6,46,26,6]),$a([4,6,7,34,14,46]),$a([4,7,8,29,9,41])]);$ctx.nonccametrics=$a([$a([1,11,7,1,0,9]),$a([1,14,7,8,0,8]),$a([1,17,7,36,0,36]),$a([1,20,8,19,0,19]),$a([1,24,8,9,0,17]),$a([1,28,8,25,0,33]),$a([2,8,8,1,0,1]),$a([2,11,9,1,0,9]),$a([2,14,9,8,0,8]),$a([2,17,10,36,0,36]),$a([2,20,11,19,0,19]),$a([2,23,13,9,0,17]),$a([2,26,15,27,0,35]),$a([3,6,12,1,1,1]),$a([3,8,14,7,7,7]),$a([3,10,16,15,15,15]),$a([3,12,18,25,25,25]),$a([3,15,21,37,37,37]),$a([3,20,26,1,17,33]),$a([3,26,32,1,9,17]),$a([3,32,38,21,29,37]),$a([3,38,44,15,31,47]),$a([3,44,50,1,25,49]),$a([4,4,8,47,19,43]),$a([4,6,12,1,1,1]),$a([4,8,14,7,7,7]),$a([4,10,16,15,15,15]),$a([4,12,18,25,25,25]),$a([4,15,21,37,37,37]),$a([4,20,26,1,17,33]),$a([4,26,32,1,9,17]),$a([4,32,38,21,29,37]),$a([4,38,44,15,31,47]),$a([4,44,50,1,25,49])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_micropdf417.$ctx[id]=$ctx[id]);bwipp_micropdf417.__17915__=1})()}$k[$j++]="metrics";if($1.cca){$k[$j++]=$1.ccametrics}else{$k[$j++]=$1.nonccametrics}var _Eu=$k[--$j];$1[$k[--$j]]=_Eu;$1.urows=$1.rows;$1.ucols=$1.columns;$F($1.metrics,function(){$1.m=$k[--$j];$1.c=$g($1.m,0);$1.r=$g($1.m,1);$1.k=$g($1.m,2);$1.rapl=$g($1.m,3);$1.rapc=$g($1.m,4);$1.rapr=$g($1.m,5);$1.ncws=$f($1.r*$1.c-$1.k);$1.okay=true;if($1.datcws.length>$1.ncws){$1.okay=false}if($1.urows!=0&&$1.urows!=$1.r){$1.okay=false}if($1.ucols!=0&&$1.ucols!=$1.c){$1.okay=false}if($1.okay){return true}});if(!$1.okay){$k[$j++]="bwipp.micropdf417noValidSymbol#17939";$k[$j++]="Maximum length exceeded or invalid size";bwipp_raiseerror()}$1.m=$1.datcws.length;$1.n=$f($1.c*$1.r-$1.k);$1.cws=$a($f($1.c*$1.r+1));$P($1.cws,0,$1.datcws);$k[$j++]=$1.cws;$k[$j++]=$1.m;$k[$j++]=Infinity;for(var _Fc=0,_Fd=$f($1.n-$1.m);_Fc<_Fd;_Fc++){$k[$j++]=900}var _Fe=$a();var _Ff=$k[--$j];$P($k[--$j],_Ff,_Fe);$k[$j++]=$1.cws;$k[$j++]=$1.n;$k[$j++]=Infinity;for(var _Fk=0,_Fl=$1.k;_Fk<_Fl;_Fk++){$k[$j++]=0}$k[$j++]=0;var _Fm=$a();var _Fn=$k[--$j];$P($k[--$j],_Fn,_Fm);if(!bwipp_micropdf417.__17955__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;$k[$j++]=1;for(var _Fp=0,_Fq=928;_Fp<_Fq;_Fp++){var _Fr=$k[--$j];$k[$j++]=_Fr;$k[$j++]=_Fr*3%929}$ctx.rsalog=$a();$ctx.rslog=$a(929);for(var _Fu=1;_Fu<=928;_Fu+=1){$p($ctx.rslog,$g($ctx.rsalog,_Fu),_Fu)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_micropdf417.$ctx[id]=$ctx[id]);bwipp_micropdf417.__17955__=1})()}$1.rsprod=function(){var _Fz=$k[--$j];var _G0=$k[--$j];$k[$j++]=_G0;$k[$j++]=_Fz;if(_Fz!=0&&_G0!=0){var _G3=$g($1.rslog,$k[--$j]);var _G8=$g($1.rsalog,$f(_G3+$g($1.rslog,$k[--$j]))%928);$k[$j++]=_G8}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _GA=0,_GB=$1.k;_GA<_GB;_GA++){$k[$j++]=0}$1.coeffs=$a();for(var _GF=1,_GE=$1.k;_GF<=_GE;_GF+=1){$1.i=_GF;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _GM=$1.i-1;_GM>=1;_GM-=1){$1.j=_GM;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _GY=$k[--$j];var _GZ=$k[--$j];var _Ga=$k[--$j];$p($k[--$j],_Ga,$f(_GZ+_GY)%929)}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Gi=$k[--$j];var _Gj=$k[--$j];$p($k[--$j],_Gj,_Gi)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);for(var _Gp=$1.coeffs.length-1;_Gp>=0;_Gp-=2){var _Gq=$1.coeffs;$p(_Gq,_Gp,$f(929-$g(_Gq,_Gp)))}for(var _Gu=0,_Gt=$f($1.n-1);_Gu<=_Gt;_Gu+=1){$1.t=$f($g($1.cws,_Gu)+$g($1.cws,$1.n))%929;for(var _H2=0,_H1=$f($1.k-1);_H2<=_H1;_H2+=1){$1.j=_H2;$p($1.cws,$f($1.n+$1.j),$f($g($1.cws,$f($f($1.n+$1.j)+1))+$f(929-$1.t*$g($1.coeffs,$f($f($1.k-$1.j)-1))%929))%929)}}for(var _HJ=$1.n,_HI=$f($1.n+$1.k);_HJ<=_HI;_HJ+=1){$p($1.cws,_HJ,$f(929-$g($1.cws,_HJ))%929)}$1.cws=$G($1.cws,0,$1.cws.length-1);var _HR=$g($1.options,"debugcws")!==undefined;if(_HR){$k[$j++]="bwipp.debugcws#17993";$k[$j++]=$1.cws;bwipp_raiseerror()}if(!bwipp_micropdf417.__18252__){(function(){var $ctx=Object.create($1);$ctx.clusters=$a([$a([120256,125680,128380,120032,125560,128318,108736,119920,108640,86080,108592,86048,110016,120560,125820,109792,120440,125758,88256,109680,88160,89536,110320,120700,89312,110200,120638,89200,110140,89840,110460,89720,110398,89980,128506,119520,125304,128190,107712,119408,125244,107616,119352,84032,107568,119324,84e3,107544,83984,108256,119672,125374,85184,108144,119612,85088,108088,119582,85040,108060,85728,108408,119742,85616,108348,85560,108318,85880,108478,85820,85790,107200,119152,125116,107104,119096,125086,83008,107056,119068,82976,107032,82960,82952,83648,107376,119228,83552,107320,119198,83504,107292,83480,83468,83824,107452,83768,107422,83740,83900,106848,118968,125022,82496,106800,118940,82464,106776,118926,82448,106764,82440,106758,82784,106936,119006,82736,106908,82712,106894,82700,82694,106974,82830,82240,106672,118876,82208,106648,118862,82192,106636,82184,106630,82180,82352,82328,82316,82080,118830,106572,106566,82050,117472,124280,127678,103616,117360,124220,103520,117304,124190,75840,103472,75808,104160,117624,124350,76992,104048,117564,76896,103992,76848,76824,77536,104312,117694,77424,104252,77368,77340,77688,104382,77628,77758,121536,126320,128700,121440,126264,128670,111680,121392,126236,111648,121368,126222,111632,121356,103104,117104,124092,112320,103008,117048,124062,112224,121656,126366,93248,74784,102936,117006,93216,112152,93200,75456,103280,117180,93888,75360,103224,117150,93792,112440,121758,93744,75288,93720,75632,103356,94064,75576,103326,94008,112542,93980,75708,94140,75678,94110,121184,126136,128606,111168,121136,126108,111136,121112,126094,111120,121100,111112,111108,102752,116920,123998,111456,102704,116892,91712,74272,121244,116878,91680,74256,102668,91664,111372,102662,74244,74592,102840,116958,92e3,74544,102812,91952,111516,102798,91928,74508,74502,74680,102878,92088,74652,92060,74638,92046,92126,110912,121008,126044,110880,120984,126030,110864,120972,110856,120966,110852,110850,74048,102576,116828,90944,74016,102552,116814,90912,111e3,121038,90896,73992,102534,90888,110982,90884,74160,102620,91056,74136,102606,91032,111054,91020,74118,91014,91100,91086,110752,120920,125998,110736,120908,110728,120902,110724,110722,73888,102488,116782,90528,73872,102476,90512,110796,102470,90504,73860,90500,73858,73944,90584,90572,90566,120876,120870,110658,102444,73800,90312,90308,90306,101056,116080,123580,100960,116024,70720,100912,115996,70688,100888,70672,70664,71360,101232,116156,71264,101176,116126,71216,101148,71192,71180,71536,101308,71480,101278,71452,71612,71582,118112,124600,127838,105024,118064,124572,104992,118040,124558,104976,118028,104968,118022,100704,115896,123486,105312,100656,115868,79424,70176,118172,115854,79392,105240,100620,79376,70152,79368,70496,100792,115934,79712,70448,118238,79664,105372,100750,79640,70412,79628,70584,100830,79800,70556,79772,70542,70622,79838,122176,126640,128860,122144,126616,128846,122128,126604,122120,126598,122116,104768,117936,124508,113472,104736,126684,124494,113440,122264,126670,113424,104712,117894,113416,122246,104706,69952,100528,115804,78656,69920,100504,115790,96064,78624,104856,117966,96032,113560,122318,100486,96016,78600,104838,96008,69890,70064,100572,78768,70040,100558,96176,78744,104910,96152,113614,70022,78726,70108,78812,70094,96220,78798,122016,126552,128814,122e3,126540,121992,126534,121988,121986,104608,117848,124462,113056,104592,126574,113040,122060,117830,113032,104580,113028,104578,113026,69792,100440,115758,78240,69776,100428,95136,78224,104652,100422,95120,113100,69764,95112,78212,69762,78210,69848,100462,78296,69836,95192,78284,69830,95180,78278,69870,95214,121936,126508,121928,126502,121924,121922,104528,117804,112848,104520,117798,112840,121958,112836,104514,112834,69712,100396,78032,69704,100390,94672,78024,104550,94664,112870,69698,94660,78018,94658,78060,94700,94694,126486,121890,117782,104484,104482,69672,77928,94440,69666,77922,99680,68160,99632,68128,99608,115342,68112,99596,68104,99590,68448,99768,115422,68400,99740,68376,99726,68364,68358,68536,99806,68508,68494,68574,101696,116400,123740,101664,116376,101648,116364,101640,116358,101636,67904,99504,115292,72512,67872,116444,115278,72480,101784,116430,72464,67848,99462,72456,101766,67842,68016,99548,72624,67992,99534,72600,101838,72588,67974,68060,72668,68046,72654,118432,124760,127918,118416,124748,118408,124742,118404,118402,101536,116312,105888,101520,116300,105872,118476,116294,105864,101508,105860,101506,105858,67744,99416,72096,67728,116334,80800,72080,101580,99398,80784,105932,67716,80776,72068,67714,72066,67800,99438,72152,67788,80856,72140,67782,80844,72134,67822,72174,80878,126800,128940,126792,128934,126788,126786,118352,124716,122576,126828,124710,122568,126822,122564,118338,122562,101456,116268,105680,101448,116262,114128,105672,118374,114120,122598,101442,114116,105666,114114,67664,99372,71888,67656,99366,80336,71880,101478,97232,80328,105702,67650,97224,114150,71874,97220,67692,71916,67686,80364,71910,97260,80358,97254,126760,128918,126756,126754,118312,124694,122472,126774,122468,118306,122466,101416,116246,105576,101412,113896,105572,101410,113892,105570,113890,67624,99350,71784,101430,80104,71780,67618,96744,80100,71778,96740,80098,96738,71798,96758,126738,122420,122418,105524,113780,113778,71732,79988,96500,96498,66880,66848,98968,66832,66824,66820,66992,66968,66956,66950,67036,67022,1e5,99984,115532,99976,115526,99972,99970,66720,98904,69024,100056,98892,69008,100044,69e3,100038,68996,66690,68994,66776,98926,69080,100078,69068,66758,69062,66798,69102,116560,116552,116548,116546,99920,102096,116588,115494,102088,116582,102084,99906,102082,66640,68816,66632,98854,73168,68808,66628,73160,68804,66626,73156,68802,66668,68844,66662,73196,68838,73190,124840,124836,124834,116520,118632,124854,118628,116514,118626,99880,115478,101992,116534,106216,101988,99874,106212,101986,106210,66600,98838,68712,99894,72936,68708,66594,81384,72932,68706,81380,72930,66614,68726,72950,81398,128980,128978,124820,126900,124818,126898,116500,118580,116498,122740,118578,122738,99860,101940,99858,106100,101938,114420]),$a([128352,129720,125504,128304,129692,125472,128280,129678,125456,128268,125448,128262,125444,125792,128440,129758,120384,125744,128412,120352,125720,128398,120336,125708,120328,125702,120324,120672,125880,128478,110144,120624,125852,110112,120600,125838,110096,120588,110088,120582,110084,110432,120760,125918,89664,110384,120732,89632,110360,120718,89616,110348,89608,110342,89952,110520,120798,89904,110492,89880,110478,89868,90040,110558,90012,89998,125248,128176,129628,125216,128152,129614,125200,128140,125192,128134,125188,125186,119616,125360,128220,119584,125336,128206,119568,125324,119560,125318,119556,119554,108352,119728,125404,108320,119704,125390,108304,119692,108296,119686,108292,108290,85824,108464,119772,85792,108440,119758,85776,108428,85768,108422,85764,85936,108508,85912,108494,85900,85894,85980,85966,125088,128088,129582,125072,128076,125064,128070,125060,125058,119200,125144,128110,119184,125132,119176,125126,119172,119170,107424,119256,125166,107408,119244,107400,119238,107396,107394,83872,107480,119278,83856,107468,83848,107462,83844,83842,83928,107502,83916,83910,83950,125008,128044,125e3,128038,124996,124994,118992,125036,118984,125030,118980,118978,106960,119020,106952,119014,106948,106946,82896,106988,82888,106982,82884,82882,82924,82918,124968,128022,124964,124962,118888,124982,118884,118882,106728,118902,106724,106722,82408,106742,82404,82402,124948,124946,118836,118834,106612,106610,124224,127664,129372,124192,127640,129358,124176,127628,124168,127622,124164,124162,117568,124336,127708,117536,124312,127694,117520,124300,117512,124294,117508,117506,104256,117680,124380,104224,117656,124366,104208,117644,104200,117638,104196,104194,77632,104368,117724,77600,104344,117710,77584,104332,77576,104326,77572,77744,104412,77720,104398,77708,77702,77788,77774,128672,129880,93168,128656,129868,92664,128648,129862,92412,128644,128642,124064,127576,129326,126368,124048,129902,126352,128716,127558,126344,124036,126340,124034,126338,117152,124120,127598,121760,117136,124108,121744,126412,124102,121736,117124,121732,117122,121730,103328,117208,124142,112544,103312,117196,112528,121804,117190,112520,103300,112516,103298,112514,75680,103384,117230,94112,75664,103372,94096,112588,103366,94088,75652,94084,75650,75736,103406,94168,75724,94156,75718,94150,75758,128592,129836,91640,128584,129830,91388,128580,91262,128578,123984,127532,126160,123976,127526,126152,128614,126148,123970,126146,116944,124012,121296,116936,124006,121288,126182,121284,116930,121282,102864,116972,111568,102856,116966,111560,121318,111556,102850,111554,74704,102892,92112,74696,102886,92104,111590,92100,74690,92098,74732,92140,74726,92134,128552,129814,90876,128548,90750,128546,123944,127510,126056,128566,126052,123938,126050,116840,123958,121064,116836,121060,116834,121058,102632,116854,111080,121078,111076,102626,111074,74216,102646,91112,74212,91108,74210,91106,74230,91126,128532,90494,128530,123924,126004,123922,126002,116788,120948,116786,120946,102516,110836,102514,110834,73972,90612,73970,90610,128522,123914,125978,116762,120890,102458,110714,123552,127320,129198,123536,127308,123528,127302,123524,123522,116128,123608,127342,116112,123596,116104,123590,116100,116098,101280,116184,123630,101264,116172,101256,116166,101252,101250,71584,101336,116206,71568,101324,71560,101318,71556,71554,71640,101358,71628,71622,71662,127824,129452,79352,127816,129446,79100,127812,78974,127810,123472,127276,124624,123464,127270,124616,127846,124612,123458,124610,115920,123500,118224,115912,123494,118216,124646,118212,115906,118210,100816,115948,105424,100808,115942,105416,118246,105412,100802,105410,70608,100844,79824,70600,100838,79816,105446,79812,70594,79810,70636,79852,70630,79846,129960,95728,113404,129956,95480,113278,129954,95356,95294,127784,129430,78588,128872,129974,95996,78462,128868,127778,95870,128866,123432,127254,124520,123428,126696,128886,123426,126692,124514,126690,115816,123446,117992,115812,122344,117988,115810,122340,117986,122338,100584,115830,104936,100580,113640,104932,100578,113636,104930,113634,70120,100598,78824,70116,96232,78820,70114,96228,78818,96226,70134,78838,129940,94968,113022,129938,94844,94782,127764,78206,128820,127762,95102,128818,123412,124468,123410,126580,124466,126578,115764,117876,115762,122100,117874,122098,100468,104692,100466,113140,104690,113138,69876,78324,69874,95220,78322,95218,129930,94588,94526,127754,128794,123402,124442,126522,115738,117818,121978,100410,104570,112890,69754,78074,94714,94398,123216,127148,123208,127142,123204,123202,115408,123244,115400,123238,115396,115394,99792,115436,99784,115430,99780,99778,68560,99820,68552,99814,68548,68546,68588,68582,127400,129238,72444,127396,72318,127394,123176,127126,123752,123172,123748,123170,123746,115304,123190,116456,115300,116452,115298,116450,99560,115318,101864,99556,101860,99554,101858,68072,99574,72680,68068,72676,68066,72674,68086,72694,129492,80632,105854,129490,80508,80446,127380,72062,127924,127378,80766,127922,123156,123700,123154,124788,123698,124786,115252,116340,115250,118516,116338,118514,99444,101620,99442,105972,101618,105970,67828,72180,67826,80884,72178,80882,97008,114044,96888,113982,96828,96798,129482,80252,130010,97148,80190,97086,127370,127898,128954,123146,123674,124730,126842,115226,116282,118394,122618,99386,101498,105722,114170,67706,71930,80378,96632,113854,96572,96542,80062,96702,96444,96414,96350,123048,123044,123042,115048,123062,115044,115042,99048,115062,99044,99042,67048,99062,67044,67042,67062,127188,68990,127186,123028,123316,123026,123314,114996,115572,114994,115570,98932,100084,98930,100082,66804,69108,66802,69106,129258,73084,73022,127178,127450,123018,123290,123834,114970,115514,116602,98874,99962,102138,66682,68858,73210,81272,106174,81212,81182,72894,81342,97648,114364,97592,114334,97564,97550,81084,97724,81054,97694,97464,114270,97436,97422,80990,97502,97372,97358,97326,114868,114866,98676,98674,66292,66290,123098,114842,115130,98618,99194,66170,67322,69310,73404,73374,81592,106334,81564,81550,73310,81630,97968,114524,97944,114510,97932,97926,81500,98012,81486,97998,97880,114478,97868,97862,81454,97902,97836,97830,69470,73564,73550,81752,106414,81740,81734,73518,81774,81708,81702]),$a([109536,120312,86976,109040,120060,86496,108792,119934,86256,108668,86136,129744,89056,110072,129736,88560,109820,129732,88312,109694,129730,88188,128464,129772,89592,128456,129766,89340,128452,89214,128450,125904,128492,125896,128486,125892,125890,120784,125932,120776,125926,120772,120770,110544,120812,110536,120806,110532,84928,108016,119548,84448,107768,119422,84208,107644,84088,107582,84028,129640,85488,108284,129636,85240,108158,129634,85116,85054,128232,129654,85756,128228,85630,128226,125416,128246,125412,125410,119784,125430,119780,119778,108520,119798,108516,108514,83424,107256,119166,83184,107132,83064,107070,83004,82974,129588,83704,107390,129586,83580,83518,128116,83838,128114,125172,125170,119284,119282,107508,107506,82672,106876,82552,106814,82492,82462,129562,82812,82750,128058,125050,119034,82296,106686,82236,82206,82366,82108,82078,76736,103920,117500,76256,103672,117374,76016,103548,75896,103486,75836,129384,77296,104188,129380,77048,104062,129378,76924,76862,127720,129398,77564,127716,77438,127714,124392,127734,124388,124386,117736,124406,117732,117730,104424,117750,104420,104418,112096,121592,126334,92608,111856,121468,92384,111736,121406,92272,111676,92216,111646,92188,75232,103160,117118,93664,74992,103036,93424,112252,102974,93304,74812,93244,74782,93214,129332,75512,103294,129908,129330,93944,75388,129906,93820,75326,93758,127604,75646,128756,127602,94078,128754,124148,126452,124146,126450,117236,121844,117234,121842,103412,103410,91584,111344,121212,91360,111224,121150,91248,111164,91192,111134,91164,91150,74480,102780,91888,74360,102718,91768,111422,91708,74270,91678,129306,74620,129850,92028,74558,91966,127546,128634,124026,126202,116986,121338,102906,90848,110968,121022,90736,110908,90680,110878,90652,90638,74104,102590,91e3,74044,90940,74014,90910,74174,91070,90480,110780,90424,110750,90396,90382,73916,90556,73886,90526,90296,110686,90268,90254,73822,90334,90204,90190,71136,101112,116094,70896,100988,70776,100926,70716,70686,129204,71416,101246,129202,71292,71230,127348,71550,127346,123636,123634,116212,116210,101364,101362,79296,105200,118140,79072,105080,118078,78960,105020,78904,104990,78876,78862,70384,100732,79600,70264,100670,79480,105278,79420,70174,79390,129178,70524,129466,79740,70462,79678,127290,127866,123514,124666,115962,118266,100858,113376,122232,126654,95424,113264,122172,95328,113208,122142,95280,113180,95256,113166,95244,78560,104824,117950,95968,78448,104764,95856,113468,104734,95800,78364,95772,78350,95758,70008,100542,78712,69948,96120,78652,69918,96060,78622,96030,70078,78782,96190,94912,113008,122044,94816,112952,122014,94768,112924,94744,112910,94732,94726,78192,104636,95088,78136,104606,95032,113054,95004,78094,94990,69820,78268,69790,95164,78238,95134,94560,112824,121950,94512,112796,94488,112782,94476,94470,78008,104542,94648,77980,94620,77966,94606,69726,78046,94686,94384,112732,94360,112718,94348,94342,77916,94428,77902,94414,94296,112686,94284,94278,77870,94318,94252,94246,68336,99708,68216,99646,68156,68126,68476,68414,127162,123258,115450,99834,72416,101752,116414,72304,101692,72248,101662,72220,72206,67960,99518,72568,67900,72508,67870,72478,68030,72638,80576,105840,118460,80480,105784,118430,80432,105756,80408,105742,80396,80390,72048,101564,80752,71992,101534,80696,71964,80668,71950,80654,67772,72124,67742,80828,72094,80798,114016,122552,126814,96832,113968,122524,96800,113944,122510,96784,113932,96776,113926,96772,80224,105656,118366,97120,80176,105628,97072,114076,105614,97048,80140,97036,80134,97030,71864,101470,80312,71836,97208,80284,71822,97180,80270,97166,67678,71902,80350,97246,96576,113840,122460,96544,113816,122446,96528,113804,96520,113798,96516,96514,80048,105564,96688,80024,105550,96664,113870,96652,80006,96646,71772,80092,71758,96732,80078,96718,96416,113752,122414,96400,113740,96392,113734,96388,96386,79960,105518,96472,79948,96460,79942,96454,71726,79982,96494,96336,113708,96328,113702,96324,96322,79916,96364,79910,96358,96296,113686,96292,96290,79894,96310,66936,99006,66876,66846,67006,68976,100028,68920,99998,68892,68878,66748,69052,66718,69022,73056,102072,116574,73008,102044,72984,102030,72972,72966,68792,99934,73144,68764,73116,68750,73102,66654,68830,73182,81216,106160,118620,81184,106136,118606,81168,106124,81160,106118,81156,81154,72880,101980,81328,72856,101966,81304,106190,81292,72838,81286,68700,72924,68686,81372,72910,81358,114336,122712,126894,114320,122700,114312,122694,114308,114306,81056,106072,118574,97696,81040,106060,97680,114380,106054,97672,81028,97668,81026,97666,72792,101934,81112,72780,97752,81100,72774,97740,81094,97734,68654,72814,81134,97774,114256,122668,114248,122662,114244,114242,80976,106028,97488,80968,106022,97480,114278,97476,80962,97474,72748,81004,72742,97516,80998,97510,114216,122646,114212,114210,80936,106006,97384,80932,97380,80930,97378,72726,80950,97398,114196,114194,80916,97332,80914,97330,66236,66206,67256,99166,67228,67214,66142,67294,69296,100188,69272,100174,69260,69254,67164,69340,67150,69326,73376,102232,116654,73360,102220,73352,102214,73348,73346,69208,100142,73432,102254,73420,69190,73414,67118,69230,73454,106320,118700,106312,118694,106308,106306,73296,102188,81616,106348,102182,81608,73284,81604,73282,81602,69164,73324,69158,81644,73318,81638,122792,126934,122788,122786,106280,118678,114536,106276,114532,106274,114530,73256,102166,81512,73252,98024,81508,73250,98020,81506,98018,69142,73270,81526,98038,122772,122770,106260,114484,106258,114482,73236,81460,73234,97908,81458,97906,122762,106250,114458,73226,81434,97850,66396,66382,67416,99246,67404,67398,66350,67438,69456,100268,69448,100262,69444,69442,67372,69484,67366,69478,102312,116694,102308,102306,69416,100246,73576,102326,73572,69410,73570,67350,69430,73590,118740,118738,102292,106420,102290,106418,69396,73524,69394,81780,73522,81778,118730,102282,106394,69386,73498,81722,66476,66470,67496,99286,67492,67490,66454,67510,100308,100306,67476,69556,67474,69554,116714])]);$ctx.raps=$a([$a([802,930,946,818,882,890,826,954,922,986,970,906,778,794,786,914,978,982,980,916,948,932,934,942,940,936,808,812,814,806,822,950,918,790,788,820,884,868,870,878,876,872,840,856,860,862,846,844,836,838,834,866]),$a([718,590,622,558,550,566,534,530,538,570,562,546,610,626,634,762,754,758,630,628,612,614,582,578,706,738,742,740,748,620,556,552,616,744,712,716,708,710,646,654,652,668,664,696,688,656,720,592,600,604,732,734])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_micropdf417.$ctx[id]=$ctx[id]);bwipp_micropdf417.__18252__=1})()}$1.cwtobits=function(){var _Hd=$g($1.clusters,$k[--$j]);$1.v=$g(_Hd,$k[--$j]);$k[$j++]=Infinity;for(var _Hg=0,_Hh=17;_Hg<_Hh;_Hg++){$k[$j++]=0}var _Hk=$R($s(17),$1.v,2);for(var _Hl=0,_Hm=_Hk.length;_Hl<_Hm;_Hl++){$k[$j++]=$g(_Hk,_Hl)-48}var _Ho=$a();$k[$j++]=$G(_Ho,_Ho.length-17,17)};$1.raptobits=function(){var _Hs=$g($1.raps,$k[--$j]);$1.v=$g(_Hs,$k[--$j]);$k[$j++]=Infinity;for(var _Hv=0,_Hw=10;_Hv<_Hw;_Hv++){$k[$j++]=0}var _Hz=$R($s(10),$1.v,2);for(var _I0=0,_I1=_Hz.length;_I0<_I1;_I0++){$k[$j++]=$g(_Hz,_I0)-48}var _I3=$a();$k[$j++]=$G(_I3,_I3.length-10,10)};$1.rwid=$g($a([38,55,82,99]),$f($1.c-1));if($1.c==3&&$1.cca){$1.rwid=72}$1.pixs=$a($1.rwid*$1.r);for(var _IF=0,_IE=$f($1.r-1);_IF<=_IE;_IF+=1){$1.i=_IF;$1.clst=$f($f($1.i+$1.rapl)-1)%3;$k[$j++]=$1.pixs;$k[$j++]=$1.rwid*$1.i;$k[$j++]=Infinity;if($1.c==1){$k[$j++]=$f($f($1.i+$1.rapl)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$f($f($1.i+$1.rapr)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j])}if($1.c==2){$k[$j++]=$f($f($1.i+$1.rapl)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*2);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*2+1);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$f($f($1.i+$1.rapr)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j])}if($1.c==3){if(!$1.cca){$k[$j++]=$f($f($1.i+$1.rapl)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j])}$k[$j++]=$g($1.cws,$1.i*3);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$f($f($1.i+$1.rapc)-1)%52;$k[$j++]=1;$1.raptobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*3+1);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*3+2);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$f($f($1.i+$1.rapr)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j])}if($1.c==4){$k[$j++]=$f($f($1.i+$1.rapl)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*4);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*4+1);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$f($f($1.i+$1.rapc)-1)%52;$k[$j++]=1;$1.raptobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*4+2);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$g($1.cws,$1.i*4+3);$k[$j++]=$1.clst;$1.cwtobits();$q($k[--$j]);$k[$j++]=$f($f($1.i+$1.rapr)-1)%52;$k[$j++]=0;$1.raptobits();$q($k[--$j])}$k[$j++]=1;var _Ji=$a();var _Jj=$k[--$j];$P($k[--$j],_Jj,_Ji)}var _Js=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.rwid],["pixy",$1.r],["height",$1.r/72*$1.rowmult],["width",$1.rwid/72],["opt",$1.options]]);$k[$j++]=_Js;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_datamatrix(){var $1=Object.create(bwipp_datamatrix.$ctx||(bwipp_datamatrix.$ctx={}));$1.dontdraw=false;$1.columns=0;$1.rows=0;$1.format="unset";$1.version="unset";$1.parse=false;$1.parsefnc=false;$1.c40headerlength=-1;$1.raw=false;$1.dmre=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.datamatrixEmptyData#18375";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($ne($1.version,"unset")&&($1.rows!=0||$1.columns!=0)){$k[$j++]="bwipp.datamatrixVersionRowsCols#18379";$k[$j++]="rows and columns must not be given if version is specified";bwipp_raiseerror()}if($ne($1.version,"unset")){$X($1.version,"x");if($k[--$j]){var _9=$k[--$j];var _A=$k[--$j];$k[$j++]=_9;$k[$j++]=_A;$j--;var _B=$k[--$j];var _C=$k[--$j];$k[$j++]=_C;$k[$j++]=_B;$k[$j++]=_C;$k[$j++]=_B;$as($a(2));$F($k[--$j],function(){var _F=$k[--$j];$k[$j++]=_F;$k[$j++]=true;if(_F.length==0){$j--;$k[$j++]=false}var _G=$k[--$j];var _H=$k[--$j];$k[$j++]=_G;$F(_H,function(){var _I=$k[--$j];if(_I<48||_I>57){$j--;$k[$j++]=false}});if($nt($k[--$j])){$k[$j++]="bwipp.datamatrixVersionBadRowOrColumn#18393";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}});$1.rows=$i($k[--$j]);$1.columns=$i($k[--$j]);$k[$j++]="format";if($1.rows==$1.columns){$k[$j++]="square"}else{$k[$j++]="rectangle"}var _O=$k[--$j];$1[$k[--$j]]=_O}else{$j--;$k[$j++]="bwipp.datamatrixVersionFormat#18400";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}}else{if($eq($1.format,"unset")){$k[$j++]="format";if($1.dmre){$k[$j++]="rectangle"}else{$k[$j++]="square"}var _S=$k[--$j];$1[$k[--$j]]=_S}}if($ne($1.format,"square")&&$ne($1.format,"rectangle")){$k[$j++]="bwipp.datamatrixInvalidFormat#18409";$k[$j++]="The format must be either square or rectangle";bwipp_raiseerror()}if(!bwipp_datamatrix.__18469__){(function(){var $ctx=Object.create($1);var _18=$a([16,64,1,4,36,1,1]);$ctx.metrics=$a([$a([10,10,1,1,5,1,0]),$a([12,12,1,1,7,1,0]),$a([14,14,1,1,10,1,0]),$a([16,16,1,1,12,1,0]),$a([18,18,1,1,14,1,0]),$a([20,20,1,1,18,1,0]),$a([22,22,1,1,20,1,0]),$a([24,24,1,1,24,1,0]),$a([26,26,1,1,28,1,0]),$a([32,32,2,2,36,1,0]),$a([36,36,2,2,42,1,0]),$a([40,40,2,2,48,1,0]),$a([44,44,2,2,56,1,0]),$a([48,48,2,2,68,1,0]),$a([52,52,2,2,84,2,0]),$a([64,64,4,4,112,2,0]),$a([72,72,4,4,144,4,0]),$a([80,80,4,4,192,4,0]),$a([88,88,4,4,224,4,0]),$a([96,96,4,4,272,4,0]),$a([104,104,4,4,336,6,0]),$a([120,120,6,6,408,6,0]),$a([132,132,6,6,496,8,0]),$a([144,144,6,6,620,10,0]),$a([8,18,1,1,7,1,0]),$a([8,32,1,2,11,1,0]),$a([8,48,1,2,15,1,1]),$a([8,64,1,4,18,1,1]),$a([8,80,1,4,22,1,1]),$a([8,96,1,4,28,1,1]),$a([8,120,1,6,32,1,1]),$a([8,144,1,6,36,1,1]),$a([12,26,1,1,14,1,0]),$a([12,36,1,2,18,1,0]),$a([12,64,1,4,27,1,1]),$a([12,88,1,4,36,1,1]),$a([16,36,1,2,24,1,0]),$a([16,48,1,2,28,1,0]),_18,$a([20,36,1,2,28,1,1]),$a([20,44,1,2,34,1,1]),$a([20,64,1,4,42,1,1]),$a([22,48,1,2,38,1,1]),$a([24,48,1,2,41,1,1]),$a([24,64,1,4,46,1,1]),$a([26,40,1,2,38,1,1]),$a([26,48,1,2,42,1,1]),$a([26,64,1,4,50,1,1])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_datamatrix.$ctx[id]=$ctx[id]);bwipp_datamatrix.__18469__=1})()}$1.urows=$1.rows;$1.ucols=$1.columns;$1.fullcws=$a([]);var _1N=$1.metrics;for(var _1O=0,_1P=_1N.length;_1O<_1P;_1O++){$1.m=$g(_1N,_1O);$1.rows=$g($1.m,0);$1.cols=$g($1.m,1);$1.regh=$g($1.m,2);$1.regv=$g($1.m,3);$1.rscw=$g($1.m,4);$1.rsbl=$g($1.m,5);$1.doly=$g($1.m,6);$1.mrows=$f($1.rows-2*$1.regh);$1.mcols=$f($1.cols-2*$1.regv);$1.ncws=$f(~~($1.mrows*$1.mcols/8)-$1.rscw);$1.okay=true;if($1.urows!=0&&$1.urows!=$1.rows){$1.okay=false}if($1.ucols!=0&&$1.ucols!=$1.cols){$1.okay=false}if($eq($1.format,"square")&&$ne($1.rows,$1.cols)){$1.okay=false}if($eq($1.format,"rectangle")&&$eq($1.rows,$1.cols)){$1.okay=false}if(!$1.dmre&&$1.doly==1){$1.okay=false}if($1.okay){$k[$j++]=Infinity;$q($1.fullcws);$k[$j++]=$1.ncws;$1.fullcws=$a()}}$k[$j++]=Infinity;for(var _24=0,_25=1558;_24<_25;_24++){$k[$j++]=1e4}$1.numremcws=$a();var _27=$1.fullcws;for(var _28=0,_29=_27.length;_28<_29;_28++){$p($1.numremcws,$f($g(_27,_28)-1),1)}for(var _2C=1556;_2C>=0;_2C-=1){$1.i=_2C;if($g($1.numremcws,$1.i)!=1){$p($1.numremcws,$1.i,$f($g($1.numremcws,$1.i+1)+1))}}if(!bwipp_datamatrix.__18615__){(function(){var $ctx=Object.create($1);$ctx.fnc1=-1;$ctx.prog=-2;$ctx.m05=-3;$ctx.m06=-4;$ctx.lC=-5;$ctx.lB=-6;$ctx.lX=-7;$ctx.lT=-8;$ctx.lE=-9;$ctx.unl=-10;$ctx.sapp=-11;$ctx.usft=-12;$ctx.sft1=-13;$ctx.sft2=-14;$ctx.sft3=-15;$ctx.eci=-16;$ctx.pad=-17;$ctx.unlcw=254;$k[$j++]=Infinity;for(var _2L=0;_2L<=128;_2L+=1){$k[$j++]=_2L;$k[$j++]=_2L+1}$k[$j++]=$ctx.pad;$k[$j++]=129;for(var _2N=0;_2N<=99;_2N+=1){var _2P=$R($s(2),_2N,10);var _2R=$Z($s(2),"00");$P(_2R,2-_2P.length,_2P);$k[$j++]=_2R;$k[$j++]=_2N+130}var _2e=$a([$ctx.lC,$ctx.lB,$ctx.fnc1,$ctx.sapp,$ctx.prog,$ctx.usft,$ctx.m05,$ctx.m06,$ctx.lX,$ctx.lT,$ctx.lE,$ctx.eci]);$k[$j++]=229;for(var _2f=0,_2g=_2e.length;_2f<_2g;_2f++){var _2j=$f($k[--$j]+1);$k[$j++]=$g(_2e,_2f);$k[$j++]=_2j;$k[$j++]=_2j}$j--;$ctx.Avals=$d();$k[$j++]=Infinity;var _2l=$ctx.Avals;for(var _2q=_2l.size,_2p=_2l.keys(),_2o=0;_2o<_2q;_2o++){var _2m=_2p.next().value;$k[$j++]=_2m;$k[$j++]=_2l.get(_2m);$k[$j++]=Infinity;var _2r=$k[--$j];var _2s=$k[--$j];$k[$j++]=_2r;$k[$j++]=_2s;var _2t=$a();$k[$j++]=_2t}$ctx.Avals=$d();$k[$j++]=Infinity;$k[$j++]=$ctx.sft1;$k[$j++]=0;$k[$j++]=$ctx.sft2;$k[$j++]=1;$k[$j++]=$ctx.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _2y=48;_2y<=57;_2y+=1){$k[$j++]=_2y;$k[$j++]=_2y-44}for(var _2z=65;_2z<=90;_2z+=1){$k[$j++]=_2z;$k[$j++]=_2z-51}$ctx.CNvals=$d();$k[$j++]=Infinity;for(var _31=0;_31<=31;_31+=1){$k[$j++]=_31;$k[$j++]=_31}$ctx.C1vals=$d();$k[$j++]=Infinity;for(var _33=33;_33<=47;_33+=1){$k[$j++]=_33;$k[$j++]=_33-33}for(var _34=58;_34<=64;_34+=1){$k[$j++]=_34;$k[$j++]=_34-43}for(var _35=91;_35<=95;_35+=1){$k[$j++]=_35;$k[$j++]=_35-69}$k[$j++]=$ctx.fnc1;$k[$j++]=27;$k[$j++]=$ctx.usft;$k[$j++]=30;$ctx.C2vals=$d();$k[$j++]=Infinity;for(var _39=96;_39<=127;_39+=1){$k[$j++]=_39;$k[$j++]=_39-96}$ctx.C3vals=$d();$k[$j++]=Infinity;var _3B=$ctx.CNvals;for(var _3G=_3B.size,_3F=_3B.keys(),_3E=0;_3E<_3G;_3E++){var _3C=_3F.next().value;$k[$j++]=_3C;$k[$j++]=_3B.get(_3C);$k[$j++]=Infinity;var _3H=$k[--$j];var _3I=$k[--$j];$k[$j++]=_3H;$k[$j++]=_3I;var _3J=$a();$k[$j++]=_3J}var _3K=$ctx.C1vals;for(var _3P=_3K.size,_3O=_3K.keys(),_3N=0;_3N<_3P;_3N++){var _3L=_3O.next().value;$k[$j++]=_3L;$k[$j++]=_3K.get(_3L);$k[$j++]=Infinity;var _3Q=$k[--$j];var _3R=$k[--$j];$k[$j++]=_3Q;$k[$j++]=$g($ctx.CNvals,$ctx.sft1);$k[$j++]=_3R;var _3V=$a();$k[$j++]=_3V}var _3W=$ctx.C2vals;for(var _3b=_3W.size,_3a=_3W.keys(),_3Z=0;_3Z<_3b;_3Z++){var _3X=_3a.next().value;$k[$j++]=_3X;$k[$j++]=_3W.get(_3X);$k[$j++]=Infinity;var _3c=$k[--$j];var _3d=$k[--$j];$k[$j++]=_3c;$k[$j++]=$g($ctx.CNvals,$ctx.sft2);$k[$j++]=_3d;var _3h=$a();$k[$j++]=_3h}var _3i=$ctx.C3vals;for(var _3n=_3i.size,_3m=_3i.keys(),_3l=0;_3l<_3n;_3l++){var _3j=_3m.next().value;$k[$j++]=_3j;$k[$j++]=_3i.get(_3j);$k[$j++]=Infinity;var _3o=$k[--$j];var _3p=$k[--$j];$k[$j++]=_3o;$k[$j++]=$g($ctx.CNvals,$ctx.sft3);$k[$j++]=_3p;var _3t=$a();$k[$j++]=_3t}$ctx.Cvals=$d();$k[$j++]=Infinity;$k[$j++]=$ctx.sft1;$k[$j++]=0;$k[$j++]=$ctx.sft2;$k[$j++]=1;$k[$j++]=$ctx.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _3y=48;_3y<=57;_3y+=1){$k[$j++]=_3y;$k[$j++]=_3y-44}for(var _3z=97;_3z<=122;_3z+=1){$k[$j++]=_3z;$k[$j++]=_3z-83}$ctx.TNvals=$d();$k[$j++]=Infinity;for(var _41=0;_41<=31;_41+=1){$k[$j++]=_41;$k[$j++]=_41}$ctx.T1vals=$d();$k[$j++]=Infinity;for(var _43=33;_43<=47;_43+=1){$k[$j++]=_43;$k[$j++]=_43-33}for(var _44=58;_44<=64;_44+=1){$k[$j++]=_44;$k[$j++]=_44-43}for(var _45=91;_45<=95;_45+=1){$k[$j++]=_45;$k[$j++]=_45-69}$k[$j++]=$ctx.fnc1;$k[$j++]=27;$k[$j++]=$ctx.usft;$k[$j++]=30;$ctx.T2vals=$d();$k[$j++]=Infinity;$k[$j++]=96;$k[$j++]=0;for(var _49=65;_49<=90;_49+=1){$k[$j++]=_49;$k[$j++]=_49-64}for(var _4A=123;_4A<=127;_4A+=1){$k[$j++]=_4A;$k[$j++]=_4A-96}$ctx.T3vals=$d();$k[$j++]=Infinity;var _4C=$ctx.TNvals;for(var _4H=_4C.size,_4G=_4C.keys(),_4F=0;_4F<_4H;_4F++){var _4D=_4G.next().value;$k[$j++]=_4D;$k[$j++]=_4C.get(_4D);$k[$j++]=Infinity;var _4I=$k[--$j];var _4J=$k[--$j];$k[$j++]=_4I;$k[$j++]=_4J;var _4K=$a();$k[$j++]=_4K}var _4L=$ctx.T1vals;for(var _4Q=_4L.size,_4P=_4L.keys(),_4O=0;_4O<_4Q;_4O++){var _4M=_4P.next().value;$k[$j++]=_4M;$k[$j++]=_4L.get(_4M);$k[$j++]=Infinity;var _4R=$k[--$j];var _4S=$k[--$j];$k[$j++]=_4R;$k[$j++]=$g($ctx.TNvals,$ctx.sft1);$k[$j++]=_4S;var _4W=$a();$k[$j++]=_4W}var _4X=$ctx.T2vals;for(var _4c=_4X.size,_4b=_4X.keys(),_4a=0;_4a<_4c;_4a++){var _4Y=_4b.next().value;$k[$j++]=_4Y;$k[$j++]=_4X.get(_4Y);$k[$j++]=Infinity;var _4d=$k[--$j];var _4e=$k[--$j];$k[$j++]=_4d;$k[$j++]=$g($ctx.TNvals,$ctx.sft2);$k[$j++]=_4e;var _4i=$a();$k[$j++]=_4i}var _4j=$ctx.T3vals;for(var _4o=_4j.size,_4n=_4j.keys(),_4m=0;_4m<_4o;_4m++){var _4k=_4n.next().value;$k[$j++]=_4k;$k[$j++]=_4j.get(_4k);$k[$j++]=Infinity;var _4p=$k[--$j];var _4q=$k[--$j];$k[$j++]=_4p;$k[$j++]=$g($ctx.TNvals,$ctx.sft3);$k[$j++]=_4q;var _4u=$a();$k[$j++]=_4u}$ctx.Tvals=$d();for(var _4w=128;_4w<=255;_4w+=1){$ctx.i=_4w;$k[$j++]=$ctx.Avals;$k[$j++]=$ctx.i;$k[$j++]=Infinity;$q($g($ctx.Avals,$ctx.usft));$q($g($ctx.Avals,$ctx.i-128));var _55=$a();var _56=$k[--$j];$p($k[--$j],_56,_55);$k[$j++]=$ctx.Cvals;$k[$j++]=$ctx.i;$k[$j++]=Infinity;$q($g($ctx.Cvals,$ctx.usft));$q($g($ctx.Cvals,$ctx.i-128));var _5G=$a();var _5H=$k[--$j];$p($k[--$j],_5H,_5G);$k[$j++]=$ctx.Tvals;$k[$j++]=$ctx.i;$k[$j++]=Infinity;$q($g($ctx.Tvals,$ctx.usft));$q($g($ctx.Tvals,$ctx.i-128));var _5R=$a();var _5S=$k[--$j];$p($k[--$j],_5S,_5R)}$k[$j++]=Infinity;$k[$j++]=13;$k[$j++]=0;$k[$j++]=42;$k[$j++]=1;$k[$j++]=62;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _5U=48;_5U<=57;_5U+=1){$k[$j++]=_5U;$k[$j++]=_5U-44}for(var _5V=65;_5V<=90;_5V+=1){$k[$j++]=_5V;$k[$j++]=_5V-51}$ctx.Xvals=$d();$k[$j++]=Infinity;var _5X=$ctx.Xvals;for(var _5c=_5X.size,_5b=_5X.keys(),_5a=0;_5a<_5c;_5a++){var _5Y=_5b.next().value;$k[$j++]=_5Y;$k[$j++]=_5X.get(_5Y);$k[$j++]=Infinity;var _5d=$k[--$j];var _5e=$k[--$j];$k[$j++]=_5d;$k[$j++]=_5e;var _5f=$a();$k[$j++]=_5f}$ctx.Xvals=$d();$k[$j++]=Infinity;for(var _5h=64;_5h<=94;_5h+=1){$k[$j++]=_5h;$k[$j++]=_5h-64}$k[$j++]=$ctx.unl;$k[$j++]=31;for(var _5j=32;_5j<=63;_5j+=1){$k[$j++]=_5j;$k[$j++]=_5j}$ctx.Evals=$d();$k[$j++]=Infinity;var _5l=$ctx.Evals;for(var _5q=_5l.size,_5p=_5l.keys(),_5o=0;_5o<_5q;_5o++){var _5m=_5p.next().value;$k[$j++]=_5m;$k[$j++]=_5l.get(_5m);$k[$j++]=Infinity;var _5r=$k[--$j];var _5s=$k[--$j];$k[$j++]=_5r;$k[$j++]=_5s;var _5t=$a();$k[$j++]=_5t}$ctx.Evals=$d();$k[$j++]=Infinity;for(var _5v=0;_5v<=255;_5v+=1){$k[$j++]=_5v;$k[$j++]=_5v}$ctx.Bvals=$d();$k[$j++]=Infinity;var _5x=$ctx.Bvals;for(var _62=_5x.size,_61=_5x.keys(),_60=0;_60<_62;_60++){var _5y=_61.next().value;$k[$j++]=_5y;$k[$j++]=_5x.get(_5y);$k[$j++]=Infinity;var _63=$k[--$j];var _64=$k[--$j];$k[$j++]=_63;$k[$j++]=_64;var _65=$a();$k[$j++]=_65}$ctx.Bvals=$d();$ctx.encvals=$a([$ctx.Avals,$ctx.Cvals,$ctx.Tvals,$ctx.Xvals,$ctx.Evals,$ctx.Bvals]);$ctx.A=0;$ctx.C=1;$ctx.T=2;$ctx.X=3;$ctx.E=4;$ctx.B=5;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_datamatrix.$ctx[id]=$ctx[id]);bwipp_datamatrix.__18615__=1})()}if($1.raw){$1.cws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i==$1.barcode.length){break}$1.cw=$i($G($1.barcode,$1.i+1,3));$p($1.cws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}$1.cws=$G($1.cws,0,$1.j)}else{var _6Z=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true],["FNC1",$1.fnc1],["PROG",$1.prog]]);$1.fncvals=_6Z;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6c=$k[--$j];$1[$k[--$j]]=_6c;$1.msglen=$1.msg.length;if($1.msglen>=9){$q($G($1.msg,0,7));var _6i=$k[--$j];var _6j=$k[--$j];$k[$j++]=_6i==29;$k[$j++]=_6j;$j--;var _6k=$k[--$j];var _6l=$k[--$j];var _6m=$k[--$j];var _6n=$k[--$j];var _6o=$k[--$j];var _6p=$k[--$j];if(_6k&&_6l==48&&_6m==30&&_6n==62&&_6o==41&&_6p==91){$q($G($1.msg,$1.msglen-2,2));var _6t=$k[--$j];var _6u=$k[--$j];if(_6t==4&&_6u==30){if($g($1.msg,5)==53){$k[$j++]=Infinity;$k[$j++]=$1.m05;$q($G($1.msg,7,$1.msg.length-9));$1.msg=$a()}else{if($g($1.msg,5)==54){$k[$j++]=Infinity;$k[$j++]=$1.m06;$q($G($1.msg,7,$1.msg.length-9));$1.msg=$a()}}}}}$1.msglen=$1.msg.length;$k[$j++]=Infinity;for(var _7B=0,_7C=$1.msglen;_7B<_7C;_7B++){$k[$j++]=0}$k[$j++]=0;$1.numD=$a();$k[$j++]=Infinity;for(var _7F=0,_7G=$1.msglen;_7F<_7G;_7F++){$k[$j++]=0}$k[$j++]=9999;$1.nextXterm=$a();$k[$j++]=Infinity;for(var _7J=0,_7K=$1.msglen;_7J<_7K;_7J++){$k[$j++]=0}$k[$j++]=9999;$1.nextNonX=$a();$k[$j++]=Infinity;for(var _7N=0,_7O=$1.msglen;_7N<_7O;_7N++){$k[$j++]=false}$k[$j++]=false;$1.isECI=$a();for(var _7R=$1.msglen-1;_7R>=0;_7R-=1){$1.i=_7R;$1.barchar=$g($1.msg,$1.i);if($1.barchar>=48&&$1.barchar<=57){$p($1.numD,$1.i,$f($g($1.numD,$1.i+1)+1))}if($1.barchar==13||$1.barchar==42||$1.barchar==62){$p($1.nextXterm,$1.i,0)}else{$p($1.nextXterm,$1.i,$f($g($1.nextXterm,$1.i+1)+1))}var _7o=$g($1.Xvals,$1.barchar)!==undefined;if(!_7o){$p($1.nextNonX,$1.i,0)}else{$p($1.nextNonX,$1.i,$f($g($1.nextNonX,$1.i+1)+1))}$p($1.isECI,$1.i,$1.barchar<=-1e6)}$k[$j++]=Infinity;var _7z=$1.nextXterm;for(var _80=0,_81=_7z.length;_80<_81;_80++){var _82=$g(_7z,_80);$k[$j++]=_82;if(_82>1e4){$j--;$k[$j++]=1e4}}$1.nextXterm=$a();$k[$j++]=Infinity;var _84=$1.nextNonX;for(var _85=0,_86=_84.length;_85<_86;_85++){var _87=$g(_84,_85);$k[$j++]=_87;if(_87>1e4){$j--;$k[$j++]=1e4}}$1.nextNonX=$a();$1.isD=function(){$k[$j++]=$1.char>=48&&$1.char<=57};$1.isC=function(){var _8D=$g($1.CNvals,$1.char)!==undefined;$k[$j++]=_8D};$1.isT=function(){var _8G=$g($1.TNvals,$1.char)!==undefined;$k[$j++]=_8G};$1.isX=function(){var _8J=$g($1.Xvals,$1.char)!==undefined;$k[$j++]=_8J};$1.isE=function(){var _8M=$g($1.Evals,$1.char)!==undefined;$k[$j++]=_8M};$1.isEA=function(){$k[$j++]=$1.char>127};$1.isFN=function(){$k[$j++]=$1.char<0};$1.XtermFirst=function(){var _8P=$k[--$j];$k[$j++]=$lt($g($1.nextXterm,_8P),$g($1.nextNonX,_8P))};$1.lookup=function(){$1.ac=1;$1.cc=2;$1.tc=2;$1.xc=2;$1.ec=2;$1.bc=2.25;if($1.mode==$1.A){$1.ac=0;$1.cc=1;$1.tc=1;$1.xc=1;$1.ec=1;$1.bc=1.25}if($1.mode==$1.C){$1.cc=0}if($1.mode==$1.T){$1.tc=0}if($1.mode==$1.X){$1.xc=0}if($1.mode==$1.E){$1.ec=0}if($1.mode==$1.B){$1.bc=0}for(var _8g=0,_8h=1;_8g<_8h;_8g++){if($g($1.isECI,$1.i)){$k[$j++]=$1.A;break}if($1.c40headerlength!=-1&&$1.i<$1.c40headerlength){$k[$j++]=$1.C;break}$1.k=0;for(;;){if($1.i+$1.k==$1.msglen){var _8t=$a(["ac","cc","tc","xc","ec","bc"]);for(var _8u=0,_8v=_8t.length;_8u<_8v;_8u++){var _8w=$g(_8t,_8u);$1[_8w]=Math.ceil($1[_8w])}var _93=$a([$1.cc,$1.tc,$1.xc,$1.ec,$1.bc]);$k[$j++]=true;for(var _94=0,_95=_93.length;_94<_95;_94++){var _98=$k[--$j];$k[$j++]=_98&&$1.ac<=$g(_93,_94)}if($k[--$j]){$k[$j++]=$1.A;break}var _9G=$a([$1.ac,$1.cc,$1.tc,$1.xc,$1.ec]);$k[$j++]=true;for(var _9H=0,_9I=_9G.length;_9H<_9I;_9H++){var _9L=$k[--$j];$k[$j++]=_9L&&$1.bc<$g(_9G,_9H)}if($k[--$j]){$k[$j++]=$1.B;break}var _9T=$a([$1.ac,$1.cc,$1.tc,$1.xc,$1.bc]);$k[$j++]=true;for(var _9U=0,_9V=_9T.length;_9U<_9V;_9U++){var _9Y=$k[--$j];$k[$j++]=_9Y&&$1.ec<$g(_9T,_9U)}if($k[--$j]){$k[$j++]=$1.E;break}var _9g=$a([$1.ac,$1.cc,$1.xc,$1.ec,$1.bc]);$k[$j++]=true;for(var _9h=0,_9i=_9g.length;_9h<_9i;_9h++){var _9l=$k[--$j];$k[$j++]=_9l&&$1.tc<$g(_9g,_9h)}if($k[--$j]){$k[$j++]=$1.T;break}var _9t=$a([$1.ac,$1.cc,$1.tc,$1.ec,$1.bc]);$k[$j++]=true;for(var _9u=0,_9v=_9t.length;_9u<_9v;_9u++){var _9y=$k[--$j];$k[$j++]=_9y&&$1.xc<$g(_9t,_9u)}if($k[--$j]){$k[$j++]=$1.X;break}$k[$j++]=$1.C;break}$1.char=$g($1.msg,$1.i+$1.k);$k[$j++]="ac";$k[$j++]=$1.ac;$1.isD();if($k[--$j]){var _A8=$k[--$j];$k[$j++]=$f(_A8+1/2)}else{$1.isEA();if($k[--$j]){var _AA=$k[--$j];$k[$j++]=Math.ceil(_AA)+2}else{var _AB=$k[--$j];$k[$j++]=Math.ceil(_AB)+1}}var _AC=$k[--$j];$1[$k[--$j]]=_AC;$k[$j++]="cc";$k[$j++]=$1.cc;$1.isC();if($k[--$j]){var _AG=$k[--$j];$k[$j++]=$f(_AG+.6666667)}else{$1.isEA();if($k[--$j]){var _AI=$k[--$j];$k[$j++]=$f(_AI+2.6666667)}else{var _AJ=$k[--$j];$k[$j++]=$f(_AJ+1.3333334)}}var _AK=$k[--$j];$1[$k[--$j]]=_AK;$k[$j++]="tc";$k[$j++]=$1.tc;$1.isT();if($k[--$j]){var _AO=$k[--$j];$k[$j++]=$f(_AO+.6666667)}else{$1.isEA();if($k[--$j]){var _AQ=$k[--$j];$k[$j++]=$f(_AQ+2.6666667)}else{var _AR=$k[--$j];$k[$j++]=$f(_AR+1.3333334)}}var _AS=$k[--$j];$1[$k[--$j]]=_AS;$k[$j++]="xc";$k[$j++]=$1.xc;$1.isX();if($k[--$j]){var _AW=$k[--$j];$k[$j++]=$f(_AW+.6666667)}else{$1.isEA();if($k[--$j]){var _AY=$k[--$j];$k[$j++]=$f(_AY+4.3333334)}else{var _AZ=$k[--$j];$k[$j++]=$f(_AZ+3.3333334)}}var _Aa=$k[--$j];$1[$k[--$j]]=_Aa;$k[$j++]="ec";$k[$j++]=$1.ec;$1.isE();if($k[--$j]){var _Ae=$k[--$j];$k[$j++]=$f(_Ae+3/4)}else{$1.isEA();if($k[--$j]){var _Ag=$k[--$j];$k[$j++]=$f(_Ag+17/4)}else{var _Ah=$k[--$j];$k[$j++]=$f(_Ah+13/4)}}var _Ai=$k[--$j];$1[$k[--$j]]=_Ai;$k[$j++]="bc";$k[$j++]=$1.bc;$1.isFN();if($k[--$j]){var _Am=$k[--$j];$k[$j++]=$f(_Am+4)}else{var _An=$k[--$j];$k[$j++]=$f(_An+1)}var _Ao=$k[--$j];$1[$k[--$j]]=_Ao;if($1.k>=4){var _Aw=$a([$1.cc,$1.tc,$1.xc,$1.ec,$1.bc]);$k[$j++]=true;for(var _Ax=0,_Ay=_Aw.length;_Ax<_Ay;_Ax++){var _B1=$k[--$j];$k[$j++]=_B1&&$1.ac+1<=$g(_Aw,_Ax)}if($k[--$j]){$k[$j++]=$1.A;break}if($1.bc+1<=$1.ac){$k[$j++]=$1.B;break}var _BB=$a([$1.cc,$1.tc,$1.xc,$1.ec]);$k[$j++]=true;for(var _BC=0,_BD=_BB.length;_BC<_BD;_BC++){var _BG=$k[--$j];$k[$j++]=_BG&&$1.bc+1<$g(_BB,_BC)}if($k[--$j]){$k[$j++]=$1.B;break}var _BO=$a([$1.ac,$1.cc,$1.tc,$1.xc,$1.bc]);$k[$j++]=true;for(var _BP=0,_BQ=_BO.length;_BP<_BQ;_BP++){var _BT=$k[--$j];$k[$j++]=_BT&&$1.ec+1<$g(_BO,_BP)}if($k[--$j]){$k[$j++]=$1.E;break}var _Bb=$a([$1.ac,$1.cc,$1.xc,$1.ec,$1.bc]);$k[$j++]=true;for(var _Bc=0,_Bd=_Bb.length;_Bc<_Bd;_Bc++){var _Bg=$k[--$j];$k[$j++]=_Bg&&$1.tc+1<$g(_Bb,_Bc)}if($k[--$j]){$k[$j++]=$1.T;break}var _Bo=$a([$1.ac,$1.cc,$1.tc,$1.ec,$1.bc]);$k[$j++]=true;for(var _Bp=0,_Bq=_Bo.length;_Bp<_Bq;_Bp++){var _Bt=$k[--$j];$k[$j++]=_Bt&&$1.xc+1<$g(_Bo,_Bp)}if($k[--$j]){$k[$j++]=$1.X;break}var _C0=$a([$1.ac,$1.tc,$1.ec,$1.bc]);$k[$j++]=true;for(var _C1=0,_C2=_C0.length;_C1<_C2;_C1++){var _C5=$k[--$j];$k[$j++]=_C5&&$1.cc+1<$g(_C0,_C1)}if($k[--$j]){if($1.cc<$1.xc){$k[$j++]=$1.C;break}if($1.cc==$1.xc){$k[$j++]=$1.i+$1.k+1;$1.XtermFirst();if($k[--$j]){$k[$j++]=$1.X;break}else{$k[$j++]=$1.C;break}}}}$1.k=$1.k+1}}};$1.addtocws=function(){var _CI=$k[--$j];$P($1.cws,$1.j,_CI);$1.j=_CI.length+$1.j};$1.ECItocws=function(){var _CN=$f(-$k[--$j]-1e6);$k[$j++]=_CN;if(_CN<=126){var _CO=$k[--$j];$k[$j++]=$f(_CO+1);$as($a(1))}else{var _CQ=$k[--$j];$k[$j++]=_CQ;if(_CQ<=16382){var _CS=$f($k[--$j]-127);$k[$j++]=~~(_CS/254)+128;$k[$j++]=$f(_CS%254+1);$as($a(2))}else{var _CV=$f($k[--$j]-16383);$k[$j++]=~~(_CV/64516)+192;$k[$j++]=~~(_CV/254)%254+1;$k[$j++]=$f(_CV%254+1);$as($a(3))}}};$1.encA=function(){for(var _CX=0,_CY=1;_CX<_CY;_CX++){if($g($1.isECI,$1.i)){$k[$j++]=$g($1.Avals,$1.eci);$1.addtocws();$k[$j++]=$g($1.msg,$1.i);$1.ECItocws();$1.addtocws();$1.i=$1.i+1;break}if($g($1.numD,$1.i)>=2){var _Cm=$s(2);$p(_Cm,0,$g($1.msg,$1.i));$p(_Cm,1,$g($1.msg,$1.i+1));$k[$j++]=$g($1.Avals,_Cm);$1.addtocws();$1.i=$1.i+2;break}$k[$j++]="newmode";$1.lookup();var _Cw=$k[--$j];$1[$k[--$j]]=_Cw;if($1.newmode!=$1.mode){$k[$j++]=$g($1.Avals,$g($a([-1,$1.lC,$1.lT,$1.lX,$1.lE,$1.lB]),$1.newmode));$1.addtocws();$1.mode=$1.newmode;break}$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.i=$1.i+1;break}};$1.CTXvalstocws=function(){$1.in=$k[--$j];$k[$j++]=Infinity;for(var _DK=0,_DJ=$1.in.length-1;_DK<=_DJ;_DK+=3){var _DM=$G($1.in,_DK,3);$k[$j++]=0;for(var _DN=0,_DO=_DM.length;_DN<_DO;_DN++){var _DQ=$k[--$j];$k[$j++]=$f(_DQ+$g(_DM,_DN))*40}var _DS=~~($k[--$j]/40)+1;$k[$j++]=~~(_DS/256);$k[$j++]=_DS%256}$as($a($m()));var _DV=$k[--$j];var _DW=$k[--$j];$k[$j++]=_DV;$k[$j++]=_DW;$j--};$1.encCTX=function(){$1.p=0;$1.ctxvals=$a(2500);$1.done=false;for(;;){if($1.i==$1.msglen){break}var _Dg=$g($g($1.encvals,$1.mode),$g($1.msg,$1.i))!==undefined;if(!_Dg){break}if($1.p%3==0){if($1.p>0){$k[$j++]="newmode";$1.lookup();var _Dj=$k[--$j];$1[$k[--$j]]=_Dj;if($ne($1.newmode,$1.mode)){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();if($1.newmode!=$1.A){$k[$j++]=$g($1.Avals,$g($a([-1,$1.lC,$1.lT,$1.lX,$1.lE,$1.lB]),$1.newmode));$1.addtocws()}$1.mode=$1.newmode;$1.done=true;break}}if($1.msglen-$1.i<=3){$1.remcws=$g($1.numremcws,$1.j+~~($1.p/3)*2);$k[$j++]=Infinity;var _EF=$G($1.msg,$1.i,$1.msglen-$1.i);for(var _EG=0,_EH=_EF.length;_EG<_EH;_EG++){var _EI=$g(_EF,_EG);var _EM=$g($g($1.encvals,$1.mode),_EI)!==undefined;$k[$j++]=_EI;if(_EM){$q($g($g($1.encvals,$1.mode),$k[--$j]))}else{$j--;$k[$j++]=-1;$k[$j++]=-1;$k[$j++]=-1;$k[$j++]=-1}}$1.remvals=$a();if($1.remcws==2&&$1.remvals.length==3){$k[$j++]=Infinity;$q($G($1.ctxvals,0,$1.p));$q($1.remvals);var _EZ=$a();$k[$j++]=_EZ;$1.CTXvalstocws();$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;$1.done=true;break}if($1.remcws==2&&$1.remvals.length==2&&$1.mode!=$1.X){$k[$j++]=Infinity;$q($G($1.ctxvals,0,$1.p));$q($1.remvals);$q($g($g($1.encvals,$1.mode),$1.sft1));var _Ep=$a();$k[$j++]=_Ep;$1.CTXvalstocws();$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;$1.done=true;break}if($1.remcws==2&&$1.remvals.length==1){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;$1.done=true;break}if($1.remcws==1&&$1.remvals.length==1){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;$1.done=true;break}}}var _FO=$g($g($1.encvals,$1.mode),$g($1.msg,$1.i));$P($1.ctxvals,$1.p,_FO);$1.p=_FO.length+$1.p;$1.i=$1.i+1}if(!$1.done){for(;;){if($1.p%3==0){break}$1.i=$1.i-1;$1.p=$1.p-$g($g($1.encvals,$1.mode),$g($1.msg,$1.i)).length}$k[$j++]=Infinity;$q($G($1.ctxvals,0,$1.p));var _Fh=$a();$k[$j++]=_Fh;$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$1.mode=$1.A;if($1.i!=$1.msglen&&$nt($g($1.isECI,$1.i))){if($g($1.numD,$1.i)>=2){var _Ft=$s(2);$p(_Ft,0,$g($1.msg,$1.i));$p(_Ft,1,$g($1.msg,$1.i+1));$k[$j++]=$g($1.Avals,_Ft);$1.addtocws();$1.i=$1.i+2}else{$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.i=$1.i+1}}}};$1.Evalstocws=function(){$1.in=$k[--$j];$1.inlen=$1.in.length;$1.outlen=~~Math.ceil($1.in.length/4*3);$k[$j++]=Infinity;$q($1.in);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$1.in=$a();$k[$j++]=Infinity;for(var _GG=0,_GF=$1.inlen-1;_GG<=_GF;_GG+=4){var _GI=$G($1.in,_GG,4);$k[$j++]=0;for(var _GJ=0,_GK=_GI.length;_GJ<_GK;_GJ++){var _GM=$k[--$j];$k[$j++]=$or(_GM,$g(_GI,_GJ))<<6}var _GO=$k[--$j]>>>6;$k[$j++]=_GO>>>16&255;$k[$j++]=_GO>>>8&255;$k[$j++]=_GO&255}$as($a($m()));var _GR=$k[--$j];var _GS=$k[--$j];$k[$j++]=_GR;$k[$j++]=_GS;$j--;var _GV=$G($k[--$j],0,$1.outlen);$k[$j++]=_GV};$1.encE=function(){$1.p=0;$1.edifactvals=$a(2100);for(;;){if($1.i==$1.msglen){break}var _Gd=$g($1.Evals,$g($1.msg,$1.i))!==undefined;if(!_Gd){break}if($1.p%4==0){if($1.msglen-$1.i<=2){$1.remcws=$g($1.numremcws,$1.j+~~($1.p/4)*3);$k[$j++]=Infinity;var _Gp=$G($1.msg,$1.i,$1.msglen-$1.i);for(var _Gq=0,_Gr=_Gp.length;_Gq<_Gr;_Gq++){$q($g($1.Avals,$g(_Gp,_Gq)))}$1.remvals=$a();if(($1.remcws==1||$1.remcws==2)&&$1.remvals.length<=$1.remcws){$k[$j++]=$G($1.edifactvals,0,$1.p);$1.Evalstocws();$1.addtocws();$k[$j++]=$1.remvals;$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;break}}$1.lookup();if($k[--$j]!=$1.mode){break}}var _HC=$g($1.Evals,$g($1.msg,$1.i));$P($1.edifactvals,$1.p,_HC);$1.p=_HC.length+$1.p;$1.i=$1.i+1}if($1.mode!=$1.A){$1.remcws=$f($g($1.numremcws,$1.j+~~($1.p/4)*3-1)-1);if($1.p%4!=0||$1.i!=$1.msglen||$1.remcws>=3){var _HT=$g($1.Evals,$1.unl);$P($1.edifactvals,$1.p,_HT);$1.p=_HT.length+$1.p}$k[$j++]=$G($1.edifactvals,0,$1.p);$1.Evalstocws();$1.addtocws();$1.mode=$1.A;if($1.i!=$1.msglen&&$nt($g($1.isECI,$1.i))){if($g($1.numD,$1.i)>=2){var _Hj=$s(2);$p(_Hj,0,$g($1.msg,$1.i));$p(_Hj,1,$g($1.msg,$1.i+1));$k[$j++]=$g($1.Avals,_Hj);$1.addtocws();$1.i=$1.i+2}else{$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.i=$1.i+1}}}};$1.encB=function(){$1.p=0;$1.bvals=$a(1558);for(;;){if($1.i==$1.msglen){break}$1.lookup();if($k[--$j]!=$1.mode){break}$p($1.bvals,$1.p,$g($1.msg,$1.i));$1.p=$1.p+1;$1.i=$1.i+1}$1.remcws=$f($g($1.numremcws,$1.j+$1.p)-1);$k[$j++]=Infinity;if($1.remcws==0&&$1.i==$1.msglen){$k[$j++]=0}else{if($1.p<250){$k[$j++]=$1.p}else{$k[$j++]=~~($1.p/250)+249;$k[$j++]=$1.p%250}}$q($G($1.bvals,0,$1.p));$1.bvals=$a();for(var _IS=0,_IR=$1.bvals.length-1;_IS<=_IR;_IS+=1){$1.p=_IS;var _IY=$f(($1.j+$1.p+1)*149%255+1+$g($1.bvals,$1.p));$k[$j++]=_IY;if(_IY>=256){var _IZ=$k[--$j];$k[$j++]=$f(_IZ-256)}$p($1.bvals,$1.p,$k[--$j])}$k[$j++]=$1.bvals;$1.addtocws();$1.mode=$1.A};$1.cws=$a(1558);$1.mode=$1.A;$1.i=0;$1.j=0;for(;;){if($1.i>=$1.msglen){break}if($1[$g($a(["encA","encCTX","encCTX","encCTX","encE","encB"]),$1.mode)]()===true){break}}$1.cws=$G($1.cws,0,$1.j)}$1.datlen=$1.cws.length;$1.remcws=$f($g($1.numremcws,$1.j-1)-1);if($1.remcws>0){$k[$j++]=Infinity;$q($1.cws);for(var _Ix=0,_Iy=$1.remcws;_Ix<_Iy;_Ix++){$k[$j++]=129}$1.cws=$a();for(var _J4=$1.datlen+1,_J3=$f($f($1.datlen+$1.remcws)-1);_J4<=_J3;_J4+=1){$1.i=_J4;var _J6=($1.i+1)*149%253+1+129;$k[$j++]=_J6;if(_J6>254){var _J7=$k[--$j];$k[$j++]=$f(_J7-254)}$p($1.cws,$1.i,$k[--$j])}}var _JC=$g($1.options,"debugcws")!==undefined;if(_JC){$k[$j++]="bwipp.debugcws#19036";$k[$j++]=$1.cws;bwipp_raiseerror()}var _JE=$1.metrics;for(var _JF=0,_JG=_JE.length;_JF<_JG;_JF++){$1.m=$g(_JE,_JF);$1.rows=$g($1.m,0);$1.cols=$g($1.m,1);$1.regh=$g($1.m,2);$1.regv=$g($1.m,3);$1.rscw=$g($1.m,4);$1.rsbl=$g($1.m,5);$1.doly=$g($1.m,6);$1.mrows=$f($1.rows-2*$1.regh);$1.mcols=$f($1.cols-2*$1.regv);$1.rrows=~~($1.mrows/$1.regh);$1.rcols=~~($1.mcols/$1.regv);$1.ncws=$f(~~($1.mrows*$1.mcols/8)-$1.rscw);$1.okay=true;if($1.cws.length!=$1.ncws){$1.okay=false}if($1.urows!=0&&$1.urows!=$1.rows){$1.okay=false}if($1.ucols!=0&&$1.ucols!=$1.cols){$1.okay=false}if($eq($1.format,"square")&&$ne($1.rows,$1.cols)){$1.okay=false}if($eq($1.format,"rectangle")&&$eq($1.rows,$1.cols)){$1.okay=false}if(!$1.dmre&&$1.doly==1){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.datamatrixNoValidSymbol#19064";$k[$j++]="Maximum length exceeded or invalid size";bwipp_raiseerror()}$1.cwbs=$a($1.rsbl);$1.ecbs=$a($1.rsbl);for(var _K5=0,_K4=$f($1.rsbl-1);_K5<=_K4;_K5+=1){$1.i=_K5;if($1.cws.length!=1558){$1.cwbsize=~~($1.cws.length/$1.rsbl)}else{if($1.i<=7){$1.cwbsize=156}else{$1.cwbsize=155}}$1.cwb=$a($1.cwbsize);for(var _KE=0,_KD=$1.cwbsize-1;_KE<=_KD;_KE+=1){$1.j=_KE;$p($1.cwb,$1.j,$g($1.cws,$f($1.j*$1.rsbl+$1.i)))}$p($1.cwbs,$1.i,$1.cwb);$k[$j++]=$1.ecbs;$k[$j++]=$1.i;$k[$j++]=Infinity;for(var _KT=0,_KU=~~($1.rscw/$1.rsbl);_KT<_KU;_KT++){$k[$j++]=0}var _KV=$a();var _KW=$k[--$j];$p($k[--$j],_KW,_KV)}if(!bwipp_datamatrix.__19091__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;$k[$j++]=1;for(var _KY=0,_KZ=255;_KY<_KZ;_KY++){var _Ka=$k[--$j];var _Kb=_Ka*2;$k[$j++]=_Ka;$k[$j++]=_Kb;if(_Kb>=256){var _Kc=$k[--$j];$k[$j++]=_Kc^301}}$ctx.rsalog=$a();$ctx.rslog=$a(256);for(var _Kf=1;_Kf<=255;_Kf+=1){$p($ctx.rslog,$g($ctx.rsalog,_Kf),_Kf)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_datamatrix.$ctx[id]=$ctx[id]);bwipp_datamatrix.__19091__=1})()}$1.rsprod=function(){var _Kk=$k[--$j];var _Kl=$k[--$j];$k[$j++]=_Kl;$k[$j++]=_Kk;if(_Kk!=0&&_Kl!=0){var _Ko=$g($1.rslog,$k[--$j]);var _Kt=$g($1.rsalog,$f(_Ko+$g($1.rslog,$k[--$j]))%255);$k[$j++]=_Kt}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Kw=0,_Kx=~~($1.rscw/$1.rsbl);_Kw<_Kx;_Kw++){$k[$j++]=0}$1.coeffs=$a();for(var _L2=1,_L1=~~($1.rscw/$1.rsbl);_L2<=_L1;_L2+=1){$1.i=_L2;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _L9=$1.i-1;_L9>=1;_L9-=1){$1.j=_L9;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _LL=$k[--$j];var _LM=$k[--$j];var _LN=$k[--$j];$p($k[--$j],_LN,$xo(_LM,_LL))}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _LV=$k[--$j];var _LW=$k[--$j];$p($k[--$j],_LW,_LV)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);for(var _Ld=0,_Lc=$1.cwbs.length-1;_Ld<=_Lc;_Ld+=1){$1.i=_Ld;$1.cwb=$g($1.cwbs,$1.i);$1.ecb=$g($1.ecbs,$1.i);for(var _Lm=0,_Ll=$1.cwb.length-1;_Lm<=_Ll;_Lm+=1){$1.t=$xo($g($1.cwb,_Lm),$g($1.ecb,0));for(var _Ls=$1.ecb.length-1;_Ls>=0;_Ls-=1){$1.j=_Ls;$1.p=$1.ecb.length-$1.j-1;$k[$j++]=$1.ecb;$k[$j++]=$1.p;$k[$j++]=$1.t;$k[$j++]=$g($1.coeffs,$1.j);$1.rsprod();var _M1=$k[--$j];var _M2=$k[--$j];$p($k[--$j],_M2,_M1);if($1.j>0){$p($1.ecb,$1.p,$xo($g($1.ecb,$1.p+1),$g($1.ecb,$1.p)))}}}}if($1.ncws==1558){$k[$j++]=Infinity;var _MF=$G($1.ecbs,8,2);for(var _MG=0,_MH=_MF.length;_MG<_MH;_MG++){$k[$j++]=$g(_MF,_MG)}var _MK=$G($1.ecbs,0,8);for(var _ML=0,_MM=_MK.length;_ML<_MM;_ML++){$k[$j++]=$g(_MK,_ML)}$1.ecbs=$a()}$k[$j++]=Infinity;var _MP=$1.cws;for(var _MQ=0,_MR=_MP.length;_MQ<_MR;_MQ++){$k[$j++]=$g(_MP,_MQ)}for(var _MU=0,_MV=$1.rscw;_MU<_MV;_MU++){$k[$j++]=0}$1.cws=$a();for(var _MZ=0,_MY=$f($1.rscw-1);_MZ<=_MY;_MZ+=1){$1.i=_MZ;$p($1.cws,$f($1.ncws+$1.i),$g($g($1.ecbs,$1.i%$1.rsbl),~~($1.i/$1.rsbl)))}$1.module=function(){var _Mk=$k[--$j];var _Ml=$k[--$j];var _Mm=$k[--$j];var _Mp=$Z($s(8),"00000000");var _Mr=$R($s(8),$k[--$j],2);$P(_Mp,8-_Mr.length,_Mr);$k[$j++]=_Mm;$k[$j++]=_Ml;$k[$j++]=_Mk;$k[$j++]=_Mp;for(var _Ms=7;_Ms>=0;_Ms-=1){var _Mt=$k[--$j];$k[$j++]=$f($g(_Mt,_Ms)-48);$k[$j++]=_Mt}$j--;var _Mv=$k[--$j];var _Mw=$k[--$j];var _Mx=$k[--$j];var _My=$k[--$j];var _Mz=$k[--$j];var _N0=$k[--$j];var _N1=$k[--$j];var _N2=$k[--$j];var _N3=$k[--$j];var _N4=$k[--$j];var _N5=$k[--$j];$k[$j++]=_N2;$k[$j++]=_N1;$k[$j++]=_N0;$k[$j++]=_Mz;$k[$j++]=_My;$k[$j++]=_Mx;$k[$j++]=_Mw;$k[$j++]=_Mv;$k[$j++]=_N5;$k[$j++]=_N4;$F(_N3,function(){if($k[--$j]()===true){return true}var _N7=$k[--$j];var _N8=$k[--$j];$k[$j++]=_N8;$k[$j++]=_N7;if(_N8<0){var _N9=$k[--$j];var _NA=$k[--$j];$k[$j++]=$f(_NA+$1.mrows);$k[$j++]=$f(_N9+$f(4-$f($1.mrows+4)%8))}var _ND=$k[--$j];$k[$j++]=_ND;if(_ND<0){var _NF=$k[--$j];var _NG=$k[--$j];$k[$j++]=$f(_NG+$f(4-$f($1.mcols+4)%8));$k[$j++]=$f(_NF+$1.mcols)}var _NI=$k[--$j];var _NJ=$k[--$j];$k[$j++]=_NJ;$k[$j++]=_NI;if(_NJ>=$1.mrows){var _NL=$k[--$j];var _NM=$k[--$j];$k[$j++]=$f(_NM-$1.mrows);$k[$j++]=_NL}var _NO=$k[--$j];var _NP=$k[--$j];var _NS=$k[--$j];var _NT=$k[--$j];$p($1.mmat,$f(_NO+_NP*$1.mcols),$k[--$j]);$k[$j++]=_NT;$k[$j++]=_NS})};var _Nl=$a([function(){var _NV=$k[--$j];var _NW=$k[--$j];$k[$j++]=_NW;$k[$j++]=_NV;$k[$j++]=$f(_NW-2);$k[$j++]=$f(_NV-2)},function(){var _NX=$k[--$j];var _NY=$k[--$j];$k[$j++]=_NY;$k[$j++]=_NX;$k[$j++]=$f(_NY-2);$k[$j++]=$f(_NX-1)},function(){var _NZ=$k[--$j];var _Na=$k[--$j];$k[$j++]=_Na;$k[$j++]=_NZ;$k[$j++]=$f(_Na-1);$k[$j++]=$f(_NZ-2)},function(){var _Nb=$k[--$j];var _Nc=$k[--$j];$k[$j++]=_Nc;$k[$j++]=_Nb;$k[$j++]=$f(_Nc-1);$k[$j++]=$f(_Nb-1)},function(){var _Nd=$k[--$j];var _Ne=$k[--$j];$k[$j++]=_Ne;$k[$j++]=_Nd;$k[$j++]=$f(_Ne-1);$k[$j++]=_Nd},function(){var _Nf=$k[--$j];var _Ng=$k[--$j];$k[$j++]=_Ng;$k[$j++]=_Nf;$k[$j++]=_Ng;$k[$j++]=$f(_Nf-2)},function(){var _Nh=$k[--$j];var _Ni=$k[--$j];$k[$j++]=_Ni;$k[$j++]=_Nh;$k[$j++]=_Ni;$k[$j++]=$f(_Nh-1)},function(){var _Nj=$k[--$j];var _Nk=$k[--$j];$k[$j++]=_Nk;$k[$j++]=_Nj;$k[$j++]=_Nk;$k[$j++]=_Nj}]);$1.dmn=_Nl;var _Nu=$a([function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=0},function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=1},function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=2},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-2)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=1;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=2;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=3;$k[$j++]=$f($1.mcols-1)}]);$1.dmc1=_Nu;var _O3=$a([function(){$k[$j++]=$f($1.mrows-3);$k[$j++]=0},function(){$k[$j++]=$f($1.mrows-2);$k[$j++]=0},function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=0},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-4)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-3)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-2)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=1;$k[$j++]=$f($1.mcols-1)}]);$1.dmc2=_O3;var _OC=$a([function(){$k[$j++]=$f($1.mrows-3);$k[$j++]=0},function(){$k[$j++]=$f($1.mrows-2);$k[$j++]=0},function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=0},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-2)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=1;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=2;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=3;$k[$j++]=$f($1.mcols-1)}]);$1.dmc3=_OC;var _OM=$a([function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=0},function(){$k[$j++]=$f($1.mrows-1);$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-3)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-2)},function(){$k[$j++]=0;$k[$j++]=$f($1.mcols-1)},function(){$k[$j++]=1;$k[$j++]=$f($1.mcols-3)},function(){$k[$j++]=1;$k[$j++]=$f($1.mcols-2)},function(){$k[$j++]=1;$k[$j++]=$f($1.mcols-1)}]);$1.dmc4=_OM;$k[$j++]=Infinity;for(var _OP=0,_OQ=$1.mrows*$1.mcols;_OP<_OQ;_OP++){$k[$j++]=-1}$1.mmat=$a();for(var _OT=$1.cws.length-1;_OT>=0;_OT-=1){$k[$j++]=$g($1.cws,_OT)}$k[$j++]=4;$k[$j++]=0;for(;;){var _OW=$k[--$j];var _OX=$k[--$j];$k[$j++]=_OX;$k[$j++]=_OW;if(_OW==0&&_OX==$1.mrows){$k[$j++]=$1.dmc1;$1.module()}var _Oa=$k[--$j];var _Ob=$k[--$j];$k[$j++]=_Ob;$k[$j++]=_Oa;if(_Oa==0&&_Ob==$f($1.mrows-2)&&$1.mcols%4!=0){$k[$j++]=$1.dmc2;$1.module()}var _Of=$k[--$j];var _Og=$k[--$j];$k[$j++]=_Og;$k[$j++]=_Of;if(_Of==0&&_Og==$f($1.mrows-2)&&$1.mcols%8==4){$k[$j++]=$1.dmc3;$1.module()}var _Ok=$k[--$j];var _Ol=$k[--$j];$k[$j++]=_Ol;$k[$j++]=_Ok;if(_Ok==2&&_Ol==$f($1.mrows+4)&&$1.mcols%8==0){$k[$j++]=$1.dmc4;$1.module()}for(;;){var _Op=$k[--$j];var _Oq=$k[--$j];$k[$j++]=_Oq;$k[$j++]=_Op;if(_Op>=0&&_Oq<$1.mrows){var _Os=$k[--$j];var _Ot=$k[--$j];$k[$j++]=_Ot;$k[$j++]=_Os;if($g($1.mmat,$f(_Os+_Ot*$1.mcols))==-1){$k[$j++]=$1.dmn;$1.module()}}var _Oy=$k[--$j];var _Oz=$k[--$j];$k[$j++]=$f(_Oz-2);$k[$j++]=$f(_Oy+2);if(!($f(_Oy+2)<$1.mcols&&$f(_Oz-2)>=0)){break}}var _P1=$k[--$j];var _P2=$k[--$j];$k[$j++]=$f(_P2+1);$k[$j++]=$f(_P1+3);for(;;){var _P3=$k[--$j];var _P4=$k[--$j];$k[$j++]=_P4;$k[$j++]=_P3;if(_P3<$1.mcols&&_P4>=0){var _P6=$k[--$j];var _P7=$k[--$j];$k[$j++]=_P7;$k[$j++]=_P6;if($g($1.mmat,$f(_P6+_P7*$1.mcols))==-1){$k[$j++]=$1.dmn;$1.module()}}var _PC=$k[--$j];var _PD=$k[--$j];$k[$j++]=$f(_PD+2);$k[$j++]=$f(_PC-2);if(!($f(_PC-2)>=0&&$f(_PD+2)<$1.mrows)){break}}var _PF=$k[--$j];var _PG=$k[--$j];$k[$j++]=$f(_PG+3);$k[$j++]=$f(_PF+1);if(!($f(_PF+1)<$1.mcols||$f(_PG+3)<$1.mrows)){$j-=2;break}}if($g($1.mmat,$f($1.mrows*$1.mcols-1))==-1){$P($1.mmat,$f($1.mrows*$f($1.mcols-1)-2),$a([1,0]));$P($1.mmat,$f($1.mrows*$1.mcols-2),$a([0,1]))}$1.pixs=$a($1.rows*$1.cols);$1.cwpos=0;for(var _Pa=0,_PZ=$f($1.rows-1);_Pa<=_PZ;_Pa+=1){$1.i=_Pa;if($1.i%($1.rrows+2)==0){$k[$j++]=$1.pixs;$k[$j++]=$1.i*$1.cols;$k[$j++]=Infinity;for(var _Ph=0,_Pi=~~($1.cols/2);_Ph<_Pi;_Ph++){$k[$j++]=1;$k[$j++]=0}var _Pj=$a();var _Pk=$k[--$j];$P($k[--$j],_Pk,_Pj)}if($1.i%($1.rrows+2)==$1.rrows+1){$k[$j++]=$1.pixs;$k[$j++]=$1.i*$1.cols;$k[$j++]=Infinity;for(var _Pt=0,_Pu=$1.cols;_Pt<_Pu;_Pt++){$k[$j++]=1}var _Pv=$a();var _Pw=$k[--$j];$P($k[--$j],_Pw,_Pv)}if($1.i%($1.rrows+2)!=0&&$1.i%($1.rrows+2)!=$1.rrows+1){for(var _Q5=0,_Q4=$f($1.cols-1);_Q5<=_Q4;_Q5+=1){$1.j=_Q5;if($1.j%($1.rcols+2)==0){$p($1.pixs,$f($1.i*$1.cols+$1.j),1)}if($1.j%($1.rcols+2)==$1.rcols+1){$p($1.pixs,$f($1.i*$1.cols+$1.j),$1.i%2)}if($1.j%($1.rcols+2)!=0&&$1.j%($1.rcols+2)!=$1.rcols+1){$p($1.pixs,$f($1.i*$1.cols+$1.j),$g($1.mmat,$1.cwpos));$1.cwpos=$1.cwpos+1}}}}var _Qd=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.cols],["pixy",$1.rows],["height",$1.rows*2/72],["width",$1.cols*2/72],["opt",$1.options]]);$k[$j++]=_Qd;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_datamatrixrectangular(){var $1=Object.create(bwipp_datamatrixrectangular.$ctx||(bwipp_datamatrixrectangular.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"format","rectangle");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_datamatrixrectangularextension(){var $1=Object.create(bwipp_datamatrixrectangularextension.$ctx||(bwipp_datamatrixrectangularextension.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"dmre",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_mailmark(){var $1=Object.create(bwipp_mailmark.$ctx||(bwipp_mailmark.$ctx={}));$1.type="unset";$1.parse=false;$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];$1[$k[--$j]]=_6;$1.barlen=$1.barcode.length;delete $1.options["parse"];var _A=$1["type"];if($ne(_A,"7")&&($ne(_A,"9")&&$ne(_A,"29"))){$k[$j++]="bwipp.mailmarkBadType#19438";$k[$j++]="Royal Mail Mailmark type must be 7, 9 or 29";bwipp_raiseerror()}var _B=new Map([["7","24x24"],["9","32x32"],["29","16x48"]]);$1.version=$g(_B,$1["type"]);var _E=new Map([["7","square"],["9","square"],["29","rectangle"]]);$1.format=$g(_E,$1["type"]);if($1.barcode.length<45){$k[$j++]="bwipp.mailmarkBadLength#19454";$k[$j++]="Royal Mail Mailmark must contain at least 45 characters of Mailmark formatted data, including any required space padding";bwipp_raiseerror()}if($ne($G($1.barcode,0,4),"JGB ")){$k[$j++]="bwipp.mailmarkBadIndicator#19457";$k[$j++]="Royal Mail Mailmark must begin with JGB<space> identifier";bwipp_raiseerror()}$p($1.options,"dontdraw",true);$p($1.options,"version",$1.version);$p($1.options,"format",$1.format);$p($1.options,"c40headerlength",45);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _S=$k[--$j];$1[$k[--$j]]=_S;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_qrcode(){var $1=Object.create(bwipp_qrcode.$ctx||(bwipp_qrcode.$ctx={}));$1.dontdraw=false;$1.format="unset";$1.version="unset";$1.eclevel="unset";$1.parse=false;$1.parsefnc=false;$1.mask=-1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.qrcodeEmptyData#19520";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($ne($1.version,"unset")){if($eq($1.format,"unset")){$k[$j++]="full";if($eq($G($1.version,0,1),"M")){$j--;$k[$j++]="micro"}if($eq($G($1.version,0,1),"R")){$j--;$k[$j++]="rmqr"}$1.format=$k[--$j]}}else{if($eq($1.format,"unset")){$1.format="full"}}if($ne($1.format,"full")&&($ne($1.format,"micro")&&$ne($1.format,"rmqr"))){$k[$j++]="bwipp.qrcodeInvalidFormat#19536";$k[$j++]="The format must be either full, micro or rmqr";bwipp_raiseerror()}if($eq($1.format,"rmqr")&&$eq($1.version,"unset")){$k[$j++]="bwipp.qrcodeRMQRwithoutVersion#19540";$k[$j++]="A version must be provided for RMQR";bwipp_raiseerror()}if($eq($1.eclevel,"unset")){$k[$j++]="eclevel";if($ne($1.format,"micro")){$k[$j++]="M"}else{$k[$j++]="L"}var _I=$k[--$j];$1[$k[--$j]]=_I}if($ne($1.eclevel,"L")&&($ne($1.eclevel,"M")&&($ne($1.eclevel,"Q")&&$ne($1.eclevel,"H")))){$k[$j++]="bwipp.qrcodeInvalidEClevel#19547";$k[$j++]="Error correction level must be either L, M, Q, or H";bwipp_raiseerror()}if($1.mask!=-1&&$eq($1.format,"rmqr")){$k[$j++]="bwipp.qrcodeRMQRmask#19551";$k[$j++]="A mask cannot be supplied for RMQR";bwipp_raiseerror()}if($1.mask!=-1){var _U=$eq($1.format,"full")?8:4;if($1.mask<1||$1.mask>_U){$k[$j++]="bwipp.qrcodeBadMask#19556";$k[$j++]="An invalid mask was supplied";bwipp_raiseerror()}}$1.fn1=-1;var _Y=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true],["FNC1",$1.fn1]]);$1.fncvals=_Y;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _b=$k[--$j];$1[$k[--$j]]=_b;$1.msglen=$1.msg.length;$1.fnc1first=false;if($1.msglen>0){if($g($1.msg,0)==$1.fn1){$1.fnc1first=true;$k[$j++]=Infinity;var _k=$G($1.msg,1,$1.msglen-1);for(var _l=0,_m=_k.length;_l<_m;_l++){var _n=$g(_k,_l);$k[$j++]=_n;if(_n==37){var _o=$k[--$j];$k[$j++]=_o;$k[$j++]=_o}}$1.msg=$a();$1.msglen=$1.msg.length}}if(!bwipp_qrcode.__19700__){(function(){var $ctx=Object.create($1);var _r=$a(["v1to9","v10to26","v27to40","vM1","vM2","vM3","vM4","vR7x43","vR7x59","vR7x77","vR7x99","vR7x139","vR9x43","vR9x59","vR9x77","vR9x99","vR9x139","vR11x27","vR11x43","vR11x59","vR11x77","vR11x99","vR11x139","vR13x27","vR13x43","vR13x59","vR13x77","vR13x99","vR13x139","vR15x43","vR15x59","vR15x77","vR15x99","vR15x139","vR17x43","vR17x59","vR17x77","vR17x99","vR17x139"]);$k[$j++]=0;for(var _s=0,_t=_r.length;_s<_t;_s++){var _v=$k[--$j];$ctx[$g(_r,_s)]=_v;$k[$j++]=$f(_v+1)}$j--;$ctx.N=0;$ctx.A=1;$ctx.B=2;$ctx.K=3;$ctx.E=4;$k[$j++]=Infinity;$k[$j++]=Infinity;for(var _w=48;_w<=57;_w+=1){$k[$j++]=_w}var _x=$a();for(var _y=0,_z=_x.length;_y<_z;_y++){$k[$j++]=$g(_x,_y);$k[$j++]=-1}$ctx.Nexcl=$d();$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=32;$k[$j++]=36;$k[$j++]=37;$k[$j++]=42;$k[$j++]=43;$k[$j++]=45;$k[$j++]=46;$k[$j++]=47;$k[$j++]=58;for(var _12=65;_12<=90;_12+=1){$k[$j++]=_12}$k[$j++]=$ctx.fn1;var _14=$a();for(var _15=0,_16=_14.length;_15<_16;_15++){$k[$j++]=$g(_14,_15);$k[$j++]=-1}$ctx.Aexcl=$d();$k[$j++]=Infinity;$k[$j++]=Infinity;for(var _19=129;_19<=159;_19+=1){$k[$j++]=_19}for(var _1A=224;_1A<=235;_1A+=1){$k[$j++]=_1A}var _1B=$a();for(var _1C=0,_1D=_1B.length;_1C<_1D;_1C++){$k[$j++]=$g(_1B,_1C);$k[$j++]=-1}$ctx.Kexcl=$d();$k[$j++]=Infinity;$k[$j++]=$a(["0001","0010","0100","1000","0111"]);$k[$j++]=$a(["0001","0010","0100","1000","0111"]);$k[$j++]=$a(["0001","0010","0100","1000","0111"]);$k[$j++]=$a(["",-1,-1,-1,-1]);$k[$j++]=$a(["0","1",-1,-1,-1]);$k[$j++]=$a(["00","01","10","11",-1]);$k[$j++]=$a(["000","001","010","011",-1]);for(var _1N=0,_1O=32;_1N<_1O;_1N++){$k[$j++]=$a(["001","010","011","100","111"])}$ctx.mids=$a();$ctx.cclens=$a([$a([10,9,8,8]),$a([12,11,16,10]),$a([14,13,16,12]),$a([3,-1,-1,-1]),$a([4,3,-1,-1]),$a([5,4,4,3]),$a([6,5,5,4]),$a([4,3,3,2]),$a([5,5,4,3]),$a([6,5,5,4]),$a([7,6,5,5]),$a([7,6,6,5]),$a([5,5,4,3]),$a([6,5,5,4]),$a([7,6,5,5]),$a([7,6,6,5]),$a([8,7,6,6]),$a([4,4,3,2]),$a([6,5,5,4]),$a([7,6,5,5]),$a([7,6,6,5]),$a([8,7,6,6]),$a([8,7,7,6]),$a([5,5,4,3]),$a([6,6,5,5]),$a([7,6,6,5]),$a([7,7,6,6]),$a([8,7,7,6]),$a([8,8,7,7]),$a([7,6,6,5]),$a([7,7,6,5]),$a([8,7,7,6]),$a([8,7,7,6]),$a([9,8,7,7]),$a([7,6,6,5]),$a([8,7,6,6]),$a([8,7,7,6]),$a([8,8,7,6]),$a([9,8,8,7])]);$k[$j++]=Infinity;for(var _25=0,_26=3;_25<_26;_25++){$k[$j++]=4}$k[$j++]=3;$k[$j++]=5;$k[$j++]=7;$k[$j++]=9;for(var _27=0,_28=32;_27<_28;_27++){$k[$j++]=3}$ctx.termlens=$a();$ctx.padstrs=$a(["11101100","00010001"]);$ctx.charmap="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";$ctx.charvals=new Map;for(var _2B=0;_2B<=44;_2B+=1){$p($ctx.charvals,$g($ctx.charmap,_2B),_2B)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__19700__=1})()}$1.tobin=function(){var _2H=$s($k[--$j]);$k[$j++]=_2H;for(var _2J=0,_2I=_2H.length-1;_2J<=_2I;_2J+=1){var _2K=$k[--$j];$p(_2K,_2J,48);$k[$j++]=_2K}var _2L=$k[--$j];var _2O=$R($s(_2L.length),$k[--$j],2);$P(_2L,_2L.length-_2O.length,_2O);$k[$j++]=_2L};$1.encA=function(){$1.in=$k[--$j];if($1.fnc1first){$k[$j++]=Infinity;$F($1.in,function(){var _2S=$k[--$j];$k[$j++]=_2S;if(_2S==$1.fn1){$j--;$k[$j++]=37}});$1.in=$a()}$1.out=$s(~~($1.in.length*11/2)+1);$1.k=0;$1.m=0;for(;;){if($1.k==$1.in.length){break}if($1.k<$1.in.length-1){$k[$j++]=$f($g($1.charvals,$g($1.in,$1.k))*45+$g($1.charvals,$g($1.in,$1.k+1)));$k[$j++]=11;$1.tobin();$1.k=$1.k+2}else{$k[$j++]=$g($1.charvals,$g($1.in,$1.k));$k[$j++]=6;$1.tobin();$1.k=$1.k+1}var _2s=$k[--$j];$P($1.out,$1.m,_2s);$1.m=_2s.length+$1.m}$k[$j++]=$G($1.out,0,$1.m)};$1.encN=function(){$1.in=$k[--$j];$1.out=$s(~~($1.in.length*10/3)+1);$1.k=0;$1.m=0;for(;;){if($1.k==$1.in.length){break}if($1.k<$1.in.length-2){var _38=$G($1.in,$1.k,3);$k[$j++]=0;for(var _39=0,_3A=_38.length;_39<_3A;_39++){var _3C=$k[--$j];$k[$j++]=$f($g(_38,_39)+$f(_3C*10-48))}$k[$j++]=10;$1.tobin();$1.k=$1.k+3}else{if($1.k==$1.in.length-2){var _3I=$G($1.in,$1.k,2);$k[$j++]=0;for(var _3J=0,_3K=_3I.length;_3J<_3K;_3J++){var _3M=$k[--$j];$k[$j++]=$f($g(_3I,_3J)+$f(_3M*10-48))}$k[$j++]=7;$1.tobin();$1.k=$1.k+2}else{var _3Q=$G($1.in,$1.k,1);$k[$j++]=0;for(var _3R=0,_3S=_3Q.length;_3R<_3S;_3R++){var _3U=$k[--$j];$k[$j++]=$f($g(_3Q,_3R)+$f(_3U*10-48))}$k[$j++]=4;$1.tobin();$1.k=$1.k+1}}var _3W=$k[--$j];$P($1.out,$1.m,_3W);$1.m=_3W.length+$1.m}$k[$j++]=$G($1.out,0,$1.m)};$1.encB=function(){$1.in=$k[--$j];if($1.fnc1first){$k[$j++]=Infinity;$F($1.in,function(){var _3g=$k[--$j];$k[$j++]=_3g;if(_3g==$1.fn1){$j--;$k[$j++]=29}});$1.in=$a()}$1.out=$s($1.in.length*8);for(var _3n=0,_3m=$1.in.length-1;_3n<=_3m;_3n+=1){$1.k=_3n;$k[$j++]=$i($g($1.in,$1.k));$k[$j++]=8;$1.tobin();$P($1.out,$1.k*8,$k[--$j])}$k[$j++]=$1.out};$1.encK=function(){$1.in=$k[--$j];$1.out=$s(~~($1.in.length/2)*13);$1.k=0;$1.m=0;for(;;){if($1.k==$1.in.length){break}var _46=$f($g($1.in,$1.k)*256+$g($1.in,$1.k+1));$k[$j++]=_46;if(_46<57408){$k[$j++]=33088}else{$k[$j++]=49472}var _47=$k[--$j];var _49=$f($k[--$j]-_47);$k[$j++]=$f((_49>>>8)*192+(_49&255));$k[$j++]=13;$1.tobin();var _4A=$k[--$j];$P($1.out,$1.m,_4A);$1.m=_4A.length+$1.m;$1.k=$1.k+2}$k[$j++]=$1.out};$1.encE=function(){var _4I=$f(-$g($k[--$j],0)-1e6);$k[$j++]=_4I;if(_4I<=127){$k[$j++]=8;$1.tobin()}else{var _4J=$k[--$j];$k[$j++]=_4J;if(_4J<=16383){var _4K=$k[--$j];$k[$j++]=$f(_4K+32768);$k[$j++]=16;$1.tobin()}else{var _4L=$k[--$j];$k[$j++]=$f(_4L+12582912);$k[$j++]=24;$1.tobin()}}};$1.encfuncs=$a(["encN","encA","encB","encK","encE"]);$1.addtobits=function(){var _4N=$k[--$j];$P($1.bits,$1.j,_4N);$1.j=_4N.length+$1.j};$k[$j++]=Infinity;for(var _4S=0,_4T=$1.msglen;_4S<_4T;_4S++){$k[$j++]=0}$k[$j++]=0;$1.numNs=$a();$k[$j++]=Infinity;for(var _4W=0,_4X=$1.msglen;_4W<_4X;_4W++){$k[$j++]=0}$k[$j++]=0;$1.numAs=$a();$k[$j++]=Infinity;for(var _4a=0,_4b=$1.msglen;_4a<_4b;_4a++){$k[$j++]=0}$k[$j++]=0;$1.numAorNs=$a();$k[$j++]=Infinity;for(var _4e=0,_4f=$1.msglen;_4e<_4f;_4e++){$k[$j++]=0}$k[$j++]=0;$1.numBs=$a();$k[$j++]=Infinity;for(var _4i=0,_4j=$1.msglen;_4i<_4j;_4i++){$k[$j++]=0}$k[$j++]=0;$1.numKs=$a();$k[$j++]=Infinity;for(var _4m=0,_4n=$1.msglen;_4m<_4n;_4m++){$k[$j++]=0}$k[$j++]=9999;$1.nextNs=$a();$k[$j++]=Infinity;for(var _4q=0,_4r=$1.msglen;_4q<_4r;_4q++){$k[$j++]=0}$k[$j++]=9999;$1.nextBs=$a();$k[$j++]=Infinity;for(var _4u=0,_4v=$1.msglen;_4u<_4v;_4u++){$k[$j++]=0}$k[$j++]=9999;$1.nextAs=$a();$k[$j++]=Infinity;for(var _4y=0,_4z=$1.msglen;_4y<_4z;_4y++){$k[$j++]=0}$k[$j++]=9999;$1.nextKs=$a();$1.isECI=$a($1.msglen);for(var _54=$1.msglen-1;_54>=0;_54-=1){$1.i=_54;$1.barchar=$g($1.msg,$1.i);var _5A=$g($1.Kexcl,$1.barchar)!==undefined;if(_5A){$k[$j++]="sjis";if($1.i+1<$1.msglen){$k[$j++]=$f($1.barchar*256+$g($1.msg,$1.i+1))}else{$k[$j++]=0}var _5H=$k[--$j];$1[$k[--$j]]=_5H;if($1.sjis>=33088&&$1.sjis<=40956||$1.sjis>=57408&&$1.sjis<=60351){$p($1.nextKs,$1.i,0);$p($1.numKs,$1.i,$f($g($1.numKs,$1.i+2)+1))}else{$p($1.nextKs,$1.i,$f($g($1.nextKs,$1.i+1)+1))}}else{$p($1.nextKs,$1.i,$f($g($1.nextKs,$1.i+1)+1))}var _5g=$g($1.Nexcl,$1.barchar)!==undefined;if(_5g){$p($1.nextNs,$1.i,0);$p($1.numNs,$1.i,$f($g($1.numNs,$1.i+1)+1));$p($1.numAorNs,$1.i,$f($g($1.numAorNs,$1.i+1)+1))}else{$p($1.nextNs,$1.i,$f($g($1.nextNs,$1.i+1)+1))}var _60=$g($1.Aexcl,$1.barchar)!==undefined;if(_60){$p($1.nextAs,$1.i,0);$p($1.numAs,$1.i,$f($g($1.numAs,$1.i+1)+1));$p($1.numAorNs,$1.i,$f($g($1.numAorNs,$1.i+1)+1))}else{$p($1.nextAs,$1.i,$f($g($1.nextAs,$1.i+1)+1))}$p($1.isECI,$1.i,$1.barchar<=-1e6)}for(var _6N=0,_6M=$1.msglen-1;_6N<=_6M;_6N+=1){$1.i=_6N;if($g($1.numKs,$1.i)>0){$p($1.numKs,$1.i+1,0);$p($1.nextKs,$1.i+1,$f($g($1.nextKs,$1.i+1)+1))}}for(var _6Z=$1.msglen-1;_6Z>=0;_6Z-=1){$1.i=_6Z;if($f($g($1.numNs,$1.i)+$f($g($1.numAs,$1.i)+$g($1.numKs,$1.i)))==0&&$nt($g($1.isECI,$1.i))){$p($1.nextBs,$1.i,0);$p($1.numBs,$1.i,$f($g($1.numBs,$1.i+1)+1))}else{$p($1.nextBs,$1.i,$f($g($1.nextBs,$1.i+1)+1))}}$1.KbeforeB=function(){var _71=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numK,_71)&&$g($1.nextBs,$f($1.numK*2+$1.i))==0};$1.KbeforeA=function(){var _79=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numK,_79)&&$g($1.nextAs,$f($1.numK*2+$1.i))==0};$1.KbeforeN=function(){var _7H=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numK,_7H)&&$g($1.nextNs,$f($1.numK*2+$1.i))==0};$1.KbeforeE=function(){var _7P=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numK,_7P)&&$f($1.numK*2+$1.i)==$1.msglen};$1.AbeforeK=function(){var _7W=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numA,_7W)&&$g($1.nextKs,$f($1.numA+$1.i))==0};$1.AbeforeB=function(){var _7e=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numA,_7e)&&$g($1.nextBs,$f($1.numA+$1.i))==0};$1.AbeforeN=function(){var _7m=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numA,_7m)&&$g($1.nextNs,$f($1.numA+$1.i))==0};$1.AbeforeE=function(){var _7u=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numA,_7u)&&$f($1.numA+$1.i)==$1.msglen};$1.NbeforeK=function(){var _81=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numN,_81)&&$g($1.nextKs,$f($1.numN+$1.i))==0};$1.NbeforeB=function(){var _89=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numN,_89)&&$g($1.nextBs,$f($1.numN+$1.i))==0};$1.NbeforeA=function(){var _8H=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numN,_8H)&&$g($1.nextAs,$f($1.numN+$1.i))==0};$1.NbeforeE=function(){var _8P=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numN,_8P)&&$f($1.numN+$1.i)==$1.msglen};$1.AorNbeforeB=function(){var _8W=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numAorN,_8W)&&$g($1.nextBs,$f($1.numAorN+$1.i))==0};$1.AorNbeforeE=function(){var _8e=$g($k[--$j],$1.ver);$k[$j++]=$ge($1.numAorN,_8e)&&$f($1.numAorN+$1.i)==$1.msglen};$1.nextNslt=function(){if($g($1.nextNs,$1.i)>=$1.msglen){$j--;$k[$j++]=true}else{var _8u=$g($k[--$j],$1.ver);$k[$j++]=$lt($g($1.numNs,$f($g($1.nextNs,$1.i)+$1.i)),_8u)}};if(!bwipp_qrcode.__19901__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;$k[$j++]="full";$k[$j++]=Infinity;for(var _8v=0;_8v<=9;_8v+=1){$k[$j++]=$R($s(2),_8v,10);$k[$j++]=$ctx.v1to9}for(var _8z=10;_8z<=26;_8z+=1){$k[$j++]=$R($s(2),_8z,10);$k[$j++]=$ctx.v10to26}for(var _93=27;_93<=40;_93+=1){$k[$j++]=$R($s(2),_93,10);$k[$j++]=$ctx.v27to40}var _97=$d();var _9C=new Map([["M1",$ctx.vM1],["M2",$ctx.vM2],["M3",$ctx.vM3],["M4",$ctx.vM4]]);var _9j=new Map([["R7x43",$ctx.vR7x43],["R7x59",$ctx.vR7x59],["R7x77",$ctx.vR7x77],["R7x99",$ctx.vR7x99],["R7x139",$ctx.vR7x139],["R9x43",$ctx.vR9x43],["R9x59",$ctx.vR9x59],["R9x77",$ctx.vR9x77],["R9x99",$ctx.vR9x99],["R9x139",$ctx.vR9x139],["R11x27",$ctx.vR11x27],["R11x43",$ctx.vR11x43],["R11x59",$ctx.vR11x59],["R11x77",$ctx.vR11x77],["R11x99",$ctx.vR11x99],["R11x139",$ctx.vR11x139],["R13x27",$ctx.vR13x27],["R13x43",$ctx.vR13x43],["R13x59",$ctx.vR13x59],["R13x77",$ctx.vR13x77],["R13x99",$ctx.vR13x99],["R13x139",$ctx.vR13x139],["R15x43",$ctx.vR15x43],["R15x59",$ctx.vR15x59],["R15x77",$ctx.vR15x77],["R15x99",$ctx.vR15x99],["R15x139",$ctx.vR15x139],["R17x43",$ctx.vR17x43],["R17x59",$ctx.vR17x59],["R17x77",$ctx.vR17x77],["R17x99",$ctx.vR17x99],["R17x139",$ctx.vR17x139]]);$k[$j++]=_97;$k[$j++]="micro";$k[$j++]=_9C;$k[$j++]="rmqr";$k[$j++]=_9j;$ctx.versetmap=$d();$ctx.versetfull=$a([$ctx.v1to9,$ctx.v10to26,$ctx.v27to40]);$ctx.versetmicro=$a([$ctx.vM1,$ctx.vM2,$ctx.vM3,$ctx.vM4]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__19901__=1})()}if($ne($1.version,"unset")){var _9y=$g($1.versetmap,$1.format);var _9z=$1.version;var _A0=$g(_9y,_9z)!==undefined;$k[$j++]=_9y;$k[$j++]=_9z;if(!_A0){$j-=2;if($eq($1.format,"full")){$k[$j++]="bwipp.qrcodeInvalidFullVersion#19907";$k[$j++]="Valid versions for QR Code symbols are 1 to 40";bwipp_raiseerror()}else{if($eq($1.format,"micro")){$k[$j++]="bwipp.qrcodeInvalidMicroVersion#19910";$k[$j++]="Valid versions for Micro QR Code symbols are M1 to M4";bwipp_raiseerror()}else{$k[$j++]="bwipp.qrcodeInvalidRMQRversion#19912";$k[$j++]="Invalid version for an RMQR symbol";bwipp_raiseerror()}}}var _A3=$k[--$j];var _A5=$g($k[--$j],_A3);$k[$j++]=_A5;$k[$j++]=Infinity;var _A6=$k[--$j];var _A7=$k[--$j];$k[$j++]=_A6;$k[$j++]=_A7;$1.verset=$a()}else{if($eq($1.format,"full")){$1.verset=$1.versetfull}if($eq($1.format,"micro")){$1.verset=$1.versetmicro}}$k[$j++]=Infinity;for(var _AD=0,_AE=39;_AD<_AE;_AD++){$k[$j++]=-1}$1.msgbits=$a();$1.e=1e4;if(!bwipp_qrcode.__19955__){(function(){var $ctx=Object.create($1);$ctx.mode0forceKB=$a([1,1,1,$ctx.e,$ctx.e,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]);$ctx.mode0forceA=$a([1,1,1,$ctx.e,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]);$ctx.mode0forceN=$a([1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]);$ctx.mode0NbeforeB=$a([4,4,5,$ctx.e,$ctx.e,2,3,2,2,3,3,3,2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]);$ctx.modeBKbeforeB=$a([9,12,13,$ctx.e,$ctx.e,4,6,4,5,6,6,6,5,6,6,6,7,4,6,6,6,7,7,5,6,6,7,7,7,6,6,7,7,7,6,7,7,7,8]);$ctx.modeBKbeforeA=$a([8,10,11,$ctx.e,$ctx.e,4,5,4,5,5,6,6,5,5,6,6,6,4,5,6,6,6,6,5,6,6,6,6,7,6,6,6,6,7,6,6,6,7,7]);$ctx.modeBKbeforeN=$a([8,9,11,$ctx.e,$ctx.e,3,5,3,4,5,5,5,4,5,5,5,6,3,5,5,5,6,6,4,5,5,6,6,6,5,5,6,6,7,5,6,6,6,7]);$ctx.modeBKbeforeE=$a([5,5,6,$ctx.e,$ctx.e,2,3,2,3,3,3,3,3,3,3,3,4,2,3,3,3,4,4,3,3,3,4,4,4,3,3,4,4,4,3,4,4,4,4]);$ctx.modeBAbeforeK=$a([11,12,14,$ctx.e,$ctx.e,5,7,5,6,7,8,8,6,7,8,8,8,6,7,8,8,8,8,6,8,8,8,8,9,8,8,8,8,9,8,8,8,9,9]);$ctx.modeBAbeforeB=$a([11,15,16,$ctx.e,$ctx.e,6,7,6,7,7,8,8,7,7,8,8,8,6,7,8,8,8,9,7,8,8,8,9,9,8,8,9,9,9,8,8,9,9,10]);$ctx.modeBAbeforeN=$a([12,13,15,$ctx.e,$ctx.e,6,8,6,7,8,8,8,7,8,8,8,9,6,8,8,8,9,9,7,8,8,9,9,10,8,9,9,9,10,8,9,9,10,10]);$ctx.modeBAbeforeE=$a([6,7,8,$ctx.e,$ctx.e,3,4,3,4,4,4,4,4,4,4,4,5,4,4,4,4,5,5,4,4,4,5,5,5,4,5,5,5,5,4,5,5,5,5]);$ctx.modeBNbeforeK=$a([6,7,8,$ctx.e,$ctx.e,3,4,3,4,4,5,5,4,4,5,5,5,3,4,5,5,5,5,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5]);$ctx.modeBNbeforeB=$a([6,8,9,$ctx.e,$ctx.e,3,4,3,4,4,5,5,4,4,5,5,5,3,4,5,5,5,5,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,6]);$ctx.modeBNbeforeA=$a([6,7,8,$ctx.e,$ctx.e,3,4,3,4,4,5,5,4,4,5,5,5,4,4,5,5,5,5,4,5,5,5,5,5,5,5,5,5,6,5,5,5,5,6]);$ctx.modeBNbeforeE=$a([3,4,4,$ctx.e,$ctx.e,2,3,2,2,3,3,3,2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]);$ctx.modeANbeforeA=$a([13,15,17,$ctx.e,5,7,9,7,8,9,9,9,8,9,9,9,11,7,9,9,9,11,11,8,9,9,10,11,11,9,10,11,11,11,9,11,11,11,11]);$ctx.modeANbeforeB=$a([13,17,18,$ctx.e,$ctx.e,7,9,7,8,9,9,9,8,9,9,9,10,7,9,9,9,10,11,8,9,9,9,11,11,9,9,11,11,11,9,10,11,11,11]);$ctx.modeANbeforeE=$a([7,8,9,$ctx.e,3,4,5,4,5,5,5,5,5,5,5,5,6,4,5,5,5,6,6,5,5,5,5,6,6,5,5,6,6,6,5,6,6,6,6]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__19955__=1})()}var _B7=$1.verset;for(var _B8=0,_B9=_B7.length;_B8<_B9;_B8++){$1.ver=$g(_B7,_B8);$1.mode=-1;$1.seq=$a([]);$1.i=0;for(;;){if($1.i>=$1.msglen){break}$1.numK=$g($1.numKs,$1.i);$1.numB=$g($1.numBs,$1.i);$1.numA=$g($1.numAs,$1.i);$1.numN=$g($1.numNs,$1.i);$1.numAorN=$g($1.numAorNs,$1.i);$1.eci=$g($1.isECI,$1.i);if($eq($1.ver,$1.vM1)&&$1.numA>=1){$1.seq=-1;break}if($eq($1.ver,$1.vM1)&&$1.numB>=1){$1.seq=-1;break}if($eq($1.ver,$1.vM1)&&$1.numK>=1){$1.seq=-1;break}if($eq($1.ver,$1.vM1)&&$1.eci){$1.seq=-1;break}if($eq($1.ver,$1.vM2)&&$1.numB>=1){$1.seq=-1;break}if($eq($1.ver,$1.vM2)&&$1.numK>=1){$1.seq=-1;break}if($eq($1.ver,$1.vM2)&&$1.eci){$1.seq=-1;break}if($eq($1.ver,$1.vM3)&&$1.eci){$1.seq=-1;break}if($eq($1.ver,$1.vM4)&&$1.eci){$1.seq=-1;break}for(;;){if($1.eci){$k[$j++]=$1.E;break}if($1.mode==-1){$k[$j++]=$1.mode0forceKB;$1.KbeforeA();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.mode0forceKB;$1.KbeforeN();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.modeBKbeforeE;$1.KbeforeB();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.mode0forceKB;$1.KbeforeE();if($k[--$j]){$k[$j++]=$1.K;break}if($1.numK>=1){$k[$j++]=$1.B;break}$k[$j++]=$1.mode0NbeforeB;$1.NbeforeB();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.mode0forceKB;$1.NbeforeB();if($k[--$j]){$k[$j++]=$1.B;break}$k[$j++]=$1.modeANbeforeE;$1.NbeforeA();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.mode0forceN;$1.NbeforeE();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeBAbeforeE;$1.AbeforeK();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.modeBAbeforeE;$1.AorNbeforeB();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.mode0forceA;$1.AorNbeforeE();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.B;break}if($1.mode==$1.B){$k[$j++]=$1.modeBKbeforeB;$1.KbeforeB();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.modeBKbeforeA;$1.KbeforeA();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.modeBKbeforeN;$1.KbeforeN();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.modeBKbeforeE;$1.KbeforeE();if($k[--$j]){$k[$j++]=$1.K;break}$k[$j++]=$1.modeBAbeforeK;$1.AbeforeK();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.modeBAbeforeB;$1.AbeforeB();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.modeBAbeforeN;$1.AbeforeN();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.modeBAbeforeE;$1.AbeforeE();if($k[--$j]){$k[$j++]=$1.A;break}$k[$j++]=$1.modeBNbeforeK;$1.NbeforeK();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeBNbeforeB;$1.NbeforeB();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeBNbeforeA;$1.NbeforeA();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeBNbeforeE;$1.NbeforeE();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeBAbeforeE;$1.AorNbeforeE();var _DH=$k[--$j];if(_DH&&$le($1.numAorN,$g($1.modeBAbeforeN,$1.ver))){$k[$j++]=$1.modeBNbeforeA;$1.nextNslt();if($k[--$j]){$k[$j++]=$1.A;break}}$k[$j++]=$1.B;break}if($1.mode==$1.A){if($1.numK>=1){$k[$j++]=$1.K;break}if($1.numB>=1){$k[$j++]=$1.B;break}$k[$j++]=$1.modeANbeforeA;$1.NbeforeA();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeANbeforeB;$1.NbeforeB();if($k[--$j]){$k[$j++]=$1.N;break}$k[$j++]=$1.modeANbeforeE;$1.NbeforeE();if($k[--$j]){$k[$j++]=$1.N;break}if($1.numA>=1||$1.numN>=1){$k[$j++]=$1.A;break}$k[$j++]=$1.B;break}if($1.mode==$1.N){if($1.numK>=1){$k[$j++]=$1.K;break}if($1.numB>=1){$k[$j++]=$1.B;break}if($1.numA>=1){$k[$j++]=$1.A;break}if($1.numN>=1){$k[$j++]=$1.N;break}$k[$j++]=$1.B;break}if($1.mode==$1.K){if($1.numB>=1){$k[$j++]=$1.B;break}if($1.numA>=1){$k[$j++]=$1.A;break}if($1.numN>=1){$k[$j++]=$1.N;break}if($1.numK>=1){$k[$j++]=$1.K;break}$k[$j++]=$1.B;break}}var _E1=$k[--$j];$k[$j++]=_E1;if(_E1==$1.K&&$1.fnc1first){$j--;$k[$j++]=$1.B}var _E5=$k[--$j];$k[$j++]=_E5;if(_E5==$1.mode){$j--;var _EB=$1.mode==$1.K?2:1;$1.dat=$G($1.msg,$1.i,_EB);$k[$j++]=Infinity;$q($1.seq);$k[$j++]=Infinity;var _EE=$k[--$j];var _EF=$k[--$j];$k[$j++]=_EE;$q(_EF);$q($1.dat);var _EH=$a();$k[$j++]=_EH;$1.seq=$a()}else{$1.mode=$k[--$j];if($1.mode==$1.K){$k[$j++]=$1.K;$k[$j++]=$G($1.msg,$1.i,$1.numK*2)}if($1.mode==$1.B){$k[$j++]=$1.B;$k[$j++]=$G($1.msg,$1.i,$1.numB)}if($1.mode==$1.A){$k[$j++]=$1.A;$k[$j++]=$G($1.msg,$1.i,$1.numA)}if($1.mode==$1.N){$k[$j++]=$1.N;$k[$j++]=$G($1.msg,$1.i,$1.numN)}if($1.mode==$1.E){$1.mode=-1;$k[$j++]=$1.E;$k[$j++]=$G($1.msg,$1.i,1)}$1.dat=$k[--$j];$1.sw=$k[--$j];$k[$j++]=Infinity;$q($1.seq);$k[$j++]=$1.sw;$k[$j++]=$1.dat;$1.seq=$a()}$1.i=$1.i+$1.dat.length}for(;;){if($1.seq==-1){break}$1.bits=$s(23648);$1.j=0;if($1.fnc1first){if($lt($1.ver,$1.vR7x43)){$k[$j++]="0101"}else{$k[$j++]="101"}$1.addtobits()}$1.abort=false;for(var _F7=0,_F6=$1.seq.length-1;_F7<=_F6;_F7+=2){$1.i=_F7;$1.mode=$g($1.seq,$1.i);$k[$j++]=$g($g($1.mids,$1.ver),$1.mode);$1.addtobits();$1.chars=$g($1.seq,$1.i+1);$k[$j++]="charslen";$k[$j++]=$1.chars.length;if($1.mode==$1.K){var _FM=$k[--$j];$k[$j++]=~~(_FM/2)}var _FN=$k[--$j];$1[$k[--$j]]=_FN;if($1.mode!=$1.E){$1.cclen=$g($g($1.cclens,$1.ver),$1.mode);if($1.charslen>=~~Math.pow(2,$1.cclen)){$1.abort=true;break}$k[$j++]=$1.charslen;$k[$j++]=$1.cclen;$1.tobin();$1.addtobits()}$k[$j++]=$1.chars;if($1[$g($1.encfuncs,$1.mode)]()===true){break}$1.addtobits()}if($1.abort){break}$1.bits=$G($1.bits,0,$1.j);$p($1.msgbits,$1.ver,$1.bits);break}}if(!bwipp_qrcode.__20173__){(function(){var $ctx=Object.create($1);$ctx.metrics=$a([$a(["micro","M1",$ctx.vM1,11,11,98,99,36,$a([2,99,99,99]),$a([1,0,-1,-1,-1,-1,-1,-1])]),$a(["micro","M2",$ctx.vM2,13,13,98,99,80,$a([5,6,99,99]),$a([1,0,1,0,-1,-1,-1,-1])]),$a(["micro","M3",$ctx.vM3,15,15,98,99,132,$a([6,8,99,99]),$a([1,0,1,0,-1,-1,-1,-1])]),$a(["micro","M4",$ctx.vM4,17,17,98,99,192,$a([8,10,14,99]),$a([1,0,1,0,1,0,-1,-1])]),$a(["full","1",$ctx.v1to9,21,21,98,99,208,$a([7,10,13,17]),$a([1,0,1,0,1,0,1,0])]),$a(["full","2",$ctx.v1to9,25,25,18,99,359,$a([10,16,22,28]),$a([1,0,1,0,1,0,1,0])]),$a(["full","3",$ctx.v1to9,29,29,22,99,567,$a([15,26,36,44]),$a([1,0,1,0,2,0,2,0])]),$a(["full","4",$ctx.v1to9,33,33,26,99,807,$a([20,36,52,64]),$a([1,0,2,0,2,0,4,0])]),$a(["full","5",$ctx.v1to9,37,37,30,99,1079,$a([26,48,72,88]),$a([1,0,2,0,2,2,2,2])]),$a(["full","6",$ctx.v1to9,41,41,34,99,1383,$a([36,64,96,112]),$a([2,0,4,0,4,0,4,0])]),$a(["full","7",$ctx.v1to9,45,45,22,38,1568,$a([40,72,108,130]),$a([2,0,4,0,2,4,4,1])]),$a(["full","8",$ctx.v1to9,49,49,24,42,1936,$a([48,88,132,156]),$a([2,0,2,2,4,2,4,2])]),$a(["full","9",$ctx.v1to9,53,53,26,46,2336,$a([60,110,160,192]),$a([2,0,3,2,4,4,4,4])]),$a(["full","10",$ctx.v10to26,57,57,28,50,2768,$a([72,130,192,224]),$a([2,2,4,1,6,2,6,2])]),$a(["full","11",$ctx.v10to26,61,61,30,54,3232,$a([80,150,224,264]),$a([4,0,1,4,4,4,3,8])]),$a(["full","12",$ctx.v10to26,65,65,32,58,3728,$a([96,176,260,308]),$a([2,2,6,2,4,6,7,4])]),$a(["full","13",$ctx.v10to26,69,69,34,62,4256,$a([104,198,288,352]),$a([4,0,8,1,8,4,12,4])]),$a(["full","14",$ctx.v10to26,73,73,26,46,4651,$a([120,216,320,384]),$a([3,1,4,5,11,5,11,5])]),$a(["full","15",$ctx.v10to26,77,77,26,48,5243,$a([132,240,360,432]),$a([5,1,5,5,5,7,11,7])]),$a(["full","16",$ctx.v10to26,81,81,26,50,5867,$a([144,280,408,480]),$a([5,1,7,3,15,2,3,13])]),$a(["full","17",$ctx.v10to26,85,85,30,54,6523,$a([168,308,448,532]),$a([1,5,10,1,1,15,2,17])]),$a(["full","18",$ctx.v10to26,89,89,30,56,7211,$a([180,338,504,588]),$a([5,1,9,4,17,1,2,19])]),$a(["full","19",$ctx.v10to26,93,93,30,58,7931,$a([196,364,546,650]),$a([3,4,3,11,17,4,9,16])]),$a(["full","20",$ctx.v10to26,97,97,34,62,8683,$a([224,416,600,700]),$a([3,5,3,13,15,5,15,10])]),$a(["full","21",$ctx.v10to26,101,101,28,50,9252,$a([224,442,644,750]),$a([4,4,17,0,17,6,19,6])]),$a(["full","22",$ctx.v10to26,105,105,26,50,10068,$a([252,476,690,816]),$a([2,7,17,0,7,16,34,0])]),$a(["full","23",$ctx.v10to26,109,109,30,54,10916,$a([270,504,750,900]),$a([4,5,4,14,11,14,16,14])]),$a(["full","24",$ctx.v10to26,113,113,28,54,11796,$a([300,560,810,960]),$a([6,4,6,14,11,16,30,2])]),$a(["full","25",$ctx.v10to26,117,117,32,58,12708,$a([312,588,870,1050]),$a([8,4,8,13,7,22,22,13])]),$a(["full","26",$ctx.v10to26,121,121,30,58,13652,$a([336,644,952,1110]),$a([10,2,19,4,28,6,33,4])]),$a(["full","27",$ctx.v27to40,125,125,34,62,14628,$a([360,700,1020,1200]),$a([8,4,22,3,8,26,12,28])]),$a(["full","28",$ctx.v27to40,129,129,26,50,15371,$a([390,728,1050,1260]),$a([3,10,3,23,4,31,11,31])]),$a(["full","29",$ctx.v27to40,133,133,30,54,16411,$a([420,784,1140,1350]),$a([7,7,21,7,1,37,19,26])]),$a(["full","30",$ctx.v27to40,137,137,26,52,17483,$a([450,812,1200,1440]),$a([5,10,19,10,15,25,23,25])]),$a(["full","31",$ctx.v27to40,141,141,30,56,18587,$a([480,868,1290,1530]),$a([13,3,2,29,42,1,23,28])]),$a(["full","32",$ctx.v27to40,145,145,34,60,19723,$a([510,924,1350,1620]),$a([17,0,10,23,10,35,19,35])]),$a(["full","33",$ctx.v27to40,149,149,30,58,20891,$a([540,980,1440,1710]),$a([17,1,14,21,29,19,11,46])]),$a(["full","34",$ctx.v27to40,153,153,34,62,22091,$a([570,1036,1530,1800]),$a([13,6,14,23,44,7,59,1])]),$a(["full","35",$ctx.v27to40,157,157,30,54,23008,$a([570,1064,1590,1890]),$a([12,7,12,26,39,14,22,41])]),$a(["full","36",$ctx.v27to40,161,161,24,50,24272,$a([600,1120,1680,1980]),$a([6,14,6,34,46,10,2,64])]),$a(["full","37",$ctx.v27to40,165,165,28,54,25568,$a([630,1204,1770,2100]),$a([17,4,29,14,49,10,24,46])]),$a(["full","38",$ctx.v27to40,169,169,32,58,26896,$a([660,1260,1860,2220]),$a([4,18,13,32,48,14,42,32])]),$a(["full","39",$ctx.v27to40,173,173,26,54,28256,$a([720,1316,1950,2310]),$a([20,4,40,7,43,22,10,67])]),$a(["full","40",$ctx.v27to40,177,177,30,58,29648,$a([750,1372,2040,2430]),$a([19,6,18,31,34,34,20,61])]),$a(["rmqr","R7x43",$ctx.vR7x43,7,43,22,99,104,$a([99,7,99,10]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x59",$ctx.vR7x59,7,59,20,40,171,$a([99,9,99,14]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x77",$ctx.vR7x77,7,77,26,52,261,$a([99,12,99,22]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x99",$ctx.vR7x99,7,99,24,50,358,$a([99,16,99,30]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x139",$ctx.vR7x139,7,139,28,56,545,$a([99,24,99,44]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R9x43",$ctx.vR9x43,9,43,22,99,170,$a([99,9,99,14]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R9x59",$ctx.vR9x59,9,59,20,40,267,$a([99,12,99,22]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R9x77",$ctx.vR9x77,9,77,26,52,393,$a([99,18,99,32]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R9x99",$ctx.vR9x99,9,99,24,50,532,$a([99,24,99,44]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R9x139",$ctx.vR9x139,9,139,28,56,797,$a([99,36,99,66]),$a([-1,-1,1,1,-1,-1,3,0])]),$a(["rmqr","R11x27",$ctx.vR11x27,11,27,98,99,122,$a([99,8,99,10]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R11x43",$ctx.vR11x43,11,43,22,99,249,$a([99,12,99,20]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R11x59",$ctx.vR11x59,11,59,20,40,376,$a([99,16,99,32]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R11x77",$ctx.vR11x77,11,77,26,52,538,$a([99,24,99,44]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R11x99",$ctx.vR11x99,11,99,24,50,719,$a([99,32,99,60]),$a([-1,-1,1,1,-1,-1,1,1])]),$a(["rmqr","R11x139",$ctx.vR11x139,11,139,28,56,1062,$a([99,48,99,90]),$a([-1,-1,2,0,-1,-1,3,0])]),$a(["rmqr","R13x27",$ctx.vR13x27,13,27,98,99,172,$a([99,9,99,14]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R13x43",$ctx.vR13x43,13,43,22,99,329,$a([99,14,99,28]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R13x59",$ctx.vR13x59,13,59,20,40,486,$a([99,22,99,40]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R13x77",$ctx.vR13x77,13,77,26,52,684,$a([99,32,99,56]),$a([-1,-1,1,1,-1,-1,1,1])]),$a(["rmqr","R13x99",$ctx.vR13x99,13,99,24,50,907,$a([99,40,99,78]),$a([-1,-1,1,1,-1,-1,1,2])]),$a(["rmqr","R13x139",$ctx.vR13x139,13,139,28,56,1328,$a([99,60,99,112]),$a([-1,-1,2,1,-1,-1,2,2])]),$a(["rmqr","R15x43",$ctx.vR15x43,15,43,22,99,409,$a([99,18,99,36]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R15x59",$ctx.vR15x59,15,59,20,40,596,$a([99,26,99,48]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R15x77",$ctx.vR15x77,15,77,26,52,830,$a([99,36,99,72]),$a([-1,-1,1,1,-1,-1,2,1])]),$a(["rmqr","R15x99",$ctx.vR15x99,15,99,24,50,1095,$a([99,48,99,88]),$a([-1,-1,2,0,-1,-1,4,0])]),$a(["rmqr","R15x139",$ctx.vR15x139,15,139,28,56,1594,$a([99,72,99,130]),$a([-1,-1,2,1,-1,-1,1,4])]),$a(["rmqr","R17x43",$ctx.vR17x43,17,43,22,99,489,$a([99,22,99,40]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R17x59",$ctx.vR17x59,17,59,20,40,706,$a([99,32,99,60]),$a([-1,-1,2,0,-1,-1,2,0])]),$a(["rmqr","R17x77",$ctx.vR17x77,17,77,26,52,976,$a([99,44,99,84]),$a([-1,-1,2,0,-1,-1,1,2])]),$a(["rmqr","R17x99",$ctx.vR17x99,17,99,24,50,1283,$a([99,60,99,104]),$a([-1,-1,2,1,-1,-1,4,0])]),$a(["rmqr","R17x139",$ctx.vR17x139,17,139,28,56,1860,$a([99,80,99,156]),$a([-1,-1,4,0,-1,-1,2,4])])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20173__=1})()}$k[$j++]="eclval";$X("LMQH",$1.eclevel);$j--;var _Kj=$k[--$j];var _Kk=$k[--$j];$k[$j++]=_Kj.length;$k[$j++]=_Kk;$j--;var _Kl=$k[--$j];var _Km=$k[--$j];$k[$j++]=_Kl;$k[$j++]=_Km;$j--;var _Kn=$k[--$j];$1[$k[--$j]]=_Kn;for(var _Kr=0,_Kq=$1.metrics.length-1;_Kr<=_Kq;_Kr+=1){$1.i=_Kr;$1.m=$g($1.metrics,$1.i);$1.frmt=$g($1.m,0);$1.vers=$g($1.m,1);$1.vergrp=$g($1.m,2);$1.verind=$1.i-44;$1.rows=$g($1.m,3);$1.cols=$g($1.m,4);$1.asp2=$g($1.m,5);$1.asp3=$g($1.m,6);$1.nmod=$g($1.m,7);$1.ncws=~~($1.nmod/8);$1.rbit=$1.nmod%8;$1.lc4b=false;if($eq($1.vers,"M1")||$eq($1.vers,"M3")){$1.ncws=$1.ncws+1;$1.rbit=0;$1.lc4b=true}$1.ecws=$g($g($1.m,8),$1.eclval);$1.dcws=$f($1.ncws-$1.ecws);var _LP=$1.lc4b?4:0;$1.dmod=$f($1.dcws*8-_LP);$1.ecb1=$g($g($1.m,9),$1.eclval*2);$1.ecb2=$g($g($1.m,9),$f($1.eclval*2+1));$1.okay=true;if($ne($1.format,$1.frmt)){$1.okay=false}if($eq($1.frmt,"micro")&&$1.fnc1first){$1.okay=false}if($ne($1.version,"unset")&&$ne($1.version,$1.vers)){$1.okay=false}if($1.ecb1==-1||$1.ecb2==-1){$1.okay=false}$1.verbits=$g($1.msgbits,$1.vergrp);if($1.verbits==-1){$1.okay=false}else{if($1.verbits.length>$1.dmod){$1.okay=false}}$1.term=$G("000000000",0,$g($1.termlens,$1.vergrp));if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.qrcodeNoValidSymbol#20217";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}$1.format=$1.frmt;$1.version=$1.vers;$1.msgbits=$1.verbits;$1.dcpb=~~($1.dcws/$f($1.ecb1+$1.ecb2));$1.ecpb=~~($1.ncws/$f($1.ecb1+$1.ecb2))-$1.dcpb;var _M3=$1.term;var _M4=$1.dmod;var _M5=$1.msgbits;var _M6=$1.term;var _M7=_M6.length;var _M8=$f(_M4-_M5.length);if($f(_M4-_M5.length)>_M6.length){var _=_M7;_M7=_M8;_M8=_}$1.term=$G(_M3,0,_M8);var _MC=$s($1.msgbits.length+$1.term.length);$P(_MC,0,$1.msgbits);$P(_MC,$1.msgbits.length,$1.term);$1.msgbits=_MC;$1.pad=$s($1.dmod);for(var _MK=0,_MJ=$1.pad.length-1;_MK<=_MJ;_MK+=1){$p($1.pad,_MK,48)}$P($1.pad,0,$1.msgbits);$1.padnum=0;var _MR=$1.lc4b?5:1;for(var _MT=~~(Math.ceil($1.msgbits.length/8)*8),_MS=$f($1.dmod-_MR);_MT<=_MS;_MT+=8){$P($1.pad,_MT,$g($1.padstrs,$1.padnum));$1.padnum=($1.padnum+1)%2}$1.cws=$a($1.dcws);for(var _Md=0,_Mc=$1.cws.length-1;_Md<=_Mc;_Md+=1){$1.c=_Md;$1.bpcw=8;if($1.lc4b&&$1.c==$1.cws.length-1){$1.bpcw=4}$1.cwb=$G($1.pad,$1.c*8,$1.bpcw);$1.cw=0;for(var _Mn=0,_Mm=$1.bpcw-1;_Mn<=_Mm;_Mn+=1){$1.i=_Mn;$1.cw=$f($1.cw+~~Math.pow(2,$1.bpcw-$1.i-1)*$f($g($1.cwb,$1.i)-48))}$p($1.cws,$1.c,$1.cw)}if($1.lc4b){var _My=$1.cws;var _Mz=$1.cws;$p(_My,_Mz.length-1,$g(_My,_Mz.length-1)<<4)}var _N2=$g($1.options,"debugcws")!==undefined;if(_N2){$k[$j++]="bwipp.debugcws#20261";$k[$j++]=$1.cws;bwipp_raiseerror()}if(!bwipp_qrcode.__20268__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;$k[$j++]=1;for(var _N4=0,_N5=255;_N4<_N5;_N4++){var _N6=$k[--$j];var _N7=_N6*2;$k[$j++]=_N6;$k[$j++]=_N7;if(_N7>=256){var _N8=$k[--$j];$k[$j++]=_N8^285}}$ctx.rsalog=$a();$ctx.rslog=$a(256);for(var _NB=1;_NB<=255;_NB+=1){$p($ctx.rslog,$g($ctx.rsalog,_NB),_NB)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20268__=1})()}$1.rsprod=function(){var _NG=$k[--$j];var _NH=$k[--$j];$k[$j++]=_NH;$k[$j++]=_NG;if(_NG!=0&&_NH!=0){var _NK=$g($1.rslog,$k[--$j]);var _NP=$g($1.rsalog,$f(_NK+$g($1.rslog,$k[--$j]))%255);$k[$j++]=_NP}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _NR=0,_NS=$1.ecpb;_NR<_NS;_NR++){$k[$j++]=0}$1.coeffs=$a();for(var _NW=0,_NV=$1.ecpb-1;_NW<=_NV;_NW+=1){$1.i=_NW;$p($1.coeffs,$1.i+1,$g($1.coeffs,$1.i));for(var _Nd=$1.i;_Nd>=1;_Nd-=1){$1.j=_Nd;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Np=$k[--$j];var _Nq=$k[--$j];var _Nr=$k[--$j];$p($k[--$j],_Nr,$xo(_Nq,_Np))}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Nz=$k[--$j];var _O0=$k[--$j];$p($k[--$j],_O0,_Nz)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);$1.rscodes=function(){$1.rscws=$k[--$j];$1.rsnd=$1.rscws.length;$k[$j++]=Infinity;$F($1.rscws);for(var _O9=0,_OA=$1.ecpb;_O9<_OA;_O9++){$k[$j++]=0}$1.rscws=$a();for(var _OE=0,_OD=$1.rsnd-1;_OE<=_OD;_OE+=1){$1.m=_OE;$1.k=$g($1.rscws,$1.m);for(var _OK=0,_OJ=$1.ecpb-1;_OK<=_OJ;_OK+=1){$1.j=_OK;$k[$j++]=$1.rscws;$k[$j++]=$1.m+$1.j+1;$k[$j++]=$g($1.coeffs,$1.ecpb-$1.j-1);$k[$j++]=$1.k;$1.rsprod();var _OX=$k[--$j];var _OY=$k[--$j];$p($k[--$j],_OY,$xo(_OX,$g($1.rscws,$1.m+$1.j+1)))}}$k[$j++]=$G($1.rscws,$1.rsnd,$1.ecpb)};$1.dcwsb=$a($f($1.ecb1+$1.ecb2));$1.ecwsb=$a($f($1.ecb1+$1.ecb2));for(var _Om=0,_Ol=$f($1.ecb1-1);_Om<=_Ol;_Om+=1){$1.i=_Om;$p($1.dcwsb,$1.i,$G($1.cws,$1.i*$1.dcpb,$1.dcpb));$k[$j++]=$1.ecwsb;$k[$j++]=$1.i;$k[$j++]=$g($1.dcwsb,$1.i);$1.rscodes();var _Oz=$k[--$j];var _P0=$k[--$j];$p($k[--$j],_P0,_Oz)}for(var _P4=0,_P3=$f($1.ecb2-1);_P4<=_P3;_P4+=1){$1.i=_P4;$p($1.dcwsb,$f($1.ecb1+$1.i),$G($1.cws,$f($1.ecb1*$1.dcpb+$1.i*($1.dcpb+1)),$1.dcpb+1));$k[$j++]=$1.ecwsb;$k[$j++]=$f($1.ecb1+$1.i);$k[$j++]=$g($1.dcwsb,$f($1.ecb1+$1.i));$1.rscodes();var _PM=$k[--$j];var _PN=$k[--$j];$p($k[--$j],_PN,_PM)}$1.cws=$a($1.ncws);$1.cw=0;for(var _PT=0,_PS=$1.dcpb;_PT<=_PS;_PT+=1){$1.i=_PT;for(var _PX=0,_PW=$f($f($1.ecb1+$1.ecb2)-1);_PX<=_PW;_PX+=1){$1.j=_PX;if($1.i<$g($1.dcwsb,$1.j).length){$p($1.cws,$1.cw,$g($g($1.dcwsb,$1.j),$1.i));$1.cw=$1.cw+1}}}for(var _Pm=0,_Pl=$1.ecpb-1;_Pm<=_Pl;_Pm+=1){$1.i=_Pm;for(var _Pq=0,_Pp=$f($f($1.ecb1+$1.ecb2)-1);_Pq<=_Pp;_Pq+=1){$1.j=_Pq;$p($1.cws,$1.cw,$g($g($1.ecwsb,$1.j),$1.i));$1.cw=$1.cw+1}}if($1.rbit>0){$1.pad=$a($1.cws.length+1);$P($1.pad,0,$1.cws);$p($1.pad,$1.pad.length-1,0);$1.cws=$1.pad}if($1.lc4b){var _Q8=$1.cws;var _Q9=$1.dcws;$p(_Q8,$f(_Q9-1),$g(_Q8,$f(_Q9-1))>>>4);for(var _QE=$f($1.dcws-1),_QD=$1.ncws-2;_QE<=_QD;_QE+=1){$1.i=_QE;$p($1.cws,$1.i,($g($1.cws,$1.i)&15)<<4);$p($1.cws,$1.i,$g($1.cws,$1.i+1)>>>4&15|$g($1.cws,$1.i))}$p($1.cws,$1.ncws-1,($g($1.cws,$1.ncws-1)&15)<<4)}var _QY=$g($1.options,"debugecc")!==undefined;if(_QY){$k[$j++]="bwipp.debugecc#20363";$k[$j++]=$1.cws;bwipp_raiseerror()}$k[$j++]=Infinity;for(var _Qc=0,_Qd=$1.rows*$1.cols;_Qc<_Qd;_Qc++){$k[$j++]=-1}$1.pixs=$a();$1.qmv=function(){var _Qg=$k[--$j];var _Qh=$k[--$j];$k[$j++]=$f(_Qh+_Qg*$1.cols)};if($eq($1.format,"full")){for(var _Ql=8,_Qk=$f($1.cols-9);_Ql<=_Qk;_Ql+=1){$1.i=_Ql;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=6;$1.qmv();var _Qp=$k[--$j];$p($k[--$j],_Qp,($1.i+1)%2);$k[$j++]=$1.pixs;$k[$j++]=6;$k[$j++]=$1.i;$1.qmv();var _Qu=$k[--$j];$p($k[--$j],_Qu,($1.i+1)%2)}}if($eq($1.format,"micro")){for(var _Qz=8,_Qy=$f($1.cols-1);_Qz<=_Qy;_Qz+=1){$1.i=_Qz;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=0;$1.qmv();var _R3=$k[--$j];$p($k[--$j],_R3,($1.i+1)%2);$k[$j++]=$1.pixs;$k[$j++]=0;$k[$j++]=$1.i;$1.qmv();var _R8=$k[--$j];$p($k[--$j],_R8,($1.i+1)%2)}}if($eq($1.format,"rmqr")){for(var _RD=3,_RC=$f($1.cols-4);_RD<=_RC;_RD+=1){$1.i=_RD;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=0;$1.qmv();var _RH=$k[--$j];$p($k[--$j],_RH,($1.i+1)%2);$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$f($1.rows-1);$1.qmv();var _RN=$k[--$j];$p($k[--$j],_RN,($1.i+1)%2)}for(var _RR=3,_RQ=$f($1.rows-4);_RR<=_RQ;_RR+=1){$1.i=_RR;$k[$j++]=$1.pixs;$k[$j++]=0;$k[$j++]=$1.i;$1.qmv();var _RV=$k[--$j];$p($k[--$j],_RV,($1.i+1)%2);$k[$j++]=$1.pixs;$k[$j++]=$f($1.cols-1);$k[$j++]=$1.i;$1.qmv();var _Rb=$k[--$j];$p($k[--$j],_Rb,($1.i+1)%2)}for(var _Ri=$f($1.asp2-1),_Rj=$f($1.asp3-$1.asp2),_Rh=$f($1.cols-13);_Rj<0?_Ri>=_Rh:_Ri<=_Rh;_Ri+=_Rj){$1.i=_Ri;for(var _Rm=3,_Rl=$f($1.rows-4);_Rm<=_Rl;_Rm+=1){$1.j=_Rm;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.qmv();var _Rr=$k[--$j];$p($k[--$j],_Rr,($1.j+1)%2)}}}if(!bwipp_qrcode.__20452__){(function(){var $ctx=Object.create($1);$ctx.fpat=$a([$a([1,1,1,1,1,1,1,0]),$a([1,0,0,0,0,0,1,0]),$a([1,0,1,1,1,0,1,0]),$a([1,0,1,1,1,0,1,0]),$a([1,0,1,1,1,0,1,0]),$a([1,0,0,0,0,0,1,0]),$a([1,1,1,1,1,1,1,0]),$a([0,0,0,0,0,0,0,0])]);$ctx.fsubpat=$a([$a([1,1,1,1,1,9,9,9]),$a([1,0,0,0,1,9,9,9]),$a([1,0,1,0,1,9,9,9]),$a([1,0,0,0,1,9,9,9]),$a([1,1,1,1,1,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9])]);$ctx.fcorpat=$a([$a([1,1,1,9,9,9,9,9]),$a([1,0,9,9,9,9,9,9]),$a([1,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9])]);$ctx.fnullpat=$a([$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9])]);var _Si=new Map([["full",$a([$ctx.fpat,$ctx.fpat,$ctx.fpat,$ctx.fnullpat])],["micro",$a([$ctx.fpat,$ctx.fnullpat,$ctx.fnullpat,$ctx.fnullpat])],["rmqr",$a([$ctx.fpat,$ctx.fcorpat,$ctx.fcorpat,$ctx.fsubpat])]]);$ctx.fpatmap=_Si;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20452__=1})()}$1.fpats=$g($1.fpatmap,$1.format);for(var _Sn=0;_Sn<=7;_Sn+=1){$1.y=_Sn;for(var _So=0;_So<=7;_So+=1){$1.x=_So;$1.fpb0=$g($g($g($1.fpats,0),$1.y),$1.x);$1.fpb1=$g($g($g($1.fpats,1),$1.y),$1.x);$1.fpb2=$g($g($g($1.fpats,2),$1.y),$1.x);$1.fpb3=$g($g($g($1.fpats,3),$1.y),$1.x);if($1.fpb0!=9&&$1.y<$1.rows){$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.qmv();var _TK=$k[--$j];$p($k[--$j],_TK,$1.fpb0)}if($1.fpb1!=9){$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.cols-$1.x)-1);$k[$j++]=$1.y;$1.qmv();var _TS=$k[--$j];$p($k[--$j],_TS,$1.fpb1)}if($1.fpb2!=9){$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$f($f($1.rows-$1.y)-1);$1.qmv();var _Ta=$k[--$j];$p($k[--$j],_Ta,$1.fpb2)}if($1.fpb3!=9){$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.cols-$1.x)-1);$k[$j++]=$f($f($1.rows-$1.y)-1);$1.qmv();var _Tj=$k[--$j];$p($k[--$j],_Tj,$1.fpb3)}}}if(!bwipp_qrcode.__20485__){(function(){var $ctx=Object.create($1);$ctx.algnpatfull=$a([$a([1,1,1,1,1]),$a([1,0,0,0,1]),$a([1,0,1,0,1]),$a([1,0,0,0,1]),$a([1,1,1,1,1])]);$ctx.algnpatrmqr=$a([$a([1,1,1,9,9]),$a([1,0,1,9,9]),$a([1,1,1,9,9]),$a([9,9,9,9,9]),$a([9,9,9,9,9])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20485__=1})()}$1.putalgnpat=function(){$1.py=$k[--$j];$1.px=$k[--$j];for(var _U0=0;_U0<=4;_U0+=1){$1.pb=_U0;for(var _U1=0;_U1<=4;_U1+=1){$1.pa=_U1;$1.algnb=$g($g($1.algnpat,$1.pb),$1.pa);if($1.algnb!=9){$k[$j++]=$1.pixs;$k[$j++]=$f($1.px+$1.pa);$k[$j++]=$f($1.py+$1.pb);$1.qmv();var _UE=$k[--$j];$p($k[--$j],_UE,$1.algnb)}}}};if($eq($1.format,"full")){$1.algnpat=$1.algnpatfull;for(var _UN=$f($1.asp2-2),_UO=$f($1.asp3-$1.asp2),_UM=$f($1.cols-13);_UO<0?_UN>=_UM:_UN<=_UM;_UN+=_UO){$1.i=_UN;$k[$j++]=$1.i;$k[$j++]=4;$1.putalgnpat();$k[$j++]=4;$k[$j++]=$1.i;$1.putalgnpat()}for(var _UW=$f($1.asp2-2),_UX=$f($1.asp3-$1.asp2),_UV=$f($1.cols-9);_UX<0?_UW>=_UV:_UW<=_UV;_UW+=_UX){$1.x=_UW;for(var _Ud=$f($1.asp2-2),_Ue=$f($1.asp3-$1.asp2),_Uc=$f($1.rows-9);_Ue<0?_Ud>=_Uc:_Ud<=_Uc;_Ud+=_Ue){$1.y=_Ud;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.putalgnpat()}}}if($eq($1.format,"rmqr")){$1.algnpat=$1.algnpatrmqr;for(var _Uo=$f($1.asp2-2),_Up=$f($1.asp3-$1.asp2),_Un=$f($1.cols-13);_Up<0?_Uo>=_Un:_Uo<=_Un;_Uo+=_Up){$1.i=_Uo;$k[$j++]=$1.i;$k[$j++]=0;$1.putalgnpat();$k[$j++]=$1.i;$k[$j++]=$f($1.rows-3);$1.putalgnpat()}}if(!bwipp_qrcode.__20532__){(function(){var $ctx=Object.create($1);$ctx.formatmapmicro=$a([$a([$a([1,8])]),$a([$a([2,8])]),$a([$a([3,8])]),$a([$a([4,8])]),$a([$a([5,8])]),$a([$a([6,8])]),$a([$a([7,8])]),$a([$a([8,8])]),$a([$a([8,7])]),$a([$a([8,6])]),$a([$a([8,5])]),$a([$a([8,4])]),$a([$a([8,3])]),$a([$a([8,2])]),$a([$a([8,1])])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20532__=1})()}var _Xs=new Map([["full",$a([$a([$a([0,8]),$a([8,$f($1.cols-1)])]),$a([$a([1,8]),$a([8,$f($1.cols-2)])]),$a([$a([2,8]),$a([8,$f($1.cols-3)])]),$a([$a([3,8]),$a([8,$f($1.cols-4)])]),$a([$a([4,8]),$a([8,$f($1.cols-5)])]),$a([$a([5,8]),$a([8,$f($1.cols-6)])]),$a([$a([7,8]),$a([8,$f($1.cols-7)])]),$a([$a([8,8]),$a([$f($1.cols-8),8])]),$a([$a([8,7]),$a([$f($1.cols-7),8])]),$a([$a([8,5]),$a([$f($1.cols-6),8])]),$a([$a([8,4]),$a([$f($1.cols-5),8])]),$a([$a([8,3]),$a([$f($1.cols-4),8])]),$a([$a([8,2]),$a([$f($1.cols-3),8])]),$a([$a([8,1]),$a([$f($1.cols-2),8])]),$a([$a([8,0]),$a([$f($1.cols-1),8])])])],["micro",$1.formatmapmicro],["rmqr",$a([$a([$a([11,3]),$a([$f($1.cols-3),$f($1.rows-6)])]),$a([$a([11,2]),$a([$f($1.cols-4),$f($1.rows-6)])]),$a([$a([11,1]),$a([$f($1.cols-5),$f($1.rows-6)])]),$a([$a([10,5]),$a([$f($1.cols-6),$f($1.rows-2)])]),$a([$a([10,4]),$a([$f($1.cols-6),$f($1.rows-3)])]),$a([$a([10,3]),$a([$f($1.cols-6),$f($1.rows-4)])]),$a([$a([10,2]),$a([$f($1.cols-6),$f($1.rows-5)])]),$a([$a([10,1]),$a([$f($1.cols-6),$f($1.rows-6)])]),$a([$a([9,5]),$a([$f($1.cols-7),$f($1.rows-2)])]),$a([$a([9,4]),$a([$f($1.cols-7),$f($1.rows-3)])]),$a([$a([9,3]),$a([$f($1.cols-7),$f($1.rows-4)])]),$a([$a([9,2]),$a([$f($1.cols-7),$f($1.rows-5)])]),$a([$a([9,1]),$a([$f($1.cols-7),$f($1.rows-6)])]),$a([$a([8,5]),$a([$f($1.cols-8),$f($1.rows-2)])]),$a([$a([8,4]),$a([$f($1.cols-8),$f($1.rows-3)])]),$a([$a([8,3]),$a([$f($1.cols-8),$f($1.rows-4)])]),$a([$a([8,2]),$a([$f($1.cols-8),$f($1.rows-5)])]),$a([$a([8,1]),$a([$f($1.cols-8),$f($1.rows-6)])])])]]);$1.formatmap=$g(_Xs,$1.format);$F($1.formatmap,function(){$F($k[--$j],function(){$F($k[--$j]);$1.qmv();$p($1.pixs,$k[--$j],1)})});if($eq($1.format,"full")&&$1.cols>=45){$1.versionmap=$a([$a([$a([$f($1.cols-9),5]),$a([5,$f($1.cols-9)])]),$a([$a([$f($1.cols-10),5]),$a([5,$f($1.cols-10)])]),$a([$a([$f($1.cols-11),5]),$a([5,$f($1.cols-11)])]),$a([$a([$f($1.cols-9),4]),$a([4,$f($1.cols-9)])]),$a([$a([$f($1.cols-10),4]),$a([4,$f($1.cols-10)])]),$a([$a([$f($1.cols-11),4]),$a([4,$f($1.cols-11)])]),$a([$a([$f($1.cols-9),3]),$a([3,$f($1.cols-9)])]),$a([$a([$f($1.cols-10),3]),$a([3,$f($1.cols-10)])]),$a([$a([$f($1.cols-11),3]),$a([3,$f($1.cols-11)])]),$a([$a([$f($1.cols-9),2]),$a([2,$f($1.cols-9)])]),$a([$a([$f($1.cols-10),2]),$a([2,$f($1.cols-10)])]),$a([$a([$f($1.cols-11),2]),$a([2,$f($1.cols-11)])]),$a([$a([$f($1.cols-9),1]),$a([1,$f($1.cols-9)])]),$a([$a([$f($1.cols-10),1]),$a([1,$f($1.cols-10)])]),$a([$a([$f($1.cols-11),1]),$a([1,$f($1.cols-11)])]),$a([$a([$f($1.cols-9),0]),$a([0,$f($1.cols-9)])]),$a([$a([$f($1.cols-10),0]),$a([0,$f($1.cols-10)])]),$a([$a([$f($1.cols-11),0]),$a([0,$f($1.cols-11)])])])}else{$1.versionmap=$a([])}var _ZW=$1.versionmap;for(var _ZX=0,_ZY=_ZW.length;_ZX<_ZY;_ZX++){$F($g(_ZW,_ZX),function(){$F($k[--$j]);$1.qmv();$p($1.pixs,$k[--$j],0)})}if($eq($1.format,"full")){$k[$j++]=$1.pixs;$k[$j++]=8;$k[$j++]=$f($1.rows-8);$1.qmv();var _Zg=$k[--$j];$p($k[--$j],_Zg,0)}var _a0=$a([function(){var _Zi=$k[--$j];var _Zj=$k[--$j];$k[$j++]=$f(_Zj+_Zi)%2},function(){var _Zk=$k[--$j];var _Zl=$k[--$j];$k[$j++]=_Zk;$k[$j++]=_Zl;$j--;var _Zm=$k[--$j];$k[$j++]=_Zm%2},function(){$j--;var _Zn=$k[--$j];$k[$j++]=_Zn%3},function(){var _Zo=$k[--$j];var _Zp=$k[--$j];$k[$j++]=$f(_Zp+_Zo)%3},function(){var _Zq=$k[--$j];var _Zr=$k[--$j];$k[$j++]=(~~(_Zq/2)+~~(_Zr/3))%2},function(){var _Zs=$k[--$j];var _Zu=$k[--$j]*_Zs;$k[$j++]=$f(_Zu%2+_Zu%3)},function(){var _Zv=$k[--$j];var _Zx=$k[--$j]*_Zv;$k[$j++]=$f(_Zx%2+_Zx%3)%2},function(){var _Zy=$k[--$j];var _Zz=$k[--$j];$k[$j++]=$f(_Zz*_Zy%3+$f(_Zz+_Zy)%2)%2}]);var _aB=$a([function(){var _a1=$k[--$j];var _a2=$k[--$j];$k[$j++]=_a1;$k[$j++]=_a2;$j--;var _a3=$k[--$j];$k[$j++]=_a3%2},function(){var _a4=$k[--$j];var _a5=$k[--$j];$k[$j++]=(~~(_a4/2)+~~(_a5/3))%2},function(){var _a6=$k[--$j];var _a8=$k[--$j]*_a6;$k[$j++]=$f(_a8%2+_a8%3)%2},function(){var _a9=$k[--$j];var _aA=$k[--$j];$k[$j++]=$f(_aA*_a9%3+$f(_aA+_a9)%2)%2}]);var _aE=$a([function(){var _aC=$k[--$j];var _aD=$k[--$j];$k[$j++]=(~~(_aC/2)+~~(_aD/3))%2}]);var _aF=new Map([["full",_a0],["micro",_aB],["rmqr",_aE]]);$1.maskfuncs=$g(_aF,$1.format);if($1.mask!=-1){$1.maskfuncs=$a([$g($1.maskfuncs,$1.mask-1)]);$1.bestmaskval=$1.mask-1}$1.masks=$a($1.maskfuncs.length);for(var _aS=0,_aR=$1.masks.length-1;_aS<=_aR;_aS+=1){$1.m=_aS;$1.mask=$a($1.rows*$1.cols);for(var _aY=0,_aX=$f($1.rows-1);_aY<=_aX;_aY+=1){$1.j=_aY;for(var _ab=0,_aa=$f($1.cols-1);_ab<=_aa;_ab+=1){$1.i=_ab;$k[$j++]=$1.i;$k[$j++]=$1.j;if($g($1.maskfuncs,$1.m)()===true){break}var _ah=$k[--$j];$k[$j++]=_ah==0;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.qmv();var _al=$k[--$j];var _an=$g($k[--$j],_al);var _ao=$k[--$j];var _ap=_ao&&_an==-1?1:0;$k[$j++]=_ap;$k[$j++]=$1.mask;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.qmv();var _at=$k[--$j];var _au=$k[--$j];$p(_au,_at,$k[--$j])}}$p($1.masks,$1.m,$1.mask)}var _b1=$ne($1.format,"rmqr")?1:2;$1.posx=$f($1.cols-_b1);$1.posy=$f($1.rows-1);$1.dir=-1;$1.col=1;$1.num=0;for(;;){if($1.posx<0){break}$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.qmv();var _b7=$k[--$j];if($g($k[--$j],_b7)==-1){var _bC=$g($1.cws,~~($1.num/8));var _bE=-(7-$1.num%8);$k[$j++]=(_bE<0?_bC>>>-_bE:_bC<<_bE)&1;$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.qmv();var _bI=$k[--$j];var _bJ=$k[--$j];$p(_bJ,_bI,$k[--$j]);$1.num=$1.num+1}if($1.col==1){$1.col=0;$1.posx=$f($1.posx-1)}else{$1.col=1;$1.posx=$f($1.posx+1);$1.posy=$f($1.posy+$1.dir);if($1.posy<0||$1.posy>=$1.rows){$1.dir=$1.dir*-1;$1.posy=$f($1.posy+$1.dir);$1.posx=$f($1.posx-2);if($eq($1.format,"full")&&$1.posx==6){$1.posx=$f($1.posx-1)}}}}$1.evalfulln1n3=function(){$1.scrle=$k[--$j];$k[$j++]="scr1";$k[$j++]=0;$F($1.scrle,function(){var _bd=$k[--$j];$k[$j++]=_bd;if(_bd>=5){var _be=$k[--$j];var _bg=$f($f($k[--$j]+_be)-2);$k[$j++]=_bg;$k[$j++]=_bg}$j--});var _bh=$k[--$j];$1[$k[--$j]]=_bh;$1.scr3=0;for(var _bl=3,_bk=$1.scrle.length-3;_bl<=_bk;_bl+=2){$1.j=_bl;if($g($1.scrle,$1.j)%3==0){$1.fact=~~($g($1.scrle,$1.j)/3);var _bu=$G($1.scrle,$1.j-2,5);for(var _bv=0,_bw=_bu.length;_bv<_bw;_bv++){$k[$j++]=$g(_bu,_bv)==$1.fact}var _bz=$k[--$j];var _c0=$k[--$j];var _c1=$k[--$j];$k[$j++]=$an(_c0,_bz);$k[$j++]=_c1;$j--;var _c2=$k[--$j];var _c3=$k[--$j];var _c4=$k[--$j];if(_c4&&(_c3&&_c2)){if($1.j==3||$1.j+4>=$1.scrle.length){$1.scr3=$1.scr3+40}else{if($g($1.scrle,$1.j-3)>=4||$g($1.scrle,$1.j+3)>=4){$1.scr3=$1.scr3+40}}}}}$k[$j++]=$1.scr1;$k[$j++]=$1.scr3};$1.evalfull=function(){$1.sym=$k[--$j];$1.n1=0;$1.n2=0;$1.n3=0;$1.rle=$a($f($1.cols+1));$1.lastpairs=$a($1.cols);$1.thispairs=$a($1.cols);$1.colsadd1=$f($1.cols+1);for(var _cS=0,_cR=$f($1.cols-1);_cS<=_cR;_cS+=1){$1.i=_cS;$k[$j++]=Infinity;var _cU=$1.cols;$k[$j++]=0;$k[$j++]=0;for(var _cW=$1.i,_cX=_cU,_cV=$f(_cU*_cU-1);_cX<0?_cW>=_cV:_cW<=_cV;_cW+=_cX){var _cZ=$g($1.sym,_cW);var _ca=$k[--$j];$k[$j++]=_cZ;if($eq(_ca,_cZ)){var _cb=$k[--$j];var _cc=$k[--$j];$k[$j++]=$f(_cc+1);$k[$j++]=_cb}else{var _cd=$k[--$j];$k[$j++]=1;$k[$j++]=_cd}}$j--;var _cf=$m()+2;$as($G($1.rle,0,_cf-2));$1.evalfulln1n3();$1.n3=$f($k[--$j]+$1.n3);$1.n1=$f($k[--$j]+$1.n1);$j--;$1.symrow=$G($1.sym,$1.i*$1.cols,$1.cols);$k[$j++]=Infinity;var _cq=$1.symrow;$k[$j++]=0;$k[$j++]=0;for(var _cr=0,_cs=_cq.length;_cr<_cs;_cr++){var _ct=$g(_cq,_cr);var _cu=$k[--$j];$k[$j++]=_ct;if($eq(_cu,_ct)){var _cv=$k[--$j];var _cw=$k[--$j];$k[$j++]=$f(_cw+1);$k[$j++]=_cv}else{var _cx=$k[--$j];$k[$j++]=1;$k[$j++]=_cx}}$j--;var _cz=$m()+2;$as($G($1.rle,0,_cz-2));$1.evalfulln1n3();$1.n3=$f($k[--$j]+$1.n3);$1.n1=$f($k[--$j]+$1.n1);$j--;var _d5=$1.thispairs;$1.thispairs=$1.lastpairs;$1.lastpairs=_d5;var _d9=$g($1.symrow,0)==1?0:1;var _dA=$1.symrow;$k[$j++]=_d9;for(var _dB=0,_dC=_dA.length;_dB<_dC;_dB++){var _dD=$g(_dA,_dB);var _dE=$k[--$j];$k[$j++]=$f(_dE+_dD);$k[$j++]=_dD}$j--;$as($1.thispairs);$j--;if($1.i>0){$k[$j++]=Infinity;$q($1.lastpairs);$q($1.thispairs);$k[$j++]=$1.n2;for(var _dL=0,_dM=$1.cols;_dL<_dM;_dL++){var _dN=$k[--$j];var _dO=$k[--$j];$k[$j++]=_dN;$k[$j++]=_dO;var _dQ=$k[$j-1-$1.colsadd1];if(($f($k[--$j]+_dQ)&3)==0){var _dS=$k[--$j];$k[$j++]=$f(_dS+3)}}$1.n2=$k[--$j];$l()}}$k[$j++]="dark";$k[$j++]=0;$F($1.sym,function(){var _dV=$k[--$j];var _dW=$k[--$j];$k[$j++]=$f(_dW+_dV)});var _dX=$k[--$j];$1[$k[--$j]]=_dX;var _da=$1.cols;$1.n4=~~(Math.abs($f($1.dark*100/(_da*_da)-50))/5)*10;$k[$j++]=$f($f($f($1.n1+$1.n2)+$1.n3)+$1.n4)};$1.evalmicro=function(){$1.sym=$k[--$j];$1.dkrhs=0;$1.dkbot=0;for(var _di=1,_dh=$f($1.cols-1);_di<=_dh;_di+=1){$1.i=_di;$k[$j++]="dkrhs";$k[$j++]=$1.dkrhs;$k[$j++]=$1.sym;$k[$j++]=$f($1.cols-1);$k[$j++]=$1.i;$1.qmv();var _dn=$k[--$j];var _dp=$g($k[--$j],_dn);var _dq=$k[--$j];$1[$k[--$j]]=$f(_dq+_dp);$k[$j++]="dkbot";$k[$j++]=$1.dkbot;$k[$j++]=$1.sym;$k[$j++]=$1.i;$k[$j++]=$f($1.cols-1);$1.qmv();var _dw=$k[--$j];var _dy=$g($k[--$j],_dw);var _dz=$k[--$j];$1[$k[--$j]]=$f(_dz+_dy)}if($1.dkrhs<=$1.dkbot){$k[$j++]=-($1.dkrhs*16+$1.dkbot)}else{$k[$j++]=-($1.dkbot*16+$1.dkrhs)}};$1.bestscore=999999999;for(var _e9=0,_e8=$1.masks.length-1;_e9<=_e8;_e9+=1){$1.m=_e9;$1.masksym=$a($1.rows*$1.cols);for(var _eG=0,_eF=$f($1.rows*$1.cols-1);_eG<=_eF;_eG+=1){$1.i=_eG;$p($1.masksym,$1.i,$xo($g($1.pixs,$1.i),$g($g($1.masks,$1.m),$1.i)))}if($1.masks.length!=1){if($eq($1.format,"full")){$k[$j++]=$1.masksym;$1.evalfull();$1.score=$k[--$j]}else{$k[$j++]=$1.masksym;$1.evalmicro();$1.score=$k[--$j]}if($1.score<$1.bestscore){$1.bestsym=$1.masksym;$1.bestmaskval=$1.m;$1.bestscore=$1.score}}else{$1.bestsym=$1.masksym}}$1.pixs=$1.bestsym;if($eq($1.format,"full")){$k[$j++]=$1.pixs;$k[$j++]=8;$k[$j++]=$f($1.cols-8);$1.qmv();var _eh=$k[--$j];$p($k[--$j],_eh,1)}if(!bwipp_qrcode.__20814__){(function(){var $ctx=Object.create($1);$ctx.fmtvalsfull=$a([21522,20773,24188,23371,17913,16590,20375,19104,30660,29427,32170,30877,26159,25368,27713,26998,5769,5054,7399,6608,1890,597,3340,2107,13663,12392,16177,14854,9396,8579,11994,11245]);$ctx.fmtvalsmicro=$a([17477,16754,20011,19228,21934,20633,24512,23287,26515,25252,28157,26826,30328,29519,31766,31009,1758,1001,3248,2439,5941,4610,7515,6252,9480,8255,12134,10833,13539,12756,16013,15290]);$ctx.fmtvalsrmqr1=$a([129714,124311,121821,115960,112748,108361,104707,99878,98062,90155,89697,82244,81360,74485,72895,66458,61898,61167,53413,53120,45844,44081,37499,36190,29814,27475,21785,19004,13992,10637,6087,2274,258919,257090,250376,249133,242105,241308,233686,233459,227035,223742,219060,215185,209925,207648,202090,199247,194591,190266,186736,181845,178881,173540,170926,165003,163235,156294,154828,148457,147325,139352,138770,131383]);$ctx.fmtvalsrmqr2=$a([133755,136542,142100,144433,149669,153472,158154,161519,167879,168162,175784,176525,183577,184892,191606,193363,196867,204326,204908,212809,213981,220408,221874,228759,230591,236442,239056,244469,247393,252228,255758,260139,942,7307,8897,15844,16752,24149,24607,32570,34322,39223,42877,47192,50380,56297,58787,64134,67798,71667,76217,79516,84488,87341,93031,95298,101738,102991,109573,111392,118708,118929,126683,127486]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20814__=1})()}if($eq($1.format,"full")){$k[$j++]="ecid";$X("MLHQ",$1.eclevel);$j--;var _eq=$k[--$j];var _er=$k[--$j];$k[$j++]=_eq.length;$k[$j++]=_er;$j--;var _es=$k[--$j];var _et=$k[--$j];$k[$j++]=_es;$k[$j++]=_et;$j--;var _eu=$k[--$j];$1[$k[--$j]]=_eu;$1.fmtval=$g($1.fmtvalsfull,($1.ecid<<3)+$1.bestmaskval);for(var _f2=0,_f1=$1.formatmap.length-1;_f2<=_f1;_f2+=1){$1.i=_f2;$F($g($1.formatmap,$1.i),function(){var _f7=$k[--$j];$k[$j++]=$1.pixs;$q(_f7);$1.qmv();var _f8=$1.fmtval;var _fA=-(14-$1.i);var _fB=$k[--$j];$p($k[--$j],_fB,(_fA<0?_f8>>>-_fA:_f8<<_fA)&1)})}}if($eq($1.format,"micro")){$1.symid=$g($g($a([$a([0]),$a([1,2]),$a([3,4]),$a([5,6,7])]),~~($f($1.cols-11)/2)),$1.eclval);$1.fmtval=$g($1.fmtvalsmicro,($1.symid<<2)+$1.bestmaskval);for(var _fT=0,_fS=$1.formatmap.length-1;_fT<=_fS;_fT+=1){$1.i=_fT;$k[$j++]=$1.pixs;$q($g($g($1.formatmap,$1.i),0));$1.qmv();var _fZ=$1.fmtval;var _fb=-(14-$1.i);var _fc=$k[--$j];$p($k[--$j],_fc,(_fb<0?_fZ>>>-_fb:_fZ<<_fb)&1)}}if($eq($1.format,"rmqr")){$k[$j++]="fmtvalu";$X("MH",$1.eclevel);$j--;var _fg=$k[--$j];var _fh=$k[--$j];$k[$j++]=_fg.length;$k[$j++]=_fh;$j--;var _fi=$k[--$j];var _fj=$k[--$j];$k[$j++]=_fi;$k[$j++]=_fj;$j--;var _fk=$k[--$j];$1[$k[--$j]]=(_fk<<5)+$1.verind;$1.fmtval1=$g($1.fmtvalsrmqr1,$1.fmtvalu);$1.fmtval2=$g($1.fmtvalsrmqr2,$1.fmtvalu);for(var _fv=0,_fu=$1.formatmap.length-1;_fv<=_fu;_fv+=1){$1.i=_fv;$k[$j++]=$1.pixs;$q($g($g($1.formatmap,$1.i),0));$1.qmv();var _g1=$1.fmtval1;var _g3=-(17-$1.i);var _g4=$k[--$j];$p($k[--$j],_g4,(_g3<0?_g1>>>-_g3:_g1<<_g3)&1);$k[$j++]=$1.pixs;$q($g($g($1.formatmap,$1.i),1));$1.qmv();var _gB=$1.fmtval2;var _gD=-(17-$1.i);var _gE=$k[--$j];$p($k[--$j],_gE,(_gD<0?_gB>>>-_gD:_gB<<_gD)&1)}}if(!bwipp_qrcode.__20853__){(function(){var $ctx=Object.create($1);$ctx.vervals=$a([31892,34236,39577,42195,48118,51042,55367,58893,63784,68472,70749,76311,79154,84390,87683,92361,96236,102084,102881,110507,110734,117786,119615,126325,127568,133589,136944,141498,145311,150283,152622,158308,161089,167017]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_qrcode.$ctx[id]=$ctx[id]);bwipp_qrcode.__20853__=1})()}if($eq($1.format,"full")&&$1.cols>=45){$1.verval=$g($1.vervals,~~($f($1.cols-17)/4)-7);for(var _gP=0,_gO=$1.versionmap.length-1;_gP<=_gO;_gP+=1){$1.i=_gP;$F($g($1.versionmap,$1.i),function(){var _gU=$k[--$j];$k[$j++]=$1.pixs;$F(_gU);$1.qmv();var _gV=$1.verval;var _gX=-(17-$1.i);var _gY=$k[--$j];$p($k[--$j],_gY,(_gX<0?_gV>>>-_gX:_gV<<_gX)&1)})}}var _gg=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.cols],["pixy",$1.rows],["height",$1.rows*2/72],["width",$1.cols*2/72],["opt",$1.options]]);$k[$j++]=_gg;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_swissqrcode(){var $1=Object.create(bwipp_swissqrcode.$ctx||(bwipp_swissqrcode.$ctx={}));$1.dontdraw=false;$1.parse=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];$1[$k[--$j]]=_6;$1.barlen=$1.barcode.length;delete $1.options["parse"];if($1.barcode.length>997){$k[$j++]="bwipp.swissqrcodeBadLength#20930";$k[$j++]="Swiss QR Code input must not exceed 997 digits";bwipp_raiseerror()}$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_qrcode();var _E=$k[--$j];$1[$k[--$j]]=_E;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){$$.save();var _K=$$.currpos();$$.translate(_K.x,_K.y);var _L=72/25.4;$$.scale(_L,_L);$$.save();$$.newpath();$$.moveto(0,0);$$.lineto(46,0);$$.lineto(46,46);$$.lineto(0,46);$$.closepath();$$.moveto(19.5,19.5);$$.lineto(19.5,26.5);$$.lineto(26.5,26.5);$$.lineto(26.5,19.5);$$.closepath();$$.clip();$$.save();$$.moveto(0,0);var _O=46/$g($1.args,"pixx")/2;$$.scale(_O,_O);bwipp_renmatrix();$$.restore();$$.restore();$$.translate(19.5,19.5);var _P=7/83;$$.scale(_P,_P);$$.newpath();$$.moveto(6,6);$$.lineto(6,77);$$.lineto(77,77);$$.lineto(77,6);$$.closepath();$$.moveto(49,18);$$.lineto(49,34);$$.lineto(65,34);$$.lineto(65,49);$$.lineto(49,49);$$.lineto(49,65);$$.lineto(34,65);$$.lineto(34,49);$$.lineto(18,49);$$.lineto(18,34);$$.lineto(34,34);$$.lineto(34,18);$$.closepath();$$.setrgbcolor(0,0,0);$$.fill();$$.restore()}}function bwipp_microqrcode(){var $1=Object.create(bwipp_microqrcode.$ctx||(bwipp_microqrcode.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"format","micro");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_qrcode();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_rectangularmicroqrcode(){var $1=Object.create(bwipp_rectangularmicroqrcode.$ctx||(bwipp_rectangularmicroqrcode.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"format","rmqr");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_qrcode();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_maxicode(){var $1=Object.create(bwipp_maxicode.$ctx||(bwipp_maxicode.$ctx={}));$1.dontdraw=false;$1.mode=-1;$1.sam=-1;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.maxicodeEmptyData#21148";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($1.mode!=-1&&($1.mode<2||$1.mode>6)){$k[$j++]="bwipp.maxicodeBadMode#21152";$k[$j++]="Mode must be 2 to 6";bwipp_raiseerror()}if($1.sam!=-1){$k[$j++]=true;for(var _7=0,_8=1;_7<_8;_7++){var _9=$1.sam;if(_9<12||_9>88){$j--;$k[$j++]=false;break}var _B=$1.sam%10;if(_B<2||_B>8){$j--;$k[$j++]=false;break}if(~~($1.sam/10)>$1.sam%10){$j--;$k[$j++]=false;break}}if($nt($k[--$j])){$k[$j++]="bwipp.maxicodeBadSAM#21163";$k[$j++]='SAM must be formatted as "NM" for Nth of M symbols, from 2 to 8 symbols';bwipp_raiseerror()}}var _H=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true]]);$1.fncvals=_H;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _K=$k[--$j];$1[$k[--$j]]=_K;$1.msglen=$1.msg.length;if($1.mode==2||$1.mode==3){$1.barcode=$s($1.msglen);for(var _T=0,_S=$1.msglen-1;_T<=_S;_T+=1){$1.i=_T;if($g($1.msg,$1.i)>0){$p($1.barcode,$1.i,$g($1.msg,$1.i))}}$1.barlen=$1.barcode.length;$1.fid="";if($1.barlen>=7){if($eq($G($1.barcode,0,7),"[)>01")){$1.fid=$G($1.barcode,0,9);$1.barcode=$G($1.barcode,9,$1.barlen-9)}}$X($1.barcode,"");if($k[--$j]){$1.pcode=$k[--$j];$j--;if($1.mode==2){$k[$j++]=true;for(var _p=0,_q=1;_p<_q;_p++){if($1.pcode.length>9){$j--;$k[$j++]=false;break}$F($1.pcode,function(){var _t=$k[--$j];if(_t<48||_t>57){$j--;$k[$j++]=false;return true}})}if($nt($k[--$j])){$j--;$k[$j++]="bwipp.maxicodeBadMode2PostCode#21212";$k[$j++]="A mode 2 postcode must not exceed 9 digits";bwipp_raiseerror()}}else{$F($1.pcode,function(){var _w=$k[--$j];if(!(_w==32||(_w>=34&&_w<=58||_w>=65&&_w<=90))){$j--;$k[$j++]="bwipp.maxicodeBadMode3PostCode#21220";$k[$j++]="A mode 3 postcode must not exceed 6 characters";bwipp_raiseerror()}})}}else{$j--;$k[$j++]="bwipp.maxicodeExpectedPostCode#21225";$k[$j++]="Expected postcode followed by group separator character";bwipp_raiseerror()}$X($k[--$j],"");if($k[--$j]){$1.ccode=$k[--$j];$j--;$k[$j++]=true;for(var _10=0,_11=1;_10<_11;_10++){if($1.ccode.length!=3){$j--;$k[$j++]=false;break}$F($1.ccode,function(){var _14=$k[--$j];if(_14<48||_14>57){$j--;$k[$j++]=false;return true}})}if($nt($k[--$j])){$j--;$k[$j++]="bwipp.maxicodeBadCountryCode#21235";$k[$j++]="Country code must be three digits";bwipp_raiseerror()}}else{$j--;$k[$j++]="bwipp.maxicodeExpectedCountryCode#21238";$k[$j++]="Expected country code followed by group separator character";bwipp_raiseerror()}$X($k[--$j],"");if($k[--$j]){$1.scode=$k[--$j];$j--;$k[$j++]=true;for(var _19=0,_1A=1;_19<_1A;_19++){if($1.scode.length!=3){$j--;$k[$j++]=false;break}$F($1.scode,function(){var _1D=$k[--$j];if(_1D<48||_1D>57){$j--;$k[$j++]=false;return true}})}if($nt($k[--$j])){$j--;$k[$j++]="bwipp.maxicodeBadServiceClass#21248";$k[$j++]="Service class must be three digits";bwipp_raiseerror()}}else{$j--;$k[$j++]="bwipp.maxicodeExpectedServiceClass#21251";$k[$j++]="Expected service class followed by group separator character";bwipp_raiseerror()}$1.barcode=$k[--$j];var _1I=$s($1.barcode.length+$1.fid.length);$P(_1I,0,$1.fid);$P(_1I,$1.fid.length,$1.barcode);$1.barcode=_1I;$1.barlen=$1.barcode.length;$k[$j++]=Infinity;var _1N=$1.barcode;for(var _1O=0,_1P=_1N.length;_1O<_1P;_1O++){$k[$j++]=$g(_1N,_1O)}$1.msg=$a();$1.msglen=$1.msg.length}if(!bwipp_maxicode.__21361__){(function(){var $ctx=Object.create($1);$ctx.eci=-1;$ctx.pad=-2;$ctx.ns=-3;$ctx.la=-4;$ctx.lb=-5;$ctx.sa=-6;$ctx.sb=-7;$ctx.sc=-8;$ctx.sd=-9;$ctx.se=-10;$ctx.sa2=-11;$ctx.sa3=-12;$ctx.lkc=-13;$ctx.lkd=-14;$ctx.lke=-15;$ctx.pd2=-16;$ctx.pd3=-17;$ctx.charmaps=$a([$a([13,"`",192,224,0]),$a(["A","a",193,225,1]),$a(["B","b",194,226,2]),$a(["C","c",195,227,3]),$a(["D","d",196,228,4]),$a(["E","e",197,229,5]),$a(["F","f",198,230,6]),$a(["G","g",199,231,7]),$a(["H","h",200,232,8]),$a(["I","i",201,233,9]),$a(["J","j",202,234,10]),$a(["K","k",203,235,11]),$a(["L","l",204,236,12]),$a(["M","m",205,237,13]),$a(["N","n",206,238,14]),$a(["O","o",207,239,15]),$a(["P","p",208,240,16]),$a(["Q","q",209,241,17]),$a(["R","r",210,242,18]),$a(["S","s",211,243,19]),$a(["T","t",212,244,20]),$a(["U","u",213,245,21]),$a(["V","v",214,246,22]),$a(["W","w",215,247,23]),$a(["X","x",216,248,24]),$a(["Y","y",217,249,25]),$a(["Z","z",218,250,26]),$a([$ctx.eci,$ctx.eci,$ctx.eci,$ctx.eci,$ctx.eci]),$a([28,28,28,28,$ctx.pad]),$a([29,29,29,29,$ctx.pad]),$a([30,30,30,30,27]),$a([$ctx.ns,$ctx.ns,$ctx.ns,$ctx.ns,$ctx.ns]),$a([" ","{",219,251,28]),$a([$ctx.pad,$ctx.pad,220,252,29]),$a(['"',"}",221,253,30]),$a(["#","~",222,254,31]),$a(["$",127,223,255,159]),$a(["%",";",170,161,160]),$a(["&","<",172,168,162]),$a(["'","=",177,171,163]),$a([40,">",178,175,164]),$a([41,"?",179,176,165]),$a(["*","[",181,180,166]),$a(["+",92,185,183,167]),$a([",","]",186,184,169]),$a(["-","^",188,187,173]),$a([".","_",189,191,174]),$a(["/"," ",190,138,182]),$a(["0",",",128,139,149]),$a(["1",".",129,140,150]),$a(["2","/",130,141,151]),$a(["3",":",131,142,152]),$a(["4","@",132,143,153]),$a(["5","!",133,144,154]),$a(["6","|",134,145,155]),$a(["7",$ctx.pd2,135,146,156]),$a(["8",$ctx.sa2,136,147,157]),$a(["9",$ctx.sa3,137,148,158]),$a([":",$ctx.pd3,$ctx.la,$ctx.la,$ctx.la]),$a([$ctx.sb,$ctx.sa," "," "," "]),$a([$ctx.sc,$ctx.sc,$ctx.lkc,$ctx.sc,$ctx.sc]),$a([$ctx.sd,$ctx.sd,$ctx.sd,$ctx.lkd,$ctx.sd]),$a([$ctx.se,$ctx.se,$ctx.se,$ctx.se,$ctx.lke]),$a([$ctx.lb,$ctx.la,$ctx.lb,$ctx.lb,$ctx.lb])]);$ctx.charvals=$a([new Map,new Map,new Map,new Map,new Map]);for(var _3G=0,_3F=$ctx.charmaps.length-1;_3G<=_3F;_3G+=1){$ctx.i=_3G;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _3K=0;_3K<=4;_3K+=1){$ctx.j=_3K;var _3N=$g($ctx.encs,$ctx.j);$k[$j++]=_3N;if($eq($t(_3N),"stringtype")){var _3Q=$g($k[--$j],0);$k[$j++]=_3Q}$p($g($ctx.charvals,$ctx.j),$k[--$j],$ctx.i)}}$ctx.seta=$g($ctx.charvals,0);$ctx.setb=$g($ctx.charvals,1);$ctx.setc=$g($ctx.charvals,2);$ctx.setd=$g($ctx.charvals,3);$ctx.sete=$g($ctx.charvals,4);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_maxicode.$ctx[id]=$ctx[id]);bwipp_maxicode.__21361__=1})()}$k[$j++]=Infinity;for(var _3i=0,_3j=$1.msglen+1;_3i<_3j;_3i++){$k[$j++]=0}$1.nseq=$a();for(var _3m=$1.msglen-1;_3m>=0;_3m-=1){$1.i=_3m;var _3p=$g($1.msg,$1.i);if(_3p>=48&&_3p<=57){$p($1.nseq,$1.i,$f($g($1.nseq,$1.i+1)+1))}else{$p($1.nseq,$1.i,0)}}$1.nseq=$G($1.nseq,0,$1.msglen);$1.prefixinset=function(){$k[$j++]=0;for(;;){var _40=$k[--$j];var _41=$k[--$j];$k[$j++]=_41;$k[$j++]=_40;if(_40>=_41.length){break}var _42=$k[--$j];var _43=$k[--$j];var _45=$k[--$j];var _46=$g(_45,$g(_43,_42))!==undefined;$k[$j++]=_45;$k[$j++]=_43;$k[$j++]=_42;if(_46){var _47=$k[--$j];$k[$j++]=$f(_47+1)}else{break}}var _48=$k[--$j];var _49=$k[--$j];$k[$j++]=_48;$k[$j++]=_49;$j--;var _4A=$k[--$j];var _4B=$k[--$j];$k[$j++]=_4A;$k[$j++]=_4B;$j--};$1.enc=function(){var _4C=$k[--$j];$p($1.out,$1.j,$g(_4C,$k[--$j]));$1.j=$1.j+1};$1.out=$a(144);$1.i=0;$1.j=0;$1.cset="seta";for(;;){if($1.i==$1.msglen){if($ne($1.cset,"seta")&&$ne($1.cset,"setb")){$k[$j++]=$1.la;$k[$j++]=$1[$1.cset];$1.enc();$1.cset="seta"}break}for(;;){if($g($1.msg,$1.i)<=-1e6){$k[$j++]=$1.eci;$k[$j++]=$1[$1.cset];$1.enc();var _4Z=$f(-$g($1.msg,$1.i)-1e6);$k[$j++]=_4Z;if(_4Z<=31){var _4a=$k[--$j];$k[$j++]=_4a&63;$as($a(1))}else{var _4c=$k[--$j];$k[$j++]=_4c;if(_4c<=1023){var _4d=$k[--$j];$k[$j++]=_4d>>>6&31|32;$k[$j++]=_4d&63;$as($a(2))}else{var _4f=$k[--$j];$k[$j++]=_4f;if(_4f<=32767){var _4g=$k[--$j];$k[$j++]=_4g>>>12&47|48;$k[$j++]=_4g>>>6&63;$k[$j++]=_4g&63;$as($a(3))}else{var _4i=$k[--$j];$k[$j++]=_4i>>>18&55|56;$k[$j++]=_4i>>>12&63;$k[$j++]=_4i>>>6&63;$k[$j++]=_4i&63;$as($a(4))}}}var _4k=$k[--$j];$P($1.out,$1.j,_4k);$1.j=_4k.length+$1.j;$1.i=$1.i+1;break}if($g($1.nseq,$1.i)>=9){var _4u=$G($1.msg,$1.i,9);$k[$j++]=0;for(var _4v=0,_4w=_4u.length;_4v<_4w;_4v++){var _4y=$k[--$j];$k[$j++]=$f(_4y+$f($g(_4u,_4v)-48))*10}var _4z=$k[--$j];$k[$j++]=~~(_4z/10);for(var _50=0,_51=4;_50<_51;_50++){var _52=$k[--$j];$k[$j++]=_52&63;$k[$j++]=_52>>>6}$k[$j++]=$g($1[$1.cset],$1.ns);for(var _57=0;_57<=10;_57+=2){var _58=$k[$j-1-_57];$k[$j++]=_58}$as($a(6));var _5A=$k[--$j];var _5B=$k[--$j];var _5C=$k[--$j];var _5D=$k[--$j];var _5E=$k[--$j];var _5F=$k[--$j];var _5G=$k[--$j];$k[$j++]=_5A;$k[$j++]=_5G;$k[$j++]=_5F;$k[$j++]=_5E;$k[$j++]=_5D;$k[$j++]=_5C;$k[$j++]=_5B;for(var _5H=0,_5I=6;_5H<_5I;_5H++){$j--}$P($1.out,$1.j,$k[--$j]);$1.i=$1.i+9;$1.j=$1.j+6;break}$1.char1=$g($1.msg,$1.i);$k[$j++]="char2";if($1.i+1<$1.msglen){$k[$j++]=$g($1.msg,$1.i+1)}else{$k[$j++]=-99}var _5W=$k[--$j];$1[$k[--$j]]=_5W;$k[$j++]="char3";if($1.i+2<$1.msglen){$k[$j++]=$g($1.msg,$1.i+2)}else{$k[$j++]=-99}var _5d=$k[--$j];$1[$k[--$j]]=_5d;var _5i=$g($1[$1.cset],$1.char1)!==undefined;if(_5i){$k[$j++]=$1.char1;$k[$j++]=$1[$1.cset];$1.enc();$1.i=$1.i+1;break}var _5q=$g($1.setb,$1.char1)!==undefined;if($eq($1.cset,"seta")&&_5q){var _5t=$g($1.setb,$1.char2)!==undefined;if(_5t){$k[$j++]=$1.lb;$k[$j++]=$1.seta;$1.enc();$1.cset="setb"}else{$k[$j++]=$1.sb;$k[$j++]=$1.seta;$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.setb;$1.enc();$1.i=$1.i+1}break}var _64=$g($1.seta,$1.char1)!==undefined;if($eq($1.cset,"setb")&&_64){var _65=$1.seta;var _66=$1.msg;var _67=$1.i;var _68=$1.msglen;var _69=$1.i;var _6A=_68-_69;var _6B=4;if(4>_68-_69){var _=_6A;_6A=_6B;_6B=_}$k[$j++]="p";$k[$j++]=_65;$k[$j++]=$G(_66,_67,_6B);$1.prefixinset();var _6D=$k[--$j];$1[$k[--$j]]=_6D;if($1.p==1){$k[$j++]=$1.sa;$k[$j++]=$1.setb;$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.seta;$1.enc();$1.i=$1.i+1}if($1.p==2){$k[$j++]=$1.sa2;$k[$j++]=$1.setb;$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.seta;$1.enc();$k[$j++]=$1.char2;$k[$j++]=$1.seta;$1.enc();$1.i=$1.i+2}if($1.p==3){$k[$j++]=$1.sa3;$k[$j++]=$1.setb;$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1.seta;$1.enc();$k[$j++]=$1.char2;$k[$j++]=$1.seta;$1.enc();$k[$j++]=$1.char3;$k[$j++]=$1.seta;$1.enc();$1.i=$1.i+3}if($1.p>=4){$k[$j++]=$1.la;$k[$j++]=$1.setb;$1.enc();$1.cset="seta"}break}var _6i=$g($1.seta,$1.char1)!==undefined;if(_6i){$k[$j++]=$1.la;$k[$j++]=$1[$1.cset];$1.enc();$1.cset="seta";break}var _6o=$g($1.setb,$1.char1)!==undefined;if(_6o){$k[$j++]=$1.lb;$k[$j++]=$1[$1.cset];$1.enc();$1.cset="setb";break}var _6u=$g($1.setc,$1.char1)!==undefined;if(_6u){$1.setx="setc";$1.sx=$1.sc;$1.lkx=$1.lkc}var _6z=$g($1.setd,$1.char1)!==undefined;if(_6z){$1.setx="setd";$1.sx=$1.sd;$1.lkx=$1.lkd}var _74=$g($1.sete,$1.char1)!==undefined;if(_74){$1.setx="sete";$1.sx=$1.se;$1.lkx=$1.lke}var _78=$1[$1.setx];var _79=$1.msg;var _7A=$1.i;var _7B=$1.msglen;var _7C=$1.i;var _7D=_7B-_7C;var _7E=4;if(4>_7B-_7C){var _=_7D;_7D=_7E;_7E=_}$k[$j++]="p";$k[$j++]=_78;$k[$j++]=$G(_79,_7A,_7E);$1.prefixinset();var _7G=$k[--$j];$1[$k[--$j]]=_7G;if($1.p==1){$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1[$1.setx];$1.enc();$1.i=$1.i+1}if($1.p==2){$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1[$1.setx];$1.enc();$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char2;$k[$j++]=$1[$1.setx];$1.enc();$1.i=$1.i+2}if($1.p==3){$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char1;$k[$j++]=$1[$1.setx];$1.enc();$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char2;$k[$j++]=$1[$1.setx];$1.enc();$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.char3;$k[$j++]=$1[$1.setx];$1.enc();$1.i=$1.i+3}if($1.p>=4){$k[$j++]=$1.sx;$k[$j++]=$1[$1.cset];$1.enc();$k[$j++]=$1.lkx;$k[$j++]=$1[$1.setx];$1.enc();$1.cset=$1.setx}break}}$1.encmsg=$G($1.out,0,$1.j);$1.padval=$g($1[$1.cset],$1.pad);$k[$j++]="sami";if($1.sam!=-1){$k[$j++]=$a([$g($1.seta,$1.pad),(~~($1.sam/10)-1)*8+($1.sam%10-1)])}else{$k[$j++]=$a([])}var _8L=$k[--$j];$1[$k[--$j]]=_8L;$k[$j++]=Infinity;$q($1.sami);$q($1.encmsg);$1.encmsg=$a();if($1.mode==2||$1.mode==3){if($1.encmsg.length>84){$k[$j++]="bwipp.maxicodeMode23TooLong#21554";$k[$j++]="The secondary message is too long";bwipp_raiseerror()}var _8U=$Z($s(4),"0000");var _8X=$R($s(4),~~$1.mode,2);$P(_8U,4-_8X.length,_8X);$1.mdb=_8U;var _8Z=$Z($s(10),"0000000000");var _8c=$R($s(10),$i($1.ccode),2);$P(_8Z,10-_8c.length,_8c);$1.ccb=_8Z;var _8e=$Z($s(10),"0000000000");var _8h=$R($s(10),$i($1.scode),2);$P(_8e,10-_8h.length,_8h);$1.scb=_8e;$1.pcb=$Z($s(36),"000000000000000000000000000000000000");if($1.mode==2){var _8o=$R($s(6),$1.pcode.length,2);$P($1.pcb,6-_8o.length,_8o);var _8s=$R($s(30),$i($1.pcode),2);$P($1.pcb,36-_8s.length,_8s)}else{$k[$j++]=Infinity;var _8u=$Z($s(6),"      ");$k[$j++]=_8u;$k[$j++]=_8u;$k[$j++]=0;if($1.pcode.length>6){$k[$j++]=$G($1.pcode,0,6)}else{$k[$j++]=$1.pcode}var _8z=$k[--$j];var _90=$k[--$j];$P($k[--$j],_90,_8z);$F($k[--$j],function(){var _95=$g($1.seta,$k[--$j]);$k[$j++]=_95});$1.pccw=$a();for(var _97=0;_97<=5;_97+=1){$1.i=_97;var _9D=$R($s(6),$g($1.pccw,$1.i),2);$P($1.pcb,6*$1.i+6-_9D.length,_9D)}}$1.scm=$s(60);$P($1.scm,2,$1.mdb);$P($1.scm,38,$G($1.pcb,0,4));$P($1.scm,30,$G($1.pcb,4,6));$P($1.scm,24,$G($1.pcb,10,6));$P($1.scm,18,$G($1.pcb,16,6));$P($1.scm,12,$G($1.pcb,22,6));$P($1.scm,6,$G($1.pcb,28,6));$P($1.scm,0,$G($1.pcb,34,2));$P($1.scm,52,$G($1.ccb,0,2));$P($1.scm,42,$G($1.ccb,2,6));$P($1.scm,36,$G($1.ccb,8,2));$P($1.scm,54,$G($1.scb,0,6));$P($1.scm,48,$G($1.scb,6,4));$1.pri=$a([0,0,0,0,0,0,0,0,0,0]);for(var _9t=0;_9t<=59;_9t+=1){$1.i=_9t;$1.ps=~~($1.i/6);$1.ep=~~Math.pow(2,5-$1.i%6)*($g($1.scm,$1.i)-48);$p($1.pri,$1.ps,$f($g($1.pri,$1.ps)+$1.ep))}$k[$j++]=Infinity;for(var _A5=0,_A6=84;_A5<_A6;_A5++){$k[$j++]=$1.padval}$1.sec=$a();$P($1.sec,0,$1.encmsg)}if($1.mode==4||$1.mode==5||$1.mode==6||$1.mode==-1){if($1.mode==-1){var _AH=$1.encmsg.length<=77?5:4;$1.mode=_AH}$k[$j++]=Infinity;var _AJ=$1.mode==5?78:94;for(var _AK=0,_AL=_AJ;_AK<_AL;_AK++){$k[$j++]=$1.padval}$1.cws=$a();if($1.encmsg.length>$1.cws.length-1){$k[$j++]="bwipp.maxicodeMode56TooLong#21619";$k[$j++]="The message is too long";bwipp_raiseerror()}$p($1.cws,0,$1.mode);$P($1.cws,1,$1.encmsg);$1.pri=$G($1.cws,0,10);$1.sec=$G($1.cws,10,$1.cws.length-10)}$k[$j++]=Infinity;$k[$j++]=1;for(var _AZ=0,_Aa=63;_AZ<_Aa;_AZ++){var _Ab=$k[--$j];var _Ac=_Ab*2;$k[$j++]=_Ab;$k[$j++]=_Ac;if(_Ac>=64){var _Ad=$k[--$j];$k[$j++]=_Ad^67}}$1.rsalog=$a();$1.rslog=$a(64);for(var _Ag=1;_Ag<=63;_Ag+=1){$p($1.rslog,$g($1.rsalog,_Ag),_Ag)}$1.rsprod=function(){var _Ak=$k[--$j];var _Al=$k[--$j];$k[$j++]=_Al;$k[$j++]=_Ak;if(_Ak!=0&&_Al!=0){var _Ao=$g($1.rslog,$k[--$j]);var _At=$g($1.rsalog,$f(_Ao+$g($1.rslog,$k[--$j]))%63);$k[$j++]=_At}else{$j-=2;$k[$j++]=0}};$1.rscodes=function(){$1.rsnum=$k[--$j];$1.cwb=$k[--$j];$k[$j++]=Infinity;$k[$j++]=1;for(var _Ax=0,_Ay=$1.rsnum;_Ax<_Ay;_Ax++){$k[$j++]=0}$1.coeffs=$a();for(var _B2=1,_B1=$1.rsnum;_B2<=_B1;_B2+=1){$1.i=_B2;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _B9=$1.i-1;_B9>=1;_B9-=1){$1.j=_B9;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _BL=$k[--$j];var _BM=$k[--$j];var _BN=$k[--$j];$p($k[--$j],_BN,$xo(_BM,_BL))}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _BV=$k[--$j];var _BW=$k[--$j];$p($k[--$j],_BW,_BV)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);$k[$j++]=Infinity;for(var _Bc=0,_Bd=$1.rsnum;_Bc<_Bd;_Bc++){$k[$j++]=0}$1.ecb=$a();for(var _Bh=0,_Bg=$1.cwb.length-1;_Bh<=_Bg;_Bh+=1){$1.t=$xo($g($1.cwb,_Bh),$g($1.ecb,0));for(var _Bn=$1.ecb.length-1;_Bn>=0;_Bn-=1){$1.i=_Bn;$1.p=$1.ecb.length-$1.i-1;$k[$j++]=$1.ecb;$k[$j++]=$1.p;$k[$j++]=$1.t;$k[$j++]=$g($1.coeffs,$1.i);$1.rsprod();var _Bw=$k[--$j];var _Bx=$k[--$j];$p($k[--$j],_Bx,_Bw);if($1.i>0){$p($1.ecb,$1.p,$xo($g($1.ecb,$1.p+1),$g($1.ecb,$1.p)))}}}$k[$j++]=$1.ecb};$k[$j++]=Infinity;for(var _CB=0,_CA=$1.sec.length-1;_CB<=_CA;_CB+=2){$k[$j++]=$g($1.sec,_CB)}$1.seco=$a();$k[$j++]=Infinity;for(var _CH=1,_CG=$1.sec.length-1;_CH<=_CG;_CH+=2){$k[$j++]=$g($1.sec,_CH)}$1.sece=$a();var _CM=$1.sec.length==84?20:28;$1.scodes=_CM;$k[$j++]="secochk";$k[$j++]=$1.seco;$k[$j++]=$1.scodes;$1.rscodes();var _CP=$k[--$j];$1[$k[--$j]]=_CP;$k[$j++]="secechk";$k[$j++]=$1.sece;$k[$j++]=$1.scodes;$1.rscodes();var _CT=$k[--$j];$1[$k[--$j]]=_CT;$k[$j++]=Infinity;for(var _CX=0,_CW=$1.scodes-1;_CX<=_CW;_CX+=1){$k[$j++]=$g($1.secochk,_CX);$k[$j++]=$g($1.secechk,_CX)}$1.secchk=$a();$k[$j++]=Infinity;$q($1.pri);$k[$j++]=$1.pri;$k[$j++]=10;$1.rscodes();$q($k[--$j]);$q($1.sec);$q($1.secchk);$1.codewords=$a();$k[$j++]=Infinity;for(var _Cj=0,_Ck=864;_Cj<_Ck;_Cj++){$k[$j++]=0}$1.mods=$a();for(var _Cm=0;_Cm<=143;_Cm+=1){$1.i=_Cm;$k[$j++]=Infinity;var _Cr=$R($s(6),$g($1.codewords,$1.i),2);for(var _Cs=0,_Ct=_Cr.length;_Cs<_Ct;_Cs++){$k[$j++]=$g(_Cr,_Cs)-48}$1.cw=$a();$P($1.mods,6*$1.i+(6-$1.cw.length),$1.cw)}if(!bwipp_maxicode.__21755__){(function(){var $ctx=Object.create($1);$ctx.modmap=$a([469,529,286,316,347,346,673,672,703,702,647,676,283,282,313,312,370,610,618,379,378,409,408,439,705,704,559,589,588,619,458,518,640,701,675,674,285,284,315,314,310,340,531,289,288,319,349,348,456,486,517,516,471,470,369,368,399,398,429,428,549,548,579,578,609,608,649,648,679,678,709,708,639,638,669,668,699,698,279,278,309,308,339,338,381,380,411,410,441,440,561,560,591,590,621,620,547,546,577,576,607,606,367,366,397,396,427,426,291,290,321,320,351,350,651,650,681,680,711,710,1,0,31,30,61,60,3,2,33,32,63,62,5,4,35,34,65,64,7,6,37,36,67,66,9,8,39,38,69,68,11,10,41,40,71,70,13,12,43,42,73,72,15,14,45,44,75,74,17,16,47,46,77,76,19,18,49,48,79,78,21,20,51,50,81,80,23,22,53,52,83,82,25,24,55,54,85,84,27,26,57,56,87,86,117,116,147,146,177,176,115,114,145,144,175,174,113,112,143,142,173,172,111,110,141,140,171,170,109,108,139,138,169,168,107,106,137,136,167,166,105,104,135,134,165,164,103,102,133,132,163,162,101,100,131,130,161,160,99,98,129,128,159,158,97,96,127,126,157,156,95,94,125,124,155,154,93,92,123,122,153,152,91,90,121,120,151,150,181,180,211,210,241,240,183,182,213,212,243,242,185,184,215,214,245,244,187,186,217,216,247,246,189,188,219,218,249,248,191,190,221,220,251,250,193,192,223,222,253,252,195,194,225,224,255,254,197,196,227,226,257,256,199,198,229,228,259,258,201,200,231,230,261,260,203,202,233,232,263,262,205,204,235,234,265,264,207,206,237,236,267,266,297,296,327,326,357,356,295,294,325,324,355,354,293,292,323,322,353,352,277,276,307,306,337,336,275,274,305,304,335,334,273,272,303,302,333,332,271,270,301,300,331,330,361,360,391,390,421,420,363,362,393,392,423,422,365,364,395,394,425,424,383,382,413,412,443,442,385,384,415,414,445,444,387,386,417,416,447,446,477,476,507,506,537,536,475,474,505,504,535,534,473,472,503,502,533,532,455,454,485,484,515,514,453,452,483,482,513,512,451,450,481,480,511,510,541,540,571,570,601,600,543,542,573,572,603,602,545,544,575,574,605,604,563,562,593,592,623,622,565,564,595,594,625,624,567,566,597,596,627,626,657,656,687,686,717,716,655,654,685,684,715,714,653,652,683,682,713,712,637,636,667,666,697,696,635,634,665,664,695,694,633,632,663,662,693,692,631,630,661,660,691,690,721,720,751,750,781,780,723,722,753,752,783,782,725,724,755,754,785,784,727,726,757,756,787,786,729,728,759,758,789,788,731,730,761,760,791,790,733,732,763,762,793,792,735,734,765,764,795,794,737,736,767,766,797,796,739,738,769,768,799,798,741,740,771,770,801,800,743,742,773,772,803,802,745,744,775,774,805,804,747,746,777,776,807,806,837,836,867,866,897,896,835,834,865,864,895,894,833,832,863,862,893,892,831,830,861,860,891,890,829,828,859,858,889,888,827,826,857,856,887,886,825,824,855,854,885,884,823,822,853,852,883,882,821,820,851,850,881,880,819,818,849,848,879,878,817,816,847,846,877,876,815,814,845,844,875,874,813,812,843,842,873,872,811,810,841,840,871,870,901,900,931,930,961,960,903,902,933,932,963,962,905,904,935,934,965,964,907,906,937,936,967,966,909,908,939,938,969,968,911,910,941,940,971,970,913,912,943,942,973,972,915,914,945,944,975,974,917,916,947,946,977,976,919,918,949,948,979,978,921,920,951,950,981,980,923,922,953,952,983,982,925,924,955,954,985,984,927,926,957,956,987,986,58,89,88,118,149,148,178,209,208,238,269,268,298,329,328,358,389,388,418,449,448,478,509,508,538,569,568,598,629,628,658,689,688,718,749,748,778,809,808,838,869,868,898,929,928,958,989,988]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_maxicode.$ctx[id]=$ctx[id]);bwipp_maxicode.__21755__=1})()}$1.pixs=$a(864);$1.j=0;for(var _D5=0,_D4=$1.mods.length-1;_D5<=_D4;_D5+=1){$1.i=_D5;if($g($1.mods,$1.i)==1){$p($1.pixs,$1.j,$g($1.modmap,$1.i));$1.j=$1.j+1}}$k[$j++]=Infinity;$q($G($1.pixs,0,$1.j));$k[$j++]=28;$k[$j++]=29;$k[$j++]=280;$k[$j++]=281;$k[$j++]=311;$k[$j++]=457;$k[$j++]=488;$k[$j++]=500;$k[$j++]=530;$k[$j++]=670;$k[$j++]=700;$k[$j++]=677;$k[$j++]=707;$1.pixs=$a();var _DL=new Map([["ren",bwipp_renmaximatrix],["pixs",$1.pixs],["opt",$1.options]]);$k[$j++]=_DL;if(!$1.dontdraw){bwipp_renmaximatrix()}}function bwipp_azteccode(){var $1=Object.create(bwipp_azteccode.$ctx||(bwipp_azteccode.$ctx={}));$1.dontdraw=false;$1.format="full";$1.readerinit=false;$1.layers=-1;$1.eclevel=23;$1.ecaddchars=3;$1.raw=false;$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.aztecEmptyData#21830";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($1.eclevel<5||$1.eclevel>95){$k[$j++]="bwipp.aztecInvalidEClevel#21834";$k[$j++]="The EC percentage must be from 5 to 95";bwipp_raiseerror()}if($1.ecaddchars<3){$k[$j++]="bwipp.aztecInvalidECaddChars#21838";$k[$j++]="The number of additional EC codewords must be 3 or more";bwipp_raiseerror()}if($ne($1.format,"full")&&($ne($1.format,"compact")&&$ne($1.format,"rune"))){$k[$j++]="bwipp.aztecInvalidFormat#21842";$k[$j++]="The format must be either full, compact or rune";bwipp_raiseerror()}if($eq($1.format,"full")){if($1.readerinit&&($1.layers<1||$1.layers>22)){$k[$j++]="bwipp.aztecFullInitInvalidLayers#21847";$k[$j++]="Full-range symbols for reader programming must specify from 1 to 22 layers";bwipp_raiseerror()}if($1.layers!=-1&&($1.layers<1||$1.layers>32)){$k[$j++]="bwipp.aztecFullInvalidLayers#21850";$k[$j++]="Layers for full-range symbols must be from 1 to 32";bwipp_raiseerror()}}if($eq($1.format,"compact")){if($1.readerinit){if($1.layers!=-1&&$1.layers!=1){$k[$j++]="bwipp.aztecCompactInitInvalidLayers#21857";$k[$j++]="Compact symbols for reader programming must have 1 layer";bwipp_raiseerror()}$1.layers=1}if($1.layers!=-1&&($1.layers<1||$1.layers>4)){$k[$j++]="bwipp.aztecCompactInvalidLayers#21862";$k[$j++]="Layers for compact symbols must be from 1 to 4";bwipp_raiseerror()}}if($eq($1.format,"rune")){if($1.layers!=-1){$k[$j++]="bwipp.aztecRuneInvalidLayers#21868";$k[$j++]="It is not valid to specify layers for runes";bwipp_raiseerror()}if($1.readerinit){$k[$j++]="bwipp.aztecRuneReaderInit#21871";$k[$j++]="Reader initialisation is not compactible with Aztec Runes";bwipp_raiseerror()}if($1.barcode.length==0){$k[$j++]="bwipp.aztecRuneNotNumeric#21874";$k[$j++]="Aztec runes must be numeric";bwipp_raiseerror()}$F($1.barcode,function(){var _S=$k[--$j];if(_S<48||_S>57){$k[$j++]="bwipp.aztecRuneNotNumeric#21878";$k[$j++]="Aztec runes must be numeric";bwipp_raiseerror()}});var _U=$i($1.barcode);if(_U<0||_U>255){$k[$j++]="bwipp.aztecRuneInvalid#21882";$k[$j++]="Aztec runes must be 0 to 255";bwipp_raiseerror()}}$1.fn1=-1;var _Y=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true],["FNC1",$1.fn1]]);$1.fncvals=_Y;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _b=$k[--$j];$1[$k[--$j]]=_b;$1.msglen=$1.msg.length;if(!bwipp_azteccode.__21995__){(function(){var $ctx=Object.create($1);$ctx.U=0;$ctx.L=1;$ctx.M=2;$ctx.P=3;$ctx.D=4;$ctx.B=5;$ctx.lu=-2;$ctx.ll=-3;$ctx.lm=-4;$ctx.lp=-5;$ctx.ld=-6;$ctx.su=-7;$ctx.sp=-8;$ctx.sb=-9;$ctx.fl=-10;$ctx.p2=-11;$ctx.p3=-12;$ctx.p4=-13;$ctx.p5=-14;$ctx.charmaps=$a([$a([$ctx.sp,$ctx.sp,$ctx.sp,$ctx.fl,$ctx.sp]),$a([32,32,32,13,32]),$a(["A","a",1,$ctx.p2,"0"]),$a(["B","b",2,$ctx.p3,"1"]),$a(["C","c",3,$ctx.p4,"2"]),$a(["D","d",4,$ctx.p5,"3"]),$a(["E","e",5,"!","4"]),$a(["F","f",6,'"',"5"]),$a(["G","g",7,"#","6"]),$a(["H","h",8,"$","7"]),$a(["I","i",9,"%","8"]),$a(["J","j",10,"&","9"]),$a(["K","k",11,"'",","]),$a(["L","l",12,40,"."]),$a(["M","m",13,41,$ctx.lu]),$a(["N","n",27,"*",$ctx.su]),$a(["O","o",28,"+",-99]),$a(["P","p",29,",",-99]),$a(["Q","q",30,"-",-99]),$a(["R","r",31,".",-99]),$a(["S","s","@","/",-99]),$a(["T","t",92,":",-99]),$a(["U","u","^",";",-99]),$a(["V","v","_","<",-99]),$a(["W","w","`","=",-99]),$a(["X","x","|",">",-99]),$a(["Y","y","~","?",-99]),$a(["Z","z",127,"[",-99]),$a([$ctx.ll,$ctx.su,$ctx.ll,"]",-99]),$a([$ctx.lm,$ctx.lm,$ctx.lu,"{",-99]),$a([$ctx.ld,$ctx.ld,$ctx.lp,"}",-99]),$a([$ctx.sb,$ctx.sb,$ctx.sb,$ctx.lu,-99])]);$ctx.charvals=$a([new Map,new Map,new Map,new Map,new Map]);for(var _1c=0,_1b=$ctx.charmaps.length-1;_1c<=_1b;_1c+=1){$ctx.i=_1c;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _1g=0;_1g<=4;_1g+=1){$ctx.j=_1g;var _1j=$g($ctx.encs,$ctx.j);$k[$j++]=_1j;if($eq($t(_1j),"stringtype")){var _1m=$g($k[--$j],0);$k[$j++]=_1m}$p($g($ctx.charvals,$ctx.j),$k[--$j],$ctx.i)}}var _1w=new Map([["\r\n",$ctx.p2],[". ",$ctx.p3],[", ",$ctx.p4],[": ",$ctx.p5]]);$ctx.pcomp=_1w;$ctx.e=1e4;var _21=$a([4,9,9,14,0,14]);$ctx.latlen=$a([$a([0,5,5,10,5,10]),$a([9,0,5,10,5,10]),$a([5,5,0,5,10,10]),$a([5,10,10,0,10,15]),_21,$a([0,0,0,0,0,0])]);$ctx.latseq=$a([$a([$a([]),$a([$ctx.ll]),$a([$ctx.lm]),$a([$ctx.lm,$ctx.lp]),$a([$ctx.ld]),$a([$ctx.sb])]),$a([$a([$ctx.ld,$ctx.lu]),$a([]),$a([$ctx.lm]),$a([$ctx.lm,$ctx.lp]),$a([$ctx.ld]),$a([$ctx.sb])]),$a([$a([$ctx.lu]),$a([$ctx.ll]),$a([]),$a([$ctx.lp]),$a([$ctx.lu,$ctx.ld]),$a([$ctx.sb])]),$a([$a([$ctx.lu]),$a([$ctx.lu,$ctx.ll]),$a([$ctx.lu,$ctx.lm]),$a([]),$a([$ctx.lu,$ctx.ld]),$a([$ctx.lu,$ctx.sb])]),$a([$a([$ctx.lu]),$a([$ctx.lu,$ctx.ll]),$a([$ctx.lu,$ctx.lm]),$a([$ctx.lu,$ctx.lm,$ctx.lp]),$a([]),$a([$ctx.lu,$ctx.sb])]),$a([$a([$ctx.lu]),$a([$ctx.ll]),$a([$ctx.lm]),$a([]),$a([]),$a([])])]);$ctx.shftlen=$a([$a([$ctx.e,$ctx.e,$ctx.e,5,$ctx.e]),$a([5,$ctx.e,$ctx.e,5,$ctx.e]),$a([$ctx.e,$ctx.e,$ctx.e,5,$ctx.e]),$a([$ctx.e,$ctx.e,$ctx.e,$ctx.e,$ctx.e]),$a([4,$ctx.e,$ctx.e,4,$ctx.e])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_azteccode.$ctx[id]=$ctx[id]);bwipp_azteccode.__21995__=1})()}$1.msgbits="";if($ne($1.format,"rune")&&$1.raw){$1.msgbits=$1.barcode}if($ne($1.format,"rune")&&!$1.raw){$1.charsize=function(){var _3v=$k[--$j];$k[$j++]=_3v;if(_3v>=0){$j--;var _3y=$g($a([5,5,5,5,4,8]),$k[--$j]);$k[$j++]=_3y}else{var _3z=$k[--$j];var _40=$k[--$j];$k[$j++]=_3z;$k[$j++]=_40;$j--;var _41=$k[--$j];$k[$j++]=_41;if(_41==$1.fn1){$j--;$k[$j++]=8}else{var _44=$f(-$k[--$j]-1e6);$k[$j++]=_44;if(_44==0){$j--;$k[$j++]=1}var _45=$k[--$j];$k[$j++]=(~~(Math.log(_45)/Math.log(10))+1)*4+8}}};$1.curlen=$a([0,$1.e,$1.e,$1.e,$1.e,$1.e]);$1.curseq=$a([$a([]),$a([]),$a([]),$a([]),$a([]),$a([])]);$1.backto=$1.U;$1.lastchar="";$F($1.msg,function(){$1.char=$k[--$j];for(;;){$1.imp=false;var _4S=$a([$1.U,$1.L,$1.M,$1.P,$1.D,$1.B]);for(var _4T=0,_4U=_4S.length;_4T<_4U;_4T++){$1.x=$g(_4S,_4T);var _4c=$a([$1.U,$1.L,$1.M,$1.P,$1.D,$1.B]);for(var _4d=0,_4e=_4c.length;_4d<_4e;_4d++){$1.y=$g(_4c,_4d);if($1.x!=$1.B||$1.y==$1.backto){$1.cost=$f($g($1.curlen,$1.x)+$g($g($1.latlen,$1.x),$1.y));if($1.cost<$g($1.curlen,$1.y)){$p($1.curlen,$1.y,$1.cost);$k[$j++]=$1.curseq;$k[$j++]=$1.y;$k[$j++]=Infinity;$q($g($1.curseq,$1.x));$q($g($g($1.latseq,$1.x),$1.y));var _59=$a();var _5A=$k[--$j];$p($k[--$j],_5A,_59);if($1.y==$1.B){$k[$j++]="backto";if($1.x==$1.P||$1.x==$1.D){$k[$j++]=$1.U}else{$k[$j++]=$1.x}var _5K=$k[--$j];$1[$k[--$j]]=_5K}$1.imp=true}}}}if(!$1.imp){break}}$1.nxtlen=$a([$1.e,$1.e,$1.e,$1.e,$1.e,$1.e]);$1.nxtseq=$a(6);var _5b=$a([$1.U,$1.L,$1.M,$1.P,$1.D,$1.B]);for(var _5c=0,_5d=_5b.length;_5c<_5d;_5c++){$1.x=$g(_5b,_5c);for(;;){if($1.char>=0){if($1.x!=$1.B){var _5m=$g($g($1.charvals,$1.x),$1.char)!==undefined;if(!_5m){break}}}else{if($1.x!=$1.P){break}}$k[$j++]="cost";$k[$j++]=$g($1.curlen,$1.x);$k[$j++]=$1.x;$k[$j++]=$1.char;$1.charsize();var _5u=$k[--$j];var _5v=$k[--$j];$1[$k[--$j]]=$f(_5v+_5u);if($1.cost<$g($1.nxtlen,$1.x)){$p($1.nxtlen,$1.x,$1.cost);$k[$j++]=$1.nxtseq;$k[$j++]=$1.x;$k[$j++]=Infinity;$q($g($1.curseq,$1.x));$k[$j++]=$1.char;var _6A=$a();var _6B=$k[--$j];$p($k[--$j],_6B,_6A)}if($1.x==$1.B){break}var _6K=$a([$1.U,$1.L,$1.M,$1.P,$1.D]);for(var _6L=0,_6M=_6K.length;_6L<_6M;_6L++){$1.y=$g(_6K,_6L);if($ne($1.x,$1.y)){$k[$j++]="cost";$k[$j++]=$f($g($1.curlen,$1.y)+$g($g($1.shftlen,$1.y),$1.x));$k[$j++]=$1.x;$k[$j++]=$1.char;$1.charsize();var _6a=$k[--$j];var _6b=$k[--$j];$1[$k[--$j]]=$f(_6b+_6a);if($1.cost<$g($1.nxtlen,$1.y)){$p($1.nxtlen,$1.y,$1.cost);$k[$j++]=$1.nxtseq;$k[$j++]=$1.y;$k[$j++]=Infinity;$q($g($1.curseq,$1.y));var _6r=$1.x==$1.U?$1.su:$1.sp;$k[$j++]=_6r;$k[$j++]=$1.char;var _6t=$a();var _6u=$k[--$j];$p($k[--$j],_6u,_6t)}}}break}}if($ne($1.lastchar,"")&&$1.char>=0){var _6y=$s(2);$p(_6y,0,$1.lastchar);$p(_6y,1,$1.char);$1.pchars=_6y;var _73=$g($1.pcomp,$1.pchars)!==undefined;if(_73){var _79=$a([$1.U,$1.L,$1.M,$1.P,$1.D]);for(var _7A=0,_7B=_79.length;_7A<_7B;_7A++){$1.i=$g(_79,_7A);$1.inP=true;if($1.i==$1.M){if($1.lastchar==13){$1.inP=false}}else{if($1.i==$1.D){if($1.lastchar==44||$1.lastchar==46){$1.inP=false}}}if($1.inP&&$lt($g($1.curlen,$1.i),$g($1.nxtlen,$1.i))){$1.curseqi=$g($1.curseq,$1.i);$1.lastld=false;$1.lastsp=false;$1.lastidx=-1;for(var _7V=$1.curseqi.length-1;_7V>=0;_7V-=1){$1.idx=_7V;$1.ch=$g($1.curseqi,$1.idx);if($1.lastidx==-1){if($eq($1.ch,$1.lastchar)){$1.lastidx=$1.idx;if($1.idx>0){if($g($1.curseqi,$1.idx-1)==$1.sp){$1.lastsp=true}}}}else{if($1.ch<0&&$1.ch>=$1.ld){if($1.i==$1.P){if($1.ch==$1.ld){$1.lastld=true}}else{if($1.ch!=$1.lp){$1.inP=$1.lastsp}}break}}}if($1.inP&&$1.lastidx>=0){$p($1.nxtlen,$1.i,$g($1.curlen,$1.i));if($1.lastidx<$1.curseqi.length-1){if($1.i==$1.P){if($1.lastld){$p($1.nxtlen,$1.i,$f($g($1.nxtlen,$1.i)+1))}$k[$j++]=$1.nxtseq;$k[$j++]=$1.i;$k[$j++]=Infinity;$q($1.curseqi);$r($1.curseqi.length-$1.lastidx,-1);$j--;$k[$j++]=$g($1.pcomp,$1.pchars);var _8H=$a();var _8I=$k[--$j];$p($k[--$j],_8I,_8H)}else{$k[$j++]=$1.nxtseq;$k[$j++]=$1.i;$k[$j++]=Infinity;$q($1.curseqi);var _8N=$a();var _8O=$k[--$j];$p($k[--$j],_8O,_8N);$p($g($1.nxtseq,$1.i),$1.lastidx,$g($1.pcomp,$1.pchars))}}else{$k[$j++]=$1.nxtseq;$k[$j++]=$1.i;$k[$j++]=Infinity;$q($1.curseqi);$j--;$k[$j++]=$g($1.pcomp,$1.pchars);var _8d=$a();var _8e=$k[--$j];$p($k[--$j],_8e,_8d)}}}}}}if($ne($g($1.nxtseq,$1.B),null)){$1.numbytes=0;$F($g($1.nxtseq,$1.B),function(){if($k[--$j]==$1.sb){$k[$j++]=0}else{$k[$j++]=$1.numbytes+1}$1.numbytes=$k[--$j]});if($1.numbytes==32){$p($1.nxtlen,$1.B,$f($g($1.nxtlen,$1.B)+11))}}$1.curlen=$1.nxtlen;$1.curseq=$1.nxtseq;$k[$j++]="lastchar";if($1.char>=0){$k[$j++]=$1.char}else{$k[$j++]=""}var _90=$k[--$j];$1[$k[--$j]]=_90});$1.minseq=$1.e;var _99=$a([$1.U,$1.L,$1.M,$1.P,$1.D,$1.B]);for(var _9A=0,_9B=_99.length;_9A<_9B;_9A++){$1.i=$g(_99,_9A);if($g($1.curlen,$1.i)<$1.minseq){$1.minseq=$g($1.curlen,$1.i);$1.seq=$g($1.curseq,$1.i)}}$1.tobin=function(){var _9O=$s($k[--$j]);$k[$j++]=_9O;for(var _9Q=0,_9P=_9O.length-1;_9Q<=_9P;_9Q+=1){var _9R=$k[--$j];$p(_9R,_9Q,48);$k[$j++]=_9R}var _9S=$k[--$j];var _9V=$R($s(_9S.length),$k[--$j],2);$P(_9S,_9S.length-_9V.length,_9V);$k[$j++]=_9S};$1.encu=function(){var _9a=$g($g($1.charvals,$1.U),$k[--$j]);$k[$j++]=_9a;$k[$j++]=5;$1.tobin()};$1.encl=function(){var _9f=$g($g($1.charvals,$1.L),$k[--$j]);$k[$j++]=_9f;$k[$j++]=5;$1.tobin()};$1.encm=function(){var _9k=$g($g($1.charvals,$1.M),$k[--$j]);$k[$j++]=_9k;$k[$j++]=5;$1.tobin()};$1.encd=function(){var _9p=$g($g($1.charvals,$1.D),$k[--$j]);$k[$j++]=_9p;$k[$j++]=4;$1.tobin()};$1.encp=function(){var _9q=$k[--$j];$k[$j++]=_9q;if(_9q==$1.fn1){$j--;$k[$j++]="00000000"}else{var _9s=$k[--$j];$k[$j++]=_9s;if(_9s<=-1e6){var _9u=$f(-$k[--$j]-1e6);$k[$j++]=_9u;$k[$j++]=_9u;if(_9u==0){$j--;$k[$j++]=1}var _9w=~~(Math.log($k[--$j])/Math.log(10));var _9x=$s((_9w+1)*4+8);$P(_9x,0,"00000");$k[$j++]=_9w;$k[$j++]=_9x;$k[$j++]=_9x;$k[$j++]=_9w+1;$k[$j++]=3;$1.tobin();var _9y=$k[--$j];$P($k[--$j],5,_9y);var _A0=$k[--$j];var _A1=$k[--$j];var _A2=$k[--$j];$k[$j++]=_A0;$k[$j++]=_A2;for(var _A3=_A1;_A3>=0;_A3-=1){var _A4=$k[--$j];var _A5=$k[--$j];$k[$j++]=_A5;$k[$j++]=~~(_A4/10);$k[$j++]=_A5;$k[$j++]=_A3*4+8;$k[$j++]=$f(_A4%10+2);$k[$j++]=4;$1.tobin();var _A6=$k[--$j];var _A7=$k[--$j];$P($k[--$j],_A7,_A6)}$j--}else{var _AD=$g($g($1.charvals,$1.P),$k[--$j]);$k[$j++]=_AD;$k[$j++]=5;$1.tobin()}}};$1.encfuncs=$a(["encu","encl","encm","encp","encd"]);$1.addtomsgbits=function(){$1.v=$k[--$j];$P($1.msgbits,$1.j,$1.v);$1.j=$1.j+$1.v.length};$1.state=$1.U;$1.msgbits=$s($1.minseq);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.seq.length){break}if($1.state!=$1.B){$1.char=$g($1.seq,$1.i);$k[$j++]=$1.char;if($1[$g($1.encfuncs,$1.state)]()===true){break}$1.addtomsgbits();$1.i=$1.i+1;if($1.char==$1.su||$1.char==$1.sp){$k[$j++]=$g($1.seq,$1.i);if($1.char==$1.su){$1.encu()}else{$1.encp()}$1.addtomsgbits();$1.i=$1.i+1}if($1.char==$1.lu){$1.state=$1.U}if($1.char==$1.ll){$1.state=$1.L}if($1.char==$1.lm){$1.state=$1.M}if($1.char==$1.lp){$1.state=$1.P}if($1.char==$1.ld){$1.state=$1.D}if($1.char==$1.sb){$1.state=$1.B}}else{$1.numbytes=0;for(;;){if($1.i+$1.numbytes>=$1.seq.length){break}if($g($1.seq,$1.i+$1.numbytes)<0){break}$1.numbytes=$1.numbytes+1}if($1.numbytes<=31){$k[$j++]=$1.numbytes;$k[$j++]=5;$1.tobin();$1.addtomsgbits()}else{$k[$j++]=0;$k[$j++]=5;$1.tobin();$1.addtomsgbits();$k[$j++]=$1.numbytes-31;$k[$j++]=11;$1.tobin();$1.addtomsgbits()}for(var _BF=0,_BG=$1.numbytes;_BF<_BG;_BF++){$k[$j++]=$g($1.seq,$1.i);$k[$j++]=8;$1.tobin();$1.addtomsgbits();$1.i=$1.i+1}if($1.i<$1.seq.length){$1.char=$g($1.seq,$1.i);$1.i=$1.i+1;if($1.char==$1.lu){$1.state=$1.U}if($1.char==$1.ll){$1.state=$1.L}if($1.char==$1.lm){$1.state=$1.M}}}}}if(!bwipp_azteccode.__22309__){(function(){var $ctx=Object.create($1);$ctx.metrics=$a([$a(["rune",0,0,0,6]),$a(["compact",1,1,17,6]),$a(["full",1,1,21,6]),$a(["compact",2,0,40,6]),$a(["full",2,1,48,6]),$a(["compact",3,0,51,8]),$a(["full",3,1,60,8]),$a(["compact",4,0,76,8]),$a(["full",4,1,88,8]),$a(["full",5,1,120,8]),$a(["full",6,1,156,8]),$a(["full",7,1,196,8]),$a(["full",8,1,240,8]),$a(["full",9,1,230,10]),$a(["full",10,1,272,10]),$a(["full",11,1,316,10]),$a(["full",12,1,364,10]),$a(["full",13,1,416,10]),$a(["full",14,1,470,10]),$a(["full",15,1,528,10]),$a(["full",16,1,588,10]),$a(["full",17,1,652,10]),$a(["full",18,1,720,10]),$a(["full",19,1,790,10]),$a(["full",20,1,864,10]),$a(["full",21,1,940,10]),$a(["full",22,1,1020,10]),$a(["full",23,0,920,12]),$a(["full",24,0,992,12]),$a(["full",25,0,1066,12]),$a(["full",26,0,1144,12]),$a(["full",27,0,1224,12]),$a(["full",28,0,1306,12]),$a(["full",29,0,1392,12]),$a(["full",30,0,1480,12]),$a(["full",31,0,1570,12]),$a(["full",32,0,1664,12])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_azteccode.$ctx[id]=$ctx[id]);bwipp_azteccode.__22309__=1})()}var _CD=$1.metrics;for(var _CE=0,_CF=_CD.length;_CE<_CF;_CE++){$1.m=$g(_CD,_CE);$1.frmt=$g($1.m,0);$1.mlyr=$g($1.m,1);$1.icap=$g($1.m,2);$1.ncws=$g($1.m,3);$1.bpcw=$g($1.m,4);$1.numecw=~~Math.ceil($f($1.ncws*$1.eclevel/100+$1.ecaddchars));if($1.msgbits.length==0){$1.numecw=0}$1.numdcw=$f($1.ncws-$1.numecw);$1.okay=true;if($ne($1.format,$1.frmt)){$1.okay=false}if($1.readerinit&&$1.icap!=1){$1.okay=false}if($1.layers!=-1&&$1.layers!=$1.mlyr){$1.okay=false}if(~~Math.ceil($1.msgbits.length/$1.bpcw)>$1.numdcw){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.qrcodeNoValidSymbol#22330";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$1.layers=$1.mlyr;$1.allzero=function(){var _Ck=$k[--$j];$k[$j++]=$eq(_Ck,$G("000000000000",0,_Ck.length))};$1.allones=function(){var _Cm=$k[--$j];$k[$j++]=$eq(_Cm,$G("111111111111",0,_Cm.length))};$1.cws=$a($1.ncws);$1.m=0;$1.c=0;for(;;){if($1.msgbits.length<=$1.m){break}if($1.msgbits.length-$1.m>=$1.bpcw){$1.cwb=$G($1.msgbits,$1.m,$f($1.bpcw-1));$1.cwf=$G($1.msgbits,$f($f($1.m+$1.bpcw)-1),1);$k[$j++]=$1.cwb;$1.allzero();if($k[--$j]){$1.cwf="1";$1.m=$1.m-1}$k[$j++]=$1.cwb;$1.allones();if($k[--$j]){$1.cwf="0";$1.m=$1.m-1}var _D9=$s(12);$P(_D9,0,$1.cwb);$P(_D9,$f($1.bpcw-1),$1.cwf);$1.cwb=$G(_D9,0,$1.bpcw)}else{$1.cwb=$G($1.msgbits,$1.m,$1.msgbits.length-$1.m);var _DL=$Z($s(12),"111111111111");$P(_DL,0,$1.cwb);$1.cwb=$G(_DL,0,$1.bpcw);$k[$j++]=$1.cwb;$1.allones();if($k[--$j]){$P($1.cwb,$1.cwb.length-1,"0")}}$1.cw=0;for(var _DV=0,_DU=$f($1.bpcw-1);_DV<=_DU;_DV+=1){$1.i=_DV;$1.cw=$f($1.cw+~~Math.pow(2,$f($f($1.bpcw-$1.i)-1))*$f($g($1.cwb,$1.i)-48))}$p($1.cws,$1.c,$1.cw);$1.m=$f($1.m+$1.bpcw);$1.c=$1.c+1}$1.cws=$G($1.cws,0,$1.c);var _Dm=$g($1.options,"debugcws")!==undefined;if(_Dm){$k[$j++]="bwipp.debugcws#22369";$k[$j++]=$1.cws;bwipp_raiseerror()}$1.rscodes=function(){$1.rspm=$k[--$j];$1.rsgf=$k[--$j];$1.rsnc=$k[--$j];$1.rscws=$k[--$j];$k[$j++]=Infinity;$k[$j++]=1;for(var _Dt=0,_Du=$f($1.rsgf-1);_Dt<_Du;_Dt++){var _Dv=$k[--$j];var _Dw=_Dv*2;$k[$j++]=_Dv;$k[$j++]=_Dw;if(_Dw>=$1.rsgf){var _Dz=$k[--$j];$k[$j++]=$xo(_Dz,$1.rspm)}}$1.rsalog=$a();$1.rslog=$a($1.rsgf);for(var _E5=1,_E4=$f($1.rsgf-1);_E5<=_E4;_E5+=1){$p($1.rslog,$g($1.rsalog,_E5),_E5)}$1.rsprod=function(){var _E9=$k[--$j];var _EA=$k[--$j];$k[$j++]=_EA;$k[$j++]=_E9;if(_E9!=0&&_EA!=0){var _ED=$g($1.rslog,$k[--$j]);var _EJ=$g($1.rsalog,$f(_ED+$g($1.rslog,$k[--$j]))%$f($1.rsgf-1));$k[$j++]=_EJ}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _EL=0,_EM=$1.rsnc;_EL<_EM;_EL++){$k[$j++]=0}$1.coeffs=$a();for(var _EQ=1,_EP=$1.rsnc;_EQ<=_EP;_EQ+=1){$1.i=_EQ;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _EX=$1.i-1;_EX>=1;_EX-=1){$1.j=_EX;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Ej=$k[--$j];var _Ek=$k[--$j];var _El=$k[--$j];$p($k[--$j],_El,$xo(_Ek,_Ej))}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _Et=$k[--$j];var _Eu=$k[--$j];$p($k[--$j],_Eu,_Et)}$1.nd=$1.rscws.length;$k[$j++]=Infinity;$F($1.rscws);for(var _Ez=0,_F0=$1.rsnc;_Ez<_F0;_Ez++){$k[$j++]=0}$k[$j++]=0;$1.rscws=$a();for(var _F4=0,_F3=$1.nd-1;_F4<=_F3;_F4+=1){$1.k=$xo($g($1.rscws,_F4),$g($1.rscws,$1.nd));for(var _FC=0,_FB=$f($1.rsnc-1);_FC<=_FB;_FC+=1){$1.j=_FC;$k[$j++]=$1.rscws;$k[$j++]=$1.nd+$1.j;$k[$j++]=$g($1.rscws,$1.nd+$1.j+1);$k[$j++]=$1.k;$k[$j++]=$g($1.coeffs,$f($f($1.rsnc-$1.j)-1));$1.rsprod();var _FP=$k[--$j];var _FQ=$k[--$j];var _FR=$k[--$j];$p($k[--$j],_FR,$xo(_FQ,_FP))}}$k[$j++]=$G($1.rscws,0,$1.rscws.length-1)};if($eq($1.format,"full")){$1.mode=($f($1.layers-1)<<11)+($1.cws.length-1);if($1.readerinit){$1.mode=$1.mode|1024}$1.mode=$a([($1.mode&61440)>>>12,($1.mode&3840)>>>8,($1.mode&240)>>>4,$1.mode&15]);$k[$j++]="mode";$k[$j++]=$1.mode;$k[$j++]=6;$k[$j++]=16;$k[$j++]=19;$1.rscodes();var _Fh=$k[--$j];$1[$k[--$j]]=_Fh}if($eq($1.format,"compact")){$1.mode=($f($1.layers-1)<<6)+($1.cws.length-1);if($1.readerinit){$1.mode=$1.mode|32}$1.mode=$a([($1.mode&240)>>>4,$1.mode&15]);$k[$j++]="mode";$k[$j++]=$1.mode;$k[$j++]=5;$k[$j++]=16;$k[$j++]=19;$1.rscodes();var _Fs=$k[--$j];$1[$k[--$j]]=_Fs}if($eq($1.format,"rune")){$1.mode=$i($1.barcode);$1.mode=$a([($1.mode&240)>>>4,$1.mode&15]);$k[$j++]="mode";$k[$j++]=$1.mode;$k[$j++]=5;$k[$j++]=16;$k[$j++]=19;$1.rscodes();var _G0=$k[--$j];$1[$k[--$j]]=_G0;$k[$j++]=Infinity;var _G2=$1.mode;for(var _G3=0,_G4=_G2.length;_G3<_G4;_G3++){$k[$j++]=$g(_G2,_G3)^10}$1.mode=$a()}$1.modebits=$s($1.mode.length*4);for(var _GB=0,_GA=$1.modebits.length-1;_GB<=_GA;_GB+=1){$P($1.modebits,_GB,"0")}for(var _GF=0,_GE=$1.mode.length-1;_GF<=_GE;_GF+=1){$1.i=_GF;var _GL=$R($s(4),$g($1.mode,$1.i),2);$P($1.modebits,4-_GL.length+4*$1.i,_GL)}if(!bwipp_azteccode.__22470__){(function(){var $ctx=Object.create($1);$ctx.rsparams=$a([$a([]),$a([]),$a([]),$a([]),$a([]),$a([]),$a([64,67]),$a([]),$a([256,301]),$a([]),$a([1024,1033]),$a([]),$a([4096,4201])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_azteccode.$ctx[id]=$ctx[id]);bwipp_azteccode.__22470__=1})()}$k[$j++]="cws";$k[$j++]=$1.cws;$k[$j++]=$f($1.ncws-$1.cws.length);$F($g($1.rsparams,$1.bpcw));$1.rscodes();var _Gi=$k[--$j];$1[$k[--$j]]=_Gi;if($eq($1.format,"full")){$1.databits=$s($f($1.layers*$1.layers*16+$1.layers*112))}else{$1.databits=$s($f($1.layers*$1.layers*16+$1.layers*88))}for(var _Gv=0,_Gu=$1.databits.length-1;_Gv<=_Gu;_Gv+=1){$P($1.databits,_Gv,"0")}for(var _Gz=0,_Gy=$f($1.ncws-1);_Gz<=_Gy;_Gz+=1){$1.i=_Gz;var _H6=$R($s($1.bpcw),$g($1.cws,$1.i),2);$P($1.databits,$f($f($f($1.bpcw-_H6.length)+$1.bpcw*$1.i)+$f($1.databits.length-$1.ncws*$1.bpcw)),_H6)}$1.cmv=function(){var _HE=$k[--$j];var _HF=$k[--$j];$k[$j++]=$f($f(_HF-_HE*$1.size)+$1.mid)};$1.lmv=function(){$1.lbit=$k[--$j];$1.llyr=$k[--$j];$1.lwid=$f($1.fw+$1.llyr*4);$1.ldir=~~(~~($1.lbit/2)/$1.lwid);if($1.ldir==0){$k[$j++]=$f(-~~($f($1.lwid-1)/2)+1+~~($1.lbit/2)%$1.lwid);$k[$j++]=$f($f(~~(($1.fw-1)/2)+$1.llyr*2)+$1.lbit%2);$1.cmv()}if($1.ldir==1){$k[$j++]=$f($f(~~($1.fw/2)+$1.llyr*2)+$1.lbit%2);$k[$j++]=$f(~~($f($1.lwid-1)/2)-1-~~($1.lbit/2)%$1.lwid);$1.cmv()}if($1.ldir==2){$k[$j++]=-$f(-~~($1.lwid/2)+1+~~($1.lbit/2)%$1.lwid);$k[$j++]=-$f($f(~~($1.fw/2)+$1.llyr*2)+$1.lbit%2);$1.cmv()}if($1.ldir==3){$k[$j++]=-$f($f(~~(($1.fw-1)/2)+$1.llyr*2)+$1.lbit%2);$k[$j++]=-$f(~~($1.lwid/2)-1-~~($1.lbit/2)%$1.lwid);$1.cmv()}};if($eq($1.format,"full")){$1.fw=12}else{$1.fw=9}$1.size=$f($f($1.fw+$1.layers*4)+2);$k[$j++]=Infinity;for(var _Hu=0,_Hv=$1.size*$1.size;_Hu<_Hv;_Hu++){$k[$j++]=-1}$1.pixs=$a();$1.mid=$f(~~($f($1.size-1)/2)*$1.size+~~($f($1.size-1)/2));$1.i=0;for(var _I2=1,_I1=$1.layers;_I2<=_I1;_I2+=1){$1.layer=_I2;for(var _I6=0,_I5=($1.fw+$1.layer*4)*8-1;_I6<=_I5;_I6+=1){$1.pos=_I6;$k[$j++]=$1.pixs;$k[$j++]=$1.layer;$k[$j++]=$1.pos;$1.lmv();var _IE=$k[--$j];$p($k[--$j],_IE,$g($1.databits,$1.databits.length-$1.i-1)-48);$1.i=$1.i+1}}if($eq($1.format,"full")){$1.fw=13;$1.size=$f($f($f($1.fw+$1.layers*4)+2)+~~$f($f($1.layers+10.5)/7.5-1)*2);$1.mid=~~($1.size*$1.size/2);$k[$j++]=Infinity;for(var _IP=0,_IQ=$1.size*$1.size;_IP<_IQ;_IP++){$k[$j++]=-2}$1.npixs=$a();for(var _IU=0,_IT=~~($1.size/2);_IU<=_IT;_IU+=16){$1.i=_IU;for(var _IX=0,_IW=$f($1.size-1);_IX<=_IW;_IX+=1){$1.j=_IX;$k[$j++]=$1.npixs;$k[$j++]=-~~($1.size/2)+$1.j;$k[$j++]=$1.i;$1.cmv();var _Ig=$k[--$j];$P($k[--$j],_Ig,$a([(~~($1.size/2)+$1.j+$1.i+1)%2]));$k[$j++]=$1.npixs;$k[$j++]=-~~($1.size/2)+$1.j;$k[$j++]=-$1.i;$1.cmv();var _Iq=$k[--$j];$P($k[--$j],_Iq,$a([(~~($1.size/2)+$1.j+$1.i+1)%2]));$k[$j++]=$1.npixs;$k[$j++]=$1.i;$k[$j++]=-~~($1.size/2)+$1.j;$1.cmv();var _J0=$k[--$j];$P($k[--$j],_J0,$a([(~~($1.size/2)+$1.j+$1.i+1)%2]));$k[$j++]=$1.npixs;$k[$j++]=-$1.i;$k[$j++]=-~~($1.size/2)+$1.j;$1.cmv();var _JA=$k[--$j];$P($k[--$j],_JA,$a([(~~($1.size/2)+$1.j+$1.i+1)%2]))}}$1.j=0;for(var _JE=0,_JD=$1.npixs.length-1;_JE<=_JD;_JE+=1){$1.i=_JE;if($g($1.npixs,$1.i)==-2){$p($1.npixs,$1.i,$g($1.pixs,$1.j));$1.j=$1.j+1}}$1.pixs=$1.npixs}$1.fw=~~($1.fw/2);for(var _JT=-$1.fw,_JS=$1.fw;_JT<=_JS;_JT+=1){$1.i=_JT;for(var _JX=-$1.fw,_JW=$1.fw;_JX<=_JW;_JX+=1){$1.j=_JX;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.cmv();if(Math.abs($1.i)>Math.abs($1.j)){$k[$j++]=Math.abs($1.i)}else{$k[$j++]=Math.abs($1.j)}var _Jf=$k[--$j];var _Jg=$k[--$j];$p($k[--$j],_Jg,$f(_Jf+1)%2)}}var _KI=$a([$a([-($1.fw+1),$1.fw,1]),$a([-($1.fw+1),$1.fw+1,1]),$a([-$1.fw,$1.fw+1,1]),$a([$1.fw+1,$1.fw+1,1]),$a([$1.fw+1,$1.fw,1]),$a([$1.fw+1,-$1.fw,1]),$a([$1.fw,$1.fw+1,0]),$a([$1.fw+1,-($1.fw+1),0]),$a([$1.fw,-($1.fw+1),0]),$a([-$1.fw,-($1.fw+1),0]),$a([-($1.fw+1),-($1.fw+1),0]),$a([-($1.fw+1),-$1.fw,0])]);for(var _KJ=0,_KK=_KI.length;_KJ<_KK;_KJ++){$k[$j++]=$1.pixs;$F($g(_KI,_KJ));var _KN=$k[--$j];var _KO=$k[--$j];var _KP=$k[--$j];$k[$j++]=_KN;$k[$j++]=_KP;$k[$j++]=_KO;$1.cmv();var _KQ=$k[--$j];var _KR=$k[--$j];$p($k[--$j],_KQ,_KR)}if(!bwipp_azteccode.__22596__){(function(){var $ctx=Object.create($1);$ctx.modemapfull=$a([$a([-5,7]),$a([-4,7]),$a([-3,7]),$a([-2,7]),$a([-1,7]),$a([1,7]),$a([2,7]),$a([3,7]),$a([4,7]),$a([5,7]),$a([7,5]),$a([7,4]),$a([7,3]),$a([7,2]),$a([7,1]),$a([7,-1]),$a([7,-2]),$a([7,-3]),$a([7,-4]),$a([7,-5]),$a([5,-7]),$a([4,-7]),$a([3,-7]),$a([2,-7]),$a([1,-7]),$a([-1,-7]),$a([-2,-7]),$a([-3,-7]),$a([-4,-7]),$a([-5,-7]),$a([-7,-5]),$a([-7,-4]),$a([-7,-3]),$a([-7,-2]),$a([-7,-1]),$a([-7,1]),$a([-7,2]),$a([-7,3]),$a([-7,4]),$a([-7,5])]);$ctx.modemapcompact=$a([$a([-3,5]),$a([-2,5]),$a([-1,5]),$a([0,5]),$a([1,5]),$a([2,5]),$a([3,5]),$a([5,3]),$a([5,2]),$a([5,1]),$a([5,0]),$a([5,-1]),$a([5,-2]),$a([5,-3]),$a([3,-5]),$a([2,-5]),$a([1,-5]),$a([0,-5]),$a([-1,-5]),$a([-2,-5]),$a([-3,-5]),$a([-5,-3]),$a([-5,-2]),$a([-5,-1]),$a([-5,0]),$a([-5,1]),$a([-5,2]),$a([-5,3])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_azteccode.$ctx[id]=$ctx[id]);bwipp_azteccode.__22596__=1})()}$k[$j++]="modemap";if($eq($1.format,"full")){$k[$j++]=$1.modemapfull}else{$k[$j++]=$1.modemapcompact}var _Lf=$k[--$j];$1[$k[--$j]]=_Lf;for(var _Lj=0,_Li=$1.modemap.length-1;_Lj<=_Li;_Lj+=1){$1.i=_Lj;$k[$j++]=$1.pixs;$F($g($1.modemap,$1.i));$1.cmv();var _Lr=$k[--$j];$p($k[--$j],_Lr,$g($1.modebits,$1.i)-48)}var _Lz=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.size],["pixy",$1.size],["height",$1.size*2/72],["width",$1.size*2/72],["opt",$1.options]]);$k[$j++]=_Lz;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_azteccodecompact(){var $1=Object.create(bwipp_azteccodecompact.$ctx||(bwipp_azteccodecompact.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"format","compact");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_azteccode();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_aztecrune(){var $1=Object.create(bwipp_aztecrune.$ctx||(bwipp_aztecrune.$ctx={}));$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$p($1.options,"dontdraw",true);$p($1.options,"format","rune");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_azteccode();var _6=$k[--$j];$1[$k[--$j]]=_6;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_codeone(){var $1=Object.create(bwipp_codeone.$ctx||(bwipp_codeone.$ctx={}));$1.dontdraw=false;$1.version="unset";$1.parse=false;$1.parsefnc=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _2=$a(["unset","T-16","T-32","T-48","S-10","S-20","S-30","A","B","C","D","E","F","G","H"]);$k[$j++]=false;for(var _3=0,_4=_2.length;_3<_4;_3++){var _7=$k[--$j];$k[$j++]=_7||$eq($g(_2,_3),$1.version)}if($nt($k[--$j])){$k[$j++]="bwipp.codeoneBadVersion#22757";$k[$j++]="version must be A to H, T-16, T-32, T-48, S-10, S-20 or S-30";bwipp_raiseerror()}$1.stype=$eq($G($1.version,0,1),"S");if(!bwipp_codeone.__22920__){(function(){var $ctx=Object.create($1);$ctx.stypevals=$a(["1","1010","1100100","1111101000","10011100010000","11000011010100000","11110100001001000000","100110001001011010000000","101111101011110000100000000","111011100110101100101000000000","1001010100000010111110010000000000","1011101001000011101101110100000000000","1110100011010100101001010001000000000000","10010001100001001110011100101010000000000000","10110101111001100010000011110100100000000000000","11100011010111111010100100110001101000000000000000","100011100001101111001001101111110000010000000000000000","101100011010001010111100001011101100010100000000000000000"]);$ctx.stypemetrics=$a([$a(["S-10",8,11,10,4,4,1,99,99,99]),$a(["S-20",8,21,20,8,8,1,99,99,99]),$a(["S-30",8,31,30,12,12,1,99,99,99])]);$ctx.nonstypemetrics=$a([$a(["A",16,18,16,10,10,1,4,99,6]),$a(["B",22,22,20,19,16,1,4,99,8]),$a(["C",28,32,28,44,26,1,4,22,11]),$a(["D",40,42,36,91,44,1,4,16,16]),$a(["E",52,54,48,182,70,1,4,22,22]),$a(["F",70,76,68,370,140,2,4,22,31]),$a(["G",104,98,88,732,280,4,6,21,47]),$a(["H",148,134,120,1480,560,8,6,20,69]),$a(["T-16",16,17,16,10,10,1,99,99,99]),$a(["T-32",16,33,32,24,16,1,99,99,99]),$a(["T-48",16,49,48,38,22,1,99,99,99])]);$ctx.fnc1=-1;$ctx.fnc3=-2;$ctx.lC=-5;$ctx.lB=-6;$ctx.lX=-7;$ctx.lT=-8;$ctx.lD=-9;$ctx.unl=-10;$ctx.fnc2=-11;$ctx.fnc4=-12;$ctx.sft1=-13;$ctx.sft2=-14;$ctx.sft3=-15;$ctx.eci=-16;$ctx.pad=-17;$ctx.fnc1lD=-18;$ctx.unlcw=255;$k[$j++]=Infinity;for(var _S=0;_S<=128;_S+=1){$k[$j++]=_S;$k[$j++]=_S+1}$k[$j++]=$ctx.pad;$k[$j++]=129;for(var _U=0;_U<=99;_U+=1){var _W=$R($s(2),_U,10);var _Y=$Z($s(2),"00");$P(_Y,2-_W.length,_W);$k[$j++]=_Y;$k[$j++]=_U+130}var _g=$a([$ctx.lC,$ctx.lB,$ctx.fnc1,$ctx.fnc2,$ctx.fnc3,$ctx.fnc4,$ctx.fnc1lD]);$k[$j++]=229;for(var _h=0,_i=_g.length;_h<_i;_h++){var _l=$f($k[--$j]+1);$k[$j++]=$g(_g,_h);$k[$j++]=_l;$k[$j++]=_l}$j--;$k[$j++]=$ctx.lX;$k[$j++]=238;$k[$j++]=$ctx.lT;$k[$j++]=239;$ctx.Avals=$d();$k[$j++]=Infinity;var _p=$ctx.Avals;for(var _u=_p.size,_t=_p.keys(),_s=0;_s<_u;_s++){var _q=_t.next().value;$k[$j++]=_q;$k[$j++]=_p.get(_q);$k[$j++]=Infinity;var _v=$k[--$j];var _w=$k[--$j];$k[$j++]=_v;$k[$j++]=_w;var _x=$a();$k[$j++]=_x}$ctx.Avals=$d();$k[$j++]=Infinity;$k[$j++]=$ctx.sft1;$k[$j++]=0;$k[$j++]=$ctx.sft2;$k[$j++]=1;$k[$j++]=$ctx.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _12=48;_12<=57;_12+=1){$k[$j++]=_12;$k[$j++]=_12-44}for(var _13=65;_13<=90;_13+=1){$k[$j++]=_13;$k[$j++]=_13-51}$ctx.CNvals=$d();$k[$j++]=Infinity;for(var _15=0;_15<=31;_15+=1){$k[$j++]=_15;$k[$j++]=_15}$ctx.C1vals=$d();$k[$j++]=Infinity;for(var _17=33;_17<=47;_17+=1){$k[$j++]=_17;$k[$j++]=_17-33}for(var _18=58;_18<=64;_18+=1){$k[$j++]=_18;$k[$j++]=_18-43}for(var _19=91;_19<=95;_19+=1){$k[$j++]=_19;$k[$j++]=_19-69}$k[$j++]=$ctx.fnc1;$k[$j++]=27;$k[$j++]=$ctx.fnc2;$k[$j++]=28;$k[$j++]=$ctx.fnc3;$k[$j++]=29;$k[$j++]=$ctx.fnc4;$k[$j++]=30;$k[$j++]=$ctx.pad;$k[$j++]=31;$ctx.C2vals=$d();$k[$j++]=Infinity;for(var _1G=96;_1G<=127;_1G+=1){$k[$j++]=_1G;$k[$j++]=_1G-96}$ctx.C3vals=$d();$k[$j++]=Infinity;var _1I=$ctx.CNvals;for(var _1N=_1I.size,_1M=_1I.keys(),_1L=0;_1L<_1N;_1L++){var _1J=_1M.next().value;$k[$j++]=_1J;$k[$j++]=_1I.get(_1J);$k[$j++]=Infinity;var _1O=$k[--$j];var _1P=$k[--$j];$k[$j++]=_1O;$k[$j++]=_1P;var _1Q=$a();$k[$j++]=_1Q}var _1R=$ctx.C1vals;for(var _1W=_1R.size,_1V=_1R.keys(),_1U=0;_1U<_1W;_1U++){var _1S=_1V.next().value;$k[$j++]=_1S;$k[$j++]=_1R.get(_1S);$k[$j++]=Infinity;var _1X=$k[--$j];var _1Y=$k[--$j];$k[$j++]=_1X;$k[$j++]=$g($ctx.CNvals,$ctx.sft1);$k[$j++]=_1Y;var _1c=$a();$k[$j++]=_1c}var _1d=$ctx.C2vals;for(var _1i=_1d.size,_1h=_1d.keys(),_1g=0;_1g<_1i;_1g++){var _1e=_1h.next().value;$k[$j++]=_1e;$k[$j++]=_1d.get(_1e);$k[$j++]=Infinity;var _1j=$k[--$j];var _1k=$k[--$j];$k[$j++]=_1j;$k[$j++]=$g($ctx.CNvals,$ctx.sft2);$k[$j++]=_1k;var _1o=$a();$k[$j++]=_1o}var _1p=$ctx.C3vals;for(var _1u=_1p.size,_1t=_1p.keys(),_1s=0;_1s<_1u;_1s++){var _1q=_1t.next().value;$k[$j++]=_1q;$k[$j++]=_1p.get(_1q);$k[$j++]=Infinity;var _1v=$k[--$j];var _1w=$k[--$j];$k[$j++]=_1v;$k[$j++]=$g($ctx.CNvals,$ctx.sft3);$k[$j++]=_1w;var _20=$a();$k[$j++]=_20}$ctx.Cvals=$d();$k[$j++]=Infinity;$k[$j++]=$ctx.sft1;$k[$j++]=0;$k[$j++]=$ctx.sft2;$k[$j++]=1;$k[$j++]=$ctx.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _25=48;_25<=57;_25+=1){$k[$j++]=_25;$k[$j++]=_25-44}for(var _26=97;_26<=122;_26+=1){$k[$j++]=_26;$k[$j++]=_26-83}$ctx.TNvals=$d();$k[$j++]=Infinity;for(var _28=0;_28<=31;_28+=1){$k[$j++]=_28;$k[$j++]=_28}$ctx.T1vals=$d();$k[$j++]=Infinity;for(var _2A=33;_2A<=47;_2A+=1){$k[$j++]=_2A;$k[$j++]=_2A-33}for(var _2B=58;_2B<=64;_2B+=1){$k[$j++]=_2B;$k[$j++]=_2B-43}for(var _2C=91;_2C<=95;_2C+=1){$k[$j++]=_2C;$k[$j++]=_2C-69}$k[$j++]=$ctx.fnc1;$k[$j++]=27;$k[$j++]=$ctx.fnc2;$k[$j++]=28;$k[$j++]=$ctx.fnc3;$k[$j++]=29;$k[$j++]=$ctx.fnc4;$k[$j++]=30;$k[$j++]=$ctx.pad;$k[$j++]=31;$ctx.T2vals=$d();$k[$j++]=Infinity;$k[$j++]=96;$k[$j++]=0;for(var _2J=65;_2J<=90;_2J+=1){$k[$j++]=_2J;$k[$j++]=_2J-64}for(var _2K=123;_2K<=127;_2K+=1){$k[$j++]=_2K;$k[$j++]=_2K-96}$ctx.T3vals=$d();$k[$j++]=Infinity;var _2M=$ctx.TNvals;for(var _2R=_2M.size,_2Q=_2M.keys(),_2P=0;_2P<_2R;_2P++){var _2N=_2Q.next().value;$k[$j++]=_2N;$k[$j++]=_2M.get(_2N);$k[$j++]=Infinity;var _2S=$k[--$j];var _2T=$k[--$j];$k[$j++]=_2S;$k[$j++]=_2T;var _2U=$a();$k[$j++]=_2U}var _2V=$ctx.T1vals;for(var _2a=_2V.size,_2Z=_2V.keys(),_2Y=0;_2Y<_2a;_2Y++){var _2W=_2Z.next().value;$k[$j++]=_2W;$k[$j++]=_2V.get(_2W);$k[$j++]=Infinity;var _2b=$k[--$j];var _2c=$k[--$j];$k[$j++]=_2b;$k[$j++]=$g($ctx.TNvals,$ctx.sft1);$k[$j++]=_2c;var _2g=$a();$k[$j++]=_2g}var _2h=$ctx.T2vals;for(var _2m=_2h.size,_2l=_2h.keys(),_2k=0;_2k<_2m;_2k++){var _2i=_2l.next().value;$k[$j++]=_2i;$k[$j++]=_2h.get(_2i);$k[$j++]=Infinity;var _2n=$k[--$j];var _2o=$k[--$j];$k[$j++]=_2n;$k[$j++]=$g($ctx.TNvals,$ctx.sft2);$k[$j++]=_2o;var _2s=$a();$k[$j++]=_2s}var _2t=$ctx.T3vals;for(var _2y=_2t.size,_2x=_2t.keys(),_2w=0;_2w<_2y;_2w++){var _2u=_2x.next().value;$k[$j++]=_2u;$k[$j++]=_2t.get(_2u);$k[$j++]=Infinity;var _2z=$k[--$j];var _30=$k[--$j];$k[$j++]=_2z;$k[$j++]=$g($ctx.TNvals,$ctx.sft3);$k[$j++]=_30;var _34=$a();$k[$j++]=_34}$ctx.Tvals=$d();for(var _36=128;_36<=255;_36+=1){$ctx.i=_36;$k[$j++]=$ctx.Avals;$k[$j++]=$ctx.i;$k[$j++]=Infinity;$q($g($ctx.Avals,$ctx.fnc4));$q($g($ctx.Avals,$ctx.i-128));var _3F=$a();var _3G=$k[--$j];$p($k[--$j],_3G,_3F);$k[$j++]=$ctx.Cvals;$k[$j++]=$ctx.i;$k[$j++]=Infinity;$q($g($ctx.Cvals,$ctx.fnc4));$q($g($ctx.Cvals,$ctx.i-128));var _3Q=$a();var _3R=$k[--$j];$p($k[--$j],_3R,_3Q);$k[$j++]=$ctx.Tvals;$k[$j++]=$ctx.i;$k[$j++]=Infinity;$q($g($ctx.Tvals,$ctx.fnc4));$q($g($ctx.Tvals,$ctx.i-128));var _3b=$a();var _3c=$k[--$j];$p($k[--$j],_3c,_3b)}$k[$j++]=Infinity;$k[$j++]=13;$k[$j++]=0;$k[$j++]=42;$k[$j++]=1;$k[$j++]=62;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _3e=48;_3e<=57;_3e+=1){$k[$j++]=_3e;$k[$j++]=_3e-44}for(var _3f=65;_3f<=90;_3f+=1){$k[$j++]=_3f;$k[$j++]=_3f-51}$ctx.Xvals=$d();$k[$j++]=Infinity;var _3h=$ctx.Xvals;for(var _3m=_3h.size,_3l=_3h.keys(),_3k=0;_3k<_3m;_3k++){var _3i=_3l.next().value;$k[$j++]=_3i;$k[$j++]=_3h.get(_3i);$k[$j++]=Infinity;var _3n=$k[--$j];var _3o=$k[--$j];$k[$j++]=_3n;$k[$j++]=_3o;var _3p=$a();$k[$j++]=_3p}$ctx.Xvals=$d();$k[$j++]=Infinity;for(var _3r=0;_3r<=255;_3r+=1){$k[$j++]=_3r;$k[$j++]=_3r}$ctx.Bvals=$d();$k[$j++]=Infinity;var _3t=$ctx.Bvals;for(var _3y=_3t.size,_3x=_3t.keys(),_3w=0;_3w<_3y;_3w++){var _3u=_3x.next().value;$k[$j++]=_3u;$k[$j++]=_3t.get(_3u);$k[$j++]=Infinity;var _3z=$k[--$j];var _40=$k[--$j];$k[$j++]=_3z;$k[$j++]=_40;var _41=$a();$k[$j++]=_41}$ctx.Bvals=$d();$ctx.encvals=$a([$ctx.Avals,$ctx.Cvals,$ctx.Tvals,$ctx.Xvals,-1,$ctx.Bvals]);$ctx.A=0;$ctx.C=1;$ctx.T=2;$ctx.X=3;$ctx.D=4;$ctx.B=5;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_codeone.$ctx[id]=$ctx[id]);bwipp_codeone.__22920__=1})()}if($1.stype){$F($1.barcode,function(){var _4C=$k[--$j];if(_4C<48||_4C>57){$k[$j++]="bwipp.codeoneStypeNonDigit#22926";$k[$j++]="S-Type symbols can only contain digits";bwipp_raiseerror()}});$1.barlen=$1.barcode.length;if($1.barlen>18){$k[$j++]="bwipp.codeoneStypeTooLong#22932";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$1.normalize=function(){$1.base=$k[--$j];$1.num=$k[--$j];for(var _4I=$1.num.length-1;_4I>=1;_4I-=1){$1.i=_4I;var _4J=$1.num;var _4K=$1.i;$p(_4J,_4K-1,$f($g(_4J,_4K-1)+~~($g($1.num,$1.i)/$1.base)));$p($1.num,$1.i,$g($1.num,$1.i)%$1.base)}for(;;){if($lt($g($1.num,0),$1.base)){break}$k[$j++]=Infinity;$k[$j++]=0;$F($1.num);$1.num=$a();$p($1.num,0,$f($g($1.num,0)+~~($g($1.num,1)/$1.base)));$p($1.num,1,$g($1.num,1)%$1.base)}$k[$j++]=Infinity;$1.i=true;var _4l=$1.num;for(var _4m=0,_4n=_4l.length;_4m<_4n;_4m++){var _4o=$g(_4l,_4m);$k[$j++]=_4o;if(_4o==0&&$1.i){$j--}else{$1.i=false}}$1.num=$a();if($1.num.length==0){$1.num=$a([0])}$k[$j++]=$1.num};$1.bigadd=function(){var _4u=$k[--$j];var _4v=$k[--$j];$1.offset=Math.abs(_4u.length-_4v.length);if(_4u.length<_4v.length){var _=_4u;_4u=_4v;_4v=_}$1.a=_4u;$1.b=_4v;for(var _4y=0,_4x=$1.b.length-1;_4y<=_4x;_4y+=1){var _4z=$1.a;var _50=$1.offset;$p(_4z,_4y+_50,$f($g(_4z,_4y+_50)+$g($1.b,_4y)))}$k[$j++]=$1.a};$1.barlen=$1.barcode.length;$1.v=$a([1]);for(var _59=0,_58=$1.barlen-1;_59<=_58;_59+=1){$1.i=_59;$k[$j++]=Infinity;$F($g($1.stypevals,$1.i),function(){var _5D=$k[--$j];$k[$j++]=$f(_5D-48)*$f($g($1.barcode,$1.barlen-$1.i-1)-48)});var _5I=$a();$k[$j++]=_5I;$k[$j++]=$1.v;$1.bigadd();$1.v=$k[--$j]}$k[$j++]="v";$k[$j++]=$1.v;$k[$j++]=2;$1.normalize();var _5M=$k[--$j];$1[$k[--$j]]=_5M;$k[$j++]=Infinity;for(var _5P=0,_5Q=(5-$1.v.length%5)%5;_5P<_5Q;_5P++){$k[$j++]=0}$q($1.v);$1.v=$a();$1.cws=$a(~~($1.v.length/5));for(var _5X=0,_5W=$1.cws.length-1;_5X<=_5W;_5X+=1){$1.i=_5X;var _5a=$G($1.v,$1.i*5,5);$k[$j++]=0;for(var _5b=0,_5c=_5a.length;_5b<_5c;_5b++){var _5e=$k[--$j];$k[$j++]=$f(_5e+$g(_5a,_5b))*2}$p($1.cws,$1.i,~~($k[--$j]/2))}$1.metrics=$1.stypemetrics}else{var _5n=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true],["FNC1",$1.fnc1],["FNC3",$1.fnc3]]);$1.fncvals=_5n;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _5q=$k[--$j];$1[$k[--$j]]=_5q;$1.msglen=$1.msg.length;$1.eciesc=92;var _5t=$1.msg;$k[$j++]="numecis";$k[$j++]=0;for(var _5u=0,_5v=_5t.length;_5u<_5v;_5u++){if($g(_5t,_5u)<=-1e6){var _5x=$k[--$j];$k[$j++]=$f(_5x+1)}}var _5y=$k[--$j];$1[$k[--$j]]=_5y;if($1.numecis>0){$1.msgtmp=$a($f($f($1.msg.length*2+$1.numecis*6)+2));$p($1.msgtmp,0,$1.pad);$p($1.msgtmp,1,$1.eciesc);$1.j=2;for(var _6A=0,_69=$1.msg.length-1;_6A<=_69;_6A+=1){var _6C=$g($1.msg,_6A);$k[$j++]=_6C;if(_6C<=-1e6){var _6G=$G($R($s(7),-$k[--$j],10),1,6);for(var _6H=0,_6I=_6G.length;_6H<_6I;_6H++){$k[$j++]=$g(_6G,_6H)}$as($a(6));$P($1.msgtmp,$1.j+1,$k[--$j]);$p($1.msgtmp,$1.j,$1.eciesc);$1.j=$1.j+7}else{var _6S=$k[--$j];$k[$j++]=_6S;if(_6S!=$1.eciesc){$p($1.msgtmp,$1.j,$k[--$j]);$1.j=$1.j+1}else{$j--;$p($1.msgtmp,$1.j,$1.eciesc);$p($1.msgtmp,$1.j+1,$1.eciesc);$1.j=$1.j+2}}}$1.msg=$G($1.msgtmp,0,$1.j);$1.msglen=$1.msg.length}$1.metrics=$1.nonstypemetrics;$1.fullcws=$a([]);var _6l=$1.metrics;for(var _6m=0,_6n=_6l.length;_6m<_6n;_6m++){$1.m=$g(_6l,_6m);$1.vers=$g($1.m,0);$1.dcws=$g($1.m,4);$1.okay=true;if($eq($1.version,"unset")){if($1.vers.length!=1){$1.okay=false}}else{if($ne($1.version,$1.vers)){$1.okay=false}}if($1.okay){$k[$j++]=Infinity;$q($1.fullcws);$k[$j++]=$1.dcws;$1.fullcws=$a()}}$k[$j++]=Infinity;for(var _71=0,_72=1480;_71<_72;_71++){$k[$j++]=1e4}$1.numremcws=$a();var _74=$1.fullcws;for(var _75=0,_76=_74.length;_75<_76;_75++){$p($1.numremcws,$f($g(_74,_75)-1),1)}for(var _79=1478;_79>=0;_79-=1){$1.i=_79;if($g($1.numremcws,$1.i)!=1){$p($1.numremcws,$1.i,$f($g($1.numremcws,$1.i+1)+1))}}$k[$j++]=Infinity;for(var _7J=0,_7K=$1.msglen;_7J<_7K;_7J++){$k[$j++]=0}$k[$j++]=0;$1.numD=$a();$k[$j++]=Infinity;for(var _7N=0,_7O=$1.msglen;_7N<_7O;_7N++){$k[$j++]=0}$k[$j++]=9999;$1.nextXterm=$a();$k[$j++]=Infinity;for(var _7R=0,_7S=$1.msglen;_7R<_7S;_7R++){$k[$j++]=0}$k[$j++]=9999;$1.nextNonX=$a();for(var _7V=$1.msglen-1;_7V>=0;_7V-=1){$1.i=_7V;$1.barchar=$g($1.msg,$1.i);if($1.barchar>=48&&$1.barchar<=57){$p($1.numD,$1.i,$f($g($1.numD,$1.i+1)+1))}if($1.barchar==13||$1.barchar==42||$1.barchar==62){$p($1.nextXterm,$1.i,0)}else{$p($1.nextXterm,$1.i,$f($g($1.nextXterm,$1.i+1)+1))}var _7s=$g($1.Xvals,$1.barchar)!==undefined;if(!_7s){$p($1.nextNonX,$1.i,0)}else{$p($1.nextNonX,$1.i,$f($g($1.nextNonX,$1.i+1)+1))}}$k[$j++]=Infinity;var _80=$1.nextXterm;for(var _81=0,_82=_80.length;_81<_82;_81++){var _83=$g(_80,_81);$k[$j++]=_83;if(_83>1e4){$j--;$k[$j++]=1e4}}$1.nextXterm=$a();$k[$j++]=Infinity;var _85=$1.nextNonX;for(var _86=0,_87=_85.length;_86<_87;_86++){var _88=$g(_85,_86);$k[$j++]=_88;if(_88>1e4){$j--;$k[$j++]=1e4}}$1.nextNonX=$a();$1.isD=function(){$k[$j++]=$1.char>=48&&$1.char<=57};$1.isC=function(){var _8E=$g($1.CNvals,$1.char)!==undefined;$k[$j++]=_8E};$1.isT=function(){var _8H=$g($1.TNvals,$1.char)!==undefined;$k[$j++]=_8H};$1.isX=function(){var _8K=$g($1.Xvals,$1.char)!==undefined;$k[$j++]=_8K};$1.isEA=function(){$k[$j++]=$1.char>127};$1.isFN=function(){$k[$j++]=$1.char<0};$1.XtermFirst=function(){var _8N=$k[--$j];$k[$j++]=$lt($g($1.nextXterm,_8N),$g($1.nextNonX,_8N))};$1.lookup=function(){$1.ac=1;$1.cc=2;$1.tc=2;$1.xc=2;$1.bc=3;if($1.mode==$1.A){$1.ac=0;$1.cc=1;$1.tc=1;$1.xc=1;$1.bc=2}if($1.mode==$1.C){$1.cc=0}if($1.mode==$1.T){$1.tc=0}if($1.mode==$1.X){$1.xc=0}if($1.mode==$1.B){$1.bc=0}for(var _8c=0,_8d=1;_8c<_8d;_8c++){$1.k=0;for(;;){if($1.i+$1.k==$1.msglen){var _8l=$a([$1.ac,$1.cc,$1.tc,$1.xc]);$k[$j++]=true;for(var _8m=0,_8n=_8l.length;_8m<_8n;_8m++){var _8q=$k[--$j];$k[$j++]=_8q&&$1.bc<=Math.ceil($g(_8l,_8m))}if($k[--$j]){$k[$j++]=$1.B;break}var _8x=$a([$1.cc,$1.tc,$1.xc,$1.bc]);$k[$j++]=true;for(var _8y=0,_8z=_8x.length;_8y<_8z;_8y++){var _92=$k[--$j];$k[$j++]=_92&&$1.ac<=Math.ceil($g(_8x,_8y))}if($k[--$j]){$k[$j++]=$1.A;break}var _97=$a([$1.tc,$1.xc]);$k[$j++]=true;for(var _98=0,_99=_97.length;_98<_99;_98++){var _9C=$k[--$j];$k[$j++]=_9C&&Math.ceil($1.cc)<=Math.ceil($g(_97,_98))}if($k[--$j]){$k[$j++]=$1.C;break}var _9G=$a([$1.xc]);$k[$j++]=true;for(var _9H=0,_9I=_9G.length;_9H<_9I;_9H++){var _9L=$k[--$j];$k[$j++]=_9L&&Math.ceil($1.tc)<=Math.ceil($g(_9G,_9H))}if($k[--$j]){$k[$j++]=$1.T;break}$k[$j++]=$1.X;break}$1.char=$g($1.msg,$1.i+$1.k);$k[$j++]="ac";$k[$j++]=$1.ac;$1.isD();if($k[--$j]){var _9V=$k[--$j];$k[$j++]=$f(_9V+1/2)}else{$1.isEA();if($k[--$j]){var _9X=$k[--$j];$k[$j++]=Math.ceil(_9X)+2}else{var _9Y=$k[--$j];$k[$j++]=Math.ceil(_9Y)+1}}var _9Z=$k[--$j];$1[$k[--$j]]=_9Z;$k[$j++]="cc";$k[$j++]=$1.cc;$1.isC();if($k[--$j]){var _9d=$k[--$j];$k[$j++]=$f(_9d+.6666667)}else{$1.isEA();if($k[--$j]){var _9f=$k[--$j];$k[$j++]=$f(_9f+2.6666667)}else{var _9g=$k[--$j];$k[$j++]=$f(_9g+1.3333334)}}var _9h=$k[--$j];$1[$k[--$j]]=_9h;$k[$j++]="tc";$k[$j++]=$1.tc;$1.isT();if($k[--$j]){var _9l=$k[--$j];$k[$j++]=$f(_9l+.6666667)}else{$1.isEA();if($k[--$j]){var _9n=$k[--$j];$k[$j++]=$f(_9n+2.6666667)}else{var _9o=$k[--$j];$k[$j++]=$f(_9o+1.3333334)}}var _9p=$k[--$j];$1[$k[--$j]]=_9p;$k[$j++]="xc";$k[$j++]=$1.xc;$1.isX();if($k[--$j]){var _9t=$k[--$j];$k[$j++]=$f(_9t+.6666667)}else{$1.isEA();if($k[--$j]){var _9v=$k[--$j];$k[$j++]=$f(_9v+4.3333334)}else{var _9w=$k[--$j];$k[$j++]=$f(_9w+3.3333334)}}var _9x=$k[--$j];$1[$k[--$j]]=_9x;$k[$j++]="bc";$k[$j++]=$1.bc;$1.isFN();if($k[--$j]){var _A1=$k[--$j];$k[$j++]=$f(_A1+3)}else{var _A2=$k[--$j];$k[$j++]=$f(_A2+1)}var _A3=$k[--$j];$1[$k[--$j]]=_A3;if($1.k>=3){var _AA=$a([$1.ac,$1.cc,$1.tc,$1.xc]);$k[$j++]=true;for(var _AB=0,_AC=_AA.length;_AB<_AC;_AB++){var _AF=$k[--$j];$k[$j++]=_AF&&$1.bc+1<=Math.ceil($g(_AA,_AB))}if($k[--$j]){$k[$j++]=$1.B;break}var _AM=$a([$1.cc,$1.tc,$1.xc,$1.bc]);$k[$j++]=true;for(var _AN=0,_AO=_AM.length;_AN<_AO;_AN++){var _AR=$k[--$j];$k[$j++]=_AR&&$1.ac+1<=Math.ceil($g(_AM,_AN))}if($k[--$j]){$k[$j++]=$1.A;break}var _AY=$a([$1.ac,$1.cc,$1.xc,$1.bc]);$k[$j++]=true;for(var _AZ=0,_Aa=_AY.length;_AZ<_Aa;_AZ++){var _Ad=$k[--$j];$k[$j++]=_Ad&&Math.ceil($1.tc)+1<=Math.ceil($g(_AY,_AZ))}if($k[--$j]){$k[$j++]=$1.T;break}var _Ai=$a([$1.ac,$1.tc]);$k[$j++]=true;for(var _Aj=0,_Ak=_Ai.length;_Aj<_Ak;_Aj++){var _An=$k[--$j];$k[$j++]=_An&&Math.ceil($1.cc)+1<=Math.ceil($g(_Ai,_Aj))}if($k[--$j]){if(Math.ceil($1.cc)<Math.ceil($1.xc)){$k[$j++]=$1.C;break}if($1.cc==$1.xc){$k[$j++]=$1.i+$1.k+1;$1.XtermFirst();if($k[--$j]){$k[$j++]=$1.X;break}else{$k[$j++]=$1.C;break}}}var _B3=$a([$1.ac,$1.cc,$1.tc,$1.bc]);$k[$j++]=true;for(var _B4=0,_B5=_B3.length;_B4<_B5;_B4++){var _B8=$k[--$j];$k[$j++]=_B8&&Math.ceil($1.xc)+1<=Math.ceil($g(_B3,_B4))}if($k[--$j]){$k[$j++]=$1.X;break}}$1.k=$1.k+1}}};$1.addtocws=function(){var _BC=$k[--$j];$k[$j++]=_BC;if(_BC.length+$1.j>1480){$j--;$k[$j++]="bwipp.codeoneTooLong#23128";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}var _BE=$k[--$j];$P($1.cws,$1.j,_BE);$1.j=_BE.length+$1.j};$1.tobin=function(){var _BJ=$s($k[--$j]);$k[$j++]=_BJ;for(var _BL=0,_BK=_BJ.length-1;_BL<=_BK;_BL+=1){var _BM=$k[--$j];$p(_BM,_BL,48);$k[$j++]=_BM}var _BN=$k[--$j];var _BQ=$R($s(_BN.length),$k[--$j],2);$P(_BN,_BN.length-_BQ.length,_BQ);$k[$j++]=_BN;$k[$j++]=Infinity;var _BR=$k[--$j];var _BS=$k[--$j];$k[$j++]=_BR;$F(_BS,function(){var _BT=$k[--$j];$k[$j++]=$f(_BT-48)});var _BU=$a();$k[$j++]=_BU};$1.encA=function(){for(var _BV=0,_BW=1;_BV<_BW;_BV++){if($g($1.numD,$1.i)>=21){$1.Dbits=$a([1,1,1,1]);$1.mode=$1.D;break}var _Be=$g($1.numD,$1.i);if(_Be>=13&&$f(_Be+$1.i)==$1.msglen){$1.Dbits=$a([1,1,1,1]);$1.mode=$1.D;break}if($g($1.numD,$1.i)>=2){var _Bm=$s(2);$p(_Bm,0,$g($1.msg,$1.i));$p(_Bm,1,$g($1.msg,$1.i+1));$k[$j++]=$g($1.Avals,_Bm);$1.addtocws();$1.i=$1.i+2;break}if($g($1.msg,$1.i)==$1.fnc1){if($g($1.numD,$1.i+1)>=15){$k[$j++]=$g($1.Avals,$1.fnc1lD);$1.addtocws();$1.i=$1.i+1;$1.Dbits=$a([]);$1.mode=$1.D;break}var _CB=$g($1.numD,$1.i+1);if(_CB>=7&&$f($f(_CB+$1.i)+1)==$1.msglen){$k[$j++]=$g($1.Avals,$1.fnc1lD);$1.addtocws();$1.i=$1.i+1;$1.Dbits=$a([]);$1.mode=$1.D;break}}$k[$j++]="newmode";$1.lookup();var _CK=$k[--$j];$1[$k[--$j]]=_CK;if($1.newmode!=$1.mode){$k[$j++]=$g($1.Avals,$g($a([-1,$1.lC,$1.lT,$1.lX,$1.lD,$1.lB]),$1.newmode));$1.addtocws();$1.mode=$1.newmode;break}$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.i=$1.i+1;break}};$1.CTXvalstocws=function(){$1.in=$k[--$j];$k[$j++]=Infinity;for(var _Ci=0,_Ch=$1.in.length-1;_Ci<=_Ch;_Ci+=3){var _Ck=$G($1.in,_Ci,3);$k[$j++]=0;for(var _Cl=0,_Cm=_Ck.length;_Cl<_Cm;_Cl++){var _Co=$k[--$j];$k[$j++]=$f(_Co+$g(_Ck,_Cl))*40}var _Cq=~~($k[--$j]/40)+1;$k[$j++]=~~(_Cq/256);$k[$j++]=_Cq%256}$as($a($m()));var _Ct=$k[--$j];var _Cu=$k[--$j];$k[$j++]=_Ct;$k[$j++]=_Cu;$j--};$1.encCTX=function(){$1.p=0;$1.ctxvals=$a(2220);for(;;){if($1.i==$1.msglen){break}if($1.p%3==0){if($g($1.numD,$1.i)>=12){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$1.mode=$1.A;break}var _DA=$g($1.numD,$1.i);if(_DA>=8&&$f(_DA+$1.i)==$1.msglen){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$1.mode=$1.A;break}if($1.mode==$1.X){var _DP=$g($1.Xvals,$g($1.msg,$1.i))!==undefined;if(!_DP){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();if($g($1.numremcws,$1.j)!=1||$g($1.msg,$1.i)>127){$k[$j++]=$a([$1.unlcw]);$1.addtocws()}$1.mode=$1.A;break}if($1.i+1<$1.msglen){var _Di=$g($1.Xvals,$g($1.msg,$1.i+1))!==undefined;if(!_Di){break}if($1.i+2<$1.msglen){var _Dp=$g($1.Xvals,$g($1.msg,$1.i+2))!==undefined;if(!_Dp){break}}}}else{$1.lookup();if($k[--$j]!=$1.mode){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$1.mode=$1.A;break}}if($1.msglen-$1.i<=3){$1.remcws=$g($1.numremcws,$1.j+~~($1.p/3)*2);$k[$j++]=Infinity;var _E8=$G($1.msg,$1.i,$1.msglen-$1.i);for(var _E9=0,_EA=_E8.length;_E9<_EA;_E9++){var _EB=$g(_E8,_E9);var _EF=$g($g($1.encvals,$1.mode),_EB)!==undefined;$k[$j++]=_EB;if(_EF){$q($g($g($1.encvals,$1.mode),$k[--$j]))}else{$j--;$k[$j++]=-1;$k[$j++]=-1;$k[$j++]=-1;$k[$j++]=-1}}$1.remvals=$a();if($1.remcws==2&&$1.remvals.length==3){$k[$j++]=Infinity;$q($G($1.ctxvals,0,$1.p));$q($1.remvals);var _ES=$a();$k[$j++]=_ES;$1.CTXvalstocws();$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;break}if($1.remcws==2&&$1.remvals.length==2&&$1.mode!=$1.X){$k[$j++]=Infinity;$q($G($1.ctxvals,0,$1.p));$q($1.remvals);$q($g($g($1.encvals,$1.mode),$1.sft1));var _Ei=$a();$k[$j++]=_Ei;$1.CTXvalstocws();$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;break}if($1.remcws==2&&$1.remvals.length==1){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;break}if($1.remcws==1&&$1.remvals.length==1){$k[$j++]=$G($1.ctxvals,0,$1.p);$1.CTXvalstocws();$1.addtocws();$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.mode=$1.A;$1.i=$1.msglen;break}}}var _FH=$g($g($1.encvals,$1.mode),$g($1.msg,$1.i));$P($1.ctxvals,$1.p,_FH);$1.p=_FH.length+$1.p;$1.i=$1.i+1}if($1.mode!=$1.A){for(;;){if($1.p%3==0){break}$1.i=$1.i-1;$1.p=$1.p-$g($g($1.encvals,$1.mode),$g($1.msg,$1.i)).length}$k[$j++]=Infinity;$q($G($1.ctxvals,0,$1.p));var _Fb=$a();$k[$j++]=_Fb;$1.CTXvalstocws();$1.addtocws();$k[$j++]=$a([$1.unlcw]);$1.addtocws();$1.mode=$1.A;if($1.i!=$1.msglen){if($g($1.numD,$1.i)>=2){var _Fk=$s(2);$p(_Fk,0,$g($1.msg,$1.i));$p(_Fk,1,$g($1.msg,$1.i+1));$k[$j++]=$g($1.Avals,_Fk);$1.addtocws();$1.i=$1.i+2}else{$k[$j++]=$g($1.Avals,$g($1.msg,$1.i));$1.addtocws();$1.i=$1.i+1}}}};$1.encD=function(){for(;;){if($g($1.numD,$1.i)<3){$1.Drem=(8-$1.Dbits.length%8)%8;$1.remcws=$g($1.numremcws,$1.j+~~($1.Dbits.length/8));if(($f($g($1.numremcws,$1.j+~~($1.Dbits.length/8)-1)-1)==0&&$1.Drem==0||$1.remcws==1&&$1.Drem!=0)&&$1.i==$1.msglen){if($1.Drem==4||$1.Drem==6){$k[$j++]=Infinity;$q($1.Dbits);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$1.Dbits=$a()}if($1.Drem==2||$1.Drem==6){$k[$j++]=Infinity;$q($1.Dbits);$k[$j++]=0;$k[$j++]=1;$1.Dbits=$a()}break}if(($1.i==$1.msglen-1&&$g($1.numD,$1.i)==1||$1.i==$1.msglen-2&&$g($1.numD,$1.i)==2)&&$1.remcws==1&&$1.Drem==0){break}if(!($1.i==$1.msglen-1&&$g($1.numD,$1.i)==1&&$1.remcws==1&&($1.Drem==4||$1.Drem==6))){$k[$j++]=Infinity;$q($1.Dbits);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$1.Dbits=$a();$1.Drem=(8-$1.Dbits.length%8)%8}if($1.Drem==4||$1.Drem==6){if($g($1.numD,$1.i)>=1){$k[$j++]=Infinity;$q($1.Dbits);$k[$j++]=$f($f($g($1.msg,$1.i)-48)+1);$k[$j++]=4;$1.tobin();$q($k[--$j]);$1.Dbits=$a();$1.i=$1.i+1}else{$k[$j++]=Infinity;$q($1.Dbits);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$1.Dbits=$a()}$1.Drem=$1.Drem-4}if($1.Drem==2){$k[$j++]=Infinity;$q($1.Dbits);$k[$j++]=0;$k[$j++]=1;$1.Dbits=$a();$1.Drem=0}break}$k[$j++]=Infinity;$q($1.Dbits);var _H7=$G($1.msg,$1.i,3);$k[$j++]=0;for(var _H8=0,_H9=_H7.length;_H8<_H9;_H8++){var _HB=$k[--$j];$k[$j++]=$f(_HB+$f($g(_H7,_H8)-48))*10}var _HC=$k[--$j];$k[$j++]=~~(_HC/10)+1;$k[$j++]=10;$1.tobin();$q($k[--$j]);$1.Dbits=$a();$1.i=$1.i+3}$k[$j++]=Infinity;for(var _HI=0,_HH=$1.Dbits.length-1;_HI<=_HH;_HI+=8){var _HK=$G($1.Dbits,_HI,8);$k[$j++]=0;for(var _HL=0,_HM=_HK.length;_HL<_HM;_HL++){var _HO=$k[--$j];$k[$j++]=$f(_HO+$g(_HK,_HL))*2}var _HP=$k[--$j];$k[$j++]=~~(_HP/2)}$as($a($m()));var _HS=$k[--$j];var _HT=$k[--$j];$k[$j++]=_HS;$k[$j++]=_HT;$j--;$1.addtocws();$1.mode=$1.A};$1.encB=function(){$1.p=0;$1.bvals=$a(1480);for(;;){if($1.i==$1.msglen){break}if($g($1.msg,$1.i)<0){break}$1.lookup();if($k[--$j]!=$1.mode){break}$p($1.bvals,$1.p,$g($1.msg,$1.i));$1.p=$1.p+1;$1.i=$1.i+1}$1.remcws=$f($g($1.numremcws,$1.j+$1.p)-1);$k[$j++]=Infinity;if($1.remcws==0&&$1.i==$1.msglen){$k[$j++]=0}else{if($1.p<250){$k[$j++]=$1.p}else{$k[$j++]=~~($1.p/250)+249;$k[$j++]=$1.p%250}}$q($G($1.bvals,0,$1.p));$1.bvals=$a();$k[$j++]=$1.bvals;$1.addtocws();$1.mode=$1.A};$1.cws=$a(1480);$1.mode=$1.A;$1.i=0;$1.j=0;for(;;){if($1.i>=$1.msglen){break}if($1[$g($a(["encA","encCTX","encCTX","encCTX","encD","encB"]),$1.mode)]()===true){break}}$1.cws=$G($1.cws,0,$1.j)}var _IC=$1.metrics;for(var _ID=0,_IE=_IC.length;_ID<_IE;_ID++){$1.m=$g(_IC,_ID);$1.vers=$g($1.m,0);$1.rows=$g($1.m,1);$1.cols=$g($1.m,2);$1.dcol=$g($1.m,3);$1.dcws=$g($1.m,4);$1.rscw=$g($1.m,5);$1.rsbl=$g($1.m,6);$1.riso=$g($1.m,7);$1.risi=$g($1.m,8);$1.risl=$g($1.m,9);$1.dcpb=~~($1.dcws/$1.rsbl);$1.ecpb=~~($1.rscw/$1.rsbl);$1.okay=true;if($ne($1.version,"unset")&&$ne($1.version,$1.vers)){$1.okay=false}if($1.cws.length>$1.dcws){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.codeoneNoValidSymbol#23444";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}if(!$1.stype){$k[$j++]=Infinity;$q($1.cws);for(var _Ip=0,_Iq=$f($1.dcws-$1.cws.length);_Ip<_Iq;_Ip++){$k[$j++]=129}$1.cws=$a()}else{$k[$j++]=Infinity;for(var _Iu=0,_Iv=$f($1.dcws-$1.cws.length);_Iu<_Iv;_Iu++){$k[$j++]=0}$q($1.cws);$1.cws=$a()}var _Iz=$g($1.options,"debugcws")!==undefined;if(_Iz){$k[$j++]="bwipp.debugcws#23454";$k[$j++]=$1.cws;bwipp_raiseerror()}$1.cwbs=$a($1.rsbl);$1.ecbs=$a($1.rsbl);for(var _J7=0,_J6=$f($1.rsbl-1);_J7<=_J6;_J7+=1){$1.i=_J7;$1.cwb=$a($1.dcpb);for(var _JC=0,_JB=$1.dcpb-1;_JC<=_JB;_JC+=1){$1.j=_JC;$p($1.cwb,$1.j,$g($1.cws,$f($1.j*$1.rsbl+$1.i)))}$p($1.cwbs,$1.i,$1.cwb)}var _JO=$1.stype?32:256;$1.gf=_JO;$1["gf-1"]=$1.gf-1;var _JR=$1.stype?37:301;$1.pm=_JR;$k[$j++]=Infinity;$k[$j++]=1;for(var _JT=0,_JU=$1["gf-1"];_JT<_JU;_JT++){var _JV=$k[--$j];var _JW=_JV*2;$k[$j++]=_JV;$k[$j++]=_JW;if(_JW>=$1.gf){var _JZ=$k[--$j];$k[$j++]=_JZ^$1.pm}}$1.rsalog=$a();$1.rslog=$a($1.gf);for(var _Jf=1,_Je=$1["gf-1"];_Jf<=_Je;_Jf+=1){$p($1.rslog,$g($1.rsalog,_Jf),_Jf)}$1.rsprod=function(){var _Jj=$k[--$j];var _Jk=$k[--$j];$k[$j++]=_Jk;$k[$j++]=_Jj;if(_Jj!=0&&_Jk!=0){var _Jn=$g($1.rslog,$k[--$j]);var _Jt=$g($1.rsalog,$f(_Jn+$g($1.rslog,$k[--$j]))%$1["gf-1"]);$k[$j++]=_Jt}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Jv=0,_Jw=$1.ecpb;_Jv<_Jw;_Jv++){$k[$j++]=0}$1.coeffs=$a();for(var _K0=0,_Jz=$1.ecpb-1;_K0<=_Jz;_K0+=1){$1.i=_K0;$p($1.coeffs,$1.i+1,$g($1.coeffs,$1.i));for(var _K7=$1.i;_K7>=1;_K7-=1){$1.j=_K7;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _KJ=$k[--$j];var _KK=$k[--$j];var _KL=$k[--$j];$p($k[--$j],_KL,$xo(_KK,_KJ))}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _KT=$k[--$j];var _KU=$k[--$j];$p($k[--$j],_KU,_KT)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);for(var _Kb=0,_Ka=$1.cwbs.length-1;_Kb<=_Ka;_Kb+=1){$1.i=_Kb;$k[$j++]=Infinity;$q($g($1.cwbs,$1.i));for(var _Kg=0,_Kh=$1.ecpb;_Kg<_Kh;_Kg++){$k[$j++]=0}$1.rscws=$a();for(var _Kl=0,_Kk=$1.dcpb-1;_Kl<=_Kk;_Kl+=1){$1.m=_Kl;$1.k=$g($1.rscws,$1.m);for(var _Kr=0,_Kq=$1.ecpb-1;_Kr<=_Kq;_Kr+=1){$1.j=_Kr;$k[$j++]=$1.rscws;$k[$j++]=$1.m+$1.j+1;$k[$j++]=$g($1.coeffs,$1.ecpb-$1.j-1);$k[$j++]=$1.k;$1.rsprod();var _L4=$k[--$j];var _L5=$k[--$j];$p($k[--$j],_L5,$xo(_L4,$g($1.rscws,$1.m+$1.j+1)))}}$p($1.ecbs,$1.i,$G($1.rscws,$1.dcpb,$1.ecpb))}$k[$j++]=Infinity;$q($1.cws);for(var _LF=0,_LG=$1.rscw;_LF<_LG;_LF++){$k[$j++]=0}$1.cws=$a();for(var _LK=0,_LJ=$f($1.rscw-1);_LK<=_LJ;_LK+=1){$1.i=_LK;$p($1.cws,$f($1.dcws+$1.i),$g($g($1.ecbs,$1.i%$1.rsbl),~~($1.i/$1.rsbl)))}var _LY=$1.stype?5:8;$1.mmat=$a($f($1.dcws+$1.rscw)*_LY);$1.r=0;$1.c=0;var _Lb=$1.stype?2:1;for(var _Le=0,_Lf=_Lb,_Ld=$1.cws.length-1;_Lf<0?_Le>=_Ld:_Le<=_Ld;_Le+=_Lf){$1.i=_Le;if(!$1.stype){var _Li=$Z($s(8),"00000000");var _Ln=$R($s(8),$g($1.cws,$1.i),2);$P(_Li,8-_Ln.length,_Ln);$k[$j++]=_Li;$k[$j++]=Infinity;var _Lo=$k[--$j];var _Lp=$k[--$j];$k[$j++]=_Lo;$F(_Lp,function(){var _Lq=$k[--$j];$k[$j++]=$f(_Lq-48)});var _Lr=$a();$1.top=$G(_Lr,0,4);$1.bot=$G(_Lr,4,4)}else{var _Lv=$Z($s(5),"00000");var _M0=$R($s(5),$g($1.cws,$1.i),2);$P(_Lv,5-_M0.length,_M0);$k[$j++]=_Lv;$k[$j++]=Infinity;var _M1=$k[--$j];var _M2=$k[--$j];$k[$j++]=_M1;$F(_M2,function(){var _M3=$k[--$j];$k[$j++]=$f(_M3-48)});$1.c1=$a();var _M6=$Z($s(5),"00000");var _MB=$R($s(5),$g($1.cws,$1.i+1),2);$P(_M6,5-_MB.length,_MB);$k[$j++]=_M6;$k[$j++]=Infinity;var _MC=$k[--$j];var _MD=$k[--$j];$k[$j++]=_MC;$F(_MD,function(){var _ME=$k[--$j];$k[$j++]=$f(_ME-48)});$1.c2=$a();$k[$j++]=Infinity;$q($G($1.c1,0,3));$q($G($1.c2,0,2));$1.top=$a();$k[$j++]=Infinity;$q($G($1.c1,3,2));$q($G($1.c2,2,3));$1.bot=$a()}$P($1.mmat,$f($1.r*$1.dcol+$1.c),$1.top);$P($1.mmat,$f(($1.r+1)*$1.dcol+$1.c),$1.bot);$1.c=$1.c+$1.top.length;if($1.c==$1.dcol){$1.c=0;$1.r=$1.r+2}}$1.mmv=function(){var _Mg=$k[--$j];var _Mh=$k[--$j];$k[$j++]=$f(_Mh+_Mg*$1.cols)};$k[$j++]=Infinity;for(var _Mk=0,_Ml=$1.rows*$1.cols;_Mk<_Ml;_Mk++){$k[$j++]=-1}$1.pixs=$a();var _NH=$a([function(){for(var _Mo=0,_Mp=$1.cols;_Mo<_Mp;_Mo++){$k[$j++]=0}},function(){for(var _Mr=0,_Ms=$1.cols;_Mr<_Ms;_Mr++){$k[$j++]=1}},function(){$k[$j++]=0;for(var _Mu=0,_Mv=$f($1.cols-2);_Mu<_Mv;_Mu++){$k[$j++]=1}$k[$j++]=0},function(){$k[$j++]=0;$k[$j++]=1;for(var _Mx=0,_My=$f($1.cols-4);_Mx<_My;_Mx++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0},function(){for(var _N0=0,_N1=~~($f($1.cols-1)/2);_N0<_N1;_N0++){$k[$j++]=-1}$k[$j++]=1;for(var _N3=0,_N4=~~($f($1.cols-1)/2);_N3<_N4;_N3++){$k[$j++]=-1}},function(){for(var _N6=0,_N7=~~($f($1.cols-1)/2);_N6<_N7;_N6++){$k[$j++]=-1}$k[$j++]=0;for(var _N9=0,_NA=~~($f($1.cols-1)/2);_N9<_NA;_N9++){$k[$j++]=-1}},function(){$k[$j++]=1;for(var _NC=0,_ND=$f($1.cols-2);_NC<_ND;_NC++){$k[$j++]=0}$k[$j++]=1},function(){$k[$j++]=1;$k[$j++]=0;for(var _NF=0,_NG=$f($1.cols-4);_NF<_NG;_NF++){$k[$j++]=1}$k[$j++]=0;$k[$j++]=1}]);$1.artifact=_NH;if(!bwipp_codeone.__23573__){(function(){var $ctx=Object.create($1);var _NI=new Map([["A","121343"],["B","12134343"],["C","12121343"],["D","1213434343"],["E","1212134343"],["F","1212121343"],["G","121213434343"],["H","121212134343"],["S","56661278"],["T","5666666666127878"]]);$ctx.cpatmap=_NI;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_codeone.$ctx[id]=$ctx[id]);bwipp_codeone.__23573__=1})()}$1.cpat=$g($1.cpatmap,$G($1.vers,0,1));$k[$j++]=$1.pixs;$k[$j++]=0;$k[$j++]=~~($f($1.rows-$1.cpat.length)/2);$1.mmv();$k[$j++]=Infinity;$F($1.cpat,function(){if($g($1.artifact,$f($k[--$j]-49))()===true){return true}});var _NV=$a();var _NW=$k[--$j];$P($k[--$j],_NW,_NV);for(var _Na=0,_NZ=$f($1.risl-1);_Na<=_NZ;_Na+=1){$1.i=_Na;for(var _Nf=$1.riso,_Ng=$1.risi,_Ne=$f($1.cols-1);_Ng<0?_Nf>=_Ne:_Nf<=_Ne;_Nf+=_Ng){$1.j=_Nf;var _Ni=$1.i%12==0?1:0;var _Nj=$a([1,_Ni]);$k[$j++]=_Nj;$k[$j++]=_Nj;$k[$j++]=$1.pixs;$k[$j++]=$1.j;$k[$j++]=$1.i;$1.mmv();var _Nn=$k[--$j];var _No=$k[--$j];$P(_No,_Nn,$k[--$j]);if($1.i!=$f($1.risl-1)){$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.cols-$1.j)-2);$k[$j++]=$f($f($1.rows-$1.i)-1);$1.mmv();var _Nx=$k[--$j];var _Ny=$k[--$j];$P(_Ny,_Nx,$k[--$j])}else{$j--}}}if(!bwipp_codeone.__23611__){(function(){var $ctx=Object.create($1);var _Od=new Map([["A",$a([$a([12,5])])],["B",$a([$a([16,7])])],["C",$a([$a([26,12])])],["D",$a([])],["E",$a([$a([26,23])])],["F",$a([$a([26,32]),$a([70,32]),$a([26,34]),$a([70,34])])],["G",$a([$a([27,48]),$a([69,48])])],["H",$a([$a([26,70]),$a([66,70]),$a([106,70]),$a([26,72]),$a([66,72]),$a([106,72])])],["S-10",$a([])],["S-20",$a([$a([10,4])])],["S-30",$a([$a([15,4]),$a([15,6])])],["T-16",$a([$a([8,10])])],["T-32",$a([$a([16,10]),$a([16,12])])],["T-48",$a([$a([24,10]),$a([24,12]),$a([24,14])])]]);$ctx.blackdotmap=_Od;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_codeone.$ctx[id]=$ctx[id]);bwipp_codeone.__23611__=1})()}$F($g($1.blackdotmap,$1.vers),function(){var _Oj=$k[--$j];$k[$j++]=$1.pixs;$q(_Oj);$1.mmv();var _Ok=$k[--$j];$p($k[--$j],_Ok,1)});$1.j=0;for(var _Oo=0,_On=$1.pixs.length-1;_Oo<=_On;_Oo+=1){$1.i=_Oo;if($g($1.pixs,$1.i)==-1){$p($1.pixs,$1.i,$g($1.mmat,$1.j));$1.j=$1.j+1}}var _P4=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.cols],["pixy",$1.rows],["height",$1.rows/72*2],["width",$1.cols/72*2],["opt",$1.options]]);$k[$j++]=_P4;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hanxin(){var $1=Object.create(bwipp_hanxin.$ctx||(bwipp_hanxin.$ctx={}));$1.dontdraw=false;$1.version="unset";$1.eclevel="L2";$1.parse=false;$1.parsefnc=false;$1.mask=-1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($eq($1.barcode,"")){$k[$j++]="bwipp.hanxinEmptyData#23684";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($ne($1.version,"unset")){var _5=$1.version.length;var _6=_5>=1&&_5<=2;$k[$j++]=_6;if(_6){$j--;var _7=$1.version;$k[$j++]=true;for(var _8=0,_9=_7.length;_8<_9;_8++){var _A=$g(_7,_8);if(_A<48||_A>57){$j--;$k[$j++]=false}}var _B=$k[--$j];$k[$j++]=_B;if(_B){$j--;var _D=$i($1.version);$k[$j++]=_D>=1&&_D<=84}}if($nt($k[--$j])){$k[$j++]="bwipp.hanxinInvalidVersion#23695";$k[$j++]="Valid versions are 1 to 84";bwipp_raiseerror()}}var _G=$1.eclevel.length==2;$k[$j++]=_G;if(_G){$j--;$k[$j++]=$G($1.eclevel,0,1);if($eq("L","L")){$j--;var _L=$g($1.eclevel,1)-48;$k[$j++]=_L>=1&&_L<=4}}if($nt($k[--$j])){$k[$j++]="bwipp.hanxinInvalidErrorCorrectionLevel#23705";$k[$j++]="Valid error correction levels are L1 to L4";bwipp_raiseerror()}if($1.mask!=-1){if($1.mask<1||$1.mask>4){$k[$j++]="bwipp.hanxinInvalidErrorCorrectionLevel#23710";$k[$j++]="The valid masks are 1 to 4";bwipp_raiseerror()}}var _S=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc]]);$1.fncvals=_S;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _V=$k[--$j];$1[$k[--$j]]=_V;$1.msglen=$1.msg.length;$1.tobin=function(){var _Z=$s($k[--$j]);$k[$j++]=_Z;for(var _b=0,_a=_Z.length-1;_b<=_a;_b+=1){var _c=$k[--$j];$p(_c,_b,48);$k[$j++]=_c}var _d=$k[--$j];var _g=$R($s(_d.length),$k[--$j],2);$P(_d,_d.length-_g.length,_g);$k[$j++]=_d};$1.bits=$s(4+13+$1.msglen*8);$P($1.bits,0,"0011");$k[$j++]=$1.bits;$k[$j++]=4;$k[$j++]=$1.msglen;$k[$j++]=13;$1.tobin();var _m=$k[--$j];var _n=$k[--$j];$P($k[--$j],_n,_m);for(var _r=0,_q=$1.msglen-1;_r<=_q;_r+=1){$1.i=_r;$k[$j++]=$1.bits;$k[$j++]=17+$1.i*8;$k[$j++]=$g($1.msg,$1.i);$k[$j++]=8;$1.tobin();var _x=$k[--$j];var _y=$k[--$j];$P($k[--$j],_y,_x)}if(!bwipp_hanxin.__24081__){(function(){var $ctx=Object.create($1);var _24=$a([0,-1,-1]);$ctx.metrics=$a([$a(["1",23,-1,0,205,$a([1,21,4]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,17,8]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,13,12]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,9,16]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["2",25,-1,0,301,$a([1,31,6]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,25,12]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,19,18]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,15,22]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["3",27,-1,0,405,$a([1,42,8]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,34,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,26,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["4",29,14,1,439,$a([1,46,8]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,38,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,30,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,22,32]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["5",31,16,1,555,$a([1,57,12]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,49,20]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,37,32]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,14,20]),$a([1,13,22]),$a([0,-1,-1])]),$a(["6",33,16,1,675,$a([1,70,14]),_24,$a([0,-1,-1]),$a([1,58,26]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,24,20]),$a([1,22,18]),$a([0,-1,-1]),$a([1,16,24]),$a([1,18,26]),$a([0,-1,-1])]),$a(["7",35,17,1,805,$a([1,84,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,26,22]),$a([1,28,24]),$a([0,-1,-1]),$a([2,14,20]),$a([1,12,20]),$a([0,-1,-1])]),$a(["8",37,18,1,943,$a([1,99,18]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,40,18]),$a([1,41,18]),$a([0,-1,-1]),$a([1,31,26]),$a([1,32,28]),$a([0,-1,-1]),$a([2,16,24]),$a([1,15,22]),$a([0,-1,-1])]),$a(["9",39,19,1,1089,$a([1,114,22]),$a([0,-1,-1]),$a([0,-1,-1]),$a([2,48,20]),$a([0,-1,-1]),$a([0,-1,-1]),$a([2,24,20]),$a([1,26,22]),$a([0,-1,-1]),$a([2,18,28]),$a([1,18,26]),$a([0,-1,-1])]),$a(["10",41,20,1,1243,$a([1,131,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,52,22]),$a([1,57,24]),$a([0,-1,-1]),$a([2,27,24]),$a([1,29,24]),$a([0,-1,-1]),$a([2,21,32]),$a([1,19,30]),$a([0,-1,-1])]),$a(["11",43,14,2,1289,$a([1,135,26]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,56,24]),$a([1,57,24]),$a([0,-1,-1]),$a([2,28,24]),$a([1,31,26]),$a([0,-1,-1]),$a([2,22,32]),$a([1,21,32]),$a([0,-1,-1])]),$a(["12",45,15,2,1455,$a([1,153,28]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,62,26]),$a([1,65,28]),$a([0,-1,-1]),$a([2,32,28]),$a([1,33,28]),$a([0,-1,-1]),$a([3,17,26]),$a([1,22,30]),$a([0,-1,-1])]),$a(["13",47,16,2,1629,$a([1,86,16]),$a([1,85,16]),$a([0,-1,-1]),$a([1,71,30]),$a([1,72,30]),$a([0,-1,-1]),$a([2,37,32]),$a([1,35,30]),$a([0,-1,-1]),$a([3,20,30]),$a([1,21,32]),$a([0,-1,-1])]),$a(["14",49,16,2,1805,$a([1,94,18]),$a([1,95,18]),$a([0,-1,-1]),$a([2,51,22]),$a([1,55,24]),$a([0,-1,-1]),$a([3,30,26]),$a([1,31,26]),$a([0,-1,-1]),$a([4,18,28]),$a([1,17,24]),$a([0,-1,-1])]),$a(["15",51,17,2,1995,$a([1,104,20]),$a([1,105,20]),$a([0,-1,-1]),$a([2,57,24]),$a([1,61,26]),$a([0,-1,-1]),$a([3,33,28]),$a([1,36,30]),$a([0,-1,-1]),$a([4,20,30]),$a([1,19,30]),$a([0,-1,-1])]),$a(["16",53,17,2,2187,$a([1,115,22]),$a([1,114,22]),$a([0,-1,-1]),$a([2,65,28]),$a([1,61,26]),$a([0,-1,-1]),$a([3,38,32]),$a([1,33,30]),$a([0,-1,-1]),$a([5,19,28]),$a([1,14,24]),$a([0,-1,-1])]),$a(["17",55,18,2,2393,$a([1,126,24]),$a([1,125,24]),$a([0,-1,-1]),$a([2,70,30]),$a([1,69,30]),$a([0,-1,-1]),$a([4,33,28]),$a([1,29,26]),$a([0,-1,-1]),$a([5,20,30]),$a([1,19,30]),$a([0,-1,-1])]),$a(["18",57,19,2,2607,$a([1,136,26]),$a([1,137,26]),$a([0,-1,-1]),$a([3,56,24]),$a([1,59,26]),$a([0,-1,-1]),$a([5,35,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([6,18,28]),$a([1,21,28]),$a([0,-1,-1])]),$a(["19",59,20,2,2829,$a([1,148,28]),$a([1,149,28]),$a([0,-1,-1]),$a([3,61,26]),$a([1,64,28]),$a([0,-1,-1]),$a([7,24,20]),$a([1,23,22]),$a([0,-1,-1]),$a([6,20,30]),$a([1,21,32]),$a([0,-1,-1])]),$a(["20",61,20,2,3053,$a([3,107,20]),$a([0,-1,-1]),$a([0,-1,-1]),$a([3,65,28]),$a([1,72,30]),$a([0,-1,-1]),$a([7,26,22]),$a([1,23,22]),$a([0,-1,-1]),$a([7,19,28]),$a([1,20,32]),$a([0,-1,-1])]),$a(["21",63,21,2,3291,$a([3,115,22]),$a([0,-1,-1]),$a([0,-1,-1]),$a([4,56,24]),$a([1,63,28]),$a([0,-1,-1]),$a([7,28,24]),$a([1,25,22]),$a([0,-1,-1]),$a([8,18,28]),$a([1,21,22]),$a([0,-1,-1])]),$a(["22",65,16,3,3383,$a([2,116,22]),$a([1,122,24]),$a([0,-1,-1]),$a([4,56,24]),$a([1,72,30]),$a([0,-1,-1]),$a([7,28,24]),$a([1,32,26]),$a([0,-1,-1]),$a([8,18,28]),$a([1,24,30]),$a([0,-1,-1])]),$a(["23",67,17,3,3631,$a([3,127,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([5,51,22]),$a([1,62,26]),$a([0,-1,-1]),$a([7,30,26]),$a([1,35,26]),$a([0,-1,-1]),$a([8,20,30]),$a([1,21,32]),$a([0,-1,-1])]),$a(["24",69,17,3,3887,$a([2,135,26]),$a([1,137,26]),$a([0,-1,-1]),$a([5,56,24]),$a([1,59,26]),$a([0,-1,-1]),$a([7,33,28]),$a([1,30,28]),$a([0,-1,-1]),$a([11,16,24]),$a([1,19,26]),$a([0,-1,-1])]),$a(["25",71,18,3,4151,$a([3,105,20]),$a([1,121,22]),$a([0,-1,-1]),$a([5,61,26]),$a([1,57,26]),$a([0,-1,-1]),$a([9,28,24]),$a([1,28,22]),$a([0,-1,-1]),$a([10,19,28]),$a([1,18,30]),$a([0,-1,-1])]),$a(["26",73,18,3,4423,$a([2,157,30]),$a([1,150,28]),$a([0,-1,-1]),$a([5,65,28]),$a([1,61,26]),$a([0,-1,-1]),$a([8,33,28]),$a([1,34,30]),$a([0,-1,-1]),$a([10,19,28]),$a([2,15,26]),$a([0,-1,-1])]),$a(["27",75,19,3,4703,$a([3,126,24]),$a([1,115,22]),$a([0,-1,-1]),$a([7,51,22]),$a([1,54,22]),$a([0,-1,-1]),$a([8,35,30]),$a([1,37,30]),$a([0,-1,-1]),$a([15,15,22]),$a([1,10,22]),$a([0,-1,-1])]),$a(["28",77,19,3,4991,$a([4,105,20]),$a([1,103,20]),$a([0,-1,-1]),$a([7,56,24]),$a([1,45,18]),$a([0,-1,-1]),$a([10,31,26]),$a([1,27,26]),$a([0,-1,-1]),$a([10,17,26]),$a([3,20,28]),$a([1,21,28])]),$a(["29",79,20,3,5287,$a([3,139,26]),$a([1,137,28]),$a([0,-1,-1]),$a([6,66,28]),$a([1,66,30]),$a([0,-1,-1]),$a([9,36,30]),$a([1,34,32]),$a([0,-1,-1]),$a([13,19,28]),$a([1,17,32]),$a([0,-1,-1])]),$a(["30",81,20,3,5591,$a([6,84,16]),$a([1,82,16]),$a([0,-1,-1]),$a([6,70,30]),$a([1,68,30]),$a([0,-1,-1]),$a([7,35,30]),$a([3,33,28]),$a([1,32,28]),$a([13,20,30]),$a([1,20,28]),$a([0,-1,-1])]),$a(["31",83,21,3,5903,$a([5,105,20]),$a([1,94,18]),$a([0,-1,-1]),$a([6,74,32]),$a([1,71,30]),$a([0,-1,-1]),$a([11,33,28]),$a([1,34,32]),$a([0,-1,-1]),$a([13,19,28]),$a([3,16,26]),$a([0,-1,-1])]),$a(["32",85,17,4,6033,$a([4,127,24]),$a([1,126,24]),$a([0,-1,-1]),$a([7,66,28]),$a([1,66,30]),$a([0,-1,-1]),$a([12,30,24]),$a([1,24,28]),$a([1,24,30]),$a([15,19,28]),$a([1,17,32]),$a([0,-1,-1])]),$a(["33",87,17,4,6353,$a([7,84,16]),$a([1,78,16]),$a([0,-1,-1]),$a([7,70,30]),$a([1,66,28]),$a([0,-1,-1]),$a([12,33,28]),$a([1,32,30]),$a([0,-1,-1]),$a([14,21,32]),$a([1,24,28]),$a([0,-1,-1])]),$a(["34",89,18,4,6689,$a([5,117,22]),$a([1,117,24]),$a([0,-1,-1]),$a([8,66,28]),$a([1,58,26]),$a([0,-1,-1]),$a([11,38,32]),$a([1,34,32]),$a([0,-1,-1]),$a([15,20,30]),$a([2,17,26]),$a([0,-1,-1])]),$a(["35",91,18,4,7025,$a([4,148,28]),$a([1,146,28]),$a([0,-1,-1]),$a([8,68,30]),$a([1,70,24]),$a([0,-1,-1]),$a([10,36,32]),$a([3,38,28]),$a([0,-1,-1]),$a([16,19,28]),$a([3,16,26]),$a([0,-1,-1])]),$a(["36",93,19,4,7377,$a([4,126,24]),$a([2,135,26]),$a([0,-1,-1]),$a([8,70,28]),$a([2,43,26]),$a([0,-1,-1]),$a([13,32,28]),$a([2,41,30]),$a([0,-1,-1]),$a([17,19,28]),$a([3,15,26]),$a([0,-1,-1])]),$a(["37",95,19,4,7729,$a([5,136,26]),$a([1,132,24]),$a([0,-1,-1]),$a([5,67,30]),$a([4,68,28]),$a([1,69,28]),$a([14,35,30]),$a([1,32,24]),$a([0,-1,-1]),$a([18,18,26]),$a([3,16,28]),$a([1,14,28])]),$a(["38",97,19,4,8089,$a([3,142,26]),$a([3,141,28]),$a([0,-1,-1]),$a([8,70,30]),$a([1,73,32]),$a([1,74,32]),$a([12,34,30]),$a([3,34,26]),$a([1,35,28]),$a([18,21,32]),$a([1,27,30]),$a([0,-1,-1])]),$a(["39",99,20,4,8465,$a([5,116,22]),$a([2,103,20]),$a([1,102,20]),$a([9,74,32]),$a([1,74,30]),$a([0,-1,-1]),$a([14,34,28]),$a([2,32,32]),$a([1,32,30]),$a([19,21,32]),$a([1,25,26]),$a([0,-1,-1])]),$a(["40",101,20,4,8841,$a([7,116,22]),$a([1,117,22]),$a([0,-1,-1]),$a([11,65,28]),$a([1,58,24]),$a([0,-1,-1]),$a([15,38,32]),$a([1,27,28]),$a([0,-1,-1]),$a([20,20,30]),$a([1,20,32]),$a([1,21,32])]),$a(["41",103,17,5,9009,$a([6,136,26]),$a([1,130,24]),$a([0,-1,-1]),$a([11,66,28]),$a([1,62,30]),$a([0,-1,-1]),$a([14,34,28]),$a([3,34,32]),$a([1,30,30]),$a([18,20,30]),$a([3,20,28]),$a([2,15,26])]),$a(["42",105,17,5,9401,$a([5,105,20]),$a([2,115,22]),$a([2,116,22]),$a([10,75,32]),$a([1,73,32]),$a([0,-1,-1]),$a([16,38,32]),$a([1,27,28]),$a([0,-1,-1]),$a([22,19,28]),$a([2,16,30]),$a([1,19,30])]),$a(["43",107,18,5,9799,$a([6,147,28]),$a([1,146,28]),$a([0,-1,-1]),$a([11,66,28]),$a([2,65,30]),$a([0,-1,-1]),$a([18,33,28]),$a([2,33,30]),$a([0,-1,-1]),$a([22,21,32]),$a([1,28,30]),$a([0,-1,-1])]),$a(["44",109,18,5,10207,$a([6,116,22]),$a([3,125,24]),$a([0,-1,-1]),$a([11,75,32]),$a([1,68,30]),$a([0,-1,-1]),$a([13,35,28]),$a([6,34,32]),$a([1,30,30]),$a([23,21,32]),$a([1,26,30]),$a([0,-1,-1])]),$a(["45",111,18,5,10623,$a([7,105,20]),$a([4,95,18]),$a([0,-1,-1]),$a([12,67,28]),$a([1,63,30]),$a([1,62,32]),$a([21,31,26]),$a([2,33,32]),$a([0,-1,-1]),$a([23,21,32]),$a([2,24,30]),$a([0,-1,-1])]),$a(["46",113,19,5,11045,$a([10,116,22]),$a([0,-1,-1]),$a([0,-1,-1]),$a([12,74,32]),$a([1,78,30]),$a([0,-1,-1]),$a([18,37,32]),$a([1,39,30]),$a([1,41,28]),$a([25,21,32]),$a([1,27,28]),$a([0,-1,-1])]),$a(["47",115,19,5,11477,$a([5,126,24]),$a([4,115,22]),$a([1,114,22]),$a([12,67,28]),$a([2,66,32]),$a([1,68,30]),$a([21,35,30]),$a([1,39,30]),$a([0,-1,-1]),$a([26,21,32]),$a([1,28,28]),$a([0,-1,-1])]),$a(["48",117,19,5,11917,$a([9,126,24]),$a([1,117,22]),$a([0,-1,-1]),$a([13,75,32]),$a([1,68,30]),$a([0,-1,-1]),$a([20,35,30]),$a([3,35,28]),$a([0,-1,-1]),$a([27,21,32]),$a([1,28,30]),$a([0,-1,-1])]),$a(["49",119,17,6,12111,$a([9,126,24]),$a([1,137,26]),$a([0,-1,-1]),$a([13,71,30]),$a([2,68,32]),$a([0,-1,-1]),$a([20,37,32]),$a([1,39,28]),$a([1,38,28]),$a([24,20,32]),$a([5,25,28]),$a([0,-1,-1])]),$a(["50",121,17,6,12559,$a([8,147,28]),$a([1,141,28]),$a([0,-1,-1]),$a([10,73,32]),$a([4,74,30]),$a([1,73,30]),$a([16,36,32]),$a([6,39,30]),$a([1,37,30]),$a([27,21,32]),$a([3,20,26]),$a([0,-1,-1])]),$a(["51",123,18,6,13025,$a([9,137,26]),$a([1,135,26]),$a([0,-1,-1]),$a([12,70,30]),$a([4,75,32]),$a([0,-1,-1]),$a([24,35,30]),$a([1,40,28]),$a([0,-1,-1]),$a([23,20,32]),$a([8,24,30]),$a([0,-1,-1])]),$a(["52",125,18,6,13489,$a([14,95,18]),$a([1,86,18]),$a([0,-1,-1]),$a([13,73,32]),$a([3,77,30]),$a([0,-1,-1]),$a([24,35,30]),$a([2,35,28]),$a([0,-1,-1]),$a([26,21,32]),$a([5,21,30]),$a([1,23,30])]),$a(["53",127,18,6,13961,$a([9,147,28]),$a([1,142,28]),$a([0,-1,-1]),$a([10,73,30]),$a([6,70,32]),$a([1,71,32]),$a([25,35,30]),$a([2,34,26]),$a([0,-1,-1]),$a([29,21,32]),$a([4,22,30]),$a([0,-1,-1])]),$a(["54",129,18,6,14441,$a([11,126,24]),$a([1,131,24]),$a([0,-1,-1]),$a([16,74,32]),$a([1,79,30]),$a([0,-1,-1]),$a([25,38,32]),$a([1,25,30]),$a([0,-1,-1]),$a([33,21,32]),$a([1,28,28]),$a([0,-1,-1])]),$a(["55",131,19,6,14939,$a([14,105,20]),$a([1,99,18]),$a([0,-1,-1]),$a([19,65,28]),$a([1,72,28]),$a([0,-1,-1]),$a([24,37,32]),$a([2,40,30]),$a([1,41,30]),$a([31,21,32]),$a([4,24,32]),$a([0,-1,-1])]),$a(["56",133,19,6,15435,$a([10,147,28]),$a([1,151,28]),$a([0,-1,-1]),$a([15,71,30]),$a([3,71,32]),$a([1,73,32]),$a([24,37,32]),$a([3,38,30]),$a([1,39,30]),$a([36,19,30]),$a([3,29,26]),$a([0,-1,-1])]),$a(["57",135,19,6,15939,$a([15,105,20]),$a([1,99,18]),$a([0,-1,-1]),$a([19,70,30]),$a([1,64,28]),$a([0,-1,-1]),$a([27,38,32]),$a([2,25,26]),$a([0,-1,-1]),$a([38,20,30]),$a([2,18,28]),$a([0,-1,-1])]),$a(["58",137,17,7,16171,$a([14,105,20]),$a([1,113,22]),$a([1,114,22]),$a([17,67,30]),$a([3,92,32]),$a([0,-1,-1]),$a([30,35,30]),$a([1,41,30]),$a([0,-1,-1]),$a([36,21,32]),$a([1,26,30]),$a([1,27,30])]),$a(["59",139,17,7,16691,$a([11,146,28]),$a([1,146,26]),$a([0,-1,-1]),$a([20,70,30]),$a([1,60,26]),$a([0,-1,-1]),$a([29,38,32]),$a([1,24,32]),$a([0,-1,-1]),$a([40,20,30]),$a([2,17,26]),$a([0,-1,-1])]),$a(["60",141,18,7,17215,$a([3,137,26]),$a([1,136,26]),$a([10,126,24]),$a([22,65,28]),$a([1,75,30]),$a([0,-1,-1]),$a([30,37,32]),$a([1,51,30]),$a([0,-1,-1]),$a([42,20,30]),$a([1,21,30]),$a([0,-1,-1])]),$a(["61",143,18,7,17751,$a([12,126,24]),$a([2,118,22]),$a([1,116,22]),$a([19,74,32]),$a([1,74,30]),$a([1,72,28]),$a([30,38,32]),$a([2,29,30]),$a([0,-1,-1]),$a([39,20,32]),$a([2,37,26]),$a([1,38,26])]),$a(["62",145,18,7,18295,$a([12,126,24]),$a([3,136,26]),$a([0,-1,-1]),$a([21,70,30]),$a([2,65,28]),$a([0,-1,-1]),$a([34,35,30]),$a([1,44,32]),$a([0,-1,-1]),$a([42,20,30]),$a([2,19,28]),$a([2,18,28])]),$a(["63",147,18,7,18847,$a([12,126,24]),$a([3,117,22]),$a([1,116,22]),$a([25,61,26]),$a([2,62,28]),$a([0,-1,-1]),$a([34,35,30]),$a([1,40,32]),$a([1,41,32]),$a([45,20,30]),$a([1,20,32]),$a([1,21,32])]),$a(["64",149,19,7,19403,$a([15,105,20]),$a([2,115,22]),$a([2,116,22]),$a([25,65,28]),$a([1,72,28]),$a([0,-1,-1]),$a([18,35,30]),$a([17,37,32]),$a([1,50,32]),$a([42,20,30]),$a([6,19,28]),$a([1,15,28])]),$a(["65",151,19,7,19971,$a([19,105,20]),$a([1,101,20]),$a([0,-1,-1]),$a([33,51,22]),$a([1,65,22]),$a([0,-1,-1]),$a([40,33,28]),$a([1,28,28]),$a([0,-1,-1]),$a([49,20,30]),$a([1,18,28]),$a([0,-1,-1])]),$a(["66",153,17,8,20229,$a([18,105,20]),$a([2,117,22]),$a([0,-1,-1]),$a([26,65,28]),$a([1,80,30]),$a([0,-1,-1]),$a([35,35,30]),$a([3,35,28]),$a([1,36,28]),$a([52,18,28]),$a([2,38,30]),$a([0,-1,-1])]),$a(["67",155,17,8,20805,$a([26,84,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([26,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([45,31,26]),$a([1,9,26]),$a([0,-1,-1]),$a([52,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["68",157,17,8,21389,$a([16,126,24]),$a([1,114,22]),$a([1,115,22]),$a([23,70,30]),$a([3,65,28]),$a([1,66,28]),$a([40,35,30]),$a([1,43,30]),$a([0,-1,-1]),$a([46,20,30]),$a([7,19,28]),$a([1,16,28])]),$a(["69",159,18,8,21993,$a([19,116,22]),$a([1,105,22]),$a([0,-1,-1]),$a([20,70,30]),$a([7,66,28]),$a([1,63,28]),$a([40,35,30]),$a([1,42,32]),$a([1,43,32]),$a([54,20,30]),$a([1,19,30]),$a([0,-1,-1])]),$a(["70",161,18,8,22593,$a([17,126,24]),$a([2,115,22]),$a([0,-1,-1]),$a([24,70,30]),$a([4,74,32]),$a([0,-1,-1]),$a([48,31,26]),$a([2,18,26]),$a([0,-1,-1]),$a([54,19,28]),$a([6,15,26]),$a([1,14,26])]),$a(["71",163,18,8,23201,$a([29,84,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([29,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([6,34,30]),$a([3,36,30]),$a([38,33,28]),$a([58,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["72",165,18,8,23817,$a([16,147,28]),$a([1,149,28]),$a([0,-1,-1]),$a([31,66,28]),$a([1,37,26]),$a([0,-1,-1]),$a([48,33,28]),$a([1,23,26]),$a([0,-1,-1]),$a([53,20,30]),$a([6,19,28]),$a([1,17,28])]),$a(["73",167,19,8,24453,$a([20,115,22]),$a([2,134,24]),$a([0,-1,-1]),$a([29,66,28]),$a([2,56,26]),$a([2,57,26]),$a([45,36,30]),$a([2,15,28]),$a([0,-1,-1]),$a([59,20,30]),$a([2,21,32]),$a([0,-1,-1])]),$a(["74",169,19,8,25085,$a([17,147,28]),$a([1,134,26]),$a([0,-1,-1]),$a([26,70,30]),$a([5,75,32]),$a([0,-1,-1]),$a([47,35,30]),$a([1,48,32]),$a([0,-1,-1]),$a([64,18,28]),$a([2,33,30]),$a([1,35,30])]),$a(["75",171,17,9,25373,$a([22,115,22]),$a([1,133,24]),$a([0,-1,-1]),$a([33,65,28]),$a([1,74,28]),$a([0,-1,-1]),$a([43,36,30]),$a([5,27,28]),$a([1,30,28]),$a([57,20,30]),$a([5,21,32]),$a([1,24,32])]),$a(["76",173,17,9,26021,$a([18,136,26]),$a([2,142,26]),$a([0,-1,-1]),$a([33,66,28]),$a([2,49,26]),$a([0,-1,-1]),$a([48,35,30]),$a([2,38,28]),$a([0,-1,-1]),$a([64,20,30]),$a([1,20,32]),$a([0,-1,-1])]),$a(["77",175,17,9,26677,$a([19,126,24]),$a([2,135,26]),$a([1,136,26]),$a([32,66,28]),$a([2,55,26]),$a([2,56,26]),$a([49,36,30]),$a([2,18,32]),$a([0,-1,-1]),$a([65,18,28]),$a([5,27,30]),$a([1,29,30])]),$a(["78",177,18,9,27335,$a([20,137,26]),$a([1,130,26]),$a([0,-1,-1]),$a([30,75,32]),$a([2,71,32]),$a([0,-1,-1]),$a([46,35,30]),$a([6,39,32]),$a([0,-1,-1]),$a([3,12,30]),$a([70,19,28]),$a([0,-1,-1])]),$a(["79",179,18,9,28007,$a([20,147,28]),$a([0,-1,-1]),$a([0,-1,-1]),$a([35,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([49,35,30]),$a([5,35,28]),$a([0,-1,-1]),$a([70,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["80",181,18,9,28687,$a([21,136,26]),$a([1,155,28]),$a([0,-1,-1]),$a([34,70,30]),$a([1,64,28]),$a([1,65,28]),$a([54,35,30]),$a([1,45,30]),$a([0,-1,-1]),$a([68,20,30]),$a([3,18,28]),$a([1,19,28])]),$a(["81",183,18,9,29375,$a([19,126,24]),$a([5,115,22]),$a([1,114,22]),$a([33,70,30]),$a([3,65,28]),$a([1,64,28]),$a([52,35,30]),$a([3,41,32]),$a([1,40,32]),$a([67,20,30]),$a([5,21,32]),$a([1,24,32])]),$a(["82",185,18,9,30071,$a([2,150,28]),$a([21,136,26]),$a([0,-1,-1]),$a([32,70,30]),$a([6,65,28]),$a([0,-1,-1]),$a([52,38,32]),$a([2,27,32]),$a([0,-1,-1]),$a([73,20,30]),$a([2,22,32]),$a([0,-1,-1])]),$a(["83",187,17,10,30387,$a([21,126,24]),$a([4,136,26]),$a([0,-1,-1]),$a([30,74,32]),$a([6,73,30]),$a([0,-1,-1]),$a([54,35,30]),$a([4,40,32]),$a([0,-1,-1]),$a([75,20,30]),$a([1,20,28]),$a([0,-1,-1])]),$a(["84",189,17,10,31091,$a([30,105,20]),$a([1,114,22]),$a([0,-1,-1]),$a([3,45,22]),$a([55,47,20]),$a([0,-1,-1]),$a([2,26,26]),$a([62,33,28]),$a([0,-1,-1]),$a([79,18,28]),$a([4,33,30]),$a([0,-1,-1])])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hanxin.$ctx[id]=$ctx[id]);bwipp_hanxin.__24081__=1})()}$1.eclval=$g($1.eclevel,1)-49;var _Ig=$1.metrics;for(var _Ih=0,_Ii=_Ig.length;_Ih<_Ii;_Ih++){$1.m=$g(_Ig,_Ih);$1.vers=$g($1.m,0);$1.size=$g($1.m,1);$1.alnk=$g($1.m,2);$1.alnn=$g($1.m,3);$1.alnr=$f($1.size-$1.alnk*$1.alnn);$1.nmod=$g($1.m,4);$1.ncws=~~($1.nmod/8);$1.rbit=$1.nmod%8;$1.ecbs=$G($1.m,5+$1.eclval*3,3);var _J2=$1.ecbs;$k[$j++]="ecws";$k[$j++]=0;for(var _J3=0,_J4=_J2.length;_J3<_J4;_J3++){var _J5=$g(_J2,_J3);var _J8=$k[--$j];$k[$j++]=$f(_J8+$g(_J5,0)*$g(_J5,2))}var _J9=$k[--$j];$1[$k[--$j]]=_J9;$1.dcws=$f($1.ncws-$1.ecws);$1.dmod=$1.dcws*8;$1.okay=true;if($ne($1.version,"unset")&&$ne($1.version,$1.vers)){$1.okay=false}if($1.bits.length>$1.dmod){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.hanxinNoValidSymbol#24105";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}$1.version=$1.vers;$1.msgbits=$1.bits;$1.e1nb=$g($g($1.ecbs,0),0);$1.e2nb=$g($g($1.ecbs,1),0);$1.e3nb=$g($g($1.ecbs,2),0);$1.e1dcws=$g($g($1.ecbs,0),1);$1.e2dcws=$g($g($1.ecbs,1),1);$1.e3dcws=$g($g($1.ecbs,2),1);$1.e1ecws=$g($g($1.ecbs,0),2);$1.e2ecws=$g($g($1.ecbs,1),2);$1.e3ecws=$g($g($1.ecbs,2),2);$1.pad=$s($1.dmod);for(var _Js=0,_Jr=$1.pad.length-1;_Js<=_Jr;_Js+=1){$p($1.pad,_Js,48)}$P($1.pad,0,$1.msgbits);$1.cws=$a($1.dcws);for(var _K0=0,_Jz=$1.cws.length-1;_K0<=_Jz;_K0+=1){$1.c=_K0;$1.cwb=$G($1.pad,$1.c*8,8);$1.cw=0;for(var _K4=0;_K4<=7;_K4+=1){$1.i=_K4;$1.cw=$f($1.cw+~~Math.pow(2,8-$1.i-1)*$f($g($1.cwb,$1.i)-48))}$p($1.cws,$1.c,$1.cw)}$1.rscodes=function(){$1.rspm=$k[--$j];$1.rsgf=$k[--$j];$1.rsnc=$k[--$j];$1.rscws=$k[--$j];$k[$j++]=Infinity;$k[$j++]=1;for(var _KI=0,_KJ=$f($1.rsgf-1);_KI<_KJ;_KI++){var _KK=$k[--$j];var _KL=_KK*2;$k[$j++]=_KK;$k[$j++]=_KL;if(_KL>=$1.rsgf){var _KO=$k[--$j];$k[$j++]=$xo(_KO,$1.rspm)}}$1.rsalog=$a();$1.rslog=$a($1.rsgf);for(var _KU=1,_KT=$f($1.rsgf-1);_KU<=_KT;_KU+=1){$p($1.rslog,$g($1.rsalog,_KU),_KU)}$1.rsprod=function(){var _KY=$k[--$j];var _KZ=$k[--$j];$k[$j++]=_KZ;$k[$j++]=_KY;if(_KY!=0&&_KZ!=0){var _Kc=$g($1.rslog,$k[--$j]);var _Ki=$g($1.rsalog,$f(_Kc+$g($1.rslog,$k[--$j]))%$f($1.rsgf-1));$k[$j++]=_Ki}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Kk=0,_Kl=$1.rsnc;_Kk<_Kl;_Kk++){$k[$j++]=0}$1.coeffs=$a();for(var _Kp=1,_Ko=$1.rsnc;_Kp<=_Ko;_Kp+=1){$1.i=_Kp;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _Kw=$1.i-1;_Kw>=1;_Kw-=1){$1.j=_Kw;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _L8=$k[--$j];var _L9=$k[--$j];var _LA=$k[--$j];$p($k[--$j],_LA,$xo(_L9,_L8))}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _LI=$k[--$j];var _LJ=$k[--$j];$p($k[--$j],_LJ,_LI)}$1.nd=$1.rscws.length;$k[$j++]=Infinity;$F($1.rscws);for(var _LO=0,_LP=$1.rsnc;_LO<_LP;_LO++){$k[$j++]=0}$k[$j++]=0;$1.rscws=$a();for(var _LT=0,_LS=$1.nd-1;_LT<=_LS;_LT+=1){$1.k=$xo($g($1.rscws,_LT),$g($1.rscws,$1.nd));for(var _Lb=0,_La=$f($1.rsnc-1);_Lb<=_La;_Lb+=1){$1.j=_Lb;$k[$j++]=$1.rscws;$k[$j++]=$1.nd+$1.j;$k[$j++]=$g($1.rscws,$1.nd+$1.j+1);$k[$j++]=$1.k;$k[$j++]=$g($1.coeffs,$f($f($1.rsnc-$1.j)-1));$1.rsprod();var _Lo=$k[--$j];var _Lp=$k[--$j];var _Lq=$k[--$j];$p($k[--$j],_Lq,$xo(_Lp,_Lo))}}$k[$j++]=$G($1.rscws,0,$1.rscws.length-1)};$1.dcwsb=$a($f($f($1.e1nb+$1.e2nb)+$1.e3nb));$1.ecwsb=$a($1.dcwsb.length);$1.in=0;$1.out=0;for(var _M2=0,_M3=$1.e1nb;_M2<_M3;_M2++){$k[$j++]=$G($1.cws,$1.in,$1.e1dcws);$k[$j++]=$1.e1ecws;$k[$j++]=256;$k[$j++]=355;$1.rscodes();var _M9=$k[--$j];$p($1.dcwsb,$1.out,$G(_M9,0,$1.e1dcws));$p($1.ecwsb,$1.out,$G(_M9,$1.e1dcws,$1.e1ecws));$1.in=$f($1.in+$1.e1dcws);$1.out=$1.out+1}for(var _MN=0,_MO=$1.e2nb;_MN<_MO;_MN++){$k[$j++]=$G($1.cws,$1.in,$1.e2dcws);$k[$j++]=$1.e2ecws;$k[$j++]=256;$k[$j++]=355;$1.rscodes();var _MU=$k[--$j];$p($1.dcwsb,$1.out,$G(_MU,0,$1.e2dcws));$p($1.ecwsb,$1.out,$G(_MU,$1.e2dcws,$1.e2ecws));$1.in=$f($1.in+$1.e2dcws);$1.out=$1.out+1}for(var _Mi=0,_Mj=$1.e3nb;_Mi<_Mj;_Mi++){$k[$j++]=$G($1.cws,$1.in,$1.e3dcws);$k[$j++]=$1.e3ecws;$k[$j++]=256;$k[$j++]=355;$1.rscodes();var _Mp=$k[--$j];$p($1.dcwsb,$1.out,$G(_Mp,0,$1.e3dcws));$p($1.ecwsb,$1.out,$G(_Mp,$1.e3dcws,$1.e3ecws));$1.in=$f($1.in+$1.e3dcws);$1.out=$1.out+1}$1.cws=$a($1.ncws);$1.cw=0;for(var _N6=0,_N5=$1.dcwsb.length-1;_N6<=_N5;_N6+=1){$1.i=_N6;var _N9=$g($1.dcwsb,$1.i);$P($1.cws,$1.cw,_N9);$1.cw=_N9.length+$1.cw;var _NF=$g($1.ecwsb,$1.i);$P($1.cws,$1.cw,_NF);$1.cw=_NF.length+$1.cw}$k[$j++]=Infinity;var _NJ=$1.ncws;var _NK=12;var _NL=_NJ-1;if(_NJ-1>12){var _=_NK;_NK=_NL;_NL=_}for(var _NN=0,_NM=_NL;_NN<=_NM;_NN+=1){for(var _NQ=_NN,_NP=$1.ncws-1;_NQ<=_NP;_NQ+=13){$k[$j++]=_NQ;if(_NQ<$1.ncws){var _NU=$g($1.cws,$k[--$j]);$k[$j++]=_NU}else{$j--}}}$1.cws=$a();if($1.rbit>0){$1.pad=$a($1.cws.length+1);$P($1.pad,0,$1.cws);$p($1.pad,$1.pad.length-1,0);$1.cws=$1.pad}$k[$j++]=Infinity;for(var _Ng=0,_Nh=$1.size*$1.size;_Ng<_Nh;_Ng++){$k[$j++]=-1}$1.pixs=$a();$1.qmv=function(){var _Nk=$k[--$j];var _Nl=$k[--$j];$k[$j++]=$f(_Nl+_Nk*$1.size)};if($1.alnn!=0){$1.trmv=function(){var _No=$k[--$j];var _Nq=$k[--$j];$k[$j++]=$f($f($f(_No*$1.size+$1.size)-1)-_Nq)};$1.aplot=function(){var _Nr=$k[--$j];var _Ns=$k[--$j];var _Nt=$k[--$j];$k[$j++]=_Nr;$k[$j++]=_Nt;$k[$j++]=_Ns;$k[$j++]=_Nr;$k[$j++]=_Ns;$k[$j++]=_Nt;$1.trmv();var _Nv=$k[--$j];$p($1.pixs,_Nv,$k[--$j]);$1.trmv();var _Ny=$k[--$j];$p($1.pixs,_Ny,$k[--$j])};$1.i=0;$1.stag=0;for(;;){if($1.i>=$1.size){break}for(var _O4=0,_O3=$f($1.size-1);_O4<=_O3;_O4+=1){$1.j=_O4;if($f($1.j+$1.alnr)<$1.size){$k[$j++]=(~~($1.j/$1.alnk)+$1.stag)%2==0&&!($1.i==0&&$1.j<$1.alnk)||$1.j%$1.alnk==0}else{$k[$j++]=$f($1.alnn+$1.stag)%2==0}if($k[--$j]){$k[$j++]=$1.j;$k[$j++]=$1.i;$k[$j++]=1;$1.aplot();var _OL=$1.j;var _OM=$1.i;$k[$j++]=_OL+1;$k[$j++]=_OM+1;if(_OM+1<$1.size&&_OL+1<$1.size){$k[$j++]=0;$1.aplot()}else{$j-=2}}}if($f($1.i+$1.alnr)==$1.size){$1.i=$f($f($1.i+$1.alnr)-1)}else{$1.i=$f($1.i+$1.alnk)}$1.stag=1-$1.stag}for(var _Ob=$1.alnk,_Oc=$1.alnk,_Oa=$f($1.size-2);_Oc<0?_Ob>=_Oa:_Ob<=_Oa;_Ob+=_Oc){$1.i=_Ob;if(~~($1.i/$1.alnk)%2!=0){$k[$j++]=$1.pixs;$k[$j++]=0;$k[$j++]=$1.i-1;$1.trmv();var _Oh=$k[--$j];$p($k[--$j],_Oh,0);$k[$j++]=$1.pixs;$k[$j++]=0;$k[$j++]=$1.i+1;$1.trmv();var _Ol=$k[--$j];$p($k[--$j],_Ol,0);$k[$j++]=$1.pixs;$k[$j++]=1;$k[$j++]=$1.i-1;$1.trmv();var _Op=$k[--$j];$p($k[--$j],_Op,0);$k[$j++]=$1.pixs;$k[$j++]=1;$k[$j++]=$1.i;$1.trmv();var _Ot=$k[--$j];$p($k[--$j],_Ot,0);$k[$j++]=$1.pixs;$k[$j++]=1;$k[$j++]=$1.i+1;$1.trmv();var _Ox=$k[--$j];$p($k[--$j],_Ox,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i-1;$k[$j++]=0;$1.trmv();var _P1=$k[--$j];$p($k[--$j],_P1,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i+1;$k[$j++]=0;$1.trmv();var _P5=$k[--$j];$p($k[--$j],_P5,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i-1;$k[$j++]=1;$1.trmv();var _P9=$k[--$j];$p($k[--$j],_P9,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=1;$1.trmv();var _PD=$k[--$j];$p($k[--$j],_PD,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i+1;$k[$j++]=1;$1.trmv();var _PH=$k[--$j];$p($k[--$j],_PH,0)}$k[$j++]=$1.pixs;$k[$j++]=$f($1.size-1);$k[$j++]=$1.i-1;$1.trmv();var _PM=$k[--$j];if($g($k[--$j],_PM)!=1){$k[$j++]=$1.pixs;$k[$j++]=$f($1.size-1);$k[$j++]=$1.i-1;$1.trmv();var _PS=$k[--$j];$p($k[--$j],_PS,0);$k[$j++]=$1.pixs;$k[$j++]=$f($1.size-2);$k[$j++]=$1.i-1;$1.trmv();var _PX=$k[--$j];$p($k[--$j],_PX,0);$k[$j++]=$1.pixs;$k[$j++]=$f($1.size-2);$k[$j++]=$1.i;$1.trmv();var _Pc=$k[--$j];$p($k[--$j],_Pc,0);$k[$j++]=$1.pixs;$k[$j++]=$f($1.size-2);$k[$j++]=$1.i+1;$1.trmv();var _Ph=$k[--$j];$p($k[--$j],_Ph,0);$k[$j++]=$1.pixs;$k[$j++]=$f($1.size-1);$k[$j++]=$1.i+1;$1.trmv();var _Pm=$k[--$j];$p($k[--$j],_Pm,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i-1;$k[$j++]=$f($1.size-1);$1.trmv();var _Pr=$k[--$j];$p($k[--$j],_Pr,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i-1;$k[$j++]=$f($1.size-2);$1.trmv();var _Pw=$k[--$j];$p($k[--$j],_Pw,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$f($1.size-2);$1.trmv();var _Q1=$k[--$j];$p($k[--$j],_Q1,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i+1;$k[$j++]=$f($1.size-2);$1.trmv();var _Q6=$k[--$j];$p($k[--$j],_Q6,0);$k[$j++]=$1.pixs;$k[$j++]=$1.i+1;$k[$j++]=$f($1.size-1);$1.trmv();var _QB=$k[--$j];$p($k[--$j],_QB,0)}}}if(!bwipp_hanxin.__24313__){(function(){var $ctx=Object.create($1);$ctx.fpat=$a([$a([1,1,1,1,1,1,1,0]),$a([1,0,0,0,0,0,0,0]),$a([1,0,1,1,1,1,1,0]),$a([1,0,1,0,0,0,0,0]),$a([1,0,1,0,1,1,1,0]),$a([1,0,1,0,1,1,1,0]),$a([1,0,1,0,1,1,1,0]),$a([0,0,0,0,0,0,0,0])]);$ctx.fpat2=$a([$a([1,1,1,0,1,0,1,0]),$a([1,1,1,0,1,0,1,0]),$a([1,1,1,0,1,0,1,0]),$a([0,0,0,0,1,0,1,0]),$a([1,1,1,1,1,0,1,0]),$a([0,0,0,0,0,0,1,0]),$a([1,1,1,1,1,1,1,0]),$a([0,0,0,0,0,0,0,0])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hanxin.$ctx[id]=$ctx[id]);bwipp_hanxin.__24313__=1})()}for(var _QY=0,_QX=$1.fpat.length-1;_QY<=_QX;_QY+=1){$1.y=_QY;for(var _Qc=0,_Qb=$g($1.fpat,0).length-1;_Qc<=_Qb;_Qc+=1){$1.x=_Qc;$1.fpb=$g($g($1.fpat,$1.y),$1.x);$1.fpb2=$g($g($1.fpat2,$1.y),$1.x);$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.qmv();var _Qr=$k[--$j];$p($k[--$j],_Qr,$1.fpb);$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.size-$1.x)-1);$k[$j++]=$1.y;$1.qmv();var _Qy=$k[--$j];$p($k[--$j],_Qy,$1.fpb);$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.size-$1.x)-1);$k[$j++]=$f($f($1.size-$1.y)-1);$1.qmv();var _R6=$k[--$j];$p($k[--$j],_R6,$1.fpb);$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$f($f($1.size-$1.y)-1);$1.qmv();var _RD=$k[--$j];$p($k[--$j],_RD,$1.fpb2)}}$1.functionmap=$a([$a([$a([0,8]),$a([$f($1.size-1),$f($1.size-9)])]),$a([$a([1,8]),$a([$f($1.size-2),$f($1.size-9)])]),$a([$a([2,8]),$a([$f($1.size-3),$f($1.size-9)])]),$a([$a([3,8]),$a([$f($1.size-4),$f($1.size-9)])]),$a([$a([4,8]),$a([$f($1.size-5),$f($1.size-9)])]),$a([$a([5,8]),$a([$f($1.size-6),$f($1.size-9)])]),$a([$a([6,8]),$a([$f($1.size-7),$f($1.size-9)])]),$a([$a([7,8]),$a([$f($1.size-8),$f($1.size-9)])]),$a([$a([8,8]),$a([$f($1.size-9),$f($1.size-9)])]),$a([$a([8,7]),$a([$f($1.size-9),$f($1.size-8)])]),$a([$a([8,6]),$a([$f($1.size-9),$f($1.size-7)])]),$a([$a([8,5]),$a([$f($1.size-9),$f($1.size-6)])]),$a([$a([8,4]),$a([$f($1.size-9),$f($1.size-5)])]),$a([$a([8,3]),$a([$f($1.size-9),$f($1.size-4)])]),$a([$a([8,2]),$a([$f($1.size-9),$f($1.size-3)])]),$a([$a([8,1]),$a([$f($1.size-9),$f($1.size-2)])]),$a([$a([8,0]),$a([$f($1.size-9),$f($1.size-1)])]),$a([$a([$f($1.size-9),0]),$a([8,$f($1.size-1)])]),$a([$a([$f($1.size-9),1]),$a([8,$f($1.size-2)])]),$a([$a([$f($1.size-9),2]),$a([8,$f($1.size-3)])]),$a([$a([$f($1.size-9),3]),$a([8,$f($1.size-4)])]),$a([$a([$f($1.size-9),4]),$a([8,$f($1.size-5)])]),$a([$a([$f($1.size-9),5]),$a([8,$f($1.size-6)])]),$a([$a([$f($1.size-9),6]),$a([8,$f($1.size-7)])]),$a([$a([$f($1.size-9),7]),$a([8,$f($1.size-8)])]),$a([$a([$f($1.size-9),8]),$a([8,$f($1.size-9)])]),$a([$a([$f($1.size-8),8]),$a([7,$f($1.size-9)])]),$a([$a([$f($1.size-7),8]),$a([6,$f($1.size-9)])]),$a([$a([$f($1.size-6),8]),$a([5,$f($1.size-9)])]),$a([$a([$f($1.size-5),8]),$a([4,$f($1.size-9)])]),$a([$a([$f($1.size-4),8]),$a([3,$f($1.size-9)])]),$a([$a([$f($1.size-3),8]),$a([2,$f($1.size-9)])]),$a([$a([$f($1.size-2),8]),$a([1,$f($1.size-9)])]),$a([$a([$f($1.size-1),8]),$a([0,$f($1.size-9)])])]);var _U0=$1.functionmap;for(var _U1=0,_U2=_U0.length;_U1<_U2;_U1++){$F($g(_U0,_U1),function(){$F($k[--$j]);$1.qmv();$p($1.pixs,$k[--$j],0)})}var _UD=$a([function(){$j-=2;$k[$j++]=1},function(){var _U7=$k[--$j];var _U8=$k[--$j];$k[$j++]=$f(_U8+_U7)%2},function(){var _U9=$k[--$j];var _UA=$k[--$j];$k[$j++]=$f($f(_U9+_UA)%3+_UA%3)%2},function(){var _UB=$k[--$j];var _UC=$k[--$j];$k[$j++]=$f(_UC%_UB+$f(_UB%_UC+$f(_UB%3+_UC%3)))%2}]);$1.maskfuncs=_UD;if($1.mask!=-1){$1.maskfuncs=$a([$g($1.maskfuncs,$1.mask-1)]);$1.bestmaskval=$1.mask-1}$1.masks=$a($1.maskfuncs.length);for(var _UO=0,_UN=$1.masks.length-1;_UO<=_UN;_UO+=1){$1.m=_UO;$1.mask=$a($1.size*$1.size);for(var _UU=0,_UT=$f($1.size-1);_UU<=_UT;_UU+=1){$1.j=_UU;for(var _UX=0,_UW=$f($1.size-1);_UX<=_UW;_UX+=1){$1.i=_UX;$k[$j++]=$1.i+1;$k[$j++]=$1.j+1;if($g($1.maskfuncs,$1.m)()===true){break}var _Ud=$k[--$j];$k[$j++]=_Ud==0;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.qmv();var _Uh=$k[--$j];var _Uj=$g($k[--$j],_Uh);var _Uk=$k[--$j];var _Ul=_Uk&&_Uj==-1?1:0;$k[$j++]=_Ul;$k[$j++]=$1.mask;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.qmv();var _Up=$k[--$j];var _Uq=$k[--$j];$p(_Uq,_Up,$k[--$j])}}$p($1.masks,$1.m,$1.mask)}$1.posx=0;$1.posy=0;$1.num=0;for(;;){if($1.posy==$1.size){break}$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.qmv();var _V0=$k[--$j];if($g($k[--$j],_V0)==-1){var _V5=$g($1.cws,~~($1.num/8));var _V7=-(7-$1.num%8);$k[$j++]=(_V7<0?_V5>>>-_V7:_V5<<_V7)&1;$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.qmv();var _VB=$k[--$j];var _VC=$k[--$j];$p(_VC,_VB,$k[--$j]);$1.num=$1.num+1}$1.posx=$1.posx+1;if($1.posx==$1.size){$1.posx=0;$1.posy=$1.posy+1}}$1.evalfulln1n3=function(){$1.scrle=$k[--$j];$k[$j++]="scr1";$k[$j++]=0;$F($1.scrle,function(){var _VL=$k[--$j];$k[$j++]=_VL;if(_VL>=3){var _VM=$k[--$j];var _VO=$f($k[--$j]+_VM*4);$k[$j++]=_VO;$k[$j++]=_VO}$j--});var _VP=$k[--$j];$1[$k[--$j]]=_VP;$1.scr3=0;for(var _VT=5,_VS=$1.scrle.length-1;_VT<=_VS;_VT+=2){$1.j=_VT;if($g($1.scrle,$1.j)%3==0){$1.fact=~~($g($1.scrle,$1.j)/3);var _Vc=$G($1.scrle,$1.j-4,4);for(var _Vd=0,_Ve=_Vc.length;_Vd<_Ve;_Vd++){$k[$j++]=$g(_Vc,_Vd)==$1.fact}var _Vh=$k[--$j];var _Vi=$k[--$j];var _Vj=$k[--$j];var _Vk=$k[--$j];if(_Vk&&(_Vj&&(_Vi&&_Vh))){if($1.j==5||$1.j+2>=$1.scrle.length){$1.scr3=$1.scr3+50}else{if($g($1.scrle,$1.j-5)>=3||$g($1.scrle,$1.j+1)>=3){$1.scr3=$1.scr3+50}}}}}for(var _Vy=1,_Vx=$1.scrle.length-5;_Vy<=_Vx;_Vy+=2){$1.j=_Vy;if($g($1.scrle,$1.j)%3==0){$1.fact=~~($g($1.scrle,$1.j)/3);var _W7=$G($1.scrle,$1.j+1,4);for(var _W8=0,_W9=_W7.length;_W8<_W9;_W8++){$k[$j++]=$g(_W7,_W8)==$1.fact}var _WC=$k[--$j];var _WD=$k[--$j];var _WE=$k[--$j];var _WF=$k[--$j];if(_WF&&(_WE&&(_WD&&_WC))){if($1.j==1||$1.j+6>=$1.scrle.length){$1.scr3=$1.scr3+50}else{if($g($1.scrle,$1.j-1)>=3||$g($1.scrle,$1.j+5)>=3){$1.scr3=$1.scr3+50}}}}}$k[$j++]=$1.scr1;$k[$j++]=$1.scr3};$1.evalfull=function(){$1.sym=$k[--$j];$1.n1=0;$1.n3=0;$1.rle=$a($f($1.size+1));$1.lastpairs=$a($1.size);$1.thispairs=$a($1.size);$1.sizeadd1=$f($1.size+1);for(var _Wd=0,_Wc=$f($1.size-1);_Wd<=_Wc;_Wd+=1){$1.i=_Wd;$k[$j++]=Infinity;var _Wf=$1.size;$k[$j++]=0;$k[$j++]=0;for(var _Wh=$1.i,_Wi=_Wf,_Wg=$f(_Wf*_Wf-1);_Wi<0?_Wh>=_Wg:_Wh<=_Wg;_Wh+=_Wi){var _Wk=$g($1.sym,_Wh);var _Wl=$k[--$j];$k[$j++]=_Wk;if($eq(_Wl,_Wk)){var _Wm=$k[--$j];var _Wn=$k[--$j];$k[$j++]=$f(_Wn+1);$k[$j++]=_Wm}else{var _Wo=$k[--$j];$k[$j++]=1;$k[$j++]=_Wo}}$j--;var _Wq=$m()+2;$as($G($1.rle,0,_Wq-2));$1.evalfulln1n3();$1.n3=$f($k[--$j]+$1.n3);$1.n1=$f($k[--$j]+$1.n1);$j--;$1.symrow=$G($1.sym,$1.i*$1.size,$1.size);$k[$j++]=Infinity;var _X1=$1.symrow;$k[$j++]=0;$k[$j++]=0;for(var _X2=0,_X3=_X1.length;_X2<_X3;_X2++){var _X4=$g(_X1,_X2);var _X5=$k[--$j];$k[$j++]=_X4;if($eq(_X5,_X4)){var _X6=$k[--$j];var _X7=$k[--$j];$k[$j++]=$f(_X7+1);$k[$j++]=_X6}else{var _X8=$k[--$j];$k[$j++]=1;$k[$j++]=_X8}}$j--;var _XA=$m()+2;$as($G($1.rle,0,_XA-2));$1.evalfulln1n3();$1.n3=$f($k[--$j]+$1.n3);$1.n1=$f($k[--$j]+$1.n1);$j--}$k[$j++]=$f($1.n1+$1.n3)};$1.bestscore=999999999;for(var _XK=0,_XJ=$1.masks.length-1;_XK<=_XJ;_XK+=1){$1.m=_XK;$1.masksym=$a($1.size*$1.size);for(var _XR=0,_XQ=$f($1.size*$1.size-1);_XR<=_XQ;_XR+=1){$1.i=_XR;$p($1.masksym,$1.i,$xo($g($1.pixs,$1.i),$g($g($1.masks,$1.m),$1.i)))}if($1.masks.length!=1){$k[$j++]=$1.masksym;$1.evalfull();$1.score=$k[--$j];if($1.score<$1.bestscore){$1.bestsym=$1.masksym;$1.bestmaskval=$1.m;$1.bestscore=$1.score}}else{$1.bestsym=$1.masksym}}$1.pixs=$1.bestsym;$1.funval=((~~($f($1.size-21)/2)+20)*4+$1.eclval)*4+$1.bestmaskval;$k[$j++]=$a([($1.funval&3840)>>>8,($1.funval&240)>>>4,$1.funval&15]);$k[$j++]=4;$k[$j++]=16;$k[$j++]=19;$1.rscodes();$1.funvals=$k[--$j];$k[$j++]=Infinity;$F($1.funvals,function(){$k[$j++]=4;$1.tobin();$F($k[--$j],function(){var _Xw=$k[--$j];$k[$j++]=$f(_Xw-48)})});$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$1.funbits=$a();for(var _Y0=0,_Xz=$1.functionmap.length-1;_Y0<=_Xz;_Y0+=1){$1.i=_Y0;$F($g($1.functionmap,$1.i),function(){var _Y5=$k[--$j];$k[$j++]=$1.pixs;$q(_Y5);$1.qmv();var _Y9=$k[--$j];$p($k[--$j],_Y9,$g($1.funbits,$1.i))})}var _YH=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.size],["pixy",$1.size],["height",$1.size*2/72],["width",$1.size*2/72],["opt",$1.options]]);$k[$j++]=_YH;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_dotcode(){var $1=Object.create(bwipp_dotcode.$ctx||(bwipp_dotcode.$ctx={}));$1.dontdraw=false;$1.rows=-1;$1.columns=-1;$1.ratio=-1;$1.parse=false;$1.parsefnc=false;$1.raw=false;$1.fast=false;$1.mask=-1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.rows!=-1){if($1.rows<5){$k[$j++]="bwipp.dotcodeBadRows#24578";$k[$j++]="There must be at least 5 rows";bwipp_raiseerror()}}if($1.columns!=-1){if($1.columns<5){$k[$j++]="bwipp.dotcodeBadColumns#24584";$k[$j++]="There must be at least 5 columns";bwipp_raiseerror()}}if($1.rows!=-1&&$1.columns!=-1&&($1.rows+$1.columns)%2!=1){$k[$j++]="bwipp.dotcodeRowsColumnsBadParity#24589";$k[$j++]="Sum of rows and columns must be odd";bwipp_raiseerror()}if($1.ratio==-1&&$1.rows==-1&&$1.columns==-1){$1.ratio=3/2}if($1.ratio!=-1){if($1.ratio<=0){$k[$j++]="bwipp.dotcodeRatio#24598";$k[$j++]="The ratio must be greater than 0";bwipp_raiseerror()}}if($1.mask!=-1){if($1.mask<0||$1.mask>3){$k[$j++]="bwipp.dotcodeBadMask#24604";$k[$j++]="Valid mask values are 0 to 3";bwipp_raiseerror()}}if(!bwipp_dotcode.__24621__){(function(){var $ctx=Object.create($1);$ctx.laa=-1;$ctx.lab=-2;$ctx.lac=-3;$ctx.bin=-4;$ctx.sfa=-5;$ctx.sfb=-6;$ctx.sb2=-7;$ctx.sb3=-8;$ctx.sb4=-9;$ctx.sb5=-10;$ctx.sb6=-11;$ctx.sfc=-12;$ctx.sc2=-13;$ctx.sc3=-14;$ctx.sc4=-15;$ctx.sc5=-16;$ctx.sc6=-17;$ctx.sc7=-18;$ctx.bsa=-19;$ctx.bsb=-20;$ctx.tma=-21;$ctx.tmb=-22;$ctx.tmc=-23;$ctx.tms=-24;$ctx.fn1=-25;$ctx.fn2=-26;$ctx.fn3=-27;$ctx.crl=-28;$ctx.aim=-29;$ctx.m05=-30;$ctx.m06=-31;$ctx.m12=-32;$ctx.mac=-33;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_dotcode.$ctx[id]=$ctx[id]);bwipp_dotcode.__24621__=1})()}var _N=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["eci",true],["FNC1",$1.fn1],["FNC3",$1.fn3]]);$1.fncvals=_N;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _Q=$k[--$j];$1[$k[--$j]]=_Q;$1.msglen=$1.msg.length;var _T=$1.msg;$k[$j++]="numecis";$k[$j++]=0;for(var _U=0,_V=_T.length;_U<_V;_U++){if($g(_T,_U)<=-1e6){var _X=$k[--$j];$k[$j++]=$f(_X+1)}}var _Y=$k[--$j];$1[$k[--$j]]=_Y;$1.msgtmp=$a($f($1.msg.length+$1.numecis*6));$1.j=0;for(var _f=0,_e=$1.msg.length-1;_f<=_e;_f+=1){var _h=$g($1.msg,_f);$k[$j++]=_h;if(_h<=-1e6){var _l=$G($R($s(7),-$k[--$j],10),1,6);for(var _m=0,_n=_l.length;_m<_n;_m++){$k[$j++]=$g(_l,_m)}$as($a(6));$P($1.msgtmp,$1.j+1,$k[--$j]);$p($1.msgtmp,$1.j,$1.fn2);$1.j=$1.j+7}else{$p($1.msgtmp,$1.j,$k[--$j]);$1.j=$1.j+1}}$1.msg=$1.msgtmp;$1.msglen=$1.msg.length;if(!bwipp_dotcode.__24720__){(function(){var $ctx=Object.create($1);$ctx.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$ctx.sfb,$ctx.crl,"96"]),$a([$ctx.sb2,9,"97"]),$a([$ctx.sb3,28,"98"]),$a([$ctx.sb4,29,"99"]),$a([$ctx.sb5,30,$ctx.aim]),$a([$ctx.sb6,$ctx.sfa,$ctx.laa]),$a([$ctx.lab,$ctx.laa,$ctx.sfb]),$a([$ctx.sc2,$ctx.sc2,$ctx.sb2]),$a([$ctx.sc3,$ctx.sc3,$ctx.sb3]),$a([$ctx.sc4,$ctx.sc4,$ctx.sb4]),$a([$ctx.lac,$ctx.lac,$ctx.lab]),$a([$ctx.fn1,$ctx.fn1,$ctx.fn1]),$a([$ctx.fn2,$ctx.fn2,$ctx.fn2]),$a([$ctx.fn3,$ctx.fn3,$ctx.fn3]),$a([$ctx.bsa,$ctx.bsa,$ctx.bsa]),$a([$ctx.bsb,$ctx.bsb,$ctx.bsb]),$a([$ctx.bin,$ctx.bin,$ctx.bin])]);$ctx.charvals=$a([new Map,new Map,new Map]);for(var _3d=0,_3c=$ctx.charmaps.length-1;_3d<=_3c;_3d+=1){$ctx.i=_3d;$ctx.encs=$g($ctx.charmaps,$ctx.i);for(var _3h=0;_3h<=2;_3h+=1){$ctx.j=_3h;var _3k=$g($ctx.encs,$ctx.j);$k[$j++]=_3k;if($eq($t(_3k),"stringtype")){var _3n=$g($k[--$j],0);$k[$j++]=_3n}$p($g($ctx.charvals,$ctx.j),$k[--$j],$ctx.i)}}$ctx.Avals=$g($ctx.charvals,0);$ctx.Bvals=$g($ctx.charvals,1);$p($ctx.Bvals,$ctx.m05,97);$p($ctx.Bvals,$ctx.m06,98);$p($ctx.Bvals,$ctx.m12,99);$p($ctx.Bvals,$ctx.mac,100);$ctx.Cvals=$g($ctx.charvals,2);$k[$j++]=Infinity;var _4H=$a([$ctx.sc2,$ctx.sc3,$ctx.sc4,$ctx.sc5,$ctx.sc6,$ctx.sc7,$ctx.tma,$ctx.tmb,$ctx.tmc,$ctx.tms]);$k[$j++]=102;for(var _4I=0,_4J=_4H.length;_4I<_4J;_4I++){var _4M=$f($k[--$j]+1);$k[$j++]=$g(_4H,_4I);$k[$j++]=_4M;$k[$j++]=_4M}$j--;$ctx.BINvals=$d();$ctx.A=0;$ctx.B=1;$ctx.C=2;$ctx.BIN=3;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_dotcode.$ctx[id]=$ctx[id]);bwipp_dotcode.__24720__=1})()}$k[$j++]=Infinity;for(var _4Q=0,_4R=$1.msglen+1;_4Q<_4R;_4Q++){$k[$j++]=0}$1.nDigits=$a();$k[$j++]=Infinity;for(var _4U=0,_4V=$1.msglen+1;_4U<_4V;_4U++){$k[$j++]=false}$1.SeventeenTen=$a();$k[$j++]=Infinity;for(var _4Y=0,_4Z=$1.msglen+1;_4Y<_4Z;_4Y++){$k[$j++]=false}$1.ECI=$a();$k[$j++]=Infinity;for(var _4c=0,_4d=$1.msglen+1;_4c<_4d;_4c++){$k[$j++]=false}$1.DatumA=$a();$k[$j++]=Infinity;for(var _4g=0,_4h=$1.msglen+1;_4g<_4h;_4g++){$k[$j++]=false}$1.DatumB=$a();$k[$j++]=Infinity;for(var _4k=0,_4l=$1.msglen+1;_4k<_4l;_4k++){$k[$j++]=false}$1.DatumC=$a();$k[$j++]=Infinity;for(var _4o=0,_4p=$1.msglen+8;_4o<_4p;_4o++){$k[$j++]=false}$1.Binary=$a();$k[$j++]=Infinity;for(var _4s=0,_4t=$1.msglen+1;_4s<_4t;_4s++){$k[$j++]=0}$1.AheadC=$a();$k[$j++]=Infinity;for(var _4w=0,_4x=$1.msglen+1;_4w<_4x;_4w++){$k[$j++]=0}$1.TryC=$a();$k[$j++]=Infinity;for(var _50=0,_51=$1.msglen+1;_50<_51;_50++){$k[$j++]=0}$1.AheadA=$a();$k[$j++]=Infinity;for(var _54=0,_55=$1.msglen+1;_54<_55;_54++){$k[$j++]=0}$1.AheadB=$a();$k[$j++]=Infinity;for(var _58=0,_59=$1.msglen+1;_58<_59;_58++){$k[$j++]=0}$1.UntilEndSeg=$a();for(var _5C=$1.msglen-1;_5C>=0;_5C-=1){$1.i=_5C;$1.barchar=$g($1.msg,$1.i);if($1.barchar>=48&&$1.barchar<=57){$p($1.nDigits,$1.i,$f($g($1.nDigits,$1.i+1)+1))}var _5P=$g($1.Avals,$1.barchar)!==undefined;if(_5P){$p($1.DatumA,$1.i,true)}var _5U=$g($1.Bvals,$1.barchar)!==undefined;if(_5U){$p($1.DatumB,$1.i,true)}$1.CRLF=false;if($1.barchar==13&&$1.i<$1.msglen-1){if($g($1.msg,$1.i+1)==10){$1.CRLF=true}}if($1.CRLF){$p($1.DatumB,$1.i,true)}if($g($1.nDigits,$1.i)>=2){$p($1.DatumC,$1.i,true)}if($1.barchar<0){$p($1.DatumC,$1.i,true)}if($1.barchar>=128){$p($1.Binary,$1.i,true)}if($g($1.nDigits,$1.i)>=10){$k[$j++]=Infinity;$q($G($1.msg,$1.i,10));for(var _5x=0,_5y=1;_5x<_5y;_5x++){if($k[--$j]!=48){$k[$j++]=false;break}if($k[--$j]!=49){$k[$j++]=false;break}$j-=6;if($k[--$j]!=55){$k[$j++]=false;break}if($k[--$j]!=49){$k[$j++]=false;break}$k[$j++]=true}$p($1.SeventeenTen,$1.i,$k[--$j]);$l()}if($g($1.nDigits,$1.i+1)>=6&&$g($1.msg,$1.i)==$1.fn2){$p($1.ECI,$1.i,true)}if($1.barchar<0&&$1.barchar!=$1.fn3){$p($1.AheadC,$1.i,$f($g($1.AheadC,$1.i+1)+1))}else{if($g($1.nDigits,$1.i)<=1){$p($1.AheadC,$1.i,0)}else{$p($1.AheadC,$1.i,$f($g($1.AheadC,$1.i+2)+1))}}if($g($1.nDigits,$1.i)>0&&$gt($g($1.AheadC,$1.i),$g($1.AheadC,$1.i+1))){$p($1.TryC,$1.i,$g($1.AheadC,$1.i))}if($g($1.DatumA,$1.i)&&$g($1.TryC,$1.i)<2&&$1.barchar!=$1.fn3){$p($1.AheadA,$1.i,$f($g($1.AheadA,$1.i+1)+1))}if($g($1.DatumB,$1.i)&&$g($1.TryC,$1.i)<2&&$1.barchar!=$1.fn3){$k[$j++]=$1.AheadB;$k[$j++]=$1.i;$k[$j++]=$1.AheadB;$k[$j++]=$1.i+1;if($1.CRLF){var _7B=$k[--$j];$k[$j++]=$f(_7B+1)}var _7C=$k[--$j];var _7E=$g($k[--$j],_7C);var _7F=$k[--$j];$p($k[--$j],_7F,$f(_7E+1))}if($1.barchar!=$1.fn3){$p($1.UntilEndSeg,$1.i,$f($g($1.UntilEndSeg,$1.i+1)+1))}}$1.addtocws=function(){var _7O=$k[--$j];$P($1.cws,$1.j,_7O);$1.j=_7O.length+$1.j};$1.base259to103=function(){$1.in=$k[--$j];$1.inlen=$1.in.length;$k[$j++]=Infinity;for(var _7V=0,_7W=5-$1.inlen;_7V<_7W;_7V++){$k[$j++]=0}$q($1.in);$1.in=$a();$1.out=$a(6);$k[$j++]=Infinity;$q($G($1.in,0,2));$1.msbs=$a();$k[$j++]=Infinity;$q($1.msbs);var _7e=$k[--$j];var _7f=$k[--$j];$k[$j++]=$f(_7e+_7f*259);for(var _7g=0,_7h=2;_7g<_7h;_7g++){var _7i=$k[--$j];$k[$j++]=_7i%103;$k[$j++]=~~(_7i/103)}$1.mscs=$a();$k[$j++]=Infinity;$q($G($1.in,2,3));$1.lsbs=$a();$k[$j++]=Infinity;$q($1.lsbs);var _7o=$k[--$j];var _7p=$k[--$j];var _7q=$k[--$j];$k[$j++]=$f($f(_7o+_7p*259)+_7q*67081);for(var _7r=0,_7s=3;_7r<_7s;_7r++){var _7t=$k[--$j];$k[$j++]=_7t%103;$k[$j++]=~~(_7t/103)}$1.lscs=$a();var _7w=$g($1.lscs,0);var _7y=$g($1.mscs,0);$p($1.out,5,$f(_7w+_7y*42)%103);var _81=$g($1.lscs,1);var _83=$g($1.mscs,0);var _85=$g($1.mscs,1);$p($1.out,4,$f($f($f(~~($f(_7w+_7y*42)/103)+_81)+_83*68)+_85*42)%103);var _88=$g($1.lscs,2);var _8A=$g($1.mscs,0);var _8C=$g($1.mscs,1);var _8E=$g($1.mscs,2);$p($1.out,3,$f($f($f($f(~~($f($f($f(~~($f(_7w+_7y*42)/103)+_81)+_83*68)+_85*42)/103)+_88)+_8A*92)+_8C*68)+_8E*42)%103);var _8H=$g($1.lscs,3);var _8J=$g($1.mscs,0);var _8L=$g($1.mscs,1);var _8N=$g($1.mscs,2);$p($1.out,2,$f($f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_7w+_7y*42)/103)+_81)+_83*68)+_85*42)/103)+_88)+_8A*92)+_8C*68)+_8E*42)/103)+_8H)+_8J*15)+_8L*92)+_8N*68)%103);var _8Q=$g($1.mscs,1);var _8S=$g($1.mscs,2);$p($1.out,1,$f($f(~~($f($f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_7w+_7y*42)/103)+_81)+_83*68)+_85*42)/103)+_88)+_8A*92)+_8C*68)+_8E*42)/103)+_8H)+_8J*15)+_8L*92)+_8N*68)/103)+_8Q*15)+_8S*92)%103);$p($1.out,0,$f(~~($f($f(~~($f($f($f($f(~~($f($f($f($f(~~($f($f($f(~~($f(_7w+_7y*42)/103)+_81)+_83*68)+_85*42)/103)+_88)+_8A*92)+_8C*68)+_8E*42)/103)+_8H)+_8J*15)+_8L*92)+_8N*68)/103)+_8Q*15)+_8S*92)/103)+$g($1.mscs,2)*15)%103);$k[$j++]=$G($1.out,6-$1.inlen-1,$1.inlen+1)};$1.finaliseBIN=function(){if($1.bpos!=0){$k[$j++]=$G($1.bvals,0,$1.bpos);$1.base259to103();$q($k[--$j]);$1.bpos=0}};$1.addtobin=function(){$p($1.bvals,$1.bpos,$k[--$j]);$1.bpos=$1.bpos+1;if($1.bpos==5){$1.finaliseBIN()}};$1.ECIabc=function(){var _8n=$G($1.msg,$1.i+1,6);$k[$j++]=0;for(var _8o=0,_8p=_8n.length;_8o<_8p;_8o++){var _8r=$k[--$j];$k[$j++]=$f(_8r+$f($g(_8n,_8o)-48))*10}var _8t=~~($k[--$j]/10);$k[$j++]=_8t;if(_8t>=40){var _8v=$f($k[--$j]-40);var _8w=_8v%12769;$k[$j++]=~~(_8v/12769)+40;$k[$j++]=~~(_8w/113);$k[$j++]=_8w%113}};$1.ECIbin=function(){$k[$j++]=Infinity;var _8z=$G($1.msg,$1.i+1,6);$k[$j++]=0;for(var _90=0,_91=_8z.length;_90<_91;_90++){var _93=$k[--$j];$k[$j++]=$f(_93+$f($g(_8z,_90)-48))*10}var _95=~~($k[--$j]/10);$k[$j++]=_95;if(_95>=65536){var _96=$k[--$j];var _97=_96%65536;$k[$j++]=258;$k[$j++]=~~(_96/65536);$k[$j++]=~~(_97/256);$k[$j++]=_97%256}else{var _98=$k[--$j];$k[$j++]=_98;if(_98>=256){var _99=$k[--$j];$k[$j++]=257;$k[$j++]=~~(_99/256);$k[$j++]=_99%256}else{var _9A=$k[--$j];$k[$j++]=256;$k[$j++]=_9A}}var _9B=$a();for(var _9C=0,_9D=_9B.length;_9C<_9D;_9C++){$k[$j++]=$g(_9B,_9C);$1.addtobin()}};$1.encC=function(){for(var _9F=0,_9G=1;_9F<_9G;_9F++){if($1.i==$1.segstart){for(var _9J=0,_9K=1;_9J<_9K;_9J++){if($1.i>$f($1.segend-7)){$k[$j++]=0;break}if($g($1.msg,$1.segstart)!=91){$k[$j++]=0;break}if($g($1.msg,$1.segstart+1)!=41){$k[$j++]=0;break}if($g($1.msg,$1.segstart+2)!=62){$k[$j++]=0;break}if($g($1.msg,$1.segstart+3)!=30){$k[$j++]=0;break}var _9b=$g($1.msg,$1.segstart+4);if(_9b<48||_9b>57){$k[$j++]=0;break}var _9e=$g($1.msg,$1.segstart+5);if(_9e<48||_9e>57){$k[$j++]=0;break}if($g($1.msg,$f($1.segend-1))!=4){$k[$j++]=0;break}var _9o=$f($f($g($1.msg,$1.segstart+4)-48)*10+$f($g($1.msg,$1.segstart+5)-48));$k[$j++]=_9o;if(_9o!=5&&(_9o!=6&&_9o!=12)){$j--;$k[$j++]=$1.mac;break}if($g($1.msg,$1.segstart+6)!=29){$j--;$k[$j++]=0;break}if($g($1.msg,$f($1.segend-2))!=30){$j--;$k[$j++]=0;break}var _9w=$k[--$j];$k[$j++]=_9w;if(_9w==5){$j--;$k[$j++]=$1.m05;break}if($k[--$j]==6){$k[$j++]=$1.m06;break}$k[$j++]=$1.m12;break}$1.inmac=$k[--$j];if($1.inmac!=0){$k[$j++]=$a([$g($1.Cvals,$1.lab)]);$1.addtocws();$1.mode=$1.B;$k[$j++]=$a([$g($1.Bvals,$1.inmac)]);$1.addtocws();if($1.inmac==$1.mac){$k[$j++]=$a([$g($1.Bvals,$g($1.msg,$1.segstart+4))]);$1.addtocws();$k[$j++]=$a([$g($1.Bvals,$g($1.msg,$1.segstart+5))]);$1.addtocws();$1.i=$1.i+6}else{$1.i=$1.i+7}break}}if($1.i==$1.segstart){if($g($1.nDigits,$1.i)>=2){$k[$j++]=$a([$g($1.Cvals,$1.fn1)]);$1.addtocws()}if($g($1.msg,$1.i)==$1.fn1&&$g($1.nDigits,$1.i+1)>=2){$1.i=$1.i+1}}if($g($1.SeventeenTen,$1.i)){$k[$j++]=$a([$g($1.Cvals,$1.aim),$f($f($g($1.msg,$1.i+2)-48)*10+$f($g($1.msg,$1.i+3)-48)),$f($f($g($1.msg,$1.i+4)-48)*10+$f($g($1.msg,$1.i+5)-48)),$f($f($g($1.msg,$1.i+6)-48)*10+$f($g($1.msg,$1.i+7)-48))]);$1.addtocws();$1.i=$1.i+10;break}if($g($1.DatumC,$1.i)){var _BE=$g($1.msg,$1.i);if(_BE==$1.fn1||(_BE==$1.fn2||_BE==$1.fn3)){$k[$j++]=$a([$g($1.Cvals,$g($1.msg,$1.i))]);$1.addtocws();if($g($1.ECI,$1.i)){$k[$j++]=Infinity;$1.ECIabc();var _BR=$a();$k[$j++]=_BR;$1.addtocws();$1.i=$1.i+7;break}if($g($1.msg,$1.i)==$1.fn3&&$1.segstart!=$1.i){$1.i=$1.i+1;$1.inmac=0;$1.segstart=$1.i;$1.segend=$f($1.i+$g($1.UntilEndSeg,$1.i));break}$1.i=$1.i+1;break}$k[$j++]=$a([$f($f($g($1.msg,$1.i)-48)*10+$f($g($1.msg,$1.i+1)-48))]);$1.addtocws();$1.i=$1.i+2;break}if($g($1.Binary,$1.i)){if($g($1.nDigits,$1.i+1)>0){if($g($1.msg,$1.i)<160){$k[$j++]=$a([$g($1.Cvals,$1.bsa),$g($1.Avals,$f($g($1.msg,$1.i)-128))]);$1.addtocws()}else{$k[$j++]=$a([$g($1.Cvals,$1.bsb),$g($1.Bvals,$f($g($1.msg,$1.i)-128))]);$1.addtocws()}$1.i=$1.i+1;break}$k[$j++]=$a([$g($1.Cvals,$1.bin)]);$1.addtocws();$1.mode=$1.BIN;break}$1.m=$g($1.AheadA,$1.i);$1.n=$g($1.AheadB,$1.i);if($gt($1.m,$1.n)){$k[$j++]=$a([$g($1.Cvals,$1.laa)]);$1.addtocws();$1.mode=$1.A;break}if($1.i==$1.segstart){var _Cc=$g($1.msg,$1.i);if(_Cc==9||(_Cc==28||(_Cc==29||_Cc==30))){$k[$j++]=$a([$g($1.Cvals,$1.laa)]);$1.addtocws();$1.mode=$1.A;break}}if($1.n>4){$k[$j++]=$a([$g($1.Cvals,$1.lab)]);$1.addtocws();$1.mode=$1.B;break}$k[$j++]=$a([$g($1.Cvals,$g($a([$1.sfb,$1.sb2,$1.sb3,$1.sb4]),$f($1.n-1)))]);$1.addtocws();for(var _Cz=0,_D0=$1.n;_Cz<_D0;_Cz++){if($g($1.msg,$1.i)==13){$k[$j++]=$a([$g($1.Bvals,$1.crl)]);$1.addtocws();$1.i=$1.i+2}else{$k[$j++]=$a([$g($1.Bvals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1}}break}};$1.encB=function(){for(var _DG=0,_DH=1;_DG<_DH;_DG++){$1.n=$g($1.TryC,$1.i);if($1.n>=2){if($1.n>4){$k[$j++]=$a([$g($1.Bvals,$1.lac)]);$1.addtocws();$1.mode=$1.C;break}$k[$j++]=$a([$g($1.Bvals,$g($a([$1.sfc,$1.sc2,$1.sc3,$1.sc4]),$f($1.n-1)))]);$1.addtocws();for(var _Dd=0,_De=$1.n;_Dd<_De;_Dd++){if($g($1.msg,$1.i)<0){$k[$j++]=$a([$g($1.Cvals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1}else{$k[$j++]=$a([$f($f($g($1.msg,$1.i)-48)*10+$f($g($1.msg,$1.i+1)-48))]);$1.addtocws();$1.i=$1.i+2}}break}if($g($1.DatumB,$1.i)){var _E2=$g($1.msg,$1.i);if(_E2==$1.fn1||(_E2==$1.fn2||_E2==$1.fn3)){$k[$j++]=$a([$g($1.Bvals,$g($1.msg,$1.i))]);$1.addtocws();if($g($1.ECI,$1.i)){$k[$j++]=Infinity;$1.ECIabc();var _EF=$a();$k[$j++]=_EF;$1.addtocws();$1.i=$1.i+7;break}if($g($1.msg,$1.i)==$1.fn3&&$1.i!=$1.segstart){$1.i=$1.i+1;$1.mode=$1.C;$1.inmac=0;$1.segstart=$1.i;$1.segend=$f($1.i+$g($1.UntilEndSeg,$1.i));break}$1.i=$1.i+1;break}if($g($1.msg,$1.i)==13&&$1.i<$1.msglen-1){if($g($1.msg,$1.i+1)==10){$k[$j++]=$a([$g($1.Bvals,$1.crl)]);$1.addtocws();$1.i=$1.i+2;break}}$k[$j++]=$a([$g($1.Bvals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1;break}if($g($1.Binary,$1.i)){if($g($1.DatumB,$1.i+1)){if($g($1.msg,$1.i)<160){$k[$j++]=$a([$g($1.Bvals,$1.bsa),$g($1.Avals,$f($g($1.msg,$1.i)-128))]);$1.addtocws()}else{$k[$j++]=$a([$g($1.Bvals,$1.bsb),$g($1.Bvals,$f($g($1.msg,$1.i)-128))]);$1.addtocws()}$1.i=$1.i+1;break}$k[$j++]=$a([$g($1.Bvals,$1.bin)]);$1.addtocws();$1.mode=$1.BIN;break}if($g($1.AheadA,$1.i)==1){$k[$j++]=$a([$g($1.Bvals,$1.sfa),$g($1.Avals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1;break}$k[$j++]=$a([$g($1.Bvals,$1.laa)]);$1.addtocws();$1.mode=$1.A;break}};$1.encA=function(){for(var _Fe=0,_Ff=1;_Fe<_Ff;_Fe++){$1.n=$g($1.TryC,$1.i);if($1.n>=2){if($1.n>4){$k[$j++]=$a([$g($1.Avals,$1.lac)]);$1.addtocws();$1.mode=$1.C;break}$k[$j++]=$a([$g($1.Avals,$g($a([$1.sfc,$1.sc2,$1.sc3,$1.sc4]),$f($1.n-1)))]);$1.addtocws();for(var _G1=0,_G2=$1.n;_G1<_G2;_G1++){if($g($1.msg,$1.i)<0){$k[$j++]=$a([$g($1.Cvals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1}else{$k[$j++]=$a([$f($f($g($1.msg,$1.i)-48)*10+$f($g($1.msg,$1.i+1)-48))]);$1.addtocws();$1.i=$1.i+2}}break}if($g($1.DatumA,$1.i)){var _GQ=$g($1.msg,$1.i);if(_GQ==$1.fn1||(_GQ==$1.fn2||_GQ==$1.fn3)){$k[$j++]=$a([$g($1.Avals,$g($1.msg,$1.i))]);$1.addtocws();if($g($1.ECI,$1.i)){$k[$j++]=Infinity;$1.ECIabc();var _Gd=$a();$k[$j++]=_Gd;$1.addtocws();$1.i=$1.i+7;break}if($g($1.msg,$1.i)==$1.fn3&&$1.i!=$1.segstart){$1.i=$1.i+1;$1.mode=$1.C;$1.inmac=0;$1.segstart=$1.i;$1.segend=$f($1.i+$g($1.UntilEndSeg,$1.i));break}$1.i=$1.i+1;break}$k[$j++]=$a([$g($1.Avals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1;break}if($g($1.Binary,$1.i)){if($g($1.DatumA,$1.i+1)){if($g($1.msg,$1.i)<160){$k[$j++]=$a([$g($1.Avals,$1.bsa),$g($1.Avals,$f($g($1.msg,$1.i)-128))]);$1.addtocws()}else{$k[$j++]=$a([$g($1.Avals,$1.bsb),$g($1.Bvals,$f($g($1.msg,$1.i)-128))]);$1.addtocws()}$1.i=$1.i+1;break}$k[$j++]=$a([$g($1.Avals,$1.bin)]);$1.addtocws();$1.mode=$1.BIN;break}$1.n=$g($1.AheadB,$1.i);if($1.n>6){$k[$j++]=$a([$g($1.Avals,$1.lab)]);$1.addtocws();$1.mode=$1.B;break}$k[$j++]=$a([$g($1.Avals,$g($a([$1.sfb,$1.sb2,$1.sb3,$1.sb4,$1.sb5,$1.sb6]),$f($1.n-1)))]);$1.addtocws();for(var _Ht=0,_Hu=$1.n;_Ht<_Hu;_Ht++){if($g($1.msg,$1.i)==13){$k[$j++]=$a([$g($1.Bvals,$1.crl)]);$1.addtocws();$1.i=$1.i+2}else{$k[$j++]=$a([$g($1.Bvals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1}}break}};$1.encBIN=function(){for(var _IA=0,_IB=1;_IA<_IB;_IA++){$1.n=$g($1.TryC,$1.i);if($1.n>=2){$k[$j++]=Infinity;$1.finaliseBIN();var _IG=$a();$k[$j++]=_IG;$1.addtocws();if($1.n>7){$k[$j++]=$a([$g($1.BINvals,$1.tmc)]);$1.addtocws();$1.mode=$1.C;break}$k[$j++]=$a([$g($1.BINvals,$g($a([$1.sc2,$1.sc3,$1.sc4,$1.sc5,$1.sc6,$1.sc7]),$f($1.n-2)))]);$1.addtocws();for(var _Ia=0,_Ib=$1.n;_Ia<_Ib;_Ia++){if($g($1.msg,$1.i)<0){$k[$j++]=$a([$g($1.Cvals,$g($1.msg,$1.i))]);$1.addtocws();$1.i=$1.i+1}else{$k[$j++]=$a([$f($f($g($1.msg,$1.i)-48)*10+$f($g($1.msg,$1.i+1)-48))]);$1.addtocws();$1.i=$1.i+2}}break}if($g($1.ECI,$1.i)&&$g($1.Binary,$1.i+7)){$k[$j++]=Infinity;$1.ECIbin();var _J0=$a();$k[$j++]=_J0;$1.addtocws();$1.i=$1.i+7;if($1.i==$1.msglen){$k[$j++]=Infinity;$1.finaliseBIN();var _J4=$a();$k[$j++]=_J4;$1.addtocws()}break}if($g($1.msg,$1.i)>=0){if($g($1.Binary,$1.i)||$g($1.Binary,$1.i+1)||$g($1.Binary,$1.i+2)||$g($1.Binary,$1.i+3)||$g($1.ECI,$1.i+1)&&$g($1.Binary,$1.i+8)){$k[$j++]=Infinity;$k[$j++]=$g($1.msg,$1.i);$1.addtobin();var _JT=$a();$k[$j++]=_JT;$1.addtocws();$1.i=$1.i+1;if($1.i==$1.msglen){$k[$j++]=Infinity;$1.finaliseBIN();var _JX=$a();$k[$j++]=_JX;$1.addtocws()}break}}$k[$j++]=Infinity;$1.finaliseBIN();var _JY=$a();$k[$j++]=_JY;$1.addtocws();if($1.i!=$1.msglen-1){if($g($1.msg,$1.i)==$1.fn3&&$1.i!=$1.segstart){$k[$j++]=$a([$g($1.BINvals,$1.tms)]);$1.addtocws();$1.i=$1.i+1;$1.mode=$1.C;$1.inmac=0;$1.segstart=$1.i;$1.segend=$f($1.i+$g($1.UntilEndSeg,$1.i));break}if($gt($g($1.AheadA,$1.i),$g($1.AheadB,$1.i))){$k[$j++]=$a([$g($1.BINvals,$1.tma)]);$1.addtocws();$1.mode=$1.A}else{$k[$j++]=$a([$g($1.BINvals,$1.tmb)]);$1.addtocws();$1.mode=$1.B}break}break}};$1.cws=$a($1.msglen*2+1);$1.mode=$1.C;$1.bvals=$a(5);$1.bpos=0;$1.inmac=0;$1.segstart=0;$1.segend=$g($1.UntilEndSeg,0);$1.i=0;$1.j=0;for(;;){if($1.i>=$1.msglen){break}if($1.inmac!=0){if($1.inmac!=$1.mac&&$1.i==$f($1.segend-2)){$1.i=$1.i+2;if($1.i>=$1.msglen){break}}if($1.inmac==$1.mac&&$1.i==$f($1.segend-1)){$1.i=$1.i+1;if($1.i>=$1.msglen){break}}}if($1[$g($a(["encA","encB","encC","encBIN"]),$1.mode)]()===true){break}}$1.cws=$G($1.cws,0,$1.j);$1.nd=$1.cws.length;$1.minarea=(($1.nd+3+~~($1.nd/2))*9+2)*2;if($1.ratio!=-1){$1.hgt=Math.sqrt($1.minarea/$1.ratio);$1.wid=Math.sqrt($1.minarea*$1.ratio);$1.h=~~$1.hgt;$1.w=~~$1.wid;if(($1.h+$1.w)%2==1){if($1.h*$1.w<$1.minarea){$1.h=$1.h+1;$1.w=$1.w+1}}else{if($1.hgt*$1.w<$1.wid*$1.h){$1.w=$1.w+1;if($1.h*$1.w<$1.minarea){$1.w=$1.w-1;$1.h=$1.h+1;if($1.h*$1.w<$1.minarea){$1.w=$1.w+2}}}else{$1.h=$1.h+1;if($1.h*$1.w<$1.minarea){$1.h=$1.h-1;$1.w=$1.w+1;if($1.h*$1.w<$1.minarea){$1.h=$1.h+2}}}}$1.rows=$1.h;$1.columns=$1.w}else{if($1.columns==-1){var _LN=~~(($1.minarea+$1.rows-1)/$1.rows);$k[$j++]="columns";$k[$j++]=_LN;if((_LN+$1.rows)%2==0){var _LP=$k[--$j];$k[$j++]=$f(_LP+1)}var _LQ=$k[--$j];$1[$k[--$j]]=_LQ}if($1.rows==-1){var _LW=~~(($1.minarea+$1.columns-1)/$1.columns);$k[$j++]="rows";$k[$j++]=_LW;if((_LW+$1.columns)%2==0){var _LY=$k[--$j];$k[$j++]=$f(_LY+1)}var _LZ=$k[--$j];$1[$k[--$j]]=_LZ}}$1.ndots=~~($1.rows*$1.columns/2);for(;;){var _Le=$1.nd+1;if((_Le+(~~(_Le/2)+3))*9+2>$1.ndots){break}$1.nd=$1.nd+1}$1.nc=~~($1.nd/2)+3;$1.nw=$1.nd+$1.nc;$1.rembits=$1.ndots-($1.nw*9+2);if($1.nd>$1.cws.length){$k[$j++]=Infinity;$q($1.cws);var _Lr=$1.mode==$1.BIN?109:106;$k[$j++]=_Lr;for(var _Lu=0,_Lv=$1.nd-$1.cws.length-1;_Lu<_Lv;_Lu++){$k[$j++]=106}$1.cws=$a()}var _Ly=$g($1.options,"debugcws")!==undefined;if(_Ly){$k[$j++]="bwipp.debugcws#25277";$k[$j++]=$1.cws;bwipp_raiseerror()}if($1.nw*9>$1.ndots-2){$k[$j++]="bwipp.dotcodeTooLong#25281";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}if(!bwipp_dotcode.__25311__){(function(){var $ctx=Object.create($1);$ctx.encs=$a(["101010101","010101011","010101101","010110101","011010101","101010110","101011010","101101010","110101010","010101110","010110110","010111010","011010110","011011010","011101010","100101011","100101101","100110101","101001011","101001101","101010011","101011001","101100101","101101001","110010101","110100101","110101001","001010111","001011011","001011101","001101011","001101101","001110101","010010111","010011011","010011101","010100111","010110011","010111001","011001011","011001101","011010011","011011001","011100101","011101001","100101110","100110110","100111010","101001110","101011100","101100110","101101100","101110010","101110100","110010110","110011010","110100110","110101100","110110010","110110100","111001010","111010010","111010100","001011110","001101110","001110110","001111010","010011110","010111100","011001110","011011100","011100110","011101100","011110010","011110100","100010111","100011011","100011101","100100111","100110011","100111001","101000111","101100011","101110001","110001011","110001101","110010011","110011001","110100011","110110001","111000101","111001001","111010001","000101111","000110111","000111011","000111101","001001111","001100111","001110011","001111001","010001111","011000111","011100011","011110001","100011110","100111100","101111000","110001110","110011100","110111000","111000110","111001100"]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_dotcode.$ctx[id]=$ctx[id]);bwipp_dotcode.__25311__=1})()}if($1.rows%2==0){$1.sixedges=$a([$a([$1.columns-1,$1.rows-2]),$a([0,$1.rows-2]),$a([$1.columns-2,$1.rows-1]),$a([1,$1.rows-1]),$a([$1.columns-1,0]),$a([0,0])])}else{$1.sixedges=$a([$a([$1.columns-2,0]),$a([$1.columns-2,$1.rows-1]),$a([$1.columns-1,1]),$a([$1.columns-1,$1.rows-2]),$a([0,0]),$a([0,$1.rows-1])])}$1.dmv=function(){var _MY=$k[--$j];var _MZ=$k[--$j];$k[$j++]=$f(_MZ+_MY*$1.columns)};$1.outline=$a($1.rows*$1.columns);for(var _Mf=0,_Me=$1.rows-1;_Mf<=_Me;_Mf+=1){$1.y=_Mf;for(var _Mi=0,_Mh=$1.columns-1;_Mi<=_Mh;_Mi+=1){$1.x=_Mi;$k[$j++]=$1.outline;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.dmv();var _Mo=$k[--$j];$p($k[--$j],_Mo,($1.x+$1.y)%2-1)}}var _Mq=$1.sixedges;for(var _Mr=0,_Ms=_Mq.length;_Mr<_Ms;_Mr++){$k[$j++]=$1.outline;$q($g(_Mq,_Mr));$1.dmv();var _Mv=$k[--$j];$p($k[--$j],_Mv,1)}$1.clearcol=function(){$1.x=$k[--$j];$k[$j++]=true;for(var _N1=$1.x&1,_N0=$1.rows-1;_N1<=_N0;_N1+=2){$k[$j++]=$1.x;$k[$j++]=_N1;$1.dmv();if($g($1.sym,$k[--$j])==1){$j--;$k[$j++]=false;break}}};$1.clearrow=function(){$1.y=$k[--$j];$k[$j++]=true;for(var _NA=$1.y&1,_N9=$1.columns-1;_NA<=_N9;_NA+=2){$k[$j++]=_NA;$k[$j++]=$1.y;$1.dmv();if($g($1.sym,$k[--$j])==1){$j--;$k[$j++]=false;break}}};$1.evalsymbol=function(){$1.sym=$k[--$j];$1.worst=9999999;var _NK=$a([$a(["x",0]),$a(["x",1]),$a(["y",0]),$a(["y",1])]);for(var _NL=0,_NM=_NK.length;_NL<_NM;_NL++){$q($g(_NK,_NL));$1.fl=$k[--$j];$1.dir=$k[--$j];$1.sum=0;$1.first=-1;$1.last=-1;var _NR=$eq($1.dir,"x")?$1.columns:$1.rows;for(var _NT=0,_NS=_NR-1;_NT<=_NS;_NT+=1){$1[$1.dir]=_NT;var _NV=$1.sym;var _NX=$1[$1.dir];var _NZ=$eq($1.dir,"x")?$1.rows:$1.columns;var _Nc=(_NZ-1)*$1.fl;if($eq($1.dir,"y")){var _=_Nc;_Nc=_NX;_NX=_}$k[$j++]=_NV;$k[$j++]=_NX;$k[$j++]=_Nc;$1.dmv();var _Nd=$k[--$j];if($g($k[--$j],_Nd)==1){if($1.first==-1){$1.first=$1[$1.dir]}$1.last=$1[$1.dir];$1.sum=$1.sum+1}}var _Nq=$eq($1.dir,"x")?$1.rows:$1.columns;var _Nr=$f($f($1.sum+$1.last)-$1.first)*_Nq;$k[$j++]=_Nr;if(_Nr<$1.worst){$1.worst=$k[--$j]}else{$j--}}$1.pen=0;if($1.rows%2==1||$1.rows<=12){$1.sum=0;$1.p=0;for(var _Ny=1,_Nx=$1.columns-2;_Ny<=_Nx;_Ny+=1){$k[$j++]=_Ny;$1.clearcol();if($k[--$j]){$1.sum=$1.sum+1;$k[$j++]="p";if($1.sum==1){$k[$j++]=$1.rows}else{$k[$j++]=$1.p*$1.rows}var _O5=$k[--$j];$1[$k[--$j]]=_O5}else{$1.sum=0;$1.pen=$1.pen+$1.p;$1.p=0}}$1.pen=$1.pen+$1.p}if($1.rows%2==0||$1.columns<=12){$1.sum=0;$1.p=0;for(var _OF=1,_OE=$1.rows-2;_OF<=_OE;_OF+=1){$k[$j++]=_OF;$1.clearrow();if($k[--$j]){$1.sum=$1.sum+1;$k[$j++]="p";if($1.sum==1){$k[$j++]=$1.columns}else{$k[$j++]=$1.p*$1.columns}var _OM=$k[--$j];$1[$k[--$j]]=_OM}else{$1.sum=0;$1.pen=$1.pen+$1.p;$1.p=0}}$1.pen=$1.pen+$1.p}$k[$j++]=Infinity;for(var _OT=0,_OU=($1.columns+4)*2;_OT<_OU;_OT++){$k[$j++]=0}for(var _OY=0,_OZ=$1.columns,_OX=$1.sym.length-1;_OZ<0?_OY>=_OX:_OY<=_OX;_OY+=_OZ){$k[$j++]=0;$k[$j++]=0;$q($G($1.sym,_OY,$1.columns));$k[$j++]=0;$k[$j++]=0}for(var _Oe=0,_Of=($1.columns+4)*2;_Oe<_Of;_Oe++){$k[$j++]=0}$1.symp=$a();$1.columns=$1.columns+4;$1.rows=$1.rows+4;$1.sum=0;for(var _Ol=2,_Ok=$1.rows-3;_Ol<=_Ok;_Ol+=1){$1.y=_Ol;for(var _Op=($1.y&1)+2,_Oo=$1.columns-3;_Op<=_Oo;_Op+=2){$1.x=_Op;for(var _Oq=0,_Or=1;_Oq<_Or;_Oq++){$k[$j++]=$1.symp;$k[$j++]=$1.x-1;$k[$j++]=$1.y-1;$1.dmv();var _Ov=$k[--$j];if($g($k[--$j],_Ov)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x+1;$k[$j++]=$1.y-1;$1.dmv();var _P1=$k[--$j];if($g($k[--$j],_P1)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x-1;$k[$j++]=$1.y+1;$1.dmv();var _P7=$k[--$j];if($g($k[--$j],_P7)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x+1;$k[$j++]=$1.y+1;$1.dmv();var _PD=$k[--$j];if($g($k[--$j],_PD)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.dmv();var _PJ=$k[--$j];if($g($k[--$j],_PJ)==0){$1.sum=$1.sum+1;break}$k[$j++]=$1.symp;$k[$j++]=$1.x-2;$k[$j++]=$1.y;$1.dmv();var _PQ=$k[--$j];if($g($k[--$j],_PQ)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x;$k[$j++]=$1.y-2;$1.dmv();var _PW=$k[--$j];if($g($k[--$j],_PW)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x+2;$k[$j++]=$1.y;$1.dmv();var _Pc=$k[--$j];if($g($k[--$j],_Pc)==1){break}$k[$j++]=$1.symp;$k[$j++]=$1.x;$k[$j++]=$1.y+2;$1.dmv();var _Pi=$k[--$j];if($g($k[--$j],_Pi)==1){break}$1.sum=$1.sum+1}}}$1.columns=$1.columns-4;$1.rows=$1.rows-4;if($1.worst==0){$k[$j++]=-99999}else{$k[$j++]=$f($f($1.worst-$1.sum*$1.sum)-$1.pen)}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Pt=0,_Pu=112;_Pt<_Pu;_Pt++){var _Pv=$k[--$j];$k[$j++]=_Pv;$k[$j++]=_Pv*3%113}$1.rsalog=$a();$1.step=~~($1.nw/112)+1;$1.offset=function(){var _Pz=$k[--$j];$k[$j++]=$f(_Pz*$1.step+$1.start)};$1.bestscore=-99999999;$k[$j++]="masks";if($1.mask!=-1){$k[$j++]=$a([$1.mask])}else{if($1.fast){$k[$j++]=$a([3,2,1,0])}else{$k[$j++]=$a([0,1,2,3])}}var _Q7=$k[--$j];$1[$k[--$j]]=_Q7;$1.litmasks=$a(4);$F($1.masks,function(){$1.mask=$k[--$j];$k[$j++]=Infinity;var _QG=$1.cws;$k[$j++]=$1.mask;$k[$j++]=$g($a([0,3,7,17]),$1.mask);$k[$j++]=0;for(var _QH=0,_QI=_QG.length;_QH<_QI;_QH++){var _QK=$k[--$j];var _QL=$k[--$j];$k[$j++]=$f($g(_QG,_QH)+_QK)%113;$k[$j++]=_QL;$k[$j++]=$f(_QK+_QL)}$j-=2;for(var _QN=0,_QO=$1.nc;_QN<_QO;_QN++){$k[$j++]=0}$1.rscws=$a();for(var _QS=0,_QR=$1.step-1;_QS<=_QR;_QS+=1){$1.start=_QS;$1.ND=~~(($1.nd+1-$1.start+$1.step-1)/$1.step);$1.NW=~~(($1.nw+1-$1.start+$1.step-1)/$1.step);$1.NC=$1.NW-$1.ND;$k[$j++]=Infinity;$k[$j++]=1;for(var _Qe=0,_Qf=$1.NC;_Qe<_Qf;_Qe++){$k[$j++]=0}$1.coeffs=$a();for(var _Qj=1,_Qi=$1.NC;_Qj<=_Qi;_Qj+=1){$1.i=_Qj;for(var _Ql=$1.NC;_Ql>=1;_Ql-=1){$1.j=_Ql;$p($1.coeffs,$1.j,$f($f($g($1.coeffs,$1.j)+113)-$g($1.rsalog,$1.i)*$g($1.coeffs,$1.j-1)%113)%113)}}for(var _Qz=0,_Qy=$1.ND-1;_Qz<=_Qy;_Qz+=1){$k[$j++]="t";$k[$j++]=$1.rscws;$k[$j++]=_Qz;$1.offset();var _R1=$k[--$j];var _R3=$g($k[--$j],_R1);$k[$j++]=_R3;$k[$j++]=$1.rscws;$k[$j++]=$1.ND;$1.offset();var _R6=$k[--$j];var _R8=$g($k[--$j],_R6);var _R9=$k[--$j];$1[$k[--$j]]=$f(_R9+_R8)%113;for(var _RD=0,_RC=$1.NC-2;_RD<=_RC;_RD+=1){$1.j=_RD;$k[$j++]=$1.rscws;$k[$j++]=$1.ND+$1.j;$1.offset();$k[$j++]=$1.rscws;$k[$j++]=$1.ND+$1.j+1;$1.offset();var _RK=$k[--$j];var _RM=$g($k[--$j],_RK);var _RR=$k[--$j];$p($k[--$j],_RR,$f($f(_RM+113)-$1.t*$g($1.coeffs,$1.j+1)%113)%113)}$k[$j++]=$1.rscws;$k[$j++]=$1.ND+$1.NC-1;$1.offset();var _Ra=$k[--$j];$p($k[--$j],_Ra,$f(113-$1.t*$g($1.coeffs,$1.NC)%113)%113)}for(var _Rf=$1.ND,_Re=$1.NW-1;_Rf<=_Re;_Rf+=1){$k[$j++]=_Rf;$k[$j++]=$1.rscws;$k[$j++]=_Rf;$1.offset();var _Ri=$k[--$j];var _Rj=$k[--$j];var _Rk=$k[--$j];$k[$j++]=_Rj;$k[$j++]=_Ri;$k[$j++]=113;$k[$j++]=$1.rscws;$k[$j++]=_Rk;$1.offset();var _Rl=$k[--$j];var _Rn=$g($k[--$j],_Rl);var _Ro=$k[--$j];var _Rp=$k[--$j];$p($k[--$j],_Rp,$f(_Ro-_Rn)%113)}}$1.bits=$s($1.ndots);$P($1.bits,0,$g($a(["00","01","10","11"]),$1.mask));for(var _Rz=1,_Ry=$1.nw;_Rz<=_Ry;_Rz+=1){$1.i=_Rz;$P($1.bits,($1.i-1)*9+2,$g($1.encs,$g($1.rscws,$1.i)))}if($1.rembits>0){$P($1.bits,$1.nw*9+2,$G("11111111111111111",0,$1.rembits))}var _SC=$1.outline;$1.pixs=$A($a(_SC.length),_SC);$1.posx=0;$k[$j++]="posy";if($1.rows%2==0){$k[$j++]=0}else{$k[$j++]=$1.rows-1}var _SH=$k[--$j];$1[$k[--$j]]=_SH;var _SL=$G($1.bits,0,$1.bits.length-6);for(var _SM=0,_SN=_SL.length;_SM<_SN;_SM++){$k[$j++]=$g(_SL,_SM);for(;;){$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.dmv();var _SS=$k[--$j];if($g($k[--$j],_SS)==-1){break}if($1.rows%2==0){$1.posy=$1.posy+1;if($1.posy==$1.rows){$1.posy=0;$1.posx=$1.posx+1}}else{$1.posx=$1.posx+1;if($1.posx==$1.columns){$1.posx=0;$1.posy=$1.posy-1}}}$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.dmv();var _Sh=$k[--$j];var _Si=$k[--$j];$p(_Si,_Sh,$f($k[--$j]-48))}for(var _Sk=0;_Sk<=5;_Sk+=1){$1.i=_Sk;$k[$j++]=$1.pixs;$q($g($1.sixedges,$1.i));$1.dmv();var _St=$k[--$j];$p($k[--$j],_St,$g($1.bits,$1.bits.length-6+$1.i)-48)}$k[$j++]="score";$k[$j++]=$1.pixs;$1.evalsymbol();var _Sw=$k[--$j];$1[$k[--$j]]=_Sw;if($1.score>$1.bestscore){$1.bestsym=$1.pixs;$1.bestscore=$1.score;if($1.fast&&$1.bestscore>~~($1.rows*$1.columns/2)){return true}}var _T6=$1.pixs;$1.litmask=$A($a(_T6.length),_T6);for(var _T9=0;_T9<=5;_T9+=1){$1.i=_T9;$k[$j++]=$1.litmask;$q($g($1.sixedges,$1.i));$1.dmv();var _TE=$k[--$j];$p($k[--$j],_TE,1)}$p($1.litmasks,$1.mask,$1.litmask);if($1.fast){$k[$j++]="score";$k[$j++]=$1.litmask;$1.evalsymbol();var _TL=$k[--$j];$1[$k[--$j]]=_TL;if($gt($1.score,$1.bestscore)){$1.bestsym=$1.litmask;$1.bestscore=$1.score;if($1.bestscore>~~($1.rows*$1.columns/2)){return true}}}});$1.pixs=$1.bestsym;if(!$1.fast&&$1.bestscore<=~~($1.rows*$1.columns/2)){$1.bestscore=-99999999;$F($1.masks,function(){$1.litmask=$g($1.litmasks,$k[--$j]);$k[$j++]="score";$k[$j++]=$1.litmask;$1.evalsymbol();var _Te=$k[--$j];$1[$k[--$j]]=_Te;if($1.score>$1.bestscore){$1.bestsym=$1.litmask;$1.bestscore=$1.score}});$1.pixs=$1.bestsym}var _Tr=new Map([["ren",bwipp_renmatrix],["dotty",true],["pixs",$1.pixs],["pixx",$1.columns],["pixy",$1.rows],["height",$1.rows*2/72],["width",$1.columns*2/72],["opt",$1.options]]);$k[$j++]=_Tr;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_ultracode(){var $1=Object.create(bwipp_ultracode.$ctx||(bwipp_ultracode.$ctx={}));$1.dontdraw=false;$1.eclevel="EC2";$1.parse=false;$1.parsefnc=false;$1.start=257;$1.link1=0;$1.raw=false;$1.rev=2;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _2=$1.rev;if(_2!=1&&_2!=2){$k[$j++]="bwipp.ultracodeInvalidRevision#25672";$k[$j++]="Valid revisions are 1 and 2";bwipp_raiseerror()}var _4=$1.eclevel.length==3;$k[$j++]=_4;if(_4){$j--;$k[$j++]=$G($1.eclevel,0,2);if($eq("EC","EC")){$j--;var _9=$g($1.eclevel,2)-48;var _B=$1.rev==2?1:0;$k[$j++]=_9>=_B&&_9<=5}}if($nt($k[--$j])){$k[$j++]="bwipp.ultracodeInvalidErrorCorrectionLevel#25681";$k[$j++]="Valid error correction levels are EC1 to EC5, and EC0 for legacy revision 1";bwipp_raiseerror()}if($1.raw){$1.dcws=$a($1.barcode.length);$1.i=0;$1.j=0;for(;;){if($1.i==$1.barcode.length){break}$1.cw=$i($G($1.barcode,$1.i+1,3));$p($1.dcws,$1.j,$1.cw);$1.i=$1.i+4;$1.j=$1.j+1}$1.dcws=$G($1.dcws,0,$1.j)}else{$1.fn1=-1;$1.fn3=-2;var _X=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["FNC1",$1.fn1],["FNC3",$1.fn3]]);$1.fncvals=_X;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _a=$k[--$j];$1[$k[--$j]]=_a;$1.msglen=$1.msg.length;$1.scr=$a([]);$1.scp=$a([]);$k[$j++]=Infinity;$q($1.scr);$q($1.scp);$F($1.msg,function(){var _i=$k[--$j];$k[$j++]=_i;if(_i==$1.fn1){$j--;$k[$j++]=268}var _k=$k[--$j];$k[$j++]=_k;if(_k==$1.fn3){$j--;$k[$j++]=269}});$1.dcws=$a()}var _o=$g($1.options,"debugcws")!==undefined;if(_o){$k[$j++]="bwipp.debugcws#25725";$k[$j++]=$1.dcws;bwipp_raiseerror()}$1.mcc=$1.dcws.length+3;$1.eclval=$g($1.eclevel,2)-48;if($1.eclval!=0){$k[$j++]="qcc";$k[$j++]=$g($a([0,1,2,4,6,8]),$1.eclval);$k[$j++]=~~($1.mcc/25);if($1.mcc%25!=0){var _z=$k[--$j];$k[$j++]=$f(_z+1)}var _10=$k[--$j];var _11=$k[--$j];$1[$k[--$j]]=$f(_11*_10+5)}else{$1.qcc=3}$1.acc=$1.qcc-3+78*$1.link1;$1.tcc=$1.mcc+$1.qcc;if(!bwipp_ultracode.__25747__){(function(){var $ctx=Object.create($1);$ctx.metrics=$a([$a([2,7,37,5]),$a([3,36,84,13]),$a([4,85,161,22]),$a([5,142,282,29])]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ultracode.$ctx[id]=$ctx[id]);bwipp_ultracode.__25747__=1})()}var _1D=$1.metrics;for(var _1E=0,_1F=_1D.length;_1E<_1F;_1E++){$1.m=$g(_1D,_1E);$1.rows=$g($1.m,0);$1.minc=$g($1.m,1);$1.maxc=$g($1.m,2);$1.mcol=$g($1.m,3);$1.okay=true;if($1.tcc<$1.minc||$1.tcc>$1.maxc){$1.okay=false}if($1.okay){break}}if(!$1.okay){$k[$j++]="bwipp.ultracodeNoValidSymbol#25761";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}for(var _1W=$1.mcol;_1W<=61;_1W+=1){$1.columns=_1W;$k[$j++]=$1.columns;if($1.columns>=15){var _1Z=$k[--$j];$k[$j++]=$f(_1Z-1)}if($1.columns>=31){var _1b=$k[--$j];$k[$j++]=$f(_1b-1)}if($1.columns>=47){var _1d=$k[--$j];$k[$j++]=$f(_1d-1)}var _1h=$f($f($k[--$j]*$1.rows-3)-$1.tcc);$k[$j++]=_1h;if(_1h>=0){$1.pads=$k[--$j];break}$j--}$1.dcc=$f($1.columns-$1.mcol);$k[$j++]=Infinity;$k[$j++]=$1.start;$k[$j++]=$1.mcc;$k[$j++]=$1.acc;$q($1.dcws);for(var _1q=0,_1r=$1.qcc;_1q<_1r;_1q++){$k[$j++]=0}$k[$j++]=0;$1.rsseq=$a();$k[$j++]=Infinity;$k[$j++]=1;for(var _1t=0,_1u=282;_1t<_1u;_1t++){var _1v=$k[--$j];$k[$j++]=_1v;$k[$j++]=_1v*3%283}$1.rsalog=$a();$1.rslog=$a(283);for(var _1y=1;_1y<=282;_1y+=1){$p($1.rslog,$g($1.rsalog,_1y),_1y)}$1.rsprod=function(){var _22=$k[--$j];var _23=$k[--$j];$k[$j++]=_23;$k[$j++]=_22;if(_22!=0&&_23!=0){var _26=$g($1.rslog,$k[--$j]);var _2B=$g($1.rsalog,$f(_26+$g($1.rslog,$k[--$j]))%282);$k[$j++]=_2B}else{$j-=2;$k[$j++]=0}};$1.n=$1.mcc;$1.k=$1.qcc;$k[$j++]=Infinity;$k[$j++]=1;for(var _2F=0,_2G=$1.k;_2F<_2G;_2F++){$k[$j++]=0}$1.coeffs=$a();for(var _2K=1,_2J=$1.k;_2K<=_2J;_2K+=1){$1.i=_2K;$p($1.coeffs,$1.i,$g($1.coeffs,$1.i-1));for(var _2R=$1.i-1;_2R>=1;_2R-=1){$1.j=_2R;$k[$j++]=$1.coeffs;$k[$j++]=$1.j;$k[$j++]=$g($1.coeffs,$1.j-1);$k[$j++]=$g($1.coeffs,$1.j);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _2d=$k[--$j];var _2e=$k[--$j];var _2f=$k[--$j];$p($k[--$j],_2f,$f(_2e+_2d)%283)}$k[$j++]=$1.coeffs;$k[$j++]=0;$k[$j++]=$g($1.coeffs,0);$k[$j++]=$g($1.rsalog,$1.i);$1.rsprod();var _2n=$k[--$j];var _2o=$k[--$j];$p($k[--$j],_2o,_2n)}$1.coeffs=$G($1.coeffs,0,$1.coeffs.length-1);for(var _2u=$1.coeffs.length-1;_2u>=0;_2u-=2){var _2v=$1.coeffs;$p(_2v,_2u,$f(283-$g(_2v,_2u)))}for(var _2z=0,_2y=$1.n-1;_2z<=_2y;_2z+=1){$1.t=$f($g($1.rsseq,_2z)+$g($1.rsseq,$1.n))%283;for(var _37=0,_36=$1.k-1;_37<=_36;_37+=1){$1.j=_37;$p($1.rsseq,$1.n+$1.j,$f($g($1.rsseq,$1.n+$1.j+1)+$f(283-$1.t*$g($1.coeffs,$1.k-$1.j-1)%283))%283)}}for(var _3O=$1.n,_3N=$1.n+$1.k;_3O<=_3N;_3O+=1){$p($1.rsseq,_3O,$f(283-$g($1.rsseq,_3O))%283)}$1.ecws=$G($1.rsseq,$1.n,$1.k);var _3X=$g($1.options,"debugecc")!==undefined;if(_3X){$k[$j++]="bwipp.debugecc#25829";$k[$j++]=$1.ecws;bwipp_raiseerror()}if(!bwipp_ultracode.__25888__){(function(){var $ctx=Object.create($1);$ctx.tiles=$a([13135,13136,13153,13156,13163,13165,13513,13515,13516,13531,13535,13536,13561,13563,13565,13613,13615,13616,13631,13635,13636,13651,13653,13656,15135,15136,15153,15163,15165,15313,15315,15316,15351,15353,15356,15361,15363,15365,15613,15615,15616,15631,15635,15636,15651,15653,15656,16135,16136,16153,16156,16165,16313,16315,16316,16351,16353,16356,16361,16363,16365,16513,16515,16516,16531,16535,16536,16561,16563,16565,31315,31316,31351,31356,31361,31365,31513,31515,31516,31531,31535,31536,31561,31563,31565,31613,31615,31631,31635,31636,31651,31653,31656,35131,35135,35136,35151,35153,35156,35161,35163,35165,35315,35316,35351,35356,35361,35365,35613,35615,35616,35631,35635,35636,35651,35653,35656,36131,36135,36136,36151,36153,36156,36163,36165,36315,36316,36351,36356,36361,36365,36513,36515,36516,36531,36535,36536,36561,36563,36565,51313,51315,51316,51351,51353,51356,51361,51363,51365,51513,51516,51531,51536,51561,51563,51613,51615,51616,51631,51635,51636,51651,51653,51656,53131,53135,53136,53151,53153,53156,53161,53163,53165,53513,53516,53531,53536,53561,53563,53613,53615,53616,53631,53635,53636,53651,53653,53656,56131,56135,56136,56151,56153,56156,56161,56163,56165,56313,56315,56316,56351,56353,56356,56361,56363,56365,56513,56516,56531,56536,56561,56563,61313,61315,61316,61351,61353,61356,61361,61363,61365,61513,61515,61516,61531,61535,61536,61561,61563,61565,61615,61631,61635,61651,61653,63131,63135,63136,63151,63153,63156,63161,63163,63165,63513,63515,63516,63531,63535,63536,63561,63563,63565,63613,63615,63631,63635,63651,63653,65131,65135,65136,65151,65153,65156,65161,65163,65165,65313,65315,65316,65351,65353,65356,65361,65363,65365,65613,65615,65631,65635,65651,65653,56565,51515]);$ctx.dccurev1=$a([51363,51563,51653,53153,53163,53513,53563,53613,53653,56153,56163,56313,56353,56363,56513,56563,51316,51356,51536,51616,53156,53516,53536,53616,53636,53656,56136,56156,56316,56356,56516,56536]);$ctx.dcclrev1=$a([61351,61361,61531,61561,61631,61651,63131,63151,63161,63531,63561,63631,65131,65161,65351,65631,31351,31361,31531,31561,31631,31651,35131,35151,35161,35361,35631,35651,36131,36151,36351,36531]);$ctx.dccurev2=$a([15316,16316,13516,16516,13616,15616,13136,15136,16136,13536,16536,13636,13156,16156,15356,13656,15313,16313,13513,16513,13613,15613,13153,15153,16153,16353,13653,15653,13163,15163,15363,13563]);$ctx.dcclrev2=$a([36315,36515,35615,35135,36135,31535,36535,31635,35635,35165,36165,31365,35365,36365,31565,36565,61315,65315,63515,61615,65135,61535,63535,61635,63635,65635,63165,65165,61365,65365,61565,63565]);for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ultracode.$ctx[id]=$ctx[id]);bwipp_ultracode.__25888__=1})()}$k[$j++]="dccu";if($1.rev==1){$k[$j++]=$1.dccurev1}else{$k[$j++]=$1.dccurev2}var _3i=$k[--$j];$1[$k[--$j]]=_3i;$k[$j++]="dccl";if($1.rev==1){$k[$j++]=$1.dcclrev1}else{$k[$j++]=$1.dcclrev2}var _3n=$k[--$j];$1[$k[--$j]]=_3n;$1.rows=$f($1.rows*6+1);$1.columns=$1.columns+6;$k[$j++]=Infinity;for(var _3t=0,_3u=$1.rows*$1.columns;_3t<_3u;_3t++){$k[$j++]=-1}$1.pixs=$a();$1.qmv=function(){var _3x=$k[--$j];var _3y=$k[--$j];$k[$j++]=$f(_3y+_3x*$1.columns)};for(var _41=0,_40=$1.columns-1;_41<=_40;_41+=1){$1.i=_41;for(var _44=0,_43=$f($1.rows-1);_44<=_43;_44+=6){$1.j=_44;if($1.i>=5){$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.qmv();var _4A=$k[--$j];$p($k[--$j],_4A,$1.i%2*9)}}$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=0;$1.qmv();var _4E=$k[--$j];$p($k[--$j],_4E,9);$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$f($1.rows-1);$1.qmv();var _4J=$k[--$j];$p($k[--$j],_4J,9)}for(var _4N=1,_4M=$f($1.rows-2);_4N<=_4M;_4N+=1){$1.i=_4N;for(var _4Q=3,_4P=$1.columns-1;_4Q<=_4P;_4Q+=16){$1.j=_4Q;$k[$j++]=$1.pixs;$k[$j++]=$1.j;$k[$j++]=$1.i;$1.qmv();var _4V=$k[--$j];$p($k[--$j],_4V,(1-$1.i%2)*9)}$k[$j++]=$1.pixs;$k[$j++]=0;$k[$j++]=$1.i;$1.qmv();var _4Z=$k[--$j];$p($k[--$j],_4Z,9);$k[$j++]=$1.pixs;$k[$j++]=1;$k[$j++]=$1.i;$1.qmv();var _4e=$k[--$j];$p($k[--$j],_4e,(1-$1.i%2)*9);$k[$j++]=$1.pixs;$k[$j++]=2;$k[$j++]=$1.i;$1.qmv();var _4i=$k[--$j];$p($k[--$j],_4i,0);$k[$j++]=$1.pixs;$k[$j++]=3;$k[$j++]=$1.i;$1.qmv();var _4m=$k[--$j];$p($k[--$j],_4m,9);$k[$j++]=$1.pixs;$k[$j++]=4;$k[$j++]=$1.i;$1.qmv();var _4q=$k[--$j];$p($k[--$j],_4q,0);$k[$j++]=$1.pixs;$k[$j++]=$1.columns-1;$k[$j++]=$1.i;$1.qmv();var _4v=$k[--$j];$p($k[--$j],_4v,9)}$1.i=~~($1.rows/2)-5;$k[$j++]=Infinity;var _52=$R($s(5),$g($1.dccu,$1.dcc),10);for(var _53=0,_54=_52.length;_53<_54;_53++){$k[$j++]=$g(_52,_53)-48}var _5A=$R($s(5),$g($1.dccl,$1.dcc),10);$k[$j++]=0;for(var _5B=0,_5C=_5A.length;_5B<_5C;_5B++){$k[$j++]=$g(_5A,_5B)-48}var _5E=$a();for(var _5F=0,_5G=_5E.length;_5F<_5G;_5F++){$k[$j++]=$g(_5E,_5F);$k[$j++]=$1.pixs;$k[$j++]=2;$k[$j++]=$1.i;$1.qmv();var _5K=$k[--$j];var _5L=$k[--$j];$p(_5L,_5K,$k[--$j]);$1.i=$1.i+1}$k[$j++]=Infinity;$k[$j++]=$1.start;$k[$j++]=$1.mcc;$q($1.ecws);$k[$j++]=$1.tcc;$k[$j++]=283;$k[$j++]=$1.acc;$q($1.dcws);for(var _5V=0,_5W=$1.pads;_5V<_5W;_5V++){$k[$j++]=284}$k[$j++]=$1.qcc;$1.tileseq=$a();$1.x=5;$1.y=1;var _5Z=$1.tileseq;for(var _5a=0,_5b=_5Z.length;_5a<_5b;_5a++){var _5g=$R($s(5),$g($1.tiles,$g(_5Z,_5a)),10);for(var _5h=0,_5i=_5g.length;_5h<_5i;_5h++){$k[$j++]=$g(_5g,_5h);$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.qmv();var _5n=$k[--$j];var _5o=$k[--$j];$p(_5o,_5n,$f($k[--$j]-48));$1.y=$1.y+1}if($1.y!=$f($1.rows-1)){$1.y=$1.y+1}else{$1.x=$1.x+1;$1.y=1;$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.qmv();var _5y=$k[--$j];if($g($k[--$j],_5y)!=-1){$1.x=$1.x+1}}}if(!bwipp_ultracode.__25970__){(function(){var $ctx=Object.create($1);var _62=new Map([[0,"FFFFFF"],[9,"000000"],[1,"00FFFF"],[3,"FF00FF"],[5,"FFFF00"],[6,"00FF00"]]);$ctx.colormap=_62;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_ultracode.$ctx[id]=$ctx[id]);bwipp_ultracode.__25970__=1})()}var _6B=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.columns],["pixy",$1.rows],["height",$1.rows/72*2],["width",$1.columns/72*2],["colormap",$1.colormap],["opt",$1.options]]);$k[$j++]=_6B;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_jabcode(){var $1=Object.create(bwipp_jabcode.$ctx||(bwipp_jabcode.$ctx={}));$1.dontdraw=false;$1.rows=-1;$1.columns=-1;$1.slave=false;$1.colors=16;$1.eclevel=6;$1.raw=false;$1.parse=false;$1.parsefnc=false;$1.mask=-1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$1.databpm=~~Math.round(Math.log($1.colors)/Math.log(2));var _3=$1.colors;$k[$j++]="metabpm";$k[$j++]=_3;if(_3>8){$j--;$k[$j++]=8}var _4=$k[--$j];$1[$k[--$j]]=~~Math.round(Math.log(_4)/Math.log(2));$1.fn1=-1;var _9=new Map([["parse",$1.parse],["parsefnc",$1.parsefnc],["FNC1",$1.fn1]]);$1.fncvals=_9;$k[$j++]="msg";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _C=$k[--$j];$1[$k[--$j]]=_C;$1.msglen=$1.msg.length;$1.addtobits=function(){var _F=$k[--$j];$P($1.bits,$1.j,_F);$1.j=_F.length+$1.j};$1.tofixedbits=function(){var _K=$Z($s(13),"0000000000000");var _L=$k[--$j];var _O=$R($s(13),$k[--$j],2);$P(_K,$f(_L-_O.length),_O);$k[$j++]=$G(_K,0,_L)};var _R=$1.msglen<=15?4:17;$1.bits=$s(7+_R+$1.msglen*8+12);$1.j=0;$k[$j++]=31;$k[$j++]=5;$1.tofixedbits();$1.addtobits();$k[$j++]="00";$1.addtobits();if($1.msglen<=15){$k[$j++]=$1.msglen;$k[$j++]=4;$1.tofixedbits();$1.addtobits()}else{$k[$j++]="0000";$1.addtobits();$k[$j++]=$1.msglen-16;$k[$j++]=13;$1.tofixedbits();$1.addtobits()}for(var _Z=0,_Y=$1.msglen-1;_Z<=_Y;_Z+=1){$k[$j++]=$g($1.msg,_Z);$k[$j++]=8;$1.tofixedbits();$1.addtobits()}$k[$j++]=28;$k[$j++]=5;$1.tofixedbits();$1.addtobits();$k[$j++]=31;$k[$j++]=5;$1.tofixedbits();$1.addtobits();$k[$j++]="11";$1.addtobits();$1.diffside=21;$1.sameshape=false;$1.sameecc=false;$1.hasslaves=false;$1.metrics=function(){$1.mc=$k[--$j];$1.mr=$k[--$j];var _e=$1.mc;var _f=$1.mr;var _g=$1.mc;var _h=$1.mr;var _i=$1.colors;var _j=64;if(64>_i){var _=_i;_i=_j;_j=_}var _l=$1.slave?7:17;$k[$j++]=_e*_f;$k[$j++]=((~~($f(_g-25)/16)+2)*(~~($f(_h-25)/16)+2)-4)*7;$k[$j++]=_j*2;$k[$j++]=_l*4;if(!$1.slave){var _p=$eq($1.mr,$1.mc)?0:1;$1.metass=_p;var _q=$1.mr;var _r=$1.mc;if($lt(_q,_r)){var _=_r;_r=_q;_q=_}$1.metavf=$g($a([0,1,2,2,3,3,3,3]),~~($f(_q-21)/16));$k[$j++]="metavlen";if($1.metass==0){$k[$j++]=$a([2,2,3,4])}else{$k[$j++]=$a([4,6,8,10])}var _z=$g($k[--$j],$1.metavf);$1[$k[--$j]]=_z;$1.metaelen=$f($1.metavf*2+10);$k[$j++]=$f($f(7+$1.metavlen)+$1.metaelen);if($1.hasslaves){var _15=$k[--$j];$k[$j++]=$f(_15+4)}var _18=~~Math.ceil($k[--$j]*2/$1.metabpm);$1.nummetabits=$f(_18*$1.metabpm+6);$k[$j++]=_18+6}else{$k[$j++]=3;if(!$1.sameshape){var _1B=$k[--$j];$k[$j++]=$f(_1B+5)}if($1.hasslaves){var _1D=$k[--$j];$k[$j++]=$f(_1D+3)}if(!$1.sameecc){var _1F=$1.mr;var _1G=$1.mc;if($lt(_1F,_1G)){var _=_1G;_1G=_1F;_1F=_}var _1J=$k[--$j];$k[$j++]=$f(_1J+$g($a([10,12,14,14,16,16,16,16]),~~($f(_1F-21)/16)))}var _1M=~~Math.ceil($k[--$j]*2/$1.metabpm);$1.nummetabits=_1M*$1.metabpm;$k[$j++]=_1M}var _1O=$k[--$j];$1.nummetamodules=_1O;var _1P=$k[--$j];var _1Q=$k[--$j];var _1R=$k[--$j];$1.numdatamodules=$f($k[--$j]-$f(_1R+$f(_1Q+$f(_1P+_1O))));$1.numdatabits=$1.numdatamodules*$1.databpm};$1.coderate=$g($a([.67,.63,.57,.55,.5,.43,.34,.25,.2,.17,.14]),$1.eclevel);$1.grosslen=~~Math.ceil($1.bits.length/$1.coderate);$1.snapsize=function(){var _1b=~~Math.ceil($k[--$j])-18;$k[$j++]=_1b;if(_1b<0){$j--;$k[$j++]=0}var _1c=$k[--$j];$k[$j++]=~~(_1c/4)*4+21};if($1.rows==-1&&$1.columns==-1){$k[$j++]="size";$k[$j++]=Math.sqrt($1.grosslen);$1.snapsize();var _1g=$k[--$j];$1[$k[--$j]]=_1g;for(;;){$k[$j++]=$1.size;$k[$j++]=$1.size;$1.metrics();if($1.grosslen<=$1.numdatabits){break}$1.size=$f($1.size+4)}$1.rows=$1.size;$1.columns=$1.size}else{if($1.columns==-1&&$1.rows!=-1){$k[$j++]="columns";$k[$j++]=$1.grosslen/$1.rows;$1.snapsize();var _1t=$k[--$j];$1[$k[--$j]]=_1t;for(;;){$k[$j++]=$1.rows;$k[$j++]=$1.columns;$1.metrics();if($1.grosslen<=$1.numdatabits){break}$1.columns=$f($1.columns+4)}}if($1.rows==-1&&$1.columns!=-1){$k[$j++]="rows";$k[$j++]=$1.grosslen/$1.columns;$1.snapsize();var _24=$k[--$j];$1[$k[--$j]]=_24;for(;;){$k[$j++]=$1.rows;$k[$j++]=$1.columns;$1.metrics();if($1.grosslen<=$1.numdatabits){break}$1.rows=$f($1.rows+4)}}if($1.rows!=-1&&$1.columns!=-1){$k[$j++]=$1.rows;$k[$j++]=$1.columns;$1.metrics()}}$1.C=$1.numdatabits;$1.cols=$1.columns;if($1.rows>145||$1.cols>145){$k[$j++]="bwipp.jabcodeNoValidSymbol#26182";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}$1.min=$1.C;for(var _2K=3;_2K<=8;_2K+=1){$1.i=_2K;for(var _2M=$1.i+1;_2M<=9;_2M+=1){$1.j=_2M;$1.dist=~~($1.C/$1.j)*$1.j-~~($1.C/$1.j)*$1.i-$1.bits.length;if($1.dist<$1.min&&$1.dist>=0){$1.datawc=$1.i;$1.datawr=$1.j;$1.min=$1.dist}}}$1.tmpbits=$s(~~($1.C/$1.datawr)*$1.datawr-~~($1.C/$1.datawr)*$1.datawc);$P($1.tmpbits,0,$1.bits);for(var _2m=$1.bits.length,_2l=$1.tmpbits.length-1;_2m<=_2l;_2m+=1){var _2o=$g($1.tmpbits,_2m-1);$k[$j++]=_2m;$k[$j++]=_2o;if(_2o%2==0){var _2p=$k[--$j];$k[$j++]=$f(_2p+1)}else{var _2q=$k[--$j];$k[$j++]=$f(_2q-1)}var _2s=$k[--$j];$p($1.tmpbits,$k[--$j],_2s)}$1.bits=$1.tmpbits;$1.m0=22609+1;$1.m1=62509-65536;$1.m2=19605;$1.m3=32557;$1.lcg64_temper=function(){$1.p00=$1.m0*$1.s0;$1.p01=$1.m0*$1.s1;$1.p02=$1.m0*$1.s2;$1.p03=$1.m0*$1.s3;$1.p10=$1.m1*$1.s0;$1.p11=$1.m1*$1.s1;$1.p12=$1.m1*$1.s2;$1.p13=$1.m1*$1.s3;$1.p20=$1.m2*$1.s0;$1.p21=$1.m2*$1.s1;$1.p22=$1.m2*$1.s2;$1.p23=$1.m2*$1.s3;$1.p30=$1.m3*$1.s0;$1.p31=$1.m3*$1.s1;$1.p32=$1.m3*$1.s2;$1.p33=$1.m3*$1.s3;$1.s3=$1.p33%65536+1;$1.s2=$1.p32%65536+~~($1.p33/65536)+$1.p23%65536;$1.s1=$1.p31%65536+~~($1.p32/65536)+($1.p22%65536+~~($1.p23/65536))+$1.p13%65536;$1.s0=$1.p30%65536+~~($1.p31/65536)+($1.p21%65536+~~($1.p22/65536))+($1.p12%65536+~~($1.p13/65536))+$1.p03%65536;$1.s3=$1.s3+65536;$1.s2=$1.s2+65535;$1.s1=$1.s1+65535;$1.s0=$1.s0+65535;$1.s2=~~($1.s3/65536)+$1.s2;$1.s3=$1.s3%65536;$1.s1=~~($1.s2/65536)+$1.s1;$1.s2=$1.s2%65536;$1.s0=~~($1.s1/65536)+$1.s0;$1.s1=$1.s1%65536;$1.s0=$1.s0%65536;var _3x=(($1.s0-32768)*65536+$1.s1^2147483648)&4294967295;var _3y=_3x^_3x>>>11;var _3z=_3y^_3y<<7&-1658038656;var _40=(_3z^_3z<<15&-272236544)&4294967295;$k[$j++]=_40^_40>>>18};$1.createMatrixA=function(){$k[$j++]="nb_pcb";if($1.wr<4){$k[$j++]=~~($1.Pg_sub_block/2)}else{$k[$j++]=~~($1.Pg_sub_block/$1.wr)*$1.wc}var _46=$k[--$j];$1[$k[--$j]]=_46;$1.offset=~~Math.ceil($1.Pg_sub_block/32);$1.effwidth=$1.offset*32;$1.matrixA=$a($1.offset*$1.nb_pcb);for(var _4G=0,_4F=$1.offset*$1.nb_pcb-1;_4G<=_4F;_4G+=1){$p($1.matrixA,_4G,0)}$1.permutation=$a($1.Pg_sub_block);for(var _4M=0,_4L=$1.Pg_sub_block-1;_4M<=_4L;_4M+=1){$p($1.permutation,_4M,_4M)}for(var _4R=0,_4Q=~~($1.Pg_sub_block/$1.wr)-1;_4R<=_4Q;_4R+=1){$1.i=_4R;for(var _4U=0,_4T=$f($1.wr-1);_4U<=_4T;_4U+=1){$1.j=_4U;var _4V=$1.matrixA;var _4W=$1.i;var _4X=$1.effwidth;var _4Y=$1.wr;var _4Z=$1.j;var _4f=$f(31-$f($1.i*$f($1.effwidth+$1.wr)+$1.j)%32);$p(_4V,~~($f(_4W*$f(_4X+_4Y)+_4Z)/32),$g(_4V,~~($f(_4W*$f(_4X+_4Y)+_4Z)/32))|(_4f<0?1>>>-_4f:1<<_4f))}}$1.s0=0;$1.s1=0;$1.s2=11;$1.s3=64569;for(var _4i=1,_4h=$f($1.wc-1);_4i<=_4h;_4i+=1){$1.i=_4i;$1.off_index=~~($1.Pg_sub_block/$1.wr)*$1.i;for(var _4o=0,_4n=$1.Pg_sub_block-1;_4o<=_4n;_4o+=1){$1.j=_4o;$1.lcg64_temper();var _4p=$k[--$j];$k[$j++]=_4p;if(_4p<0){var _4q=$k[--$j];$k[$j++]=$f((_4q^2147483648)+2147483648)}$1.pos=~~($k[--$j]/4294967296*($1.Pg_sub_block-$1.j));for(var _4x=0,_4w=~~($1.Pg_sub_block/$1.wr)-1;_4x<=_4w;_4x+=1){$1.k=_4x;var _4y=$1.matrixA;var _4z=$1.off_index;var _50=$1.k;var _51=$1.offset;var _52=$1.j;var _5A=$g($1.matrixA,~~($g($1.permutation,$1.pos)/32)+$1.k*$1.offset);var _5E=-$f(31-$g($1.permutation,$1.pos)%32);var _5G=31-$1.j%32;$p(_4y,(_4z+_50)*_51+~~(_52/32),$g(_4y,(_4z+_50)*_51+~~(_52/32))|(_5G<0?((_5E<0?_5A>>>-_5E:_5A<<_5E)&1)>>>-_5G:((_5E<0?_5A>>>-_5E:_5A<<_5E)&1)<<_5G))}var _5J=$1.permutation;var _5K=$1.Pg_sub_block;var _5L=$1.j;$p(_5J,_5K-1-_5L,$g($1.permutation,$1.pos));$p($1.permutation,$1.pos,$g(_5J,_5K-1-_5L))}}};$1.createMetadataMatrixA=function(){$1.nb_pcb=~~($1.Pg_sub_block/2);$1.offset=~~Math.ceil($1.Pg_sub_block/32);$1.matrixA=$a($1.offset*$1.nb_pcb);for(var _5Y=0,_5X=$1.offset*$1.nb_pcb-1;_5Y<=_5X;_5Y+=1){$p($1.matrixA,_5Y,0)}$1.permutation=$a($1.Pg_sub_block);for(var _5e=0,_5d=$1.Pg_sub_block-1;_5e<=_5d;_5e+=1){$p($1.permutation,_5e,_5e)}$1.s0=0;$1.s1=0;$1.s2=0;$1.s3=38545;$1.nb_once=~~(~~$f($1.nb_pcb/$1.wc*$1.Pg_sub_block+3)/$1.nb_pcb);for(var _5m=0,_5l=$1.nb_pcb-1;_5m<=_5l;_5m+=1){$1.i=_5m;for(var _5p=0,_5o=$1.nb_once-1;_5p<=_5o;_5p+=1){$1.j=_5p;$1.lcg64_temper();var _5q=$k[--$j];$k[$j++]=_5q;if(_5q<0){var _5r=$k[--$j];$k[$j++]=$f((_5r^2147483648)+2147483648)}$1.pos=~~($k[--$j]/4294967296*($1.Pg_sub_block-$1.j));var _5v=$1.matrixA;var _5w=$1.i;var _5x=$1.offset;var _60=$g($1.permutation,$1.pos);var _65=$f(31-$g($1.permutation,$1.pos)%32);$p(_5v,_5w*_5x+~~(_60/32),$g(_5v,_5w*_5x+~~(_60/32))|(_65<0?1>>>-_65:1<<_65));var _68=$1.permutation;var _69=$1.Pg_sub_block;var _6A=$1.j;$p(_68,_69-1-_6A,$g($1.permutation,$1.pos));$p($1.permutation,$1.pos,$g(_68,_69-1-_6A))}}};$1.GaussJordan=function(){$k[$j++]="nb_pcb";if($1.wr<4){$k[$j++]=~~($1.Pg_sub_block/2)}else{$k[$j++]=~~($1.Pg_sub_block/$1.wr)*$1.wc}var _6K=$k[--$j];$1[$k[--$j]]=_6K;$1.offset=~~Math.ceil($1.Pg_sub_block/32);var _6N=$1.matrixA;$1.matrixH=$A($a(_6N.length),_6N);$k[$j++]=Infinity;for(var _6R=0,_6S=$1.Pg_sub_block;_6R<_6S;_6R++){$k[$j++]=0}$1.column_arrangement=$a();$k[$j++]=Infinity;for(var _6V=0,_6W=$1.Pg_sub_block;_6V<_6W;_6V++){$k[$j++]=false}$1.processed_column=$a();$k[$j++]=Infinity;for(var _6Z=0,_6a=$1.nb_pcb;_6Z<_6a;_6Z++){$k[$j++]=0}$1.zero_lines_nb=$a();$k[$j++]=Infinity;for(var _6d=0,_6e=$1.Pg_sub_block*2;_6d<_6e;_6d++){$k[$j++]=0}$1.swap_col=$a();$1.zero_lines=0;$1.loop0=0;for(var _6i=0,_6h=$1.nb_pcb-1;_6i<=_6h;_6i+=1){$1.i=_6i;$1.pivot_column=$1.Pg_sub_block+1;for(var _6m=0,_6l=$1.Pg_sub_block-1;_6m<=_6l;_6m+=1){$1.j=_6m;var _6r=$g($1.matrixH,~~(($1.offset*32*$1.i+$1.j)/32));var _6v=-(31-($1.offset*32*$1.i+$1.j)%32);if(((_6v<0?_6r>>>-_6v:_6r<<_6v)&1)==1){$1.pivot_column=$1.j;break}}if($1.pivot_column<$1.Pg_sub_block){$p($1.processed_column,$1.pivot_column,true);$p($1.column_arrangement,$1.pivot_column,$1.i);if($1.pivot_column>=$1.nb_pcb){$p($1.swap_col,$1.loop0*2,$1.pivot_column);$1.loop0=$1.loop0+1}$1.off_index=~~($1.pivot_column/32);$1.off_index1=$1.pivot_column%32;for(var _7E=0,_7D=$1.nb_pcb-1;_7E<=_7D;_7E+=1){$1.j=_7E;if($1.i!=$1.j){var _7L=$g($1.matrixH,$1.off_index+$1.j*$1.offset);var _7N=-(31-$1.off_index1);if(((_7N<0?_7L>>>-_7N:_7L<<_7N)&1)==1){for(var _7Q=0,_7P=$1.offset-1;_7Q<=_7P;_7Q+=1){$1.k=_7Q;var _7R=$1.matrixH;var _7S=$1.offset;var _7T=$1.j;var _7U=$1.k;$p(_7R,_7S*_7T+_7U,$xo($g(_7R,_7S*_7T+_7U),$g($1.matrixH,$1.offset*$1.i+$1.k)))}}}}}else{$p($1.zero_lines_nb,$1.zero_lines,$1.i);$1.zero_lines=$1.zero_lines+1}}$1.matrix_rank=$1.nb_pcb-$1.zero_lines;$1.loop2=0;for(var _7k=$1.matrix_rank,_7j=$1.nb_pcb-1;_7k<=_7j;_7k+=1){$1.i=_7k;if($g($1.column_arrangement,$1.i)>0){for(var _7q=0,_7p=$1.nb_pcb-1;_7q<=_7p;_7q+=1){$1.j=_7q;if($nt($g($1.processed_column,$1.j))){$p($1.column_arrangement,$1.j,$g($1.column_arrangement,$1.i));$p($1.column_arrangement,$1.i,0);$p($1.processed_column,$1.j,true);$p($1.processed_column,$1.i,false);$p($1.swap_col,$1.loop0*2,$1.i);$p($1.swap_col,$1.loop0*2+1,$1.j);$p($1.column_arrangement,$1.i,$1.j);$1.loop0=$1.loop0+1;$1.loop2=$1.loop2+1;break}}}}$1.loop1=0;for(var _8I=0,_8H=$1.nb_pcb-1;_8I<=_8H;_8I+=1){$1.kl=_8I;if($nt($g($1.processed_column,$1.kl))&&$1.loop1<$1.loop0-$1.loop2){$p($1.column_arrangement,$1.kl,$g($1.column_arrangement,$g($1.swap_col,$1.loop1*2)));$p($1.processed_column,$1.kl,true);$p($1.swap_col,$1.loop1*2+1,$1.kl);$1.loop1=$1.loop1+1}}$1.loop1=0;for(var _8e=0,_8d=$1.nb_pcb-1;_8e<=_8d;_8e+=1){$1.kl=_8e;if($nt($g($1.processed_column,$1.kl))){$p($1.column_arrangement,$1.kl,$g($1.zero_lines_nb,$1.loop1));$1.loop1=$1.loop1+1}}for(var _8q=0,_8p=$1.nb_pcb-1;_8q<=_8p;_8q+=1){$1.i=_8q;for(var _8t=0,_8s=$1.offset-1;_8t<=_8s;_8t+=1){$1.j=_8t;$p($1.matrixA,$1.i*$1.offset+$1.j,$g($1.matrixH,$f($g($1.column_arrangement,$1.i)*$1.offset+$1.j)))}}$1.tmp=0;for(var _97=0,_96=$1.loop0-1;_97<=_96;_97+=1){$1.i=_97;for(var _9A=0,_99=$1.nb_pcb-1;_9A<=_99;_9A+=1){$1.j=_9A;var _9H=$g($1.matrixA,~~($g($1.swap_col,$1.i*2)/32)+$1.j*$1.offset);var _9L=-$f(31-$g($1.swap_col,$1.i*2)%32);$1.tmp=(-((_9L<0?_9H>>>-_9L:_9H<<_9L)&1)^$1.tmp)&1^$1.tmp;var _9O=$1.matrixA;var _9R=$g($1.swap_col,$1.i*2);var _9S=$1.j;var _9T=$1.offset;var _9b=$g($1.matrixA,~~($g($1.swap_col,$1.i*2+1)/32)+$1.j*$1.offset);var _9f=-$f(31-$g($1.swap_col,$1.i*2+1)%32);var _9q=$f(31-$g($1.swap_col,$1.i*2)%32);$p(_9O,~~(_9R/32)+_9S*_9T,$g(_9O,~~(_9R/32)+_9S*_9T)^(-((_9f<0?_9b>>>-_9f:_9b<<_9f)&1)^$g($1.matrixA,~~($g($1.swap_col,$1.i*2)/32)+$1.j*$1.offset))&(_9q<0?1>>>-_9q:1<<_9q));var _9r=$1.matrixA;var _9u=$g($1.swap_col,$1.i*2+1);var _9v=$1.j;var _9w=$1.offset;var _A9=$f(31-$g($1.swap_col,$1.i*2+1)%32);$p(_9r,~~(_9u/32)+_9v*_9w,$g(_9r,~~(_9u/32)+_9v*_9w)^(-($1.tmp&1)^$g($1.matrixA,~~($g($1.swap_col,$1.i*2+1)/32)+$1.j*$1.offset))&(_A9<0?1>>>-_A9:1<<_A9))}}};$1.createGeneratorMatrix=function(){$1.pn=$1.Pg_sub_block-$1.matrix_rank;$1.offset=~~Math.ceil($1.pn/32);$1.effwidth=$1.offset*32;$1.offset_cap=~~Math.ceil($1.Pg_sub_block/32);$1.G=$a($1.offset*$1.Pg_sub_block);for(var _AL=0,_AK=$1.offset*$1.Pg_sub_block-1;_AL<=_AK;_AL+=1){$p($1.G,_AL,0)}for(var _AP=0,_AO=$1.pn-1;_AP<=_AO;_AP+=1){$1.i=_AP;var _AQ=$1.G;var _AR=$1.Pg_sub_block;var _AS=$1.pn;var _AT=$1.i;var _AU=$1.offset;var _AV=$1.i;var _AY=31-$1.i%32;$p(_AQ,(_AR-_AS+_AT)*_AU+~~(_AV/32),$g(_AQ,(_AR-_AS+_AT)*_AU+~~(_AV/32))|(_AY<0?1>>>-_AY:1<<_AY))}$1.matrix_index=$1.Pg_sub_block-$1.pn;$1.loop0=0;for(var _Af=0,_Ae=($1.Pg_sub_block-$1.pn)*$1.effwidth-1;_Af<=_Ae;_Af+=1){$1.i=_Af;if($1.matrix_index>=$1.Pg_sub_block){$1.loop0=$1.loop0+1;$1.matrix_index=$1.Pg_sub_block-$1.pn}if($1.i%$1.effwidth<$1.pn){var _Ao=$1.G;var _Ap=$1.i;var _Av=$g($1.matrixA,~~($1.matrix_index/32)+$1.offset_cap*$1.loop0);var _Ax=-(31-$1.matrix_index%32);var _B2=31-$1.i%32;$p(_Ao,~~(_Ap/32),$g(_Ao,~~(_Ap/32))^(-((_Ax<0?_Av>>>-_Ax:_Av<<_Ax)&1)^$g($1.G,~~($1.i/32)))&(_B2<0?1>>>-_B2:1<<_B2));$1.matrix_index=$1.matrix_index+1}}};$1.ldpc=function(){$1.wr=$k[--$j];$1.wc=$k[--$j];$k[$j++]=Infinity;var _B6=$k[--$j];var _B7=$k[--$j];$k[$j++]=_B6;$F(_B7,function(){var _B8=$k[--$j];$k[$j++]=$f(_B8-48)});$1.data=$a();$1.Pn=$1.data.length;if($1.wr!=-1){$1.Pg=~~(Math.ceil(Math.ceil($1.Pn*$1.wr/$f($1.wr-$1.wc))/$1.wr)*$1.wr);$1.nb_sub_blocks=~~($1.Pg/2700)+1;$1.Pg_sub_block=~~(~~($1.Pg/$1.nb_sub_blocks)/$1.wr)*$1.wr;$1.Pn_sub_block=~~($1.Pg_sub_block*$f($1.wr-$1.wc)/$1.wr);$1.nb_sub_blocks=~~($1.Pg/$1.Pg_sub_block);$k[$j++]="encoding_iterations";$k[$j++]=~~($1.Pg/$1.Pg_sub_block);if($1.Pn_sub_block*$1.nb_sub_blocks<$1.Pn){var _BY=$k[--$j];$k[$j++]=$f(_BY-1)}var _BZ=$k[--$j];$1[$k[--$j]]=_BZ;$1.createMatrixA()}else{$1.Pg=$1.Pn*2;$1.nb_sub_blocks=1;$1.Pg_sub_block=$1.Pg;$1.Pn_sub_block=$1.Pn;$1.encoding_iterations=1;$1.createMetadataMatrixA()}$1.GaussJordan();$1.createGeneratorMatrix();$1.ecc_encoded_data=$a($1.Pg);$1.offset=~~Math.ceil(($1.Pg_sub_block-$1.matrix_rank)/32);for(var _Bk=0,_Bj=$1.encoding_iterations-1;_Bk<=_Bj;_Bk+=1){$1.iter=_Bk;for(var _Bn=0,_Bm=$1.Pg_sub_block-1;_Bn<=_Bm;_Bn+=1){$1.i=_Bn;$1.temp=0;$1.loop0=0;$1.offset_index=$1.offset*$1.i;for(var _Bv=$1.iter*$1.Pn_sub_block,_Bu=($1.iter+1)*$1.Pn_sub_block-1;_Bv<=_Bu;_Bv+=1){var _C1=$g($1.G,$1.offset_index+~~($1.loop0/32));var _C3=-(31-$1.loop0%32);$1.temp=$g($1.data,_Bv)&((_C3<0?_C1>>>-_C3:_C1<<_C3)&1)^$1.temp;$1.loop0=$1.loop0+1}$p($1.ecc_encoded_data,$1.i+$1.iter*$1.Pg_sub_block,$1.temp)}}if($1.encoding_iterations!=$1.nb_sub_blocks){$1.start=$1.encoding_iterations*$1.Pn_sub_block;$1.last_index=$1.encoding_iterations*$1.Pg_sub_block;$1.Pg_sub_block=$1.Pg-$1.encoding_iterations*$1.Pg_sub_block;$1.Pn_sub_block=~~($1.Pg_sub_block*$f($1.wr-$1.wc)/$1.wr);$1.createMatrixA();$1.GaussJordan();$1.createGeneratorMatrix();$1.offset=~~Math.ceil(($1.Pg_sub_block-$1.matrix_rank)/32);for(var _CS=0,_CR=$1.Pg_sub_block-1;_CS<=_CR;_CS+=1){$1.i=_CS;$1.temp=0;$1.loop0=0;$1.offset_index=$1.offset*$1.i;for(var _CY=$1.start,_CX=$1.Pn-1;_CY<=_CX;_CY+=1){var _Ce=$g($1.G,$1.offset_index+~~($1.loop0/32));var _Cg=-(31-$1.loop0%32);$1.temp=$g($1.data,_CY)&((_Cg<0?_Ce>>>-_Cg:_Ce<<_Cg)&1)^$1.temp;$1.loop0=$1.loop0+1}$p($1.ecc_encoded_data,$1.i+$1.last_index,$1.temp)}}$1.out=$s($1.Pg);for(var _Cr=0,_Cq=$1.Pg-1;_Cr<=_Cq;_Cr+=1){$p($1.out,_Cr,$f($g($1.ecc_encoded_data,_Cr)+48))}$k[$j++]=$1.out};$k[$j++]="bits";$k[$j++]=$1.bits;$k[$j++]=$1.datawc;$k[$j++]=$1.datawr;$1.ldpc();var _Cz=$k[--$j];$1[$k[--$j]]=_Cz;$1.s0=0;$1.s1=0;$1.s2=3;$1.s3=30151;for(var _D2=$1.bits.length-1;_D2>=1;_D2-=1){$1.l=_D2;$1.lcg64_temper();var _D3=$k[--$j];$k[$j++]=_D3;if(_D3<0){var _D4=$k[--$j];$k[$j++]=$f((_D4^2147483648)+2147483648)}$1.r=~~($k[--$j]/4294967296*($1.l+1));$p($1.bits,$1.l,$g($1.bits,$1.r));$p($1.bits,$1.r,$g($1.bits,$1.l))}$1.tmpbits=$s($1.C);$P($1.tmpbits,0,$1.bits);$1.j=$1.bits.length;for(var _DO=0,_DP=~~($f($f($1.C-$1.j)+1)/2);_DO<_DP;_DO++){$p($1.tmpbits,$1.j,48);if($1.j+1<$1.C){$p($1.tmpbits,$1.j+1,49)}$1.j=$1.j+2}$1.bits=$1.tmpbits;if($1.colors==4){$1.bi=0;$1.gi=1;$1.mi=2;$1.yi=3;$1.ki=4;$1.wi=5;$k[$j++]=Infinity;$k[$j++]=$1.bi;$k[$j++]="0000FF";$k[$j++]=$1.gi;$k[$j++]="00FF00";$k[$j++]=$1.mi;$k[$j++]="FF00FF";$k[$j++]=$1.yi;$k[$j++]="FFFF00";$k[$j++]=$1.ki;$k[$j++]="000000";$k[$j++]=$1.wi;$k[$j++]="FFFFFF";$1.palette=$d();$1.metacolorindex=$a([$1.bi,$1.gi,$1.mi,$1.yi]);$1.palettelayout=$a([$1.bi,$1.gi,$1.mi,$1.yi])}else{var _Dw=new Map([[8,$a([2,2,2])],[16,$a([4,2,2])],[32,$a([4,4,2])],[64,$a([4,4,4])],[128,$a([8,4,4])],[256,$a([8,8,4])]]);$1.rgbres=$g(_Dw,$1.colors);$k[$j++]="rvals";$k[$j++]=$g($1.rgbres,0);$k[$j++]=Infinity;var _E1=$k[--$j];var _E3=$f($k[--$j]-1);$k[$j++]=_E1;$k[$j++]=_E3;for(var _E5=0,_E4=_E3;_E5<=_E4;_E5+=1){var _E6=$k[--$j];$k[$j++]=~~Math.round(_E5*(255/_E6));$k[$j++]=_E6}$j--;var _E7=$a();$1[$k[--$j]]=_E7;$k[$j++]="gvals";$k[$j++]=$g($1.rgbres,1);$k[$j++]=Infinity;var _EB=$k[--$j];var _ED=$f($k[--$j]-1);$k[$j++]=_EB;$k[$j++]=_ED;for(var _EF=0,_EE=_ED;_EF<=_EE;_EF+=1){var _EG=$k[--$j];$k[$j++]=~~Math.round(_EF*(255/_EG));$k[$j++]=_EG}$j--;var _EH=$a();$1[$k[--$j]]=_EH;$k[$j++]="bvals";$k[$j++]=$g($1.rgbres,2);$k[$j++]=Infinity;var _EL=$k[--$j];var _EN=$f($k[--$j]-1);$k[$j++]=_EL;$k[$j++]=_EN;for(var _EP=0,_EO=_EN;_EP<=_EO;_EP+=1){var _EQ=$k[--$j];$k[$j++]=~~Math.round(_EP*(255/_EQ));$k[$j++]=_EQ}$j--;var _ER=$a();$1[$k[--$j]]=_ER;var _ET=$1.colors;$1.palette=new Map;var _EU=$1.colors;var _EV=64;if(64>_EU){var _=_EU;_EU=_EV;_EV=_}$1.palettelayout=$a(_EV);$1.i=0;$1.j=8;$F($1.rvals,function(){$1.r=$k[--$j];$F($1.gvals,function(){$1.g=$k[--$j];$F($1.bvals,function(){$1.b=$k[--$j];var _Eh=$Z($s(6),"000000");var _Ej=$R($s(6),$1.r<<16|$1.g<<8|$1.b,16);$P(_Eh,6-_Ej.length,_Ej);$k[$j++]=_Eh;$k[$j++]=false;if($eq(_Eh,"000000")){$1.ki=$1.i;$j--;$k[$j++]=true}var _El=$k[--$j];var _Em=$k[--$j];$k[$j++]=_Em;$k[$j++]=_El;if($eq(_Em,"0000FF")){$1.bi=$1.i;$j--;$k[$j++]=true}var _Eo=$k[--$j];var _Ep=$k[--$j];$k[$j++]=_Ep;$k[$j++]=_Eo;if($eq(_Ep,"00FF00")){$1.gi=$1.i;$j--;$k[$j++]=true}var _Er=$k[--$j];var _Es=$k[--$j];$k[$j++]=_Es;$k[$j++]=_Er;if($eq(_Es,"00FFFF")){$1.ci=$1.i;$j--;$k[$j++]=true}var _Eu=$k[--$j];var _Ev=$k[--$j];$k[$j++]=_Ev;$k[$j++]=_Eu;if($eq(_Ev,"FF0000")){$1.ri=$1.i;$j--;$k[$j++]=true}var _Ex=$k[--$j];var _Ey=$k[--$j];$k[$j++]=_Ey;$k[$j++]=_Ex;if($eq(_Ey,"FF00FF")){$1.mi=$1.i;$j--;$k[$j++]=true}var _F0=$k[--$j];var _F1=$k[--$j];$k[$j++]=_F1;$k[$j++]=_F0;if($eq(_F1,"FFFF00")){$1.yi=$1.i;$j--;$k[$j++]=true}var _F3=$k[--$j];var _F4=$k[--$j];$k[$j++]=_F4;$k[$j++]=_F3;if($eq(_F4,"FFFFFF")){$1.wi=$1.i;$j--;$k[$j++]=true}if($nt($k[--$j])){if($1.colors<=64||($1.colors==128&&($1.r==0||$1.r==73||$1.r==182||$1.r==255)||$1.colors==256&&($1.r==0||$1.r==73||$1.r==182||$1.r==255)&&($1.g==0||$1.g==73||$1.g==182||$1.g==255))){$p($1.palettelayout,$1.j,$1.i);$1.j=$1.j+1}}$p($1.palette,$1.i,$k[--$j]);$1.i=$1.i+1})})});$P($1.palettelayout,0,$a([$1.ki,$1.bi,$1.gi,$1.ci,$1.ri,$1.mi,$1.yi,$1.wi]));$1.metacolorindex=$a([$1.ki,$1.bi,$1.gi,$1.ci,$1.ri,$1.mi,$1.yi,$1.wi])}$k[$j++]=Infinity;for(var _Fp=0,_Fq=$1.rows*$1.cols;_Fp<_Fq;_Fp++){$k[$j++]=-1}$1.pixs=$a();$1.jmv=function(){var _Ft=$k[--$j];var _Fu=$k[--$j];$k[$j++]=$f(_Fu+_Ft*$1.cols)};if(!$1.slave){$1.fpat=$a([$a([1,1,1,0,0]),$a([1,2,2,0,0]),$a([1,2,1,2,1]),$a([0,0,2,2,1]),$a([0,0,1,1,1])]);$1.fmap=$a([$a([-1,$1.bi,$1.yi]),$a([-1,$1.yi,$1.bi]),$a([-1,$1.gi,$1.mi]),$a([-1,$1.mi,$1.gi])])}else{$1.fpat=$a([$a([0,0,0,0,0]),$a([0,2,2,0,0]),$a([0,2,1,2,0]),$a([0,0,2,2,0]),$a([0,0,0,0,0])]);$1.fmap=$a([$a([-1,$1.ki,$1.wi]),$a([-1,$1.ki,$1.wi]),$a([-1,$1.ki,$1.wi]),$a([-1,$1.ki,$1.wi])])}for(var _GY=0;_GY<=4;_GY+=1){$1.y=_GY;for(var _GZ=0;_GZ<=4;_GZ+=1){$1.x=_GZ;$1.fpb=$g($g($1.fpat,$1.y),$1.x);$k[$j++]=$1.pixs;$k[$j++]=$1.x+1;$k[$j++]=$1.y+1;$1.jmv();var _Gm=$k[--$j];$p($k[--$j],_Gm,$g($g($1.fmap,0),$1.fpb));$k[$j++]=$1.pixs;$k[$j++]=$1.x+1;$k[$j++]=$f($f($1.rows-$1.y)-2);$1.jmv();var _Gw=$k[--$j];$p($k[--$j],_Gw,$g($g($1.fmap,1),$1.fpb));$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.x+$1.cols)-6);$k[$j++]=$1.y+1;$1.jmv();var _H6=$k[--$j];$p($k[--$j],_H6,$g($g($1.fmap,2),$1.fpb));$k[$j++]=$1.pixs;$k[$j++]=$f($f($1.x+$1.cols)-6);$k[$j++]=$f($f($1.rows-$1.y)-2);$1.jmv();var _HH=$k[--$j];$p($k[--$j],_HH,$g($g($1.fmap,3),$1.fpb))}}$1.algnpat0=$a([$a([$1.ki,$1.ki,-1]),$a([$1.ki,$1.wi,$1.ki]),$a([-1,$1.ki,$1.ki])]);$1.algnpat1=$a([$a([-1,$1.ki,$1.ki]),$a([$1.ki,$1.wi,$1.ki]),$a([$1.ki,$1.ki,-1])]);$1.num=~~Math.round($1.cols/16)-1;$1.algnrpos=$a([3,17]);if($1.num>0){$k[$j++]=Infinity;for(var _Hk=0,_Hj=$1.num;_Hk<=_Hj;_Hk+=1){$k[$j++]=~~(_Hk*($f($1.cols-7)/$1.num))+3}$1.algnrpos=$a()}$1.num=~~Math.round($1.rows/16)-1;$1.algncpos=$a([3,17]);if($1.num>0){$k[$j++]=Infinity;for(var _Ht=0,_Hs=$1.num;_Ht<=_Hs;_Ht+=1){$k[$j++]=~~(_Ht*($f($1.rows-7)/$1.num))+3}$1.algncpos=$a()}$1.putalgnpat=function(){$1.pp=$k[--$j];$1.py=$k[--$j];$1.px=$k[--$j];for(var _I0=0;_I0<=2;_I0+=1){$1.pb=_I0;for(var _I1=0;_I1<=2;_I1+=1){$1.pa=_I1;$k[$j++]=$1.pixs;$k[$j++]=$f($1.px+$1.pa);$k[$j++]=$f($1.py+$1.pb);$1.jmv();var _IC=$k[--$j];$p($k[--$j],_IC,$g($g($1.pp,$1.pb),$1.pa))}}};for(var _IG=0,_IF=$1.algncpos.length-1;_IG<=_IF;_IG+=1){$1.j=_IG;$1.y=$g($1.algncpos,$1.j);for(var _IM=0,_IL=$1.algnrpos.length-1;_IM<=_IL;_IM+=1){$1.i=_IM;$1.x=$g($1.algnrpos,$1.i);$k[$j++]=$1.pixs;$k[$j++]=$1.x;$k[$j++]=$1.y;$1.jmv();var _IT=$k[--$j];if($g($k[--$j],_IT)==-1){$k[$j++]=$f($1.x-1);$k[$j++]=$f($1.y-1);if(($1.i+$1.j)%2==0){$k[$j++]=$1.algnpat0}else{$k[$j++]=$1.algnpat1}$1.putalgnpat()}}}if(!$1.slave){var _JL=$a([$a([6,1]),$a([6,2]),$a([6,3]),$a([6,4]),$a([6,5]),$a([6,6]),$a([5,6]),$a([4,6]),$a([3,6]),$a([2,6]),$a([1,6]),$a([7,1]),$a([7,2]),$a([7,3]),$a([7,4]),$a([7,5]),$a([7,6]),$a([7,7]),$a([6,7]),$a([5,7]),$a([4,7]),$a([3,7]),$a([2,7]),$a([1,7]),$a([8,1]),$a([8,2]),$a([8,3]),$a([8,4]),$a([8,5]),$a([8,6]),$a([8,7]),$a([8,8]),$a([7,8]),$a([6,8]),$a([5,8]),$a([4,8]),$a([3,8]),$a([2,8]),$a([1,8]),$a([9,1]),$a([9,2]),$a([9,3]),$a([9,4]),$a([9,5])]);for(var _JM=0,_JN=_JL.length;_JM<_JN;_JM++){$q($g(_JL,_JM));$1.y=$k[--$j];$1.x=$k[--$j];$k[$j++]=$a([$1.x,$1.y]);$k[$j++]=$a([-$1.x,$1.y]);$k[$j++]=$a([-$1.x,-$1.y]);$k[$j++]=$a([$1.x,-$1.y])}$as($a(176));$1.metadatamap=$k[--$j];$1.palettemap1=$a([$a([4,1]),$a([4,2]),$a([5,1]),$a([5,2]),$a([2,4]),$a([2,5]),$a([1,4]),$a([1,5]),$a([-2,1]),$a([-2,2]),$a([-1,1]),$a([-1,2]),$a([-4,4]),$a([-4,5]),$a([-5,4]),$a([-5,5])]);$1.palettemap2=$a([$a([-4,-5]),$a([-4,-4]),$a([-5,-5]),$a([-5,-4]),$a([-2,-2]),$a([-2,-1]),$a([-1,-2]),$a([-1,-1]),$a([2,-5]),$a([2,-4]),$a([1,-5]),$a([1,-4]),$a([4,-2]),$a([4,-1]),$a([5,-2]),$a([5,-1])])}else{$k[$j++]=Infinity;for(var _KD=1;_KD<=19;_KD+=1){$1.i=_KD;$k[$j++]=$a([0,$1.i]);$k[$j++]=$a([1,$1.i])}for(var _KI=5;_KI<=12;_KI+=1){$1.i=_KI;$k[$j++]=$a([2,$1.i]);$k[$j++]=$a([3,$1.i])}$1.metadatamap=$a();$k[$j++]=Infinity;for(var _KO=5;_KO<=12;_KO+=1){$k[$j++]=_KO;$k[$j++]=Infinity;var _KP=$k[--$j];var _KQ=$k[--$j];$k[$j++]=_KP;$k[$j++]=4;$k[$j++]=_KQ;var _KR=$a();$k[$j++]=_KR}for(var _KS=12;_KS>=5;_KS-=1){$k[$j++]=_KS;$k[$j++]=Infinity;var _KT=$k[--$j];var _KU=$k[--$j];$k[$j++]=_KT;$k[$j++]=5;$k[$j++]=_KU;var _KV=$a();$k[$j++]=_KV}for(var _KW=5;_KW<=12;_KW+=1){$k[$j++]=_KW;$k[$j++]=Infinity;var _KX=$k[--$j];var _KY=$k[--$j];$k[$j++]=_KX;$k[$j++]=6;$k[$j++]=_KY;var _KZ=$a();$k[$j++]=_KZ}for(var _Ka=12;_Ka>=5;_Ka-=1){$k[$j++]=_Ka;$k[$j++]=Infinity;var _Kb=$k[--$j];var _Kc=$k[--$j];$k[$j++]=_Kb;$k[$j++]=7;$k[$j++]=_Kc;var _Kd=$a();$k[$j++]=_Kd}$1.palettemap1=$a();$k[$j++]=Infinity;var _Kf=$1.palettemap1;for(var _Kg=0,_Kh=_Kf.length;_Kg<_Kh;_Kg++){$k[$j++]=$g(_Kf,_Kg);$k[$j++]=Infinity;var _Kj=$k[--$j];var _Kk=$k[--$j];$k[$j++]=_Kj;$q(_Kk);var _Kl=$k[--$j];var _Km=$k[--$j];$k[$j++]=-_Km;$k[$j++]=-_Kl;var _Kn=$a();$k[$j++]=_Kn}$1.palettemap2=$a()}var _Kp=$1.metadatamap;for(var _Kq=0,_Kr=_Kp.length;_Kq<_Kr;_Kq++){var _Ks=$g(_Kp,_Kq);var _Kt=$g(_Ks,0);$k[$j++]=_Ks;$k[$j++]=_Kt;if(_Kt<0){var _Kv=$k[--$j];var _Kw=$k[--$j];$p(_Kw,0,$f($f(_Kv+$1.cols)-1));$k[$j++]=_Kw}else{$j--}var _Kx=$k[--$j];var _Ky=$g(_Kx,1);$k[$j++]=_Kx;$k[$j++]=_Ky;if(_Ky<0){var _L0=$k[--$j];var _L1=$k[--$j];$p(_L1,1,$f($f(_L0+$1.rows)-1));$k[$j++]=_L1}else{$j--}$j--}var _L2=$1.palettemap1;for(var _L3=0,_L4=_L2.length;_L3<_L4;_L3++){var _L5=$g(_L2,_L3);var _L6=$g(_L5,0);$k[$j++]=_L5;$k[$j++]=_L6;if(_L6<0){var _L8=$k[--$j];var _L9=$k[--$j];$p(_L9,0,$f($f(_L8+$1.cols)-1));$k[$j++]=_L9}else{$j--}var _LA=$k[--$j];var _LB=$g(_LA,1);$k[$j++]=_LA;$k[$j++]=_LB;if(_LB<0){var _LD=$k[--$j];var _LE=$k[--$j];$p(_LE,1,$f($f(_LD+$1.rows)-1));$k[$j++]=_LE}else{$j--}$j--}var _LF=$1.palettemap2;for(var _LG=0,_LH=_LF.length;_LG<_LH;_LG++){var _LI=$g(_LF,_LG);var _LJ=$g(_LI,0);$k[$j++]=_LI;$k[$j++]=_LJ;if(_LJ<0){var _LL=$k[--$j];var _LM=$k[--$j];$p(_LM,0,$f($f(_LL+$1.cols)-1));$k[$j++]=_LM}else{$j--}var _LN=$k[--$j];var _LO=$g(_LN,1);$k[$j++]=_LN;$k[$j++]=_LO;if(_LO<0){var _LQ=$k[--$j];var _LR=$k[--$j];$p(_LR,1,$f($f(_LQ+$1.rows)-1));$k[$j++]=_LR}else{$j--}$j--}for(var _LU=0,_LT=$f($1.nummetamodules-1);_LU<=_LT;_LU+=1){$k[$j++]=$1.pixs;$q($g($1.metadatamap,_LU));$1.jmv();var _LY=$k[--$j];$p($k[--$j],_LY,0)}if(!$1.slave){var _Lb=$1.colors;var _Lc=16;if(16>_Lb){var _=_Lb;_Lb=_Lc;_Lc=_}for(var _Le=0,_Ld=_Lc-1;_Le<=_Ld;_Le+=1){$1.i=_Le;var _Lh=$g($1.palettelayout,$1.i);$k[$j++]=_Lh;$k[$j++]=$1.pixs;$k[$j++]=_Lh;$q($g($1.palettemap1,$1.i));$1.jmv();var _Lm=$k[--$j];var _Ln=$k[--$j];$p($k[--$j],_Lm,_Ln);var _Lq=$k[--$j];$k[$j++]=$1.pixs;$k[$j++]=_Lq;$q($g($1.palettemap2,$1.i));$1.jmv();var _Lu=$k[--$j];var _Lv=$k[--$j];$p($k[--$j],_Lu,_Lv)}$1.i=16}else{$1.i=0}$1.j=$1.nummetamodules;for(var _M1=$1.i,_M0=$1.palettelayout.length-1;_M1<=_M0;_M1+=2){$1.i=_M1;var _M4=$g($1.palettelayout,$1.i);$k[$j++]=_M4;$k[$j++]=$1.pixs;$k[$j++]=_M4;$q($g($1.metadatamap,$1.j));$1.jmv();var _M9=$k[--$j];var _MA=$k[--$j];$p($k[--$j],_M9,_MA);var _MD=$k[--$j];$k[$j++]=$1.pixs;$k[$j++]=_MD;$q($g($1.metadatamap,$f($1.j+2)));$1.jmv();var _MH=$k[--$j];var _MI=$k[--$j];$p($k[--$j],_MH,_MI);var _MM=$g($1.palettelayout,$1.i+1);$k[$j++]=_MM;$k[$j++]=$1.pixs;$k[$j++]=_MM;$q($g($1.metadatamap,$f($1.j+1)));$1.jmv();var _MR=$k[--$j];var _MS=$k[--$j];$p($k[--$j],_MR,_MS);var _MV=$k[--$j];$k[$j++]=$1.pixs;$k[$j++]=_MV;$q($g($1.metadatamap,$f($1.j+3)));$1.jmv();var _MZ=$k[--$j];var _Ma=$k[--$j];$p($k[--$j],_MZ,_Ma);$1.j=$f($1.j+4)}var _N2=$a([function(){var _Md=$k[--$j];var _Me=$k[--$j];$k[$j++]=$f(_Me+_Md)%$1.colors},function(){$j--;var _Mh=$k[--$j];$k[$j++]=_Mh%$1.colors},function(){var _Mi=$k[--$j];var _Mj=$k[--$j];$k[$j++]=_Mi;$k[$j++]=_Mj;$j--;var _Ml=$k[--$j];$k[$j++]=_Ml%$1.colors},function(){var _Mm=$k[--$j];var _Mn=$k[--$j];$k[$j++]=(~~(_Mm/3)+~~(_Mn/2))%$1.colors},function(){var _Mp=$k[--$j];var _Mq=$k[--$j];$k[$j++]=(~~(_Mp/2)+~~(_Mq/3))%$1.colors},function(){var _Ms=$k[--$j];var _Mu=$f($k[--$j]+_Ms);$k[$j++]=(~~(_Mu/2)+~~(_Mu/3))%$1.colors},function(){var _Mw=$k[--$j];var _Mx=$k[--$j];$k[$j++]=$f(_Mw*(_Mx*_Mx)%7+$f(_Mw+_Mx*_Mx)*2%19)%$1.colors},function(){var _Mz=$k[--$j];var _N0=$k[--$j];$k[$j++]=$f(_N0*(_Mz*_Mz)%5+$f(_Mz*_Mz+_N0*2)%13)%$1.colors}]);$1.maskfuncs=_N2;if($1.mask!=-1){$1.maskfuncs=$a([$g($1.maskfuncs,$1.mask)]);$1.bestmaskval=$1.mask}$1.masks=$a($1.maskfuncs.length);for(var _ND=0,_NC=$1.masks.length-1;_ND<=_NC;_ND+=1){$1.m=_ND;$1.mask=$a($1.rows*$1.cols);for(var _NJ=0,_NI=$f($1.rows-1);_NJ<=_NI;_NJ+=1){$1.j=_NJ;for(var _NM=0,_NL=$f($1.cols-1);_NM<=_NL;_NM+=1){$1.i=_NM;$k[$j++]=$1.pixs;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.jmv();var _NQ=$k[--$j];if($g($k[--$j],_NQ)==-1){$k[$j++]=$1.i;$k[$j++]=$1.j;if($g($1.maskfuncs,$1.m)()===true){break}}else{$k[$j++]=0}$k[$j++]=$1.mask;$k[$j++]=$1.i;$k[$j++]=$1.j;$1.jmv();var _Nb=$k[--$j];var _Nc=$k[--$j];$p(_Nc,_Nb,$k[--$j])}}$p($1.masks,$1.m,$1.mask)}$1.posx=0;$1.posy=0;$1.i=0;for(;;){if($1.posx==$1.cols){break}$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.jmv();var _Nm=$k[--$j];if($g($k[--$j],_Nm)==-1){var _Ns=$G($1.bits,$1.i,$1.databpm);$k[$j++]=0;for(var _Nt=0,_Nu=_Ns.length;_Nt<_Nu;_Nt++){var _Nw=$k[--$j];$k[$j++]=$f(_Nw+$f($g(_Ns,_Nt)-48))*2}var _Nx=$k[--$j];$k[$j++]=~~(_Nx/2);$k[$j++]=$1.pixs;$k[$j++]=$1.posx;$k[$j++]=$1.posy;$1.jmv();var _O1=$k[--$j];var _O2=$k[--$j];$p(_O2,_O1,$k[--$j]);$1.i=$1.i+$1.databpm}$1.posy=$1.posy+1;if($1.posy==$1.rows){$1.posy=0;$1.posx=$1.posx+1}}$1.evalrle=function(){$1.scrle=$k[--$j];$1.scr1=0;$1.scr3=0;for(var _OD=0,_OC=$1.scrle.length-2;_OD<=_OC;_OD+=2){$1.j=_OD;if($g($1.scrle,$1.j+1)!=-1){var _OJ=$g($1.scrle,$1.j);$k[$j++]=_OJ;if(_OJ>=5){$1.scr1=$f($f($k[--$j]-2)+$1.scr1)}else{$j--}if($1.j>=4&&$1.j<=$1.scrle.length-5){var _OR=$G($1.scrle,$1.j-4,10);$k[$j++]=_OR;for(var _OS=0,_OT=_OR.length;_OS<_OT;_OS++){$k[$j++]=$g(_OR,_OS)==1}$j--;for(var _OV=0,_OW=4;_OV<_OW;_OV++){var _OX=$k[--$j];var _OY=$k[--$j];$k[$j++]=_OX;$k[$j++]=_OY;$j--;var _OZ=$k[--$j];var _Oa=$k[--$j];$k[$j++]=$an(_Oa,_OZ)}if($k[--$j]){$k[$j++]=Infinity;var _Oc=$k[--$j];var _Od=$k[--$j];$k[$j++]=_Oc;$q(_Od);var _Oe=$k[--$j];var _Of=$k[--$j];var _Og=$k[--$j];var _Oh=$k[--$j];var _Oi=$k[--$j];var _Oj=$k[--$j];var _Ok=$k[--$j];var _Ol=$k[--$j];var _Om=$k[--$j];$k[$j++]=_Om;$k[$j++]=_Ol;$k[$j++]=_Ok;$k[$j++]=_Oj;$k[$j++]=_Oi;$k[$j++]=_Oh;$k[$j++]=_Og;$k[$j++]=_Of;$k[$j++]=_Oe;if($eq(_Om,_Oi)&&$eq(_Om,_Oe)&&$eq(_Ok,_Og)){var _On=$k[--$j];var _Oo=$k[--$j];var _Op=$k[--$j];$1.c4=_Op;$1.c5=_On;$k[$j++]=_Op;$k[$j++]=_Oo;if($1.c4==$1.bi&&$1.c5==$1.yi||($1.c4==$1.yi&&$1.c5==$1.bi||($1.c4==$1.gi&&$1.c5==$1.mi||$1.c4==$1.mi&&$1.c5==$1.gi))){$1.scr3=$1.scr3+100}}$l()}else{$j--}}}}$k[$j++]=$1.scr1;$k[$j++]=$1.scr3};$1.evalmask=function(){$1.sym=$k[--$j];$1.n1=0;$1.n2=0;$1.n3=0;var _PA=$1.rows;var _PB=$1.cols;if(_PA<_PB){var _=_PB;_PB=_PA;_PA=_}$1.rle=$a($f(_PA*2+2));$1.lastpairs=$a($1.cols);$1.thispairs=$a($1.cols);for(var _PJ=0,_PI=$f($1.cols-1);_PJ<=_PI;_PJ+=1){$1.i=_PJ;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=-1;for(var _PP=$1.i,_PQ=$1.cols,_PO=$f($1.rows*$1.cols-1);_PQ<0?_PP>=_PO:_PP<=_PO;_PP+=_PQ){var _PS=$g($1.sym,_PP);var _PT=$k[--$j];$k[$j++]=_PT;$k[$j++]=_PS;if($eq(_PT,_PS)){$j--;var _PU=$k[--$j];var _PV=$k[--$j];$k[$j++]=$f(_PV+1);$k[$j++]=_PU}else{var _PW=$k[--$j];$k[$j++]=1;$k[$j++]=_PW}}var _PY=$m()+2;$as($G($1.rle,0,_PY-2));$1.evalrle();$1.n3=$f($k[--$j]+$1.n3);$1.n1=$f($k[--$j]+$1.n1);$j--}for(var _Pg=0,_Pf=$f($1.rows-1);_Pg<=_Pf;_Pg+=1){$1.i=_Pg;$1.symrow=$G($1.sym,$1.i*$1.cols,$1.cols);$k[$j++]=Infinity;var _Pm=$1.symrow;$k[$j++]=0;$k[$j++]=-1;for(var _Pn=0,_Po=_Pm.length;_Pn<_Po;_Pn++){var _Pp=$g(_Pm,_Pn);var _Pq=$k[--$j];$k[$j++]=_Pq;$k[$j++]=_Pp;if($eq(_Pq,_Pp)){$j--;var _Pr=$k[--$j];var _Ps=$k[--$j];$k[$j++]=$f(_Ps+1);$k[$j++]=_Pr}else{var _Pt=$k[--$j];$k[$j++]=1;$k[$j++]=_Pt}}var _Pv=$m()+2;$as($G($1.rle,0,_Pv-2));$1.evalrle();$1.n3=$f($k[--$j]+$1.n3);$1.n1=$f($k[--$j]+$1.n1);$j--;var _Q1=$1.thispairs;$1.thispairs=$1.lastpairs;$1.lastpairs=_Q1;var _Q3=$1.symrow;$k[$j++]=-1;for(var _Q4=0,_Q5=_Q3.length;_Q4<_Q5;_Q4++){var _Q6=$g(_Q3,_Q4);var _Q7=$k[--$j];$k[$j++]=_Q6;$k[$j++]=_Q7;if($ne(_Q6,_Q7)){$j--;var _Q8=$k[--$j];$k[$j++]=-1;$k[$j++]=_Q8}}$j--;$as($1.thispairs);$j--;if($1.i>0){$k[$j++]=Infinity;$q($1.lastpairs);$q($1.thispairs);$k[$j++]=$1.n2;for(var _QF=0,_QG=$1.cols;_QF<_QG;_QF++){var _QH=$k[--$j];var _QI=$k[--$j];$k[$j++]=_QH;$k[$j++]=_QI;if(_QI!=-1){var _QK=$k[$j-1-$f($1.cols+1)];if($eq($k[--$j],_QK)){var _QM=$k[--$j];$k[$j++]=$f(_QM+3)}}else{$j--}}$1.n2=$k[--$j];$l()}}$k[$j++]=$f($f($1.n1+$1.n2)+$1.n3)};$1.bestscore=999999999;for(var _QT=0,_QS=$1.masks.length-1;_QT<=_QS;_QT+=1){$1.m=_QT;$1.masksym=$a($1.rows*$1.cols);for(var _Qa=0,_QZ=$f($1.rows*$1.cols-1);_Qa<=_QZ;_Qa+=1){$1.i=_Qa;$p($1.masksym,$1.i,$xo($g($1.pixs,$1.i),$g($g($1.masks,$1.m),$1.i)))}if($1.masks.length!=1){$k[$j++]=$1.masksym;$1.evalmask();$1.score=$k[--$j];if($1.score<$1.bestscore){$1.bestsym=$1.masksym;$1.bestmaskval=$1.m;$1.bestscore=$1.score}}else{$1.bestsym=$1.masksym}}$1.pixs=$1.bestsym;$1.metamask=$1.bestmaskval;$1.addtometapart=function(){var _Qw=$k[--$j];$P($1.metapart,$1.p,_Qw);$1.p=_Qw.length+$1.p};$1.addtometabits=function(){var _R0=$k[--$j];$P($1.metabits,$1.q,_R0);$1.q=_R0.length+$1.q};$1.metapart=$s(40);$1.metabits=$s($1.nummetabits);$1.p=0;$1.q=0;if(!$1.slave){$k[$j++]=~~Math.round(Math.log($1.colors)/Math.log(2))-1;$k[$j++]=3;$1.tofixedbits();$1.addtometapart();$k[$j++]=$G($1.metapart,0,$1.p);$k[$j++]=2;$k[$j++]=-1;$1.ldpc();$1.addtometabits();$1.p=0;$k[$j++]=$1.metass;$k[$j++]=1;$1.tofixedbits();$1.addtometapart();$k[$j++]=$1.metavf;$k[$j++]=2;$1.tofixedbits();$1.addtometapart();$k[$j++]=$1.metamask;$k[$j++]=3;$1.tofixedbits();$1.addtometapart();if($1.hasslaves){$k[$j++]="1"}else{$k[$j++]="0"}$1.addtometapart();$k[$j++]=$G($1.metapart,0,$1.p);$k[$j++]=2;$k[$j++]=-1;$1.ldpc();$1.addtometabits();$1.p=0;if($1.metass==0){$k[$j++]=$f($f(~~($f($1.cols-17)/4)-$g($a([0,4,8,16]),$1.metavf))-1);$k[$j++]=$1.metavlen;$1.tofixedbits();$1.addtometapart()}else{$k[$j++]=~~($f($1.cols-17)/4)-1;$k[$j++]=~~($1.metavlen/2);$1.tofixedbits();$1.addtometapart();$k[$j++]=~~($f($1.rows-17)/4)-1;$k[$j++]=~~($1.metavlen/2);$1.tofixedbits();$1.addtometapart()}$k[$j++]=$1.datawc-3;$k[$j++]=~~($1.metaelen/2);$1.tofixedbits();$1.addtometapart();$k[$j++]=$1.datawr-4;$k[$j++]=~~($1.metaelen/2);$1.tofixedbits();$1.addtometapart();if($1.hasslaves){$k[$j++]=0;$k[$j++]=4;$1.tofixedbits();$1.addtometapart()}$k[$j++]=$G($1.metapart,0,$1.p);$k[$j++]=2;$k[$j++]=-1;$1.ldpc();$1.addtometabits();$1.p=0}else{var _Rc=$1.sameshape?0:1;$k[$j++]=_Rc;$k[$j++]=1;$1.tofixedbits();$1.addtometapart();var _Re=$1.sameecc?0:1;$k[$j++]=_Re;$k[$j++]=1;$1.tofixedbits();$1.addtometapart();var _Rg=$1.hasslaves?1:0;$k[$j++]=_Rg;$k[$j++]=1;$1.tofixedbits();$1.addtometapart();$k[$j++]=$G($1.metapart,0,$1.p);$k[$j++]=2;$k[$j++]=-1;$1.ldpc();$1.addtometabits();$1.p=0;if(!$1.sameshape){$k[$j++]=~~(($1.diffside-17)/4)-1;$k[$j++]=5;$1.tofixedbits();$1.addtometapart()}if($1.hasslaves){$k[$j++]=0;$k[$j++]=3;$1.tofixedbits();$1.addtometapart()}$k[$j++]=$G($1.metapart,0,$1.p);$k[$j++]=2;$k[$j++]=-1;$1.ldpc();$1.addtometabits();$1.p=0;if(!$1.sameecc){$k[$j++]=$1.datawc-3;$k[$j++]=~~($1.metaelen/2);$1.tofixedbits();$1.addtometapart();$k[$j++]=$1.datawr-4;$k[$j++]=~~($1.metaelen/2);$1.tofixedbits();$1.addtometapart()}$k[$j++]=$G($1.metapart,0,$1.p);$k[$j++]=2;$k[$j++]=-1;$1.ldpc();$1.addtometabits();$1.p=0}for(var _S1=$1.q,_S0=$f($1.nummetabits-1);_S1<=_S0;_S1+=1){$p($1.metabits,_S1,48)}$1.i=0;$1.j=0;if(!$1.slave){var _S6=$G($1.metabits,$1.i,6);for(var _S7=0,_S8=_S6.length;_S7<_S8;_S7++){$k[$j++]=$g(_S6,_S7);if($1.colors==4){$k[$j++]=$a([$1.bi,$1.yi])}else{$k[$j++]=$a([$1.ki,$1.wi])}var _SH=$k[--$j];var _SJ=$g(_SH,$f($k[--$j]-48));$k[$j++]=_SJ;$k[$j++]=$1.pixs;$q($g($1.metadatamap,$1.j));$1.jmv();var _SO=$k[--$j];var _SP=$k[--$j];$p(_SP,_SO,$k[--$j]);$1.j=$1.j+1}$1.i=$1.i+6}for(var _SW=0,_SX=~~($f($1.nummetabits-$1.i)/$1.metabpm);_SW<_SX;_SW++){var _Sb=$G($1.metabits,$1.i,$1.metabpm);$k[$j++]=0;for(var _Sc=0,_Sd=_Sb.length;_Sc<_Sd;_Sc++){var _Sf=$k[--$j];$k[$j++]=$f(_Sf+$f($g(_Sb,_Sc)-48))*2}var _Si=$g($1.metacolorindex,~~($k[--$j]/2));$k[$j++]=_Si;$k[$j++]=$1.pixs;$q($g($1.metadatamap,$1.j));$1.jmv();var _Sn=$k[--$j];var _So=$k[--$j];$p(_So,_Sn,$k[--$j]);$1.i=$f($1.i+$1.metabpm);$1.j=$1.j+1}var _T0=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.cols],["pixy",$1.rows],["colormap",$1.palette],["height",$1.rows*2/72],["width",$1.cols*2/72],["opt",$1.options]]);$k[$j++]=_T0;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1_cc(){var $1=Object.create(bwipp_gs1_cc.$ctx||(bwipp_gs1_cc.$ctx={}));$1.parse=false;$1.dontlint=false;$1.lintreqs=false;$1.dontdraw=false;$1.ccversion="a";$1.cccolumns=-1;$1.lintype="";$1.linwidth=-1;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($ne($1.ccversion,"a")&&$ne($1.ccversion,"b")&&$ne($1.ccversion,"c")){$k[$j++]="bwipp.gs1ccBadCCversion#27168";$k[$j++]="ccversion must be a, b or c";bwipp_raiseerror()}if($1.cccolumns>30){$k[$j++]="bwipp.gs1ccColumnsTooBig#27172";$k[$j++]="The maximum number of composite component columns is 30";bwipp_raiseerror()}if(!bwipp_gs1_cc.__27190__){(function(){var $ctx=Object.create($1);var _6=new Map([["ean13",4],["upca",4],["ean8",3],["upce",2],["gs1-128",4],["databaromni",4],["databarstacked",2],["databarstackedomni",2],["databartruncated",4],["databarlimited",3],["databarexpanded",4],["databarexpandedstacked",4]]);$ctx.lintypecccolumns=_6;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1_cc.$ctx[id]=$ctx[id]);bwipp_gs1_cc.__27190__=1})()}if($ne($1.lintype,"")){var _B=$g($1.lintypecccolumns,$1.lintype)!==undefined;if(!_B){$k[$j++]="bwipp.gs1ccBadLinType#27194";$k[$j++]="The lintype is not recognised";bwipp_raiseerror()}}if($1.cccolumns==-1){if($eq($1.lintype,"gs1-128")&&$eq($1.ccversion,"c")){if($1.linwidth<0){$k[$j++]="bwipp.gs1ccMissingLinWidth#27202";$k[$j++]="linwidth must be set for a GS1-128 with a CC-C composite component";bwipp_raiseerror()}$k[$j++]=~~(($1.linwidth-52)/17)}else{$k[$j++]=$g($1.lintypecccolumns,$1.lintype)}$1.cccolumns=$k[--$j]}$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];$1.isupper=function(){var _P=$k[--$j];$k[$j++]=_P>=65&&_P<=90};$1.isnum0=function(){var _Q=$k[--$j];$k[$j++]=_Q>=48&&_Q<=57};$1.isnum1=function(){var _R=$k[--$j];$k[$j++]=_R>=49&&_R<=57};for(;;){if($1.ais.length>=1){if($eq($g($1.ais,0),"10")||$eq($g($1.ais,0),"11")||$eq($g($1.ais,0),"17")){$k[$j++]=-1;$k[$j++]="10";break}}if($1.ais.length>=1){if($eq($g($1.ais,0),"90")){$1.v=$g($1.vals,0);if($1.v.length>=1){$k[$j++]=$g($1.v,0);$1.isupper();if($k[--$j]){$k[$j++]=0;$k[$j++]="11";break}}if($1.v.length>=2){$k[$j++]=$g($1.v,0);$1.isnum1();$k[$j++]=$g($1.v,1);$1.isupper();var _n=$k[--$j];var _o=$k[--$j];if(_o&&_n){$k[$j++]=1;$k[$j++]="11";break}}if($1.v.length>=3){$k[$j++]=$g($1.v,0);$1.isnum1();$k[$j++]=$g($1.v,1);$1.isnum0();var _u=$k[--$j];var _v=$k[--$j];$k[$j++]=$an(_v,_u);$k[$j++]=$g($1.v,2);$1.isupper();var _y=$k[--$j];var _z=$k[--$j];if(_z&&_y){$k[$j++]=2;$k[$j++]="11";break}}if($1.v.length>=4){$k[$j++]=$g($1.v,0);$1.isnum1();$k[$j++]=$g($1.v,1);$1.isnum0();var _15=$k[--$j];var _16=$k[--$j];$k[$j++]=$an(_16,_15);$k[$j++]=$g($1.v,2);$1.isnum0();var _19=$k[--$j];var _1A=$k[--$j];$k[$j++]=$an(_1A,_19);$k[$j++]=$g($1.v,3);$1.isupper();var _1D=$k[--$j];var _1E=$k[--$j];if(_1E&&_1D){$k[$j++]=3;$k[$j++]="11";break}}}}$k[$j++]=-1;$k[$j++]="0";break}$1.method=$k[--$j];$1.npre=$k[--$j];$1.tobin=function(){var _1I=$s($k[--$j]);$k[$j++]=_1I;for(var _1K=0,_1J=_1I.length-1;_1K<=_1J;_1K+=1){var _1L=$k[--$j];$p(_1L,_1K,48);$k[$j++]=_1L}var _1M=$k[--$j];var _1P=$R($s(_1M.length),$k[--$j],2);$P(_1M,_1M.length-_1P.length,_1P);$k[$j++]=_1M};if(!bwipp_gs1_cc.__27322__){(function(){var $ctx=Object.create($1);$ctx.fnc1=-1;$ctx.lnumeric=-2;$ctx.lalphanumeric=-3;$ctx.liso646=-4;$k[$j++]=Infinity;for(var _1Q=65;_1Q<=90;_1Q+=1){$k[$j++]=_1Q;$k[$j++]=_1Q-65;$k[$j++]=5;$ctx.tobin()}for(var _1R=48;_1R<=57;_1R+=1){$k[$j++]=_1R;$k[$j++]=_1R+4;$k[$j++]=6;$ctx.tobin()}$k[$j++]=$ctx.fnc1;$k[$j++]="11111";$ctx.alpha=$d();$k[$j++]=Infinity;for(var _1U=0;_1U<=119;_1U+=1){var _1W=$Z($s(2),"00");var _1Y=$R($s(2),_1U,11);$P(_1W,2-_1Y.length,_1Y);$k[$j++]=_1U;$k[$j++]=_1W;if($g(_1W,0)==65){var _1a=$k[--$j];$p(_1a,0,94);$k[$j++]=_1a}var _1b=$k[--$j];$k[$j++]=_1b;if($g(_1b,1)==65){var _1d=$k[--$j];$p(_1d,1,94);$k[$j++]=_1d}var _1e=$k[--$j];var _1h=$Z($s(7),"0000000");var _1j=$R($s(7),$f($k[--$j]+8),2);$P(_1h,7-_1j.length,_1j);$k[$j++]=_1e;$k[$j++]=_1h}$k[$j++]=$ctx.lalphanumeric;$k[$j++]="0000";$ctx.numeric=$d();$k[$j++]=Infinity;for(var _1m=48;_1m<=57;_1m+=1){$k[$j++]=_1m;$k[$j++]=_1m-43;$k[$j++]=5;$ctx.tobin()}$k[$j++]=$ctx.fnc1;$k[$j++]="01111";for(var _1o=65;_1o<=90;_1o+=1){$k[$j++]=_1o;$k[$j++]=_1o-33;$k[$j++]=6;$ctx.tobin()}$k[$j++]=42;$k[$j++]="111010";for(var _1p=44;_1p<=47;_1p+=1){$k[$j++]=_1p;$k[$j++]=_1p+15;$k[$j++]=6;$ctx.tobin()}$k[$j++]=$ctx.lnumeric;$k[$j++]="000";$k[$j++]=$ctx.liso646;$k[$j++]="00100";$ctx.alphanumeric=$d();$k[$j++]=Infinity;for(var _1t=48;_1t<=57;_1t+=1){$k[$j++]=_1t;$k[$j++]=_1t-43;$k[$j++]=5;$ctx.tobin()}$k[$j++]=$ctx.fnc1;$k[$j++]="01111";for(var _1v=65;_1v<=90;_1v+=1){$k[$j++]=_1v;$k[$j++]=_1v-1;$k[$j++]=7;$ctx.tobin()}for(var _1w=97;_1w<=122;_1w+=1){$k[$j++]=_1w;$k[$j++]=_1w-7;$k[$j++]=7;$ctx.tobin()}$k[$j++]=33;$k[$j++]="11101000";$k[$j++]=34;$k[$j++]="11101001";for(var _1x=37;_1x<=47;_1x+=1){$k[$j++]=_1x;$k[$j++]=_1x+197;$k[$j++]=8;$ctx.tobin()}for(var _1y=58;_1y<=63;_1y+=1){$k[$j++]=_1y;$k[$j++]=_1y+187;$k[$j++]=8;$ctx.tobin()}$k[$j++]=95;$k[$j++]="11111011";$k[$j++]=32;$k[$j++]="11111100";$k[$j++]=$ctx.lnumeric;$k[$j++]="000";$k[$j++]=$ctx.lalphanumeric;$k[$j++]="00100";$ctx.iso646=$d();for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1_cc.$ctx[id]=$ctx[id]);bwipp_gs1_cc.__27322__=1})()}if($eq($1.method,"10")){if($eq($g($1.ais,0),"11")||$eq($g($1.ais,0),"17")){var _29=$g($1.vals,0);var _2E=$Z($s(16),"0000000000000000");var _2G=$R($s(16),$i($G(_29,0,2))*384+(($i($G(_29,2,2))-1)*32+$i($G(_29,4,2))),2);$P(_2E,16-_2G.length,_2G);$k[$j++]=_2E;$k[$j++]=Infinity;var _2H=$k[--$j];var _2I=$k[--$j];$k[$j++]=_2H;$k[$j++]=1;$k[$j++]=0;$F(_2I,function(){var _2J=$k[--$j];$k[$j++]=$f(_2J-48)});var _2M=$eq($g($1.ais,0),"11")?0:1;$k[$j++]=_2M;$1.cdf=$a();$1.ais=$G($1.ais,1,$1.ais.length-1);$1.vals=$G($1.vals,1,$1.vals.length-1);$1.fncs=$G($1.fncs,1,$1.fncs.length-1)}else{$1.cdf=$a([1,0,1,1])}if($1.ais.length!=0){if($eq($g($1.ais,0),"10")){$k[$j++]=Infinity;$F($g($1.vals,0));$1.gpf=$a();if($1.ais.length>1){$k[$j++]=Infinity;$q($1.gpf);$k[$j++]=$1.fnc1;$1.gpf=$a()}$1.ais=$G($1.ais,1,$1.ais.length-1);$1.vals=$G($1.vals,1,$1.vals.length-1);$1.fncs=$G($1.fncs,1,$1.fncs.length-1)}else{$1.gpf=$a([$1.fnc1])}}else{$k[$j++]=Infinity;$q($1.cdf);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$1.cdf=$a();$1.gpf=$a([])}$1.mode="numeric"}if($eq($1.method,"11")){$1.cdf=$a([1,1]);$1.ai90=$g($1.vals,0);if($f($1.npre+1)!=$1.ai90.length){$k[$j++]=$G($1.ai90,$f($1.npre+1),$f($f($1.ai90.length-$1.npre)-1))}else{$k[$j++]=""}$1.ai90rem=$k[--$j];$k[$j++]="nalpha";$k[$j++]=0;$F($1.ai90rem,function(){var _39=$k[--$j];if(_39>=65&&_39<=90){var _3A=$k[--$j];$k[$j++]=$f(_3A+1)}});var _3B=$k[--$j];$1[$k[--$j]]=_3B;$k[$j++]="nnums";$k[$j++]=0;$F($1.ai90rem,function(){var _3E=$k[--$j];if(_3E>=48&&_3E<=57){var _3F=$k[--$j];$k[$j++]=$f(_3F+1)}});var _3G=$k[--$j];$1[$k[--$j]]=_3G;$k[$j++]="mode";if($gt($1.nalpha,$1.nnums)){$k[$j++]="alpha"}else{if($1.nalpha==0){$k[$j++]="numeric"}else{$k[$j++]="alphanumeric"}}var _3L=$k[--$j];$1[$k[--$j]]=_3L;if($f($1.nalpha+$1.nnums)!=$1.ai90rem.length){$1.mode="alphanumeric"}$k[$j++]=Infinity;$q($1.cdf);if($eq($1.mode,"alphanumeric")){$k[$j++]=0}if($eq($1.mode,"numeric")){$k[$j++]=1;$k[$j++]=0}if($eq($1.mode,"alpha")){$k[$j++]=1;$k[$j++]=1}$1.cdf=$a();$k[$j++]="ais1";if($1.ais.length>1){$k[$j++]=$g($1.ais,1)}else{$k[$j++]=-1}var _3Y=$k[--$j];$1[$k[--$j]]=_3Y;$k[$j++]="vals1";if($1.vals.length>1){$k[$j++]=$g($1.vals,1)}else{$k[$j++]=-1}var _3d=$k[--$j];$1[$k[--$j]]=_3d;if($eq($1.ais1,"21")||$eq($1.ais1,"8004")){$k[$j++]=Infinity;$q($1.cdf);if($eq($1.ais1,"21")){$k[$j++]=1;$k[$j++]=0}else{$k[$j++]=1;$k[$j++]=1}$1.cdf=$a()}else{$k[$j++]=Infinity;$q($1.cdf);$k[$j++]=0;$1.cdf=$a()}$k[$j++]="nval";if($1.npre!=0){$k[$j++]=$i($G($1.ai90,0,$1.npre))}else{$k[$j++]=0}var _3q=$k[--$j];$1[$k[--$j]]=_3q;$X("BDHIJKLNPQRSTVXZ",$G($1.ai90,$1.npre,1));if($k[--$j]){var _3w=$k[--$j];var _3x=$k[--$j];$k[$j++]=_3w.length;$k[$j++]=_3x;$j--;var _3y=$k[--$j];var _3z=$k[--$j];$k[$j++]=_3y;$k[$j++]=_3z;$j--;$1.aval=$k[--$j]}else{$j--;$1.aval=-1}if($1.nval<31&&$1.aval!=-1){var _44=$Z($s(5),"00000");var _47=$R($s(5),$1.nval,2);$P(_44,5-_47.length,_47);$k[$j++]=_44;$k[$j++]=Infinity;var _48=$k[--$j];var _49=$k[--$j];$k[$j++]=_48;$F(_49,function(){var _4A=$k[--$j];$k[$j++]=$f(_4A-48)});$1.nbits=$a();var _4D=$Z($s(4),"0000");var _4G=$R($s(4),$1.aval,2);$P(_4D,4-_4G.length,_4G);$k[$j++]=_4D;$k[$j++]=Infinity;var _4H=$k[--$j];var _4I=$k[--$j];$k[$j++]=_4H;$F(_4I,function(){var _4J=$k[--$j];$k[$j++]=$f(_4J-48)});$1.abits=$a();$k[$j++]=Infinity;$q($1.cdf);$q($1.nbits);$q($1.abits);$1.cdf=$a()}else{var _4Q=$Z($s(10),"0000000000");var _4T=$R($s(10),$1.nval,2);$P(_4Q,10-_4T.length,_4T);$k[$j++]=_4Q;$k[$j++]=Infinity;var _4U=$k[--$j];var _4V=$k[--$j];$k[$j++]=_4U;$F(_4V,function(){var _4W=$k[--$j];$k[$j++]=$f(_4W-48)});$1.nbits=$a();var _4Z=$Z($s(5),"00000");var _4e=$R($s(5),$f($g($1.ai90,$1.npre)-65),2);$P(_4Z,5-_4e.length,_4e);$k[$j++]=_4Z;$k[$j++]=Infinity;var _4f=$k[--$j];var _4g=$k[--$j];$k[$j++]=_4f;$F(_4g,function(){var _4h=$k[--$j];$k[$j++]=$f(_4h-48)});$1.abits=$a();$k[$j++]=Infinity;$q($1.cdf);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$q($1.nbits);$q($1.abits);$1.cdf=$a()}if($ne($1.mode,"alpha")){$k[$j++]=Infinity;$F($1.ai90rem);if($1.ais.length>1){$k[$j++]=$1.fnc1}$1.gpf=$a()}else{$k[$j++]=Infinity;$F($1.ai90rem);if($1.ais.length>1){$k[$j++]=$1.fnc1}$1.in=$a();$1.out=$a($1.in.length*6);$1.j=0;for(var _50=0,_4z=$1.in.length-1;_50<=_4z;_50+=1){var _54=$g($1.alpha,$g($1.in,_50));$k[$j++]=_54;$k[$j++]=_54;$k[$j++]=Infinity;var _55=$k[--$j];var _56=$k[--$j];$k[$j++]=_55;$F(_56,function(){var _57=$k[--$j];$k[$j++]=$f(_57-48)});$P($1.out,$1.j,$a());$1.j=$k[--$j].length+$1.j}$k[$j++]=Infinity;$q($1.cdf);$q($G($1.out,0,$1.j));$1.cdf=$a();$1.gpf=$a([]);if($1.ais.length>1){$1.mode="numeric"}}$1.ais=$G($1.ais,1,$1.ais.length-1);$1.vals=$G($1.vals,1,$1.vals.length-1);$1.fncs=$G($1.fncs,1,$1.fncs.length-1);if($1.ais.length!=0){if($eq($1.ais1,"21")||$eq($1.ais1,"8004")){$k[$j++]=Infinity;$q($1.gpf);$F($1.vals1);$1.gpf=$a();$1.ais=$G($1.ais,1,$1.ais.length-1);$1.vals=$G($1.vals,1,$1.vals.length-1);$1.fncs=$G($1.fncs,1,$1.fncs.length-1);if($1.ais.length!=0){$k[$j++]=Infinity;$q($1.gpf);$k[$j++]=$1.fnc1;$1.gpf=$a()}}}}if($eq($1.method,"0")){$1.cdf=$a([0]);$1.gpf=$a([]);$1.mode="numeric"}for(var _5r=0,_5q=$1.ais.length-1;_5r<=_5q;_5r+=1){$1.i=_5r;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _61=$a($1.gpf.length+$1.ai.length+$1.val.length);$P(_61,0,$1.gpf);$k[$j++]=_61;$k[$j++]=_61;$k[$j++]=$1.gpf.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _65=$k[--$j];var _66=$k[--$j];$k[$j++]=_65;$F(_66);var _67=$a();var _68=$k[--$j];$P($k[--$j],_68,_67);var _6A=$k[--$j];$k[$j++]=_6A;$k[$j++]=_6A;$k[$j++]=$1.gpf.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _6E=$k[--$j];var _6F=$k[--$j];$k[$j++]=_6E;$F(_6F);var _6G=$a();var _6H=$k[--$j];$P($k[--$j],_6H,_6G);$1.gpf=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _6Q=$a($1.gpf.length+1);$P(_6Q,0,$1.gpf);$p(_6Q,$1.gpf.length,$1.fnc1);$1.gpf=_6Q}}if(!bwipp_gs1_cc.__27491__){(function(){var $ctx=Object.create($1);var _6c=new Map([["a",$a([$a([167,138,118,108,88,78,59]),$a([167,138,118,98,78]),$a([197,167,138,108,78])])],["b",$a([$a([336,296,256,208,160,104,56]),$a([768,648,536,416,304,208,152,112,72,32]),$a([1184,1016,840,672,496,352,264,208,152,96,56])])]]);$ctx.bitcapsmaps=_6c;for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1_cc.$ctx[id]=$ctx[id]);bwipp_gs1_cc.__27491__=1})()}$1.rembits=function(){$1.used=$k[--$j];if($ne($1.ccversion,"c")){$1.bitcaps=$g($g($1.bitcapsmaps,$1.ccversion),$f($1.cccolumns-2));$k[$j++]=-1;$F($1.bitcaps,function(){var _6m=$k[--$j];$k[$j++]=_6m;if($ge(_6m,$1.used)){var _6o=$k[--$j];var _6p=$k[--$j];$k[$j++]=_6o;$k[$j++]=_6p}$j--});var _6q=$k[--$j];$k[$j++]=_6q;if(_6q!=-1){var _6s=$k[--$j];$k[$j++]=$f(_6s-$1.used)}}else{var _6t=new Map([["c",-1]]);var _6v=$g(_6t,$1.ccversion);var _6x=~~Math.ceil($1.used/8);$1.m=~~(_6x/6)*5+_6x%6;if($1.m<=40){$k[$j++]=8}if($1.m>=41&&$1.m<=160){$k[$j++]=16}if($1.m>=161&&$1.m<=320){$k[$j++]=32}if($1.m>=321&&$1.m<=833){$k[$j++]=64}if($1.m>=834){$k[$j++]=32}$1.eccws=$k[--$j];$1.m=$f($f($1.m+$1.eccws)+3);if($1.cccolumns>30){$1.cccolumns=30}for(;;){if(~~Math.ceil($1.m/$1.cccolumns)<=30||$1.cccolumns>=30){break}$1.cccolumns=$1.cccolumns+1}$1.r=~~Math.ceil($1.m/$1.cccolumns);if($1.r<3){$1.r=3}var _7K=$f($f($1.cccolumns*$1.r-$1.eccws)-3);$1.tgt=$f(~~(_7K/5)*6+_7K%5)*8;if($1.used<=8304){$k[$j++]=$f($1.tgt-$1.used)}else{$k[$j++]=-1}}var _7O=$k[--$j];$k[$j++]=_7O;if(_7O==-1){$j--;if($eq($1.ccversion,"a")){$1.ccversion="b"}else{if($eq($1.ccversion,"b")&&$eq($1.lintype,"gs1-128")){$1.ccversion="c";$1.cccolumns=~~(($1.linwidth-52)/17)}else{$1.ccversion=-1}}$k[$j++]=$1.used;$1.rembits()}};$1.encode=function(){var _7U=$k[--$j];$k[$j++]=_7U;if($ne(_7U,"raw")){var _7V=$k[--$j];var _7X=$g(_7V,$k[--$j]);$k[$j++]=_7X}else{$j--}$k[$j++]=Infinity;var _7Y=$k[--$j];var _7Z=$k[--$j];$k[$j++]=_7Y;$F(_7Z,function(){var _7a=$k[--$j];$k[$j++]=$f(_7a-48)});var _7b=$a();$P($1.gpfenc,$1.j,_7b);$1.j=_7b.length+$1.j};$k[$j++]=Infinity;for(var _7g=0,_7h=$1.gpf.length;_7g<_7h;_7g++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=-1;$1.numericruns=$a();$k[$j++]=Infinity;for(var _7k=0,_7l=$1.gpf.length;_7k<_7l;_7k++){$k[$j++]=0}$k[$j++]=0;$1.alphanumericruns=$a();$k[$j++]=Infinity;for(var _7o=0,_7p=$1.gpf.length;_7o<_7p;_7o++){$k[$j++]=0}$k[$j++]=9999;$1.nextiso646only=$a();for(var _7s=$1.gpf.length-1;_7s>=0;_7s-=1){$1.i=_7s;var _7x=$Z($s(2),"00");var _80=$g($1.gpf,$1.i);$k[$j++]=$g($1.gpf,$1.i);$k[$j++]=_7x;$k[$j++]=_7x;$k[$j++]=0;$k[$j++]=_80;if(_80==$1.fnc1){$j--;$k[$j++]=94}var _82=$k[--$j];var _83=$k[--$j];$p($k[--$j],_83,_82);if($1.i<$1.gpf.length-1){var _87=$k[--$j];var _8A=$g($1.gpf,$1.i+1);$k[$j++]=_87;$k[$j++]=_87;$k[$j++]=1;$k[$j++]=_8A;if(_8A==$1.fnc1){$j--;$k[$j++]=94}var _8C=$k[--$j];var _8D=$k[--$j];$p($k[--$j],_8D,_8C)}var _8H=$g($1.numeric,$k[--$j])!==undefined;if(_8H){$p($1.numericruns,$1.i,$f($g($1.numericruns,$1.i+2)+2))}else{$p($1.numericruns,$1.i,0)}var _8P=$k[--$j];var _8R=$g($1.alphanumeric,_8P)!==undefined;$k[$j++]=_8P;if(_8R){$p($1.alphanumericruns,$1.i,$f($g($1.alphanumericruns,$1.i+1)+1))}else{$p($1.alphanumericruns,$1.i,0)}var _8Z=$k[--$j];var _8b=$g($1.iso646,_8Z)!==undefined;var _8d=$g($1.alphanumeric,_8Z)!==undefined;if(_8b&&!_8d){$p($1.nextiso646only,$1.i,0)}else{$p($1.nextiso646only,$1.i,$f($g($1.nextiso646only,$1.i+1)+1))}}$1.gpfenc=$a(8304);$1.i=0;$1.j=0;for(;;){if($1.i==$1.gpf.length){break}for(;;){if($eq($1.mode,"numeric")){if($1.i<=$1.gpf.length-2){var _8r=$s(2);var _8u=$g($1.gpf,$1.i);$k[$j++]=_8r;$k[$j++]=_8r;$k[$j++]=0;$k[$j++]=_8u;if(_8u==$1.fnc1){$j--;$k[$j++]=94}var _8w=$k[--$j];var _8x=$k[--$j];$p($k[--$j],_8x,_8w);var _8z=$k[--$j];var _92=$g($1.gpf,$1.i+1);$k[$j++]=_8z;$k[$j++]=_8z;$k[$j++]=1;$k[$j++]=_92;if(_92==$1.fnc1){$j--;$k[$j++]=94}var _94=$k[--$j];var _95=$k[--$j];$p($k[--$j],_95,_94);var _97=$k[--$j];var _99=$g($1.numeric,_97)!==undefined;$k[$j++]=_97;if(_99){$k[$j++]=$1.numeric;$1.encode();$1.i=$1.i+2;break}$j--;$k[$j++]=$1.lalphanumeric;$k[$j++]=$1.numeric;$1.encode();$1.mode="alphanumeric";break}else{var _9G=$g($1.gpf,$1.i);if(_9G<48||_9G>57){$k[$j++]=$1.lalphanumeric;$k[$j++]=$1.numeric;$1.encode();$1.mode="alphanumeric";break}$k[$j++]="rem";$k[$j++]=$1.cdf.length+$1.j;$1.rembits();var _9L=$k[--$j];$1[$k[--$j]]=_9L;if($1.rem>=4&&$1.rem<=6){var _9S=$G($Z($s(6),"000000"),0,$1.rem);var _9X=$R($s(4),$f($g($1.gpf,$1.i)-47),2);$P(_9S,4-_9X.length,_9X);$k[$j++]=_9S;$k[$j++]="raw";$1.encode();$1.i=$1.i+1;break}else{var _9Z=$s(2);$p(_9Z,0,$g($1.gpf,$1.i));$p(_9Z,1,94);$k[$j++]=_9Z;$k[$j++]=$1.numeric;$1.encode();$1.i=$1.i+1;break}}}if($eq($1.mode,"alphanumeric")){if($g($1.gpf,$1.i)==$1.fnc1){$k[$j++]=$1.fnc1;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="numeric";$1.i=$1.i+1;break}var _9p=$g($1.gpf,$1.i);var _9r=$g($1.iso646,_9p)!==undefined;var _9t=$g($1.alphanumeric,_9p)!==undefined;if(_9r&&!_9t){$k[$j++]=$1.liso646;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="iso646";break}if($g($1.numericruns,$1.i)>=6){$k[$j++]=$1.lnumeric;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="numeric";break}var _A3=$g($1.numericruns,$1.i);if(_A3>=4&&$f(_A3+$1.i)==$1.gpf.length){$k[$j++]=$1.lnumeric;$k[$j++]=$1.alphanumeric;$1.encode();$1.mode="numeric";break}$k[$j++]=$g($1.gpf,$1.i);$k[$j++]=$1.alphanumeric;$1.encode();$1.i=$1.i+1;break}if($eq($1.mode,"iso646")){if($g($1.gpf,$1.i)==$1.fnc1){$k[$j++]=$1.fnc1;$k[$j++]=$1.iso646;$1.encode();$1.mode="numeric";$1.i=$1.i+1;break}if($g($1.numericruns,$1.i)>=4&&$g($1.nextiso646only,$1.i)>=10){$k[$j++]=$1.lnumeric;$k[$j++]=$1.iso646;$1.encode();$1.mode="numeric";break}if($g($1.alphanumericruns,$1.i)>=5&&$g($1.nextiso646only,$1.i)>=10){$k[$j++]=$1.lalphanumeric;$k[$j++]=$1.iso646;$1.encode();$1.mode="alphanumeric";break}$k[$j++]=$g($1.gpf,$1.i);$k[$j++]=$1.iso646;$1.encode();$1.i=$1.i+1;break}}}$1.gpf=$G($1.gpfenc,0,$1.j);$k[$j++]="pad";$k[$j++]=$1.cdf.length+$1.gpf.length;$1.rembits();var _Am=$a($k[--$j]);$1[$k[--$j]]=_Am;if($1.pad.length>0){for(var _Ar=0,_Aq=$1.pad.length-1;_Ar<=_Aq;_Ar+=5){$1.i=_Ar;var _As=$1.pad;var _At=$1.i;var _Au=$a([0,0,1,0,0]);var _Av=$1.pad;var _Aw=$1.i;var _Ax=5;var _Ay=_Av.length-_Aw;if(_Av.length-_Aw>5){var _=_Ax;_Ax=_Ay;_Ay=_}$P(_As,_At,$G(_Au,0,_Ay))}if($eq($1.mode,"numeric")){$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.pad);$1.pad=$G($a(),0,$1.pad.length)}if($eq($1.mode,"alpha")){$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.pad);$1.pad=$G($a(),0,$1.pad.length)}}$k[$j++]=Infinity;$q($1.cdf);$q($1.gpf);$q($1.pad);$1.bits=$a();if(!bwipp_gs1_cc.__27702__){(function(){var $ctx=Object.create($1);$k[$j++]=Infinity;$k[$j++]=$a([0,0,0,0,0,0,1]);for(var _BF=0,_BG=68;_BF<_BG;_BF++){$k[$j++]=$a(7)}$ctx.pwr928=$a();for(var _BJ=1;_BJ<=68;_BJ+=1){$ctx.j=_BJ;$ctx.v=0;for(var _BK=6;_BK>=1;_BK-=1){$ctx.i=_BK;$ctx.v=$f($g($g($ctx.pwr928,$ctx.j-1),$ctx.i)*2+~~($ctx.v/928));$p($g($ctx.pwr928,$ctx.j),$ctx.i,$ctx.v%928)}$p($g($ctx.pwr928,$ctx.j),0,$f($g($g($ctx.pwr928,$ctx.j-1),0)*2+~~($ctx.v/928)))}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_gs1_cc.$ctx[id]=$ctx[id]);bwipp_gs1_cc.__27702__=1})()}if($1.ccversion=="a"){$k[$j++]=Infinity;for(var _Bg=0,_Bh=28;_Bg<_Bh;_Bg++){$k[$j++]=0}$1.cws=$a();$1.b=0;$1.c=0;for(;;){if($1.b==$1.bits.length){break}var _Bl=$1.bits;var _Bm=$1.b;var _Bn=$1.bits;var _Bo=$1.b;var _Bp=_Bn.length-_Bo;var _Bq=69;if(69>_Bn.length-_Bo){var _=_Bp;_Bp=_Bq;_Bq=_}$1.bs=$G(_Bl,_Bm,_Bq);$1.bsl=$1.bs.length;$1.cs=$G($1.cws,$1.c,~~($1.bsl/10)+1);$1.csl=$1.cs.length;for(var _C0=0,_Bz=$1.bsl-1;_C0<=_Bz;_C0+=1){$1.i=_C0;for(var _C3=0,_C2=$1.csl-1;_C3<=_C2;_C3+=1){$1.j=_C3;var _C4=$1.cs;var _C5=$1.j;$p(_C4,_C5,$f($g(_C4,_C5)+$g($g($1.pwr928,$1.i),$1.j+7-$1.csl)*$g($1.bs,$1.bsl-$1.i-1)))}}for(var _CI=$1.csl-1;_CI>=1;_CI-=1){$1.i=_CI;var _CJ=$1.cs;var _CK=$1.i;$p(_CJ,_CK-1,$f($g(_CJ,_CK-1)+~~($g($1.cs,$1.i)/928)));var _CP=$1.cs;var _CQ=$1.i;$p(_CP,_CQ,$g(_CP,_CQ)%928)}$1.b=$1.b+$1.bsl;$1.c=$1.c+$1.csl}$1.cws=$G($1.cws,0,$1.c);$1.barcode=$s($1.cws.length*4);for(var _Cd=0,_Cc=$1.cws.length-1;_Cd<=_Cc;_Cd+=1){$1.i=_Cd;var _Cf=$Z($s(4),"^000");var _Ck=$R($s(4),$g($1.cws,$1.i),10);$P(_Cf,4-_Ck.length,_Ck);$P($1.barcode,$1.i*4,_Cf)}delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"cca",true);$p($1.options,"columns",$1.cccolumns);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_micropdf417();var _Cu=$k[--$j];$1[$k[--$j]]=_Cu}if($1.ccversion=="b"){$1.barcode=$s(~~($1.bits.length/8));for(var _D1=0,_D0=$1.barcode.length-1;_D1<=_D0;_D1+=1){$1.i=_D1;var _D4=$G($1.bits,$1.i*8,8);$k[$j++]=0;for(var _D5=0,_D6=_D4.length;_D5<_D6;_D5++){var _D8=$k[--$j];$k[$j++]=$f(_D8+$g(_D4,_D5))*2}$p($1.barcode,$1.i,~~($k[--$j]/2))}delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"ccb",true);$p($1.options,"columns",$1.cccolumns);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_micropdf417();var _DJ=$k[--$j];$1[$k[--$j]]=_DJ}if($1.ccversion=="c"){$1.barcode=$s(~~($1.bits.length/8));for(var _DQ=0,_DP=$1.barcode.length-1;_DQ<=_DP;_DQ+=1){$1.i=_DQ;var _DT=$G($1.bits,$1.i*8,8);$k[$j++]=0;for(var _DU=0,_DV=_DT.length;_DU<_DV;_DU++){var _DX=$k[--$j];$k[$j++]=$f(_DX+$g(_DT,_DU))*2}$p($1.barcode,$1.i,~~($k[--$j]/2))}delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"ccc",true);$p($1.options,"columns",$1.cccolumns);$p($1.options,"eclevel",~~(Math.log($1.eccws)/Math.log(2))-1);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_pdf417();var _Dk=$k[--$j];$1[$k[--$j]]=_Dk}$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_ean13composite(){var $1=Object.create(bwipp_ean13composite.$ctx||(bwipp_ean13composite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#27832";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($1.options,"lintype","ean13");$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _C=$s($1.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$1.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_ean13();if(!$1.usematrix){$$.save();bwipp_renlinear();$$.rmoveto(-1,72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _H=0,_I=93;_H<_I;_H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _J=0,_K=93;_J<_K;_J++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _L=0,_M=93;_L<_M;_L++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _N=$a();$k[$j++]="ren";$k[$j++]=bwipp_renmatrix;$k[$j++]="pixs";$k[$j++]=_N;$k[$j++]="pixx";$k[$j++]=97;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=97/72;$k[$j++]="opt";$k[$j++]=$1.options;var _P=$d();$k[$j++]=_P;bwipp_renmatrix();$$.rmoveto(-2,6);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$1.linsym=$k[--$j];$1.sbs=$g($1.linsym,"sbs");$1.bhs=$g($1.linsym,"bhs");$1.bbs=$g($1.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($1.sbs,function(){var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=$f(_b+$i(_a))});var _c=$k[--$j];$1[$k[--$j]]=_c;$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _g=$k[--$j];$1[$k[--$j]]=_g;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;for(var _n=0,_o=$f($1.ccpixx-97);_n<_o;_n++){$k[$j++]=0}$1.linpad=$a();$1.diff=$f($f($f($1.linwidth+$1.linpad.length)+2)-$1.ccpixx);if($1.diff>0){$k[$j++]=Infinity;for(var _v=0,_w=$1.diff;_v<_w;_v++){$k[$j++]=0}$1.ccrpad=$a();$1.pixx=$f($1.ccpixx+$1.diff)}else{$1.ccrpad=$a(0);$1.pixx=$1.ccpixx}$k[$j++]=Infinity;for(var _15=0,_16=$1.ccpixx,_14=$1.ccpixs.length-1;_16<0?_15>=_14:_15<=_14;_15+=_16){$1.i=_15;for(var _17=0,_18=2;_17<_18;_17++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}for(var _1E=0,_1F=2;_1E<_1F;_1E++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1H=0,_1I=93;_1H<_1I;_1H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1K=0,_1L=2;_1K<_1L;_1K++){$q($1.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1N=0,_1O=93;_1N<_1O;_1N++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($1.ccrpad)}for(var _1Q=0,_1R=2;_1Q<_1R;_1Q++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1T=0,_1U=93;_1T<_1U;_1T++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1W=71;_1W>=0;_1W-=1){$1.y=_1W;$q($1.linpad);$k[$j++]=0;for(var _1a=0,_1Z=$1.sbs.length-1;_1a<=_1Z;_1a+=1){$1.i=_1a;if($1.i%2==0){var _1f=$g($1.bbs,~~($1.i/2))*72;if(_1f>$1.y||$f(_1f+$g($1.bhs,~~($1.i/2))*72)<$1.y){for(var _1o=0,_1p=$i($g($1.sbs,$1.i));_1o<_1p;_1o++){$k[$j++]=0}}else{for(var _1t=0,_1u=$i($g($1.sbs,$1.i));_1t<_1u;_1t++){$k[$j++]=1}}}else{for(var _1y=0,_1z=$i($g($1.sbs,$1.i));_1y<_1z;_1y++){$k[$j++]=0}}}$k[$j++]=0}$1.pixs=$a();$1.pixy=~~($1.pixs.length/$1.pixx);var _29=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_29;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_ean8composite(){var $1=Object.create(bwipp_ean8composite.$ctx||(bwipp_ean8composite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#27993";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($1.options,"lintype","ean8");$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _C=$s($1.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$1.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_ean8();if(!$1.usematrix){$$.save();bwipp_renlinear();$$.rmoveto(-1,72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _H=0,_I=65;_H<_I;_H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _J=0,_K=65;_J<_K;_J++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _L=0,_M=65;_L<_M;_L++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _N=$a();$k[$j++]="ren";$k[$j++]=bwipp_renmatrix;$k[$j++]="pixs";$k[$j++]=_N;$k[$j++]="pixx";$k[$j++]=69;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=69/72;$k[$j++]="opt";$k[$j++]=$1.options;var _P=$d();$k[$j++]=_P;bwipp_renmatrix();$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _S=$k[--$j];$$.rmoveto($f(69-$g(_S,"pixx")),6);$k[$j++]=_S;bwipp_renmatrix();$$.restore()}else{$1.linsym=$k[--$j];$1.sbs=$g($1.linsym,"sbs");$1.bhs=$g($1.linsym,"bhs");$1.bbs=$g($1.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($1.sbs,function(){var _c=$k[--$j];var _d=$k[--$j];$k[$j++]=$f(_d+$i(_c))});var _e=$k[--$j];$1[$k[--$j]]=_e;var _g=$1.comp;$k[$j++]="compsym";$k[$j++]=_g;$k[$j++]=$1.options;bwipp_gs1_cc();var _i=$k[--$j];$1[$k[--$j]]=_i;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;for(var _p=0,_q=$f($1.ccpixx-69);_p<_q;_p++){$k[$j++]=0}$1.linpad=$a();$1.diff=$f($f($f($1.linwidth+$1.linpad.length)+2)-$1.ccpixx);if($1.diff>0){$k[$j++]=Infinity;for(var _x=0,_y=$1.diff;_x<_y;_x++){$k[$j++]=0}$1.ccrpad=$a();$1.pixx=$f($1.ccpixx+$1.diff)}else{$1.ccrpad=$a(0);$1.pixx=$1.ccpixx}$k[$j++]=Infinity;for(var _17=0,_18=$1.ccpixx,_16=$1.ccpixs.length-1;_18<0?_17>=_16:_17<=_16;_17+=_18){$1.i=_17;for(var _19=0,_1A=2;_19<_1A;_19++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}for(var _1G=0,_1H=2;_1G<_1H;_1G++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1J=0,_1K=65;_1J<_1K;_1J++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1M=0,_1N=2;_1M<_1N;_1M++){$q($1.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1P=0,_1Q=65;_1P<_1Q;_1P++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($1.ccrpad)}for(var _1S=0,_1T=2;_1S<_1T;_1S++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1V=0,_1W=65;_1V<_1W;_1V++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1Y=71;_1Y>=0;_1Y-=1){$1.y=_1Y;$q($1.linpad);$k[$j++]=0;for(var _1c=0,_1b=$1.sbs.length-1;_1c<=_1b;_1c+=1){$1.i=_1c;if($1.i%2==0){var _1h=$g($1.bbs,~~($1.i/2))*72;if(_1h>$1.y||$f(_1h+$g($1.bhs,~~($1.i/2))*72)<$1.y){for(var _1q=0,_1r=$i($g($1.sbs,$1.i));_1q<_1r;_1q++){$k[$j++]=0}}else{for(var _1v=0,_1w=$i($g($1.sbs,$1.i));_1v<_1w;_1v++){$k[$j++]=1}}}else{for(var _20=0,_21=$i($g($1.sbs,$1.i));_20<_21;_20++){$k[$j++]=0}}}$k[$j++]=0}$1.pixs=$a();$1.pixy=~~($1.pixs.length/$1.pixx);var _2B=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_2B;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_upcacomposite(){var $1=Object.create(bwipp_upcacomposite.$ctx||(bwipp_upcacomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#28157";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($1.options,"lintype","ean13");$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _C=$s($1.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$1.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_upca();if(!$1.usematrix){$$.save();bwipp_renlinear();$$.rmoveto(-1,72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _H=0,_I=93;_H<_I;_H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _J=0,_K=93;_J<_K;_J++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _L=0,_M=93;_L<_M;_L++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _N=$a();$k[$j++]="ren";$k[$j++]=bwipp_renmatrix;$k[$j++]="pixs";$k[$j++]=_N;$k[$j++]="pixx";$k[$j++]=97;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=97/72;$k[$j++]="opt";$k[$j++]=$1.options;var _P=$d();$k[$j++]=_P;bwipp_renmatrix();$$.rmoveto(-2,6);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$1.linsym=$k[--$j];$1.sbs=$g($1.linsym,"sbs");$1.bhs=$g($1.linsym,"bhs");$1.bbs=$g($1.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($1.sbs,function(){var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=$f(_b+$i(_a))});var _c=$k[--$j];$1[$k[--$j]]=_c;$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _g=$k[--$j];$1[$k[--$j]]=_g;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;for(var _n=0,_o=$f($1.ccpixx-97);_n<_o;_n++){$k[$j++]=0}$1.linpad=$a();$1.diff=$f($f($f($1.linwidth+$1.linpad.length)+2)-$1.ccpixx);if($1.diff>0){$k[$j++]=Infinity;for(var _v=0,_w=$1.diff;_v<_w;_v++){$k[$j++]=0}$1.ccrpad=$a();$1.pixx=$f($1.ccpixx+$1.diff)}else{$1.ccrpad=$a(0);$1.pixx=$1.ccpixx}$k[$j++]=Infinity;for(var _15=0,_16=$1.ccpixx,_14=$1.ccpixs.length-1;_16<0?_15>=_14:_15<=_14;_15+=_16){$1.i=_15;for(var _17=0,_18=2;_17<_18;_17++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}for(var _1E=0,_1F=2;_1E<_1F;_1E++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1H=0,_1I=93;_1H<_1I;_1H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1K=0,_1L=2;_1K<_1L;_1K++){$q($1.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1N=0,_1O=93;_1N<_1O;_1N++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($1.ccrpad)}for(var _1Q=0,_1R=2;_1Q<_1R;_1Q++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1T=0,_1U=93;_1T<_1U;_1T++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1W=71;_1W>=0;_1W-=1){$1.y=_1W;$q($1.linpad);$k[$j++]=0;for(var _1a=0,_1Z=$1.sbs.length-1;_1a<=_1Z;_1a+=1){$1.i=_1a;if($1.i%2==0){var _1f=$g($1.bbs,~~($1.i/2))*72;if(_1f>$1.y||$f(_1f+$g($1.bhs,~~($1.i/2))*72)<$1.y){for(var _1o=0,_1p=$i($g($1.sbs,$1.i));_1o<_1p;_1o++){$k[$j++]=0}}else{for(var _1t=0,_1u=$i($g($1.sbs,$1.i));_1t<_1u;_1t++){$k[$j++]=1}}}else{for(var _1y=0,_1z=$i($g($1.sbs,$1.i));_1y<_1z;_1y++){$k[$j++]=0}}}$k[$j++]=0}$1.pixs=$a();$1.pixy=~~($1.pixs.length/$1.pixx);var _29=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_29;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_upcecomposite(){var $1=Object.create(bwipp_upcecomposite.$ctx||(bwipp_upcecomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#28318";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($1.options,"lintype","upce");$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _C=$s($1.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$1.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_upce();if(!$1.usematrix){$$.save();bwipp_renlinear();$$.rmoveto(-1,72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _H=0,_I=49;_H<_I;_H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _J=0,_K=49;_J<_K;_J++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _L=0,_M=49;_L<_M;_L++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _N=$a();$k[$j++]="ren";$k[$j++]=bwipp_renmatrix;$k[$j++]="pixs";$k[$j++]=_N;$k[$j++]="pixx";$k[$j++]=53;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=53/72;$k[$j++]="opt";$k[$j++]=$1.options;var _P=$d();$k[$j++]=_P;bwipp_renmatrix();$$.rmoveto(-2,6);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$1.linsym=$k[--$j];$1.sbs=$g($1.linsym,"sbs");$1.bhs=$g($1.linsym,"bhs");$1.bbs=$g($1.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($1.sbs,function(){var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=$f(_b+$i(_a))});var _c=$k[--$j];$1[$k[--$j]]=_c;$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _g=$k[--$j];$1[$k[--$j]]=_g;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;for(var _n=0,_o=$f($1.ccpixx-53);_n<_o;_n++){$k[$j++]=0}$1.linpad=$a();$1.diff=$f($f($f($1.linwidth+$1.linpad.length)+2)-$1.ccpixx);if($1.diff>0){$k[$j++]=Infinity;for(var _v=0,_w=$1.diff;_v<_w;_v++){$k[$j++]=0}$1.ccrpad=$a();$1.pixx=$f($1.ccpixx+$1.diff)}else{$1.ccrpad=$a(0);$1.pixx=$1.ccpixx}$k[$j++]=Infinity;for(var _15=0,_16=$1.ccpixx,_14=$1.ccpixs.length-1;_16<0?_15>=_14:_15<=_14;_15+=_16){$1.i=_15;for(var _17=0,_18=2;_17<_18;_17++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}for(var _1E=0,_1F=2;_1E<_1F;_1E++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1H=0,_1I=49;_1H<_1I;_1H++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1K=0,_1L=2;_1K<_1L;_1K++){$q($1.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1N=0,_1O=49;_1N<_1O;_1N++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($1.ccrpad)}for(var _1Q=0,_1R=2;_1Q<_1R;_1Q++){$q($1.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1T=0,_1U=49;_1T<_1U;_1T++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($1.ccrpad)}for(var _1W=71;_1W>=0;_1W-=1){$1.y=_1W;$q($1.linpad);$k[$j++]=0;for(var _1a=0,_1Z=$1.sbs.length-1;_1a<=_1Z;_1a+=1){$1.i=_1a;if($1.i%2==0){var _1f=$g($1.bbs,~~($1.i/2))*72;if(_1f>$1.y||$f(_1f+$g($1.bhs,~~($1.i/2))*72)<$1.y){for(var _1o=0,_1p=$i($g($1.sbs,$1.i));_1o<_1p;_1o++){$k[$j++]=0}}else{for(var _1t=0,_1u=$i($g($1.sbs,$1.i));_1t<_1u;_1t++){$k[$j++]=1}}}else{for(var _1y=0,_1z=$i($g($1.sbs,$1.i));_1y<_1z;_1y++){$k[$j++]=0}}}$k[$j++]=0}$1.pixs=$a();$1.pixy=~~($1.pixs.length/$1.pixx);var _29=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_29;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databaromnicomposite(){var $1=Object.create(bwipp_databaromnicomposite.$ctx||(bwipp_databaromnicomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#28479";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databaromni");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databaromni();var _L=$k[--$j];$1.linsbs=$g(_L,"sbs");$1.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$1.usematrix){bwipp_renlinear()}else{$j--}$1.sepfinder=function(){$1.fp=$k[--$j];for(var _U=$1.fp,_T=$f($1.fp+12);_U<=_T;_U+=1){$1.i=_U;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _e=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_e}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}$1.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _j=0;_j<=12;_j+=1){var _p=$k[--$j];$k[$j++]=_p&&$eq($g($1.bot,$f(_j+$1.fp)),$g($1.f3,_j))}if($k[--$j]){$P($1.sep,$1.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _v=$k[--$j];var _w=$k[--$j];var _x=_w==1?0:1;$k[$j++]=_w;for(var _y=0,_z=_v;_y<_z;_y++){$k[$j++]=_x}});$as($a($m()-1));$1.bot=$k[--$j];$j-=2;$k[$j++]=Infinity;$F($1.bot,function(){var _14=$k[--$j];$k[$j++]=$f(1-_14)});$1.sep=$a();$P($1.sep,0,$a([0,0,0]));$P($1.sep,$1.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$1.sepfinder();$k[$j++]=64;$1.sepfinder();if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _1H=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_1H;bwipp_renmatrix();$$.rmoveto(-5,1);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _1M=$k[--$j];$1[$k[--$j]]=_1M;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _1T=$k[--$j];var _1U=$k[--$j];var _1V=_1U==0?1:0;$k[$j++]=_1U;for(var _1W=0,_1X=$i(_1T);_1W<_1X;_1W++){$k[$j++]=_1V}});$1.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($1.sep);$1.sep=$a();$1.linheight=~~$1.linheight;$k[$j++]=Infinity;for(var _1f=0,_1g=$1.ccpixx,_1e=$1.ccpixs.length-1;_1g<0?_1f>=_1e:_1f<=_1e;_1f+=_1g){$1.i=_1f;for(var _1h=0,_1i=2;_1h<_1i;_1h++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$k[$j++]=0}}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.sep);for(var _1p=0,_1q=$1.linheight;_1p<_1q;_1p++){$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.linpixs)}$1.pixs=$a();$1.pixx=$f($1.ccpixx+1);$1.pixy=~~($1.pixs.length/$1.pixx);var _22=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_22;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databarstackedcomposite(){var $1=Object.create(bwipp_databarstackedcomposite.$ctx||(bwipp_databarstackedcomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#28636";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databarstacked");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databarstacked();var _L=$k[--$j];$1.bot=$G($g(_L,"pixs"),0,$g(_L,"pixx"));$1.linheight=$g(_L,"pixy");$k[$j++]=_L;if(!$1.usematrix){bwipp_renmatrix()}else{$1.linpixs=$g($k[--$j],"pixs")}$1.sepfinder=function(){$1.fp=$k[--$j];for(var _X=$1.fp,_W=$f($1.fp+12);_X<=_W;_X+=1){$1.i=_X;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _h=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_h}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}$1.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _m=0;_m<=12;_m+=1){var _s=$k[--$j];$k[$j++]=_s&&$eq($g($1.bot,$f(_m+$1.fp)),$g($1.f3,_m))}if($k[--$j]){$P($1.sep,$1.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;var _x=$1.bot;for(var _y=0,_z=_x.length;_y<_z;_y++){$k[$j++]=$f(1-$g(_x,_y))}$1.sep=$a();$P($1.sep,0,$a([0,0,0,0]));$P($1.sep,$1.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$1.sepfinder();if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _1D=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_1D;bwipp_renmatrix();$$.rmoveto(1,1);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _1I=$k[--$j];$1[$k[--$j]]=_1I;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$1.linwidth=$1.sep.length;$k[$j++]=Infinity;for(var _1S=0,_1T=$1.ccpixx,_1R=$1.ccpixs.length-1;_1T<0?_1S>=_1R:_1S<=_1R;_1S+=_1T){$1.i=_1S;for(var _1U=0,_1V=2;_1U<_1V;_1U++){$k[$j++]=0;$q($G($1.ccpixs,$1.i,$1.ccpixx))}}$q($1.sep);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _1e=0,_1f=$1.linwidth,_1d=$1.linpixs.length-1;_1f<0?_1e>=_1d:_1e<=_1d;_1e+=_1f){$1.i=_1e;$q($G($1.linpixs,$1.i,$1.linwidth));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}$1.pixs=$a();$1.pixx=$f($1.ccpixx+1);$1.pixy=~~($1.pixs.length/$1.pixx);var _1u=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_1u;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databarstackedomnicomposite(){var $1=Object.create(bwipp_databarstackedomnicomposite.$ctx||(bwipp_databarstackedomnicomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#28789";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databarstackedomni");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databarstackedomni();var _L=$k[--$j];$1.bot=$G($g(_L,"pixs"),0,$g(_L,"pixx"));$1.linheight=$g(_L,"pixy");$k[$j++]=_L;if(!$1.usematrix){bwipp_renmatrix()}else{$1.linpixs=$g($k[--$j],"pixs")}$1.sepfinder=function(){$1.fp=$k[--$j];for(var _X=$1.fp,_W=$f($1.fp+12);_X<=_W;_X+=1){$1.i=_X;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _h=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_h}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}$1.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _m=0;_m<=12;_m+=1){var _s=$k[--$j];$k[$j++]=_s&&$eq($g($1.bot,$f(_m+$1.fp)),$g($1.f3,_m))}if($k[--$j]){$P($1.sep,$1.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;var _x=$1.bot;for(var _y=0,_z=_x.length;_y<_z;_y++){$k[$j++]=$f(1-$g(_x,_y))}$1.sep=$a();$P($1.sep,0,$a([0,0,0,0]));$P($1.sep,$1.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$1.sepfinder();if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _1D=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_1D;bwipp_renmatrix();$$.rmoveto(1,1);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _1I=$k[--$j];$1[$k[--$j]]=_1I;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$1.linwidth=$1.sep.length;$k[$j++]=Infinity;for(var _1S=0,_1T=$1.ccpixx,_1R=$1.ccpixs.length-1;_1T<0?_1S>=_1R:_1S<=_1R;_1S+=_1T){$1.i=_1S;for(var _1U=0,_1V=2;_1U<_1V;_1U++){$k[$j++]=0;$q($G($1.ccpixs,$1.i,$1.ccpixx))}}$q($1.sep);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _1e=0,_1f=$1.linwidth,_1d=$1.linpixs.length-1;_1f<0?_1e>=_1d:_1e<=_1d;_1e+=_1f){$1.i=_1e;$q($G($1.linpixs,$1.i,$1.linwidth));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}$1.pixs=$a();$1.pixx=$f($1.ccpixx+1);$1.pixy=~~($1.pixs.length/$1.pixx);var _1u=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_1u;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databartruncatedcomposite(){var $1=Object.create(bwipp_databartruncatedcomposite.$ctx||(bwipp_databartruncatedcomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#28943";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databartruncated");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databartruncated();var _L=$k[--$j];$1.linsbs=$g(_L,"sbs");$1.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$1.usematrix){bwipp_renlinear()}else{$j--}$1.sepfinder=function(){$1.fp=$k[--$j];for(var _U=$1.fp,_T=$f($1.fp+12);_U<=_T;_U+=1){$1.i=_U;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _e=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_e}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}$1.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _j=0;_j<=12;_j+=1){var _p=$k[--$j];$k[$j++]=_p&&$eq($g($1.bot,$f(_j+$1.fp)),$g($1.f3,_j))}if($k[--$j]){$P($1.sep,$1.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _v=$k[--$j];var _w=$k[--$j];var _x=_w==1?0:1;$k[$j++]=_w;for(var _y=0,_z=_v;_y<_z;_y++){$k[$j++]=_x}});$as($a($m()-1));$1.bot=$k[--$j];$j-=2;$k[$j++]=Infinity;$F($1.bot,function(){var _14=$k[--$j];$k[$j++]=$f(1-_14)});$1.sep=$a();$P($1.sep,0,$a([0,0,0]));$P($1.sep,$1.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$1.sepfinder();$k[$j++]=64;$1.sepfinder();if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _1H=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_1H;bwipp_renmatrix();$$.rmoveto(-5,1);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _1M=$k[--$j];$1[$k[--$j]]=_1M;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _1T=$k[--$j];var _1U=$k[--$j];var _1V=_1U==0?1:0;$k[$j++]=_1U;for(var _1W=0,_1X=$i(_1T);_1W<_1X;_1W++){$k[$j++]=_1V}});$1.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($1.sep);$1.sep=$a();$1.linheight=~~$1.linheight;$k[$j++]=Infinity;for(var _1f=0,_1g=$1.ccpixx,_1e=$1.ccpixs.length-1;_1g<0?_1f>=_1e:_1f<=_1e;_1f+=_1g){$1.i=_1f;for(var _1h=0,_1i=2;_1h<_1i;_1h++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$k[$j++]=0}}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.sep);for(var _1p=0,_1q=$1.linheight;_1p<_1q;_1p++){$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.linpixs)}$1.pixs=$a();$1.pixx=$f($1.ccpixx+1);$1.pixy=~~($1.pixs.length/$1.pixx);var _22=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_22;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databarlimitedcomposite(){var $1=Object.create(bwipp_databarlimitedcomposite.$ctx||(bwipp_databarlimitedcomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29101";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databarlimited");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databarlimited();var _L=$k[--$j];$1.linsbs=$g(_L,"sbs");$1.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$1.usematrix){bwipp_renlinear()}else{$j--}$k[$j++]=Infinity;$k[$j++]=1;$F($1.linsbs,function(){var _R=$k[--$j];var _S=$k[--$j];var _T=_S==0?1:0;$k[$j++]=_S;for(var _U=0,_V=_R;_U<_V;_U++){$k[$j++]=_T}});$as($a($m()-1));$1.sep=$k[--$j];$j-=2;$P($1.sep,0,$a([0,0,0]));var _c=$1.sep;$P($1.sep,_c.length-9,$a([0,0,0,0,0,0,0,0,0]));if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _g=$1.sep;var _k=new Map([["ren",bwipp_renmatrix],["pixs",_g],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_k;bwipp_renmatrix();$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _n=$k[--$j];$$.rmoveto($f(72-$g(_n,"pixx")),1);$k[$j++]=_n;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _r=$k[--$j];$1[$k[--$j]]=_r;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _y=$k[--$j];var _z=$k[--$j];var _10=_z==0?1:0;$k[$j++]=_z;for(var _11=0,_12=$i(_y);_11<_12;_11++){$k[$j++]=_10}});$1.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($1.sep);$1.sep=$a();$1.linheight=~~$1.linheight;if($1.ccpixx==72){$k[$j++]=Infinity;for(var _1B=0,_1C=$1.ccpixx,_1A=$1.ccpixs.length-1;_1C<0?_1B>=_1A:_1B<=_1A;_1B+=_1C){$1.i=_1B;for(var _1D=0,_1E=2;_1D<_1E;_1D++){$k[$j++]=0;$q($G($1.ccpixs,$1.i,$1.ccpixx));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}}$q($1.sep);for(var _1L=0,_1M=$1.linheight;_1L<_1M;_1L++){$q($1.linpixs)}$1.pixs=$a();$1.pixx=$1.linpixs.length}else{$k[$j++]=Infinity;for(var _1T=0,_1U=$1.ccpixx,_1S=$1.ccpixs.length-1;_1U<0?_1T>=_1S:_1T<=_1S;_1T+=_1U){$1.i=_1T;for(var _1V=0,_1W=2;_1V<_1W;_1V++){$q($G($1.ccpixs,$1.i,$1.ccpixx));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.sep);for(var _1d=0,_1e=$1.linheight;_1d<_1e;_1d++){$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($1.linpixs)}$1.pixs=$a();$1.pixx=$f($1.ccpixx+6)}$1.pixy=~~($1.pixs.length/$1.pixx);var _1q=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_1q;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databarexpandedcomposite(){var $1=Object.create(bwipp_databarexpandedcomposite.$ctx||(bwipp_databarexpandedcomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29250";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databarexpanded");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databarexpanded();var _L=$k[--$j];$1.linsbs=$g(_L,"sbs");$1.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$1.usematrix){bwipp_renlinear()}else{$j--}$1.sepfinder=function(){$1.fp=$k[--$j];for(var _U=$1.fp,_T=$f($1.fp+12);_U<=_T;_U+=1){$1.i=_U;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _e=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_e}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}};$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _j=$k[--$j];var _k=$k[--$j];var _l=_k==1?0:1;$k[$j++]=_k;for(var _m=0,_n=_j;_m<_n;_m++){$k[$j++]=_l}});$as($a($m()-1));$1.bot=$k[--$j];$j-=2;$k[$j++]=Infinity;$F($1.bot,function(){var _s=$k[--$j];$k[$j++]=$f(1-_s)});$1.sep=$a();$P($1.sep,0,$a([0,0,0]));$P($1.sep,$1.sep.length-4,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _11=18,_10=$1.bot.length-13;_11<=_10;_11+=98){$k[$j++]=_11}for(var _14=69,_13=$1.bot.length-13;_14<=_13;_14+=98){$k[$j++]=_14}var _15=$a();for(var _16=0,_17=_15.length;_16<_17;_16++){$k[$j++]=$g(_15,_16);$1.sepfinder()}if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _1F=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_1F;bwipp_renmatrix();$$.rmoveto(1,1);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _1K=$k[--$j];$1[$k[--$j]]=_1K;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($1.linsbs,function(){var _1R=$k[--$j];var _1S=$k[--$j];var _1T=_1S==0?1:0;$k[$j++]=_1S;for(var _1U=0,_1V=$i(_1R);_1U<_1V;_1U++){$k[$j++]=_1T}});$1.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($1.sep);$1.sep=$a();$1.linheight=~~$1.linheight;$1.diff=$f($1.linpixs.length-$1.ccpixx);$k[$j++]=Infinity;for(var _1d=0,_1e=$f($1.diff-2);_1d<_1e;_1d++){$k[$j++]=0}$1.ccrpad=$a();$k[$j++]=Infinity;for(var _1j=0,_1k=$1.ccpixx,_1i=$1.ccpixs.length-1;_1k<0?_1j>=_1i:_1j<=_1i;_1j+=_1k){$1.i=_1j;for(var _1l=0,_1m=2;_1l<_1m;_1l++){$k[$j++]=0;$k[$j++]=0;$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}$q($1.sep);for(var _1u=0,_1v=$1.linheight;_1u<_1v;_1u++){$q($1.linpixs)}$1.pixs=$a();$1.pixx=$1.linpixs.length;$1.pixy=~~($1.pixs.length/$1.pixx);var _27=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_27;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_databarexpandedstackedcomposite(){var $1=Object.create(bwipp_databarexpandedstackedcomposite.$ctx||(bwipp_databarexpandedstackedcomposite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29407";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"lintype","databarexpandedstacked");$p($1.options,"linkage",true);$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _F=$s($1.linear.length+$1.comp.length);$P(_F,0,$1.linear);$P(_F,$1.linear.length,$1.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$1.linear;$k[$j++]=$1.options;bwipp_databarexpandedstacked();var _L=$k[--$j];$1.bot=$G($g(_L,"pixs"),0,$g(_L,"pixx"));$1.linheight=$g(_L,"pixy");$k[$j++]=_L;if(!$1.usematrix){bwipp_renmatrix()}else{$1.linpixs=$g($k[--$j],"pixs")}$1.sepfinder=function(){$1.fp=$k[--$j];for(var _X=$1.fp,_W=$f($1.fp+12);_X<=_W;_X+=1){$1.i=_X;if($g($1.bot,$1.i)==0){if($g($1.bot,$1.i-1)==1){$k[$j++]=1}else{var _h=$g($1.sep,$1.i-1)==0?1:0;$k[$j++]=_h}}else{$k[$j++]=0}$p($1.sep,$1.i,$k[--$j])}};$k[$j++]=Infinity;var _l=$1.bot;for(var _m=0,_n=_l.length;_m<_n;_m++){$k[$j++]=$f(1-$g(_l,_m))}$1.sep=$a();$P($1.sep,0,$a([0,0,0,0]));$P($1.sep,$1.sep.length-4,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _x=19,_w=$1.bot.length-13;_x<=_w;_x+=98){$k[$j++]=_x}for(var _10=70,_z=$1.bot.length-13;_10<=_z;_10+=98){$k[$j++]=_10}var _11=$a();for(var _12=0,_13=_11.length;_12<_13;_12++){$k[$j++]=$g(_11,_12);$1.sepfinder()}if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _1B=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_1B;bwipp_renmatrix();var _1E=$g($1.bot,0)==0?2:0;$$.rmoveto(_1E,1);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();var _1J=$k[--$j];$1[$k[--$j]]=_1J;$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$1.pixx=$1.sep.length;$k[$j++]=Infinity;for(var _1S=0,_1T=~~($f($f($1.pixx-$1.ccpixx)+1)/2);_1S<_1T;_1S++){$k[$j++]=0}$1.cclpad=$a();$k[$j++]=Infinity;for(var _1X=0,_1Y=~~($f($1.pixx-$1.ccpixx)/2);_1X<_1Y;_1X++){$k[$j++]=0}$1.ccrpad=$a();$k[$j++]=Infinity;for(var _1d=0,_1e=$1.ccpixx,_1c=$1.ccpixs.length-1;_1e<0?_1d>=_1c:_1d<=_1c;_1d+=_1e){$1.i=_1d;for(var _1f=0,_1g=2;_1f<_1g;_1f++){$q($1.cclpad);$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}$q($1.sep);$q($1.linpixs);$1.pixs=$a();$1.pixy=~~($1.pixs.length/$1.pixx);var _1y=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_1y;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_gs1_128composite(){var $1=Object.create(bwipp_gs1_128composite.$ctx||(bwipp_gs1_128composite.$ctx={}));$1.dontdraw=false;$1.usematrix=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if($1.dontdraw){$1.usematrix=true}$X($1.barcode,"|");if($k[--$j]){$1.linear=$k[--$j];$j--;$1.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29556";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$1.usematrix){$$.save()}$p($1.options,"inkspread","0");$p($1.options,"dontdraw",true);$p($1.options,"dontlint",true);var _D=$s($1.linear.length+$1.comp.length);$P(_D,0,$1.linear);$P(_D,$1.linear.length,$1.comp);$k[$j++]=_D;$k[$j++]="ai";bwipp_gs1process();$j-=3;$p($1.options,"linkagea",true);$k[$j++]=$1.linear;$k[$j++]=Infinity;$F($1.options);var _K=$d();$k[$j++]=_K;bwipp_gs1_128();var _M=$g($k[--$j],"sbs");$k[$j++]=0;$F(_M,function(){var _N=$k[--$j];var _O=$k[--$j];$k[$j++]=$f(_O+_N)});$1.linwidth=$k[--$j];$p($1.options,"lintype","gs1-128");$p($1.options,"linwidth",$1.linwidth);$k[$j++]=$1.comp;$k[$j++]=$1.options;bwipp_gs1_cc();$1.compsym=$k[--$j];if($g($1.compsym,"pixx")==99){$k[$j++]="a"}else{$k[$j++]="c"}$1.linktype=$k[--$j];if($eq($1.linktype,"a")){$p($1.options,"linkagea",true);$p($1.options,"linkagec",false)}else{$p($1.options,"linkagea",false);$p($1.options,"linkagec",true)}$k[$j++]=$1.linear;$k[$j++]=Infinity;$F($1.options);var _g=$d();$k[$j++]=_g;bwipp_gs1_128();var _h=$k[--$j];$1.linsbs=$g(_h,"sbs");$1.linheight=$g($g(_h,"bhs"),0)*72;$k[$j++]=_h;if(!$1.usematrix){bwipp_renlinear()}else{$j--}$k[$j++]=Infinity;$k[$j++]=1;$F($1.linsbs,function(){var _n=$k[--$j];var _o=$k[--$j];var _p=_o==0?1:0;$k[$j++]=_o;for(var _q=0,_r=_n;_q<_r;_q++){$k[$j++]=_p}});$as($a($m()-1));$1.sep=$k[--$j];$j-=2;if(!$1.usematrix){$$.rmoveto(0,$1.linheight);var _11=new Map([["ren",bwipp_renmatrix],["pixs",$1.sep],["pixx",$1.sep.length],["pixy",1],["height",1/72],["width",$1.sep.length/72],["opt",$1.options]]);$k[$j++]=_11;bwipp_renmatrix()}if($eq($1.linktype,"a")){$1.s=~~($f($1.linwidth-2)/11);$1.p=~~(($1.s-9)/2);$k[$j++]="x";$k[$j++]=($1.s-$1.p-1)*11+10;if($1.p==0){var _18=$k[--$j];$k[$j++]=$f(_18+2)}var _19=$k[--$j];$1[$k[--$j]]=$f(_19-99)}else{$1.x=-7}if(!$1.usematrix){$$.rmoveto($1.x,1);$k[$j++]=$1.compsym;bwipp_renmatrix();$$.restore()}else{$1.ccpixs=$g($1.compsym,"pixs");$1.ccpixx=$g($1.compsym,"pixx");$k[$j++]=Infinity;$F($1.linsbs,function(){var _1J=$k[--$j];var _1K=$k[--$j];var _1L=_1K==1?0:1;$k[$j++]=_1K;for(var _1M=0,_1N=_1J;_1M<_1N;_1M++){$k[$j++]=_1L}});$1.linpixs=$a();if($1.x>0){$k[$j++]=Infinity;for(var _1R=0,_1S=$1.x;_1R<_1S;_1R++){$k[$j++]=0}$1.cclpad=$a();$1.linlpad=$a(0)}else{$1.cclpad=$a(0);$k[$j++]=Infinity;for(var _1X=0,_1Y=-$1.x;_1X<_1Y;_1X++){$k[$j++]=0}$1.linlpad=$a()}$1.diff=$f($1.linwidth-$f($1.ccpixx+$1.x));if($1.diff>0){$k[$j++]=Infinity;for(var _1f=0,_1g=$1.diff;_1f<_1g;_1f++){$k[$j++]=0}$1.ccrpad=$a();$1.linrpad=$a(0)}else{$1.ccrpad=$a(0);$k[$j++]=Infinity;for(var _1l=0,_1m=-$1.diff;_1l<_1m;_1l++){$k[$j++]=0}$1.linrpad=$a()}$1.linheight=~~$1.linheight;var _1q=$eq($1.linktype,"a")?2:3;$1.ccrepeat=_1q;$k[$j++]=Infinity;for(var _1u=0,_1v=$1.ccpixx,_1t=$1.ccpixs.length-1;_1v<0?_1u>=_1t:_1u<=_1t;_1u+=_1v){$1.i=_1u;for(var _1x=0,_1y=$1.ccrepeat;_1x<_1y;_1x++){$q($1.cclpad);$q($G($1.ccpixs,$1.i,$1.ccpixx));$q($1.ccrpad)}}$q($1.linlpad);$q($1.sep);$q($1.linrpad);for(var _29=0,_2A=$1.linheight;_29<_2A;_29++){$q($1.linlpad);$q($1.linpixs);$q($1.linrpad)}$1.pixs=$a();$1.pixx=$f($f($1.cclpad.length+$1.ccpixx)+$1.ccrpad.length);$1.pixy=~~($1.pixs.length/$1.pixx);var _2Q=new Map([["ren",bwipp_renmatrix],["pixs",$1.pixs],["pixx",$1.pixx],["pixy",$1.pixy],["height",$1.pixy/72],["width",$1.pixx/72],["opt",$1.options]]);$k[$j++]=_2Q;if(!$1.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}}function bwipp_gs1datamatrix(){var $1=Object.create(bwipp_gs1datamatrix.$ctx||(bwipp_gs1datamatrix.$ctx={}));$1.dontdraw=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$1.gssep=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];$1.fnc1=-1;$1.dmtx=$a([$1.fnc1]);for(var _A=0,_9=$1.ais.length-1;_A<=_9;_A+=1){$1.i=_A;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _K=$a($1.dmtx.length+$1.ai.length+$1.val.length);$P(_K,0,$1.dmtx);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$1.dmtx.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _O=$k[--$j];var _P=$k[--$j];$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[--$j];$k[$j++]=_T;$k[$j++]=_T;$k[$j++]=$1.dmtx.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _X=$k[--$j];var _Y=$k[--$j];$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$1.dmtx=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _j=$a($1.dmtx.length+1);$P(_j,0,$1.dmtx);$k[$j++]=_j;$k[$j++]=_j;$k[$j++]=$1.dmtx.length;if($1.gssep){$k[$j++]=29}else{$k[$j++]=$1.fnc1}var _o=$k[--$j];var _p=$k[--$j];$p($k[--$j],_p,_o);$1.dmtx=$k[--$j]}}$1.barcode=$s(($1.dmtx.length+1)*5);$1.i=0;$1.j=0;for(;;){if($1.i==$1.dmtx.length){break}var _y=$g($1.dmtx,$1.i);$k[$j++]=_y;if(_y==$1.fnc1){$j--;$P($1.barcode,$1.j,"^FNC1");$1.j=$1.j+4}else{$p($1.barcode,$1.j,$k[--$j])}$1.i=$1.i+1;$1.j=$1.j+1}$1.barcode=$G($1.barcode,0,$1.j);delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _1G=$k[--$j];$1[$k[--$j]]=_1G;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1datamatrixrectangular(){var $1=Object.create(bwipp_gs1datamatrixrectangular.$ctx||(bwipp_gs1datamatrixrectangular.$ctx={}));$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$1.dontdraw=false;$1.gssep=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];$1.fnc1=-1;$1.dmtx=$a([$1.fnc1]);for(var _A=0,_9=$1.ais.length-1;_A<=_9;_A+=1){$1.i=_A;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _K=$a($1.dmtx.length+$1.ai.length+$1.val.length);$P(_K,0,$1.dmtx);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$1.dmtx.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _O=$k[--$j];var _P=$k[--$j];$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[--$j];$k[$j++]=_T;$k[$j++]=_T;$k[$j++]=$1.dmtx.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _X=$k[--$j];var _Y=$k[--$j];$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$1.dmtx=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _j=$a($1.dmtx.length+1);$P(_j,0,$1.dmtx);$k[$j++]=_j;$k[$j++]=_j;$k[$j++]=$1.dmtx.length;if($1.gssep){$k[$j++]=29}else{$k[$j++]=$1.fnc1}var _o=$k[--$j];var _p=$k[--$j];$p($k[--$j],_p,_o);$1.dmtx=$k[--$j]}}$1.barcode=$s(($1.dmtx.length+1)*5);$1.i=0;$1.j=0;for(;;){if($1.i==$1.dmtx.length){break}var _y=$g($1.dmtx,$1.i);$k[$j++]=_y;if(_y==$1.fnc1){$j--;$P($1.barcode,$1.j,"^FNC1");$1.j=$1.j+4}else{$p($1.barcode,$1.j,$k[--$j])}$1.i=$1.i+1;$1.j=$1.j+1}$1.barcode=$G($1.barcode,0,$1.j);delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$p($1.options,"format","rectangle");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _1H=$k[--$j];$1[$k[--$j]]=_1H;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1dldatamatrix(){var $1=Object.create(bwipp_gs1dldatamatrix.$ctx||(bwipp_gs1dldatamatrix.$ctx={}));$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];$1[$k[--$j]]=_6;$k[$j++]=$1.barcode;$k[$j++]="dl";bwipp_gs1process();$j-=3;delete $1.options["parse"];$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _D=$k[--$j];$1[$k[--$j]]=_D;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1qrcode(){var $1=Object.create(bwipp_gs1qrcode.$ctx||(bwipp_gs1qrcode.$ctx={}));$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];$1.fnc1=-1;$1.qrc=$a([$1.fnc1]);for(var _A=0,_9=$1.ais.length-1;_A<=_9;_A+=1){$1.i=_A;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _K=$a($1.qrc.length+$1.ai.length+$1.val.length);$P(_K,0,$1.qrc);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$1.qrc.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _O=$k[--$j];var _P=$k[--$j];$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[--$j];$k[$j++]=_T;$k[$j++]=_T;$k[$j++]=$1.qrc.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _X=$k[--$j];var _Y=$k[--$j];$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$1.qrc=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _j=$a($1.qrc.length+1);$P(_j,0,$1.qrc);$p(_j,$1.qrc.length,$1.fnc1);$1.qrc=_j}}$1.barcode=$s(($1.qrc.length+1)*5);$1.i=0;$1.j=0;for(;;){if($1.i==$1.qrc.length){break}var _t=$g($1.qrc,$1.i);$k[$j++]=_t;if(_t==$1.fnc1){$j--;$P($1.barcode,$1.j,"^FNC1");$1.j=$1.j+4}else{$p($1.barcode,$1.j,$k[--$j])}$1.i=$1.i+1;$1.j=$1.j+1}$1.barcode=$G($1.barcode,0,$1.j);delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_qrcode();var _1B=$k[--$j];$1[$k[--$j]]=_1B;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1dlqrcode(){var $1=Object.create(bwipp_gs1dlqrcode.$ctx||(bwipp_gs1dlqrcode.$ctx={}));$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$1.dontdraw=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];var _3=new Map([["parse",$1.parse],["parseonly",true],["parsefnc",false]]);$1.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$1.barcode;$k[$j++]=$1.fncvals;bwipp_parseinput();var _6=$k[--$j];$1[$k[--$j]]=_6;$k[$j++]=$1.barcode;$k[$j++]="dl";bwipp_gs1process();$j-=3;delete $1.options["parse"];$p($1.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_qrcode();var _D=$k[--$j];$1[$k[--$j]]=_D;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_gs1dotcode(){var $1=Object.create(bwipp_gs1dotcode.$ctx||(bwipp_gs1dotcode.$ctx={}));$1.dontdraw=false;$1.parse=false;$1.dontlint=false;$1.lintreqs=true;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];$k[$j++]=$1.barcode;$k[$j++]="ai";bwipp_gs1process();$1.fncs=$k[--$j];$1.vals=$k[--$j];$1.ais=$k[--$j];$1.fnc1=-1;$1.dmtx=$a([$1.fnc1]);for(var _A=0,_9=$1.ais.length-1;_A<=_9;_A+=1){$1.i=_A;$1.ai=$g($1.ais,$1.i);$1.val=$g($1.vals,$1.i);var _K=$a($1.dmtx.length+$1.ai.length+$1.val.length);$P(_K,0,$1.dmtx);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$1.dmtx.length;$k[$j++]=$1.ai;$k[$j++]=Infinity;var _O=$k[--$j];var _P=$k[--$j];$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[--$j];$k[$j++]=_T;$k[$j++]=_T;$k[$j++]=$1.dmtx.length+$1.ai.length;$k[$j++]=$1.val;$k[$j++]=Infinity;var _X=$k[--$j];var _Y=$k[--$j];$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$1.dmtx=$k[--$j];if($1.i!=$1.ais.length-1&&$g($1.fncs,$1.i)){var _j=$a($1.dmtx.length+1);$P(_j,0,$1.dmtx);$p(_j,$1.dmtx.length,$1.fnc1);$1.dmtx=_j}}$1.barcode=$s(($1.dmtx.length+1)*5);$1.i=0;$1.j=0;for(;;){if($1.i==$1.dmtx.length){break}var _t=$g($1.dmtx,$1.i);$k[$j++]=_t;if(_t==$1.fnc1){$j--;$P($1.barcode,$1.j,"^FNC1");$1.j=$1.j+4}else{$p($1.barcode,$1.j,$k[--$j])}$1.i=$1.i+1;$1.j=$1.j+1}$1.barcode=$G($1.barcode,0,$1.j);delete $1.options["parse"];$p($1.options,"dontdraw",true);$p($1.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_dotcode();var _1B=$k[--$j];$1[$k[--$j]]=_1B;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibccode39(){var $1=Object.create(bwipp_hibccode39.$ctx||(bwipp_hibccode39.$ctx={}));$1.dontdraw=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.textxoffset=0;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibccode39.__30222__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibccode39.$ctx[id]=$ctx[id]);bwipp_hibccode39.__30222__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibccode39badCharacter#30227";$k[$j++]="HIBC Code 39 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibccode39badCheckDigit#30241";$k[$j++]="Incorrect HIBC Code 39 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$1.text=$s($f($1.barlen+4));$p($1.text,0,42);$P($1.text,1,$1.barcode);var _u=$g($1.barcode,$f($1.barlen+1));$k[$j++]=$1.text;$k[$j++]=$f($1.barlen+2);$k[$j++]=_u;if(_u==32){$j--;$k[$j++]=95}var _v=$k[--$j];var _w=$k[--$j];$p($k[--$j],_w,_v);$p($1.text,$f($1.barlen+3),42);$p($1.options,"dontdraw",true);$p($1.options,"includecheck",false);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code39();var _15=$k[--$j];$1[$k[--$j]]=_15;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_hibccode128(){var $1=Object.create(bwipp_hibccode128.$ctx||(bwipp_hibccode128.$ctx={}));$1.dontdraw=false;$1.textfont="OCR-B";$1.textsize=10;$1.textyoffset=-8;$1.textxoffset=0;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibccode128.__30322__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibccode128.$ctx[id]=$ctx[id]);bwipp_hibccode128.__30322__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibccode128badCharacter#30327";$k[$j++]="HIBC Code 128 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibccode128badCheckDigit#30341";$k[$j++]="Incorrect HIBC Code 128 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$1.text=$s($f($1.barlen+4));$p($1.text,0,42);$P($1.text,1,$1.barcode);var _u=$g($1.barcode,$f($1.barlen+1));$k[$j++]=$1.text;$k[$j++]=$f($1.barlen+2);$k[$j++]=_u;if(_u==32){$j--;$k[$j++]=95}var _v=$k[--$j];var _w=$k[--$j];$p($k[--$j],_w,_v);$p($1.text,$f($1.barlen+3),42);$p($1.options,"dontdraw",true);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_code128();var _14=$k[--$j];$1[$k[--$j]]=_14;$p($1.args,"txt",$a([$a([$1.text,$1.textxoffset,$1.textyoffset,$1.textfont,$1.textsize])]));$p($1.args,"textxalign","center");$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_hibcdatamatrix(){var $1=Object.create(bwipp_hibcdatamatrix.$ctx||(bwipp_hibcdatamatrix.$ctx={}));$1.dontdraw=false;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibcdatamatrix.__30417__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibcdatamatrix.$ctx[id]=$ctx[id]);bwipp_hibcdatamatrix.__30417__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibcdatamatrixBadCharacter#30422";$k[$j++]="HIBC Data Matrix must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibcdatamatrixBadCheckDigit#30436";$k[$j++]="Incorrect HIBC Data Matrix check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _p=$k[--$j];$1[$k[--$j]]=_p;var _r=$1.args;$p(_r,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibcdatamatrixrectangular(){var $1=Object.create(bwipp_hibcdatamatrixrectangular.$ctx||(bwipp_hibcdatamatrixrectangular.$ctx={}));$1.dontdraw=false;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibcdatamatrixrectangular.__30504__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibcdatamatrixrectangular.$ctx[id]=$ctx[id]);bwipp_hibcdatamatrixrectangular.__30504__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibcdatamatrixrectangularBadCharacter#30509";$k[$j++]="HIBC Data Matrix Rectangular must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibcdatamatrixrectangularBadCheckDigit#30523";$k[$j++]="Incorrect HIBC Data Matrix Rectangular check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);$p($1.options,"validatecheck",false);$p($1.options,"format","rectangle");$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_datamatrix();var _q=$k[--$j];var _r=$k[--$j];$1[_r]=_q;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibcpdf417(){var $1=Object.create(bwipp_hibcpdf417.$ctx||(bwipp_hibcpdf417.$ctx={}));$1.dontdraw=false;$1.columns=2;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibcpdf417.__30593__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibcpdf417.$ctx[id]=$ctx[id]);bwipp_hibcpdf417.__30593__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibcpdf417BadCharacter#30598";$k[$j++]="HIBC PDF417 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibcpdf417BadCheckDigit#30612";$k[$j++]="Incorrect HIBC PDF417 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);$p($1.options,"columns",$1.columns);$p($1.options,"validatecheck",false);var _p=$1.barcode;$k[$j++]="args";$k[$j++]=_p;$k[$j++]=$1.options;bwipp_pdf417();var _r=$k[--$j];$1[$k[--$j]]=_r;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibcmicropdf417(){var $1=Object.create(bwipp_hibcmicropdf417.$ctx||(bwipp_hibcmicropdf417.$ctx={}));$1.dontdraw=false;$1.columns=2;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibcmicropdf417.__30682__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibcmicropdf417.$ctx[id]=$ctx[id]);bwipp_hibcmicropdf417.__30682__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibcmicropdf417BadCharacter#30687";$k[$j++]="HIBC MicroPDF417 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibcmicropdf417BadCheckDigit#30701";$k[$j++]="Incorrect HIBC MicroPDF417 check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);var _m=$1.options;$p(_m,"columns",$1.columns);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_micropdf417();var _r=$k[--$j];$1[$k[--$j]]=_r;$p($1.args,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibcqrcode(){var $1=Object.create(bwipp_hibcqrcode.$ctx||(bwipp_hibcqrcode.$ctx={}));$1.dontdraw=false;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibcqrcode.__30770__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibcqrcode.$ctx[id]=$ctx[id]);bwipp_hibcqrcode.__30770__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibcqrcodeBadCharacter#30775";$k[$j++]="HIBC QR Code must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibcqrcodeBadCheckDigit#30789";$k[$j++]="Incorrect HIBC QR Code check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_qrcode();var _p=$k[--$j];$1[$k[--$j]]=_p;var _r=$1.args;$p(_r,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibccodablockf(){var $1=Object.create(bwipp_hibccodablockf.$ctx||(bwipp_hibccodablockf.$ctx={}));$1.dontdraw=false;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibccodablockf.__30857__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibccodablockf.$ctx[id]=$ctx[id]);bwipp_hibccodablockf.__30857__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.codablockfBadCharacter#30862";$k[$j++]="HIBC Codablock F must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibccodablockfBadCheckDigit#30876";$k[$j++]="Incorrect HIBC Codablock F check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _c=$1.barlen;var _d=$s($f(_c+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_codablockf();var _p=$k[--$j];$1[$k[--$j]]=_p;var _r=$1.args;$p(_r,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_hibcazteccode(){var $1=Object.create(bwipp_hibcazteccode.$ctx||(bwipp_hibcazteccode.$ctx={}));$1.dontdraw=false;$1.validatecheck=false;$k[$j++]=$1;bwipp_processoptions();$1.options=$k[--$j];$1.barcode=$k[--$j];if(!bwipp_hibcazteccode.__30944__){(function(){var $ctx=Object.create($1);$ctx.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$ctx.charvals=new Map;for(var _2=0;_2<=42;_2+=1){$p($ctx.charvals,$G($ctx.barchars,_2,1),_2)}for(var id in $ctx)$ctx.hasOwnProperty(id)&&(bwipp_hibcazteccode.$ctx[id]=$ctx[id]);bwipp_hibcazteccode.__30944__=1})()}for(var _9=0,_8=$1.barcode.length-1;_9<=_8;_9+=1){var _D=$g($1.charvals,$G($1.barcode,_9,1))!==undefined;if(!_D){$k[$j++]="bwipp.hibcazteccodeBadCharacter#30949";$k[$j++]="HIBC Aztec Code must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$1.barcode.length;if($1.validatecheck){var _G=$k[--$j];$k[$j++]=$f(_G-1)}var _H=$k[--$j];$1[$k[--$j]]=_H;$1.checksum=41;for(var _L=0,_K=$f($1.barlen-1);_L<=_K;_L+=1){$1.checksum=$f($g($1.charvals,$G($1.barcode,_L,1))+$1.checksum)}$1.checksum=$1.checksum%43;if($1.validatecheck){if($g($1.barcode,$1.barlen)!=$g($1.barchars,$1.checksum)){$k[$j++]="bwipp.hibcazteccodeBadCheckDigit#30963";$k[$j++]="Incorrect HIBC Aztec Code check digit provided";bwipp_raiseerror()}$1.barcode=$G($1.barcode,0,$1.barlen)}var _d=$s($f($1.barlen+2));$P(_d,1,$1.barcode);$1.barcode=_d;$p($1.barcode,0,43);$p($1.barcode,$f($1.barlen+1),$g($1.barchars,$1.checksum));$p($1.options,"dontdraw",true);$p($1.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$1.barcode;$k[$j++]=$1.options;bwipp_azteccode();var _p=$k[--$j];$1[$k[--$j]]=_p;var _r=$1.args;$p(_r,"opt",$1.options);$k[$j++]=$1.args;if(!$1.dontdraw){bwipp_renmatrix()}}function bwipp_channelcode(){var $1=Object.create(bwipp_channelcode.$ctx||(bwipp_channelcode.$ctx={}));$1.options=$k[--$j];$1.barcode=$k[--$j];$1.dontdraw=false;$1.shortfinder=false;$1.includetext=false;$1.includecheck=false;$1.height=1;$F($1.options,function(){var _3=$k[--$j];$1[$k[--$j]]=_3});$1.height=+$1.height;if($1.barcode.length<2||$1.barcode.length>7){$k[$j++]="bwipp.channelcodeBadLength#31038";$k[$j++]="Channel Code must be 2 to 7 digits";bwipp_raiseerror()}$F($1.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.channelcodeBadCharacter#31042";$k[$j++]="Channel Code must contain only digits";bwipp_raiseerror()}});if($i($1.barcode)>$g($a([26,292,3493,44072,576688,7742862]),$1.barcode.length-2)){$k[$j++]="bwipp.channelcodeTooBig#31046";$k[$j++]="The Channel Code value is too big for the number of channels";bwipp_raiseerror()}$1.nextb=function(){var _E=$k[--$j];var _N=$f($g($1.s,_E)+$f($g($1.b,$f(_E-1))+$f($g($1.b,$f(_E-2))+$g($1.s,$f(_E-1)))))>4?1:2;$k[$j++]=_E;$k[$j++]=_N;if(_E<$f($1.chan+2)){var _P=$k[--$j];var _Q=$k[--$j];var _R=$k[--$j];$k[$j++]=_R;$k[$j++]=_Q;$k[$j++]=_P;for(var _T=_P,_S=_R;_T<=_S;_T+=1){var _V=$k[--$j];var _W=$k[--$j];$p($1.b,_W,_T);var _X=$k[--$j];var _Y=$k[--$j];$k[$j++]=_Y;$k[$j++]=_X;$k[$j++]=_W;$k[$j++]=_V;$k[$j++]=$f($f(_X-_T)+1);$k[$j++]=_Y;$k[$j++]=$f(_W+1);$1.nexts()}}else{var _Z=$k[--$j];var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=_b;$k[$j++]=_a;$k[$j++]=_Z;if($le(_Z,_b)){var _d=$k[--$j];var _e=$k[--$j];var _f=$k[--$j];$p($1.b,_e,_f);$k[$j++]=_f;$k[$j++]=_e;$k[$j++]=_d;if($1.value==$1.target){$k[$j++]=Infinity;for(var _i=3;_i<=10;_i+=1){$k[$j++]=$g($1.s,_i);$k[$j++]=$g($1.b,_i)}$1.out=$G($a(),0,$1.chan*2)}$1.value=$1.value+1}}$j-=4};$1.nexts=function(){var _r=$k[--$j];$k[$j++]=_r;if(_r<$f($1.chan+2)){$k[$j++]=1}else{var _t=$k[--$j];var _u=$k[--$j];$k[$j++]=_u;$k[$j++]=_t;$k[$j++]=_u}var _v=$k[--$j];var _w=$k[--$j];var _x=$k[--$j];$k[$j++]=_x;$k[$j++]=_w;for(var _z=_v,_y=_x;_z<=_y;_z+=1){var _11=$k[--$j];$p($1.s,_11,_z);var _12=$k[--$j];var _13=$k[--$j];$k[$j++]=_13;$k[$j++]=_12;$k[$j++]=_11;$k[$j++]=$f($f(_12-_z)+1);$k[$j++]=_13;$k[$j++]=_11;$1.nextb()}$j-=3};$1.encode=function(){$1.chan=$k[--$j];$1.target=$k[--$j];$1.value=0;$1.out=-1;$1.b=$a([1,1,1,0,0,0,0,0,0,0,0]);$1.s=$a([0,1,1,0,0,0,0,0,0,0,0]);var _18=$1.chan;$k[$j++]=_18;$k[$j++]=_18;$k[$j++]=3;$1.nexts();$k[$j++]=$1.out};$1.barlen=$1.barcode.length;$k[$j++]="finder";if($1.shortfinder){$k[$j++]=$a([1,1,1,1,1])}else{$k[$j++]=$a([1,1,1,1,1,1,1,1,1])}var _1E=$k[--$j];$1[$k[--$j]]=_1E;$k[$j++]="data";$k[$j++]=$i($1.barcode);$k[$j++]=$1.barlen+1;$1.encode();var _1I=$k[--$j];$1[$k[--$j]]=_1I;$1.check=$a([]);if($1.includecheck){$1.mod23=$g($a([$a([]),$a([]),$a([13,12,4,9,3,1]),$a([13,2,12,3,18,16,4,1]),$a([11,16,17,8,20,4,10,2,5,1]),$a([1,4,16,18,3,12,2,8,9,13,6,1]),$a([20,16,22,13,15,12,5,4,8,9,21,3,7,1]),$a([2,6,18,8,1,3,9,4,12,13,16,2,6,18,8,1])]),$1.barlen);$k[$j++]=0;for(var _1Z=0,_1Y=$1.data.length-1;_1Z<=_1Y;_1Z+=1){var _1e=$k[--$j];$k[$j++]=$f(_1e+$f($g($1.data,_1Z)-1)*$g($1.mod23,_1Z))}var _1f=$k[--$j];$k[$j++]=_1f%23;$k[$j++]=3;$1.encode();$1.check=$k[--$j]}$k[$j++]=Infinity;$q($1.finder);$q($1.data);$q($1.check);$1.sbs=$a();$1.txt=$a($1.barlen);for(var _1p=0,_1o=$1.barlen-1;_1p<=_1o;_1p+=1){$1.i=_1p;$p($1.txt,$1.i,$a([$G($1.barcode,$1.i,1),0,0,"",0]))}$k[$j++]=Infinity;var _1w=$1.sbs;$k[$j++]=Infinity;for(var _1y=0,_1z=~~(($1.sbs.length+1)/2);_1y<_1z;_1y++){$k[$j++]=$1.height}var _21=$a();$k[$j++]=Infinity;for(var _23=0,_24=~~(($1.sbs.length+1)/2);_23<_24;_23++){$k[$j++]=0}var _25=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_1w;$k[$j++]="bhs";$k[$j++]=_21;$k[$j++]="bbs";$k[$j++]=_25;$k[$j++]="txt";$k[$j++]=$1.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$1.options;var _28=$d();$k[$j++]=_28;if(!$1.dontdraw){bwipp_renlinear()}}function bwipp_renlinear(){if($0.bwipjs_dontdraw){return}var $1=Object.create(bwipp_renlinear.$ctx||(bwipp_renlinear.$ctx={}));$1.args=$k[--$j];$1.sbs=$a([]);$1.bhs=$a([]);$1.bbs=$a([]);$1.txt=$a([]);$1.barcolor="unset";$1.includetext=false;$1.textcolor="unset";$1.textxalign="unset";$1.textyalign="unset";$1.textfont="OCR-B";$1.textsize=10;$1.textxoffset=0;$1.textyoffset=0;$1.textgaps=0;$1.alttext="";$1.bordercolor="unset";$1.backgroundcolor="unset";$1.inkspread=0;$1.width=0;$1.barratio=1;$1.spaceratio=1;$1.showborder=false;$1.borderleft=10;$1.borderright=10;$1.bordertop=1;$1.borderbottom=1;$1.borderwidth=.5;$1.guardwhitespace=false;$1.guardleftpos=0;$1.guardleftypos=0;$1.guardrightpos=0;$1.guardrightypos=0;$1.guardwidth=7;$1.guardheight=7;$F($1.args,function(){var _7=$k[--$j];$1[$k[--$j]]=_7});var _9=$1.opt;for(var _E=_9.size,_D=_9.keys(),_C=0;_C<_E;_C++){var _A=_D.next().value;$1[_A]=_9.get(_A)}$1.barcolor=""+$1.barcolor;$1.textcolor=""+$1.textcolor;$1.textxalign=""+$1.textxalign;$1.textyalign=""+$1.textyalign;$1.textfont=""+$1.textfont;$1.textsize=+$1.textsize;$1.textxoffset=+$1.textxoffset;$1.textyoffset=+$1.textyoffset;$1.textgaps=+$1.textgaps;$1.alttext=""+$1.alttext;$1.bordercolor=""+$1.bordercolor;$1.backgroundcolor=""+$1.backgroundcolor;$1.inkspread=+$1.inkspread;$1.width=+$1.width;$1.barratio=+$1.barratio;$1.spaceratio=+$1.spaceratio;$1.borderleft=+$1.borderleft;$1.borderright=+$1.borderright;$1.bordertop=+$1.bordertop;$1.borderbottom=+$1.borderbottom;$1.borderwidth=+$1.borderwidth;$1.guardleftpos=+$1.guardleftpos;$1.guardleftypos=+$1.guardleftypos;$1.guardrightpos=+$1.guardrightpos;$1.guardrightypos=+$1.guardrightypos;$1.guardwidth=+$1.guardwidth;$1.guardheight=+$1.guardheight;$1.bars=$a(~~(($1.sbs.length+1)/2));$1.x=0;$1.maxh=0;for(var _k=0,_j=~~(($1.sbs.length+1)/2)*2-2;_k<=_j;_k+=1){$1.i=_k;if($1.i%2==0){$1.d=$f($f($g($1.sbs,$1.i)*$1.barratio-$1.barratio)+1);if($g($1.sbs,$1.i)!=0){$1.h=$g($1.bhs,~~($1.i/2))*72;$1.c=$f($1.d/2+$1.x);$1.y=$g($1.bbs,~~($1.i/2))*72;$1.w=$f($1.d-$1.inkspread);$p($1.bars,~~($1.i/2),$a([$1.h,$1.c,$1.y,$1.w]));if($f($1.h+$1.y)>$1.maxh){$1.maxh=$f($1.h+$1.y)}}else{$p($1.bars,~~($1.i/2),-1)}}else{$1.d=$f($f($g($1.sbs,$1.i)*$1.spaceratio-$1.spaceratio)+1)}$1.x=$f($1.x+$1.d)}$$.save();var _1P=$$.currpos();$$.translate(_1P.x,_1P.y);if($1.width!=0){$$.scale($1.width*72/$1.x,1)}$$.newpath();$$.moveto(-$1.borderleft,-$1.borderbottom);$$.rlineto($f($f($1.x+$1.borderleft)+$1.borderright),0);$$.rlineto(0,$f($f($1.maxh+$1.borderbottom)+$1.bordertop));$$.rlineto(-$f($f($1.x+$1.borderleft)+$1.borderright),0);$$.rlineto(0,-$f($f($1.maxh+$1.borderbottom)+$1.bordertop));$$.closepath();if($1.showborder){$$.save();if($ne($1.bordercolor,"unset")){$$.setcolor($1.bordercolor)}$$.setlinewidth($1.borderwidth);$$.stroke();$$.restore()}$$.save();if($ne($1.barcolor,"unset")){$$.setcolor($1.barcolor)}var _1n=$1.bars;for(var _1o=0,_1p=_1n.length;_1o<_1p;_1o++){var _1q=$g(_1n,_1o);$k[$j++]=_1q;if(_1q!=-1){$q($k[--$j]);$$.newpath();$$.setlinewidth($k[--$j]);var _1t=$k[--$j];$$.moveto($k[--$j],_1t);$$.rlineto(0,$k[--$j]);$$.stroke()}else{$j--}}$$.restore();if($ne($1.textcolor,"unset")){$$.setcolor($1.textcolor)}if($1.includetext){if($eq($1.textxalign,"unset")&&$eq($1.textyalign,"unset")&&$eq($1.alttext,"")){$1.s=0;$1.fn="";var _22=$1.txt;for(var _23=0,_24=_22.length;_23<_24;_23++){$F($g(_22,_23));var _26=$k[--$j];var _27=$k[--$j];$k[$j++]=_27;$k[$j++]=_26;if(_26!=$1.s||$ne(_27,$1.fn)){var _2A=$k[--$j];var _2B=$k[--$j];$1.s=_2A;$1.fn=_2B;$$.selectfont(_2B,_2A)}else{$j-=2}var _2C=$k[--$j];$$.moveto($k[--$j],_2C);$$.show($k[--$j],0,0)}}else{$$.selectfont($1.textfont,$1.textsize);if($eq($1.alttext,"")){$k[$j++]=Infinity;var _2I=$1.txt;for(var _2J=0,_2K=_2I.length;_2J<_2K;_2J++){$F($g($g(_2I,_2J),0))}$1.txt=$a();$1.tstr=$s($1.txt.length);for(var _2S=0,_2R=$1.txt.length-1;_2S<=_2R;_2S+=1){$p($1.tstr,_2S,$g($1.txt,_2S))}}else{$1.tstr=$1.alttext}if($1.tstr.length==0){$k[$j++]=0}else{$$.save();$$.newpath();$$.moveto(0,0);$$.charpath("0",false);var _2Y=$$.pathbbox();$$.restore();$k[$j++]=_2Y.ury}$1.textascent=$k[--$j];var _2b=$$.stringwidth($1.tstr);$1.textwidth=$f(_2b.w+($1.tstr.length-1)*$1.textgaps);$1.textxpos=$f($1.textxoffset+$f($1.x-$1.textwidth)/2);if($eq($1.textxalign,"left")){$1.textxpos=$1.textxoffset}if($eq($1.textxalign,"right")){$1.textxpos=$f($f($1.x-$1.textxoffset)-$1.textwidth)}if($eq($1.textxalign,"offleft")){$1.textxpos=-$f($1.textwidth+$1.textxoffset)}if($eq($1.textxalign,"offright")){$1.textxpos=$f($1.x+$1.textxoffset)}if($eq($1.textxalign,"justify")&&$1.textwidth<$1.x){$1.textxpos=0;$1.textgaps=$f($1.x-$1.textwidth)/($1.tstr.length-1)}$1.textypos=-$f($f($1.textyoffset+$1.textascent)+1);if($eq($1.textyalign,"above")){$1.textypos=$f($f($1.textyoffset+$1.maxh)+1)}if($eq($1.textyalign,"center")){$1.textypos=$f($1.textyoffset+$f($1.maxh-$1.textascent)/2)}$$.moveto($1.textxpos,$1.textypos);$$.show($1.tstr,$1.textgaps,0)}}if($1.guardwhitespace){$$.selectfont("OCR-B",$1.guardheight*2);if($1.guardleftpos!=0){$$.moveto($f(-$1.guardleftpos-1),$f($f($1.guardleftypos-$1.guardheight/2)-1.5));$$.show("<",0,0)}if($1.guardrightpos!=0){$$.moveto($f($f($f($1.guardrightpos+$1.x)-$1.guardwidth)+1),$f($f($1.guardrightypos-$1.guardheight/2)-1.5));$$.show(">",0,0)}}$$.restore()}function bwipp_renmaximatrix(){if($0.bwipjs_dontdraw){return}var $1=Object.create(bwipp_renmaximatrix.$ctx||(bwipp_renmaximatrix.$ctx={}));$1.args=$k[--$j];$1.barcolor="unset";$1.backgroundcolor="unset";$F($1.args,function(){var _3=$k[--$j];$1[$k[--$j]]=_3});var _5=$1.opt;for(var _A=_5.size,_9=_5.keys(),_8=0;_8<_A;_8++){var _6=_9.next().value;$1[_6]=_5.get(_6)}$1.barcolor=""+$1.barcolor;$1.backgroundcolor=""+$1.backgroundcolor;$$.save();if($ne($1.barcolor,"unset")){$$.setcolor($1.barcolor)}$$.maxicode($1.pixs);$$.restore()}function bwipp_encode(bwipjs,encoder,text,opts,dontdraw){if(typeof text!=="string"){throw new Error("bwipp.typeError: barcode text not a string ("+text+")")}opts=opts||{};if(typeof opts==="string"){var tmp=opts.split(" ");opts={};for(var i=0;i<tmp.length;i++){if(!tmp[i]){continue}var eq=tmp[i].indexOf("=");if(eq==-1){opts[tmp[i]]=true}else{opts[tmp[i].substr(0,eq)]=tmp[i].substr(eq+1)}}}else if(typeof opts!=="object"||opts.constructor!==Object){throw new Error("bwipp.typeError: options not an object")}if(/[\u0100-\uffff]/.test(text)){text=unescape(encodeURIComponent(text))}$0.bwipjs_dontdraw=opts.dontdraw||dontdraw||false;var map=new Map;for(var id in opts){if(opts.hasOwnProperty(id)){map.set(id,opts[id])}}$$=bwipjs;$k=[text,map];$j=2;encoder();if($j){return $k.splice(0,$j)}return true}function bwipp_lookup(symbol){if(!symbol){throw new Error("bwipp.undefinedEncoder: bcid is not defined")}switch(symbol.replace(/-/g,"_")){case"auspost":return bwipp_auspost;case"azteccode":return bwipp_azteccode;case"azteccodecompact":return bwipp_azteccodecompact;case"aztecrune":return bwipp_aztecrune;case"bc412":return bwipp_bc412;case"channelcode":return bwipp_channelcode;case"codablockf":return bwipp_codablockf;case"code11":return bwipp_code11;case"code128":return bwipp_code128;case"code16k":return bwipp_code16k;case"code2of5":return bwipp_code2of5;case"code32":return bwipp_code32;case"code39":return bwipp_code39;case"code39ext":return bwipp_code39ext;case"code49":return bwipp_code49;case"code93":return bwipp_code93;case"code93ext":return bwipp_code93ext;case"codeone":return bwipp_codeone;case"coop2of5":return bwipp_coop2of5;case"daft":return bwipp_daft;case"databarexpanded":return bwipp_databarexpanded;case"databarexpandedcomposite":return bwipp_databarexpandedcomposite;case"databarexpandedstacked":return bwipp_databarexpandedstacked;case"databarexpandedstackedcomposite":return bwipp_databarexpandedstackedcomposite;case"databarlimited":return bwipp_databarlimited;case"databarlimitedcomposite":return bwipp_databarlimitedcomposite;case"databaromni":return bwipp_databaromni;case"databaromnicomposite":return bwipp_databaromnicomposite;case"databarstacked":return bwipp_databarstacked;case"databarstackedcomposite":return bwipp_databarstackedcomposite;case"databarstackedomni":return bwipp_databarstackedomni;case"databarstackedomnicomposite":return bwipp_databarstackedomnicomposite;case"databartruncated":return bwipp_databartruncated;case"databartruncatedcomposite":return bwipp_databartruncatedcomposite;case"datalogic2of5":return bwipp_datalogic2of5;case"datamatrix":return bwipp_datamatrix;case"datamatrixrectangular":return bwipp_datamatrixrectangular;case"datamatrixrectangularextension":return bwipp_datamatrixrectangularextension;case"dotcode":return bwipp_dotcode;case"ean13":return bwipp_ean13;case"ean13composite":return bwipp_ean13composite;case"ean14":return bwipp_ean14;case"ean2":return bwipp_ean2;case"ean5":return bwipp_ean5;case"ean8":return bwipp_ean8;case"ean8composite":return bwipp_ean8composite;case"flattermarken":return bwipp_flattermarken;case"gs1_128":return bwipp_gs1_128;case"gs1_128composite":return bwipp_gs1_128composite;case"gs1_cc":return bwipp_gs1_cc;case"gs1datamatrix":return bwipp_gs1datamatrix;case"gs1datamatrixrectangular":return bwipp_gs1datamatrixrectangular;case"gs1dldatamatrix":return bwipp_gs1dldatamatrix;case"gs1dlqrcode":return bwipp_gs1dlqrcode;case"gs1dotcode":return bwipp_gs1dotcode;case"gs1northamericancoupon":return bwipp_gs1northamericancoupon;case"gs1qrcode":return bwipp_gs1qrcode;case"hanxin":return bwipp_hanxin;case"hibcazteccode":return bwipp_hibcazteccode;case"hibccodablockf":return bwipp_hibccodablockf;case"hibccode128":return bwipp_hibccode128;case"hibccode39":return bwipp_hibccode39;case"hibcdatamatrix":return bwipp_hibcdatamatrix;case"hibcdatamatrixrectangular":return bwipp_hibcdatamatrixrectangular;case"hibcmicropdf417":return bwipp_hibcmicropdf417;case"hibcpdf417":return bwipp_hibcpdf417;case"hibcqrcode":return bwipp_hibcqrcode;case"iata2of5":return bwipp_iata2of5;case"identcode":return bwipp_identcode;case"industrial2of5":return bwipp_industrial2of5;case"interleaved2of5":return bwipp_interleaved2of5;case"isbn":return bwipp_isbn;case"ismn":return bwipp_ismn;case"issn":return bwipp_issn;case"itf14":return bwipp_itf14;case"jabcode":return bwipp_jabcode;case"japanpost":return bwipp_japanpost;case"kix":return bwipp_kix;case"leitcode":return bwipp_leitcode;case"mailmark":return bwipp_mailmark;case"mands":return bwipp_mands;case"matrix2of5":return bwipp_matrix2of5;case"maxicode":return bwipp_maxicode;case"micropdf417":return bwipp_micropdf417;case"microqrcode":return bwipp_microqrcode;case"msi":return bwipp_msi;case"onecode":return bwipp_onecode;case"pdf417":return bwipp_pdf417;case"pdf417compact":return bwipp_pdf417compact;case"pharmacode":return bwipp_pharmacode;case"pharmacode2":return bwipp_pharmacode2;case"planet":return bwipp_planet;case"plessey":return bwipp_plessey;case"posicode":return bwipp_posicode;case"postnet":return bwipp_postnet;case"pzn":return bwipp_pzn;case"qrcode":return bwipp_qrcode;case"rationalizedCodabar":return bwipp_rationalizedCodabar;case"raw":return bwipp_raw;case"rectangularmicroqrcode":return bwipp_rectangularmicroqrcode;case"royalmail":return bwipp_royalmail;case"sscc18":return bwipp_sscc18;case"swissqrcode":return bwipp_swissqrcode;case"symbol":return bwipp_symbol;case"telepen":return bwipp_telepen;case"telepennumeric":return bwipp_telepennumeric;case"ultracode":return bwipp_ultracode;case"upca":return bwipp_upca;case"upcacomposite":return bwipp_upcacomposite;case"upce":return bwipp_upce;case"upcecomposite":return bwipp_upcecomposite}throw new Error("bwipp.unknownEncoder: unknown encoder name: "+symbol)}var BWIPP_VERSION="2023-04-03";
function ToCanvas(r,t){if(typeof t=="string"){t=document.getElementById(t)||document.querySelector(t)}else if(typeof r=="string"){r=document.getElementById(r)||document.querySelector(r)}if(r instanceof HTMLCanvasElement){var e=r;r=t;t=e}else if(!(t instanceof HTMLCanvasElement)){throw"bwipjs: Not a canvas"}_Render(bwipp_lookup(r.bcid),r,DrawingCanvas(r,t));return t}function _ToCanvas(r,t,e){if(typeof e=="string"){e=document.getElementById(e)||document.querySelector(e)}else if(typeof t=="string"){t=document.getElementById(t)||document.querySelector(t)}if(t instanceof HTMLCanvasElement){var i=t;t=e;e=i}else if(!(e instanceof HTMLCanvasElement)){throw"bwipjs: Not a canvas"}_Render(r,t,DrawingCanvas(t,e));return e}function FixupOptions(r){var t=r.scale||2;var e=+r.scaleX||t;var i=+r.scaleY||e;r.paddingleft=l(r.paddingleft,r.paddingwidth,r.padding,e);r.paddingright=l(r.paddingright,r.paddingwidth,r.padding,e);r.paddingtop=l(r.paddingtop,r.paddingheight,r.padding,i);r.paddingbottom=l(r.paddingbottom,r.paddingheight,r.padding,i);if(/^[0-9a-fA-F]{8}$/.test(""+r.backgroundcolor)){var n=r.backgroundcolor;var a=parseInt(n.substr(0,2),16)/255;var s=parseInt(n.substr(2,2),16)/255;var f=parseInt(n.substr(4,2),16)/255;var o=parseInt(n.substr(6,2),16)/255;var v=Math.floor((1-a)*(1-o)*255).toString(16);var u=Math.floor((1-s)*(1-o)*255).toString(16);var h=Math.floor((1-f)*(1-o)*255).toString(16);r.backgroundcolor=(v.length==1?"0":"")+v+(u.length==1?"0":"")+u+(h.length==1?"0":"")+h}return r;function l(r,t,e,i){if(r!=null){return r*i}if(t!=null){return t*i}return e*i||0}}var BWIPJS_OPTIONS={bcid:1,text:1,scale:1,scaleX:1,scaleY:1,rotate:1,padding:1,paddingwidth:1,paddingheight:1,paddingtop:1,paddingleft:1,paddingright:1,paddingbottom:1,backgroundcolor:1};function Render(r,t){return _Render(bwipp_lookup(r.bcid),r,t)}function _Render(r,t,e){var i=t.text;if(!i){throw new ReferenceError("bwip-js: bar code text not specified.")}FixupOptions(t);var n=t.scale||2;var a=+t.scaleX||n;var s=+t.scaleY||a;var f=t.rotate||"N";var o=new BWIPJS(e);var v={};for(var u in t){if(!BWIPJS_OPTIONS[u]){v[u]=t[u]}}if(v.alttext){v.includetext=true}if(+v.height&&r!=bwipp_pharmacode2){v.height=v.height/25.4||.5}if(+v.width){v.width=v.width/25.4||0}o.scale(a,s);bwipp_encode(o,r,i,v);return o.render()}function ToRaw(r,t,e){if(arguments.length==1){e=r;r=e.bcid;t=e.text}var i=new BWIPJS(DrawingBuiltin({}));var n=bwipp_encode(i,bwipp_lookup(r),t,e,true);var a={pixs:1,pixx:1,pixy:1,sbs:1,bbs:1,bhs:1,width:1,height:1};for(var s=0;s<n.length;s++){var f=n[s];if(f instanceof Map){var o={};for(var v=f.keys(),u=f.size,h=0;h<u;h++){var l=v.next().value;if(a[l]){var c=f.get(l);if(c instanceof Array){o[l]=c.b.slice(c.o,c.o+c.length)}else{o[l]=c}}}n[s]=o}else{n.splice(s--,1)}}return n}var BWIPJS=function(){var F=Math.floor;var o=Math.round;var M=Math.ceil;var E=Math.min;var C=Math.max;function t(r){if(this.constructor!==t){return new t(r)}this.gstk=[];this.cmds=[];this.drawing=r;this.reset();this.minx=this.miny=Infinity;this.maxx=this.maxy=-Infinity}t.prototype.reset=function(){this.g_tdx=0;this.g_tdy=0;this.g_tsx=1;this.g_tsy=1;this.g_posx=0;this.g_posy=0;this.g_penw=1;this.g_path=[];this.g_font=null;this.g_rgb=[0,0,0];this.g_clip=false};t.prototype.save=function(){var r={};for(var t in this){if(t.indexOf("g_")==0){r[t]=n(this[t])}}this.gstk.push(r);function n(r){if(r instanceof Array){var t=[];for(var e=0;e<r.length;e++)t[e]=n(r[e]);return t}if(r instanceof Object){var t={};for(var i in r)t[i]=n(r[i]);return t}return r}};t.prototype.restore=function(){if(!this.gstk.length){throw new Error("grestore: stack underflow")}var r=this.gstk.pop();var t=this;if(this.g_clip&&!r.g_clip){this.cmds.push(function(){t.drawing.unclip()})}for(var e in r){this[e]=r[e]}};t.prototype.currpos=function(){return{x:(this.g_posx-this.g_tdx)/this.g_tsx,y:(this.g_posy-this.g_tdy)/this.g_tsy}};t.prototype.currfont=function(){return this.g_font};t.prototype.translate=function(r,t){this.g_tdx=this.g_tsx*r;this.g_tdy=this.g_tsy*t};t.prototype.scale=function(r,t){this.g_tsx*=r;this.g_tsy*=t;var e=this.drawing.scale(this.g_tsx,this.g_tsy);if(e&&e[0]&&e[1]){this.g_tsx=e[0];this.g_tsy=e[1]}};t.prototype.setlinewidth=function(r){this.g_penw=r};t.prototype.selectfont=function(r,t){this.g_font={FontName:this.jsstring(r),FontSize:+t}};t.prototype.getfont=function(){return this.g_font.FontName};t.prototype.jsstring=function(r){if(r instanceof Uint8Array){for(var t=0,e=r.length;t<e&&r[t];t++);if(t<e){return String.fromCharCode.apply(null,r.subarray(0,t))}return String.fromCharCode.apply(null,r)}return""+r};t.prototype.setcolor=function(r){if(r instanceof Uint8Array){r=this.jsstring(r)}if(r.length==6){var t=parseInt(r.substr(0,2),16);var e=parseInt(r.substr(2,2),16);var i=parseInt(r.substr(4,2),16);this.g_rgb=[t,e,i]}else if(r.length==8){var n=parseInt(r.substr(0,2),16)/255;var a=parseInt(r.substr(2,2),16)/255;var s=parseInt(r.substr(4,2),16)/255;var f=parseInt(r.substr(6,2),16)/255;var t=o((1-n)*(1-f)*255);var e=o((1-a)*(1-f)*255);var i=o((1-s)*(1-f)*255);this.g_rgb=[t,e,i]}};t.prototype.setrgbcolor=function(r,t,e){this.g_rgb=[r,t,e]};t.prototype.getRGB=function(){var r=this.g_rgb[0].toString(16);var t=this.g_rgb[1].toString(16);var e=this.g_rgb[2].toString(16);return"00".substr(r.length)+r+"00".substr(t.length)+t+"00".substr(e.length)+e};t.prototype.newpath=function(){this.g_path=[]};t.prototype.closepath=function(){var r=this.g_path;var t=r.length;if(!t)return;var e=t-1;for(;e>=0&&r[e].op=="l";e--);e++;if(e<t-1){var i=[];var n=Infinity;var a=Infinity;var s=-Infinity;var f=-Infinity;for(var o=e;o<t;o++){var v=r[o];i.push([v.x0,v.y0]);if(n>v.x0)n=v.x0;if(s<v.x0)s=v.x0;if(a>v.y0)a=v.y0;if(f<v.y0)f=v.y0}var v=r[t-1];var u=r[e];if(v.x1!=u.x0||v.y1!=u.y0){i.push([v.x1,v.y1]);if(n>v.x1)n=v.x1;if(s<v.x1)s=v.x1;if(a>v.y1)a=v.y1;if(f<v.y1)f=v.y1}r.splice(e,t-e,{op:"p",x0:n,y0:a,x1:s,y1:f,poly:i})}else{r.push({op:"c"})}};t.prototype.moveto=function(r,t){this.g_posx=this.g_tdx+this.g_tsx*r;this.g_posy=this.g_tdy+this.g_tsy*t};t.prototype.rmoveto=function(r,t){this.g_posx+=this.g_tsx*r;this.g_posy+=this.g_tsy*t};t.prototype.lineto=function(r,t){var e=o(this.g_posx);var i=o(this.g_posy);this.g_posx=this.g_tdx+this.g_tsx*r;this.g_posy=this.g_tdy+this.g_tsy*t;var n=o(this.g_posx);var a=o(this.g_posy);this.g_path.push({op:"l",x0:e,y0:i,x1:n,y1:a})};t.prototype.rlineto=function(r,t){var e=o(this.g_posx);var i=o(this.g_posy);this.g_posx+=this.g_tsx*r;this.g_posy+=this.g_tsy*t;var n=o(this.g_posx);var a=o(this.g_posy);this.g_path.push({op:"l",x0:e,y0:i,x1:n,y1:a})};t.prototype.arc=function(r,t,e,i,n,a){if(i==n){return}if(i!=0&&i!=360||n!=0&&n!=360){throw new Error("arc: not a full circle ("+i+","+n+")")}r=this.g_tdx+this.g_tsx*r;t=this.g_tdy+this.g_tsy*t;var s=e*this.g_tsx;var f=e*this.g_tsy;this.g_path.push({op:"e",x0:r-s,y0:t-f,x1:r+s,y1:t+f,x:r,y:t,rx:s,ry:f,sa:i,ea:n,ccw:a})};t.prototype.stringwidth=function(r){var t=this.g_tsx;var e=this.g_tsy;var i=+this.g_font.FontSize||10;r=this.jsstring(r);var n=this.drawing.measure(r,this.g_font.FontName,i*t,i*e);return{w:n.width/t,h:(n.ascent+n.descent)/e,a:n.ascent/e,d:n.descent/e}};t.prototype.charpath=function(r,t){var e=this.stringwidth(r);this.rlineto(0,e.a);this.rlineto(e.w,0);this.rlineto(0,-e.h)};t.prototype.pathbbox=function(){if(!this.g_path.length)throw new Error("pathbbox: --nocurrentpoint--");var r=this.g_path;var t=Infinity;var e=Infinity;var i=-Infinity;var n=-Infinity;for(var a=0;a<r.length;a++){var s=r[a];if(s.op=="c"){continue}if(s.x0<s.x1){if(t>s.x0)t=s.x0;if(i<s.x1)i=s.x1}else{if(t>s.x1)t=s.x1;if(i<s.x0)i=s.x0}if(s.y0<s.y1){if(e>s.y0)e=s.y0;if(n<s.y1)n=s.y1}else{if(e>s.y1)e=s.y1;if(n<s.y0)n=s.y0}}var f={llx:(t-this.g_tdx)/this.g_tsx,lly:(e-this.g_tdy)/this.g_tsy,urx:(i-this.g_tdx)/this.g_tsx,ury:(n-this.g_tdy)/this.g_tsy};return f};t.prototype.transform=function(r){var t=this.minx;var e=this.maxy;for(var i=0;i<r.length;i++){var n=r[i];n[0]=n[0]-t;n[1]=e-n[1]}};t.prototype.stroke=function(){var r=this.g_tsx;var t=this.g_tsy;var h=this.g_path;var l=this.getRGB();this.g_path=[];var c=F(this.g_penw*r+.66);var p=F(this.g_penw*t+.66);var e=0,i=0;for(var n=0;n<h.length;n++){var a=h[n];if(a.op=="l"){if(a.x0!=a.x1&&a.y0!=a.y1){throw new Error("stroke: --not-orthogonal--")}var s=a.x0;var f=a.y0;var o=a.x1;var v=a.y1;var u=c/2;var y=p/2;if(s>o){var g=s;s=o;o=g}if(f>v){var g=f;f=v;v=g}if(s==o){this.bbox(s-u,f,s+c-u-1,v)}else{this.bbox(s,f-p+y+1,o,v+y)}e++}else if(a.op=="p"){var x=Infinity;var d=Infinity;var _=-Infinity;var b=-Infinity;var w=a.poly;if(w.length!=4){throw new Error("stroke: --not-a-rect--")}for(var n=0,m=w.length-1;n<w.length;m=n++){var k=w[m][0];var I=w[m][1];var S=w[n][0];var T=w[n][1];if(S!=k&&T!=I){throw new Error("stroke: --not-orthogonal--")}if(S<x)x=S;if(S>_)_=S;if(T<d)d=T;if(T>b)b=T}var u=M(c/2);var y=M(p/2);this.bbox(x-u,d-y,_+u,b+y);i++}else{throw new Error("stroke: --not-a-line--")}}var B=this;this.cmds.push(function(){var r=M(c/2);var t=M(p/2);var e=c-r;var i=p-t;for(var n=0;n<h.length;n++){var a=h[n];if(a.op=="l"){var s=[[a.x0,a.y0],[a.x1,a.y1]];B.transform(s);B.drawing.line(s[0][0],s[0][1],s[1][0],s[1][1],a.x0==a.x1?c:p,l);B.fill(l)}else{var s=a.poly;B.transform(s);var f=E(s[0][0],s[2][0]);var o=C(s[0][0],s[2][0]);var v=E(s[0][1],s[2][1]);var u=C(s[0][1],s[2][1]);B.drawing.polygon([[f-r,v-t],[f-r,u+t+1],[o+r+1,u+t+1],[o+r+1,v-t]]);B.drawing.polygon([[f+e,v+i],[f+e,u-i+1],[o-e+1,u-i+1],[o-e+1,v+i]]);B.drawing.fill(l)}}})};t.prototype.fill=function(){var i=this.g_path;var n=this.getRGB();this.g_path=[];for(var r=0;r<i.length;r++){var t=i[r];if(t.op=="p"){var e=Infinity;var a=Infinity;var s=-Infinity;var f=-Infinity;var o=t.poly;for(var v=0;v<o.length;v++){var u=o[v][0];var h=o[v][1];if(u<e)e=u;if(u>s)s=u;if(h<a)a=h;if(h>f)f=h}this.bbox(e,a+1,s-1,f)}else if(t.op=="e"){this.bbox(t.x-t.rx,t.y-t.ry,t.x+t.rx,t.y+t.ry)}else{throw new Error("fill: --not-a-polygon--")}}var l=this;this.cmds.push(function(){for(var r=0;r<i.length;r++){var t=i[r];if(t.op=="p"){var e=t.poly;l.transform(e);l.drawing.polygon(e)}else if(t.op=="e"){var e=[[t.x,t.y]];l.transform(e);l.drawing.ellipse(e[0][0],e[0][1],t.rx,t.ry,t.ccw)}}l.drawing.fill(n)})};t.prototype.clip=function(){var n=this.g_path;this.g_path=[];this.g_clip=true;var a=this;this.cmds.push(function(){var r=[];for(var t=0;t<n.length;t++){var e=n[t];if(e.op=="p"){var i=e.poly;a.transform(i);r.push(i)}else{throw new Error("clip: only polygon regions supported")}}a.drawing.clip(r)})};t.prototype.maxicode=function(a){var s=this.g_tsx;var f=this.g_tsy;var o=this.getRGB();var r=1.04*s*100;var v=r/30|0;if(r-(v*30-1)>9){v++}var t,u,e,i;e=s/2|0;i=f/2|0;t=v-e;if(t&1){t--}u=(4*f|0)-i;var h=t/2-1;var l=(h+1)/2|0;var c=u-2-2*l;this.bbox(0,0,v*30-e,f*3*32+f*4-i);var p=this;this.cmds.push(function(){for(var r=0;r<a.length;r++){var t=a[r];var e=t%30;var i=t/30|0;e*=v;e+=i&1?v:v/2;e=e|0;i=33-i;i*=f*3;i+=f*2-u/2;i=i|0;var n=[[e-.5,i--]];i-=l-1;n.push([e-1-h,i--]);i-=c;n.push([e-1-h,i--]);i-=l-1;n.push([e-.5,i++]);i+=l-1;n.push([e+h,i++]);i+=c;n.push([e+h,i++]);p.transform(n);p.drawing.hexagon(n,o)}p.drawing.fill(o);var e=14*v+v/2+.01|0;var i=(12*4+3)*f-l/2+.01|0;p.drawing.ellipse(e,i,.5774*3.5*s+.01|0,.5774*3.5*f+.01|0,true);p.drawing.ellipse(e,i,1.3359*3.5*s+.01|0,1.3359*3.5*f+.01|0,false);p.drawing.fill(o);p.drawing.ellipse(e,i,2.1058*3.5*s+.01|0,2.1058*3.5*f+.01|0,true);p.drawing.ellipse(e,i,2.8644*3.5*s+.01|0,2.8644*3.5*f+.01|0,false);p.drawing.fill(o);p.drawing.ellipse(e,i,3.6229*3.5*s+.01|0,3.6229*3.5*f+.01|0,true);p.drawing.ellipse(e,i,4.3814*3.5*s+.01|0,4.3814*3.5*f+.01|0,false);p.drawing.fill(o)})};t.prototype.show=function(e,i,r){if(!e.length){return}var t=this.g_tsx;var n=this.g_tsy;var a=this.g_font.FontName||"OCR-B";var s=this.g_font.FontSize||10;var f=s*t;var o=s*n;var v=this.g_posx;var u=this.g_posy;var h=this.getRGB();e=this.jsstring(e);i=t*i||0;r=n*r||0;var l=u+r;var c=this.drawing.measure(e,a,f,o);var p=c.width+(e.length-1)*i;this.bbox(v,l-c.descent+1,v+p-1,l+c.ascent);this.g_posx+=p;var y=this;y.cmds.push(function(){var r=v-y.minx;var t=y.maxy-u;y.drawing.text(r,t,e,h,{name:a,width:f,height:o,dx:i})})};t.prototype.bbox=function(r,t,e,i){if(r>e){var n=r;r=e;e=n}if(t>i){var n=t;t=i;i=n}r=F(r);t=F(t);e=M(e);i=M(i);if(this.minx>r)this.minx=r;if(this.maxx<e)this.maxx=e;if(this.miny>t)this.miny=t;if(this.maxy<i)this.maxy=i};t.prototype.render=function(){if(this.minx===Infinity){return new Promise(function(r,t){r(null)})}this.drawing.init(this.maxx-this.minx+1,this.maxy-this.miny+1,this.g_tsx,this.g_tsy);for(var r=0,t=this.cmds.length;r<t;r++){this.cmds[r]()}return this.drawing.end()};return t}();function DrawingBuiltin(v){var r=Math.floor;var u=0,h=0,l=0,c=0;var p=0,y=0,g=0,x=0;var d,_;var b,w;var m,k;var I,S,T;var B;var F;return{scale:function(r,t){if(v.bcid=="swissqrcode"){return[r,t]}else{return[r|0||1,t|0||1]}},measure:function(r,t,e,i){e=e|0;i=i|0;var n=FontLib.lookup(t);var a=0;var s=0;var f=0;for(var o=0,v=r.length;o<v;o++){var u=r.charCodeAt(o);var h=FontLib.getglyph(n,u,e,i);s=Math.max(s,h.top);f=Math.max(f,h.height-h.top);if(o==v-1){a+=h.left+h.width}else{a+=h.advance}}return{width:a,ascent:s,descent:f}},init:function(r,t){var e=v.paddingleft;var i=v.paddingright;var n=v.paddingtop;var a=v.paddingbottom;var s=v.rotate||"N";r+=e+i;t+=n+a;if(+v.sizelimit&&+v.sizelimit<r*t){throw new Error("Image size over limit")}switch(s){case"R":h=-1;l=1;p=1;break;case"I":u=-1;l=1;y=-1;x=1;break;case"L":h=1;p=-1;x=1;break;default:u=y=1;break}var f=s=="L"||s=="R";b=f?t:r;w=f?r:t;m=e;k=n;B=[];B.min=Infinity;F=null;I=S=T=0;var o=this.image(b,w);d=o.buffer;_=o.ispng?1:0},line:function(r,t,e,i,n,a){r=r|0;t=t|0;e=e|0;i=i|0;n=Math.round(n)||1;if(i<t){var s=t;t=i;i=s}if(e<r){var s=r;r=e;e=s}I=parseInt(a.substr(0,2),16);S=parseInt(a.substr(2,2),16);T=parseInt(a.substr(4,2),16);var f=n/2|0;if(r==e){r=r-n+f;e=e+f-1}else{t=t-f;i=i+n-f-1}for(var o=t;o<=i;o++){for(var v=r;v<=e;v++){M(v,o,255)}}},polygon:function(r){var t=r.length;for(var e=t-1,i=0;i<t;e=i++){if(r[e][0]==r[i][0]){var n=r[e][0]|0;var a=r[e][1]|0;var s=r[i][1]|0;if(a>s){for(var f=s+1;f<a;f++){E(n,f)}}else{for(var f=a+1;f<s;f++){E(n,f)}}}else{var n=r[e][0]|0;var o=r[i][0]|0;var a=r[e][1]|0;if(n<o){var v=r[e==0?t-1:e-1][1];var u=r[i==t-1?0:i+1][1];if(v>a){E(n,a)}if(u>a){E(o,a)}}else{var v=r[i==t-1?0:i+1][1];var u=r[e==0?t-1:e-1][1];if(v>a){E(o,a)}if(u>a){E(n,a)}}}}},hexagon:function(r,t){var e=r[0][0]|0;var i=r[0][1]|0;var n=r[1][1]-r[0][1]|0;var a=r[2][1]-r[1][1]-1|0;var s=r[2][0]|0;var f=r[4][0]|0;I=parseInt(t.substr(0,2),16);S=parseInt(t.substr(2,2),16);T=parseInt(t.substr(4,2),16);C(e,e+1,i++);for(var o=1;o<n;o++){C(e-2*o,e+1+2*o,i++)}for(var o=0;o<=a;o++){C(s,f,i++)}for(var o=n-1;o>=1;o--){C(e-2*o,e+1+2*o,i++)}C(e,e+1,i)},ellipse:function(r,t,e,i,n){a(r-e|0,t-i|0,r+e|0,t+i|0,n)},fill:function(r){I=parseInt(r.substr(0,2),16);S=parseInt(r.substr(2,2),16);T=parseInt(r.substr(4,2),16);t();B=[];B.min=Infinity},clip:function(r){if(!F){F=[];F.min=Infinity}var t=B;B=F;for(var e=0,i=r.length;e<i;e++){this.polygon(r[e])}B=t},unclip:function(){F=null},text:function(r,t,e,i,n){r=r|0;t=t|0;I=parseInt(i.substr(0,2),16);S=parseInt(i.substr(2,2),16);T=parseInt(i.substr(4,2),16);var a=FontLib.lookup(n.name);var s=n.width|0;var f=n.height|0;var o=n.dx|0;for(var v=0;v<e.length;v++){var u=e.charCodeAt(v);var h=FontLib.getglyph(a,u,s,f);var l=t-h.top;var c=h.left;var p=h.width;var y=h.height;var g=h.bytes;var x=h.offset;for(var d=0;d<p;d++){for(var _=0;_<y;_++){var b=g[x+_*p+d];if(b){M(r+c+d,l+_,b)}}}r+=h.advance+o}},end:function(){}};function M(r,t,e){if(F&&j(r,t)){return}r+=m;t+=k;var i=u*r+h*t+l*(b-1)+c*(w-1);var n=p*r+y*t+g*(b-1)+x*(w-1);var a=(n*b+i)*4+(n+1)*_;var s=d[a+3]/255;var f=e/255;var o=(1-f)*s;var v=f+o;d[a+0]=(I*f+d[a+0]*o)/v|0;d[a+1]=(S*f+d[a+1]*o)/v|0;d[a+2]=(T*f+d[a+2]*o)/v|0;d[a+3]=255*v|0}function E(r,t){if(B.min>t)B.min=t;if(!B[t]){B[t]=[r]}else{B[t].push(r)}}function C(r,t,e){while(r<=t){M(r++,e,255)}}function t(){var r=B.min;var t=B.length-1;for(var e=r;e<=t;e++){var i=B[e];if(!i){continue}i.sort(function(r,t){return r-t});var n=false;var a=0;for(var s=0,f=i.length;s<f;s++){var o=i[s];if(n){C(a,o-1,e)}else{a=o}n=!n}}}function a(r,t,e,i,n){r=r|0;t=t|0;e=e|0;i=i|0;var a=Math.abs(e-r);var s=Math.abs(i-t);var f=s&1;var o=4*(1-a)*s*s;var v=4*(f+1)*a*a;var u=o+v+f*a*a;var h;var l=[],c=[];l.min=c.min=Infinity;if(r>e){r=e;e+=a}if(t>i)t=i;t+=(s+1)/2|0;i=t-f;a*=8*a;f=8*s*s;do{x(c,e,t);g(l,r,t);g(l,r,i);x(c,e,i);h=2*u;if(h>=o){r++;e--;o+=f;u+=o}if(h<=v){t++;i--;v+=a;u+=v}}while(r<=e);while(t-i<s){x(c,e+1,t);g(l,r-1,t++);g(l,r-1,i);x(c,e+1,i--)}for(var p=l.min,y=l.length-1;p<=y;p++){E(l[p],p)}for(var p=c.min,y=c.length-1;p<=y;p++){E(c[p]+1,p)}function g(r,t,e){if(r.min>e)r.min=e;var i=r[e];if(i==null||i>t){r[e]=t}}function x(r,t,e){if(r.min>e)r.min=e;var i=r[e];if(i==null||i<t){r[e]=t}}}function j(r,t){var e=F[t];if(!e){return true}if(!e.sorted){e.sort(function(r,t){return r-t});e.sorted=true}var i=false;for(var n=0,a=e.length;n<a;n++){var s=e[n];if(s>r){return!i}else if(s==r){return i}i=!i}return true}function e(r){var t=0;for(var e=0,i=r.length,n=i-1;e<i;n=e++){t+=r[n][0]*r[e][1]-r[e][0]*r[n][1]}return t>0?1:-1}}function DrawingCanvas(e,i){if(typeof window==null){throw new Error("DrawingCanvas: not a browser")}var n;var a=i.getContext("2d",{willReadFrequently:true});var r=DrawingBuiltin(e);r.image=t;r.end=s;return r;function t(r,t){i.width=r;i.height=t;a.setTransform(1,0,0,1,0,0);if(/^[0-9a-fA-F]{6}$/.test(""+e.backgroundcolor)){a.fillStyle="#"+e.backgroundcolor;a.fillRect(0,0,r,t)}else{a.clearRect(0,0,r,t)}n=a.getImageData(0,0,r,t);return{buffer:n.data,ispng:false}}function s(){a.putImageData(n,0,0)}}var FontLib=function(){var v=[];var s={};var u={};var h={};var l=0;h.next=h;h.prev=h;return{lookup:t,monochrome:e,getglyph:i,getpaths:n,loadFont:r};function r(r){var t=100;var e=100;var i=null;if(arguments.length==2){i=arguments[1]}else if(arguments.length==3){t=e=+arguments[1]||100;i=arguments[2]}else if(arguments.length==4){e=+arguments[1]||100;t=+arguments[2]||100;i=arguments[3]}else{throw new Error("loadFont(): invalid number of arguments")}var n=STBTT.InitFont(toUint8Array(i));n.bwipjs_name=r;n.bwipjs_multx=t;n.bwipjs_multy=e;var a=v.push(n)-1;s[r.toUpperCase()]=a;return a}function t(r){var t=s[r.toUpperCase()];return t===undefined?1:t}function e(r){if(r){throw new Error("fontlib: monochrome not implemented")}}function i(r,t,e,i){r=r|0;t=t|0;e=+e;i=+i;if(!e||e<8){e=8}if(!i||i<8){i=e}if(r<0||r>=v.length){r=1}if(!t||t<32){t=32}var n=""+r+"c"+t+"w"+e+"h"+i;var a=u[n];if(a){a.prev.next=a.next;a.next.prev=a.prev;var s=h;s.next.prev=a;a.next=s.next;a.prev=s;s.next=a;return a}var f=v[r];var a=STBTT.GetGlyph(f,t,e*f.bwipjs_multx/100,i*f.bwipjs_multy/100)||STBTT.GetGlyph(f,0,e*f.bwipjs_multx/100,i*f.bwipjs_multy/100);a.bytes=a.pixels;a.cachekey=n;a.offset=0;if(l>250){var s=h;var o=s.prev;o.prev.next=s;s.prev=o.prev;o.next=o.prev=null;delete u[o.cachekey]}else{l++}u[n]=a;var s=h;s.next.prev=a;a.next=s.next;a.prev=s;s.next=a;return a}function n(r,t,e,i){r=r|0;t=t|0;e=+e;i=+i;if(!e||e<8){e=8}if(!i||i<8){i=e}if(r<0||r>=v.length){r=1}if(!t||t<32){t=32}var n=v[r];return STBTT.GetPaths(n,t,e*n.bwipjs_multx/100,i*n.bwipjs_multy/100)}}();var STBTT=function(){var P=1,D=2,O=3,g=4,x=0,r=1,t=2,d=3,e=0,i=1,n=2,a=3,s=4,f=0,_=1,o=2,b=10;var W=Math.floor;var v=Math.ceil;var q=Math.sqrt;var j=Math.abs;function z(r){var t=[];for(var e=0;e<r;e++){t.push({})}return t}function U(r){return r[r.cursor++]||0}function u(r){return r[r.cursor]}function w(r,t){r.cursor=t>r.length||t<0?r.length:t}function R(r,t){w(r,r.cursor+t)}function G(r,t){var e=0;for(var i=0;i<t;i++){e=e<<8|U(r)}return e}function m(){return{length:0}}function k(r,t,e){if(t<0||e<0||t>r.length||e>r.length-t){return m()}var i=r.subarray(t,t+e);i.cursor=0;return i}function I(r){var t=r.cursor;var e=G(r,2);if(e){var i=U(r);R(r,i*e);R(r,G(r,i)-1)}return k(r,t,r.cursor-t)}function L(r){var t=U(r);if(t>=32&&t<=246){return t-139}else if(t>=247&&t<=250){return(t-247)*256+U(r)+108}else if(t>=251&&t<=254){return-(t-251)*256-U(r)-108}else if(t==28){return G(r,2)}else if(t==29){return G(r,4)}return 0}function h(r){var t=u(r);if(t==30){R(r,1);while(r.cursor<r.length){var e=U(r);if((e&15)==15||e>>4==15){break}}}else{L(r)}}function l(r,t){w(r,0);while(r.cursor<r.length){var e=r.cursor,i,n;while(u(r)>=28){h(r)}i=r.cursor;n=U(r);if(n==12){n=U(r)|256}if(n==t){return k(r,e,i-e)}}return k(r,0,0)}function c(r,t,e,i){var n=l(r,t);for(var a=0;a<e&&n.cursor<n.length;a++){i[a]=L(n)}}function S(r,t,e){var i=l(r,t);if(i.cursor<i.length){e=L(i)}return e}function p(r){w(r,0);return G(r,2)}function A(r,t){var e,i,n,a;w(r,0);e=G(r,2);i=U(r);R(r,t*i);n=G(r,i);a=G(r,i);return k(r,2+(e+1)*i+n,a-n)}function J(r){return r&32768?(4294901760|r)>>0:r}function H(r,t){return r[t]*256+r[t+1]}function X(r,t){var e=r[t]*256+r[t+1];return e&32768?(4294901760|e)>>0:e}function T(r,t){return(r[t]<<24)+(r[t+1]<<16)+(r[t+2]<<8)+r[t+3]}function B(r,t,e){var i=H(r,t+4);var n=t+12;for(var a=0;a<i;++a){var s=n+16*a;if(r[s]==e[0]&&r[s+1]==e[1]&&r[s+2]==e[2]&&r[s+3]==e[3]){return T(r,s+8)}}return 0}function F(r,t){var e=[0,0];c(t,18,2,e);if(!e[1]||!e[0]){return m()}var i=k(r,e[1],e[0]);var n=S(i,19,0);if(!n){return m()}w(r,e[1]+n);return I(r)}function y(r,t,e){var i,n,a,s;r.data=t;r.fontstart=e;r.cff=m();i=B(t,e,[99,109,97,112]);r.loca=B(t,e,[108,111,99,97]);r.head=B(t,e,[104,101,97,100]);r.glyf=B(t,e,[103,108,121,102]);r.hhea=B(t,e,[104,104,101,97]);r.hmtx=B(t,e,[104,109,116,120]);r.kern=B(t,e,[107,101,114,110]);if(!i||!r.head||!r.hhea||!r.hmtx){return 0}if(r.glyf){if(!r.loca){return 0}}else{var f,o,v,u,h=2,l=0,c=0,p=0;u=B(t,e,[67,70,70,32]);if(!u){return 0}r.fontdicts=m();r.fdselect=m();r.cff=t.subarray(u);r.cff.cursor=0;f=r.cff;R(f,2);w(f,U(f));I(f);v=I(f);o=A(v,0);I(f);r.gsubrs=I(f);l=S(o,17,l);h=S(o,256|6,h);c=S(o,256|36,c);p=S(o,256|37,p);r.subrs=F(f,o);if(h!=2){return 0}if(l==0){return 0}if(c){if(!p){return 0}w(f,c);r.fontdicts=I(f);r.fdselect=k(f,p,f.length-p)}w(f,l);r.charstrings=I(f)}n=B(t,e,[109,97,120,112]);if(n){r.numGlyphs=H(t,n+4)}else{r.numGlyphs=65535}s=H(t,i+2);r.index_map=0;for(a=0;a<s;++a){var y=i+4+8*a;switch(H(t,y)){case d:switch(H(t,y+2)){case _:case b:r.index_map=i+T(t,y+4);break}break;case x:r.index_map=i+T(t,y+4);break}}if(r.index_map==0){return 0}r.indexToLocFormat=H(t,r.head+50);return 1}function M(r,t){var e=r.data,i=r.index_map;var n=H(e,i+0);if(n==0){var a=H(e,i+2);if(t<a-6){return e[i+6+t]}return 0}else if(n==6){var s=H(e,i+6),f=H(e,i+8);if(t>=s&&t<s+f){return H(e,i+10+(t-s)*2)}return 0}else if(n==2){return 0}else if(n==4){var o=H(e,i+6)>>1,v=H(e,i+8)>>1,u=H(e,i+10),h=H(e,i+12)>>1,l=i+14,c=l;if(t>65535){return 0}if(t>=H(e,c+h*2)){c+=h*2}c-=2;while(u){v>>=1;var p=H(e,c+v*2);if(t>p){c+=v*2}--u}c+=2;var y,g,x=c-l>>>1;g=H(e,i+14+o*2+2+2*x);if(t<g){return 0}y=H(e,i+14+o*6+2+2*x);if(y==0){return t+X(e,i+14+o*4+2+2*x)}return H(e,y+(t-g)*2+i+14+o*6+2+2*x)}else if(n==12||n==13){var d=T(e,i+12),_=0,b=d;while(_<b){var w=_+(b-_>>1);var m=T(e,i+16+w*12);var k=T(e,i+16+w*12+4);if(t<m){b=w}else if(t>k){_=w+1}else{var I=T(e,i+16+w*12+8);if(n==12){return I+t-m}else{return I}}}return 0}return 0}function Y(r,t,e,i,n,a){r.type=t;r.x=e;r.y=i;r.cx=n;r.cy=a}function $(r,t){var e,i;if(t>=r.numGlyphs){return-1}if(r.indexToLocFormat>=2){return-1}if(r.indexToLocFormat==0){e=r.glyf+H(r.data,r.loca+t*2)*2;i=r.glyf+H(r.data,r.loca+t*2+2)*2}else{e=r.glyf+T(r.data,r.loca+t*4);i=r.glyf+T(r.data,r.loca+t*4+4)}return e==i?-1:e}function E(r,t,e){if(r.cff.length){fr(r,t,e)}else{var i=$(r,t);if(i<0){return 0}e.x0=X(r.data,i+2);e.y0=X(r.data,i+4);e.x1=X(r.data,i+6);e.y1=X(r.data,i+8)}return 1}function Q(r,t,e,i,n,a,s,f,o,v){if(i){if(e){Y(r[t++],O,o+s>>1,v+f>>1,o,v)}Y(r[t++],O,n,a,s,f)}else{if(e){Y(r[t++],O,n,a,o,v)}else{Y(r[t++],D,n,a,0,0)}}return t}function C(r,t){var e=r.data,i=$(r,t);if(i<0){return null}var n=[];var a=X(e,i);if(a>0){var s=0,f,o,v=0,u,h,l,c=0,p,y=0,g,x,d,_,b,w,m,k;var I=i+10;var S=H(e,i+10+a*2);var T=e.subarray(i+10+a*2+2+S);var B=0;h=1+H(e,I+a*2-2);u=h+2*a;n=z(u);l=0;f=0;p=u-h;for(o=0;o<h;++o){if(f==0){s=T[B++];if(s&8){f=T[B++]}}else{--f}n[p+o].type=s}g=0;for(o=0;o<h;++o){s=n[p+o].type;if(s&2){var F=T[B++];g+=s&16?F:-F}else{if(!(s&16)){g=g+J(T[B]*256+T[B+1]);B+=2}}n[p+o].x=g}x=0;for(o=0;o<h;++o){s=n[p+o].type;if(s&4){var M=T[B++];x+=s&32?M:-M}else{if(!(s&32)){x=x+J(T[B]*256+T[B+1]);B+=2}}n[p+o].y=x}var E=0;b=w=d=_=m=k=0;for(o=0;o<h;++o){s=n[p+o].type;g=n[p+o].x;x=n[p+o].y;if(l==o){if(o!=0){E=Q(n,E,c,y,b,w,m,k,d,_)}y=!(s&1);if(y){m=g;k=x;if(!(n[p+o+1].type&1)){b=g+n[p+o+1].x>>1;w=x+n[p+o+1].y>>1}else{b=n[p+o+1].x;w=n[p+o+1].y;++o}}else{b=g;w=x}Y(n[E++],P,b,w,0,0);c=0;l=1+H(e,I+v*2);++v}else{if(!(s&1)){if(c){Y(n[E++],O,d+g>>1,_+x>>1,d,_)}d=g;_=x;c=1}else{if(c){Y(n[E++],O,g,x,d,_)}else{Y(n[E++],D,g,x,0,0)}c=0}}}n.length=Q(n,E,c,y,b,w,m,k,d,_)}else if(a==-1){var C=1;var j=i+10;while(C){var s,R,G=[1,0,0,1,0,0];s=X(e,j);j+=2;R=X(e,j);j+=2;if(s&2){if(s&1){G[4]=X(e,j);j+=2;G[5]=X(e,j);j+=2}else{G[4]=U(e,j);j+=1;G[5]=U(e,j);j+=1}}if(s&1<<3){G[0]=G[3]=X(e,j)/16384;j+=2;G[1]=G[2]=0}else if(s&1<<6){G[0]=X(e,j)/16384;j+=2;G[1]=G[2]=0;G[3]=X(e,j)/16384;j+=2}else if(s&1<<7){G[0]=X(e,j)/16384;j+=2;G[1]=X(e,j)/16384;j+=2;G[2]=X(e,j)/16384;j+=2;G[3]=X(e,j)/16384;j+=2}var u=q(G[0]*G[0]+G[1]*G[1]);var h=q(G[2]*G[2]+G[3]*G[3]);var L=or(r,R);if(L.length>0){for(var o=0,A=L.length;o<A;++o){var N=L[o],g,x;g=N.x;x=N.y;N.x=W(u*(G[0]*g+G[2]*x+G[4]));N.y=W(h*(G[1]*g+G[3]*x+G[5]));g=N.cx;x=N.cy;N.cx=W(u*(G[0]*g+G[2]*x+G[4]));N.cy=W(h*(G[1]*g+G[3]*x+G[5]))}n=n.concat(L)}C=s&1<<5}}return n}function N(r,t,e){if(t>r.max_x||!r.started){r.max_x=t}if(e>r.max_y||!r.started){r.max_y=e}if(t<r.min_x||!r.started){r.min_x=t}if(e<r.min_y||!r.started){r.min_y=e}r.started=1}function K(r,t,e,i,n,a,s,f){N(r,e,i);if(t==g){N(r,n,a);N(r,s,f)}var o={};Y(o,t,e,i,n,a);o.cx1=s;o.cy1=f;r.vertices.push(o)}function V(r){if(r.first_x!=r.x||r.first_y!=r.y){K(r,D,r.first_x,r.first_y,0,0,0,0)}}function Z(r,t,e){V(r);r.first_x=r.x=r.x+t;r.first_y=r.y=r.y+e;K(r,P,r.x,r.y,0,0,0,0)}function rr(r,t,e){r.x+=t;r.y+=e;K(r,D,r.x,r.y,0,0,0,0)}function tr(r,t,e,i,n,a,s){var f=r.x+t,o=r.y+e,v=f+i,u=o+n;r.x=v+a;r.y=u+s;K(r,g,r.x,r.y,f,o,v,u)}function er(r,t){var e=p(r);var i=107;if(e>=33900){i=32768}else if(e>=1240){i=1131}t+=i;if(t<0||t>=e){return m()}return A(r,t)}function ir(r,t){var e=r.fdselect;var i,n,a,s,f,o=-1,v;w(e,0);f=U(e);if(f==0){R(e,t);o=U(e)}else if(f==3){i=G(e,2);n=G(e,2);for(v=0;v<i;v++){s=U(e);a=G(e,2);if(t>=n&&t<a){o=s;break}n=a}}if(o==-1){m()}return F(r.cff,A(r.fontdicts,o))}function nr(r,t,e){var i=1,n=0,a=0,s=0,f,o,v,u=0,h,l=[],c=[],p=r.subrs,y,g;y=A(r.charstrings,t);while(y.cursor<y.length){o=0;h=1;v=U(y);switch(v){case 19:case 20:if(i){n+=s/2|0}i=0;R(y,(n+7)/8|0);break;case 1:case 3:case 18:case 23:n+=s/2|0;break;case 21:i=0;if(s<2){return 0}Z(e,l[s-2],l[s-1]);break;case 4:i=0;if(s<1){return 0}Z(e,0,l[s-1]);break;case 22:i=0;if(s<1){return 0}Z(e,l[s-1],0);break;case 5:if(s<2){return 0}for(;o+1<s;o+=2){rr(e,l[o],l[o+1])}break;case 7:if(s<1){return 0}for(;;){if(o>=s){break}rr(e,0,l[o]);o++;if(o>=s){break}rr(e,l[o],0);o++}break;case 6:if(s<1){return 0}for(;;){if(o>=s){break}rr(e,l[o],0);o++;if(o>=s){break}rr(e,0,l[o]);o++}break;case 31:if(s<4){return 0}for(;;){if(o+3>=s){break}tr(e,l[o],0,l[o+1],l[o+2],s-o==5?l[o+4]:0,l[o+3]);o+=4;if(o+3>=s){break}tr(e,0,l[o],l[o+1],l[o+2],l[o+3],s-o==5?l[o+4]:0);o+=4}break;case 30:if(s<4){return 0}for(;;){if(o+3>=s){break}tr(e,0,l[o],l[o+1],l[o+2],l[o+3],s-o==5?l[o+4]:0);o+=4;if(o+3>=s){break}tr(e,l[o],0,l[o+1],l[o+2],s-o==5?l[o+4]:0,l[o+3]);o+=4}break;case 8:if(s<6){return 0}for(;o+5<s;o+=6){tr(e,l[o],l[o+1],l[o+2],l[o+3],l[o+4],l[o+5])}break;case 24:if(s<8){return 0}for(;o+5<s-2;o+=6){tr(e,l[o],l[o+1],l[o+2],l[o+3],l[o+4],l[o+5])}if(o+1>=s){return 0}rr(e,l[o],l[o+1]);break;case 25:if(s<8){return 0}for(;o+1<s-6;o+=2){rr(e,l[o],l[o+1])}if(o+5>=s){return 0}tr(e,l[o],l[o+1],l[o+2],l[o+3],l[o+4],l[o+5]);break;case 26:case 27:if(s<4){return 0}g=0;if(s&1){g=l[o];o++}for(;o+3<s;o+=4){if(v==27){tr(e,l[o],g,l[o+1],l[o+2],l[o+3],0)}else{tr(e,g,l[o],l[o+1],l[o+2],0,l[o+3])}g=0}break;case 10:if(!u){if(r.fdselect.length){p=ir(r,t)}u=1}case 29:if(s<1){return 0}f=l[--s]|0;if(a>=10){return 0}c[a++]=y;y=er(v==10?p:r.gsubrs,f);if(y.length==0){return 0}y.cursor=0;h=0;break;case 11:if(a<=0){return 0}y=c[--a];h=0;break;case 14:V(e);return 1;case 12:var x,d,_,b,w,m,k,I,S,T,B,F,M,E,C=U(y);switch(C){case 34:if(s<7){return 0}x=l[0];d=l[1];I=l[2];_=l[3];b=l[4];w=l[5];m=l[6];tr(e,x,0,d,I,_,0);tr(e,b,0,w,-I,m,0);break;case 35:if(s<13){return 0}x=l[0];k=l[1];d=l[2];I=l[3];_=l[4];S=l[5];b=l[6];T=l[7];w=l[8];B=l[9];m=l[10];F=l[11];tr(e,x,k,d,I,_,S);tr(e,b,T,w,B,m,F);break;case 36:if(s<9){return 0}x=l[0];k=l[1];d=l[2];I=l[3];_=l[4];b=l[5];w=l[6];B=l[7];m=l[8];tr(e,x,k,d,I,_,0);tr(e,b,0,w,B,m,-(k+I+B));break;case 37:if(s<11){return 0}x=l[0];k=l[1];d=l[2];I=l[3];_=l[4];S=l[5];b=l[6];T=l[7];w=l[8];B=l[9];m=F=l[10];M=x+d+_+b+w;E=k+I+S+T+B;if(j(M)>j(E)){F=-E}else{m=-M}tr(e,x,k,d,I,_,S);tr(e,b,T,w,B,m,F);break;default:return 0}break;default:if(v!=255&&v!=28&&(v<32||v>254)){return 0}if(v==255){g=(G(y,4)|0)/65536}else{R(y,-1);g=(L(y)<<16|0)>>16}if(s>=48){return 0}l[s++]=g;h=0;break}if(h){s=0}}return 0}function ar(){return{started:0,first_x:0,first_y:0,x:0,y:0,min_x:0,max_x:0,min_y:0,max_y:0,vertices:[]}}function sr(r,t){var e=ar();if(nr(r,t,e)){return e.vertices}return null}function fr(r,t,e){var i=ar();var n=nr(r,t,i);e.x0=n?i.min_x:0;e.y0=n?i.min_y:0;e.x1=n?i.max_x:0;e.y1=n?i.max_y:0;return n&&i.vertices?i.vertices.length:0}function or(r,t){if(!r.cff.length){return C(r,t)}else{return sr(r,t)}}function vr(r,t){var e=H(r.data,r.hhea+34);if(t<e){return{advanceWidth:X(r.data,r.hmtx+4*t),leftSideBearing:X(r.data,r.hmtx+4*t+2)}}else{return{advanceWidth:X(r.data,r.hmtx+4*(e-1)),leftSideBearing:X(r.data,r.hmtx+4*e+2*(t-e))}}}function ur(r,t){return vr(r,M(r,t))}function hr(r){return{ascent:X(r.data,r.hhea+4),descent:X(r.data,r.hhea+6),linegap:X(r.data,r.hhea+8)}}function lr(r,t,e,i,n,a){var s={};if(!E(r,t,s)){return{x0:0,y0:0,x1:0,y1:0}}return{x0:W(s.x0*e+n),y0:W(-s.y1*i+a),x1:v(s.x1*e+n),y1:v(-s.y0*i+a)}}function cr(r,t,e,i,n,a){return lr(r,M(r,t),e,i,n,a)}function pr(r,t,e,i){return cr(r,t,e,i,0,0)}function yr(r,t,e){var i=(r.x1-r.x0)/(r.y1-r.y0);return{fdx:i,fdy:i!=0?1/i:0,fx:r.x0+i*(e-r.y0)-(t|0),direction:r.invert?1:-1,sy:r.y0,ey:r.y1,next:0}}function gr(r,t,e,i,n,a,s){t=t|0;if(n==s){return}if(n>e.ey){return}if(s<e.sy){return}if(n<e.sy){i+=(a-i)*(e.sy-n)/(s-n);n=e.sy}if(s>e.ey){a+=(a-i)*(e.ey-s)/(s-n);s=e.ey}if(i<=t&&a<=t){r[t]+=e.direction*(s-n)}else if(i>=t+1&&a>=t+1){}else{r[t]+=e.direction*(s-n)*(1-(i-t+(a-t))/2)}}function xr(r,t,e,i,n){var a=n+1;while(i){if(i.fdx==0){var s=i.fx;if(s<e){if(s>=0){gr(r,s,i,s,n,s,a);gr(t,s+1,i,s,n,s,a)}else{gr(t,0,i,s,n,s,a)}}}else{var s=i.fx,f=i.fdx,o=s+f,v,u,h,l,c=i.fdy;if(i.sy>n){v=s+f*(i.sy-n);h=i.sy}else{v=s;h=n}if(i.ey<a){u=s+f*(i.ey-n);l=i.ey}else{u=o;l=a}if(v>=0&&u>=0&&v<e&&u<e){if((v|0)==(u|0)){var p=l-h,y=v|0;r[y]+=i.direction*(1-(v-y+(u-y))/2)*p;t[y+1]+=i.direction*p}else{var g,y,x,d,_,b,w,m;if(v>u){h=a-(h-n);l=a-(l-n);g=h,h=l,l=g;g=u,u=v,v=g;f=-f;c=-c;g=s,s=o,o=g}x=v|0;d=u|0;_=(x+1-s)*c+n;w=i.direction;m=w*(_-h);r[x]+=m*(1-(v-x+(x+1-x))/2);b=w*c;for(y=x+1;y<d;++y){r[y]+=m+b/2;m+=b}_+=c*(d-(x+1));r[d]+=m+w*(1-(d-d+(u-d))/2)*(l-_);t[d+1]+=w*(l-h)}}else{for(var y=0;y<e;++y){var k=n,x=y,d=y+1,I=o,S=a,T=(y-s)/f+n,B=(y+1-s)/f+n;if(s<x&&I>d){gr(r,y,i,s,k,x,T);gr(r,y,i,x,T,d,B);gr(r,y,i,d,B,I,S)}else if(I<x&&s>d){gr(r,y,i,s,k,d,B);gr(r,y,i,d,B,x,T);gr(r,y,i,x,T,I,S)}else if(s<x&&I>x){gr(r,y,i,s,k,x,T);gr(r,y,i,x,T,I,S)}else if(I<x&&s>x){gr(r,y,i,s,k,x,T);gr(r,y,i,x,T,I,S)}else if(s<d&&I>d){gr(r,y,i,s,k,d,B);gr(r,y,i,d,B,I,S)}else if(I<d&&s>d){gr(r,y,i,s,k,d,B);gr(r,y,i,d,B,I,S)}else{gr(r,y,i,s,k,I,S)}}}}i=i.next}}function dr(r,t,e,i,n,a){i|=0,n|=0,a|=0;var s=null,f;var o=a,v=0,u;var h=new Float32Array(r.w*2+1);var l=h.subarray(r.w);var c=0;t[e].y0=a+r.h+1;while(v<r.h){var p=o+0,y=o+1,g=s;if(h.fill){h.fill(0)}else{for(var x=0,d=h.length;x<d;x++)h[x]=0}while(g){f=g;g=f.next;if(f.ey<=p){f.direction=0}else{}}while(t[c].y0<=y){if(t[c].y0!=t[c].y1){f=yr(t[c],n,p);f.next=s;s=f}++c}if(s){xr(h,l,r.w,s,p)}for(var u=0,_=0;u<r.w;++u){var b,w;_+=l[u];b=h[u]+_;b=j(b)*255+.5;w=b>>>0;if(w>255){w=255}r.pixels[v*r.stride+u]=w}g=s;while(g){f=g;f.fx+=f.fdx;g=f.next}++o;++v}}function _r(r,t){for(var e=1;e<t;++e){var i=r[e],n=e;while(n>0&&i.y0<r[n-1].y0){r[n]=r[n-1];--n}if(e!=n){r[n]=i}}}function br(r,t,e){while(e>12){var i,n,a,s,f,o=e>>1,v=r[t].y0<r[t+o].y0,u=r[t+o].y0<r[t+e-1].y0;if(v!=u){n=r[t].y0<r[t+e-11].y0;f=n==u?0:e-1;i=r[t+f];r[t+f]=r[t+o];r[t+o]=i}i=r[t];r[t]=r[t+o];r[t+o]=i;a=1;s=e-1;for(;;){for(;r[t+a].y0<r[t].y0;++a){}for(;r[t].y0<r[t+s].y0;--s){}if(a>=s){break}i=r[t+a];r[t+a]=r[t+s];r[t+s]=i;++a;--s}if(s<e-a){br(r,t,s);t+=a;e-=a}else{br(r,t+a,e-a);e=s}}}function wr(r,t){br(r,0,t);_r(r,t)}function mr(r,t,e,i,n,a,s,f,o,v){var u=v?-n:n,h,l,c,p,y,g,x=1;l=0;for(c=0;c<e.length;++c){l+=e[c]}h=z(l+1);l=0;g=0;for(c=0;c<e.length;++c){var d=g;g+=e[c];p=e[c]-1;for(y=0;y<e[c];p=y++){var _=y,b=p;if(t[d+p].y==t[d+y].y){continue}h[l].invert=0;if(v?t[d+p].y>t[d+y].y:t[d+p].y<t[d+y].y){h[l].invert=1;_=p,b=y}h[l].x0=t[d+_].x*i+a;h[l].y0=(t[d+_].y*u+s)*x;h[l].x1=t[d+b].x*i+a;h[l].y1=(t[d+b].y*u+s)*x;++l}}wr(h,l);dr(r,h,l,x,f,o)}function kr(r,t,e,i,n,a,s,f,o){var v=(t+2*i+a)/4,u=(e+2*n+s)/4,h=(t+a)/2-v,l=(e+s)/2-u;if(o>16){return 1}if(h*h+l*l>f){kr(r,t,e,(t+i)/2,(e+n)/2,v,u,f,o+1);kr(r,v,u,(i+a)/2,(n+s)/2,a,s,f,o+1)}else{r.push({x:a,y:s})}return 1}function Ir(r,t,e,i,n,a,s,f,o,v,u){var h=i-t,l=n-e,c=a-i,p=s-n,y=f-a,g=o-s,x=f-t,d=o-e,_=q(h*h+l*l)+q(c*c+p*p)+q(y*y+g*g),b=q(x*x+d*d),w=_*_-b*b;if(u>16){return}if(w>v){var m=(t+i)/2,k=(e+n)/2,I=(i+a)/2,S=(n+s)/2,T=(a+f)/2,B=(s+o)/2,F=(m+I)/2,M=(k+S)/2,E=(I+T)/2,C=(S+B)/2,j=(F+E)/2,R=(M+C)/2;Ir(r,t,e,m,k,F,M,j,R,v,u+1);Ir(r,j,R,E,C,T,B,f,o,v,u+1)}else{r.push({x:f,y:o})}}function Sr(r,t,e){var i=[],n=t*t,a=-1,s=0,f=0,o=0;for(var v=0,u=r.length;v<u;++v){switch(r[v].type){case P:if(a>=0){e[a]=i.length-s}++a;s=i.length;f=r[v].x,o=r[v].y;i.push({x:f,y:o});break;case D:f=r[v].x,o=r[v].y;i.push({x:f,y:o});break;case O:kr(i,f,o,r[v].cx,r[v].cy,r[v].x,r[v].y,n,0);f=r[v].x,o=r[v].y;break;case g:Ir(i,f,o,r[v].cx,r[v].cy,r[v].cx1,r[v].cy1,r[v].x,r[v].y,n,0);f=r[v].x,o=r[v].y;break}}e[a]=i.length-s;return i}function Tr(r,t,e,i,n,a,s,f,o,v){f|=0,o|=0;var u=i>n?n:i,h=[],l=Sr(e,t/u,h);if(l){mr(r,l,h,i,n,a,s,f,o,v)}}function Br(r,t,e,i,n,a,s,f,o,v){var u=or(r,v);var h={};var l=lr(r,v,a,s,f,o);h.pixels=t;h.w=e|0;h.h=i|0;h.stride=n|0;if(h.w&&h.h){Tr(h,.35,u,a,s,f,o,l.x0,l.y0,1)}}function Fr(r,t,e,i,n,a,s,f,o,v){Br(r,t,e,i,n,a,s,f,o,M(r,v))}function Mr(r,t,e){return y(r,t,e)}function Er(r){var t={};if(!y(t,r,0)){return null}var e=hr(t);t.ascent=e.ascent;t.descent=e.descent;t.linegap=e.linegap;return t}function Cr(r,t,e,i){i=i||e;var n=e/r.ascent;var a=i/r.ascent;var s=M(r,t);if(!s&&t){return null}var f=or(r,s);var o=lr(r,s,n,a,0,0);var v=o.x1-o.x0;var u=o.y1-o.y0;var h=null;if(v&&u){var l={pixels:h=new Uint8Array(v*u),w:v,h:u,stride:v};Tr(l,.35,f,n,a,0,0,o.x0,o.y0,1)}var c=vr(r,s);return{glyph:s,pixels:h,width:v,height:u,top:-o.y0,left:o.x0,advance:W(c.advanceWidth*n)}}function jr(r,t,e,i){i=i||e;var n=e/r.ascent;var a=i/r.ascent;var s=M(r,t);if(!s&&t){return null}var f=or(r,s);var o=vr(r,s);var v=0;var u=0;var h=[];if(f){for(var l=0,c=f.length;l<c;l++){var p=f[l];var y;if(p.type==P){y={type:"M",x:p.x*n,y:p.y*a}}else if(p.type==D){y={type:"L",x:p.x*n,y:p.y*a}}else if(p.type==O){y={type:"Q",x:p.x*n,y:p.y*a,cx:p.cx*n,cy:p.cy*a}}else if(p.type==g){y={type:"C",x:p.x*n,y:p.y*a,cx1:p.cx*n,cy1:p.cy*a,cx2:p.cx1*n,cy2:p.cy1*a}}else{continue}if(y.y>v)v=y.y;if(y.y<u)u=y.y;h.push(y)}}h.advance=o.advanceWidth*n;h.ascent=v;h.descent=u;return h}return{InitFont:Er,GetGlyph:Cr,GetPaths:jr}}();
function toUint8Array(data) {
    if (typeof data == "string") {
        var binary = /[^A-Za-z0-9+\/=\s]/.test(data);
        var bstr = binary ? data : atob(data),
            len = bstr.length,
            bytes = new Uint8Array(len);
        for (var i = 0; i < len; i++) {
            bytes[i] = bstr.charCodeAt(i);
        }
        return bytes;
    } else if (data instanceof Uint8Array) {
        return data;
    } else if (data instanceof ArrayBuffer) {
        return new Uint8Array(data);
    }
    throw new ReferenceError("data must be a binary or base64 encoded string or Uint8Array");
}

FontLib.loadFont("OCR-A", 100, 100, "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");
FontLib.loadFont("OCR-B", 96, 100, "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");
    return {
        // The public interface
        toCanvas:ToCanvas, render:Render, raw:ToRaw,
        fixupOptions:FixupOptions,
        loadFont:FontLib.loadFont,
        BWIPJS_VERSION:'3.4.0 (2023-04-06)',
        BWIPP_VERSION:BWIPP_VERSION,
        // Internals
        BWIPJS:BWIPJS, STBTT:STBTT, FontLib:FontLib,
        DrawingBuiltin:DrawingBuiltin, DrawingCanvas:DrawingCanvas,
    };
}));
